/*   VLC-REMOTE for MAEMO 5
*   Copyright (C) 2010 Schutz Sacha <istdasklar@gmail.com>, Dru Moore <usr@dru-id.co.uk>, Yann Nave <yannux@onbebop.net>
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License version 2,
*   or (at your option) any later version, as published by the Free
*   Software Foundation
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details
*
*   You should have received a copy of the GNU General Public
*   License along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/
#include "settingsdialog.h"
#include "ui_settingsdialog.h"
#include "appsettings.h"



SettingsDialog::SettingsDialog(QWidget *parent) :
        QDialog(parent),
        ui(new Ui::SettingsDialog)
{
    ui->setupUi(this);
    ui->scrollArea->setWidget(ui->scrollAreaWidgetContents);
    connect(ui->radioButtonAutoRotate, SIGNAL(released()), this, SLOT(setOrientationAutoRotate()));
    connect(ui->radioButtonLandscape, SIGNAL(released()), this, SLOT(setOrientationLandscape()));
    connect(ui->radioButtonPortrait, SIGNAL(released()), this, SLOT(setOrientationPortrait()));
    connect(ui->checkBoxAlertOnClose, SIGNAL(toggled(bool)), this, SLOT(setAlertOnClose(bool)));
    connect(ui->checkBoxShowArt, SIGNAL(toggled(bool)), this, SLOT(setShowAlbumArt(bool)));
    connect(ui->checkBoxUnknownFiles, SIGNAL(toggled(bool)), this, SLOT(setShowUnknownFileTypes(bool)));
    connect(ui->comboBoxPollFrequency, SIGNAL(currentIndexChanged(int)), this, SLOT(setStatusPollTimeout(int)));
    connect(ui->comboBoxPingTimeout, SIGNAL(currentIndexChanged(int)), this, SLOT(setPingTimeout(int)));
    connect(ui->comboBoxConnectionTimeout, SIGNAL(currentIndexChanged(int)), this, SLOT(setConnectionTimeout(int)));
    connect(ui->comboBoxRetryNetworkDelay, SIGNAL(currentIndexChanged(int)), this, SLOT(setRetryNetworkTimeout(int)));
    connect(ui->comboBoxRetrieveArtDelay, SIGNAL(currentIndexChanged(int)), this, SLOT(setRetrieveArtTimeout(int)));
    init();

}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}

void SettingsDialog::init()
{
    switch (AppSettings::getOrientation()) {
    case LANDSCAPE:
        ui->radioButtonLandscape->setChecked(true);
        break;
    case PORTRAIT:
        ui->radioButtonPortrait->setChecked(true);
        break;
    case AUTO_ROTATE:
    default:
        ui->radioButtonAutoRotate->setChecked(true);
        break;
    }

    ui->checkBoxAlertOnClose->setChecked(AppSettings::getAlertOnClose());
    ui->checkBoxShowArt->setChecked(AppSettings::getShowAlbumArt());
    ui->checkBoxUnknownFiles->setChecked(AppSettings::getShowUnknownFileTypes());
    int idx = -1;
    idx = ui->comboBoxPollFrequency->findText(QString::number(AppSettings::getStatusPollTimeout()));
    ui->comboBoxPollFrequency->setCurrentIndex(-1 < idx ? idx : 0);
    idx = ui->comboBoxConnectionTimeout->findText(QString::number(AppSettings::getConnectionTimeout()));
    ui->comboBoxConnectionTimeout->setCurrentIndex(-1 < idx ? idx : 0);
    idx = ui->comboBoxPingTimeout->findText(QString::number(AppSettings::getPingTimeout()));
    ui->comboBoxPingTimeout->setCurrentIndex(-1 < idx ? idx : 0);
    idx = ui->comboBoxRetryNetworkDelay->findText(QString::number(AppSettings::getRetryNetworkTimeout()));
    ui->comboBoxRetryNetworkDelay->setCurrentIndex(-1 < idx ? idx : 0);
    idx = ui->comboBoxRetrieveArtDelay->findText(QString::number(AppSettings::getRetrieveArtTimeout()));
    ui->comboBoxRetrieveArtDelay->setCurrentIndex(-1 < idx ? idx : 0);
}

void SettingsDialog::setOrientationLandscape() {
    setOrientation(LANDSCAPE);
}
void SettingsDialog::setOrientationPortrait() {
    setOrientation(PORTRAIT);
}
void SettingsDialog::setOrientationAutoRotate() {
    setOrientation(AUTO_ROTATE);
}
void SettingsDialog::setOrientation(Orientation orientation) {
    AppSettings::setOrientation(orientation);
}
void SettingsDialog::setStatusPollTimeout(int idx) {
    Q_UNUSED(idx);
    AppSettings::setStatusPollTimeout(ui->comboBoxPollFrequency->currentText().toInt());
}
void SettingsDialog::setPingTimeout(int idx) {
    Q_UNUSED(idx);
    AppSettings::setPingTimeout(ui->comboBoxPingTimeout->currentText().toInt());
}
void SettingsDialog::setConnectionTimeout(int idx) {
    Q_UNUSED(idx);
    AppSettings::setConnectionTimeout(ui->comboBoxConnectionTimeout->currentText().toInt());
}
void SettingsDialog::setRetrieveArtTimeout(int idx) {
    Q_UNUSED(idx);
    AppSettings::setRetrieveArtTimeout(ui->comboBoxRetrieveArtDelay->currentText().toInt());
}
void SettingsDialog::setRetryNetworkTimeout(int idx) {
    Q_UNUSED(idx);
    AppSettings::setRetryNetworkTimeout(ui->comboBoxRetryNetworkDelay->currentText().toInt());
}
void SettingsDialog::setShowUnknownFileTypes(bool state) {
    AppSettings::setShowUnknownFileTypes(state);
}
void SettingsDialog::setShowAlbumArt(bool state) {
    AppSettings::setShowAlbumArt(state);
}
void SettingsDialog::setAlertOnClose(bool state) {
    AppSettings::setAlertOnClose(state);
}

void SettingsDialog::closeEvent(QCloseEvent * event) {
    Q_UNUSED(event);
    emit closeSignal();
    this->close();
}
