/*   VLC-REMOTE for MAEMO 5
*   Copyright (C) 2010 Schutz Sacha <istdasklar@gmail.com>, Dru Moore <usr@dru-id.co.uk>, Yann Nave <yannux@onbebop.net>
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License version 2,
*   or (at your option) any later version, as published by the Free
*   Software Foundation
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details
*
*   You should have received a copy of the GNU General Public
*   License along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/
#ifndef PLAYLISTMAINWINDOW_H
#define PLAYLISTMAINWINDOW_H

#include <QMainWindow>
#include <QTimer>
#include <QtNetwork>
#include <QtXml>
#include "vlcplaylistelementsimple.h"
#include "vlcstatus.h"

#ifndef LIST_ITEM_TYPE_OFFSET
#define LIST_ITEM_TYPE_OFFSET 1000
#endif

namespace Ui {
    class PlayListMainWindow;
}

class PlayListMainWindow : public QMainWindow {
    Q_OBJECT
public:
    explicit PlayListMainWindow(QWidget *parent = 0);
    ~PlayListMainWindow();
    void init();
public slots:
    void onClear();
    void onShuffle();
    void onLoop();
    void onPlay();
    void onRepeat();
    void onRemove();
    void requestPlayList();
    void onListSelectionChanged();
    void finished(QNetworkReply * reply);
    void readReady();
    void error(QNetworkReply::NetworkError code);
    void showPlayList();
    void updateUiWithCurrentStatus(VlcStatus * status);

protected slots:
    void parseXmlPlayList();
    void updateList();
    int parsePlayListItem(QDomNode *node, QString *extension, bool *hasArt, int *currentLeafId, int depth);

signals:
    void idUpdated(int id, bool hasArt, QString extension);

protected:
    void changeEvent(QEvent *e);
    VlcPlayListElementSimple getElementFromId(int id);
    QString getExtension(QString path, QString extension);

private:
    Ui::PlayListMainWindow *ui;
    QTimer * mTimer;
    QString mIp;
    QNetworkAccessManager * mNetManager;
    QList<VlcPlayListElementSimple>* mContents;
    VlcPlayListElementSimple mCurrentElement;
    int mCurrentVlcIndex;
    int mCurrentDepth;
    QByteArray mResponse;
};

#endif // PLAYLISTMAINWINDOW_H
