/*   VLC-REMOTE for MAEMO 5
 *   Copyright (C) 2010 Schutz Sacha <istdasklar@gmail.com>
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2,
 *   or (at your option) any later version, as published by the Free
 *   Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
#ifndef PLAYERMAINWINDOW_H
#define PLAYERMAINWINDOW_H

#include <QMainWindow>
#include <QtNetwork>
#include <QtXml>
#include <QTimer>
#include "playlistmainwindow.h"
namespace Ui {
    class PlayerMainWindow;
}

class PlayerMainWindow : public QMainWindow {
    Q_OBJECT
public:
    explicit PlayerMainWindow(QWidget *parent = 0);
    ~PlayerMainWindow();

public slots:
    void askStatus();
    void showConfig();
    void showAbout();
    void play();
    void stop();
    void pause();
    void previous();
    void next();
    void fullscreen();
    void volUp();
    void volDown();
    void slide(int value);


protected slots:
    void parseXmlStatus();
protected:
    void changeEvent(QEvent *e);

private:
    Ui::PlayerMainWindow *ui;
    PlayListMainWindow * mPlayListMainWindow;
    QNetworkAccessManager * mNetManager;
    QString mIp;
    QTimer * mTimer;

};

#endif // PLAYERMAINWINDOW_H
