/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.io.IOException;
import java.io.PrintStream;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.ListIterator;
import openlink.util.Vector;
import openlink.util.VectorOfLong;
import virtuoso.jdbc4.VirtuosoConnection;
import virtuoso.jdbc4.VirtuosoException;
import virtuoso.jdbc4.VirtuosoFuture;
import virtuoso.jdbc4.VirtuosoParameterMetaData;
import virtuoso.jdbc4.VirtuosoResultSet;
import virtuoso.jdbc4.VirtuosoResultSetMetaData;
import virtuoso.jdbc4.VirtuosoXAConnection;

public class VirtuosoStatement
implements Statement {
    protected Vector parameters;
    protected Vector objparams;
    protected LinkedList<Object> batch;
    private int concurrency;
    protected int type;
    protected int exec_type = -1;
    private int fetchDirection = 1000;
    protected VirtuosoConnection connection;
    private int maxFieldSize;
    private int prefetch = 100;
    private int maxRows;
    protected int txn_timeout;
    protected int rpc_timeout;
    protected String statid;
    protected String cursorName;
    protected boolean close_flag = false;
    protected static int req_no;
    protected VirtuosoResultSet vresultSet;
    protected VirtuosoFuture future;
    protected VirtuosoResultSetMetaData metaData;
    protected boolean isCached = false;
    protected VirtuosoParameterMetaData paramsMetaData = null;
    private boolean isPoolable = true;

    VirtuosoStatement(VirtuosoConnection virtuosoConnection) throws VirtuosoException {
        this.connection = virtuosoConnection;
        this.type = 1003;
        this.concurrency = 1007;
        this.rpc_timeout = virtuosoConnection.timeout;
        this.txn_timeout = virtuosoConnection.txn_timeout;
        this.prefetch = virtuosoConnection.fbs;
    }

    VirtuosoStatement(VirtuosoConnection virtuosoConnection, int n, int n2) throws VirtuosoException {
        this.connection = virtuosoConnection;
        if (n != 1003 && n != 1005 && n != 1004) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        this.type = n;
        if (n2 != 1007 && n2 != 1008) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        this.concurrency = n2;
        this.rpc_timeout = virtuosoConnection.timeout;
        this.txn_timeout = virtuosoConnection.txn_timeout;
        this.prefetch = virtuosoConnection.fbs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VectorOfLong getStmtOpts() throws VirtuosoException {
        Object object;
        Object[] objectArray = new Long[11];
        objectArray[0] = this.connection.isReadOnly() ? new Long(3L) : new Long(this.concurrency == 1007 ? 1L : 2L);
        objectArray[1] = new Long(0L);
        objectArray[2] = new Long(this.maxRows);
        if (this.connection.getGlobalTransaction()) {
            object = this.connection.xa_connection;
            if (VirtuosoFuture.rpc_log != null) {
                PrintStream printStream = VirtuosoFuture.rpc_log;
                synchronized (printStream) {
                    VirtuosoFuture.rpc_log.println("VirtuosoStatement.getStmtOpts () xa_res=" + ((VirtuosoXAConnection)object).getVirtuosoXAResource().hashCode() + " :" + this.hashCode());
                    VirtuosoFuture.rpc_log.flush();
                }
            }
            objectArray[3] = new Long(((VirtuosoXAConnection)object).getVirtuosoXAResource().txn_timeout * 1000);
        } else {
            objectArray[3] = new Long(this.txn_timeout * 1000);
        }
        if (VirtuosoFuture.rpc_log != null) {
            object = VirtuosoFuture.rpc_log;
            synchronized (object) {
                VirtuosoFuture.rpc_log.println("VirtuosoStatement.getStmtOpts (txn_timeout=" + objectArray[3] + ") (con=" + this.connection.hashCode() + ") :" + this.hashCode());
                VirtuosoFuture.rpc_log.flush();
            }
        }
        objectArray[4] = new Long(this.prefetch);
        objectArray[5] = new Long(this.connection.getAutoCommit() ? 1L : 0L);
        objectArray[6] = new Long(this.rpc_timeout * 1000);
        switch (this.type) {
            case 1003: {
                objectArray[7] = new Long(0L);
                break;
            }
            case 1005: {
                objectArray[7] = new Long(2L);
                break;
            }
            case 1004: {
                objectArray[7] = new Long(3L);
            }
        }
        objectArray[8] = new Long(0L);
        objectArray[9] = new Long(1L);
        objectArray[10] = new Long(this.connection.getTransactionIsolation());
        return new VectorOfLong(objectArray);
    }

    protected VirtuosoResultSet sendQuery(String string) throws VirtuosoException {
        try {
            VirtuosoConnection virtuosoConnection = this.connection;
            synchronized (virtuosoConnection) {
                if (this.close_flag) {
                    throw new VirtuosoException("Statement is already closed", -13);
                }
                Object[] objectArray = new Object[6];
                Vector vector = new Vector(1);
                if (this.future != null) {
                    this.close();
                    this.close_flag = false;
                } else {
                    this.cancel();
                }
                objectArray[0] = this.statid == null ? (this.statid = new String("s" + this.connection.hashCode() + req_no++)) : this.statid;
                objectArray[2] = this.cursorName == null ? objectArray[0] : this.cursorName;
                objectArray[1] = this.connection.escapeSQL(string);
                objectArray[3] = vector;
                objectArray[4] = null;
                try {
                    vector.addElement(new Vector(0));
                    objectArray[5] = this.getStmtOpts();
                    this.future = this.connection.getFuture("EXEC", objectArray, this.rpc_timeout);
                    return new VirtuosoResultSet(this, this.metaData);
                }
                catch (IOException iOException) {
                    throw new VirtuosoException("Problem during serialization : " + iOException.getMessage(), -3);
                }
            }
        }
        catch (Throwable throwable) {
            this.notify_error(throwable);
            return null;
        }
    }

    public void finalize() throws Throwable {
        this.close();
        if (this.metaData != null) {
            this.metaData.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws VirtuosoException {
        VirtuosoConnection virtuosoConnection = this.connection;
        synchronized (virtuosoConnection) {
            if (this.vresultSet != null) {
                this.vresultSet = null;
            }
            if (this.future != null) {
                this.connection.removeFuture(this.future);
                this.future = null;
            }
        }
    }

    @Override
    public void clearWarnings() throws VirtuosoException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws VirtuosoException {
        VirtuosoConnection virtuosoConnection = this.connection;
        synchronized (virtuosoConnection) {
            try {
                if (this.close_flag) {
                    return;
                }
                this.close_flag = true;
                if (this.statid == null) {
                    return;
                }
                this.cancel();
                Object[] objectArray = new Object[]{this.statid, new Long(1L)};
                this.future = this.connection.getFuture("FRST", objectArray, this.rpc_timeout);
                this.future.nextResult();
                this.connection.removeFuture(this.future);
                this.future = null;
            }
            catch (IOException iOException) {
                throw new VirtuosoException("Problem during closing : " + iOException.getMessage(), -3);
            }
        }
    }

    @Override
    public boolean execute(String string) throws VirtuosoException {
        this.exec_type = -1;
        this.vresultSet = this.sendQuery(string);
        return this.vresultSet.kindop() != 0;
    }

    @Override
    public ResultSet executeQuery(String string) throws VirtuosoException {
        this.exec_type = 1;
        this.vresultSet = this.sendQuery(string);
        return this.vresultSet;
    }

    @Override
    public int executeUpdate(String string) throws VirtuosoException {
        this.exec_type = 0;
        this.vresultSet = this.sendQuery(string);
        return this.vresultSet.getUpdateCount();
    }

    @Override
    public int getMaxFieldSize() throws VirtuosoException {
        return this.maxFieldSize;
    }

    @Override
    public int getMaxRows() throws VirtuosoException {
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws VirtuosoException {
        try {
            VirtuosoConnection virtuosoConnection = this.connection;
            synchronized (virtuosoConnection) {
                try {
                    if (this.vresultSet == null || this.vresultSet.isLastResult) {
                        return false;
                    }
                    Object[] objectArray = new Object[]{this.statid, new Long(this.future.hashCode())};
                    this.future.send_message("FTCH", objectArray);
                    this.vresultSet.getMoreResults();
                    return true;
                }
                catch (IOException iOException) {
                    throw new VirtuosoException("Problem during serialization : " + iOException.getMessage(), -3);
                }
            }
        }
        catch (Throwable throwable) {
            this.notify_error(throwable);
            return false;
        }
    }

    @Override
    public int getQueryTimeout() throws VirtuosoException {
        return this.rpc_timeout;
    }

    @Override
    public ResultSet getResultSet() throws VirtuosoException {
        return this.vresultSet.kindop() != 0 ? this.vresultSet : null;
    }

    @Override
    public int getUpdateCount() throws VirtuosoException {
        if (this.vresultSet != null) {
            switch (this.vresultSet.kindop()) {
                case 0: 
                case 2: {
                    return this.vresultSet.getUpdateCount();
                }
            }
            return -1;
        }
        return -1;
    }

    @Override
    public SQLWarning getWarnings() throws VirtuosoException {
        return null;
    }

    @Override
    public void setMaxFieldSize(int n) throws VirtuosoException {
        if (n < 0) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        this.maxFieldSize = n;
    }

    @Override
    public void setMaxRows(int n) throws VirtuosoException {
        if (n < 0) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        this.maxRows = n;
    }

    @Override
    public void setQueryTimeout(int n) throws VirtuosoException {
        if (n < 0) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        this.rpc_timeout = n;
    }

    @Override
    public Connection getConnection() throws VirtuosoException {
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws VirtuosoException {
        return this.fetchDirection;
    }

    @Override
    public int getFetchSize() throws VirtuosoException {
        return this.prefetch;
    }

    @Override
    public int getResultSetConcurrency() throws VirtuosoException {
        return this.concurrency;
    }

    @Override
    public int getResultSetType() throws VirtuosoException {
        return this.type;
    }

    @Override
    public void setFetchDirection(int n) throws VirtuosoException {
        if (n != 1000 && n != 1001 && n != 1002) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        this.fetchDirection = n;
    }

    @Override
    public void setFetchSize(int n) throws VirtuosoException {
        if (n < 0 || this.maxRows > 0 && n > this.maxRows) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        this.prefetch = n;
    }

    @Override
    public void setCursorName(String string) throws VirtuosoException {
        this.cursorName = string;
    }

    @Override
    public void addBatch(String string) throws VirtuosoException {
        if (string == null) {
            return;
        }
        if (this.batch == null) {
            this.batch = new LinkedList();
        }
        this.batch.add(string);
    }

    @Override
    public void clearBatch() throws VirtuosoException {
        if (this.batch != null) {
            this.batch.clear();
        }
    }

    @Override
    public int[] executeBatch() throws BatchUpdateException {
        if (this.batch == null) {
            return new int[0];
        }
        int[] nArray = new int[this.batch.size()];
        int[] nArray2 = null;
        int n = 0;
        boolean bl = false;
        VirtuosoException virtuosoException = null;
        int n2 = 0;
        ListIterator listIterator = this.batch.listIterator();
        while (listIterator.hasNext()) {
            try {
                String string = (String)listIterator.next();
                VirtuosoResultSet virtuosoResultSet = this.sendQuery(string);
                nArray[n2] = virtuosoResultSet.getUpdateCount();
                if (virtuosoResultSet.kindop() == 1) {
                    bl = true;
                    break;
                }
            }
            catch (VirtuosoException virtuosoException2) {
                bl = true;
                nArray[n2] = -3;
                virtuosoException = virtuosoException2;
            }
            ++n;
            ++n2;
        }
        this.batch.clear();
        if (bl) {
            nArray2 = new int[n];
            for (n2 = 0; n2 < n; ++n2) {
                nArray2[n2] = nArray[n2];
            }
            if (virtuosoException != null) {
                throw new BatchUpdateException(virtuosoException.getMessage(), virtuosoException.getSQLState(), virtuosoException.getErrorCode(), nArray2);
            }
            throw new BatchUpdateException(nArray2);
        }
        return nArray;
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws VirtuosoException {
    }

    public int getExecType() {
        return this.exec_type;
    }

    @Override
    public boolean isClosed() {
        return this.close_flag;
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        if (n == 2) {
            throw new VirtuosoException("Keeping the current result open not supported", "IM001", -7);
        }
        return this.getMoreResults();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return new VirtuosoResultSet(this.connection);
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        return this.executeUpdate(string);
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        return this.executeUpdate(string);
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        return this.executeUpdate(string);
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        return this.execute(string);
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        return this.execute(string);
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        return this.execute(string);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    protected void notify_error(Throwable throwable) throws VirtuosoException {
        VirtuosoConnection virtuosoConnection = this.connection;
        if (virtuosoConnection != null) {
            throw virtuosoConnection.notify_error(throwable);
        }
        VirtuosoException virtuosoException = new VirtuosoException(throwable.getMessage(), -3);
        virtuosoException.initCause(throwable);
        throw virtuosoException;
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        this.isPoolable = bl;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.isPoolable;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw new VirtuosoException("Unable to unwrap to " + clazz.toString(), "22023", -4);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this);
    }
}

