/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

import QtQuick 1.0

Item {

    id:m_topbar

    anchors.fill: parent

    property alias title: mTitle.text

    Rectangle {

        width: parent.width-1
        height: 49

        color: "white"

        radius: 0
        border.color: "grey"

        Text {
            id : mTitle

            color: "blue"

            horizontalAlignment: Text.AlignHCenter

            anchors.horizontalCenter: parent.horizontalCenter

            font.bold: true
            font.pixelSize: 22

            y:10

        }


    }

    /*
      Minimize button
      */

    Rectangle {
        id: btn_minimize

        x:m_topbar.x + 5
        y:m_topbar.y + 5

        height: 40
        width: 45

        color: "transparent"

        border.color: "grey"
        border.width: 1

        radius: 4

        Rectangle {
            x:parent.x
            y:parent.y

            width: parent.width - 15
            height: parent.height - 15

            border.color: "white"
            color: "grey"
            border.width: 1
        }

        Rectangle {
            x:parent.x + 5
            y:parent.y + 5
            width: parent.width - 15
            height: parent.height - 15

            border.color: "white"
            color: "grey"
            border.width: 1
        }

        MouseArea {
            anchors.fill: parent

            onClicked: AppMan.minimize();

            onPressed: {
                parent.color = "blue"
            }

            onReleased: {
                parent.color = "transparent"
            }
        }

    }

    /*
          Close button
          */

        Rectangle {
            id: btn_close

            x:m_topbar.width - 50
            y:m_topbar.y + 5

            width: 45
            height: 40

            color: "transparent"

            border.color: "grey"
            border.width: 1

            radius: 4

            Text {
                id: button1
                color: "grey"
                anchors.centerIn: parent; font.bold: true
                text: "X"; style: Text.Raised; styleColor: "black"
                font.pixelSize: 26
                font.family: "Tahoma"
            }

            MouseArea {
                anchors.fill: parent

                onClicked: Qt.quit()

                onPressed: {
                    parent.color = "blue"
                }

                onReleased: {
                    parent.color = "transparent"
                }
            }
        }

}
