/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

import QtQuick 1.0

Rectangle {

    id:mainWindow

    property alias source: img.source

    signal clicked

    width: 44
    height: 38
    radius: 0

    color: "transparent"

    Rectangle {
        id:mask
        anchors.fill: parent
        visible:false
        border.color: "#9c96db"
        gradient: Gradient {
            GradientStop {
                position: 0
                color: "#6289be"
            }

            GradientStop {
                position: 0.53
                color: "#000000"
            }

            GradientStop {
                position: 1
                color: "#213f91"
            }
        }
    }


    anchors.verticalCenter: parent.verticalCenter

    Image {
        id: img
        anchors.centerIn: parent
    }

    MouseArea {
        anchors.fill: parent

        onClicked: mainWindow.clicked()

        onPressed: {
            mask.visible = true
        }

        onReleased: {
            mask.visible = false
        }
    }
}
