/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

#include <QtSql/QSqlDatabase>
#include <QtSql/QSqlQuery>
#include <QtSql/QSqlRecord>
#include <QDebug>
#include <QVariant>
#include <QString>

#include "dbthread.h"

DBThread::DBThread()
{
    db = QSqlDatabase::addDatabase("QSQLITE");
#if defined(Q_WS_MAEMO_5)
    db.setDatabaseName("/opt/vietkaralist/db/vietkaralist.sqlite");
#else
    db.setDatabaseName("/home/cuonglb/vietkaralist.sqlite");
#endif
    db.open();
}

DBThread::~DBThread(){
    db.close();
}

void DBThread::run(){

    QSqlQuery query(this->mm_query);
    QSqlRecord record = query.record();

    if (record.count() > 0) {
        emit removeOldSongs();
        while (query.next()) {
            emit addSong(query.value(0).toString(),query.value(1).toString(), query.value(4).toString(), query.value(5).toString());
        }
    }

    emit stopSearch();

}

void DBThread::slotExecQuery(const QString& m_query){
    this->mm_query = m_query;
    this->start();
}
