/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

#ifndef DBMAN_H
#define DBMAN_H

#include <QObject>

#include "qmlapplicationviewer.h"
#include "dbthread.h"

class DBMan : public QObject
{
    Q_OBJECT
public:
    explicit DBMan(QObject *parent = 0);
    explicit DBMan(QObject *parent = 0, QmlApplicationViewer* viewer = 0);

private:
    QmlApplicationViewer *m_viewer;
    DBThread *m_dbthread;


signals:
    void dbChanged();
    void removeOldSongs();
    void addSong(QString m_number, QString m_title, QString m_lyric, QString m_author);
    void startSearch();
    void stopSearch();

    void execQuery(const QString& m_query);


public slots:
    bool doSearch(QString searchText);

};

#endif // DBMAN_H
