/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

#include <QtDBus/QDBusConnection>
#include <QtDBus/QDBusMessage>
#include <QtDBus/QDBusInterface>

#include "appman.h"

AppMan::AppMan(QObject *parent) :
    QObject(parent)
{
}

AppMan::AppMan(QObject *parent, QmlApplicationViewer* viewer) :
    QObject(parent)
{
    this->m_viewer = viewer;
}

void AppMan::setOrientation(const QString &orientation){
    if(orientation=="portrait")
        m_viewer->setOrientation(QmlApplicationViewer::ScreenOrientationLockPortrait);
    else if(orientation=="landscape")
        m_viewer->setOrientation(QmlApplicationViewer::ScreenOrientationLockLandscape);
    else //auto
        m_viewer->setOrientation(QmlApplicationViewer::ScreenOrientationAuto);
}

void AppMan::minimize(){
    QDBusConnection c = QDBusConnection::sessionBus();
    QDBusMessage m = QDBusMessage::createSignal("/", "com.nokia.hildon_desktop", "exit_app_view");
    c.send(m);
}

