
#include <QDebug>
#include <QVariant>
/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

#include <QString>

#include "dbman.h"
#include "dbthread.h"

DBMan::DBMan(QObject *parent) :
    QObject(parent)
{
}

DBMan::DBMan(QObject *parent, QmlApplicationViewer* viewer) :
    QObject(parent)
{
    this->m_viewer = viewer;
    this->m_dbthread = new DBThread();

    connect(this, SIGNAL(execQuery(const QString&)), this->m_dbthread, SLOT(slotExecQuery(const QString&)));

    connect(this->m_dbthread, SIGNAL(stopSearch()), this, SIGNAL(stopSearch()));
    connect(this->m_dbthread, SIGNAL(removeOldSongs()), this, SIGNAL(removeOldSongs()));
    connect(this->m_dbthread, SIGNAL(addSong(QString , QString , QString , QString)), this, SIGNAL(addSong(QString , QString , QString , QString )));
}

bool DBMan::doSearch(QString searchText){
    qDebug() << searchText;

    emit startSearch();
    emit execQuery("select * from song where title_simple like '%"+searchText+"%' order by title asc");

    return true;
}
