/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

import QtQuick 1.1

Item {

    id:songList

    anchors.fill: parent
    anchors.leftMargin: 0
    anchors.rightMargin: 0

    SongListView {
        id:songlistview
    }


    Rectangle {
        width: parent.width
        height: 50
        color:"lightblue"

        radius: 4

        border.color: "grey"

        Rectangle {
            id: rec_tag

            width: parent.width-80
            x:9
            height: 35
            anchors.verticalCenter: parent.verticalCenter
            border.color: "grey"
            radius: 4
            TextInput {
                id: txt_searchText
                width: parent.width-1
                height: 27
                x:10
                text: ""
                font.pixelSize: 20
                anchors.verticalCenter: parent.verticalCenter

                Keys.onEnterPressed: {
                    doSearch();
                }
            }
        }

        Rectangle {
            x:rec_tag.width+20
            width:50
            height: 35
            anchors.verticalCenter: parent.verticalCenter
            radius:4

            color: "white"
            border.color: "grey"

            Image {
                id: btn_search
                source: "imgs/search.png"
                anchors.verticalCenter: parent.verticalCenter
                anchors.horizontalCenter: parent.horizontalCenter
            }

            MouseArea {
                anchors.fill: parent
                onClicked: {
                    doSearch();
                }
                onPressed: {
                    parent.color = "lightblue";
                }
                onReleased : {
                    parent.color = "white"
                }
            }
        }

    }

    WaitingDlg {
        id:waitingdlg
        anchors.centerIn:parent
        visible: false
    }

    function doSearch(){
        waitingdlg.visible = true;
        DBMan.doSearch(txt_searchText.text);
    }

    Connections {
        target: DBMan
        onStopSearch:{
            waitingdlg.visible = false;
        }
    }

}
