/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

import QtQuick 1.1

Item{

    id: aboutdlg

    anchors.verticalCenter: parent.verticalCenter
    width: parent.width; height: parent.height;
    x:-(parent.width * 1.5)

    signal close

    Connections {
        target: aboutdlg.parent

        onDialogClose: {
            aboutdlg.state = "close";
            aboutdlg.destroy(600);
            }
        }


    Rectangle {
        id: rectangle1
        anchors.fill: parent; anchors.bottomMargin: 0
        visible: true
        opacity:0.8

        Image {
            id: image1
            x: 0
            y: 53

            anchors.horizontalCenter: parent.horizontalCenter
            source: "imgs/app_icon.png"

        Text {
            id: text1
            x: 11
            y: 91
            height: 20
            text: "Việt Nam Karaoke Song List<br> OS: Maemo 5 (Fremantle)"
            anchors.horizontalCenterOffset: 1
            font.bold: true
            anchors.horizontalCenter: parent.horizontalCenter
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            font.pixelSize: 20
            }

        Text {
            id: text2
            x: 10
            y: 154
            height: 20
            text: "Phiên bản : 0.0.1 (18/09/2011)<br>\
Phát triển bởi : <a href='mailto:metacuong@gmail.com'>metacuong@gmail.com</a>"
            anchors.horizontalCenterOffset: 0
            wrapMode: Text.NoWrap
            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignHCenter
            anchors.horizontalCenter: parent.horizontalCenter
            font.pixelSize: 22
            }


        }

    Rectangle {
        width : aboutdlg.width
        height: 50
        color:"grey"
        opacity: 0.5

        MenuButton{
           id:btn_about
           source: "imgs/back.png"
           x:parent.width-50

           onClicked: {
               aboutdlg.close()
           }

        }
    }

    }

    Text {
        id: title

        anchors { horizontalCenter: parent.horizontalCenter; top: aboutdlg.top; topMargin: 10 }

        y:6

        font.pixelSize: 22
        color: "black"
        text: qsTr("About")
        smooth: true
        font.bold: true
        }

    states: [
        State{
            name:"show"
            AnchorChanges { target: aboutdlg; anchors.right: parent.right }
        },
        State {
            name: "close"
            AnchorChanges { target: aboutdlg; anchors.right: parent.left }
        }
    ]

    transitions: [Transition {
        AnchorAnimation { easing.type: Easing.OutQuart; duration: 300 }
        }
    ]

}
