/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

#ifndef DBTHREAD_H
#define DBTHREAD_H

#include <QThread>
#include <QtSql/QSqlDatabase>

class DBThread : public QThread
{
    Q_OBJECT

public:
    DBThread();
    ~DBThread();

    void run();

public slots:
    void slotExecQuery(const QString& m_query);

signals:
    void removeOldSongs();
    void addSong(QString m_number, QString m_title, QString m_lyric, QString m_author);
    void stopSearch();

private:
    QString mm_query;
    QSqlDatabase db;

};

#endif // DBTHREAD_H
