/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

import QtQuick 1.1

import "./scripts/main.js" as Script

Rectangle {

    id: mainWindow

    width: 480
    height: 800

    color:"white"

    property variant pageTitle: ["Danh Sách Yêu Thích","Danh Sách Bài Hát"]

    signal dialogClose

    VisualItemModel {
        id:pageModel

        Page{
            id:page1
            width: viewModel.width; height: viewModel.height
            anchors.topMargin: 4
            color:"white"
        }

        Page{
            id:page2
            width: viewModel.width; height: viewModel.height
            color:"white"

            SongList{
                id:xsonglist
            }
        }

    }

    ListView {
        id: viewModel

        anchors.fill: parent
        anchors.topMargin: 52
        anchors.bottomMargin: 30

        model: pageModel

        preferredHighlightBegin: 0
        preferredHighlightEnd: 0

        highlightRangeMode: ListView.StrictlyEnforceRange
        orientation: ListView.Horizontal
        snapMode: ListView.SnapOneItem
        highlightMoveDuration: 300

        interactive: false

        onCurrentIndexChanged:{
            topbar.title = pageTitle[currentIndex]
        }
    }

    Component.onCompleted: {
        viewModel.currentIndex = 1;
    }

    TopBar{
        id:topbar
    }

    MenuBar {
        id:menubar

        onChangeToFavouritePage: {

        }

        onChangeToMainPage: {
        }

        onOption: {

        }

        onAbout: {
            mainWindow.state="disable"
            var a = Script.createObject("../AboutDlg.qml", mainWindow)
            a.close.connect(closeDlg)
            a.state = "show"
        }
    }

    function closeDlg(){
        dialogClose();
        mainWindow.state = "enable"
    }

    states: [
        State{
            name:"enable"
        },
        State{
            name:"disable"
            PropertyChanges {target: topbar; visible:false }
            PropertyChanges {target: menubar; visible:false }
            PropertyChanges {target: page2; visible:false}
        }
    ]


}
