/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

import QtQuick 1.1

Rectangle {

    id:container
    width:parent.width

    property alias songlistView: songlistView

    anchors.verticalCenter: parent.verticalCenter
    anchors.horizontalCenter: parent.horizontalCenter
    anchors.fill: parent;anchors.topMargin: 55;anchors.leftMargin: 0;anchors.rightMargin: 0;anchors.bottomMargin: 30

    Component {
                 id: songlistDelegate
                 Item {

                     width: container.width; height: 80

                     Rectangle {
                         width: container.width
                         height:1
                         border.color: "grey"
                     }

                     Row {
                         anchors.verticalCenter: parent.verticalCenter
                         x:6
                         Column {
                             width: 80
                                Text {
                                    text:model.number
                                    font.bold: true
                                    font.pixelSize: 20
                                    color:"blue"
                                }
                             }
                         Column {
                             width: 350
                                Text {
                                    text:model.title
                                    font.bold: true
                                    font.pixelSize: 18
                                }
                                Text {
                                    text:model.lyric
                                    font.pixelSize: 16
                                    font.italic: true
                                    wrapMode: Text.WordWrap
                                    width: 300
                                }
                             }

                          Column {
                              width:100
                              visible: container.width > container.height ? true : false
                              Text {
                                  text:model.author
                                  font.bold: true
                                  font.pixelSize: 18
                              }
                          }
                         }


                     MouseArea {
                         anchors.fill: parent;
                         onClicked:{
                             songlistView.currentIndex = index;
                         }
                    }
                 }
             }

    ListModel {
        id: songlistModel

        Component.onCompleted: {

        }

    }

    Connections {
        target:DBMan
        onDbChanged:{
        }
        onAddSong:{
            songlistModel.append({"number":m_number, "title":m_title, "lyric":m_lyric, "author":m_author})
        }
        onRemoveOldSongs:{
            console.log("Remove old songs")
            songlistModel.clear();
        }
    }

    Component {
        id: highlightsongDelegate
        Rectangle {
            width: container.width; height: songlistView.currentItem.height-6
            color: "lightsteelblue"; radius: 5
            y: songlistView.currentItem.y+4
            border.color: "grey"
            /*Behavior on y {
                SpringAnimation {
                    spring: 4
                    damping: 0.1
                }
            }*/
        }
    }

    Component {
        id: sectionHeading
        Rectangle {
            width: container.width
            height: childrenRect.height
            color: "lightsteelblue"

            Text {
                text: section
                font.bold: true
            }
        }
    }


    ListView {
        id : songlistView
        anchors.fill: parent
        model: songlistModel
        delegate: songlistDelegate
        highlight: highlightsongDelegate
        focus: true
        highlightFollowsCurrentItem: false


        section.property: "the_loai"
        section.criteria: ViewSection.FullString
        section.delegate: sectionHeading

        ScrollBar{

        }

    }


}
