/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

#include <QtGui/QApplication>
#include <QDeclarativeContext>

#include "qmlapplicationviewer.h"

#include "appman.h"
#include "dbman.h"

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);

    QmlApplicationViewer viewer;

    AppMan appman(0, &viewer);
    DBMan dbman(0, &viewer);

    QDeclarativeContext *context = viewer.rootContext();

    context->setContextProperty("AppMan", &appman);
    context->setContextProperty("DBMan", &dbman);

    viewer.setOrientation(QmlApplicationViewer::ScreenOrientationAuto);
    viewer.setMainQmlFile(QLatin1String("qml/VietKaraList/main.qml"));
    viewer.setWindowTitle(QString::fromUtf8("Viet Nam Karaoke Song List"));

#if defined(Q_WS_MAEMO_5) || defined(Q_OS_SYMBIAN)
    viewer.showFullScreen();
#else
    viewer.show();
 #endif

    return app.exec();
}
