
#include "config.h"
#include "debug.h"
#include "config.h"
#include "res.h"
#include "rescommon.h"

#pragma code_page(28591)

#define FILE_DESCRIPTION  "Vice C64 Emulator"



IDR_MENUC64 MENU DISCARDABLE
BEGIN
    POPUP N_("&File")
    BEGIN
        MENUITEM "", IDM_AUTOSTART
        MENUITEM SEPARATOR
        POPUP N_("Attach &disk image")
        BEGIN
            MENUITEM "", IDM_ATTACH_8
            MENUITEM "", IDM_ATTACH_9
            MENUITEM "", IDM_ATTACH_10
            MENUITEM "", IDM_ATTACH_11
        END
        POPUP N_("D&etach disk image")
        BEGIN
            MENUITEM "", IDM_DETACH_8
            MENUITEM "", IDM_DETACH_9
            MENUITEM "", IDM_DETACH_10
            MENUITEM "", IDM_DETACH_11
            MENUITEM SEPARATOR
            MENUITEM "", IDM_DETACH_ALL
        END
        POPUP N_("&Flip list")
        BEGIN
            MENUITEM "", IDM_FLIP_ADD
            MENUITEM "", IDM_FLIP_REMOVE
            MENUITEM "", IDM_FLIP_NEXT
            MENUITEM "", IDM_FLIP_PREVIOUS
            MENUITEM SEPARATOR
            MENUITEM "", IDM_FLIP_LOAD
            MENUITEM "", IDM_FLIP_SAVE
        END
        MENUITEM SEPARATOR
        MENUITEM "", IDM_ATTACH_TAPE
        MENUITEM "", IDM_DETACH_TAPE
        POPUP N_("Datassette contro&l")
        BEGIN
            MENUITEM "", IDM_DATASETTE_CONTROL_STOP
            MENUITEM "", IDM_DATASETTE_CONTROL_START
            MENUITEM "", IDM_DATASETTE_CONTROL_FORWARD
            MENUITEM "", IDM_DATASETTE_CONTROL_REWIND
            MENUITEM "", IDM_DATASETTE_CONTROL_RECORD
            MENUITEM "", IDM_DATASETTE_CONTROL_RESET
            MENUITEM "", IDM_DATASETTE_RESET_COUNTER
        END
        MENUITEM SEPARATOR
        POPUP N_("Attach &cartridge image...")
        BEGIN
            MENUITEM "", IDM_CART_ATTACH_CRT
            MENUITEM SEPARATOR
            MENUITEM "", IDM_CART_ATTACH_8KB
            MENUITEM "", IDM_CART_ATTACH_16KB
            MENUITEM "", IDM_CART_ATTACH_AR
            MENUITEM "", IDM_CART_ATTACH_AR3
            MENUITEM "", IDM_CART_ATTACH_AR4
            MENUITEM "", IDM_CART_ATTACH_STARDOS
            MENUITEM "", IDM_CART_ATTACH_AT
            MENUITEM "", IDM_CART_ATTACH_EPYX
            MENUITEM "", IDM_CART_ATTACH_IEEE488
            MENUITEM "", IDM_CART_ATTACH_RR
            MENUITEM "", IDM_CART_ATTACH_IDE64
            MENUITEM "", IDM_CART_ATTACH_SS4
            MENUITEM "", IDM_CART_ATTACH_SS5
            MENUITEM "", IDM_CART_ATTACH_STB
            POPUP N_("Expert Cartridge")
            BEGIN
                MENUITEM "",    IDM_CART_ENABLE_EXPERT
                MENUITEM SEPARATOR
                MENUITEM "",    IDM_CART_MODE_OFF
                MENUITEM N_("Prg"), IDM_CART_MODE_PRG
                MENUITEM "",    IDM_CART_MODE_ON
            END
            MENUITEM SEPARATOR
            MENUITEM "", IDM_CART_SET_DEFAULT
            MENUITEM "", IDM_TOGGLE_CART_RESET
        END
        MENUITEM "", IDM_CART_DETACH
        MENUITEM "", IDM_CART_FREEZE
        MENUITEM SEPARATOR
        MENUITEM "", IDM_PAUSE, CHECKED
        MENUITEM "", IDM_MONITOR
        POPUP N_("&Reset")
        BEGIN
            MENUITEM "", IDM_RESET_HARD
            MENUITEM "", IDM_RESET_SOFT
            MENUITEM SEPARATOR
            MENUITEM "", IDM_RESET_DRIVE8
            MENUITEM "", IDM_RESET_DRIVE9
            MENUITEM "", IDM_RESET_DRIVE10
            MENUITEM "", IDM_RESET_DRIVE11
        END
#ifdef DEBUG
        POPUP N_("&Debug")
        BEGIN
            POPUP N_("M&ode")
            BEGIN
                MENUITEM "", IDM_DEBUG_MODE_NORMAL
                MENUITEM "", IDM_DEBUG_MODE_SMALL
                MENUITEM "", IDM_DEBUG_MODE_HISTORY
                MENUITEM "", IDM_DEBUG_MODE_AUTOPLAY
            END
            MENUITEM "", IDM_TOGGLE_MAINCPU_TRACE,   CHECKED
            MENUITEM "", IDM_TOGGLE_DRIVE0CPU_TRACE, CHECKED
            MENUITEM "", IDM_TOGGLE_DRIVE1CPU_TRACE, CHECKED
        END
#endif
        MENUITEM SEPARATOR
        MENUITEM "", IDM_EXIT
    END
    POPUP N_("Edit")
    BEGIN
        MENUITEM "", IDM_EDIT_COPY
        MENUITEM "", IDM_EDIT_PASTE
    END
    POPUP N_("Sna&pshot")
    BEGIN
        MENUITEM "", IDM_SNAPSHOT_LOAD
        MENUITEM "", IDM_SNAPSHOT_SAVE
        MENUITEM "", IDM_LOADQUICK
        MENUITEM "", IDM_SAVEQUICK
        MENUITEM SEPARATOR
        MENUITEM "", IDM_EVENT_TOGGLE_RECORD
        MENUITEM "", IDM_EVENT_TOGGLE_PLAYBACK
        MENUITEM "", IDM_EVENT_SETMILESTONE
        MENUITEM "", IDM_EVENT_RESETMILESTONE
        POPUP N_("Recording start mode")
        BEGIN
            MENUITEM "", IDM_EVENT_START_MODE_SAVE
            MENUITEM "", IDM_EVENT_START_MODE_LOAD
            MENUITEM "", IDM_EVENT_START_MODE_RESET
            MENUITEM "", IDM_EVENT_START_MODE_PLAYBACK
        END
        MENUITEM "", IDM_EVENT_DIRECTORY
        MENUITEM SEPARATOR
        MENUITEM "", IDM_MEDIAFILE
        MENUITEM SEPARATOR
        MENUITEM "", IDM_SOUND_RECORD_START
        MENUITEM "", IDM_SOUND_RECORD_STOP
        MENUITEM SEPARATOR
        MENUITEM "", IDM_NETWORK_SETTINGS
    END
    POPUP N_("&Options")
    BEGIN
        POPUP N_("&Refresh rate")
        BEGIN
            MENUITEM "",      IDM_REFRESH_RATE_AUTO
            MENUITEM N_("1/&1"),  IDM_REFRESH_RATE_1
            MENUITEM N_("1/&2"),  IDM_REFRESH_RATE_2
            MENUITEM N_("1/&3"),  IDM_REFRESH_RATE_3
            MENUITEM N_("1/&4"),  IDM_REFRESH_RATE_4
            MENUITEM N_("1/&5"),  IDM_REFRESH_RATE_5
            MENUITEM N_("1/&6"),  IDM_REFRESH_RATE_6
            MENUITEM N_("1/&7"),  IDM_REFRESH_RATE_7
            MENUITEM N_("1/&8"),  IDM_REFRESH_RATE_8
            MENUITEM N_("1/&9"),  IDM_REFRESH_RATE_9
            MENUITEM N_("1/1&0"), IDM_REFRESH_RATE_10
        END
        POPUP N_("&Maximum Speed")
        BEGIN
            MENUITEM N_("&200%"), IDM_MAXIMUM_SPEED_200
            MENUITEM N_("&100%"), IDM_MAXIMUM_SPEED_100
            MENUITEM N_("&50%"),  IDM_MAXIMUM_SPEED_50
            MENUITEM N_("&20%"),  IDM_MAXIMUM_SPEED_20
            MENUITEM N_("1&0%"),  IDM_MAXIMUM_SPEED_10
            MENUITEM "",      IDM_MAXIMUM_SPEED_NO_LIMIT
            MENUITEM SEPARATOR
            MENUITEM "",      IDM_MAXIMUM_SPEED_CUSTOM
        END
        MENUITEM "", IDM_TOGGLE_WARP_MODE,            CHECKED
        MENUITEM SEPARATOR
        MENUITEM "", IDM_TOGGLE_FULLSCREEN
        MENUITEM "", IDM_TOGGLE_ALWAYSONTOP
        MENUITEM SEPARATOR
        MENUITEM "", IDM_TOGGLE_VIDEOCACHE,           CHECKED
        MENUITEM "", IDM_TOGGLE_DOUBLESIZE,           CHECKED
        MENUITEM "", IDM_TOGGLE_DOUBLESCAN,           CHECKED
        MENUITEM "", IDM_TOGGLE_FASTPAL,              CHECKED
        MENUITEM "", IDM_TOGGLE_SCALE2X,              CHECKED
        MENUITEM SEPARATOR
        MENUITEM "", IDM_SWAP_JOYSTICK
        MENUITEM "", IDM_SWAP_EXTRA_JOYSTICK
        MENUITEM "", IDM_ALLOW_JOY_OPPOSITE_TOGGLE
        MENUITEM "", IDM_JOYKEYS_TOGGLE
        MENUITEM SEPARATOR
        MENUITEM "", IDM_TOGGLE_SOUND,                CHECKED
        MENUITEM SEPARATOR
        MENUITEM "", IDM_TOGGLE_DRIVE_TRUE_EMULATION, CHECKED
        MENUITEM "", IDM_TOGGLE_AUTOSTART_HANDLE_TDE
        MENUITEM "", IDM_TOGGLE_VIRTUAL_DEVICES
        MENUITEM SEPARATOR
        POPUP N_("Vide&o standard")
        BEGIN
            MENUITEM N_("&PAL-G"),      IDM_SYNC_FACTOR_PAL
            MENUITEM N_("&NTSC-M"),     IDM_SYNC_FACTOR_NTSC
            MENUITEM N_("&Old NTSC-M"), IDM_SYNC_FACTOR_NTSCOLD
        END
        MENUITEM "", IDM_TOGGLE_EMUID
        MENUITEM "", IDM_MOUSE
    END
    POPUP N_("S&ettings")
    BEGIN
        MENUITEM "", IDM_AUTOSTART_SETTINGS
        MENUITEM "", IDM_VIDEO_SETTINGS
        MENUITEM "", IDM_DEVICEMANAGER
        MENUITEM "", IDM_DRIVE_SETTINGS
        MENUITEM "", IDM_DATASETTE_SETTINGS
        MENUITEM "", IDM_VICII_SETTINGS
        MENUITEM "", IDM_JOY_SETTINGS
        MENUITEM "", IDM_EXTRA_JOY_SETTINGS
        MENUITEM "", IDM_KEYBOARD_SETTINGS
        MENUITEM "", IDM_MOUSE_SETTINGS
        MENUITEM "", IDM_LIGHTPEN_SETTINGS
        MENUITEM "", IDM_SOUND_SETTINGS
        MENUITEM "", IDM_SID_SETTINGS
        MENUITEM "", IDM_ROM_SETTINGS
        MENUITEM "", IDM_RAM_SETTINGS
        MENUITEM "", IDM_RS232_SETTINGS
        POPUP N_("&Cartridge/IO settings")
        BEGIN
            MENUITEM "", IDM_REU_SETTINGS
            MENUITEM "", IDM_GEORAM_SETTINGS
            MENUITEM "", IDM_RAMCART_SETTINGS
            MENUITEM "", IDM_DQBB_SETTINGS
            MENUITEM "", IDM_ISEPIC_SETTINGS
            MENUITEM "", IDM_PLUS60K_SETTINGS
            MENUITEM "", IDM_PLUS256K_SETTINGS
            MENUITEM "", IDM_C64_256K_SETTINGS
            MENUITEM "", IDM_MIDI_SETTINGS
            MENUITEM "", IDM_MMC64_SETTINGS
            MENUITEM "", IDM_DIGIMAX_SETTINGS
            MENUITEM "", IDM_IDE64_SETTINGS
#ifdef HAVE_TFE
            MENUITEM "", IDM_TFE_SETTINGS
#endif
            MENUITEM "", IDM_ACIA_SETTINGS
            MENUITEM "", IDM_RS232USER_SETTINGS
            MENUITEM "", IDM_EASYFLASH_SETTINGS
            MENUITEM "", IDM_SFX_SE_SETTINGS
            MENUITEM "", IDM_TOGGLE_SFX_SS
        END
        MENUITEM SEPARATOR
        MENUITEM "", IDM_SETTINGS_SAVE_FILE
        MENUITEM "", IDM_SETTINGS_LOAD_FILE
        MENUITEM "", IDM_SETTINGS_SAVE
        MENUITEM "", IDM_SETTINGS_LOAD
        MENUITEM "", IDM_SETTINGS_DEFAULT
        MENUITEM SEPARATOR
        MENUITEM "", IDM_TOGGLE_SAVE_SETTINGS_ON_EXIT
        MENUITEM "", IDM_TOGGLE_CONFIRM_ON_EXIT
    END
    POPUP N_("&Language")
    BEGIN
        MENUITEM "", IDM_LANG_EN
        MENUITEM "", IDM_LANG_DA
        MENUITEM "", IDM_LANG_DE
        MENUITEM "", IDM_LANG_FR
        MENUITEM "", IDM_LANG_HU
        MENUITEM "", IDM_LANG_IT
        MENUITEM "", IDM_LANG_NL
        MENUITEM "", IDM_LANG_PL
        MENUITEM "", IDM_LANG_SV
        MENUITEM "", IDM_LANG_TR
    END
    POPUP N_("&Help")
    BEGIN
        MENUITEM "", IDM_HELP
        MENUITEM SEPARATOR
        MENUITEM "", IDM_ABOUT
        MENUITEM SEPARATOR
        MENUITEM "", IDM_CMDLINE
        MENUITEM SEPARATOR
        MENUITEM "", IDM_CONTRIBUTORS
        MENUITEM "", IDM_LICENSE
        MENUITEM "", IDM_WARRANTY
    END
END



IDD_C64ROM_SETTINGS_DIALOG DIALOG DISCARDABLE 0, 0, 240, 70
BEGIN
    LTEXT      "", IDC_KERNAL,
               9, 8, 40, 8
    EDITTEXT   IDC_C64ROM_KERNAL_FILE,
               55, 7, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_C64ROM_KERNAL_BROWSE,
               185, 7, 50, 14, 0
    LTEXT      "", IDC_BASIC,
               9, 28, 40, 8
    EDITTEXT   IDC_C64ROM_BASIC_FILE,
               55, 27, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_C64ROM_BASIC_BROWSE,
               185, 27, 50, 14, 0
    LTEXT      "", IDC_CHARACTER,
               9, 48, 40, 8
    EDITTEXT   IDC_C64ROM_CHARGEN_FILE,
               55, 47, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_C64ROM_CHARGEN_BROWSE,
               185, 47, 50, 14, 0
END



IDD_C64DRIVEROM_SETTINGS_DIALOG DIALOG DISCARDABLE 0, 0, 240, 210
BEGIN
    LTEXT      N_("1541"), IDC_1541,
               9, 8, 40, 8
    EDITTEXT   IDC_DRIVEROM_1541_FILE,
               55, 7, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_DRIVEROM_1541_BROWSE,
               185, 7, 50, 14, 0

    LTEXT      N_("1541-II"), IDC_1541_II,
               9, 28, 40, 8
    EDITTEXT   IDC_DRIVEROM_1541II_FILE,
               55, 27, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_DRIVEROM_1541II_BROWSE,
               185, 27, 50, 14, 0

    LTEXT      N_("1570"), IDC_1570,
               9, 48, 40, 8
    EDITTEXT   IDC_DRIVEROM_1570_FILE,
               55, 47, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_DRIVEROM_1570_BROWSE,
               185, 47, 50, 14, 0

    LTEXT      N_("1571"), IDC_1571,
               9, 68, 40, 8
    EDITTEXT   IDC_DRIVEROM_1571_FILE,
               55, 67, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_DRIVEROM_1571_BROWSE,
               185, 67, 50, 14, 0

    LTEXT      N_("1581"), IDC_1581,
               9, 88, 40, 8
    EDITTEXT   IDC_DRIVEROM_1581_FILE,
               55, 87, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_DRIVEROM_1581_BROWSE,
               185, 87, 50, 14, 0

    LTEXT      N_("2031"), IDC_2031,
               9, 108, 40, 8
    EDITTEXT   IDC_DRIVEROM_2031_FILE,
               55, 107, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_DRIVEROM_2031_BROWSE,
               185, 107, 50, 14, 0

    LTEXT      N_("2040"), IDC_2040,
               9, 128, 40, 8
    EDITTEXT   IDC_DRIVEROM_2040_FILE,
               55, 127, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_DRIVEROM_2040_BROWSE,
               185, 127, 50, 14, 0

    LTEXT      N_("3040"), IDC_3040,
               9, 148, 40, 8
    EDITTEXT   IDC_DRIVEROM_3040_FILE,
               55, 147, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_DRIVEROM_3040_BROWSE,
               185, 147, 50, 14, 0

    LTEXT      N_("4040"), IDC_4040,
               9, 168, 40, 8
    EDITTEXT   IDC_DRIVEROM_4040_FILE,
               55, 167, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_DRIVEROM_4040_BROWSE,
               185, 167, 50, 14, 0

    LTEXT      N_("1001"), IDC_1001,
               9, 188, 40, 8
    EDITTEXT   IDC_DRIVEROM_1001_FILE,
               55, 187, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_DRIVEROM_1001_BROWSE,
               185, 187, 50, 14, 0
END



IDD_C64ROM_RESOURCE_DIALOG DIALOG DISCARDABLE 0, 0, 160, 85
BEGIN
    GROUPBOX      "", IDC_COMPUTER_RESOURCES,
                  4, 3, 151, 55
    AUTOCHECKBOX  "", IDC_C64ROM_KERNAL_RESOURCE,
                  11, 13, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  "", IDC_C64ROM_BASIC_RESOURCE,
                  11, 28, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  "", IDC_C64ROM_CHARGEN_RESOURCE,
                  11, 43, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP

    DEFPUSHBUTTON "", IDOK,
                  20, 65, 50, 14, WS_TABSTOP
    PUSHBUTTON    "", IDCANCEL,
                  80, 65, 50, 14, WS_TABSTOP
END



IDD_C64ROMDRIVE_RESOURCE_DIALOG DIALOG DISCARDABLE 0, 0, 160, 190
BEGIN
    GROUPBOX      "", IDC_DRIVE_RESOURCES,
                  4, 3, 151, 160
    AUTOCHECKBOX  N_("1541"), IDC_DRIVEROM_1541_RESOURCE,
                  11, 13, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  N_("1541-II"), IDC_DRIVEROM_1541II_RESOURCE,
                  11, 28, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  N_("1570"), IDC_DRIVEROM_1570_RESOURCE,
                  11, 43, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  N_("1571"), IDC_DRIVEROM_1571_RESOURCE,
                  11, 58, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  N_("1581"), IDC_DRIVEROM_1581_RESOURCE,
                  11, 73, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  N_("2031"), IDC_DRIVEROM_2031_RESOURCE,
                  11, 88, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  N_("2040"), IDC_DRIVEROM_2040_RESOURCE,
                  11, 103, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  N_("3040"), IDC_DRIVEROM_3040_RESOURCE,
                  11, 118, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  N_("4040"), IDC_DRIVEROM_4040_RESOURCE,
                  11, 133, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  N_("1001"), IDC_DRIVEROM_1001_RESOURCE,
                  11, 148, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP

    DEFPUSHBUTTON "", IDOK,
                  20, 170, 50, 14, WS_TABSTOP
    PUSHBUTTON    "", IDCANCEL,
                  80, 170, 50, 14, WS_TABSTOP
END



IDD_C64KBD_MAPPING_SETTINGS_DIALOG DIALOG DISCARDABLE 0, 0, 240, 140
BEGIN
    AUTORADIOBUTTON "", IDC_C64KBD_MAPPING_SELECT_SYM,
                    10, 10, 54, 10, BS_AUTORADIOBUTTON | WS_GROUP | WS_TABSTOP
    AUTORADIOBUTTON "", IDC_C64KBD_MAPPING_SELECT_SYMDE,
                    10, 30, 54, 10, BS_AUTORADIOBUTTON
    AUTORADIOBUTTON "", IDC_C64KBD_MAPPING_SELECT_POS,
                    10, 50, 54, 10, BS_AUTORADIOBUTTON

    EDITTEXT        IDC_C64KBD_MAPPING_SYM,
                    65, 9, 110, 12, WS_TABSTOP
    PUSHBUTTON      "", IDC_C64KBD_MAPPING_SYM_BROWSE,
                    185, 9, 50, 14, 0
    EDITTEXT        IDC_C64KBD_MAPPING_SYMDE,
                    65, 29, 110, 12, WS_TABSTOP
    PUSHBUTTON      "", IDC_C64KBD_MAPPING_SYMDE_BROWSE,
                    185, 29, 50, 14, 0
    EDITTEXT        IDC_C64KBD_MAPPING_POS,
                    65, 49, 110, 12, WS_TABSTOP
    PUSHBUTTON      "", IDC_C64KBD_MAPPING_POS_BROWSE,
                    185, 49, 50, 14, 0

    PUSHBUTTON      "", IDC_C64KBD_MAPPING_DUMP,
                    10, 74, 60, 14, 0
    PUSHBUTTON      "", IDC_KBD_SHORTCUT_DUMP,
                    80, 74, 60, 14, 0

    DEFPUSHBUTTON   "", IDOK,
                    20, 120, 50, 14, WS_TABSTOP
    PUSHBUTTON      "", IDCANCEL,
                    80, 120, 50, 14, WS_TABSTOP
END



STRINGTABLE
BEGIN
  IDS_MI_NETWORK_SETTINGS  N_("Netplay (experimental)...")
  IDS_MI_PLUS60K_SETTINGS  N_("PLUS&60K settings...")
  IDS_MI_PLUS256K_SETTINGS N_("PLUS2&56K settings...")
  IDS_MI_C64_256K_SETTINGS N_("&256K settings...")
END



STRINGTABLE
LANGUAGE LANG_DANISH, SUBLANG_NEUTRAL
BEGIN
  IDS_MI_NETWORK_SETTINGS  "Netvrksspil (eksperimentelt)..."
  IDS_MI_PLUS60K_SETTINGS  "PLUS&60K-indstillinger..."
  IDS_MI_PLUS256K_SETTINGS "PLUS2&56K-indstillinger..."
  IDS_MI_C64_256K_SETTINGS "&256K-indstillinger..."
END



STRINGTABLE
LANGUAGE LANG_GERMAN, SUBLANG_NEUTRAL
BEGIN
  IDS_MI_NETWORK_SETTINGS  "Netplay (experimentell)..."
  IDS_MI_PLUS60K_SETTINGS  "PLUS&60K Einstellungen..."
  IDS_MI_PLUS256K_SETTINGS "PLUS2&56K Einstellungen..."
  IDS_MI_C64_256K_SETTINGS "&256K Einstellungen..."
END



STRINGTABLE
LANGUAGE LANG_FRENCH, SUBLANG_NEUTRAL
BEGIN
  IDS_MI_NETWORK_SETTINGS  "Jeu en rseau (exprimental)..."
  IDS_MI_PLUS60K_SETTINGS  "Paramtres PLUS&60K..."
  IDS_MI_PLUS256K_SETTINGS "Paramtres PLUS2&56K..."
  IDS_MI_C64_256K_SETTINGS "Paramtres &256K..."
END



#pragma code_page(28592)
STRINGTABLE
LANGUAGE LANG_HUNGARIAN, SUBLANG_NEUTRAL
BEGIN
  IDS_MI_NETWORK_SETTINGS  "Hlzati jtk (ksrleti)..."
  IDS_MI_PLUS60K_SETTINGS  "PLUS&60K belltsai..."
  IDS_MI_PLUS256K_SETTINGS "PLUS2&56K belltsai..."
  IDS_MI_C64_256K_SETTINGS "&256K belltsai..."
END
#pragma code_page(28591)



STRINGTABLE
LANGUAGE LANG_ITALIAN, SUBLANG_NEUTRAL
BEGIN
  IDS_MI_NETWORK_SETTINGS  "Netplay (sperimentale)..."
  IDS_MI_PLUS60K_SETTINGS  "Impostazioni PLUS&60K..."
  IDS_MI_PLUS256K_SETTINGS "Impostazioni PLUS2&56K..."
  IDS_MI_C64_256K_SETTINGS "Impostazioni &256K..."
END



STRINGTABLE
LANGUAGE LANG_DUTCH, SUBLANG_NEUTRAL
BEGIN
  IDS_MI_NETWORK_SETTINGS  "Netplay (experimenteel)..."
  IDS_MI_PLUS60K_SETTINGS  "PLUS&60K-instellingen..."
  IDS_MI_PLUS256K_SETTINGS "PLUS2&56K-instellingen..."
  IDS_MI_C64_256K_SETTINGS "&256K-instellingen..."
END



#pragma code_page(28592)
STRINGTABLE
LANGUAGE LANG_POLISH, SUBLANG_NEUTRAL
BEGIN
  IDS_MI_NETWORK_SETTINGS  "Netplay (experimental)..."
  IDS_MI_PLUS60K_SETTINGS  "Ustawienia PLUS&60K..."
  IDS_MI_PLUS256K_SETTINGS "Ustawienia PLUS2&56K..."
  IDS_MI_C64_256K_SETTINGS "Ustawienia &256K..."
END
#pragma code_page(28591)



STRINGTABLE
LANGUAGE LANG_SWEDISH, SUBLANG_NEUTRAL
BEGIN
  IDS_MI_NETWORK_SETTINGS  "Ntverksspel (experimentellt)..."
  IDS_MI_PLUS60K_SETTINGS  "PLUS&60K-instllningar..."
  IDS_MI_PLUS256K_SETTINGS "PLUS2&56K-instllningar..."
  IDS_MI_C64_256K_SETTINGS "&256K-instllningar..."
END



#pragma code_page(28599)
STRINGTABLE
LANGUAGE LANG_TURKISH, SUBLANG_NEUTRAL
BEGIN
  IDS_MI_NETWORK_SETTINGS  "Netplay (deneysel)..."
  IDS_MI_PLUS60K_SETTINGS  "PLUS&60K ayarlar..."
  IDS_MI_PLUS256K_SETTINGS "PLUS2&56K ayarlar..."
  IDS_MI_C64_256K_SETTINGS "&256K ayarlar..."
END
#pragma code_page(28591)
