                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               

#include "vice.h"

#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define __USE_INLINE__

#include <proto/locale.h>

#include "archdep.h"
#include "cmdline.h"
#include "intl.h"
#include "lib.h"
#include "resources.h"
#include "translate.h"
#include "util.h"
#include "ui.h"

#define countof(array) (sizeof(array) / sizeof((array)[0]))

typedef struct amiga_iso_s {
    char *amiga_locale_language;
    char *iso_language_code;
} amiga_iso_t;


                                                                       
static amiga_iso_t amiga_to_iso[] = {
    { "english.language", "en" },
    { "german.language", "de" },
    { "deutsch.language", "de" },
    { "danish.language", "da" },
    { "dansk.language", "da" },
    { "french.language", "fr" },
    { "franais.language", "fr" },
    { "hungarian.language", "hu" },
    { "italian.language", "it" },
    { "italiano.language", "it" },
    { "dutch.language", "nl" },
    { "nederlands.language", "nl" },
    { "polish.language", "pl" },
    { "polski.language", "pl" },
    { "swedish.language", "sv" },
    { "svenska.language", "sv" },
    { "turkish.language", "tr" },
    { NULL, NULL }
};

                                                                                                                

static char *language_table[] = {

             
    "en",

            
    "da",

            
    "de",

            
    "fr",

               
    "hu",

             
    "it",

           
    "nl",

            
    "pl",

             
    "sv",

             
    "tr"
};

                                                                           

typedef struct intl_translate_s {
    int resource_id;
    char *text;
} intl_translate_t;


intl_translate_t intl_string_table[] = {

                                                                          

         { IDMS_FILE,    N_("File") },
         { IDMS_FILE_DA, "Fil" },
         { IDMS_FILE_DE, "Datei" },
         { IDMS_FILE_FR, "Fichier" },
         { IDMS_FILE_HU, "Fjl" },
         { IDMS_FILE_IT, "File" },
         { IDMS_FILE_NL, "Bestand" },
         { IDMS_FILE_PL, "" },             
         { IDMS_FILE_SV, "Arkiv" },
         { IDMS_FILE_TR, "Dosya" },

         { IDMS_AUTOSTART_IMAGE,    N_("Autostart disk/tape image...") },
         { IDMS_AUTOSTART_IMAGE_DA, "Autostart disk-/bndimage..." },
         { IDMS_AUTOSTART_IMAGE_DE, "Autostart Disk/Band Image..." },
         { IDMS_AUTOSTART_IMAGE_FR, "Dmarrage automatique d'une image datassette..." },
         { IDMS_AUTOSTART_IMAGE_HU, "Lemez/szalag kpms automatikus indtsa..." },
         { IDMS_AUTOSTART_IMAGE_IT, "Avvia automaticamente l'immagine di un disco/cassetta..." },
         { IDMS_AUTOSTART_IMAGE_NL, "Autostart schijf-/tapebestand..." },
         { IDMS_AUTOSTART_IMAGE_PL, "" },             
         { IDMS_AUTOSTART_IMAGE_SV, "Autostarta disk-/bandavbildningsfil..." },
         { IDMS_AUTOSTART_IMAGE_TR, "Disk/Teyp imajn otomatik balat..." },

         { IDMS_ATTACH_DISK_IMAGE,    N_("Attach disk image") },
         { IDMS_ATTACH_DISK_IMAGE_DA, "Tilslut disk-image" },
         { IDMS_ATTACH_DISK_IMAGE_DE, "Disk Image einlegen" },
         { IDMS_ATTACH_DISK_IMAGE_FR, "Insrer une image de disque" },
         { IDMS_ATTACH_DISK_IMAGE_HU, "Lemez kpms csatolsa" },
         { IDMS_ATTACH_DISK_IMAGE_IT, "Seleziona l'immagine di un disco" },
         { IDMS_ATTACH_DISK_IMAGE_NL, "Koppel schijfbestand aan" },
         { IDMS_ATTACH_DISK_IMAGE_PL, "" },             
         { IDMS_ATTACH_DISK_IMAGE_SV, "Anslut diskettavbildningsfil" },
         { IDMS_ATTACH_DISK_IMAGE_TR, "Disk imajn yerletir" },

         {IDMS_DRIVE_8,    N_("Drive 8") },
         { IDMS_DRIVE_8_DA, "Drev 8" },
         { IDMS_DRIVE_8_DE, "Laufwerk 8" },
         { IDMS_DRIVE_8_FR, "Lecteur #8" },
         { IDMS_DRIVE_8_HU, "#8-as lemezegysg" },
         { IDMS_DRIVE_8_IT, "Drive 8" },
         { IDMS_DRIVE_8_NL, "Drive 8" },
         { IDMS_DRIVE_8_PL, "" },             
         { IDMS_DRIVE_8_SV, "Enhet 8" },
         { IDMS_DRIVE_8_TR, "Src 8" },

         { IDMS_DRIVE_9,    N_("Drive 9") },
         { IDMS_DRIVE_9_DA, "Drev 9" },
         { IDMS_DRIVE_9_DE, "Laufwerk 9" },
         { IDMS_DRIVE_9_FR, "Lecteur #9" },
         { IDMS_DRIVE_9_HU, "#9-es lemezegysg" },
         { IDMS_DRIVE_9_IT, "Drive 9" },
         { IDMS_DRIVE_9_NL, "Drive 9" },
         { IDMS_DRIVE_9_PL, "" },             
         { IDMS_DRIVE_9_SV, "Enhet 9" },
         { IDMS_DRIVE_9_TR, "Src 9" },

         { IDMS_DRIVE_10,    N_("Drive 10") },
         { IDMS_DRIVE_10_DA, "Drev 10" },
         { IDMS_DRIVE_10_DE, "Laufwerk 10" },
         { IDMS_DRIVE_10_FR, "Lecteur #10" },
         { IDMS_DRIVE_10_HU, "#10-es lemezegysg" },
         { IDMS_DRIVE_10_IT, "Drive 10" },
         { IDMS_DRIVE_10_NL, "Drive 10" },
         { IDMS_DRIVE_10_PL, "" },             
         { IDMS_DRIVE_10_SV, "Enhet 10" },
         { IDMS_DRIVE_10_TR, "Src 10" },

         { IDMS_DRIVE_11,    N_("Drive 11") },
         { IDMS_DRIVE_11_DA, "Drev 11" },
         { IDMS_DRIVE_11_DE, "Laufwerk 11" },
         { IDMS_DRIVE_11_FR, "Lecteur #11" },
         { IDMS_DRIVE_11_HU, "#11-es lemezegysg" },
         { IDMS_DRIVE_11_IT, "Drive 11" },
         { IDMS_DRIVE_11_NL, "Drive 11" },
         { IDMS_DRIVE_11_PL, "" },             
         { IDMS_DRIVE_11_SV, "Enhet 11" },
         { IDMS_DRIVE_11_TR, "Src 11" },

         { IDMS_DETACH_DISK_IMAGE,    N_("Detach disk image") },
         { IDMS_DETACH_DISK_IMAGE_DA, "Frakobl disk-image" },
         { IDMS_DETACH_DISK_IMAGE_DE, "Disk Image entfernen" },
         { IDMS_DETACH_DISK_IMAGE_FR, "Retirer une image de disque" },
         { IDMS_DETACH_DISK_IMAGE_HU, "Lemezkpms levlasztsa" },
         { IDMS_DETACH_DISK_IMAGE_IT, "Rimuovi un immagine disco" },
         { IDMS_DETACH_DISK_IMAGE_NL, "Ontkoppel disk bestand" },
         { IDMS_DETACH_DISK_IMAGE_PL, "" },             
         { IDMS_DETACH_DISK_IMAGE_SV, "Koppla frn diskettavbildningsfil" },
         { IDMS_DETACH_DISK_IMAGE_TR, "Disk imajn kart" },

         { IDMS_ALL,    N_("All") },
         { IDMS_ALL_DA, "Alle" },
         { IDMS_ALL_DE, "Alle" },
         { IDMS_ALL_FR, "Tout" },
         { IDMS_ALL_HU, "sszes" },
         { IDMS_ALL_IT, "Tutti" },
         { IDMS_ALL_NL, "Alles" },
         { IDMS_ALL_PL, "" },             
         { IDMS_ALL_SV, "Alla" },
         { IDMS_ALL_TR, "Tm" },

         { IDMS_FLIP_LIST,    N_("Flip list") },
         { IDMS_FLIP_LIST_DA, "Bladreliste" },
         { IDMS_FLIP_LIST_DE, "Flipliste" },
         { IDMS_FLIP_LIST_FR, "Groupement de disques" },
         { IDMS_FLIP_LIST_HU, "Lemezlista" },
         { IDMS_FLIP_LIST_IT, "Flip list" },
         { IDMS_FLIP_LIST_NL, "Flip lijst" },
         { IDMS_FLIP_LIST_PL, "" },             
         { IDMS_FLIP_LIST_SV, "Vallista" },
         { IDMS_FLIP_LIST_TR, "Sralama listesi" },

         { IDMS_ADD_CURRENT_IMAGE,    N_("Add current image") },
         { IDMS_ADD_CURRENT_IMAGE_DA, "Tilfj aktuelt image" },
         { IDMS_ADD_CURRENT_IMAGE_DE, "Aktuelles Image hinzufgen" },
         { IDMS_ADD_CURRENT_IMAGE_FR, "Ajouter l'image de disque courante" },
         { IDMS_ADD_CURRENT_IMAGE_HU, "Az aktulis kpms hozzadsa" },
         { IDMS_ADD_CURRENT_IMAGE_IT, "Aggiungi l'immagine attuale" },
         { IDMS_ADD_CURRENT_IMAGE_NL, "Voeg huidig bestand toe" },
         { IDMS_ADD_CURRENT_IMAGE_PL, "" },             
         { IDMS_ADD_CURRENT_IMAGE_SV, "Lgg till aktuell avbildning" },
         { IDMS_ADD_CURRENT_IMAGE_TR, "Geerli imaj ekle" },

         { IDMS_REMOVE_CURRENT_IMAGE,    N_("Remove current image") },
         { IDMS_REMOVE_CURRENT_IMAGE_DA, "Fjern aktuelt image" },
         { IDMS_REMOVE_CURRENT_IMAGE_DE, "Aktuelles Image entfernen" },
         { IDMS_REMOVE_CURRENT_IMAGE_FR, "Retirer l'image de disque courante" },
         { IDMS_REMOVE_CURRENT_IMAGE_HU, "Az aktulis kpms eltvoltsa" },
         { IDMS_REMOVE_CURRENT_IMAGE_IT, "Rimuovi l'immagine attuale" },
         { IDMS_REMOVE_CURRENT_IMAGE_NL, "Verwijder huidig bestand" },
         { IDMS_REMOVE_CURRENT_IMAGE_PL, "" },             
         { IDMS_REMOVE_CURRENT_IMAGE_SV, "Ta bort aktuell avbildning" },
         { IDMS_REMOVE_CURRENT_IMAGE_TR, "Geerli imaj kart" },

         { IDMS_ATTACH_NEXT_IMAGE,    N_("Attach next image") },
         { IDMS_ATTACH_NEXT_IMAGE_DA, "Tilslut nste image" },
         { IDMS_ATTACH_NEXT_IMAGE_DE, "Nchstes Image" },
         { IDMS_ATTACH_NEXT_IMAGE_FR, "Insrer la prochaine image" },
         { IDMS_ATTACH_NEXT_IMAGE_HU, "Kvetkez kpms csatolsa" },
         { IDMS_ATTACH_NEXT_IMAGE_IT, "Seleziona l'immagine successiva" },
         { IDMS_ATTACH_NEXT_IMAGE_NL, "Koppel volgend bestand" },
         { IDMS_ATTACH_NEXT_IMAGE_PL, "" },             
         { IDMS_ATTACH_NEXT_IMAGE_SV, "Anslut nsta avbildning" },
         { IDMS_ATTACH_NEXT_IMAGE_TR, "Sonraki imaj yerletir" },

         { IDMS_ATTACH_PREVIOUS_IMAGE,    N_("Attach previous image") },
         { IDMS_ATTACH_PREVIOUS_IMAGE_DA, "Tilslut forrige image" },
         { IDMS_ATTACH_PREVIOUS_IMAGE_DE, "Voriges Image" },
         { IDMS_ATTACH_PREVIOUS_IMAGE_FR, "Insrer l'image prcdente" },
         { IDMS_ATTACH_PREVIOUS_IMAGE_HU, "Elz kpms csatolsa" },
         { IDMS_ATTACH_PREVIOUS_IMAGE_IT, "Seleziona l'immagine precedente" },
         { IDMS_ATTACH_PREVIOUS_IMAGE_NL, "Koppel vorig bestand" },
         { IDMS_ATTACH_PREVIOUS_IMAGE_PL, "" },             
         { IDMS_ATTACH_PREVIOUS_IMAGE_SV, "Anslut fregende avbildning" },
         { IDMS_ATTACH_PREVIOUS_IMAGE_TR, "nceki imaj yerletir" },

         { IDMS_LOAD_FLIP_LIST,    N_("Load flip list") },
         { IDMS_LOAD_FLIP_LIST_DA, "Indls bladreliste" },
         { IDMS_LOAD_FLIP_LIST_DE, "Fliplist Datei Laden" },
         { IDMS_LOAD_FLIP_LIST_FR, "Charger un groupement de disques" },
         { IDMS_LOAD_FLIP_LIST_HU, "Lemezlista betltse" },
         { IDMS_LOAD_FLIP_LIST_IT, "Carica flip list" },
         { IDMS_LOAD_FLIP_LIST_NL, "Laad fliplijst" },
         { IDMS_LOAD_FLIP_LIST_PL, "" },             
         { IDMS_LOAD_FLIP_LIST_SV, "Ls in vallistefil" },
         { IDMS_LOAD_FLIP_LIST_TR, "Sralama listesi ykle" },

         { IDMS_SAVE_FLIP_LIST,    N_("Save flip list") },
         { IDMS_SAVE_FLIP_LIST_DA, "Gem bladreliste" },
         { IDMS_SAVE_FLIP_LIST_DE, "Fliplist Datei Speichern" },
         { IDMS_SAVE_FLIP_LIST_FR, "Enregistrer le groupement de disques" },
         { IDMS_SAVE_FLIP_LIST_HU, "Lemezlista mentse" },
         { IDMS_SAVE_FLIP_LIST_IT, "Salva fliplist" },
         { IDMS_SAVE_FLIP_LIST_NL, "Opslaan fliplijst" },
         { IDMS_SAVE_FLIP_LIST_PL, "" },             
         { IDMS_SAVE_FLIP_LIST_SV, "Spara vallistefil" },
         { IDMS_SAVE_FLIP_LIST_TR, "Sralama listesi kaydet" },

         { IDMS_ATTACH_TAPE_IMAGE,    N_("Attach tape image...") },
         { IDMS_ATTACH_TAPE_IMAGE_DA, "Tilslut bnd-image..." },
         { IDMS_ATTACH_TAPE_IMAGE_DE, "Band Image einlegen..." },
         { IDMS_ATTACH_TAPE_IMAGE_FR, "Insrer une image datassette..." },
         { IDMS_ATTACH_TAPE_IMAGE_HU, "Szalag kpms csatolsa..." },
         { IDMS_ATTACH_TAPE_IMAGE_IT, "Seleziona l'immagine di una cassetta..." },
         { IDMS_ATTACH_TAPE_IMAGE_NL, "Koppel tapebestand..." },
         { IDMS_ATTACH_TAPE_IMAGE_PL, "" },             
         { IDMS_ATTACH_TAPE_IMAGE_SV, "Anslut en bandavbildningsfil..." },
         { IDMS_ATTACH_TAPE_IMAGE_TR, "Teyp imaj yerletir..." },

         { IDMS_DETACH_TAPE_IMAGE,    N_("Detach tape image") },
         { IDMS_DETACH_TAPE_IMAGE_DA, "Frakobl bnd-image" },
         { IDMS_DETACH_TAPE_IMAGE_DE, "Band Image entfernen" },
         { IDMS_DETACH_TAPE_IMAGE_FR, "Retirer une image datassette" },
         { IDMS_DETACH_TAPE_IMAGE_HU, "Szalag kpms levlasztsa" },
         { IDMS_DETACH_TAPE_IMAGE_IT, "Rimuovi immagine cassetta" },
         { IDMS_DETACH_TAPE_IMAGE_NL, "Ontkoppel tape image" },
         { IDMS_DETACH_TAPE_IMAGE_PL, "" },             
         { IDMS_DETACH_TAPE_IMAGE_SV, "Koppla frn bandavbildningsfil" },
         { IDMS_DETACH_TAPE_IMAGE_TR, "Teyp imajn kart" },

         { IDMS_DATASSETTE_CONTROL,    N_("Datassette control") },
         { IDMS_DATASSETTE_CONTROL_DA, "Datasettestyring" },
         { IDMS_DATASSETTE_CONTROL_DE, "Bandlaufwerk Kontrolle" },
         { IDMS_DATASSETTE_CONTROL_FR, "Contrle datassette" },
         { IDMS_DATASSETTE_CONTROL_HU, "Magn vezrls" },
         { IDMS_DATASSETTE_CONTROL_IT, "Controlli del registratore" },
         { IDMS_DATASSETTE_CONTROL_NL, "Datassette bediening" },
         { IDMS_DATASSETTE_CONTROL_PL, "" },             
         { IDMS_DATASSETTE_CONTROL_SV, "Datasettestyrning" },
         { IDMS_DATASSETTE_CONTROL_TR, "Teyp kontrol" },

         { IDMS_STOP,    N_("Stop") },
         { IDMS_STOP_DA, "Stop" },
         { IDMS_STOP_DE, "Stop" },
         { IDMS_STOP_FR, "Arrt" },
         { IDMS_STOP_HU, "Lellts" },
         { IDMS_STOP_IT, "Stop" },
         { IDMS_STOP_NL, "Stop" },
         { IDMS_STOP_PL, "" },             
         { IDMS_STOP_SV, "Stoppa" },
         { IDMS_STOP_TR, "Dur" },

         { IDMS_START,    N_("Start") },
         { IDMS_START_DA, "Start" },
         { IDMS_START_DE, "Start" },
         { IDMS_START_FR, "Dmarrer" },
         { IDMS_START_HU, "Indts" },
         { IDMS_START_IT, "Avvia" },
         { IDMS_START_NL, "Start" },
         { IDMS_START_PL, "" },             
         { IDMS_START_SV, "Starta" },
         { IDMS_START_TR, "Balat" },

         { IDMS_FORWARD,    N_("Forward") },
         { IDMS_FORWARD_DA, "Spol frem" },
         { IDMS_FORWARD_DE, "Forward" },
         { IDMS_FORWARD_FR, "En avant" },
         { IDMS_FORWARD_HU, "Elrecsvls" },
         { IDMS_FORWARD_IT, "Avanti" },
         { IDMS_FORWARD_NL, "Vooruit" },
         { IDMS_FORWARD_PL, "" },             
         { IDMS_FORWARD_SV, "Spola framt" },
         { IDMS_FORWARD_TR, "leri" },

         { IDMS_REWIND,    N_("Rewind") },
         { IDMS_REWIND_DA, "Spol tilbage" },
         { IDMS_REWIND_DE, "Rewind" },
         { IDMS_REWIND_FR, "En arrire" },
         { IDMS_REWIND_HU, "Visszacsvls" },
         { IDMS_REWIND_IT, "Indietro" },
         { IDMS_REWIND_NL, "Terug" },
         { IDMS_REWIND_PL, "" },             
         { IDMS_REWIND_SV, "Spola bakt" },
         { IDMS_REWIND_TR, "Geri" },

         { IDMS_RECORD,    N_("Record") },
         { IDMS_RECORD_DA, "Optag" },
         { IDMS_RECORD_DE, "Record" },
         { IDMS_RECORD_FR, "Enregistrer" },
         { IDMS_RECORD_HU, "Felvtel" },
         { IDMS_RECORD_IT, "Registra" },
         { IDMS_RECORD_NL, "Opname" },
         { IDMS_RECORD_PL, "" },             
         { IDMS_RECORD_SV, "Spela in" },
         { IDMS_RECORD_TR, "Kayt" },

         { IDMS_RESET,    N_("Reset") },
         { IDMS_RESET_DA, "Reset" },
         { IDMS_RESET_DE, "Reset" },
         { IDMS_RESET_FR, "Rinitialiser" },
         { IDMS_RESET_HU, "Reset" },
         { IDMS_RESET_IT, "Reset" },
         { IDMS_RESET_NL, "Reset" },
         { IDMS_RESET_PL, "" },             
         { IDMS_RESET_SV, "Nollstll" },
         { IDMS_RESET_TR, "Reset" },

         { IDMS_RESET_COUNTER,    N_("Reset Counter") },
         { IDMS_RESET_COUNTER_DA, "Nulstil tller" },
         { IDMS_RESET_COUNTER_DE, "Zhler zurcksetzen" },
         { IDMS_RESET_COUNTER_FR, "Rinialiser le compteur" },
         { IDMS_RESET_COUNTER_HU, "Szmll nullzsa" },
         { IDMS_RESET_COUNTER_IT, "Reset contantore" },
         { IDMS_RESET_COUNTER_NL, "Reset teller" },
         { IDMS_RESET_COUNTER_PL, "" },             
         { IDMS_RESET_COUNTER_SV, "Nollstll rknare" },
         { IDMS_RESET_COUNTER_TR, "Sayac Resetle" },

         { IDMS_ATTACH_CART_IMAGE,    N_("Attach cartridge image...") },
         { IDMS_ATTACH_CART_IMAGE_DA, "Tilslut cartridge-image..." },
         { IDMS_ATTACH_CART_IMAGE_DE, "Erweiterungsmodule einlegen..." },
         { IDMS_ATTACH_CART_IMAGE_FR, "Insrer une cartouche..." },
         { IDMS_ATTACH_CART_IMAGE_HU, "Cartridge kpms csatolsa..." },
         { IDMS_ATTACH_CART_IMAGE_IT, "Seleziona l'immagine di una cartuccia..." },
         { IDMS_ATTACH_CART_IMAGE_NL, "Koppel cartridgebestand..." },
         { IDMS_ATTACH_CART_IMAGE_PL, "" },             
         { IDMS_ATTACH_CART_IMAGE_SV, "Anslut insticksmodulfil..." },
         { IDMS_ATTACH_CART_IMAGE_TR, "Kartu imaj yerletir..." },

         { IDMS_GENERIC_IMAGE,    N_("Generic image...") },
         { IDMS_GENERIC_IMAGE_DA, "" },             
         { IDMS_GENERIC_IMAGE_DE, "Generisches Image..." },
         { IDMS_GENERIC_IMAGE_FR, "" },             
         { IDMS_GENERIC_IMAGE_HU, "" },             
         { IDMS_GENERIC_IMAGE_IT, "Immagine generica..." },
         { IDMS_GENERIC_IMAGE_NL, "Algemeen bestand..." },
         { IDMS_GENERIC_IMAGE_PL, "" },             
         { IDMS_GENERIC_IMAGE_SV, "Generisk avbild..." },
         { IDMS_GENERIC_IMAGE_TR, "Jenerik imaj..." },

         { IDMS_MEGA_CART_IMAGE,    N_("Mega-Cart image...") },
         { IDMS_MEGA_CART_IMAGE_DA, "" },             
         { IDMS_MEGA_CART_IMAGE_DE, "Mega-Cart Image..." },
         { IDMS_MEGA_CART_IMAGE_FR, "" },             
         { IDMS_MEGA_CART_IMAGE_HU, "" },             
         { IDMS_MEGA_CART_IMAGE_IT, "Immagine Mega-Cart..." },
         { IDMS_MEGA_CART_IMAGE_NL, "Mega-Cart bestand..." },
         { IDMS_MEGA_CART_IMAGE_PL, "" },             
         { IDMS_MEGA_CART_IMAGE_SV, "Mega-Cart-avbildning..." },
         { IDMS_MEGA_CART_IMAGE_TR, "Mega-Cart imaj..." },

         { IDMS_FINAL_EXPANSION_IMAGE,    N_("Final Expansion image...") },
         { IDMS_FINAL_EXPANSION_IMAGE_DA, "" },             
         { IDMS_FINAL_EXPANSION_IMAGE_DE, "Final Expansion Image..." },
         { IDMS_FINAL_EXPANSION_IMAGE_FR, "" },             
         { IDMS_FINAL_EXPANSION_IMAGE_HU, "" },             
         { IDMS_FINAL_EXPANSION_IMAGE_IT, "Immagine Final Expansion..." },
         { IDMS_FINAL_EXPANSION_IMAGE_NL, "Final Expansion bestand..." },
         { IDMS_FINAL_EXPANSION_IMAGE_PL, "" },             
         { IDMS_FINAL_EXPANSION_IMAGE_SV, "Final Expansion-fil..." },
         { IDMS_FINAL_EXPANSION_IMAGE_TR, "Final Expansion imaj..." },

         { IDMS_ADD_TO_GENERIC,    N_("Add to generic...") },
         { IDMS_ADD_TO_GENERIC_DA, "" },             
         { IDMS_ADD_TO_GENERIC_DE, "Zu Universal Image hinzufgen..." },
         { IDMS_ADD_TO_GENERIC_FR, "" },             
         { IDMS_ADD_TO_GENERIC_HU, "" },             
         { IDMS_ADD_TO_GENERIC_IT, "Aggiungi a generica..." },
         { IDMS_ADD_TO_GENERIC_NL, "Voeg toe aan algemeen..." },
         { IDMS_ADD_TO_GENERIC_PL, "" },             
         { IDMS_ADD_TO_GENERIC_SV, "Lgg till generisk.." },
         { IDMS_ADD_TO_GENERIC_TR, "Jenerie ekle..." },

         { IDMS_SMART_ATTACH_IMAGE,    N_("Smart-attach image...") },
         { IDMS_SMART_ATTACH_IMAGE_DA, "" },             
         { IDMS_SMART_ATTACH_IMAGE_DE, "Smart-Einlegen Image Date..." },
         { IDMS_SMART_ATTACH_IMAGE_FR, "" },             
         { IDMS_SMART_ATTACH_IMAGE_HU, "" },             
         { IDMS_SMART_ATTACH_IMAGE_IT, "Immagine Smart-attach..." },
         { IDMS_SMART_ATTACH_IMAGE_NL, "Slimme koppeling van bestand..." },
         { IDMS_SMART_ATTACH_IMAGE_PL, "" },             
         { IDMS_SMART_ATTACH_IMAGE_SV, "Smartanslut avbildning..." },
         { IDMS_SMART_ATTACH_IMAGE_TR, "Smart-attach imaj..." },

         { IDMS_4_8_16KB_AT_2000,    N_("4/8/16KB image at $2000...") },
         { IDMS_4_8_16KB_AT_2000_DA, "4/8/16KB-image p $2000..." },
         { IDMS_4_8_16KB_AT_2000_DE, "4/8/16KB Modul Image bei $2000..." },
         { IDMS_4_8_16KB_AT_2000_FR, "Insertion d'une image 4/8/16Ko  $2000..." },
         { IDMS_4_8_16KB_AT_2000_HU, "4/8/16KB kpms $2000 cmen..." },
         { IDMS_4_8_16KB_AT_2000_IT, "Immagine di 4/8/16KB a $2000..." },
         { IDMS_4_8_16KB_AT_2000_NL, "4/8/16KB-bestand in $2000..." },
         { IDMS_4_8_16KB_AT_2000_PL, "" },             
         { IDMS_4_8_16KB_AT_2000_SV, "4/8/16KB-fil vid $2000..." },
         { IDMS_4_8_16KB_AT_2000_TR, "4/8/16KB imaj $2000 adresinde..." },

         { IDMS_4_8_16KB_AT_4000,    N_("4/8/16KB image at $4000...") },
         { IDMS_4_8_16KB_AT_4000_DA, "4/8/16KB-image p $4000..." },
         { IDMS_4_8_16KB_AT_4000_DE, "4/8/16KB Modul Image bei $4000..." },
         { IDMS_4_8_16KB_AT_4000_FR, "Insertion d'une image 4/8/16Ko  $4000..." },
         { IDMS_4_8_16KB_AT_4000_HU, "4/8/16KB kpms $4000 cmen..." },
         { IDMS_4_8_16KB_AT_4000_IT, "Immagine di 4/8/16KB a $4000..." },
         { IDMS_4_8_16KB_AT_4000_NL, "4/8/16KB-bestand in $4000..." },
         { IDMS_4_8_16KB_AT_4000_PL, "" },             
         { IDMS_4_8_16KB_AT_4000_SV, "4/8/16KB-fil vid $4000..." },
         { IDMS_4_8_16KB_AT_4000_TR, "4/8/16KB imaj $4000 adresinde..." },

         { IDMS_4_8_16KB_AT_6000,    N_("4/8/16KB image at $6000...") },
         { IDMS_4_8_16KB_AT_6000_DA, "4/8/16KB-image p $6000..." },
         { IDMS_4_8_16KB_AT_6000_DE, "4/8/16KB Modul Image bei $6000..." },
         { IDMS_4_8_16KB_AT_6000_FR, "Insertion d'une image 4/8/16Ko  $6000..." },
         { IDMS_4_8_16KB_AT_6000_HU, "4/8/16KB kpms $6000 cmen..." },
         { IDMS_4_8_16KB_AT_6000_IT, "Immagine di 4/8/16KB a $6000..." },
         { IDMS_4_8_16KB_AT_6000_NL, "4/8/16KB-bestand in $6000..." },
         { IDMS_4_8_16KB_AT_6000_PL, "" },             
         { IDMS_4_8_16KB_AT_6000_SV, "4/8/16KB-fil vid $6000..." },
         { IDMS_4_8_16KB_AT_6000_TR, "4/8/16KB imaj $6000 adresinde..." },

         { IDMS_4_8KB_AT_A000,    N_("4/8KB image at $A000...") },
         { IDMS_4_8KB_AT_A000_DA, "4/8KB-image p $A000..." },
         { IDMS_4_8KB_AT_A000_DE, "4/8KB Modul Image bei $A000..." },
         { IDMS_4_8KB_AT_A000_FR, "Insertion d'une image 4/8Ko  $A000..." },
         { IDMS_4_8KB_AT_A000_HU, "4/8KB kpms $A000 cmen..." },
         { IDMS_4_8KB_AT_A000_IT, "Immagine di 4/8KB a $A000..." },
         { IDMS_4_8KB_AT_A000_NL, "4/8KB-bestand in $A000..." },
         { IDMS_4_8KB_AT_A000_PL, "" },             
         { IDMS_4_8KB_AT_A000_SV, "4/8KB-fil vid $A000..." },
         { IDMS_4_8KB_AT_A000_TR, "4/8KB imaj $A000 adresinde..." },

         { IDMS_4KB_AT_B000,    N_("4KB image at $B000...") },
         { IDMS_4KB_AT_B000_DA, "4KB-image p $B000..." },
         { IDMS_4KB_AT_B000_DE, "4KB Modul Image bei $B000..." },
         { IDMS_4KB_AT_B000_FR, "Insertion d'une image 4Ko  $B000..." },
         { IDMS_4KB_AT_B000_IT, "Immagine di 4KB a $B000..." },
         { IDMS_4KB_AT_B000_HU, "4KB kpms $B000 cmen..." },
         { IDMS_4KB_AT_B000_NL, "4KB-bestand in $&B000..." },
         { IDMS_4KB_AT_B000_PL, "" },             
         { IDMS_4KB_AT_B000_SV, "4KB-fil vid $B000..." },
         { IDMS_4KB_AT_B000_TR, "4KB imaj $B000 adresinde..." },

         { IDMS_DETACH_CART_IMAGE,    N_("Detach cartridge image") },
         { IDMS_DETACH_CART_IMAGE_DA, "Frakobl cartridge-image" },
         { IDMS_DETACH_CART_IMAGE_DE, "Erweiterungsmodul Image entfernen" },
         { IDMS_DETACH_CART_IMAGE_FR, "Retirer une cartouche" },
         { IDMS_DETACH_CART_IMAGE_HU, "Cartridge kpms levlasztsa" },
         { IDMS_DETACH_CART_IMAGE_IT, "Rimuovi immagine cartuccia" },
         { IDMS_DETACH_CART_IMAGE_NL, "Ontkoppel cartridgebestand" },
         { IDMS_DETACH_CART_IMAGE_PL, "" },             
         { IDMS_DETACH_CART_IMAGE_SV, "Koppla frn insticksmodulfil" },
         { IDMS_DETACH_CART_IMAGE_TR, "Kartu imajn kart" },

         { IDMS_C1_LOW_IMAGE,    N_("C1 low  image...") },
         { IDMS_C1_LOW_IMAGE_DA, "C1 lav-image..." },
         { IDMS_C1_LOW_IMAGE_DE, "C1 low Image Datei..." },
         { IDMS_C1_LOW_IMAGE_FR, "Image C1 basse..." },
         { IDMS_C1_LOW_IMAGE_HU, "C1 als kpms..." },
         { IDMS_C1_LOW_IMAGE_IT, "Immagine nell'area bassa di C1..." },
         { IDMS_C1_LOW_IMAGE_NL, "C1 low-bestand..." },
         { IDMS_C1_LOW_IMAGE_PL, "" },             
         { IDMS_C1_LOW_IMAGE_SV, "C1 lg-avbildning..." },
         { IDMS_C1_LOW_IMAGE_TR, "C1 low imaj..." },

         { IDMS_C1_HIGH_IMAGE,    N_("C1 high image...") },
         { IDMS_C1_HIGH_IMAGE_DA, "C1 hj-image..." },
         { IDMS_C1_HIGH_IMAGE_DE, "C1 high Image Datei..." },
         { IDMS_C1_HIGH_IMAGE_FR, "Image C1 haute..." },
         { IDMS_C1_HIGH_IMAGE_HU, "C1 fels kpms..." },
         { IDMS_C1_HIGH_IMAGE_IT, "Immagine nell'area alta di C1..." },
         { IDMS_C1_HIGH_IMAGE_NL, "C1 high-bestand..." },
         { IDMS_C1_HIGH_IMAGE_PL, "" },             
         { IDMS_C1_HIGH_IMAGE_SV, "C1 hg-avbildning..." },
         { IDMS_C1_HIGH_IMAGE_TR, "C1 high imaj..." },

         { IDMS_C2_LOW_IMAGE,    N_("C2 low  image...") },
         { IDMS_C2_LOW_IMAGE_DA, "C2 lav-image..." },
         { IDMS_C2_LOW_IMAGE_DE, "C2 low Image Datei..." },
         { IDMS_C2_LOW_IMAGE_FR, "Image C2 basse..." },
         { IDMS_C2_LOW_IMAGE_IT, "Immagine nell'area bassa di C2..." },
         { IDMS_C2_LOW_IMAGE_HU, "C2 als kpms..." },
         { IDMS_C2_LOW_IMAGE_NL, "C2 low-bestand..." },
         { IDMS_C2_LOW_IMAGE_PL, "" },             
         { IDMS_C2_LOW_IMAGE_SV, "C2 lg-avbildning..." },
         { IDMS_C2_LOW_IMAGE_TR, "C2 low imaj..." },

         { IDMS_C2_HIGH_IMAGE,    N_("C2 high image...") },
         { IDMS_C2_HIGH_IMAGE_DA, "C2 hj-image..." },
         { IDMS_C2_HIGH_IMAGE_DE, "C2 high Image Datei..." },
         { IDMS_C2_HIGH_IMAGE_FR, "Image C2 haute..." },
         { IDMS_C2_HIGH_IMAGE_HU, "C2 fels kpms..." },
         { IDMS_C2_HIGH_IMAGE_IT, "Immagine nell'area alta di C2..." },
         { IDMS_C2_HIGH_IMAGE_NL, "C2 high-bestand..." },
         { IDMS_C2_HIGH_IMAGE_PL, "" },             
         { IDMS_C2_HIGH_IMAGE_SV, "C2 hg-avbildning..." },
         { IDMS_C2_HIGH_IMAGE_TR, "C2 high imaj..." },

         { IDMS_FUNCTION_LOW_3PLUS1,    N_("Function low  image (3plus1)...") },
         { IDMS_FUNCTION_LOW_3PLUS1_DA, "Funktion lav-image (3plus1)..." },
         { IDMS_FUNCTION_LOW_3PLUS1_DE, "Funktions ROM Image Datei low (3plus1)..." },
         { IDMS_FUNCTION_LOW_3PLUS1_FR, "Image Fonction basse (3+1)..." },
         { IDMS_FUNCTION_LOW_3PLUS1_HU, "Function als kpms (3plus1)..." },
         { IDMS_FUNCTION_LOW_3PLUS1_IT, "Function (3plus1) caricata nella memoria bassa..." },
         { IDMS_FUNCTION_LOW_3PLUS1_NL, "Function low-bestand (3plus1)..." },
         { IDMS_FUNCTION_LOW_3PLUS1_PL, "" },             
         { IDMS_FUNCTION_LOW_3PLUS1_SV, "Funktion lg-avbildning (3plus1)..." },
         { IDMS_FUNCTION_LOW_3PLUS1_TR, "Function low  imaj (3plus1)..." },

         { IDMS_FUNCTION_HIGH_3PLUS1,    N_("Function high image (3plus1)...") },
         { IDMS_FUNCTION_HIGH_3PLUS1_DA, "Funktion hj-image (3plus1)..." },
         { IDMS_FUNCTION_HIGH_3PLUS1_DE, "Funktions ROM Image Datei high (3plus1)..." },
         { IDMS_FUNCTION_HIGH_3PLUS1_FR, "Image Fonction haute (3+1)..." },
         { IDMS_FUNCTION_HIGH_3PLUS1_HU, "Function fels kpms (3plus1)..." },
         { IDMS_FUNCTION_HIGH_3PLUS1_IT, "Function (3plus1) caricata nella memoria alta..." },
         { IDMS_FUNCTION_HIGH_3PLUS1_NL, "Function high-bestand (3plus1)..." },
         { IDMS_FUNCTION_HIGH_3PLUS1_PL, "" },             
         { IDMS_FUNCTION_HIGH_3PLUS1_SV, "Funktion hg-avbildning (3plus1)..." },
         { IDMS_FUNCTION_HIGH_3PLUS1_TR, "Function high imaj (3plus1)..." },

         { IDMS_CRT_IMAGE,    N_("CRT image...") },
         { IDMS_CRT_IMAGE_DA, "CRT-fil..." },
         { IDMS_CRT_IMAGE_DE, "CRT Image Datei..." },
         { IDMS_CRT_IMAGE_FR, "Nom du fichier image CRT..." },
         { IDMS_CRT_IMAGE_HU, "CRT kpms..." },
         { IDMS_CRT_IMAGE_IT, "Immagine CRT..." },
         { IDMS_CRT_IMAGE_NL, "CRT-bestand..." },
         { IDMS_CRT_IMAGE_PL, "" },             
         { IDMS_CRT_IMAGE_SV, "CRT-fil..." },
         { IDMS_CRT_IMAGE_TR, "CRT imaj..." },

         { IDMS_GENERIC_8KB_IMAGE,    N_("Generic 8KB image...") },
         { IDMS_GENERIC_8KB_IMAGE_DA, "Standard 8KB-image..." },
         { IDMS_GENERIC_8KB_IMAGE_DE, "Generische 8Kb Image..." },
         { IDMS_GENERIC_8KB_IMAGE_FR, "Insrer une image gnrique de 8Ko..." },
         { IDMS_GENERIC_8KB_IMAGE_HU, "ltalnos 8KB kpms..." },
         { IDMS_GENERIC_8KB_IMAGE_IT, "Immagine generica di 8KB..." },
         { IDMS_GENERIC_8KB_IMAGE_NL, "Algemeen 8KB-bestand..." },
         { IDMS_GENERIC_8KB_IMAGE_PL, "" },             
         { IDMS_GENERIC_8KB_IMAGE_SV, "Vanlig 8KB-fil..." },
         { IDMS_GENERIC_8KB_IMAGE_TR, "8KB Jenerik imaj..." },

         { IDMS_GENERIC_16KB_IMAGE,    N_("Generic 16KB image...") },
         { IDMS_GENERIC_16KB_IMAGE_DA, "Standard 16KB-image..." },
         { IDMS_GENERIC_16KB_IMAGE_DE, "Generische 16Kb Image..." },
         { IDMS_GENERIC_16KB_IMAGE_FR, "Insrer une image gnrique de 16Ko..." },
         { IDMS_GENERIC_16KB_IMAGE_HU, "ltalnos 16KB kpms..." },
         { IDMS_GENERIC_16KB_IMAGE_IT, "Immagine generica di 16KB..." },
         { IDMS_GENERIC_16KB_IMAGE_NL, "Algemeen 16KB-bestand..." },
         { IDMS_GENERIC_16KB_IMAGE_PL, "" },             
         { IDMS_GENERIC_16KB_IMAGE_SV, "Vanlig 16KB-fil..." },
         { IDMS_GENERIC_16KB_IMAGE_TR, "16KB Jenerik imaj..." },

         { IDMS_ACTION_REPLAY_IMAGE,    N_("Action Replay image...") },
         { IDMS_ACTION_REPLAY_IMAGE_DA, "Action Replay-image..." },
         { IDMS_ACTION_REPLAY_IMAGE_DE, "Action Replay Image..." },
         { IDMS_ACTION_REPLAY_IMAGE_FR, "Insrer une cartouche Action Replay..." },
         { IDMS_ACTION_REPLAY_IMAGE_HU, "Action Replay kpms..." },
         { IDMS_ACTION_REPLAY_IMAGE_IT, "Immagine Action Replay..." },
         { IDMS_ACTION_REPLAY_IMAGE_NL, "Action Replay-bestand..." },
         { IDMS_ACTION_REPLAY_IMAGE_PL, "" },             
         { IDMS_ACTION_REPLAY_IMAGE_SV, "Action Replay-fil..." },
         { IDMS_ACTION_REPLAY_IMAGE_TR, "Action Replay imaj..." },

         { IDMS_ACTION_REPLAY3_IMAGE,    N_("Action Replay 3 image...") },
         { IDMS_ACTION_REPLAY3_IMAGE_DA, "Action Replay 3-image..." },
         { IDMS_ACTION_REPLAY3_IMAGE_DE, "Action Replay 3 Image..." },
         { IDMS_ACTION_REPLAY3_IMAGE_FR, "Insrer une cartouche Action Replay 3..." },
         { IDMS_ACTION_REPLAY3_IMAGE_HU, "Action Replay 3 kpms..." },
         { IDMS_ACTION_REPLAY3_IMAGE_IT, "Immagine Action Replay 3..." },
         { IDMS_ACTION_REPLAY3_IMAGE_NL, "Action Replay 3 bestand..." },
         { IDMS_ACTION_REPLAY3_IMAGE_PL, "" },             
         { IDMS_ACTION_REPLAY3_IMAGE_SV, "Action Replay 3-fil..." },
         { IDMS_ACTION_REPLAY3_IMAGE_TR, "Action Replay 3 imaj..." },

         { IDMS_ACTION_REPLAY4_IMAGE,    N_("Action Replay 4 image...") },
         { IDMS_ACTION_REPLAY4_IMAGE_DA, "Action Replay 4-image..." },
         { IDMS_ACTION_REPLAY4_IMAGE_DE, "Action Replay 4 Image..." },
         { IDMS_ACTION_REPLAY4_IMAGE_FR, "Insrer une cartouche Action Replay 4..." },
         { IDMS_ACTION_REPLAY4_IMAGE_HU, "Action Replay 4 kpms..." },
         { IDMS_ACTION_REPLAY4_IMAGE_IT, "Immagine Action Replay 4..." },
         { IDMS_ACTION_REPLAY4_IMAGE_NL, "Action Replay 4 bestand..." },
         { IDMS_ACTION_REPLAY4_IMAGE_PL, "" },             
         { IDMS_ACTION_REPLAY4_IMAGE_SV, "Action Replay 4-fil..." },
         { IDMS_ACTION_REPLAY4_IMAGE_TR, "Action Replay 4 imaj..." },

         { IDMS_STARDOS_IMAGE,    N_("StarDOS image...") },
         { IDMS_STARDOS_IMAGE_DA, "StarDOS-image..." },
         { IDMS_STARDOS_IMAGE_DE, "StarDOS Image..." },
         { IDMS_STARDOS_IMAGE_FR, "" },             
         { IDMS_STARDOS_IMAGE_HU, "StarDOS kpms..." },
         { IDMS_STARDOS_IMAGE_IT, "Immagine StarDOS..." },
         { IDMS_STARDOS_IMAGE_NL, "StarDOS bestand..." },
         { IDMS_STARDOS_IMAGE_PL, "" },             
         { IDMS_STARDOS_IMAGE_SV, "StarDOS-fil..." },
         { IDMS_STARDOS_IMAGE_TR, "StarDOS imaj..." },

         { IDMS_ATOMIC_POWER_IMAGE,    N_("Atomic Power image...") },
         { IDMS_ATOMIC_POWER_IMAGE_DA, "Atomic Power-image..." },
         { IDMS_ATOMIC_POWER_IMAGE_DE, "Atomic Power Image..." },
         { IDMS_ATOMIC_POWER_IMAGE_FR, "Insrer une cartouche Atomic Power..." },
         { IDMS_ATOMIC_POWER_IMAGE_HU, "Atomic Power kpms..." },
         { IDMS_ATOMIC_POWER_IMAGE_IT, "Immagine Atomic Power..." },
         { IDMS_ATOMIC_POWER_IMAGE_NL, "Atomic Power-bestand..." },
         { IDMS_ATOMIC_POWER_IMAGE_PL, "" },             
         { IDMS_ATOMIC_POWER_IMAGE_SV, "Atomic Power-fil..." },
         { IDMS_ATOMIC_POWER_IMAGE_TR, "Atomic Power imaj..." },

         { IDMS_EPYX_FASTLOAD_IMAGE,    N_("Epyx fastload image...") },
         { IDMS_EPYX_FASTLOAD_IMAGE_DA, "Epyx FastLoad-image..." },
         { IDMS_EPYX_FASTLOAD_IMAGE_DE, "Epyx Fastload Image..." },
         { IDMS_EPYX_FASTLOAD_IMAGE_FR, "Insrer une cartouche Epyx FastLoad..." },
         { IDMS_EPYX_FASTLOAD_IMAGE_HU, "Epyx gyorstlt kpms..." },
         { IDMS_EPYX_FASTLOAD_IMAGE_IT, "Immagine Epyx fastload..." },
         { IDMS_EPYX_FASTLOAD_IMAGE_NL, "Epyx fastloadbestand..." },
         { IDMS_EPYX_FASTLOAD_IMAGE_PL, "" },             
         { IDMS_EPYX_FASTLOAD_IMAGE_SV, "Epyx fastload-fil..." },
         { IDMS_EPYX_FASTLOAD_IMAGE_TR, "Epyx fastload imaj..." },

         { IDMS_IEEE488_INTERFACE_IMAGE,    N_("IEEE488 interface image...") },
         { IDMS_IEEE488_INTERFACE_IMAGE_DA, "IEEE488-interface image..." },
         { IDMS_IEEE488_INTERFACE_IMAGE_DE, "IEEE 488 Schnittstellenmodul..." },
         { IDMS_IEEE488_INTERFACE_IMAGE_FR, "Insrer une cartouche interface IEEE488..." },
         { IDMS_IEEE488_INTERFACE_IMAGE_HU, "IEEE488 interfsz kpms..." },
         { IDMS_IEEE488_INTERFACE_IMAGE_IT, "Immagine interfaccia IEEE488..." },
         { IDMS_IEEE488_INTERFACE_IMAGE_NL, "IEEE488-interfacebestand..." },
         { IDMS_IEEE488_INTERFACE_IMAGE_PL, "" },             
         { IDMS_IEEE488_INTERFACE_IMAGE_SV, "IEEE488-grnssnittsfil..." },
         { IDMS_IEEE488_INTERFACE_IMAGE_TR, "IEEE488 arabirim imaj..." },

         { IDMS_RETRO_REPLAY_IMAGE,    N_("Retro Replay image...") },
         { IDMS_RETRO_REPLAY_IMAGE_DA, "Retro Replay-image..." },
         { IDMS_RETRO_REPLAY_IMAGE_DE, "Retro Replay Image..." },
         { IDMS_RETRO_REPLAY_IMAGE_FR, "Insrer une cartouche Retro Replay..." },
         { IDMS_RETRO_REPLAY_IMAGE_HU, "Retro Replay kpms..." },
         { IDMS_RETRO_REPLAY_IMAGE_IT, "Immagine Retro Replay..." },
         { IDMS_RETRO_REPLAY_IMAGE_NL, "Retro Replay-bestand..." },
         { IDMS_RETRO_REPLAY_IMAGE_PL, "" },             
         { IDMS_RETRO_REPLAY_IMAGE_SV, "Retro Replay-fil..." },
         { IDMS_RETRO_REPLAY_IMAGE_TR, "Retro Replay imaj..." },

         { IDMS_IDE64_INTERFACE_IMAGE,    N_("IDE64 interface image...") },
         { IDMS_IDE64_INTERFACE_IMAGE_DA, "IDE64-interface image..." },
         { IDMS_IDE64_INTERFACE_IMAGE_DE, "IDE64 Schnittstellenmodul..." },
         { IDMS_IDE64_INTERFACE_IMAGE_FR, "Insrer une cartouche interface IDE64..." },
         { IDMS_IDE64_INTERFACE_IMAGE_HU, "IDE64 interfsz kpms..." },
         { IDMS_IDE64_INTERFACE_IMAGE_IT, "Immagine interfaccia IDE64..." },
         { IDMS_IDE64_INTERFACE_IMAGE_NL, "IDE64-interfacebestand..." },
         { IDMS_IDE64_INTERFACE_IMAGE_PL, "" },             
         { IDMS_IDE64_INTERFACE_IMAGE_SV, "IDE64-grnssnittsfil..." },
         { IDMS_IDE64_INTERFACE_IMAGE_TR, "IDE64 arabirim imaj..." },

         { IDMS_SUPER_SNAPSHOT_4_IMAGE,    N_("Super Snapshot 4 image...") },
         { IDMS_SUPER_SNAPSHOT_4_IMAGE_DA, "Super Snapshot 4-image..." },
         { IDMS_SUPER_SNAPSHOT_4_IMAGE_DE, "Super Snapshot 4 Image..." },
         { IDMS_SUPER_SNAPSHOT_4_IMAGE_FR, "Insrer une cartouche Super Snapshot 4..." },
         { IDMS_SUPER_SNAPSHOT_4_IMAGE_HU, "Super Snapshot 4 kpms..." },
         { IDMS_SUPER_SNAPSHOT_4_IMAGE_IT, "Immagine Super Snapshot 4..." },
         { IDMS_SUPER_SNAPSHOT_4_IMAGE_NL, "Super Snapshot 4-bestand..." },
         { IDMS_SUPER_SNAPSHOT_4_IMAGE_PL, "" },             
         { IDMS_SUPER_SNAPSHOT_4_IMAGE_SV, "Super Snapshot 4-fil..." },
         { IDMS_SUPER_SNAPSHOT_4_IMAGE_TR, "Super Snapshot 4 imaj..." },

         { IDMS_SUPER_SNAPSHOT_5_IMAGE,    N_("Super Snapshot 5 image...") },
         { IDMS_SUPER_SNAPSHOT_5_IMAGE_DA, "Super Snapshot 5-image..." },
         { IDMS_SUPER_SNAPSHOT_5_IMAGE_DE, "Super Snapshot 5 Image..." },
         { IDMS_SUPER_SNAPSHOT_5_IMAGE_FR, "Insrer une cartouche Super Snapshot 5..." },
         { IDMS_SUPER_SNAPSHOT_5_IMAGE_HU, "Super Snapshot 5 kpms..." },
         { IDMS_SUPER_SNAPSHOT_5_IMAGE_IT, "Immagine Super Snapshot 5..." },
         { IDMS_SUPER_SNAPSHOT_5_IMAGE_NL, "Super Snapshot 5-bestand..." },
         { IDMS_SUPER_SNAPSHOT_5_IMAGE_PL, "" },             
         { IDMS_SUPER_SNAPSHOT_5_IMAGE_SV, "Super Snapshot 5-fil..." },
         { IDMS_SUPER_SNAPSHOT_5_IMAGE_TR, "Super Snapshot 5 imaj..." },

         { IDMS_STRUCTURED_BASIC_IMAGE,    N_("Structured Basic image...") },
         { IDMS_STRUCTURED_BASIC_IMAGE_DA, "Structured BASIC-image..." },
         { IDMS_STRUCTURED_BASIC_IMAGE_DE, "Structured Basic Image..." },
         { IDMS_STRUCTURED_BASIC_IMAGE_FR, "Insrer une cartouche Structured Basic..." },
         { IDMS_STRUCTURED_BASIC_IMAGE_HU, "Structured Basic kpms..." },
         { IDMS_STRUCTURED_BASIC_IMAGE_IT, "Immagine Structured Basic..." },
         { IDMS_STRUCTURED_BASIC_IMAGE_NL, "Structured Basic-bestand..." },
         { IDMS_STRUCTURED_BASIC_IMAGE_PL, "" },             
         { IDMS_STRUCTURED_BASIC_IMAGE_SV, "Structured Basic-fil..." },
         { IDMS_STRUCTURED_BASIC_IMAGE_TR, "Structured Basic imaj..." },

         { IDMS_EXPERT_CART,    N_("Expert Cartridge") },
         { IDMS_EXPERT_CART_DA, "Expert Cartridge" },
         { IDMS_EXPERT_CART_DE, "Expert Cartridge" },
         { IDMS_EXPERT_CART_FR, "Activer les paramtres des cartouches experts" },
         { IDMS_EXPERT_CART_HU, "Expert cartridge" },
         { IDMS_EXPERT_CART_IT, "Expert Cartridge" },
         { IDMS_EXPERT_CART_NL, "Expert Cartridge" },
         { IDMS_EXPERT_CART_PL, "" },             
         { IDMS_EXPERT_CART_SV, "Expert Cartridge" },
         { IDMS_EXPERT_CART_TR, "Expert Kartuu" },

         { IDMS_ENABLE,    N_("Enable") },
         { IDMS_ENABLE_DA, "Aktivr" },
         { IDMS_ENABLE_DE, "Aktivieren" },
         { IDMS_ENABLE_FR, "Activer" },
         { IDMS_ENABLE_HU, "Engedlyezs" },
         { IDMS_ENABLE_IT, "Abilita" },
         { IDMS_ENABLE_NL, "Activeer" },
         { IDMS_ENABLE_PL, "" },             
         { IDMS_ENABLE_SV, "Aktivera" },
         { IDMS_ENABLE_TR, "Aktif Et" },

         { IDMS_OFF,    N_("Off") },
         { IDMS_OFF_DA, "Slukket" },
         { IDMS_OFF_DE, "Aus" },
         { IDMS_OFF_FR, "Off" },
         { IDMS_OFF_HU, "Ki" },
         { IDMS_OFF_IT, "Off" },
         { IDMS_OFF_NL, "Uit" },
         { IDMS_OFF_PL, "" },             
         { IDMS_OFF_SV, "Av" },
         { IDMS_OFF_TR, "Kapal" },

         { IDMS_PRG,    N_("Prg") },
         { IDMS_PRG_DA, "Prg" },
         { IDMS_PRG_DE, "Prg" },
         { IDMS_PRG_FR, "Prg" },
         { IDMS_PRG_HU, "Prg" },
         { IDMS_PRG_IT, "Prg" },
         { IDMS_PRG_NL, "Prg" },
         { IDMS_PRG_PL, "" },             
         { IDMS_PRG_SV, "Prg" },
         { IDMS_PRG_TR, "Prg" },

         { IDMS_ON,    N_("On") },
         { IDMS_ON_DA, "Tndt" },
         { IDMS_ON_DE, "Ein" },
         { IDMS_ON_FR, "On" },
         { IDMS_ON_HU, "Be" },
         { IDMS_ON_IT, "On" },
         { IDMS_ON_NL, "Aan" },
         { IDMS_ON_PL, "" },             
         { IDMS_ON_SV, "P" },
         { IDMS_ON_TR, "Ak" },

         { IDMS_SET_CART_AS_DEFAULT,    N_("Set cartridge as default") },
         { IDMS_SET_CART_AS_DEFAULT_DA, "Vlg cartridge som standard" },
         { IDMS_SET_CART_AS_DEFAULT_DE, "Aktuelles Erweiterungsmodul als standard aktivieren" },
         { IDMS_SET_CART_AS_DEFAULT_FR, "Dfinir cette cartouche par dfaut" },
         { IDMS_SET_CART_AS_DEFAULT_HU, "Cartridge alaprtelmezett ttele" },
         { IDMS_SET_CART_AS_DEFAULT_IT, "Imposta la cartuccia come predefinita" },
         { IDMS_SET_CART_AS_DEFAULT_NL, "Zet cartridge als standaard" },
         { IDMS_SET_CART_AS_DEFAULT_PL, "" },             
         { IDMS_SET_CART_AS_DEFAULT_SV, "Vlj insticksmodul som frval" },
         { IDMS_SET_CART_AS_DEFAULT_TR, "Kartuu varsaylan yap" },

         { IDMS_RESET_ON_CART_CHANGE,    N_("Reset on cart change") },
         { IDMS_RESET_ON_CART_CHANGE_DA, "Reset ved cartridge-skift" },
         { IDMS_RESET_ON_CART_CHANGE_DE, "Reset bei Wechsel von Erweiterungsmodulen" },
         { IDMS_RESET_ON_CART_CHANGE_FR, "Rinialiser sur changement de cartouche" },
         { IDMS_RESET_ON_CART_CHANGE_HU, "jraindts cartridge csernl" },
         { IDMS_RESET_ON_CART_CHANGE_IT, "Reset al cambio di cartuccia" },
         { IDMS_RESET_ON_CART_CHANGE_NL, "Reset bij cartwisseling" },
         { IDMS_RESET_ON_CART_CHANGE_PL, "" },             
         { IDMS_RESET_ON_CART_CHANGE_SV, "Nollstll vid modulbyte" },
         { IDMS_RESET_ON_CART_CHANGE_TR, "Kartu deiiminde resetle" },

         { IDMS_CART_FREEZE,    N_("Cartridge freeze") },
         { IDMS_CART_FREEZE_DA, "Cartridgets frys-funktion" },
         { IDMS_CART_FREEZE_DE, "Erweiterungsmodul Freeze" },
         { IDMS_CART_FREEZE_FR, "Geler la cartouche" },
         { IDMS_CART_FREEZE_HU, "Fagyaszts Cartridge-dzsel" },
         { IDMS_CART_FREEZE_IT, "Freeze della cartuccia" },
         { IDMS_CART_FREEZE_NL, "Cartridge freeze" },
         { IDMS_CART_FREEZE_PL, "" },             
         { IDMS_CART_FREEZE_SV, "Frys" },
         { IDMS_CART_FREEZE_TR, "Kartu freeze" },

         { IDMS_PAUSE,    N_("Pause") },
         { IDMS_PAUSE_DA, "Pause" },
         { IDMS_PAUSE_DE, "Pause" },
         { IDMS_PAUSE_FR, "Pause" },
         { IDMS_PAUSE_HU, "Sznet" },
         { IDMS_PAUSE_IT, "Pausa" },
         { IDMS_PAUSE_NL, "Pauze" },
         { IDMS_PAUSE_PL, "" },             
         { IDMS_PAUSE_SV, "Paus" },
         { IDMS_PAUSE_TR, "Duraklat" },

         { IDMS_MONITOR,    N_("Monitor") },
         { IDMS_MONITOR_DA, "Monitor" },
         { IDMS_MONITOR_DE, "Monitor" },
         { IDMS_MONITOR_FR, "Tracer" },
         { IDMS_MONITOR_HU, "Monitor" },
         { IDMS_MONITOR_IT, "Monitor" },
         { IDMS_MONITOR_NL, "Monitor" },
         { IDMS_MONITOR_PL, "" },             
         { IDMS_MONITOR_SV, "Monitor" },
         { IDMS_MONITOR_TR, "Monitr" },

         { IDMS_HARD,    N_("Hard") },
         { IDMS_HARD_DA, "Hrd" },
         { IDMS_HARD_DE, "Hart" },
         { IDMS_HARD_FR, "Physiquement" },
         { IDMS_HARD_HU, "Hideg" },
         { IDMS_HARD_IT, "Hard" },
         { IDMS_HARD_NL, "Hard" },
         { IDMS_HARD_PL, "" },             
         { IDMS_HARD_SV, "Hrd" },
         { IDMS_HARD_TR, "Hard" },

         { IDMS_SOFT,    N_("Soft") },
         { IDMS_SOFT_DA, "Bld" },
         { IDMS_SOFT_DE, "Soft" },
         { IDMS_SOFT_FR, "Logiciellement" },
         { IDMS_SOFT_HU, "Meleg" },
         { IDMS_SOFT_IT, "Soft" },
         { IDMS_SOFT_NL, "Zacht" },
         { IDMS_SOFT_PL, "" },             
         { IDMS_SOFT_SV, "Mjuk" },
         { IDMS_SOFT_TR, "Soft" },

         { IDMS_EXIT,    N_("Exit") },
         { IDMS_EXIT_DA, "Afslut" },
         { IDMS_EXIT_DE, "Exit" },
         { IDMS_EXIT_FR, "Quitter" },
         { IDMS_EXIT_HU, "Kilps" },
         { IDMS_EXIT_IT, "Esci" },
         { IDMS_EXIT_NL, "Afsluiten" },
         { IDMS_EXIT_PL, "" },             
         { IDMS_EXIT_SV, "Avsluta" },
         { IDMS_EXIT_TR, "k" },

         { IDMS_EDIT,    N_("Edit") },
         { IDMS_EDIT_DA, "Redigr" },
         { IDMS_EDIT_DE, "Bearbeiten" },
         { IDMS_EDIT_FR, "" },             
         { IDMS_EDIT_HU, "Szerkeszt" },
         { IDMS_EDIT_IT, "Modifica" },
         { IDMS_EDIT_NL, "Bewerken" },
         { IDMS_EDIT_PL, "" },             
         { IDMS_EDIT_SV, "Redigera" },
         { IDMS_EDIT_TR, "Dzenle" },

         { IDMS_COPY,    N_("Copy") },
         { IDMS_COPY_DA, "Kopir" },
         { IDMS_COPY_DE, "Kopie" },
         { IDMS_COPY_FR, "" },             
         { IDMS_COPY_HU, "Msol" },
         { IDMS_COPY_IT, "Copia" },
         { IDMS_COPY_NL, "Kopie" },
         { IDMS_COPY_PL, "" },             
         { IDMS_COPY_SV, "Kopiera" },
         { IDMS_COPY_TR, "Kopyala" },

         { IDMS_PASTE,    N_("Paste") },
         { IDMS_PASTE_DA, "Indst" },
         { IDMS_PASTE_DE, "Einfgen" },
         { IDMS_PASTE_FR, "" },             
         { IDMS_PASTE_HU, "Beilleszt" },
         { IDMS_PASTE_IT, "Incolla" },
         { IDMS_PASTE_NL, "Plakken" },
         { IDMS_PASTE_PL, "" },             
         { IDMS_PASTE_SV, "Klistra in" },
         { IDMS_PASTE_TR, "Yaptr" },

         { IDMS_SNAPSHOT,    N_("Snapshot") },
         { IDMS_SNAPSHOT_DA, "Snapshot" },
         { IDMS_SNAPSHOT_DE, "Snapshot" },
         { IDMS_SNAPSHOT_FR, "Sauvegarde" },
         { IDMS_SNAPSHOT_HU, "Pillanatkp" },
         { IDMS_SNAPSHOT_IT, "Snapshot" },
         { IDMS_SNAPSHOT_NL, "Momentopname" },
         { IDMS_SNAPSHOT_PL, "" },             
         { IDMS_SNAPSHOT_SV, "gonblicksbild" },
         { IDMS_SNAPSHOT_TR, "Anlk Grnt" },

         { IDMS_LOAD_SNAPSHOT_IMAGE,    N_("Load snapshot image...") },
         { IDMS_LOAD_SNAPSHOT_IMAGE_DA, "Indls snapshot..." },
         { IDMS_LOAD_SNAPSHOT_IMAGE_DE, "Snapshot Image Laden..." },
         { IDMS_LOAD_SNAPSHOT_IMAGE_FR, "Charger une sauvegarde...." },
         { IDMS_LOAD_SNAPSHOT_IMAGE_HU, "Pillanatkp betltse..." },
         { IDMS_LOAD_SNAPSHOT_IMAGE_IT, "Carica immagine dello snapshot..." },
         { IDMS_LOAD_SNAPSHOT_IMAGE_NL, "Laad momentopnamebestand..." },
         { IDMS_LOAD_SNAPSHOT_IMAGE_PL, "" },             
         { IDMS_LOAD_SNAPSHOT_IMAGE_SV, "Ls in gonblicksbild..." },
         { IDMS_LOAD_SNAPSHOT_IMAGE_TR, "Anlk grnt imaj ykle..." },

         { IDMS_SAVE_SNAPSHOT_IMAGE,    N_("Save snapshot image...") },
         { IDMS_SAVE_SNAPSHOT_IMAGE_DA, "Gem snapshot..." },
         { IDMS_SAVE_SNAPSHOT_IMAGE_DE, "Snapshot Image Speichern..." },
         { IDMS_SAVE_SNAPSHOT_IMAGE_FR, "Enregistrer une sauvegarde..." },
         { IDMS_SAVE_SNAPSHOT_IMAGE_HU, "Pillanatkp mentse..." },
         { IDMS_SAVE_SNAPSHOT_IMAGE_IT, "Salva l'immagine dello snapshot..." },
         { IDMS_SAVE_SNAPSHOT_IMAGE_NL, "Opslaan momentopnamebestand..." },
         { IDMS_SAVE_SNAPSHOT_IMAGE_PL, "" },             
         { IDMS_SAVE_SNAPSHOT_IMAGE_SV, "Spara gonblicksbild..." },
         { IDMS_SAVE_SNAPSHOT_IMAGE_TR, "Anlk grnt imaj kaydet..." },

         { IDMS_LOAD_QUICKSNAPSHOT_IMAGE,    N_("Load quicksnapshot image") },
         { IDMS_LOAD_QUICKSNAPSHOT_IMAGE_DA, "Hurtig-indls snapshot" },
         { IDMS_LOAD_QUICKSNAPSHOT_IMAGE_DE, "Schnellladen von Snapshot Image" },
         { IDMS_LOAD_QUICKSNAPSHOT_IMAGE_FR, "Charger la sauvegarde rapide" },
         { IDMS_LOAD_QUICKSNAPSHOT_IMAGE_HU, "Gyors pillanatkp betltse" },
         { IDMS_LOAD_QUICKSNAPSHOT_IMAGE_IT, "Carica immagine dello snapshot" },
         { IDMS_LOAD_QUICKSNAPSHOT_IMAGE_NL, "Snellaad momentopnamebestand" },
         { IDMS_LOAD_QUICKSNAPSHOT_IMAGE_PL, "" },             
         { IDMS_LOAD_QUICKSNAPSHOT_IMAGE_SV, "Ls in snabbgonblicksbild" },
         { IDMS_LOAD_QUICKSNAPSHOT_IMAGE_TR, "Hzl anlk grnt imaj ykle" },

         { IDMS_SAVE_QUICKSNAPSHOT_IMAGE,    N_("Save quicksnapshot image") },
         { IDMS_SAVE_QUICKSNAPSHOT_IMAGE_DA, "Hurtig-gem snapshot" },
         { IDMS_SAVE_QUICKSNAPSHOT_IMAGE_DE, "Schnellspeichern von Snapshot" },
         { IDMS_SAVE_QUICKSNAPSHOT_IMAGE_FR, "Enregistrer la sauvegarde rapide" },
         { IDMS_SAVE_QUICKSNAPSHOT_IMAGE_HU, "Gyors pillanatkp fjl mentse" },
         { IDMS_SAVE_QUICKSNAPSHOT_IMAGE_IT, "Salva immagine dello snapshot" },
         { IDMS_SAVE_QUICKSNAPSHOT_IMAGE_NL, "Snelopslaan momentopnamebestand" },
         { IDMS_SAVE_QUICKSNAPSHOT_IMAGE_PL, "" },             
         { IDMS_SAVE_QUICKSNAPSHOT_IMAGE_SV, "Spara snabbgonblicksbildfil" },
         { IDMS_SAVE_QUICKSNAPSHOT_IMAGE_TR, "Hzl anlk grnt imaj kaydet" },

         { IDMS_START_STOP_RECORDING,    N_("Start/Stop Recording History") },
         { IDMS_START_STOP_RECORDING_DA, "Start/stop optagelse af historik" },
         { IDMS_START_STOP_RECORDING_DE, "Start/Stop Aufnahme History" },
         { IDMS_START_STOP_RECORDING_FR, "Dmarrer/Arrter l'historique de l'enregistrement" },
         { IDMS_START_STOP_RECORDING_HU, "Esemny felvtel indtsa/meglltsa" },
         { IDMS_START_STOP_RECORDING_IT, "Avvia/termina la registrazione della cronologia" },
         { IDMS_START_STOP_RECORDING_NL, "Start/Stop Opnamegeschiedenis" },
         { IDMS_START_STOP_RECORDING_PL, "" },             
         { IDMS_START_STOP_RECORDING_SV, "Brja/sluta spela in hndelser" },
         { IDMS_START_STOP_RECORDING_TR, "Kayt Tarihesini Balat/Durdur" },

         { IDMS_START_STOP_PLAYBACK,    N_("Start/Stop Playback History") },
         { IDMS_START_STOP_PLAYBACK_DA, "Start/stop afspilning af historik" },
         { IDMS_START_STOP_PLAYBACK_DE, "Start/Stop Wiedergabe History" },
         { IDMS_START_STOP_PLAYBACK_FR, "Dmarrer/Arrter l'historique de la lecture" },
         { IDMS_START_STOP_PLAYBACK_HU, "Esemny visszajtszs indtsa/meglltsa" },
         { IDMS_START_STOP_PLAYBACK_IT, "Avvia/termina la riproduzione della cronologia" },
         { IDMS_START_STOP_PLAYBACK_NL, "Start/Stop Afspeelgeschiedenis" },
         { IDMS_START_STOP_PLAYBACK_PL, "" },             
         { IDMS_START_STOP_PLAYBACK_SV, "Brja/sluta spela upp hndelser" },
         { IDMS_START_STOP_PLAYBACK_TR, "Kayttan Yrtme Tarihesini Balat/Durdur" },

         { IDMS_SET_MILESTONE,    N_("Set Recording Milestone") },
         { IDMS_SET_MILESTONE_DA, "Angiv optagelses-bogmrke" },
         { IDMS_SET_MILESTONE_DE, "Setze Aufnahme Meilenstein" },
         { IDMS_SET_MILESTONE_FR, "Lever le Signet d'enregistrement" },
         { IDMS_SET_MILESTONE_HU, "Kilmterk elhelyezse a felvtelben" },
         { IDMS_SET_MILESTONE_IT, "Imposta segnalibro" },
         { IDMS_SET_MILESTONE_NL, "Zet Opname Mijlpaal" },
         { IDMS_SET_MILESTONE_PL, "" },             
         { IDMS_SET_MILESTONE_SV, "Ange inspelningsbokmrke" },
         { IDMS_SET_MILESTONE_TR, "Kayt kilometre ta koy" },

         { IDMS_RETURN_TO_MILESTONE,    N_("Return to Milestone") },
         { IDMS_RETURN_TO_MILESTONE_DA, "G til bogmrke" },
         { IDMS_RETURN_TO_MILESTONE_DE, "Rckkehr zum Meilenstein" },
         { IDMS_RETURN_TO_MILESTONE_FR, "Retourner au Signet d'enregistrement" },
         { IDMS_RETURN_TO_MILESTONE_HU, "Visszaugrs az elz kilmterkhz" },
         { IDMS_RETURN_TO_MILESTONE_IT, "Vai al segnalibro" },
         { IDMS_RETURN_TO_MILESTONE_NL, "Ga terug naar Mijlpaal" },
         { IDMS_RETURN_TO_MILESTONE_PL, "" },             
         { IDMS_RETURN_TO_MILESTONE_SV, "terg till bokmrke" },
         { IDMS_RETURN_TO_MILESTONE_TR, "Kilometre tana geri dn" },

         { IDMS_RECORDING_START_MODE,    N_("Recording start mode") },
         { IDMS_RECORDING_START_MODE_DA, "Start-tilstand for optagelse" },
         { IDMS_RECORDING_START_MODE_DE, "Aufnahme Start Modus" },
         { IDMS_RECORDING_START_MODE_FR, "Mode de dpart d'enregistrement" },
         { IDMS_RECORDING_START_MODE_HU, "Rgzts indtsnak mdja" },
         { IDMS_RECORDING_START_MODE_IT, "Modalit di inizio registrazione" },
         { IDMS_RECORDING_START_MODE_NL, "Opname start modus" },
         { IDMS_RECORDING_START_MODE_PL, "" },             
         { IDMS_RECORDING_START_MODE_SV, "Spelar in startlge" },
         { IDMS_RECORDING_START_MODE_TR, "Kayt balang modu" },

         { IDMS_SAVE_NEW_SNAPSHOT,    N_("Save new snapshot") },
         { IDMS_SAVE_NEW_SNAPSHOT_DA, "Gem nyt snapshot" },
         { IDMS_SAVE_NEW_SNAPSHOT_DE, "Speichere neuen Snapshot" },
         { IDMS_SAVE_NEW_SNAPSHOT_FR, "Enregistrer une nouvelle sauvegarde" },
         { IDMS_SAVE_NEW_SNAPSHOT_HU, "j pillanatkp mentse" },
         { IDMS_SAVE_NEW_SNAPSHOT_IT, "Salva nuovo snapshot" },
         { IDMS_SAVE_NEW_SNAPSHOT_NL, "Opslaan nieuwe momentopname" },
         { IDMS_SAVE_NEW_SNAPSHOT_PL, "" },             
         { IDMS_SAVE_NEW_SNAPSHOT_SV, "Spara ny gonblicksbild" },
         { IDMS_SAVE_NEW_SNAPSHOT_TR, "Yeni anlk grnt kaydet" },

         { IDMS_LOAD_EXISTING_SNAPSHOT,    N_("Load existing snapshot") },
         { IDMS_LOAD_EXISTING_SNAPSHOT_DA, "Indls eksisterende snapshot" },
         { IDMS_LOAD_EXISTING_SNAPSHOT_DE, "Lade existierenden Snapshot" },
         { IDMS_LOAD_EXISTING_SNAPSHOT_FR, "Charger une sauvegarde" },
         { IDMS_LOAD_EXISTING_SNAPSHOT_HU, "Ltez pillanatkp betltse" },
         { IDMS_LOAD_EXISTING_SNAPSHOT_IT, "Carica snapshot esistente" },
         { IDMS_LOAD_EXISTING_SNAPSHOT_NL, "Laad bestaande momentopname" },
         { IDMS_LOAD_EXISTING_SNAPSHOT_PL, "" },             
         { IDMS_LOAD_EXISTING_SNAPSHOT_SV, "Ls in existerande gonblicksbild" },
         { IDMS_LOAD_EXISTING_SNAPSHOT_TR, "Varolan anlk grnty ykle" },

         { IDMS_START_WITH_RESET,    N_("Start with reset") },
         { IDMS_START_WITH_RESET_DA, "Start med reset" },
         { IDMS_START_WITH_RESET_DE, "Mit Reset starten" },
         { IDMS_START_WITH_RESET_FR, "Rinitialiser au dmarrage" },
         { IDMS_START_WITH_RESET_HU, "Induls RESET-tel" },
         { IDMS_START_WITH_RESET_IT, "Avvia con reset" },
         { IDMS_START_WITH_RESET_NL, "Start bij reset" },
         { IDMS_START_WITH_RESET_PL, "" },             
         { IDMS_START_WITH_RESET_SV, "Starta med nollstllning" },
         { IDMS_START_WITH_RESET_TR, "Reset ile balat" },

         { IDMS_OVERWRITE_PLAYBACK,    N_("Overwrite Playback") },
         { IDMS_OVERWRITE_PLAYBACK_DA, "Overskriv afspilning" },
         { IDMS_OVERWRITE_PLAYBACK_DE, "Laufende Aufnahme berschreiben" },
         { IDMS_OVERWRITE_PLAYBACK_FR, "craser la lecture actuelle" },
         { IDMS_OVERWRITE_PLAYBACK_HU, "Visszajtszs fellrsa" },
         { IDMS_OVERWRITE_PLAYBACK_IT, "Sovrascrivi la riproduzione" },
         { IDMS_OVERWRITE_PLAYBACK_NL, "Overschrijf weergave" },
         { IDMS_OVERWRITE_PLAYBACK_PL, "" },             
         { IDMS_OVERWRITE_PLAYBACK_SV, "Skriv ver aktiv uppspelning" },
         { IDMS_OVERWRITE_PLAYBACK_TR, "Kayttan Yrtmenin zerine Yaz" },

         { IDMS_SELECT_HISTORY_DIR,    N_("Select History files/directory") },
         { IDMS_SELECT_HISTORY_DIR_DA, "Vlg historikfiler/-katalog" },
         { IDMS_SELECT_HISTORY_DIR_DE, "Verzeichnis fr Event Aufnahme" },
         { IDMS_SELECT_HISTORY_DIR_FR, "Slectionnez le rpertoire des captures" },
         { IDMS_SELECT_HISTORY_DIR_HU, "Vlassza ki a felvteleket/knyvtrat" },
         { IDMS_SELECT_HISTORY_DIR_IT, "Seleziona i file/directory della cronologia" },
         { IDMS_SELECT_HISTORY_DIR_NL, "Selecteer geschiedenisdirectory" },
         { IDMS_SELECT_HISTORY_DIR_PL, "" },             
         { IDMS_SELECT_HISTORY_DIR_SV, "Vlj historikfiler/-katalog" },
         { IDMS_SELECT_HISTORY_DIR_TR, "Tarihe dosyalar/dizin se" },

         { IDMS_SAVE_STOP_MEDIA_FILE,    N_("Save/stop media file...") },
         { IDMS_SAVE_STOP_MEDIA_FILE_DA, "Gem/stop mediefil..." },
         { IDMS_SAVE_STOP_MEDIA_FILE_DE, "Speichern/stop media Datei..." },
         { IDMS_SAVE_STOP_MEDIA_FILE_FR, "Enregistrer/Arrter fichier mdia..." },
         { IDMS_SAVE_STOP_MEDIA_FILE_HU, "Mdia fjl mentse/meglltsa..." },
         { IDMS_SAVE_STOP_MEDIA_FILE_IT, "Salva/arresta file multimediale..." },
         { IDMS_SAVE_STOP_MEDIA_FILE_NL, "Opslaan/stop mediabestand..." },
         { IDMS_SAVE_STOP_MEDIA_FILE_PL, "" },             
         { IDMS_SAVE_STOP_MEDIA_FILE_SV, "Starta/stoppa mediafil..." },
         { IDMS_SAVE_STOP_MEDIA_FILE_TR, "Ortam dosyas kaydet/durdur..." },

         { IDMS_NETPLAY,    N_("Netplay (experimental)...") },
         { IDMS_NETPLAY_DA, "Netvrksspil (eksperimentelt)..." },
         { IDMS_NETPLAY_DE, "Netplay (experimentell)..." },
         { IDMS_NETPLAY_FR, "Jeu en rseau (exprimental)..." },
         { IDMS_NETPLAY_HU, "Hlzati jtk (ksrleti)..." },
         { IDMS_NETPLAY_IT, "Gioco in rete (sperimentale)..." },
         { IDMS_NETPLAY_NL, "Netplay (experimenteel)..." },
         { IDMS_NETPLAY_PL, "" },             
         { IDMS_NETPLAY_SV, "Ntverksspel (experimentellt)..." },
         { IDMS_NETPLAY_TR, "Netplay (deneysel)..." },

         { IDMS_OPTIONS,    N_("Options") },
         { IDMS_OPTIONS_DA, "Valg" },
         { IDMS_OPTIONS_DE, "Optionen" },
         { IDMS_OPTIONS_FR, "Options" },
         { IDMS_OPTIONS_HU, "Opcik" },
         { IDMS_OPTIONS_IT, "Opzioni" },
         { IDMS_OPTIONS_NL, "Opties" },
         { IDMS_OPTIONS_PL, "" },             
         { IDMS_OPTIONS_SV, "Alternativ" },
         { IDMS_OPTIONS_TR, "Seenekler" },

         { IDMS_REFRESH_RATE,    N_("Refresh rate") },
         { IDMS_REFRESH_RATE_DA, "Opdateringsfrekvens" },
         { IDMS_REFRESH_RATE_DE, "Wiederholrate" },
         { IDMS_REFRESH_RATE_FR, "Taux de rafrachissement" },
         { IDMS_REFRESH_RATE_HU, "Frisstsi rta" },
         { IDMS_REFRESH_RATE_IT, "Frequenza di aggiornamento" },
         { IDMS_REFRESH_RATE_NL, "Vernieuwings snelheid" },
         { IDMS_REFRESH_RATE_PL, "" },             
         { IDMS_REFRESH_RATE_SV, "Uppdateringshastighet" },
         { IDMS_REFRESH_RATE_TR, "Yenileme hz" },

         { IDMS_AUTO,    N_("Auto") },
         { IDMS_AUTO_DA, "Auto" },
         { IDMS_AUTO_DE, "Automatisch" },
         { IDMS_AUTO_FR, "Automatique" },
         { IDMS_AUTO_HU, "Automatikus" },
         { IDMS_AUTO_IT, "Auto" },
         { IDMS_AUTO_NL, "Auto" },
         { IDMS_AUTO_PL, "" },             
         { IDMS_AUTO_SV, "Auto" },
         { IDMS_AUTO_TR, "Otomatik" },

         { IDMS_1_1,    N_("1/1") },
         { IDMS_1_1_DA, "1/1" },
         { IDMS_1_1_DE, "1/1" },
         { IDMS_1_1_FR, "1/1" },
         { IDMS_1_1_HU, "1/1" },
         { IDMS_1_1_IT, "1/1" },
         { IDMS_1_1_NL, "1/1" },
         { IDMS_1_1_PL, "1/1" },
         { IDMS_1_1_SV, "1/1" },
         { IDMS_1_1_TR, "1/1" },

         { IDMS_1_2,    N_("1/2") },
         { IDMS_1_2_DA, "1/2" },
         { IDMS_1_2_DE, "1/2" },
         { IDMS_1_2_FR, "1/2" },
         { IDMS_1_2_HU, "1/2" },
         { IDMS_1_2_IT, "1/2" },
         { IDMS_1_2_NL, "1/2" },
         { IDMS_1_2_PL, "1/2" },
         { IDMS_1_2_SV, "1/2" },
         { IDMS_1_2_TR, "1/2" },

         { IDMS_1_3,    N_("1/3") },
         { IDMS_1_3_DA, "1/3" },
         { IDMS_1_3_DE, "1/3" },
         { IDMS_1_3_FR, "1/3" },
         { IDMS_1_3_HU, "1/3" },
         { IDMS_1_3_IT, "1/3" },
         { IDMS_1_3_NL, "1/3" },
         { IDMS_1_3_PL, "1/3" },
         { IDMS_1_3_SV, "1/3" },
         { IDMS_1_3_TR, "1/3" },

         { IDMS_1_4,    N_("1/4") },
         { IDMS_1_4_DA, "1/4" },
         { IDMS_1_4_DE, "1/4" },
         { IDMS_1_4_FR, "1/4" },
         { IDMS_1_4_HU, "1/4" },
         { IDMS_1_4_IT, "1/4" },
         { IDMS_1_4_NL, "1/4" },
         { IDMS_1_4_PL, "1/4" },
         { IDMS_1_4_SV, "1/4" },
         { IDMS_1_4_TR, "1/4" },

         { IDMS_1_5,    N_("1/5") },
         { IDMS_1_5_DA, "1/5" },
         { IDMS_1_5_DE, "1/5" },
         { IDMS_1_5_FR, "1/5" },
         { IDMS_1_5_HU, "1/5" },
         { IDMS_1_5_IT, "1/5" },
         { IDMS_1_5_NL, "1/5" },
         { IDMS_1_5_PL, "1/5" },
         { IDMS_1_5_SV, "1/5" },
         { IDMS_1_5_TR, "1/5" },

         { IDMS_1_6,    N_("1/6") },
         { IDMS_1_6_DA, "1/6" },
         { IDMS_1_6_DE, "1/6" },
         { IDMS_1_6_FR, "1/6" },
         { IDMS_1_6_HU, "1/6" },
         { IDMS_1_6_IT, "1/6" },
         { IDMS_1_6_NL, "1/6" },
         { IDMS_1_6_PL, "1/6" },
         { IDMS_1_6_SV, "1/6" },
         { IDMS_1_6_TR, "1/6" },

         { IDMS_1_7,    N_("1/7") },
         { IDMS_1_7_DA, "1/7" },
         { IDMS_1_7_DE, "1/7" },
         { IDMS_1_7_FR, "1/7" },
         { IDMS_1_7_HU, "1/7" },
         { IDMS_1_7_IT, "1/7" },
         { IDMS_1_7_NL, "1/7" },
         { IDMS_1_7_PL, "1/7" },
         { IDMS_1_7_SV, "1/7" },
         { IDMS_1_7_TR, "1/7" },

         { IDMS_1_8,    N_("1/8") },
         { IDMS_1_8_DA, "1/8" },
         { IDMS_1_8_DE, "1/8" },
         { IDMS_1_8_FR, "1/8" },
         { IDMS_1_8_HU, "1/8" },
         { IDMS_1_8_IT, "1/8" },
         { IDMS_1_8_NL, "1/8" },
         { IDMS_1_8_PL, "1/8" },
         { IDMS_1_8_SV, "1/8" },
         { IDMS_1_8_TR, "1/8" },

         { IDMS_1_9,    N_("1/9") },
         { IDMS_1_9_DA, "1/9" },
         { IDMS_1_9_DE, "1/9" },
         { IDMS_1_9_FR, "1/9" },
         { IDMS_1_9_HU, "1/9" },
         { IDMS_1_9_IT, "1/9" },
         { IDMS_1_9_NL, "1/9" },
         { IDMS_1_9_PL, "1/9" },
         { IDMS_1_9_SV, "1/9" },
         { IDMS_1_9_TR, "1/9" },

         { IDMS_1_10,    N_("1/10") },
         { IDMS_1_10_DA, "1/10" },
         { IDMS_1_10_DE, "1/10" },
         { IDMS_1_10_FR, "1/10" },
         { IDMS_1_10_HU, "1/10" },
         { IDMS_1_10_IT, "1/10" },
         { IDMS_1_10_NL, "1/10" },
         { IDMS_1_10_PL, "1/10" },
         { IDMS_1_10_SV, "1/10" },
         { IDMS_1_10_TR, "1/10" },

         { IDMS_MAXIMUM_SPEED,    N_("Maximum Speed") },
         { IDMS_MAXIMUM_SPEED_DA, "Maximal hastighed" },
         { IDMS_MAXIMUM_SPEED_DE, "Maximale Geschwindigkeit" },
         { IDMS_MAXIMUM_SPEED_FR, "Vitesse Maximale" },
         { IDMS_MAXIMUM_SPEED_HU, "Maximlis sebessg" },
         { IDMS_MAXIMUM_SPEED_IT, "Velocit massima" },
         { IDMS_MAXIMUM_SPEED_NL, "Maximale Snelheid" },
         { IDMS_MAXIMUM_SPEED_PL, "" },             
         { IDMS_MAXIMUM_SPEED_SV, "Maximal hastighet" },
         { IDMS_MAXIMUM_SPEED_TR, "Maksimum Hz" },

         { IDMS_200_PERCENT,    N_("200%") },
         { IDMS_200_PERCENT_DA, "200%" },
         { IDMS_200_PERCENT_DE, "200%" },
         { IDMS_200_PERCENT_FR, "200%" },
         { IDMS_200_PERCENT_HU, "200%" },
         { IDMS_200_PERCENT_IT, "200%" },
         { IDMS_200_PERCENT_NL, "200%" },
         { IDMS_200_PERCENT_PL, "200%" },
         { IDMS_200_PERCENT_SV, "200%" },
         { IDMS_200_PERCENT_TR, "200%" },

         { IDMS_100_PERCENT,    N_("100%") },
         { IDMS_100_PERCENT_DA, "100%" },
         { IDMS_100_PERCENT_DE, "100%" },
         { IDMS_100_PERCENT_FR, "100%" },
         { IDMS_100_PERCENT_HU, "100%" },
         { IDMS_100_PERCENT_IT, "100%" },
         { IDMS_100_PERCENT_NL, "100%" },
         { IDMS_100_PERCENT_PL, "100%" },
         { IDMS_100_PERCENT_SV, "100%" },
         { IDMS_100_PERCENT_TR, "100%" },

         { IDMS_50_PERCENT,    N_("50%") },
         { IDMS_50_PERCENT_DA, "50%" },
         { IDMS_50_PERCENT_DE, "50%" },
         { IDMS_50_PERCENT_FR, "50%" },
         { IDMS_50_PERCENT_HU, "50%" },
         { IDMS_50_PERCENT_IT, "50%" },
         { IDMS_50_PERCENT_NL, "50%" },
         { IDMS_50_PERCENT_PL, "50%" },
         { IDMS_50_PERCENT_SV, "50%" },
         { IDMS_50_PERCENT_TR, "50%" },

         { IDMS_20_PERCENT,    N_("20%") },
         { IDMS_20_PERCENT_DA, "20%" },
         { IDMS_20_PERCENT_DE, "20%" },
         { IDMS_20_PERCENT_FR, "20%" },
         { IDMS_20_PERCENT_HU, "20%" },
         { IDMS_20_PERCENT_IT, "20%" },
         { IDMS_20_PERCENT_NL, "20%" },
         { IDMS_20_PERCENT_PL, "20%" },
         { IDMS_20_PERCENT_SV, "20%" },
         { IDMS_20_PERCENT_TR, "20%" },

         { IDMS_10_PERCENT,    N_("10%") },
         { IDMS_10_PERCENT_DA, "10%" },
         { IDMS_10_PERCENT_DE, "10%" },
         { IDMS_10_PERCENT_FR, "10%" },
         { IDMS_10_PERCENT_HU, "10%" },
         { IDMS_10_PERCENT_IT, "10%" },
         { IDMS_10_PERCENT_NL, "10%" },
         { IDMS_10_PERCENT_PL, "10%" },
         { IDMS_10_PERCENT_SV, "10%" },
         { IDMS_10_PERCENT_TR, "10%" },

         { IDMS_NO_LIMIT,    N_("No limit") },
         { IDMS_NO_LIMIT_DA, "Ubegrnset" },
         { IDMS_NO_LIMIT_DE, "Kein Limit" },
         { IDMS_NO_LIMIT_FR, "Aucune limite" },
         { IDMS_NO_LIMIT_HU, "Nincs hatr" },
         { IDMS_NO_LIMIT_IT, "Nessun limite" },
         { IDMS_NO_LIMIT_NL, "Geen limiet" },
         { IDMS_NO_LIMIT_PL, "" },             
         { IDMS_NO_LIMIT_SV, "Ingen grns" },
         { IDMS_NO_LIMIT_TR, "Limitsiz" },

         { IDMS_CUSTOM,    N_("Custom") },
         { IDMS_CUSTOM_DA, "Egen" },
         { IDMS_CUSTOM_DE, "Benutzerdefiniert" },
         { IDMS_CUSTOM_FR, "Personnalis" },
         { IDMS_CUSTOM_HU, "Egyni" },
         { IDMS_CUSTOM_IT, "Personalizzato" },
         { IDMS_CUSTOM_NL, "Aangepast" },
         { IDMS_CUSTOM_PL, "" },             
         { IDMS_CUSTOM_SV, "Egen" },
         { IDMS_CUSTOM_TR, "zel" },

         { IDMS_WARP_MODE,    N_("Warp mode") },
         { IDMS_WARP_MODE_DA, "Warp-tilstand" },
         { IDMS_WARP_MODE_DE, "Warp modus" },
         { IDMS_WARP_MODE_FR, "Mode turbo" },
         { IDMS_WARP_MODE_HU, "Hipergyors md" },
         { IDMS_WARP_MODE_IT, "Modalit turbo" },
         { IDMS_WARP_MODE_NL, "Warpmodus" },
         { IDMS_WARP_MODE_PL, "" },             
         { IDMS_WARP_MODE_SV, "Warplge" },
         { IDMS_WARP_MODE_TR, "Warp modu" },

         { IDMS_FULLSCREEN,    N_("Fullscreen") },
         { IDMS_FULLSCREEN_DA, "Fuldskrm" },
         { IDMS_FULLSCREEN_DE, "Vollbild" },
         { IDMS_FULLSCREEN_FR, "Priphrique plein cran" },
         { IDMS_FULLSCREEN_HU, "Teljes kperny" },
         { IDMS_FULLSCREEN_IT, "Schermo intero" },
         { IDMS_FULLSCREEN_NL, "Volscherm" },
         { IDMS_FULLSCREEN_PL, "" },             
         { IDMS_FULLSCREEN_SV, "Fullskrm" },
         { IDMS_FULLSCREEN_TR, "Tam ekran" },

         { IDMS_VIDEO_CACHE,    N_("Video cache") },
         { IDMS_VIDEO_CACHE_DA, "Grafikcache" },
         { IDMS_VIDEO_CACHE_DE, "Video cache" },
         { IDMS_VIDEO_CACHE_FR, "Cache vido" },
         { IDMS_VIDEO_CACHE_HU, "Kp gyorsttr" },
         { IDMS_VIDEO_CACHE_IT, "Cache video" },
         { IDMS_VIDEO_CACHE_NL, "Videocache" },
         { IDMS_VIDEO_CACHE_PL, "" },             
         { IDMS_VIDEO_CACHE_SV, "Grafikcache" },
         { IDMS_VIDEO_CACHE_TR, "Grnt nbellei" },

         { IDMS_DOUBLE_SIZE,    N_("Double size") },
         { IDMS_DOUBLE_SIZE_DA, "Dobbelt strrelse" },
         { IDMS_DOUBLE_SIZE_DE, "Doppelte Gre" },
         { IDMS_DOUBLE_SIZE_FR, "Taille double" },
         { IDMS_DOUBLE_SIZE_HU, "Dupla mret" },
         { IDMS_DOUBLE_SIZE_IT, "Dimensione doppia" },
         { IDMS_DOUBLE_SIZE_NL, "Dubbele grootte" },
         { IDMS_DOUBLE_SIZE_PL, "" },             
         { IDMS_DOUBLE_SIZE_SV, "Dubbel storlek" },
         { IDMS_DOUBLE_SIZE_TR, "ift boyut" },

         { IDMS_DOUBLE_SCAN,    N_("Double scan") },
         { IDMS_DOUBLE_SCAN_DA, "Dobbelt-skan" },
         { IDMS_DOUBLE_SCAN_DE, "Doppelt Scan" },
         { IDMS_DOUBLE_SCAN_FR, "Double scan" },
         { IDMS_DOUBLE_SCAN_HU, "Dupla psztzs" },
         { IDMS_DOUBLE_SCAN_IT, "Scansione doppia" },
         { IDMS_DOUBLE_SCAN_NL, "Dubbele scan" },
         { IDMS_DOUBLE_SCAN_PL, "" },             
         { IDMS_DOUBLE_SCAN_SV, "Dubbelskanning" },
         { IDMS_DOUBLE_SCAN_TR, "ift tarama" },

         { IDMS_SCALE2X,    N_("Scale2x") },
         { IDMS_SCALE2X_DA, "Scale2x" },
         { IDMS_SCALE2X_DE, "Scale2x" },
         { IDMS_SCALE2X_FR, "Scale2x" },
         { IDMS_SCALE2X_HU, "lsimts" },
         { IDMS_SCALE2X_IT, "Scale2x" },
         { IDMS_SCALE2X_NL, "Schaal2x" },
         { IDMS_SCALE2X_PL, "" },             
         { IDMS_SCALE2X_SV, "Scale2x" },
         { IDMS_SCALE2X_TR, "2x Genilet" },

         { IDMS_VDC_SETTINGS,    N_("VDC settings") },
         { IDMS_VDC_SETTINGS_PL, "VDC-indstillinger" },
         { IDMS_VDC_SETTINGS_DE, "VDC Einstellungen" },
         { IDMS_VDC_SETTINGS_FR, "Paramtres VDC" },
         { IDMS_VDC_SETTINGS_IT, "Impostazioni VDC" },
         { IDMS_VDC_SETTINGS_HU, "VDC belltsai" },
         { IDMS_VDC_SETTINGS_NL, "VDC-instellingen" },
         { IDMS_VDC_SETTINGS_PL, "" },             
         { IDMS_VDC_SETTINGS_SV, "VDC-instllningar" },
         { IDMS_VDC_SETTINGS_TR, "VDC ayarlar" },

         { IDMS_64KB_VIDEO_MEMORY,    N_("64KB video memory") },
         { IDMS_64KB_VIDEO_MEMORY_DA, "64KB grafikhukommelse" },
         { IDMS_64KB_VIDEO_MEMORY_DE, "64KB Bildschirm Speicher" },
         { IDMS_64KB_VIDEO_MEMORY_FR, "Mmoire d'affichage de 64Ko" },
         { IDMS_64KB_VIDEO_MEMORY_IT, "64KB di memoria video" },
         { IDMS_64KB_VIDEO_MEMORY_HU, "64KB kperny memria" },
         { IDMS_64KB_VIDEO_MEMORY_NL, "64KB videogeheugen" },
         { IDMS_64KB_VIDEO_MEMORY_PL, "" },             
         { IDMS_64KB_VIDEO_MEMORY_SV, "64KB grafikminne" },
         { IDMS_64KB_VIDEO_MEMORY_TR, "64KB grnt bellei" },

         { IDMS_VDC_REVISION,    N_("VDC revision") },
         { IDMS_VDC_REVISION_PL, "" },             
         { IDMS_VDC_REVISION_DE, "VDC Revision" },
         { IDMS_VDC_REVISION_FR, "" },             
         { IDMS_VDC_REVISION_IT, "Revisione VDC" },
         { IDMS_VDC_REVISION_HU, "" },             
         { IDMS_VDC_REVISION_NL, "VDC-revisie" },
         { IDMS_VDC_REVISION_PL, "" },             
         { IDMS_VDC_REVISION_SV, "VDC-revision" },
         { IDMS_VDC_REVISION_TR, "VDC revizyonu" },

         { IDMS_VDC_REV_0,    N_("Rev 0") },
         { IDMS_VDC_REV_0_PL, "" },             
         { IDMS_VDC_REV_0_DE, "Rev 0" },
         { IDMS_VDC_REV_0_FR, "" },             
         { IDMS_VDC_REV_0_IT, "Rev 0" },
         { IDMS_VDC_REV_0_HU, "" },             
         { IDMS_VDC_REV_0_NL, "Rev 0" },
         { IDMS_VDC_REV_0_PL, "" },             
         { IDMS_VDC_REV_0_SV, "Utgva 0" },
         { IDMS_VDC_REV_0_TR, "Dzeltme 0" },

         { IDMS_VDC_REV_1,    N_("Rev 1") },
         { IDMS_VDC_REV_1_PL, "" },             
         { IDMS_VDC_REV_1_DE, "Rev 1" },
         { IDMS_VDC_REV_1_FR, "" },             
         { IDMS_VDC_REV_1_IT, "Rev 1" },
         { IDMS_VDC_REV_1_HU, "" },             
         { IDMS_VDC_REV_1_NL, "Rev 1" },
         { IDMS_VDC_REV_1_PL, "" },             
         { IDMS_VDC_REV_1_SV, "Utgva 1" },
         { IDMS_VDC_REV_1_TR, "Dzeltme 1" },

         { IDMS_VDC_REV_2,    N_("Rev 2") },
         { IDMS_VDC_REV_2_PL, "" },             
         { IDMS_VDC_REV_2_DE, "Rev 2" },
         { IDMS_VDC_REV_2_FR, "" },             
         { IDMS_VDC_REV_2_IT, "Rev 2" },
         { IDMS_VDC_REV_2_HU, "" },             
         { IDMS_VDC_REV_2_NL, "Rev 2" },
         { IDMS_VDC_REV_2_PL, "" },             
         { IDMS_VDC_REV_2_SV, "Utgva 2" },
         { IDMS_VDC_REV_2_TR, "Dzeltme 2" },

         { IDMS_SWAP_JOYSTICKS,    N_("Swap Joysticks") },
         { IDMS_SWAP_JOYSTICKS_DA, "Byt om p joystickportene" },
         { IDMS_SWAP_JOYSTICKS_DE, "Joystick ports austauschen" },
         { IDMS_SWAP_JOYSTICKS_FR, "Interchanger les joysticks" },
         { IDMS_SWAP_JOYSTICKS_HU, "Botkormnyok felcserlse" },
         { IDMS_SWAP_JOYSTICKS_IT, "Scambia joystick" },
         { IDMS_SWAP_JOYSTICKS_NL, "Verwissel joysticks" },
         { IDMS_SWAP_JOYSTICKS_PL, "" },             
         { IDMS_SWAP_JOYSTICKS_SV, "Vxla spelportarna" },
         { IDMS_SWAP_JOYSTICKS_TR, "Joysticklerin Yerlerini Deitir" },

         { IDMS_SWAP_USERPORT_JOYSTICKS,    N_("Swap Userport Joysticks") },
         { IDMS_SWAP_USERPORT_JOYSTICKS_DA, "" },             
         { IDMS_SWAP_USERPORT_JOYSTICKS_DE, "Userport Joystick Ports austauschen" },
         { IDMS_SWAP_USERPORT_JOYSTICKS_FR, "" },             
         { IDMS_SWAP_USERPORT_JOYSTICKS_HU, "" },             
         { IDMS_SWAP_USERPORT_JOYSTICKS_IT, "Scambia joystick su userport" },
         { IDMS_SWAP_USERPORT_JOYSTICKS_NL, "Verwissel userport joysticks" },
         { IDMS_SWAP_USERPORT_JOYSTICKS_PL, "" },             
         { IDMS_SWAP_USERPORT_JOYSTICKS_SV, "Vxla anvndarportspelportarna" },
         { IDMS_SWAP_USERPORT_JOYSTICKS_TR, "Userport Joysticklerinin Yerlerini Deitir" },

         { IDMS_ENABLE_JOY_KEYS,    N_("Enable Joy Keys") },
         { IDMS_ENABLE_JOY_KEYS_DA, "Aktivr joystick via keyboard" },
         { IDMS_ENABLE_JOY_KEYS_DE, "Joystick Tasten aktivieren" },
         { IDMS_ENABLE_JOY_KEYS_FR, "" },             
         { IDMS_ENABLE_JOY_KEYS_HU, "Botkormny gombok engedlyezse" },
         { IDMS_ENABLE_JOY_KEYS_IT, "Attiva tasti joystick" },
         { IDMS_ENABLE_JOY_KEYS_NL, "Activeer Joy Keys" },
         { IDMS_ENABLE_JOY_KEYS_PL, "" },             
         { IDMS_ENABLE_JOY_KEYS_SV, "Aktivera styrspak via tangenter" },
         { IDMS_ENABLE_JOY_KEYS_TR, "Joy Tularn Aktif Et" },

         { IDMS_ENABLE_JOY_KEYS,    N_("Allow opposite joystick directions") },
         { IDMS_ENABLE_JOY_KEYS_DA, "" },             
         { IDMS_ENABLE_JOY_KEYS_DE, "Gegnberliegende Richtungen zulassen" },
         { IDMS_ENABLE_JOY_KEYS_FR, "" },             
         { IDMS_ENABLE_JOY_KEYS_HU, "" },             
         { IDMS_ENABLE_JOY_KEYS_IT, "" },             
         { IDMS_ENABLE_JOY_KEYS_NL, "Tegenovergestelde joystick richtingen toestaan" },
         { IDMS_ENABLE_JOY_KEYS_PL, "" },             
         { IDMS_ENABLE_JOY_KEYS_SV, "Tillt motsatta riktningar p styrspak" },
         { IDMS_ENABLE_JOY_KEYS_TR, "" },             

         { IDMS_SOUND_PLAYBACK,    N_("Sound playback") },
         { IDMS_SOUND_PLAYBACK_DA, "Sl lydemulering til" },
         { IDMS_SOUND_PLAYBACK_DE, "Sound Einschalten" },
         { IDMS_SOUND_PLAYBACK_FR, "Lecture audio" },
         { IDMS_SOUND_PLAYBACK_HU, "Hangok engedlyezse" },
         { IDMS_SOUND_PLAYBACK_IT, "Riproduzione del suono" },
         { IDMS_SOUND_PLAYBACK_NL, "Geluidsuitvoer" },
         { IDMS_SOUND_PLAYBACK_PL, "" },             
         { IDMS_SOUND_PLAYBACK_SV, "Aktivera ljudtergivning" },
         { IDMS_SOUND_PLAYBACK_TR, "Ses" },

         { IDMS_TRUE_DRIVE_EMU,    N_("True drive emulation") },
         { IDMS_TRUE_DRIVE_EMU_DA, "gte drev-emulering" },
         { IDMS_TRUE_DRIVE_EMU_DE, "Przise Floppy Emulation" },
         { IDMS_TRUE_DRIVE_EMU_FR, "Activer l'mulation relle des lecteurs" },
         { IDMS_TRUE_DRIVE_EMU_HU, "Vals lemezegysg emulci" },
         { IDMS_TRUE_DRIVE_EMU_IT, "Attiva l'emulazione hardware dei drive" },
         { IDMS_TRUE_DRIVE_EMU_NL, "Hardwarematige driveemulatie" },
         { IDMS_TRUE_DRIVE_EMU_PL, "" },             
         { IDMS_TRUE_DRIVE_EMU_SV, "kta diskettenhetsemulering" },
         { IDMS_TRUE_DRIVE_EMU_TR, "Gerek src emlasyonu" },

         { IDMS_AUTOSTART_HANDLE_TDE,    N_("Handle TDE for autostart") },
         { IDMS_AUTOSTART_HANDLE_TDE_DA, "Brug TDE ved autostart" },
         { IDMS_AUTOSTART_HANDLE_TDE_DE, "Autostart mit TDE" },
         { IDMS_AUTOSTART_HANDLE_TDE_FR, "" },             
         { IDMS_AUTOSTART_HANDLE_TDE_HU, "" },             
         { IDMS_AUTOSTART_HANDLE_TDE_IT, "Emulazione hardware dei drive all'avvio automatico" },
         { IDMS_AUTOSTART_HANDLE_TDE_NL, "Manipuleer hardwarematige drive emulatie bij autostarten" },
         { IDMS_AUTOSTART_HANDLE_TDE_PL, "" },             
         { IDMS_AUTOSTART_HANDLE_TDE_SV, "Hantera DE fr autostart" },
         { IDMS_AUTOSTART_HANDLE_TDE_TR, "TDE otomatik balatmay denetle" },

         { IDMS_VIRTUAL_DEVICE_TRAPS,    N_("Virtual device traps") },
         { IDMS_VIRTUAL_DEVICE_TRAPS_DA, "Virtuelle enheds-traps" },
         { IDMS_VIRTUAL_DEVICE_TRAPS_DE, "Virtuelle Gerte Traps" },
         { IDMS_VIRTUAL_DEVICE_TRAPS_FR, "Activer les priphriques virtuels" },
         { IDMS_VIRTUAL_DEVICE_TRAPS_HU, "Virtulis eszkzk ciklus kihagysa" },
         { IDMS_VIRTUAL_DEVICE_TRAPS_IT, "Attiva le periferiche virtuali" },
         { IDMS_VIRTUAL_DEVICE_TRAPS_NL, "Virtuele apparaattraps" },
         { IDMS_VIRTUAL_DEVICE_TRAPS_PL, "" },             
         { IDMS_VIRTUAL_DEVICE_TRAPS_SV, "Virtuella enhetstrap:ar" },
         { IDMS_VIRTUAL_DEVICE_TRAPS_TR, "Sanal a&ygt trapleri" },

         { IDMS_DRIVE_SYNC_FACTOR,    N_("Drive sync factor") },
         { IDMS_DRIVE_SYNC_FACTOR_DA, "Synkfaktor for diskettedrev" },
         { IDMS_DRIVE_SYNC_FACTOR_DE, "Laufwerkt Sync Faktor" },
         { IDMS_DRIVE_SYNC_FACTOR_FR, "Facteur de synchro du lecteur" },
         { IDMS_DRIVE_SYNC_FACTOR_HU, "Lemezegysg szinkron faktor" },
         { IDMS_DRIVE_SYNC_FACTOR_IT, "Fattore di sincronizzazione del drive" },
         { IDMS_DRIVE_SYNC_FACTOR_NL, "Drive synchronisatiefactor" },
         { IDMS_DRIVE_SYNC_FACTOR_PL, "" },             
         { IDMS_DRIVE_SYNC_FACTOR_SV, "Synkfaktor fr diskettstation" },
         { IDMS_DRIVE_SYNC_FACTOR_TR, "Src senkron faktr" },

         { IDMS_PAL,    N_("PAL") },
         { IDMS_PAL_DA, "PAL" },
         { IDMS_PAL_DE, "PAL" },
         { IDMS_PAL_FR, "PAL" },
         { IDMS_PAL_HU, "PAL" },
         { IDMS_PAL_IT, "PAL" },
         { IDMS_PAL_NL, "PAL" },
         { IDMS_PAL_PL, "PAL" },
         { IDMS_PAL_SV, "PAL" },
         { IDMS_PAL_TR, "PAL" },

         { IDMS_NTSC,    N_("NTSC") },
         { IDMS_NTSC_DA, "NTSC" },
         { IDMS_NTSC_DE, "NTSC" },
         { IDMS_NTSC_FR, "NTSC" },
         { IDMS_NTSC_HU, "NTSC" },
         { IDMS_NTSC_IT, "NTSC" },
         { IDMS_NTSC_NL, "NTSC" },
         { IDMS_NTSC_PL, "NTSC" },
         { IDMS_NTSC_SV, "NTSC" },
         { IDMS_NTSC_TR, "NTSC" },

         { IDMS_VIDEO_STANDARD,    N_("Video standard") },
         { IDMS_VIDEO_STANDARD_DA, "TV-standard" },
         { IDMS_VIDEO_STANDARD_DE, "Video standard" },
         { IDMS_VIDEO_STANDARD_FR, "Standard vido" },
         { IDMS_VIDEO_STANDARD_HU, "Vide szabvny" },
         { IDMS_VIDEO_STANDARD_IT, "Standard video" },
         { IDMS_VIDEO_STANDARD_NL, "Videostandaard" },
         { IDMS_VIDEO_STANDARD_PL, "" },             
         { IDMS_VIDEO_STANDARD_SV, "TV-standard" },
         { IDMS_VIDEO_STANDARD_TR, "Grnt standard" },

         { IDMS_PAL_G,    N_("PAL-G") },
         { IDMS_PAL_G_DA, "PAL-G" },
         { IDMS_PAL_G_DE, "PAL-G" },
         { IDMS_PAL_G_FR, "PAL-G" },
         { IDMS_PAL_G_HU, "PAL-G" },
         { IDMS_PAL_G_IT, "PAL-G" },
         { IDMS_PAL_G_NL, "PAL-G" },
         { IDMS_PAL_G_PL, "PAL-G" },
         { IDMS_PAL_G_SV, "PAL-G" },
         { IDMS_PAL_G_TR, "PAL-G" },

         { IDMS_NTSC_M,    N_("NTSC-M") },
         { IDMS_NTSC_M_DA, "NTSC-M" },
         { IDMS_NTSC_M_DE, "NTSC-M" },
         { IDMS_NTSC_M_FR, "NTSC-M" },
         { IDMS_NTSC_M_HU, "NTSC-M" },
         { IDMS_NTSC_M_IT, "NTSC-M" },
         { IDMS_NTSC_M_NL, "NTSC-M" },
         { IDMS_NTSC_M_PL, "NTSC-M" },
         { IDMS_NTSC_M_SV, "NTSC-M" },
         { IDMS_NTSC_M_TR, "NTSC-M" },

         { IDMS_OLD_NTSC_M,    N_("Old NTSC-M") },
         { IDMS_OLD_NTSC_M_DA, "Gammel NTSC-M" },
         { IDMS_OLD_NTSC_M_DE, "NTSC-M alt" },
         { IDMS_OLD_NTSC_M_FR, "Ancien NTSC-M" },
         { IDMS_OLD_NTSC_M_HU, "Rgi NTSC-M" },
         { IDMS_OLD_NTSC_M_IT, "NTSC-M vecchio" },
         { IDMS_OLD_NTSC_M_NL, "Oud NTSC-M" },
         { IDMS_OLD_NTSC_M_PL, "" },             
         { IDMS_OLD_NTSC_M_SV, "Gammal NTSC-M" },
         { IDMS_OLD_NTSC_M_TR, "Eski NTSC-M" },

         { IDMS_EMU_ID,    N_("Emulator Identification") },
         { IDMS_EMU_ID_DA, "Emulatoridentifikation" },
         { IDMS_EMU_ID_DE, "Emulator Identifikation" },
         { IDMS_EMU_ID_FR, "Identification de l'mulateur" },
         { IDMS_EMU_ID_HU, "Emultor azonost" },
         { IDMS_EMU_ID_IT, "Identificazione dell'emulatore" },
         { IDMS_EMU_ID_NL, "Emulatoridentificatie" },
         { IDMS_EMU_ID_PL, "" },             
         { IDMS_EMU_ID_SV, "Emulatoridentifiering" },
         { IDMS_EMU_ID_TR, "Emlatr Tespiti" },

         { IDMS_VIC_1112_IEEE_488,    N_("VIC-1112 IEEE 488 module") },
         { IDMS_VIC_1112_IEEE_488_DA, "VIC-1112 IEEE 488-modul" },
         { IDMS_VIC_1112_IEEE_488_DE, "VIC-1112 IEEE 488 Modul" },
         { IDMS_VIC_1112_IEEE_488_FR, "Module VIC-1112 IEEE 488" },
         { IDMS_VIC_1112_IEEE_488_HU, "VIC-1112 IEEE 488 modul" },
         { IDMS_VIC_1112_IEEE_488_IT, "Modulo VIC-1112 IEEE 488" },
         { IDMS_VIC_1112_IEEE_488_NL, "VIC-1112 IEEE 488-module" },
         { IDMS_VIC_1112_IEEE_488_PL, "" },             
         { IDMS_VIC_1112_IEEE_488_SV, "VIC-1112 IEEE 488-modul" },
         { IDMS_VIC_1112_IEEE_488_TR, "VIC-1112 IEEE 488 modl" },

         { IDMS_ENABLE_PADDLES,    N_("Enable Paddles") },
         { IDMS_ENABLE_PADDLES_DA, "" },             
         { IDMS_ENABLE_PADDLES_DE, "Paddles aktivieren" },
         { IDMS_ENABLE_PADDLES_FR, "" },             
         { IDMS_ENABLE_PADDLES_HU, "" },             
         { IDMS_ENABLE_PADDLES_IT, "Attiva paddle" },
         { IDMS_ENABLE_PADDLES_NL, "Aktiveer Paddles" },
         { IDMS_ENABLE_PADDLES_PL, "" },             
         { IDMS_ENABLE_PADDLES_SV, "Aktivera paddlar" },
         { IDMS_ENABLE_PADDLES_TR, "Paddle' aktif et" },

         { IDMS_IEEE_488_INTERFACE,    N_("IEEE 488 Interface emulation") },
         { IDMS_IEEE_488_INTERFACE_DA, "Emulering af IEEE 488-interface" },
         { IDMS_IEEE_488_INTERFACE_DE, "IEEE488 Schnittstellen-Emulation" },
         { IDMS_IEEE_488_INTERFACE_FR, "Interface d'mulation IEEE488" },
         { IDMS_IEEE_488_INTERFACE_HU, "IEEE488 interfsz emulci" },
         { IDMS_IEEE_488_INTERFACE_IT, "Emulazione dell'interfaccia IEEE 488" },
         { IDMS_IEEE_488_INTERFACE_NL, "IEEE 488 interfaceemulatie" },
         { IDMS_IEEE_488_INTERFACE_PL, "" },             
         { IDMS_IEEE_488_INTERFACE_SV, "Emulering av IEEE488-grnssnitt" },
         { IDMS_IEEE_488_INTERFACE_TR, "IEEE 488 Arabirimi emlasyonu" },

         { IDMS_GRAB_MOUSE,    N_("Grab mouse events") },
         { IDMS_GRAB_MOUSE_DA, "Fang mussehndelser" },
         { IDMS_GRAB_MOUSE_DE, "Maus Ereignisse abfangen" },
         { IDMS_GRAB_MOUSE_FR, "Attraper les vnements souris" },
         { IDMS_GRAB_MOUSE_HU, "Egr esemnyek elkapsa" },
         { IDMS_GRAB_MOUSE_IT, "Cattura eventi mouse" },
         { IDMS_GRAB_MOUSE_NL, "Gebruik de muis" },
         { IDMS_GRAB_MOUSE_PL, "" },             
         { IDMS_GRAB_MOUSE_SV, "Fnga mushndelser" },
         { IDMS_GRAB_MOUSE_TR, "Mouse olaylarn yakala" },

         { IDMS_PS2_MOUSE,    N_("PS/2 mouse emulation") },
         { IDMS_PS2_MOUSE_DA, "Emulering af PS/2-mus" },
         { IDMS_PS2_MOUSE_DE, "PS/2 Mausemulation" },
         { IDMS_PS2_MOUSE_FR, "" },             
         { IDMS_PS2_MOUSE_HU, "PS/2 egr emulci" },
         { IDMS_PS2_MOUSE_IT, "Emulazione del mouse PS/2" },
         { IDMS_PS2_MOUSE_NL, "PS/2 muis emulatie" },
         { IDMS_PS2_MOUSE_PL, "" },             
         { IDMS_PS2_MOUSE_SV, "PS/2-musemulering" },
         { IDMS_PS2_MOUSE_TR, "PS/2 mouse emlasyonu" },

         { IDMS_SETTINGS,    N_("Settings") },
         { IDMS_SETTINGS_DA, "Indstillinger" },
         { IDMS_SETTINGS_DE, "Einstellungen" },
         { IDMS_SETTINGS_FR, "Paramtres" },
         { IDMS_SETTINGS_HU, "Belltsok" },
         { IDMS_SETTINGS_IT, "Impostazioni" },
         { IDMS_SETTINGS_NL, "Instellingen" },
         { IDMS_SETTINGS_PL, "" },             
         { IDMS_SETTINGS_SV, "Instllningar" },
         { IDMS_SETTINGS_TR, "Ayarlar" },

         { IDMS_AUTOSTART_SETTINGS,    N_("Autostart settings...") },
         { IDMS_AUTOSTART_SETTINGS_DA, "" },             
         { IDMS_AUTOSTART_SETTINGS_DE, "Autostart Einstellungen..." },
         { IDMS_AUTOSTART_SETTINGS_FR, "" },             
         { IDMS_AUTOSTART_SETTINGS_HU, "" },             
         { IDMS_AUTOSTART_SETTINGS_IT, "" },             
         { IDMS_AUTOSTART_SETTINGS_NL, "Autostart instellingen..." },
         { IDMS_AUTOSTART_SETTINGS_PL, "" },             
         { IDMS_AUTOSTART_SETTINGS_SV, "Autostartinstllningar..." },
         { IDMS_AUTOSTART_SETTINGS_TR, "Otomatik balatma ayarlar..." },

         { IDMS_VIDEO_SETTINGS,    N_("Video settings...") },
         { IDMS_VIDEO_SETTINGS_DA, "Grafikindstillinger..." },
         { IDMS_VIDEO_SETTINGS_DE, "Video Einstellungen..." },
         { IDMS_VIDEO_SETTINGS_FR, "Paramtres vido..." },
         { IDMS_VIDEO_SETTINGS_HU, "Vide belltsai..." },
         { IDMS_VIDEO_SETTINGS_IT, "Impostazioni video..." },
         { IDMS_VIDEO_SETTINGS_NL, "Video-instellingen..." },
         { IDMS_VIDEO_SETTINGS_PL, "" },             
         { IDMS_VIDEO_SETTINGS_SV, "Grafikinstllningar..." },
         { IDMS_VIDEO_SETTINGS_TR, "Grnt ayalar..." },

         { IDMS_VIC_SETTINGS,    N_("VIC settings...") },
         { IDMS_VIC_SETTINGS_DA, "VIC-indstillinger..." },
         { IDMS_VIC_SETTINGS_DE, "VIC Einstellungen..." },
         { IDMS_VIC_SETTINGS_FR, "Paramtres VIC..." },
         { IDMS_VIC_SETTINGS_HU, "VIC belltsai..." },
         { IDMS_VIC_SETTINGS_IT, "Impostazioni VIC..." },
         { IDMS_VIC_SETTINGS_NL, "VIC-instellingen..." },
         { IDMS_VIC_SETTINGS_PL, "" },             
         { IDMS_VIC_SETTINGS_SV, "VIC-instllningar..." },
         { IDMS_VIC_SETTINGS_TR, "VIC ayarlar..." },

         { IDMS_CBM2_SETTINGS,    N_("CBM2 settings...") },
         { IDMS_CBM2_SETTINGS_DA, "CBM2-indstillinger..." },
         { IDMS_CBM2_SETTINGS_DE, "CBM2 Einstellungen..." },
         { IDMS_CBM2_SETTINGS_FR, "Paramtres CBM2..." },
         { IDMS_CBM2_SETTINGS_HU, "CBM belltsai..." },
         { IDMS_CBM2_SETTINGS_IT, "Impostazioni CBM2..." },
         { IDMS_CBM2_SETTINGS_NL, "CBM2-instellingen..." },
         { IDMS_CBM2_SETTINGS_PL, "" },             
         { IDMS_CBM2_SETTINGS_SV, "CBM2-instllningar..." },
         { IDMS_CBM2_SETTINGS_TR, "CBM2 ayarlar..." },

         { IDMS_SET_PET_MODEL,    N_("Change PET model") },
         { IDMS_SET_PET_MODEL_DA, "Skift PET-model" },
         { IDMS_SET_PET_MODEL_DE, "PET Modell verndern" },
         { IDMS_SET_PET_MODEL_FR, "" },             
         { IDMS_SET_PET_MODEL_HU, "PET modell kivlasztsa" },
         { IDMS_SET_PET_MODEL_IT, "Cambia modello di PET" },
         { IDMS_SET_PET_MODEL_NL, "Verander PET-model" },
         { IDMS_SET_PET_MODEL_PL, "" },             
         { IDMS_SET_PET_MODEL_SV, "Byt PET-modell" },
         { IDMS_SET_PET_MODEL_TR, "PET modelini deitir" },

         { IDMS_PET_SETTINGS,    N_("PET settings...") },
         { IDMS_PET_SETTINGS_DA, "PET-indstillinger..." },
         { IDMS_PET_SETTINGS_DE, "PET Einstellungen..." },
         { IDMS_PET_SETTINGS_FR, "Paramtres PET..." },
         { IDMS_PET_SETTINGS_HU, "PET belltsai..." },
         { IDMS_PET_SETTINGS_IT, "Impostazioni PET..." },
         { IDMS_PET_SETTINGS_NL, "PET-instellingen..." },
         { IDMS_PET_SETTINGS_PL, "" },             
         { IDMS_PET_SETTINGS_SV, "PET-instllningar..." },
         { IDMS_PET_SETTINGS_TR, "PET ayarlar..." },

         { IDMS_PERIPHERAL_SETTINGS,    N_("Peripheral settings...") },
         { IDMS_PERIPHERAL_SETTINGS_DA, "Ekstern-enhedsindstillinger..." },
         { IDMS_PERIPHERAL_SETTINGS_DE, "Peripherie Einstellungen..." },
         { IDMS_PERIPHERAL_SETTINGS_FR, "Paramtres des priphriques..." },
         { IDMS_PERIPHERAL_SETTINGS_HU, "Perifrik belltsai..." },
         { IDMS_PERIPHERAL_SETTINGS_IT, "Impostazioni periferiche..." },
         { IDMS_PERIPHERAL_SETTINGS_NL, "Randapparateninstellingen..." },
         { IDMS_PERIPHERAL_SETTINGS_PL, "" },             
         { IDMS_PERIPHERAL_SETTINGS_SV, "Instllningar fr kringutrustning..." },
         { IDMS_PERIPHERAL_SETTINGS_TR, "evresel ayarlar..." },

         { IDMS_DRIVE_SETTINGS,    N_("Drive settings...") },
         { IDMS_DRIVE_SETTINGS_DA, "Diskettedrevsindstillinger..." },
         { IDMS_DRIVE_SETTINGS_DE, "Floppy Einstellungen..." },
         { IDMS_DRIVE_SETTINGS_FR, "Paramtres des lecteurs..." },
         { IDMS_DRIVE_SETTINGS_HU, "Lemezegysg belltsai..." },
         { IDMS_DRIVE_SETTINGS_IT, "Impostazioni drive..." },
         { IDMS_DRIVE_SETTINGS_NL, "Drive-instellingen..." },
         { IDMS_DRIVE_SETTINGS_PL, "" },             
         { IDMS_DRIVE_SETTINGS_SV, "Diskettenhetsinstllningar..." },
         { IDMS_DRIVE_SETTINGS_TR, "Src ayarlar..." },

         { IDMS_DATASETTE_SETTINGS,    N_("Datasette settings...") },
         { IDMS_DATASETTE_SETTINGS_DA, "Datasetteindstillinger..." },
         { IDMS_DATASETTE_SETTINGS_DE, "Bandlaufwerk Einstellungen..." },
         { IDMS_DATASETTE_SETTINGS_FR, "Paramtres du datassette..." },
         { IDMS_DATASETTE_SETTINGS_HU, "Magn belltsai..." },
         { IDMS_DATASETTE_SETTINGS_IT, "Impostazioni registratore..." },
         { IDMS_DATASETTE_SETTINGS_NL, "Datasette-instellingen..." },
         { IDMS_DATASETTE_SETTINGS_PL, "" },             
         { IDMS_DATASETTE_SETTINGS_SV, "Datasetteinstllningar..." },
         { IDMS_DATASETTE_SETTINGS_TR, "Teyp ayarlar..." },

         { IDMS_PLUS4_SETTINGS,    N_("Plus4 settings...") },
         { IDMS_PLUS4_SETTINGS_DA, "Plus4-indstillinger..." },
         { IDMS_PLUS4_SETTINGS_DE, "Plus4 Einstellungen..." },
         { IDMS_PLUS4_SETTINGS_FR, "Paramtres Plus4..." },
         { IDMS_PLUS4_SETTINGS_HU, "Plus4 belltsai..." },
         { IDMS_PLUS4_SETTINGS_IT, "Impostazioni Plus4..." },
         { IDMS_PLUS4_SETTINGS_NL, "Plus4-instellingen..." },
         { IDMS_PLUS4_SETTINGS_PL, "" },             
         { IDMS_PLUS4_SETTINGS_SV, "Plus4-instllningar..." },
         { IDMS_PLUS4_SETTINGS_TR, "Plus4 ayarlar..." },

         { IDMS_VICII_SETTINGS,    N_("VIC-II settings...") },
         { IDMS_VICII_SETTINGS_DA, "VIC-II-indstillinger..." },
         { IDMS_VICII_SETTINGS_DE, "VIC-II Einstellungen..." },
         { IDMS_VICII_SETTINGS_FR, "Paramtres VIC-II..." },
         { IDMS_VICII_SETTINGS_HU, "VIC-II belltsai..." },
         { IDMS_VICII_SETTINGS_IT, "Impostazioni VIC-II..." },
         { IDMS_VICII_SETTINGS_NL, "VIC-II-instellingen..." },
         { IDMS_VICII_SETTINGS_PL, "" },             
         { IDMS_VICII_SETTINGS_SV, "VIC-II-instllningar..." },
         { IDMS_VICII_SETTINGS_TR, "VIC-II ayarlar..." },

         { IDMS_JOYSTICK_SETTINGS,    N_("Joystick settings...") },
         { IDMS_JOYSTICK_SETTINGS_DA, "Joystickindstillinger..." },
         { IDMS_JOYSTICK_SETTINGS_DE, "Joystick Einstellungen..." },
         { IDMS_JOYSTICK_SETTINGS_FR, "Paramtres des joysticks..." },
         { IDMS_JOYSTICK_SETTINGS_HU, "Botkormny belltsai..." },
         { IDMS_JOYSTICK_SETTINGS_IT, "Impostazioni joystick..." },
         { IDMS_JOYSTICK_SETTINGS_NL, "Joystick-instellingen..." },
         { IDMS_JOYSTICK_SETTINGS_PL, "" },             
         { IDMS_JOYSTICK_SETTINGS_SV, "Instllningar fr joystick..." },
         { IDMS_JOYSTICK_SETTINGS_TR, "Joystick ayarlar..." },

         { IDMS_JOYSTICK_DEVICE_SELECT,    N_("Joystick device selection") },
         { IDMS_JOYSTICK_DEVICE_SELECT_DA, "Joystick enheds-valg" },
         { IDMS_JOYSTICK_DEVICE_SELECT_DE, "Joystick Gerte Auswahl" },
         { IDMS_JOYSTICK_DEVICE_SELECT_FR, "" },             
         { IDMS_JOYSTICK_DEVICE_SELECT_HU, "Botkormny eszkz kivlasztsa" },
         { IDMS_JOYSTICK_DEVICE_SELECT_IT, "Selezione dispositivo joystick" },
         { IDMS_JOYSTICK_DEVICE_SELECT_NL, "Joystickapparaatselectie" },
         { IDMS_JOYSTICK_DEVICE_SELECT_PL, "" },             
         { IDMS_JOYSTICK_DEVICE_SELECT_SV, "enhetsinstllningar fr joystick" },
         { IDMS_JOYSTICK_DEVICE_SELECT_TR, "Joystick aygt seimi" },

         { IDMS_JOYSTICK_FIRE_SELECT,    N_("Joystick fire button selection") },
         { IDMS_JOYSTICK_FIRE_SELECT_DA, "Vlg fireknap for joystick" },
         { IDMS_JOYSTICK_FIRE_SELECT_DE, "Joystick Feuerknopf Wahl" },
         { IDMS_JOYSTICK_FIRE_SELECT_FR, "" },             
         { IDMS_JOYSTICK_FIRE_SELECT_HU, "Botkormny tzgomb kivlaszts" },
         { IDMS_JOYSTICK_FIRE_SELECT_IT, "Selezione pulsante di fuoco del joystick" },
         { IDMS_JOYSTICK_FIRE_SELECT_NL, "Joystickvuurknopselectie" },
         { IDMS_JOYSTICK_FIRE_SELECT_PL, "" },             
         { IDMS_JOYSTICK_FIRE_SELECT_SV, "val fr joystickens fire-knapp" },
         { IDMS_JOYSTICK_FIRE_SELECT_TR, "Joystick ate dmesi seimi" },

         { IDMS_KEYBOARD_SETTINGS,    N_("Keyboard settings...") },
         { IDMS_KEYBOARD_SETTINGS_DA, "Tastaturindstillinger..." },
         { IDMS_KEYBOARD_SETTINGS_DE, "Tastatur Einstellungen..." },
         { IDMS_KEYBOARD_SETTINGS_FR, "Paramtres du clavier..." },
         { IDMS_KEYBOARD_SETTINGS_HU, "Billentyzet belltsai..." },
         { IDMS_KEYBOARD_SETTINGS_IT, "Impostazioni tastiera..." },
         { IDMS_KEYBOARD_SETTINGS_NL, "Toetsenbordinstellingen..." },
         { IDMS_KEYBOARD_SETTINGS_PL, "" },             
         { IDMS_KEYBOARD_SETTINGS_SV, "Tangentbordsinstllningar..." },
         { IDMS_KEYBOARD_SETTINGS_TR, "Klavye ayarlar..." },

         { IDMS_MOUSE_SETTINGS,    N_("Mouse settings...") },
         { IDMS_MOUSE_SETTINGS_DA, "Musseindstillinger..." },
         { IDMS_MOUSE_SETTINGS_DE, "Maus Einstellungen..." },
         { IDMS_MOUSE_SETTINGS_FR, "" },             
         { IDMS_MOUSE_SETTINGS_HU, "Egr belltsai..." },
         { IDMS_MOUSE_SETTINGS_IT, "Impostazioni mouse..." },
         { IDMS_MOUSE_SETTINGS_NL, "Muis instellingen..." },
         { IDMS_MOUSE_SETTINGS_PL, "" },             
         { IDMS_MOUSE_SETTINGS_SV, "Musinstllningar..." },
         { IDMS_MOUSE_SETTINGS_TR, "Mouse ayarlar..." },

         { IDMS_SOUND_SETTINGS,    N_("Sound settings...") },
         { IDMS_SOUND_SETTINGS_DA, "Lydindstillinger..." },
         { IDMS_SOUND_SETTINGS_DE, "Sound Einstellungen..." },
         { IDMS_SOUND_SETTINGS_FR, "Paramtres son..." },
         { IDMS_SOUND_SETTINGS_HU, "Hang belltsai..." },
         { IDMS_SOUND_SETTINGS_IT, "Impostazioni audio..." },
         { IDMS_SOUND_SETTINGS_NL, "Geluidsinstellingen..." },
         { IDMS_SOUND_SETTINGS_PL, "" },             
         { IDMS_SOUND_SETTINGS_SV, "Ljudinstllningar..." },
         { IDMS_SOUND_SETTINGS_TR, "Ses ayarlar..." },

         { IDMS_SID_SETTINGS,    N_("SID settings...") },
         { IDMS_SID_SETTINGS_DA, "SID-indstillinger..." },
         { IDMS_SID_SETTINGS_DE, "SID Einstellungen..." },
         { IDMS_SID_SETTINGS_FR, "Paramtres SID..." },
         { IDMS_SID_SETTINGS_HU, "SID belltsai..." },
         { IDMS_SID_SETTINGS_IT, "Impostazioni SID..." },
         { IDMS_SID_SETTINGS_NL, "SID-instellingen..." },
         { IDMS_SID_SETTINGS_PL, "" },             
         { IDMS_SID_SETTINGS_SV, "SID-instllningar..." },
         { IDMS_SID_SETTINGS_TR, "SID ayarlar..." },

         { IDMS_COMPUTER_ROM_SETTINGS,    N_("Computer ROM settings...") },
         { IDMS_COMPUTER_ROM_SETTINGS_DA, "Compute ROM-indstillinger..." },
         { IDMS_COMPUTER_ROM_SETTINGS_DE, "Computer ROM Einstellungen..." },
         { IDMS_COMPUTER_ROM_SETTINGS_FR, "" },             
         { IDMS_COMPUTER_ROM_SETTINGS_HU, "ROM-ok belltsai..." },
         { IDMS_COMPUTER_ROM_SETTINGS_IT, "Impostazioni ROM del computer..." },
         { IDMS_COMPUTER_ROM_SETTINGS_NL, "Computer-ROM-instellingen..." },
         { IDMS_COMPUTER_ROM_SETTINGS_PL, "" },             
         { IDMS_COMPUTER_ROM_SETTINGS_SV, "ROM-instllningar fr dator..." },
         { IDMS_COMPUTER_ROM_SETTINGS_TR, "Bilgisayar ROM ayarlar..." },

         { IDMS_DRIVE_ROM_SETTINGS,    N_("Drive ROM settings...") },
         { IDMS_DRIVE_ROM_SETTINGS_DA, "Drev ROM-indstillinger..." },
         { IDMS_DRIVE_ROM_SETTINGS_DE, "Floppy ROM Einstellungen..." },
         { IDMS_DRIVE_ROM_SETTINGS_FR, "" },             
         { IDMS_DRIVE_ROM_SETTINGS_HU, "Lemezegysg ROM belltsai..." },
         { IDMS_DRIVE_ROM_SETTINGS_IT, "Impostazioni ROM del drive..." },
         { IDMS_DRIVE_ROM_SETTINGS_NL, "Drive-ROM-instellingen..." },
         { IDMS_DRIVE_ROM_SETTINGS_PL, "" },             
         { IDMS_DRIVE_ROM_SETTINGS_SV, "ROM-instllningar fr diskettenhet..." },
         { IDMS_DRIVE_ROM_SETTINGS_TR, "Src ROM ayarlar..." },

         { IDMS_RAM_SETTINGS,    N_("RAM settings...") },
         { IDMS_RAM_SETTINGS_DA, "RAM-indstillinger..." },
         { IDMS_RAM_SETTINGS_DE, "RAM Einstellungen..." },
         { IDMS_RAM_SETTINGS_FR, "Paramtres de la RAM..." },
         { IDMS_RAM_SETTINGS_HU, "RAM belltsai..." },
         { IDMS_RAM_SETTINGS_IT, "Impostazioni RAM..." },
         { IDMS_RAM_SETTINGS_NL, "RAM-instellingen..." },
         { IDMS_RAM_SETTINGS_PL, "" },             
         { IDMS_RAM_SETTINGS_SV, "RAM-instllningar..." },
         { IDMS_RAM_SETTINGS_TR, "RAM ayarlar..." },

         { IDMS_RS232_SETTINGS,    N_("RS232 settings...") },
         { IDMS_RS232_SETTINGS_DA, "RS232-indstillinger..." },
         { IDMS_RS232_SETTINGS_DE, "RS232 Einstellungen..." },
         { IDMS_RS232_SETTINGS_FR, "Paramtres RS232..." },
         { IDMS_RS232_SETTINGS_HU, "RS232 belltsai..." },
         { IDMS_RS232_SETTINGS_IT, "Impostazioni RS232..." },
         { IDMS_RS232_SETTINGS_NL, "RS232-instellingen..." },
         { IDMS_RS232_SETTINGS_PL, "" },             
         { IDMS_RS232_SETTINGS_SV, "RS232-instllningar..." },
         { IDMS_RS232_SETTINGS_TR, "RS232 ayarlar..." },

         { IDMS_C128_SETTINGS,    N_("C128 settings...") },
         { IDMS_C128_SETTINGS_DA, "C128-indstillinger..." },
         { IDMS_C128_SETTINGS_DE, "C128 Einstellungen..." },
         { IDMS_C128_SETTINGS_FR, "Paramtres C128..." },
         { IDMS_C128_SETTINGS_HU, "C128 belltsai..." },
         { IDMS_C128_SETTINGS_IT, "Impostazioni C128..." },
         { IDMS_C128_SETTINGS_NL, "C128-instellingen..." },
         { IDMS_C128_SETTINGS_PL, "" },             
         { IDMS_C128_SETTINGS_SV, "C128-instllningar..." },
         { IDMS_C128_SETTINGS_TR, "C128 ayarlar..." },

         { IDMS_CART_IO_SETTINGS,    N_("Cartridge/IO settings") },
         { IDMS_CART_IO_SETTINGS_DA, "Modul/IO-indstillinger" },
         { IDMS_CART_IO_SETTINGS_DE, "Erweiterungsmodul Einstellungen" },
         { IDMS_CART_IO_SETTINGS_FR, "Paramtres E/S cartouche" },
         { IDMS_CART_IO_SETTINGS_HU, "Cartridge/IO belltsai" },
         { IDMS_CART_IO_SETTINGS_IT, "Impostazioni I/O della cartuccia" },
         { IDMS_CART_IO_SETTINGS_NL, "Cartridge/IO-instellingen" },
         { IDMS_CART_IO_SETTINGS_PL, "" },             
         { IDMS_CART_IO_SETTINGS_SV, "Instllningar fr insticksmoduler..." },
         { IDMS_CART_IO_SETTINGS_TR, "Kartu/G ayarlar" },

         { IDMS_REU_SETTINGS,    N_("REU settings...") },
         { IDMS_REU_SETTINGS_DA, "REU-indstillinger..." },
         { IDMS_REU_SETTINGS_DE, "REU Einstellungen..." },
         { IDMS_REU_SETTINGS_FR, "Paramtres REU..." },
         { IDMS_REU_SETTINGS_HU, "REU belltsai..." },
         { IDMS_REU_SETTINGS_IT, "Impostazioni REU..." },
         { IDMS_REU_SETTINGS_NL, "REU-instellingen..." },
         { IDMS_REU_SETTINGS_PL, "" },             
         { IDMS_REU_SETTINGS_SV, "REU-instllningar..." },
         { IDMS_REU_SETTINGS_TR, "REU ayarlar..." },

         { IDMS_GEORAM_SETTINGS,    N_("GEORAM settings...") },
         { IDMS_GEORAM_SETTINGS_DA, "GEORAM-indstillinger..." },
         { IDMS_GEORAM_SETTINGS_DE, "GEORAM Einstellungen..." },
         { IDMS_GEORAM_SETTINGS_FR, "Paramtres GEORAM..." },
         { IDMS_GEORAM_SETTINGS_HU, "GEORAM belltsai..." },
         { IDMS_GEORAM_SETTINGS_IT, "Impostazioni GEORAM..." },
         { IDMS_GEORAM_SETTINGS_NL, "GEORAM-instellingen..." },
         { IDMS_GEORAM_SETTINGS_PL, "" },             
         { IDMS_GEORAM_SETTINGS_SV, "GEORAM-instllningar..." },
         { IDMS_GEORAM_SETTINGS_TR, "GEORAM ayarlar..." },

         { IDMS_RAMCART_SETTINGS,    N_("RAMCART settings...") },
         { IDMS_RAMCART_SETTINGS_DA, "RAMCART-indstillinger..." },
         { IDMS_RAMCART_SETTINGS_DE, "RAMCART Einstellungen..." },
         { IDMS_RAMCART_SETTINGS_FR, "Paramtres RAMCART..." },
         { IDMS_RAMCART_SETTINGS_HU, "RAMCART belltsai..." },
         { IDMS_RAMCART_SETTINGS_IT, "Impostazioni RAMCART..." },
         { IDMS_RAMCART_SETTINGS_NL, "RAMCART-instellingen..." },
         { IDMS_RAMCART_SETTINGS_PL, "" },             
         { IDMS_RAMCART_SETTINGS_SV, "RAMCART-instllningar..." },
         { IDMS_RAMCART_SETTINGS_TR, "RAMCART ayarlar..." },

         { IDMS_DQBB_SETTINGS,    N_("Double Quick Brown Box settings...") },
         { IDMS_DQBB_SETTINGS_DA, "Double Quick Brown Box indstillinger..." },
         { IDMS_DQBB_SETTINGS_DE, "Double Quick Brown Box Einstellungen..." },
         { IDMS_DQBB_SETTINGS_FR, "" },             
         { IDMS_DQBB_SETTINGS_HU, "Double Quick Brown Box belltsok..." },
         { IDMS_DQBB_SETTINGS_IT, "Impostazioni Double Quick Brown Box..." },
         { IDMS_DQBB_SETTINGS_NL, "Double Quick Brown Box instellingen..." },
         { IDMS_DQBB_SETTINGS_PL, "" },             
         { IDMS_DQBB_SETTINGS_SV, "Instllninga fr dubbel Quick Brown Box..." },
         { IDMS_DQBB_SETTINGS_TR, "Double Quick Brown Box ayarlar..." },

         { IDMS_ISEPIC_SETTINGS,    N_("Isepic settings...") },
         { IDMS_ISEPIC_SETTINGS_DA, "Isepic-indstillinger..." },
         { IDMS_ISEPIC_SETTINGS_DE, "Isepic Einstellungen..." },
         { IDMS_ISEPIC_SETTINGS_FR, "" },             
         { IDMS_ISEPIC_SETTINGS_HU, "Isepic belltsai..." },
         { IDMS_ISEPIC_SETTINGS_IT, "Impostazioni Isepic..." },
         { IDMS_ISEPIC_SETTINGS_NL, "Isepic instellingen..." },
         { IDMS_ISEPIC_SETTINGS_PL, "" },             
         { IDMS_ISEPIC_SETTINGS_SV, "Isepic-instllningar..." },
         { IDMS_ISEPIC_SETTINGS_TR, "Isepic ayarlar..." },

         { IDMS_PLUS60K_SETTINGS,    N_("PLUS60K settings...") },
         { IDMS_PLUS60K_SETTINGS_DA, "PLUS60K-indstillinger..." },
         { IDMS_PLUS60K_SETTINGS_DE, "PLUS60K Einstellungen..." },
         { IDMS_PLUS60K_SETTINGS_FR, "Paramtres PLUS60K..." },
         { IDMS_PLUS60K_SETTINGS_HU, "PLUS60K belltsai..." },
         { IDMS_PLUS60K_SETTINGS_IT, "Impostazioni PLUS60K..." },
         { IDMS_PLUS60K_SETTINGS_NL, "PLUS60K-instellingen..." },
         { IDMS_PLUS60K_SETTINGS_PL, "" },             
         { IDMS_PLUS60K_SETTINGS_SV, "PLUS60K-instllningar..." },
         { IDMS_PLUS60K_SETTINGS_TR, "PLUS60K ayarlar..." },

         { IDS_PLUS256K_FILENAME,    N_("PLUS256K file") },
         { IDS_PLUS256K_FILENAME_DA, "PLUS256K-indstillinger..." },
         { IDS_PLUS256K_FILENAME_DE, "PLUS256K Datei" },
         { IDS_PLUS256K_FILENAME_FR, "Fichier PLUS256K" },
         { IDS_PLUS256K_FILENAME_HU, "PLUS256K fjl" },
         { IDS_PLUS256K_FILENAME_IT, "File PLUS256K" },
         { IDS_PLUS256K_FILENAME_NL, "PLUS256K-bestand" },
         { IDS_PLUS256K_FILENAME_PL, "" },             
         { IDS_PLUS256K_FILENAME_SV, "PLUS256K-fil" },
         { IDS_PLUS256K_FILENAME_TR, "PLUS256K ayarlar..." },

         { IDS_PLUS256K_FILENAME_SELECT,    N_("Select file for PLUS256K") },
         { IDS_PLUS256K_FILENAME_SELECT_DA, "Vlg fil for PLUS256K" },
         { IDS_PLUS256K_FILENAME_SELECT_DE, "Datei fr PLUS256K auswhlen" },
         { IDS_PLUS256K_FILENAME_SELECT_FR, "Slectionner fichier pour PLUS256K" },
         { IDS_PLUS256K_FILENAME_SELECT_HU, "Vlasszon fjlt a PLUS256K-hoz" },
         { IDS_PLUS256K_FILENAME_SELECT_IT, "Seleziona file per PLUS256K" },
         { IDS_PLUS256K_FILENAME_SELECT_NL, "Selecteer bestand voor PLUS256K" },
         { IDS_PLUS256K_FILENAME_SELECT_PL, "" },             
         { IDS_PLUS256K_FILENAME_SELECT_SV, "Ange fil fr PLUS256K" },
         { IDS_PLUS256K_FILENAME_SELECT_TR, "PLUS256K iin dosya sein" },

         { IDMS_PLUS256K_SETTINGS,    N_("PLUS256K settings...") },
         { IDMS_PLUS256K_SETTINGS_DA, "PLUS256K-indstillinger..." },
         { IDMS_PLUS256K_SETTINGS_DE, "PLUS256K Einstellungen..." },
         { IDMS_PLUS256K_SETTINGS_FR, "Paramtres PLUS256K..." },
         { IDMS_PLUS256K_SETTINGS_HU, "PLUS256K belltsai..." },
         { IDMS_PLUS256K_SETTINGS_IT, "Impostazioni PLUS256K..." },
         { IDMS_PLUS256K_SETTINGS_NL, "PLUS256K-instellingen..." },
         { IDMS_PLUS256K_SETTINGS_PL, "" },             
         { IDMS_PLUS256K_SETTINGS_SV, "PLUS256K-instllningar..." },
         { IDMS_PLUS256K_SETTINGS_TR, "PLUS256K ayarlar..." },

         { IDMS_256K_SETTINGS,    N_("256K settings...") },
         { IDMS_256K_SETTINGS_DA, "256K-indstillinger..." },
         { IDMS_256K_SETTINGS_DE, "256K Einstellungen..." },
         { IDMS_256K_SETTINGS_FR, "Paramtres 256K..." },
         { IDMS_256K_SETTINGS_HU, "256K belltsai..." },
         { IDMS_256K_SETTINGS_IT, "Impostazioni 256K..." },
         { IDMS_256K_SETTINGS_NL, "256K-instellingen..." },
         { IDMS_256K_SETTINGS_PL, "" },             
         { IDMS_256K_SETTINGS_SV, "256K-instllningar..." },
         { IDMS_256K_SETTINGS_TR, "256K ayarlar..." },

         { IDMS_IDE64_SETTINGS,    N_("IDE64 settings...") },
         { IDMS_IDE64_SETTINGS_DA, "IDE64-indstillinger..." },
         { IDMS_IDE64_SETTINGS_DE, "IDE64 Einstellungen..." },
         { IDMS_IDE64_SETTINGS_FR, "Paramtres IDE64..." },
         { IDMS_IDE64_SETTINGS_HU, "IDE64 belltsai..." },
         { IDMS_IDE64_SETTINGS_IT, "Impostazioni IDE64..." },
         { IDMS_IDE64_SETTINGS_NL, "IDE64-instellingen..." },
         { IDMS_IDE64_SETTINGS_PL, "" },             
         { IDMS_IDE64_SETTINGS_SV, "IDE64-instllningar..." },
         { IDMS_IDE64_SETTINGS_TR, "IDE64 ayarlar..." },

         { IDMS_MMC64_SETTINGS,    N_("MMC64 settings...") },
         { IDMS_MMC64_SETTINGS_DA, "MMC64-indstillinger..." },
         { IDMS_MMC64_SETTINGS_DE, "MMC64 Einstellungen..." },
         { IDMS_MMC64_SETTINGS_FR, "Paramtres MMC64..." },
         { IDMS_MMC64_SETTINGS_HU, "MMC64 belltsai..." },
         { IDMS_MMC64_SETTINGS_IT, "Impostazioni MMC64..." },
         { IDMS_MMC64_SETTINGS_NL, "MMC64-instellingen..." },
         { IDMS_MMC64_SETTINGS_PL, "" },             
         { IDMS_MMC64_SETTINGS_SV, "MMC64-instllningar..." },
         { IDMS_MMC64_SETTINGS_TR, "MMC64 ayarlar..." },

         { IDMS_DIGIMAX_SETTINGS,    N_("Digimax settings...") },
         { IDMS_DIGIMAX_SETTINGS_DA, "Digimaxindstillinger..." },
         { IDMS_DIGIMAX_SETTINGS_DE, "Digimax Einstellungen..." },
         { IDMS_DIGIMAX_SETTINGS_FR, "" },             
         { IDMS_DIGIMAX_SETTINGS_HU, "Digimax belltsai..." },
         { IDMS_DIGIMAX_SETTINGS_IT, "Impostazioni digimax..." },
         { IDMS_DIGIMAX_SETTINGS_NL, "Digimaxinstellingen..." },
         { IDMS_DIGIMAX_SETTINGS_PL, "" },             
         { IDMS_DIGIMAX_SETTINGS_SV, "Digimaxinstllningar..." },
         { IDMS_DIGIMAX_SETTINGS_TR, "Digimax ayarlar..." },

         { IDMS_SFX_SE_SETTINGS,    N_("SFX Sound Expander settings...") },
         { IDMS_SFX_SE_SETTINGS_DA, "" },             
         { IDMS_SFX_SE_SETTINGS_DE, "SFX Sound Expander Einstellungen..." },
         { IDMS_SFX_SE_SETTINGS_FR, "" },             
         { IDMS_SFX_SE_SETTINGS_HU, "" },             
         { IDMS_SFX_SE_SETTINGS_IT, "Impostazioni SFX Sound Expander..." },
         { IDMS_SFX_SE_SETTINGS_NL, "SFX Sound Expander instellingen..." },
         { IDMS_SFX_SE_SETTINGS_PL, "" },             
         { IDMS_SFX_SE_SETTINGS_SV, "Instllningar fr SFX Sound Expander..." },
         { IDMS_SFX_SE_SETTINGS_TR, "SFX Sound Expander ayarlar..." },

         { IDMS_EASYFLASH_SETTINGS,    N_("EasyFlash settings...") },
         { IDMS_EASYFLASH_SETTINGS_DA, "" },             
         { IDMS_EASYFLASH_SETTINGS_DE, "EasyFlash Einstellungen..." },
         { IDMS_EASYFLASH_SETTINGS_FR, "" },             
         { IDMS_EASYFLASH_SETTINGS_HU, "" },             
         { IDMS_EASYFLASH_SETTINGS_IT, "Impostazioni EasyFlash..." },
         { IDMS_EASYFLASH_SETTINGS_NL, "EasyFlash instellingen..." },
         { IDMS_EASYFLASH_SETTINGS_PL, "" },             
         { IDMS_EASYFLASH_SETTINGS_SV, "EasyFlash-instllningar..." },
         { IDMS_EASYFLASH_SETTINGS_TR, "EasyFlash ayarlar..." },

         { IDMS_ENABLE_SFX_SS,    N_("Enable SFX Sound Sampler") },
         { IDMS_ENABLE_SFX_SS_DA, "" },             
         { IDMS_ENABLE_SFX_SS_DE, "SFX Sound Sampler aktivieren" },
         { IDMS_ENABLE_SFX_SS_FR, "" },             
         { IDMS_ENABLE_SFX_SS_HU, "" },             
         { IDMS_ENABLE_SFX_SS_IT, "Attiva SFX Sound Sampler" },
         { IDMS_ENABLE_SFX_SS_NL, "Activeer SFX Sound Sampler" },
         { IDMS_ENABLE_SFX_SS_PL, "" },             
         { IDMS_ENABLE_SFX_SS_SV, "Aktivera SFX Sound Sampler" },
         { IDMS_ENABLE_SFX_SS_TR, "SFX Sound Sampler' Aktif Et" },

         { IDMS_ETHERNET_SETTINGS,    N_("Ethernet settings...") },
         { IDMS_ETHERNET_SETTINGS_DA, "Ethernetindstillinger..." },
         { IDMS_ETHERNET_SETTINGS_DE, "Ethernet Einstellungen..." },
         { IDMS_ETHERNET_SETTINGS_FR, "mulation Ethernet..." },
         { IDMS_ETHERNET_SETTINGS_HU, "Ethernet belltsai..." },
         { IDMS_ETHERNET_SETTINGS_IT, "Impostazioni Ethernet..." },
         { IDMS_ETHERNET_SETTINGS_NL, "Ethernetinstellingen..." },
         { IDMS_ETHERNET_SETTINGS_PL, "" },             
         { IDMS_ETHERNET_SETTINGS_SV, "Ethernetinstllningar..." },
         { IDMS_ETHERNET_SETTINGS_TR, "Ethernet ayarlar..." },

         { IDMS_ACIA_SETTINGS,    N_("ACIA settings...") },
         { IDMS_ACIA_SETTINGS_DA, "ACIA-indstillinger..." },
         { IDMS_ACIA_SETTINGS_DE, "ACIA Einstellungen..." },
         { IDMS_ACIA_SETTINGS_FR, "Paramtres ACIA..." },
         { IDMS_ACIA_SETTINGS_HU, "ACIA belltsai..." },
         { IDMS_ACIA_SETTINGS_IT, "Impostazioni ACIA..." },
         { IDMS_ACIA_SETTINGS_NL, "ACIA-instellingen..." },
         { IDMS_ACIA_SETTINGS_PL, "" },             
         { IDMS_ACIA_SETTINGS_SV, "ACIA-instllningar..." },
         { IDMS_ACIA_SETTINGS_TR, "ACIA ayarlar..." },

         { IDMS_PETREU_SETTINGS,    N_("PET REU settings...") },
         { IDMS_PETREU_SETTINGS_DA, "PET REU-indstillinger..." },
         { IDMS_PETREU_SETTINGS_DE, "PET REU Einstellungen..." },
         { IDMS_PETREU_SETTINGS_FR, "Paramtres PET REU..." },
         { IDMS_PETREU_SETTINGS_HU, "PET REU belltsai..." },
         { IDMS_PETREU_SETTINGS_IT, "Impostazioni PET REU..." },
         { IDMS_PETREU_SETTINGS_NL, "PET REU-instellingen..." },
         { IDMS_PETREU_SETTINGS_PL, "" },             
         { IDMS_PETREU_SETTINGS_SV, "PET REU-instllningar..." },
         { IDMS_PETREU_SETTINGS_TR, "PET REU ayarlar..." },

         { IDMS_SIDCART_SETTINGS,    N_("SID cart settings...") },
         { IDMS_SIDCART_SETTINGS_DA, "SID-indstillinger..." },
         { IDMS_SIDCART_SETTINGS_DE, "SID Modul Einstellungen..." },
         { IDMS_SIDCART_SETTINGS_FR, "" },             
         { IDMS_SIDCART_SETTINGS_HU, "SID krtya belltsai..." },
         { IDMS_SIDCART_SETTINGS_IT, "Impostazioni cartuccia SID..." },
         { IDMS_SIDCART_SETTINGS_NL, "SID-cartinstellingen..." },
         { IDMS_SIDCART_SETTINGS_PL, "" },             
         { IDMS_SIDCART_SETTINGS_SV, "SID-modulinstllningar..." },
         { IDMS_SIDCART_SETTINGS_TR, "SID kartu ayarlar..." },

         { IDMS_FINAL_EXPANSION_WRITEBACK,    N_("Enable Final Expansion write-back") },
         { IDMS_FINAL_EXPANSION_WRITEBACK_DA, "" },             
         { IDMS_FINAL_EXPANSION_WRITEBACK_DE, "Final Expansion rckschreiben aktivieren" },
         { IDMS_FINAL_EXPANSION_WRITEBACK_FR, "" },             
         { IDMS_FINAL_EXPANSION_WRITEBACK_HU, "" },             
         { IDMS_FINAL_EXPANSION_WRITEBACK_IT, "" },             
         { IDMS_FINAL_EXPANSION_WRITEBACK_NL, "Activeer terug schrijven van Final Expansion" },
         { IDMS_FINAL_EXPANSION_WRITEBACK_PL, "" },             
         { IDMS_FINAL_EXPANSION_WRITEBACK_SV, "Aktivera Final Expansion-terskrivning" },
         { IDMS_FINAL_EXPANSION_WRITEBACK_TR, "" },             

         { IDMS_MEGACART_WRITEBACK,    N_("Enable Mega-Cart non-volatile RAM write-back") },
         { IDMS_MEGACART_WRITEBACK_DA, "" },             
         { IDMS_MEGACART_WRITEBACK_DE, "Mega-Cart nicht-flchtiges RAM rckschreiben aktivieren" },
         { IDMS_MEGACART_WRITEBACK_FR, "" },             
         { IDMS_MEGACART_WRITEBACK_HU, "" },             
         { IDMS_MEGACART_WRITEBACK_IT, "" },             
         { IDMS_MEGACART_WRITEBACK_NL, "Activeer terug schrijven van Mega-Cart non-volatile RAM" },
         { IDMS_MEGACART_WRITEBACK_PL, "" },             
         { IDMS_MEGACART_WRITEBACK_SV, "Aktivera Mega-Cart NvRAM-terskrivning" },
         { IDMS_MEGACART_WRITEBACK_TR, "" },             

         { IDMS_MEGACART_WRITEBACK_FILE,    N_("Select Mega-Cart non-volatile RAM file") },
         { IDMS_MEGACART_WRITEBACK_FILE_DA, "" },             
         { IDMS_MEGACART_WRITEBACK_FILE_DE, "Mega-Cart nicht-flchtiges RAM Datei whlen" },
         { IDMS_MEGACART_WRITEBACK_FILE_FR, "" },             
         { IDMS_MEGACART_WRITEBACK_FILE_HU, "" },             
         { IDMS_MEGACART_WRITEBACK_FILE_IT, "" },             
         { IDMS_MEGACART_WRITEBACK_FILE_NL, "Selecteer Mega-Cart non-volatile RAM bestand" },
         { IDMS_MEGACART_WRITEBACK_FILE_PL, "" },             
         { IDMS_MEGACART_WRITEBACK_FILE_SV, "Vlj NvRAM-fil fr Mega-Cart" },
         { IDMS_MEGACART_WRITEBACK_FILE_TR, "" },             

         { IDMS_C64DTV_SETTINGS,    N_("C64DTV settings...") },
         { IDMS_C64DTV_SETTINGS_DA, "C64DTV-indstillinger..." },
         { IDMS_C64DTV_SETTINGS_DE, "C64DTV Einstellungen..." },
         { IDMS_C64DTV_SETTINGS_FR, "" },             
         { IDMS_C64DTV_SETTINGS_HU, "C64DTV belltsai..." },
         { IDMS_C64DTV_SETTINGS_IT, "Impostazioni C64DTV..." },
         { IDMS_C64DTV_SETTINGS_NL, "C64DTV instellingen..." },
         { IDMS_C64DTV_SETTINGS_PL, "" },             
         { IDMS_C64DTV_SETTINGS_SV, "C64DTV-instllningar..." },
         { IDMS_C64DTV_SETTINGS_TR, "C64DTV ayarlar..." },

         { IDMS_RS232_USERPORT_SETTINGS,    N_("RS232 userport settings...") },
         { IDMS_RS232_USERPORT_SETTINGS_DA, "RS232-brugerportindstillinger..." },
         { IDMS_RS232_USERPORT_SETTINGS_DE, "RS232 Userport Einstellungen..." },
         { IDMS_RS232_USERPORT_SETTINGS_FR, "Paramtres RS232 userport..." },
         { IDMS_RS232_USERPORT_SETTINGS_HU, "RS232 userport belltsai..." },
         { IDMS_RS232_USERPORT_SETTINGS_IT, "Impostazioni RS232 su userport..." },
         { IDMS_RS232_USERPORT_SETTINGS_NL, "RS232-userportinstellingen..." },
         { IDMS_RS232_USERPORT_SETTINGS_PL, "" },             
         { IDMS_RS232_USERPORT_SETTINGS_SV, "RS232-anvndarportinstllningar..." },
         { IDMS_RS232_USERPORT_SETTINGS_TR, "RS232 userport ayarlar..." },

         { IDMS_SAVE_CURRENT_SETTINGS_FILE,    N_("Save current settings to specified file") },
         { IDMS_SAVE_CURRENT_SETTINGS_FILE_DA, "Gem indstillinger som" },
         { IDMS_SAVE_CURRENT_SETTINGS_FILE_DE, "Speichere Einstellungen in angegebene Datei" },
         { IDMS_SAVE_CURRENT_SETTINGS_FILE_FR, "" },             
         { IDMS_SAVE_CURRENT_SETTINGS_FILE_HU, "Jelenlegi belltsok mentse adott fjlba" },
         { IDMS_SAVE_CURRENT_SETTINGS_FILE_IT, "Salva le impostazioni attuali sul file specificato" },
         { IDMS_SAVE_CURRENT_SETTINGS_FILE_NL, "Huidige instellingen opslaan naar opgegeven bestand" },
         { IDMS_SAVE_CURRENT_SETTINGS_FILE_PL, "" },             
         { IDMS_SAVE_CURRENT_SETTINGS_FILE_SV, "Spara nuvarande instllningar till den angivna filen" },
         { IDMS_SAVE_CURRENT_SETTINGS_FILE_TR, "Belirtilen dosyaya geerli ayarlar kaydet" },

         { IDMS_LOAD_SAVED_SETTINGS_FILE,    N_("Load settings from specified file") },
         { IDMS_LOAD_SAVED_SETTINGS_FILE_DA, "Indls indstillinger fra" },
         { IDMS_LOAD_SAVED_SETTINGS_FILE_DE, "Lade Einstellungen von Datei" },
         { IDMS_LOAD_SAVED_SETTINGS_FILE_FR, "" },             
         { IDMS_LOAD_SAVED_SETTINGS_FILE_HU, "Belltsok betltse a megadott fjlbl" },
         { IDMS_LOAD_SAVED_SETTINGS_FILE_IT, "Carica le impostazioni dal file specificato" },
         { IDMS_LOAD_SAVED_SETTINGS_FILE_NL, "Instelling laden van opgegevn bestand" },
         { IDMS_LOAD_SAVED_SETTINGS_FILE_PL, "" },             
         { IDMS_LOAD_SAVED_SETTINGS_FILE_SV, "Ls instllningar frn den angivna filen" },
         { IDMS_LOAD_SAVED_SETTINGS_FILE_TR, "Belirtilen dosyadan ayarlar ykle" },

         { IDMS_SAVE_CURRENT_SETTINGS,    N_("Save current settings") },
         { IDMS_SAVE_CURRENT_SETTINGS_DA, "Gen aktuelle indstillinger" },
         { IDMS_SAVE_CURRENT_SETTINGS_DE, "Einstellungen speichern" },
         { IDMS_SAVE_CURRENT_SETTINGS_FR, "Enregistrer les paramtres courants" },
         { IDMS_SAVE_CURRENT_SETTINGS_HU, "Jelenlegi belltsok mentse" },
         { IDMS_SAVE_CURRENT_SETTINGS_IT, "Salva le impostazioni attuali" },
         { IDMS_SAVE_CURRENT_SETTINGS_NL, "Huidige instellingen opslaan" },
         { IDMS_SAVE_CURRENT_SETTINGS_PL, "" },             
         { IDMS_SAVE_CURRENT_SETTINGS_SV, "Spara nuvarande instllningar" },
         { IDMS_SAVE_CURRENT_SETTINGS_TR, "Geerli ayarlar kaydet" },

         { IDMS_LOAD_SAVED_SETTINGS,    N_("Load saved settings") },
         { IDMS_LOAD_SAVED_SETTINGS_DA, "Indls gemte indstillinger" },
         { IDMS_LOAD_SAVED_SETTINGS_DE, "Einstellungen Laden" },
         { IDMS_LOAD_SAVED_SETTINGS_FR, "Charger les paramtres" },
         { IDMS_LOAD_SAVED_SETTINGS_HU, "Belltsok betltse" },
         { IDMS_LOAD_SAVED_SETTINGS_IT, "Carica le impostazioni salvate" },
         { IDMS_LOAD_SAVED_SETTINGS_NL, "Opgeslagen instelling laden" },
         { IDMS_LOAD_SAVED_SETTINGS_PL, "" },             
         { IDMS_LOAD_SAVED_SETTINGS_SV, "Ls sparade instllningar" },
         { IDMS_LOAD_SAVED_SETTINGS_TR, "Kaydedilmi ayarlar ykle" },

         { IDMS_SET_DEFAULT_SETTINGS,    N_("Set default settings") },
         { IDMS_SET_DEFAULT_SETTINGS_DA, "Gendan standard indstillinger" },
         { IDMS_SET_DEFAULT_SETTINGS_DE, "Wiederherstellen Standard Einstellungen" },
         { IDMS_SET_DEFAULT_SETTINGS_FR, "Rtablir les paramtres par dfaut" },
         { IDMS_SET_DEFAULT_SETTINGS_HU, "Alaprtelmezs belltsa" },
         { IDMS_SET_DEFAULT_SETTINGS_IT, "Ripristina le impostazioni originarie" },
         { IDMS_SET_DEFAULT_SETTINGS_NL, "Herstel standaardinstellingen" },
         { IDMS_SET_DEFAULT_SETTINGS_PL, "" },             
         { IDMS_SET_DEFAULT_SETTINGS_SV, "terstll frvalda instllningar" },
         { IDMS_SET_DEFAULT_SETTINGS_TR, "Mevcut ayarlar varsaylan olarak kaydet" },

         { IDMS_SAVE_SETTING_ON_EXIT,    N_("Save settings on exit") },
         { IDMS_SAVE_SETTING_ON_EXIT_DA, "Gem indstillinger nr programmet afsluttes" },
         { IDMS_SAVE_SETTING_ON_EXIT_DE, "Einstellungen beim Beenden speichern" },
         { IDMS_SAVE_SETTING_ON_EXIT_FR, "Enregistrer les paramtres  la sortie" },
         { IDMS_SAVE_SETTING_ON_EXIT_HU, "Belltsok mentse kilpskor" },
         { IDMS_SAVE_SETTING_ON_EXIT_IT, "Salva le impostazioni in uscita" },
         { IDMS_SAVE_SETTING_ON_EXIT_NL, "Sla instellingen op bij afsluiten" },
         { IDMS_SAVE_SETTING_ON_EXIT_PL, "" },             
         { IDMS_SAVE_SETTING_ON_EXIT_SV, "Spara instllningar vid avslut" },
         { IDMS_SAVE_SETTING_ON_EXIT_TR, "kta ayarlar kaydet" },

         { IDMS_CONFIRM_ON_EXIT,    N_("Confirm on exit") },
         { IDMS_CONFIRM_ON_EXIT_DA, "Bekrft programafslutning" },
         { IDMS_CONFIRM_ON_EXIT_DE, "Besttigung beim Beenden" },
         { IDMS_CONFIRM_ON_EXIT_FR, "Confirmation  la sortie" },
         { IDMS_CONFIRM_ON_EXIT_HU, "Megersts kilpskor" },
         { IDMS_CONFIRM_ON_EXIT_IT, "Conferma all'uscita" },
         { IDMS_CONFIRM_ON_EXIT_NL, "Bevestigen bij afsluiten" },
         { IDMS_CONFIRM_ON_EXIT_PL, "" },             
         { IDMS_CONFIRM_ON_EXIT_SV, "Bekrfta avslutning" },
         { IDMS_CONFIRM_ON_EXIT_TR, "kta teyit et" },

         { IDMS_HELP,    N_("Help") },
         { IDMS_HELP_DA, "Hjlp" },
         { IDMS_HELP_DE, "Hilfe" },
         { IDMS_HELP_FR, "Aide" },
         { IDMS_HELP_HU, "Segtsg" },
         { IDMS_HELP_IT, "Aiuto" },
         { IDMS_HELP_NL, "Help" },
         { IDMS_HELP_PL, "" },             
         { IDMS_HELP_SV, "Hjlp" },
         { IDMS_HELP_TR, "Yardm" },

         { IDMS_ABOUT,    N_("About...") },
         { IDMS_ABOUT_DA, "Om..." },
         { IDMS_ABOUT_DE, "ber VICE..." },
         { IDMS_ABOUT_FR, " Propos..." },
         { IDMS_ABOUT_HU, "Nvjegy..." },
         { IDMS_ABOUT_IT, "Informazioni..." },
         { IDMS_ABOUT_NL, "Over VICE..." },
         { IDMS_ABOUT_PL, "" },             
         { IDMS_ABOUT_SV, "Om VICE..." },
         { IDMS_ABOUT_TR, "Hakknda..." },

         { IDMS_COMMAND_LINE_OPTIONS,    N_("Command line options") },
         { IDMS_COMMAND_LINE_OPTIONS_DA, "Kommandolinjeparametre" },
         { IDMS_COMMAND_LINE_OPTIONS_DE, "Kommandozeilen Optionen" },
         { IDMS_COMMAND_LINE_OPTIONS_FR, "Options de ligne de commande" },
         { IDMS_COMMAND_LINE_OPTIONS_HU, "Parancssori opcik" },
         { IDMS_COMMAND_LINE_OPTIONS_IT, "Opzioni da riga di comando" },
         { IDMS_COMMAND_LINE_OPTIONS_NL, "Commando invoer opties" },
         { IDMS_COMMAND_LINE_OPTIONS_PL, "" },             
         { IDMS_COMMAND_LINE_OPTIONS_SV, "Kommandoradsflaggor" },
         { IDMS_COMMAND_LINE_OPTIONS_TR, "Komut satr seenekleri" },

         { IDMS_CONTRIBUTORS,    N_("Contributors") },
         { IDMS_CONTRIBUTORS_DA, "Bidragsydere" },
         { IDMS_CONTRIBUTORS_DE, "VICE Hackers" },
         { IDMS_CONTRIBUTORS_FR, "Contributeurs" },
         { IDMS_CONTRIBUTORS_HU, "Kzremkdk" },
         { IDMS_CONTRIBUTORS_IT, "Collaboratori" },
         { IDMS_CONTRIBUTORS_NL, "Medewerkers aan het VICE project" },
         { IDMS_CONTRIBUTORS_PL, "" },             
         { IDMS_CONTRIBUTORS_SV, "Bidragslmnare" },
         { IDMS_CONTRIBUTORS_TR, "Katlmclar" },

         { IDMS_LICENSE,    N_("License") },
         { IDMS_LICENSE_DA, "Licens" },
         { IDMS_LICENSE_DE, "Lizenz" },
         { IDMS_LICENSE_FR, "License" },
         { IDMS_LICENSE_HU, "Licensz" },
         { IDMS_LICENSE_IT, "Licenza" },
         { IDMS_LICENSE_NL, "Licentie" },
         { IDMS_LICENSE_PL, "" },             
         { IDMS_LICENSE_SV, "Licens" },
         { IDMS_LICENSE_TR, "Lisans" },

         { IDMS_NO_WARRANTY,    N_("No warranty") },
         { IDMS_NO_WARRANTY_DA, "Ingen garanti" },
         { IDMS_NO_WARRANTY_DE, "Keine Garantie!" },
         { IDMS_NO_WARRANTY_FR, "Aucune garantie!" },
         { IDMS_NO_WARRANTY_HU, "Nincs garancia!" },
         { IDMS_NO_WARRANTY_IT, "Nessuna garanzia" },
         { IDMS_NO_WARRANTY_NL, "Geen garantie" },
         { IDMS_NO_WARRANTY_PL, "" },             
         { IDMS_NO_WARRANTY_SV, "Ingen garanti" },
         { IDMS_NO_WARRANTY_TR, "Garanti verilmez" },

         { IDMS_LANGUAGE_INTERNATIONAL,    N_("International") },
         { IDMS_LANGUAGE_INTERNATIONAL_DA, "International" },
         { IDMS_LANGUAGE_INTERNATIONAL_DE, "International" },
         { IDMS_LANGUAGE_INTERNATIONAL_FR, "" },             
         { IDMS_LANGUAGE_INTERNATIONAL_HU, "Nemzetkzi" },
         { IDMS_LANGUAGE_INTERNATIONAL_IT, "Internazionale" },
         { IDMS_LANGUAGE_INTERNATIONAL_NL, "Internationaal" },
         { IDMS_LANGUAGE_INTERNATIONAL_PL, "" },             
         { IDMS_LANGUAGE_INTERNATIONAL_SV, "Internationell" },
         { IDMS_LANGUAGE_INTERNATIONAL_TR, "Uluslararas" },

         { IDMS_LANGUAGE_ENGLISH,    N_("English") },
         { IDMS_LANGUAGE_ENGLISH_DA, "Engelsk" },
         { IDMS_LANGUAGE_ENGLISH_DE, "Englisch" },
         { IDMS_LANGUAGE_ENGLISH_FR, "Anglais" },
         { IDMS_LANGUAGE_ENGLISH_HU, "Angol" },
         { IDMS_LANGUAGE_ENGLISH_IT, "Inglese" },
         { IDMS_LANGUAGE_ENGLISH_NL, "Engels" },
         { IDMS_LANGUAGE_ENGLISH_PL, "" },             
         { IDMS_LANGUAGE_ENGLISH_SV, "Engelska" },
         { IDMS_LANGUAGE_ENGLISH_TR, "ngilizce" },

         { IDMS_LANGUAGE_DANISH,    N_("Danish") },
         { IDMS_LANGUAGE_DANISH_DA, "Dansk" },
         { IDMS_LANGUAGE_DANISH_DE, "Dnisch" },
         { IDMS_LANGUAGE_DANISH_FR, "" },             
         { IDMS_LANGUAGE_DANISH_HU, "" },             
         { IDMS_LANGUAGE_DANISH_IT, "Danese" },
         { IDMS_LANGUAGE_DANISH_NL, "Deens" },
         { IDMS_LANGUAGE_DANISH_PL, "" },             
         { IDMS_LANGUAGE_DANISH_SV, "Danska" },
         { IDMS_LANGUAGE_DANISH_TR, "Danimarkaca" },

         { IDMS_LANGUAGE_GERMAN,    N_("German") },
         { IDMS_LANGUAGE_GERMAN_DA, "Tysk" },
         { IDMS_LANGUAGE_GERMAN_DE, "Deutsch" },
         { IDMS_LANGUAGE_GERMAN_FR, "Allemand" },
         { IDMS_LANGUAGE_GERMAN_HU, "Nmet" },
         { IDMS_LANGUAGE_GERMAN_IT, "Tedesco" },
         { IDMS_LANGUAGE_GERMAN_NL, "Duits" },
         { IDMS_LANGUAGE_GERMAN_PL, "" },             
         { IDMS_LANGUAGE_GERMAN_SV, "Tyska" },
         { IDMS_LANGUAGE_GERMAN_TR, "Almanca" },

         { IDMS_LANGUAGE_FINNISH,    N_("Finnish") },
         { IDMS_LANGUAGE_FINNISH_DA, "Finsk" },
         { IDMS_LANGUAGE_FINNISH_DE, "Finnisch" },
         { IDMS_LANGUAGE_FINNISH_FR, "" },             
         { IDMS_LANGUAGE_FINNISH_HU, "Finn" },
         { IDMS_LANGUAGE_FINNISH_IT, "Finlandese" },
         { IDMS_LANGUAGE_FINNISH_NL, "Fins" },
         { IDMS_LANGUAGE_FINNISH_PL, "" },             
         { IDMS_LANGUAGE_FINNISH_SV, "Finska" },
         { IDMS_LANGUAGE_FINNISH_TR, "Fince" },

         { IDMS_LANGUAGE_FRENCH,    N_("French") },
         { IDMS_LANGUAGE_FRENCH_DA, "Fransk" },
         { IDMS_LANGUAGE_FRENCH_DE, "Franzsisch" },
         { IDMS_LANGUAGE_FRENCH_FR, "Franais" },
         { IDMS_LANGUAGE_FRENCH_HU, "Francia" },
         { IDMS_LANGUAGE_FRENCH_IT, "Francese" },
         { IDMS_LANGUAGE_FRENCH_NL, "Frans" },
         { IDMS_LANGUAGE_FRENCH_PL, "" },             
         { IDMS_LANGUAGE_FRENCH_SV, "Franska" },
         { IDMS_LANGUAGE_FRENCH_TR, "Franszca" },

         { IDMS_LANGUAGE_HUNGARIAN,    N_("Hungarian") },
         { IDMS_LANGUAGE_HUNGARIAN_DA, "Ungersk" },
         { IDMS_LANGUAGE_HUNGARIAN_DE, "Ungarisch" },
         { IDMS_LANGUAGE_HUNGARIAN_FR, "Hungarian" },
         { IDMS_LANGUAGE_HUNGARIAN_HU, "Magyar" },
         { IDMS_LANGUAGE_HUNGARIAN_IT, "Ungherese" },
         { IDMS_LANGUAGE_HUNGARIAN_NL, "Hongaars" },
         { IDMS_LANGUAGE_HUNGARIAN_PL, "" },             
         { IDMS_LANGUAGE_HUNGARIAN_SV, "Ungerska" },
         { IDMS_LANGUAGE_HUNGARIAN_TR, "Macarca" },

         { IDMS_LANGUAGE_ITALIAN,    N_("Italian") },
         { IDMS_LANGUAGE_ITALIAN_DA, "Italiensk" },
         { IDMS_LANGUAGE_ITALIAN_DE, "Italienisch" },
         { IDMS_LANGUAGE_ITALIAN_FR, "Italien" },
         { IDMS_LANGUAGE_ITALIAN_HU, "Olasz" },
         { IDMS_LANGUAGE_ITALIAN_IT, "Italiano" },
         { IDMS_LANGUAGE_ITALIAN_NL, "Italiaans" },
         { IDMS_LANGUAGE_ITALIAN_PL, "" },             
         { IDMS_LANGUAGE_ITALIAN_SV, "Italienska" },
         { IDMS_LANGUAGE_ITALIAN_TR, "talyanca" },

         { IDMS_LANGUAGE_DUTCH,    N_("Dutch") },
         { IDMS_LANGUAGE_DUTCH_DA, "Hollandsk" },
         { IDMS_LANGUAGE_DUTCH_DE, "Hollndisch" },
         { IDMS_LANGUAGE_DUTCH_FR, "Hollandais" },
         { IDMS_LANGUAGE_DUTCH_HU, "Holland" },
         { IDMS_LANGUAGE_DUTCH_IT, "Olandese" },
         { IDMS_LANGUAGE_DUTCH_NL, "Nederlands" },
         { IDMS_LANGUAGE_DUTCH_PL, "" },             
         { IDMS_LANGUAGE_DUTCH_SV, "Nederlndska" },
         { IDMS_LANGUAGE_DUTCH_TR, "Hollandaca" },

         { IDMS_LANGUAGE_NORWEGIAN,    N_("Norwegian") },
         { IDMS_LANGUAGE_NORWEGIAN_DA, "Norsk" },
         { IDMS_LANGUAGE_NORWEGIAN_DE, "Norwegisch" },
         { IDMS_LANGUAGE_NORWEGIAN_FR, "" },             
         { IDMS_LANGUAGE_NORWEGIAN_HU, "Norvg" },
         { IDMS_LANGUAGE_NORWEGIAN_IT, "Norvegese" },
         { IDMS_LANGUAGE_NORWEGIAN_NL, "Noors" },
         { IDMS_LANGUAGE_NORWEGIAN_PL, "" },             
         { IDMS_LANGUAGE_NORWEGIAN_SV, "Norska" },
         { IDMS_LANGUAGE_NORWEGIAN_TR, "Norvee" },

         { IDMS_LANGUAGE_POLISH,    N_("Polish") },
         { IDMS_LANGUAGE_POLISH_DA, "Polsk" },
         { IDMS_LANGUAGE_POLISH_DE, "Polnisch" },
         { IDMS_LANGUAGE_POLISH_FR, "Polonais" },
         { IDMS_LANGUAGE_POLISH_HU, "Lengyel" },
         { IDMS_LANGUAGE_POLISH_IT, "Polacco" },
         { IDMS_LANGUAGE_POLISH_NL, "Pools" },
         { IDMS_LANGUAGE_POLISH_PL, "" },             
         { IDMS_LANGUAGE_POLISH_SV, "Polska" },
         { IDMS_LANGUAGE_POLISH_TR, "Polonyaca" },

         { IDMS_LANGUAGE_SWEDISH,    N_("Swedish") },
         { IDMS_LANGUAGE_SWEDISH_DA, "Svensk" },
         { IDMS_LANGUAGE_SWEDISH_DE, "Schwedisch" },
         { IDMS_LANGUAGE_SWEDISH_FR, "Sudois" },
         { IDMS_LANGUAGE_SWEDISH_HU, "Svd" },
         { IDMS_LANGUAGE_SWEDISH_IT, "Svedese" },
         { IDMS_LANGUAGE_SWEDISH_NL, "Zweeds" },
         { IDMS_LANGUAGE_SWEDISH_PL, "" },             
         { IDMS_LANGUAGE_SWEDISH_SV, "Svenska" },
         { IDMS_LANGUAGE_SWEDISH_TR, "svee" },

         { IDMS_LANGUAGE_TURKISH,    N_("Turkish") },
         { IDMS_LANGUAGE_TURKISH_DA, "" },             
         { IDMS_LANGUAGE_TURKISH_DE, "Trkisch" },
         { IDMS_LANGUAGE_TURKISH_FR, "" },             
         { IDMS_LANGUAGE_TURKISH_HU, "" },             
         { IDMS_LANGUAGE_TURKISH_IT, "Turco" },
         { IDMS_LANGUAGE_TURKISH_NL, "Turks" },
         { IDMS_LANGUAGE_TURKISH_PL, "" },             
         { IDMS_LANGUAGE_TURKISH_SV, "Turkiska" },
         { IDMS_LANGUAGE_TURKISH_TR, "Trke" },

         { IDMS_LANGUAGE,    N_("Language") },
         { IDMS_LANGUAGE_DA, "Sprog" },
         { IDMS_LANGUAGE_DE, "Sprache" },
         { IDMS_LANGUAGE_FR, "Langage" },
         { IDMS_LANGUAGE_HU, "Nyelv" },
         { IDMS_LANGUAGE_IT, "Lingua" },
         { IDMS_LANGUAGE_NL, "Taal" },
         { IDMS_LANGUAGE_PL, "" },             
         { IDMS_LANGUAGE_SV, "Sprk" },
         { IDMS_LANGUAGE_TR, "Dil" },

         { IDMS_FULLSCREEN_STATUSBAR,    N_("Fullscreen Statusbar") },
         { IDMS_FULLSCREEN_STATUSBAR_DA, "Statusbar i fullscreen" },
         { IDMS_FULLSCREEN_STATUSBAR_DE, "Vollbild Statusleiste" },
         { IDMS_FULLSCREEN_STATUSBAR_FR, "" },             
         { IDMS_FULLSCREEN_STATUSBAR_HU, "llapotsor teljes kpernynl" },
         { IDMS_FULLSCREEN_STATUSBAR_IT, "Barra di stato nella modalit a tutto schermo" },
         { IDMS_FULLSCREEN_STATUSBAR_NL, "Volscherm Statusbalk" },
         { IDMS_FULLSCREEN_STATUSBAR_PL, "" },             
         { IDMS_FULLSCREEN_STATUSBAR_SV, "Status rad vid fullskrm" },
         { IDMS_FULLSCREEN_STATUSBAR_TR, "Tam ekran durum ubuu" },

         { IDMS_VIDEO_OVERLAY,    N_("Video overlay") },
         { IDMS_VIDEO_OVERLAY_DA, "Video-overlay" },
         { IDMS_VIDEO_OVERLAY_DE, "Video Overlay" },
         { IDMS_VIDEO_OVERLAY_FR, "" },             
         { IDMS_VIDEO_OVERLAY_HU, "Vide overlay" },
         { IDMS_VIDEO_OVERLAY_IT, "Overlay video" },
         { IDMS_VIDEO_OVERLAY_NL, "Video overlay" },
         { IDMS_VIDEO_OVERLAY_PL, "" },             
         { IDMS_VIDEO_OVERLAY_SV, "Video overlay" },
         { IDMS_VIDEO_OVERLAY_TR, "Grnt bindirme" },

         { IDMS_START_SOUND_RECORD,    N_("Start Sound Record...") },
         { IDMS_START_SOUND_RECORD_DA, "Start lydoptagelse..." },
         { IDMS_START_SOUND_RECORD_DE, "Tonaufnahme starten..." },
         { IDMS_START_SOUND_RECORD_FR, "" },             
         { IDMS_START_SOUND_RECORD_HU, "Hangfelvtel indtsa..." },
         { IDMS_START_SOUND_RECORD_IT, "Avvia la registrazione audio..." },
         { IDMS_START_SOUND_RECORD_NL, "Start Geluidsopname..." },
         { IDMS_START_SOUND_RECORD_PL, "" },             
         { IDMS_START_SOUND_RECORD_SV, "Starta ljudinspelning..." },
         { IDMS_START_SOUND_RECORD_TR, "Ses Kaydn Balat..." },

         { IDMS_STOP_SOUND_RECORD,    N_("Stop Sound Record") },
         { IDMS_STOP_SOUND_RECORD_DA, "Stop lydoptagelse" },
         { IDMS_STOP_SOUND_RECORD_DE, "Tonaufnahme stoppen" },
         { IDMS_STOP_SOUND_RECORD_FR, "" },             
         { IDMS_STOP_SOUND_RECORD_HU, "Hangfelvtel lelltsa..." },
         { IDMS_STOP_SOUND_RECORD_IT, "Interrompi la registrazione audio" },
         { IDMS_STOP_SOUND_RECORD_NL, "Stop Geluidsopname" },
         { IDMS_STOP_SOUND_RECORD_PL, "" },             
         { IDMS_STOP_SOUND_RECORD_SV, "Stoppa ljudinspelning" },
         { IDMS_STOP_SOUND_RECORD_TR, "Ses Kaydn Durdur..." },

         { IDMS_PAL_EMULATION,    N_("PAL Emulation") },
         { IDMS_PAL_EMULATION_DA, "PAL-emulering" },
         { IDMS_PAL_EMULATION_DE, "PAL Emulation" },
         { IDMS_PAL_EMULATION_FR, "mulation PAL" },
         { IDMS_PAL_EMULATION_HU, "PAL emulci" },
         { IDMS_PAL_EMULATION_IT, "Emulazione PAL" },
         { IDMS_PAL_EMULATION_NL, "PAL-emulatie" },
         { IDMS_PAL_EMULATION_PL, "" },             
         { IDMS_PAL_EMULATION_SV, "PAL-emulering" },
         { IDMS_PAL_EMULATION_TR, "PAL Emlasyonu" },

                                                                                   

         { IDMES_SETTINGS_SAVED_SUCCESS,    N_("Settings saved successfully.") },
         { IDMES_SETTINGS_SAVED_SUCCESS_DA, "Indstillingerne er gemt." },
         { IDMES_SETTINGS_SAVED_SUCCESS_DE, "Einstellungen erfolgreich gespeichert." },
         { IDMES_SETTINGS_SAVED_SUCCESS_FR, "Sauvegarde des paramtres effectue correctement." },
         { IDMES_SETTINGS_SAVED_SUCCESS_HU, "Belltsok sikeresen elmentve." },
         { IDMES_SETTINGS_SAVED_SUCCESS_IT, "Impostazioni salvate con successo." },
         { IDMES_SETTINGS_SAVED_SUCCESS_NL, "Instellingen met succes opgeslagen." },
         { IDMES_SETTINGS_SAVED_SUCCESS_PL, "" },             
         { IDMES_SETTINGS_SAVED_SUCCESS_SV, "Instllningarna har sparats." },
         { IDMES_SETTINGS_SAVED_SUCCESS_TR, "Ayarlar baaryla kaydedildi." },

         { IDMES_SETTINGS_LOAD_SUCCESS,    N_("Settings loaded successfully.") },
         { IDMES_SETTINGS_LOAD_SUCCESS_DA, "Indstillinger indlst med success." },
         { IDMES_SETTINGS_LOAD_SUCCESS_DE, "Einstellungen erfolgreich geladen." },
         { IDMES_SETTINGS_LOAD_SUCCESS_FR, "Chargement des paramtres russi." },
         { IDMES_SETTINGS_LOAD_SUCCESS_HU, "Belltsok sikeresen elmentve." },
         { IDMES_SETTINGS_LOAD_SUCCESS_IT, "Impostazioni caricate con successo." },
         { IDMES_SETTINGS_LOAD_SUCCESS_NL, "Instellingen met succes geladen." },
         { IDMES_SETTINGS_LOAD_SUCCESS_PL, "" },             
         { IDMES_SETTINGS_LOAD_SUCCESS_SV, "Instllningarna har lsts in." },
         { IDMES_SETTINGS_LOAD_SUCCESS_TR, "Ayarlar baaryla yklendi." },

         { IDMES_DFLT_SETTINGS_RESTORED,    N_("Default settings restored.") },
         { IDMES_DFLT_SETTINGS_RESTORED_DA, "Standardindstillinger gendannet." },
         { IDMES_DFLT_SETTINGS_RESTORED_DE, "Standard wiederhergestellt." },
         { IDMES_DFLT_SETTINGS_RESTORED_FR, "Paramtres par dfaut restaurs." },
         { IDMES_DFLT_SETTINGS_RESTORED_HU, "Alaprtelmezett belltsok visszalltva." },
         { IDMES_DFLT_SETTINGS_RESTORED_IT, "Impostazioni predefinite ripristinate." },
         { IDMES_DFLT_SETTINGS_RESTORED_NL, "Standaardinstellingen hersteld." },
         { IDMES_DFLT_SETTINGS_RESTORED_PL, "" },             
         { IDMES_DFLT_SETTINGS_RESTORED_SV, "Frvalda instllningar terstllda." },
         { IDMES_DFLT_SETTINGS_RESTORED_TR, "Varsaylan ayarlara geri dnld." },

         { IDMES_VICE_MESSAGE,    N_("VICE Message") },
         { IDMES_VICE_MESSAGE_DA, "VICE-besked" },
         { IDMES_VICE_MESSAGE_DE, "VICE Nachricht" },
         { IDMES_VICE_MESSAGE_FR, "Message VICE" },
         { IDMES_VICE_MESSAGE_HU, "VICE zenet" },
         { IDMES_VICE_MESSAGE_IT, "Messaggio di VICE" },
         { IDMES_VICE_MESSAGE_NL, "VICE-bericht" },
         { IDMES_VICE_MESSAGE_PL, "" },             
         { IDMES_VICE_MESSAGE_SV, "VICE-meddelande" },
         { IDMES_VICE_MESSAGE_TR, "VICE Mesaj" },

         { IDMES_OK,    N_("OK") },
         { IDMES_OK_DA, "OK" },
         { IDMES_OK_DE, "OK" },
         { IDMES_OK_FR, "OK" },
         { IDMES_OK_HU, "OK" },
         { IDMES_OK_IT, "OK" },
         { IDMES_OK_NL, "OK" },
         { IDMES_OK_PL, "OK" },
         { IDMES_OK_SV, "OK" },
         { IDMES_OK_TR, "Tamam" },

         { IDMES_VICE_CONTRIBUTORS,    N_("VICE contributors") },
         { IDMES_VICE_CONTRIBUTORS_DA, "VICE bidragsydere" },
         { IDMES_VICE_CONTRIBUTORS_DE, "VICE Hackers" },
         { IDMES_VICE_CONTRIBUTORS_FR, "VICE Contributeurs" },
         { IDMES_VICE_CONTRIBUTORS_HU, "VICE - kzremkdk" },
         { IDMES_VICE_CONTRIBUTORS_IT, "Collaboratori al progetto VICE" },
         { IDMES_VICE_CONTRIBUTORS_NL, "Medewerkers aan het VICE project" },
         { IDMES_VICE_CONTRIBUTORS_PL, "" },             
         { IDMES_VICE_CONTRIBUTORS_SV, "VICE Bidragslmnare" },
         { IDMES_VICE_CONTRIBUTORS_TR, "VICE katlmclar" },

         { IDMES_WHO_MADE_WHAT,    N_("Who made what?") },
         { IDMES_WHO_MADE_WHAT_DA, "Hvem har lavet hvad?" },
         { IDMES_WHO_MADE_WHAT_DE, "Wer hat was gemacht?" },
         { IDMES_WHO_MADE_WHAT_FR, "Qui fait quoi?" },
         { IDMES_WHO_MADE_WHAT_HU, "Ki mit csinlt?" },
         { IDMES_WHO_MADE_WHAT_IT, "Chi ha fatto cosa?" },
         { IDMES_WHO_MADE_WHAT_NL, "Wie heeft wat gemaakt?" },
         { IDMES_WHO_MADE_WHAT_PL, "" },             
         { IDMES_WHO_MADE_WHAT_SV, "Vem gjorde vad?" },
         { IDMES_WHO_MADE_WHAT_TR, "Kim ne yapt?" },

         { IDMES_VICE_DIST_NO_WARRANTY,    N_("VICE is distributed WITHOUT ANY WARRANTY!") },
         { IDMES_VICE_DIST_NO_WARRANTY_DA, "VICE distribueres UDEN NOGEN SOM HELST GARANTI!" },
         { IDMES_VICE_DIST_NO_WARRANTY_DE, "VICE ist ohne Garantie" },
         { IDMES_VICE_DIST_NO_WARRANTY_FR, "VICE est distribu SANS AUCUN GARANTIE!" },
         { IDMES_VICE_DIST_NO_WARRANTY_HU, "A VICE-t garancia nlkl terjesztjk!" },
         { IDMES_VICE_DIST_NO_WARRANTY_IT, "VICE  distribuito SENZA NESSUNA GARANZIA!" },
         { IDMES_VICE_DIST_NO_WARRANTY_NL, "VICE heeft ABSOLUUT GEEN GARANTIE!" },
         { IDMES_VICE_DIST_NO_WARRANTY_PL, "" },             
         { IDMES_VICE_DIST_NO_WARRANTY_SV, "VICE distribueras UTAN NGON SOM HELST GARANTI!" },
         { IDMES_VICE_DIST_NO_WARRANTY_TR, "VICE HBR GARANT VERLMEDEN datlmtr!" },

         { IDMES_WHICH_COMMANDS_AVAILABLE,    N_("Which command line options are available?") },
         { IDMES_WHICH_COMMANDS_AVAILABLE_DA, "Hvilke kommandolinjeparametre er tilgngelige?" },
         { IDMES_WHICH_COMMANDS_AVAILABLE_DE, "Welche Kommandozeilen Parameter sind verfgbar?" },
         { IDMES_WHICH_COMMANDS_AVAILABLE_FR, "Quelles sont les lignes de commandes disponibles?" },
         { IDMES_WHICH_COMMANDS_AVAILABLE_HU, "Milyen parancssori opcik lehetsgesek?" },
         { IDMES_WHICH_COMMANDS_AVAILABLE_IT, "Quali parametri da riga di comando sono disponibili?" },
         { IDMES_WHICH_COMMANDS_AVAILABLE_NL, "Welke commando opties zijn beschikbaar?" },
         { IDMES_WHICH_COMMANDS_AVAILABLE_PL, "" },             
         { IDMES_WHICH_COMMANDS_AVAILABLE_SV, "Vilka kommandoradsflaggor r tillgngliga?" },
         { IDMES_WHICH_COMMANDS_AVAILABLE_TR, "Hangi komut satr seenekleri mevcut?" },

         { IDMES_CANNOT_SAVE_SETTINGS,    N_("Cannot save settings.") },
         { IDMES_CANNOT_SAVE_SETTINGS_DA, "Kunne ikke gemme indstillinger." },
         { IDMES_CANNOT_SAVE_SETTINGS_DE, "Fehler beim Speichern der Einstellungen." },
         { IDMES_CANNOT_SAVE_SETTINGS_FR, "Impossible d'enregistrer les paramtres." },
         { IDMES_CANNOT_SAVE_SETTINGS_HU, "A belltsok mentse nem sikerlt." },
         { IDMES_CANNOT_SAVE_SETTINGS_IT, "Impossibile salvare le impostazioni." },
         { IDMES_CANNOT_SAVE_SETTINGS_NL, "Kan de instellingen niet opslaan." },
         { IDMES_CANNOT_SAVE_SETTINGS_PL, "" },             
         { IDMES_CANNOT_SAVE_SETTINGS_SV, "Kan inte spara instllningar." },
         { IDMES_CANNOT_SAVE_SETTINGS_TR, "Ayarlar kaydedilemedi." },

         { IDMES_CANNOT_LOAD_SETTINGS,    N_("Cannot load settings.") },
         { IDMES_CANNOT_LOAD_SETTINGS_DA, "Kunne ikke indlse indstillinger." },
         { IDMES_CANNOT_LOAD_SETTINGS_DE, "Fehler beim Laden der Einstellungen." },
         { IDMES_CANNOT_LOAD_SETTINGS_FR, "Impossible de charger les paramtres." },
         { IDMES_CANNOT_LOAD_SETTINGS_HU, "A belltsok betltse nem sikerlt." },
         { IDMES_CANNOT_LOAD_SETTINGS_IT, "Non  possibile caricare le impostazioni." },
         { IDMES_CANNOT_LOAD_SETTINGS_NL, "Kan de instellingen niet laden." },
         { IDMES_CANNOT_LOAD_SETTINGS_PL, "" },             
         { IDMES_CANNOT_LOAD_SETTINGS_SV, "Kan inte lsa instllningar." },
         { IDMES_CANNOT_LOAD_SETTINGS_TR, "Ayarlar yklenemedi." },

         { IDMES_VICE_ERROR,    N_("VICE Error") },
         { IDMES_VICE_ERROR_DA, "VICE-fejl" },
         { IDMES_VICE_ERROR_DE, "VICE Fehler" },
         { IDMES_VICE_ERROR_FR, "Erreur VICE" },
         { IDMES_VICE_ERROR_HU, "VICE hiba" },
         { IDMES_VICE_ERROR_IT, "Errore di VICE" },
         { IDMES_VICE_ERROR_NL, "Vice-fout" },
         { IDMES_VICE_ERROR_PL, "" },             
         { IDMES_VICE_ERROR_SV, "VICE-fel" },
         { IDMES_VICE_ERROR_TR, "VICE Hatas" },

         { IDMES_DEVICE_NOT_GAMEPAD,    N_("The device on this port is not a gamepad") },
         { IDMES_DEVICE_NOT_GAMEPAD_DA, "Enheden p denne port er ikke en joypad" },
         { IDMES_DEVICE_NOT_GAMEPAD_DE, "Das Gert in diesem Port ist kein Gamepad" },
         { IDMES_DEVICE_NOT_GAMEPAD_FR, "Le priphrique sur ce port nest pas une manette" },
         { IDMES_DEVICE_NOT_GAMEPAD_HU, "Az eszkz ezen a porton nem gamepad" },
         { IDMES_DEVICE_NOT_GAMEPAD_IT, "Il dispositivo su questa porta non  un gamepad" },
         { IDMES_DEVICE_NOT_GAMEPAD_NL, "Het apparaat op deze poort is geen gamepad" },
         { IDMES_DEVICE_NOT_GAMEPAD_PL, "" },             
         { IDMES_DEVICE_NOT_GAMEPAD_SV, "Enheten p denna port r ingen gamepad" },
         { IDMES_DEVICE_NOT_GAMEPAD_TR, "Bu port zerindeki aygt gamepad deil" },

         { IDMES_NOT_MAPPED_TO_AMIGA_PORT,    N_("The port is not mapped to an Amiga port") },
         { IDMES_NOT_MAPPED_TO_AMIGA_PORT_DA, "Denne port er ikke koblet til en Amigaport" },
         { IDMES_NOT_MAPPED_TO_AMIGA_PORT_DE, "Dieses Port ist keinem Amiga Port zugeordnet" },
         { IDMES_NOT_MAPPED_TO_AMIGA_PORT_FR, "Le port nest pas mapp sur un port Amiga" },
         { IDMES_NOT_MAPPED_TO_AMIGA_PORT_HU, "A port nincs lekpezve egy Amiga portra" },
         { IDMES_NOT_MAPPED_TO_AMIGA_PORT_IT, "Questa porta non  mappata ad una porta dell'Amiga" },
         { IDMES_NOT_MAPPED_TO_AMIGA_PORT_NL, "De poort is niet verbonden met een Amigapoort" },
         { IDMES_NOT_MAPPED_TO_AMIGA_PORT_PL, "" },             
         { IDMES_NOT_MAPPED_TO_AMIGA_PORT_SV, "Porten r inte bunden till en Amiga port" },
         { IDMES_NOT_MAPPED_TO_AMIGA_PORT_TR, "Port bir Amiga portuyla eletirilemedi" },

         { IDMES_CANNOT_AUTOSTART_FILE,    N_("Cannot autostart specified file.") },
         { IDMES_CANNOT_AUTOSTART_FILE_DA, "Kan ikke autostarte valgt fil" },
         { IDMES_CANNOT_AUTOSTART_FILE_DE, "Autostart von angeforderter Datei fehlgeschlagen." },
         { IDMES_CANNOT_AUTOSTART_FILE_FR, "Impossible de dmarrer automatiquement le fichier spcifi" },
         { IDMES_CANNOT_AUTOSTART_FILE_HU, "Nem lehet automatikusan elindtani a megadott fjlt." },
         { IDMES_CANNOT_AUTOSTART_FILE_IT, "Non  possibile avviare automaticamente il file specificato." },
         { IDMES_CANNOT_AUTOSTART_FILE_NL, "Kan opgegeven bestand niet autostarten." },
         { IDMES_CANNOT_AUTOSTART_FILE_PL, "" },             
         { IDMES_CANNOT_AUTOSTART_FILE_SV, "Kan inte autostarta angiven fil." },
         { IDMES_CANNOT_AUTOSTART_FILE_TR, "Belirtilen dosya otomatik balatlamad." },

         { IDMES_CANNOT_ATTACH_FILE,    N_("Cannot attach specified file") },
         { IDMES_CANNOT_ATTACH_FILE_DA, "Kan ikke tilslutte den valgte fil" },
         { IDMES_CANNOT_ATTACH_FILE_DE, "Kann Image Datei nicht einlegen" },
         { IDMES_CANNOT_ATTACH_FILE_FR, "Impossible d'attacher le fichier spcifi" },
         { IDMES_CANNOT_ATTACH_FILE_HU, "Nem lehet csatolni a megadott fjlt" },
         { IDMES_CANNOT_ATTACH_FILE_IT, "Non  possibile selezionare il file specificato" },
         { IDMES_CANNOT_ATTACH_FILE_NL, "Kan het opgegeven bestand niet koppelen" },
         { IDMES_CANNOT_ATTACH_FILE_PL, "" },             
         { IDMES_CANNOT_ATTACH_FILE_SV, "Kan inte ansluta filen" },
         { IDMES_CANNOT_ATTACH_FILE_TR, "Belirtilen dosya yerletirilemedi" },

         { IDMES_INVALID_CART,    N_("Invalid cartridge") },
         { IDMES_INVALID_CART_DA, "Ugyldigt cartridge" },
         { IDMES_INVALID_CART_DE, "Ungltiges Erweiterungsmodul" },
         { IDMES_INVALID_CART_FR, "Cartouche invalide" },
         { IDMES_INVALID_CART_HU, "rvnytelen cartridge" },
         { IDMES_INVALID_CART_IT, "Cartuccia non valida" },
         { IDMES_INVALID_CART_NL, "Ongeldige cartridge" },
         { IDMES_INVALID_CART_PL, "" },             
         { IDMES_INVALID_CART_SV, "Ogiltig insticksmodul" },
         { IDMES_INVALID_CART_TR, "Geersiz kartu" },

         { IDMES_BAD_CART_CONFIG_IN_UI,    N_("Bad cartridge config in UI!") },
         { IDMES_BAD_CART_CONFIG_IN_UI_DA, "Ugyldig cartridgekonfiguration i brugergrnseflade!" },
         { IDMES_BAD_CART_CONFIG_IN_UI_DE, "Fehlerhafte Modul Konfiguration im UI!" },
         { IDMES_BAD_CART_CONFIG_IN_UI_FR, "Mauvaise configuration de la cartouche dans l'interface utilisateur!" },
         { IDMES_BAD_CART_CONFIG_IN_UI_HU, "Rossz cartridge konfigurci!" },
         { IDMES_BAD_CART_CONFIG_IN_UI_IT, "Configurazione della cartuccia errata nell'IU!" },
         { IDMES_BAD_CART_CONFIG_IN_UI_NL, "Slechte cartridge configuratie in UI!" },
         { IDMES_BAD_CART_CONFIG_IN_UI_PL, "" },             
         { IDMES_BAD_CART_CONFIG_IN_UI_SV, "Felaktiga insticksmodulsinstllningar i UI!" },
         { IDMES_BAD_CART_CONFIG_IN_UI_TR, "UI'de kt kartu konfigrasyonu!" },

         { IDMES_INVALID_CART_IMAGE,    N_("Invalid cartridge image") },
         { IDMES_INVALID_CART_IMAGE_DA, "Ugyldigt cartridge-image" },
         { IDMES_INVALID_CART_IMAGE_DE, "Ungltiges Erweiterungsmodul Image" },
         { IDMES_INVALID_CART_IMAGE_FR, "Image de cartouche invalide" },
         { IDMES_INVALID_CART_IMAGE_HU, "rvnytelen cartridge kpms" },
         { IDMES_INVALID_CART_IMAGE_IT, "Immagine della cartuccia non valida" },
         { IDMES_INVALID_CART_IMAGE_NL, "Ongeldig cartridgebestand" },
         { IDMES_INVALID_CART_IMAGE_PL, "" },             
         { IDMES_INVALID_CART_IMAGE_SV, "Ogiltig insticksmodulfil" },
         { IDMES_INVALID_CART_IMAGE_TR, "Geersiz kartu imaj" },

         { IDMES_CANNOT_CREATE_IMAGE,    N_("Cannot create image") },
         { IDMES_CANNOT_CREATE_IMAGE_DA, "Kunne ikke oprette image" },
         { IDMES_CANNOT_CREATE_IMAGE_DE, "Kann Image Datei nicht erzeugen" },
         { IDMES_CANNOT_CREATE_IMAGE_FR, "Impossible de crer l'image" },
         { IDMES_CANNOT_CREATE_IMAGE_HU, "Nem sikerlt a kpmst ltrehozni" },
         { IDMES_CANNOT_CREATE_IMAGE_IT, "Non  possibile creare l'immagine" },
         { IDMES_CANNOT_CREATE_IMAGE_NL, "Kan bestand niet maken" },
         { IDMES_CANNOT_CREATE_IMAGE_PL, "" },             
         { IDMES_CANNOT_CREATE_IMAGE_SV, "Kan inte skapa avbildningsfil" },
         { IDMES_CANNOT_CREATE_IMAGE_TR, "Imaj yaratlamad" },

         { IDMES_ERROR_STARTING_SERVER,    N_("An error occured starting the server.") },
         { IDMES_ERROR_STARTING_SERVER_DA, "Fejl under start af serveren." },
         { IDMES_ERROR_STARTING_SERVER_DE, "Fehler beim Starten des Netplay Servers." },
         { IDMES_ERROR_STARTING_SERVER_FR, "Il y a eu une erreur au dmarrage du serveur." },
         { IDMES_ERROR_STARTING_SERVER_HU, "Hiba trtnt a jtk kiszolgl indtsakor." },
         { IDMES_ERROR_STARTING_SERVER_IT, "Si  verificato un errore all'avvio del server." },
         { IDMES_ERROR_STARTING_SERVER_NL, "Er is een fout opgetreden bij het opstarten van de server" },
         { IDMES_ERROR_STARTING_SERVER_PL, "" },             
         { IDMES_ERROR_STARTING_SERVER_SV, "Fel vid anslutning till server." },
         { IDMES_ERROR_STARTING_SERVER_TR, "Sunucu balatlrken bir hata olutu." },

         { IDMES_ERROR_CONNECTING_CLIENT,    N_("An error occured connecting the client.") },
         { IDMES_ERROR_CONNECTING_CLIENT_DA, "Fejl under tilslutning af klienten." },
         { IDMES_ERROR_CONNECTING_CLIENT_DE, "Fehler beim Verbindungsaufbau zum Client" },
         { IDMES_ERROR_CONNECTING_CLIENT_FR, "" },             
         { IDMES_ERROR_CONNECTING_CLIENT_HU, "Hiba trtnt a kapcsoldskor." },
         { IDMES_ERROR_CONNECTING_CLIENT_IT, "Si  verificato un errore durante il collegamento col client." },
         { IDMES_ERROR_CONNECTING_CLIENT_NL, "Een fout is opgetreden bij het verbinden." },
         { IDMES_ERROR_CONNECTING_CLIENT_PL, "" },             
         { IDMES_ERROR_CONNECTING_CLIENT_SV, "Fel vid anslutning till klient." },
         { IDMES_ERROR_CONNECTING_CLIENT_TR, "stemciye balanrken bir hata olutu." },

         { IDMES_INVALID_PORT_NUMBER,    N_("Invalid Port number") },
         { IDMES_INVALID_PORT_NUMBER_DA, "Ugyldigt portnummer" },
         { IDMES_INVALID_PORT_NUMBER_DE, "Ungltige Port Nummer" },
         { IDMES_INVALID_PORT_NUMBER_FR, "Numro de port invalide" },
         { IDMES_INVALID_PORT_NUMBER_HU, "rvnytelen port szm" },
         { IDMES_INVALID_PORT_NUMBER_IT, "Numero di porta non valido" },
         { IDMES_INVALID_PORT_NUMBER_NL, "Ongeldig poort nummer" },
         { IDMES_INVALID_PORT_NUMBER_PL, "" },             
         { IDMES_INVALID_PORT_NUMBER_SV, "Ogiltigt portnummer" },
         { IDMES_INVALID_PORT_NUMBER_TR, "Geersiz port numaras" },

         { IDMES_THIS_MACHINE_NO_SID,    N_("This machine may not have a SID") },
         { IDMES_THIS_MACHINE_NO_SID_DA, "Denne maskine kan ikke have en SID" },
         { IDMES_THIS_MACHINE_NO_SID_DE, "Diese Maschine hat mglicherweise keinen SID" },
         { IDMES_THIS_MACHINE_NO_SID_FR, "Cette machine n'a peut-tre pas de SID" },
         { IDMES_THIS_MACHINE_NO_SID_HU, "Ennek a gpnek nem lehet SIDje" },
         { IDMES_THIS_MACHINE_NO_SID_IT, "Questa macchina potrebbe non avere un SID" },
         { IDMES_THIS_MACHINE_NO_SID_NL, "Deze machine heeft mogelijk geen SID" },
         { IDMES_THIS_MACHINE_NO_SID_PL, "" },             
         { IDMES_THIS_MACHINE_NO_SID_SV, "Denna maskin kan inte ha en SID" },
         { IDMES_THIS_MACHINE_NO_SID_TR, "Bu makinede SID olmayabilir" },

         { IDMES_SCREENSHOT_SAVE_S_FAILED,    N_("Screenshot save of %s failed") },
         { IDMES_SCREENSHOT_SAVE_S_FAILED_DA, "Kunne ikke gemme screenshot %s" },
         { IDMES_SCREENSHOT_SAVE_S_FAILED_DE, "Screenshot speicherung von %s ist fehlgeschlagen" },
         { IDMES_SCREENSHOT_SAVE_S_FAILED_FR, "" },             
         { IDMES_SCREENSHOT_SAVE_S_FAILED_HU, "Fnykp fjl mentse %s fjlba nem sikerlt" },
         { IDMES_SCREENSHOT_SAVE_S_FAILED_IT, "Il salvataggio della schermata %s  fallito" },
         { IDMES_SCREENSHOT_SAVE_S_FAILED_NL, "Opslaan schermafdrukbestand %s is mislukt" },
         { IDMES_SCREENSHOT_SAVE_S_FAILED_PL, "" },             
         { IDMES_SCREENSHOT_SAVE_S_FAILED_SV, "Fel vid skrivning av skrmdump \"%s\"" },
         { IDMES_SCREENSHOT_SAVE_S_FAILED_TR, "%s ekran grnts kaydedilemedi" },

         { IDMES_SCREENSHOT_S_SAVED,    N_("Screenshot %s saved.") },
         { IDMES_SCREENSHOT_S_SAVED_DA, "Screenshot %s gemt." },
         { IDMES_SCREENSHOT_S_SAVED_DE, "Screenshots %s gespeicher." },
         { IDMES_SCREENSHOT_S_SAVED_FR, "" },             
         { IDMES_SCREENSHOT_S_SAVED_HU, "Fnykp %s fjlba elmentve." },
         { IDMES_SCREENSHOT_S_SAVED_IT, "Schermata %s salvata." },
         { IDMES_SCREENSHOT_S_SAVED_NL, "Schermafdruk %s opgeslagen." },
         { IDMES_SCREENSHOT_S_SAVED_PL, "" },             
         { IDMES_SCREENSHOT_S_SAVED_SV, "Skrmdump \"%s\" sparad." },
         { IDMES_SCREENSHOT_S_SAVED_TR, "%s ekran grnts kaydedildi." },

                                                                     

         { IDS_PRESS_KEY_BUTTON,    N_("Press desired key/button, move stick or press ESC for no key.") },
         { IDS_PRESS_KEY_BUTTON_DA, "Tryk nsket tast, bevg joystick eller tryk ESC for ingen binding." },
         { IDS_PRESS_KEY_BUTTON_DE, "Gewnschte Taste/Knopf drcken, Knppel bewegen oder ESC fr keine Taste drcken." },
         { IDS_PRESS_KEY_BUTTON_FR, "Appuyez sur la touche/bouton desire(e), dplacez le stick ou appuyez sur ESC pour "
                                    "effacer cette touche." },
         { IDS_PRESS_KEY_BUTTON_HU, "Nyomja meg a vlasztott gombot, mozdtsa a botkormnyt, vagy nyomjon ESC-et "
                                    "reshez" },
         { IDS_PRESS_KEY_BUTTON_IT, "Premi il tasto/bottone desiderato, muovi la leva o premi ESC per non selezionare "
                                    "alcun tasto." },
         { IDS_PRESS_KEY_BUTTON_NL, "Druk de toets/knop, beweeg de joystick of druk op ESC voor geen toets." },
         { IDS_PRESS_KEY_BUTTON_PL, "" },             
         { IDS_PRESS_KEY_BUTTON_SV, "Tryck nskad tangent/knapp, rr joysticken eller tryck ESC fr att inte vlja ngon "
                                    "knapp." },
         { IDS_PRESS_KEY_BUTTON_TR, "stenilen tu/dmeye basn, ubuu hareket ettirin veya tu sememek iin ESC'e "
                                    "basn." },

         { IDS_SAVE,    N_("Save") },
         { IDS_SAVE_DA, "Gem" },
         { IDS_SAVE_DE, "Speichern" },
         { IDS_SAVE_FR, "Enregistrer" },
         { IDS_SAVE_HU, "Ments" },
         { IDS_SAVE_IT, "Salva" },
         { IDS_SAVE_NL, "Opslaan" },
         { IDS_SAVE_PL, "" },             
         { IDS_SAVE_SV, "Spara" },
         { IDS_SAVE_TR, "Kaydet" },

         { IDS_BROWSE,    N_("Browse") },
         { IDS_BROWSE_DA, "Gennemse" },
         { IDS_BROWSE_DE, "Stbern" },
         { IDS_BROWSE_FR, "Parcourir" },
         { IDS_BROWSE_HU, "Tallz" },
         { IDS_BROWSE_IT, "Sfoglia" },
         { IDS_BROWSE_NL, "Bladeren" },
         { IDS_BROWSE_PL, "" },             
         { IDS_BROWSE_SV, "Blddra" },
         { IDS_BROWSE_TR, "Gz at" },

         { IDS_CURRENT_MODE,    N_("Current mode") },
         { IDS_CURRENT_MODE_DA, "Nuvrende tilstand" },
         { IDS_CURRENT_MODE_DE, "Aktueller Modus" },
         { IDS_CURRENT_MODE_FR, "" },             
         { IDS_CURRENT_MODE_HU, "Jelenlegi md" },
         { IDS_CURRENT_MODE_IT, "Modalit attuale" },
         { IDS_CURRENT_MODE_NL, "Huidige modus" },
         { IDS_CURRENT_MODE_PL, "" },             
         { IDS_CURRENT_MODE_SV, "Nuvarande lge" },
         { IDS_CURRENT_MODE_TR, "Geerli mod" },

         { IDS_TCP_PORT,    N_("TCP-Port") },
         { IDS_TCP_PORT_DA, "TCP-port" },
         { IDS_TCP_PORT_DE, "TCP-Port" },
         { IDS_TCP_PORT_FR, "Port TCP" },
         { IDS_TCP_PORT_HU, "TCP-Port" },
         { IDS_TCP_PORT_IT, "Porta TCP" },
         { IDS_TCP_PORT_NL, "TCP-Poort" },
         { IDS_TCP_PORT_PL, "" },             
         { IDS_TCP_PORT_SV, "TCP-port" },
         { IDS_TCP_PORT_TR, "TCP-Port" },

         { IDS_START_SERVER,    N_("Start Server") },
         { IDS_START_SERVER_DA, "Start server" },
         { IDS_START_SERVER_DE, "Server starten" },
         { IDS_START_SERVER_FR, "Dmarrer le serveur" },
         { IDS_START_SERVER_HU, "Kiszolgl elindtsa" },
         { IDS_START_SERVER_IT, "Avvia server" },
         { IDS_START_SERVER_NL, "Start server" },
         { IDS_START_SERVER_PL, "" },             
         { IDS_START_SERVER_SV, "Starta server" },
         { IDS_START_SERVER_TR, "Sunucuyu balat" },

         { IDS_SERVER_BIND,    N_("Server Bind") },
         { IDS_SERVER_BIND_DA, "" },             
         { IDS_SERVER_BIND_DE, "Server Bind" },
         { IDS_SERVER_BIND_FR, "" },             
         { IDS_SERVER_BIND_HU, "" },             
         { IDS_SERVER_BIND_IT, "Server Bind" },
         { IDS_SERVER_BIND_NL, "Server binding" },
         { IDS_SERVER_BIND_PL, "" },             
         { IDS_SERVER_BIND_SV, "Serverbindning" },
         { IDS_SERVER_BIND_TR, "Sunucu Balants" },

         { IDS_CONNECT_TO,    N_("Connect to") },
         { IDS_CONNECT_TO_DA, "Tilslut til" },
         { IDS_CONNECT_TO_DE, "Verbinden mit" },
         { IDS_CONNECT_TO_FR, "Se connecter " },
         { IDS_CONNECT_TO_HU, "Kapcsolds ehhez:" },
         { IDS_CONNECT_TO_IT, "Connetti a" },
         { IDS_CONNECT_TO_NL, "Maak verbinding naar" },
         { IDS_CONNECT_TO_PL, "" },             
         { IDS_CONNECT_TO_SV, "Anslut till" },
         { IDS_CONNECT_TO_TR, "Balanlan" },

         { IDS_DISCONNECT,    N_("Disconnect") },
         { IDS_DISCONNECT_DA, "Afbryd forbindelse" },
         { IDS_DISCONNECT_DE, "Verbindung Trennen" },
         { IDS_DISCONNECT_FR, "Se dconnecter du serveur" },
         { IDS_DISCONNECT_HU, "Sztkapcsolds" },
         { IDS_DISCONNECT_IT, "Disconnetti" },
         { IDS_DISCONNECT_NL, "Verbreek verbinding" },
         { IDS_DISCONNECT_PL, "" },             
         { IDS_DISCONNECT_SV, "Koppla frn" },
         { IDS_DISCONNECT_TR, "Balanty kes" },

         { IDS_IDLE,    N_("Idle") },
         { IDS_IDLE_DA, "Venter" },
         { IDS_IDLE_DE, "Idle" },
         { IDS_IDLE_FR, "Inactif" },
         { IDS_IDLE_HU, "Ttlen" },
         { IDS_IDLE_IT, "Inattivo" },
         { IDS_IDLE_NL, "Idle" },
         { IDS_IDLE_PL, "" },             
         { IDS_IDLE_SV, "Vntar" },
         { IDS_IDLE_TR, "Boa vakit geirme" },

         { IDS_SERVER_LISTENING,    N_("Server listening") },
         { IDS_SERVER_LISTENING_DA, "Server lytter" },
         { IDS_SERVER_LISTENING_DE, "Server wartet auf Verbindung" },
         { IDS_SERVER_LISTENING_FR, "" },             
         { IDS_SERVER_LISTENING_HU, "Vrakozs kliensre" },
         { IDS_SERVER_LISTENING_IT, "Server in ascolto" },
         { IDS_SERVER_LISTENING_NL, "Server wacht op verbinding" },
         { IDS_SERVER_LISTENING_PL, "" },             
         { IDS_SERVER_LISTENING_SV, "Servern lyssnar" },
         { IDS_SERVER_LISTENING_TR, "Sunucu dinleniyor" },

         { IDS_CONNECTED_SERVER,    N_("Connected server") },
         { IDS_CONNECTED_SERVER_DA, "Tilsluttet server" },
         { IDS_CONNECTED_SERVER_DE, "Verbunden, Server" },
         { IDS_CONNECTED_SERVER_FR, "Connect au serveur" },
         { IDS_CONNECTED_SERVER_HU, "Kiszolgl a kapcsolatban" },
         { IDS_CONNECTED_SERVER_IT, "Server connesso" },
         { IDS_CONNECTED_SERVER_NL, "Verbonden Server" },
         { IDS_CONNECTED_SERVER_PL, "" },             
         { IDS_CONNECTED_SERVER_SV, "Ansluten server" },
         { IDS_CONNECTED_SERVER_TR, "Sunucu Baland" },

         { IDS_CONNECTED_CLIENT,    N_("Connected client") },
         { IDS_CONNECTED_CLIENT_DA, "Tilsluttet klient" },
         { IDS_CONNECTED_CLIENT_DE, "Verbunden, Client" },
         { IDS_CONNECTED_CLIENT_FR, "Client connect" },
         { IDS_CONNECTED_CLIENT_HU, "Kapcsold kliens" },
         { IDS_CONNECTED_CLIENT_IT, "Client connesso" },
         { IDS_CONNECTED_CLIENT_NL, "Verbonden Client" },
         { IDS_CONNECTED_CLIENT_PL, "" },             
         { IDS_CONNECTED_CLIENT_SV, "Ansluten klient" },
         { IDS_CONNECTED_CLIENT_TR, "stemci Baland" },

         { IDS_NETPLAY_SETTINGS,    N_("Netplay Settings") },
         { IDS_NETPLAY_SETTINGS_DA, "Ntvrksspilindstillinger" },
         { IDS_NETPLAY_SETTINGS_DE, "Netplay Einstellungen" },
         { IDS_NETPLAY_SETTINGS_FR, "Paramtres de jeu en rseau" },
         { IDS_NETPLAY_SETTINGS_HU, "Hlzati jtk belltsai" },
         { IDS_NETPLAY_SETTINGS_IT, "Impostazioni Netplay" },
         { IDS_NETPLAY_SETTINGS_NL, "Netplayinstellingen" },
         { IDS_NETPLAY_SETTINGS_PL, "" },             
         { IDS_NETPLAY_SETTINGS_SV, "Instllningar fr ntverksspel" },
         { IDS_NETPLAY_SETTINGS_TR, "Netplay Ayarlar" },

         { IDS_SAVE_SCREENSHOT,    N_("Save Screenshot") },
         { IDS_SAVE_SCREENSHOT_DA, "Gem screenshot" },
         { IDS_SAVE_SCREENSHOT_DE, "Screenshot Speichern" },
         { IDS_SAVE_SCREENSHOT_FR, "Enregistrer une capture d'cran" },
         { IDS_SAVE_SCREENSHOT_HU, "Fnykp mentse" },
         { IDS_SAVE_SCREENSHOT_IT, "Salva schermata" },
         { IDS_SAVE_SCREENSHOT_NL, "Schermafdruk opslaan" },
         { IDS_SAVE_SCREENSHOT_PL, "" },             
         { IDS_SAVE_SCREENSHOT_SV, "Spara skrmdump" },
         { IDS_SAVE_SCREENSHOT_TR, "Ekran Grnts Kaydet" },

         { IDS_CANCEL,    N_("Cancel") },
         { IDS_CANCEL_DA, "Annullr" },
         { IDS_CANCEL_DE, "Abbruch" },
         { IDS_CANCEL_FR, "Annuler" },
         { IDS_CANCEL_HU, "Mgsem" },
         { IDS_CANCEL_IT, "Annulla" },
         { IDS_CANCEL_NL, "Annuleren" },
         { IDS_CANCEL_PL, "" },             
         { IDS_CANCEL_SV, "Avbryt" },
         { IDS_CANCEL_TR, "ptal" },

         { IDS_CHOOSE_SCREENSHOT_FORMAT,    N_("Choose screenshot format") },
         { IDS_CHOOSE_SCREENSHOT_FORMAT_DA, "Vlg screenshot format" },
         { IDS_CHOOSE_SCREENSHOT_FORMAT_DE, "Whle Screenshot Format" },
         { IDS_CHOOSE_SCREENSHOT_FORMAT_FR, "Chosir le format de capture d'cran" },
         { IDS_CHOOSE_SCREENSHOT_FORMAT_HU, "Vlasszon fnykp formtumot" },
         { IDS_CHOOSE_SCREENSHOT_FORMAT_IT, "Seleziona il formato per il salvataggio della schermata" },
         { IDS_CHOOSE_SCREENSHOT_FORMAT_NL, "Kies schermafdrukformaat" },
         { IDS_CHOOSE_SCREENSHOT_FORMAT_PL, "" },             
         { IDS_CHOOSE_SCREENSHOT_FORMAT_SV, "Vlj nskat format fr skrmdumpen" },
         { IDS_CHOOSE_SCREENSHOT_FORMAT_TR, "Ekran grnts biimi sein" },

         { IDS_SAVE_S_SCREENSHOT,    N_("Save %s screenshot") },
         { IDS_SAVE_S_SCREENSHOT_DA, "Gem %s-screenshot" },
         { IDS_SAVE_S_SCREENSHOT_DE, "Screenshot %s speichern" },
         { IDS_SAVE_S_SCREENSHOT_FR, "Enregistrer une capture d'cran %s" },
         { IDS_SAVE_S_SCREENSHOT_HU, "%s fnykp mentse" },
         { IDS_SAVE_S_SCREENSHOT_IT, "Salva schermata %s" },
         { IDS_SAVE_S_SCREENSHOT_NL, "Sla schermafdruk %s op" },
         { IDS_SAVE_S_SCREENSHOT_PL, "" },             
         { IDS_SAVE_S_SCREENSHOT_SV, "Spara skrmdumpen i %s format" },
         { IDS_SAVE_S_SCREENSHOT_TR, "%s ekran grntsn kaydet" },

         { IDS_DETACHED_DEVICE_D,    N_("Detached device %d") },
         { IDS_DETACHED_DEVICE_D_DA, "Frakoblet enhed %d" },
         { IDS_DETACHED_DEVICE_D_DE, "Gert %d entfernt" },
         { IDS_DETACHED_DEVICE_D_FR, "Priphrique dtach %d" },
         { IDS_DETACHED_DEVICE_D_HU, "%d eszkz levlasztva" },
         { IDS_DETACHED_DEVICE_D_IT, "Rimosso dispositivo %d" },
         { IDS_DETACHED_DEVICE_D_NL, "Apparaat %d ontkoppelt" },
         { IDS_DETACHED_DEVICE_D_PL, "" },             
         { IDS_DETACHED_DEVICE_D_SV, "Kopplade fran enhet %d" },
         { IDS_DETACHED_DEVICE_D_TR, "kartlm aygt %d" },

         { IDS_ATTACHED_S_TO_DEVICE_D,    N_("Attached %s to device#%d") },
         { IDS_ATTACHED_S_TO_DEVICE_D_DA, "Tilsluttet %s til enhed #%d" },
         { IDS_ATTACHED_S_TO_DEVICE_D_DE, "%s mit Gert #%d verbunden" },
         { IDS_ATTACHED_S_TO_DEVICE_D_FR, "%s attach au priphrique #%d" },
         { IDS_ATTACHED_S_TO_DEVICE_D_HU, "%s csatolva #%d eszkzhz" },
         { IDS_ATTACHED_S_TO_DEVICE_D_IT, "Selezionato %s per la periferica #%d" },
         { IDS_ATTACHED_S_TO_DEVICE_D_NL, "%s aan apparaat#%d gekoppelt" },
         { IDS_ATTACHED_S_TO_DEVICE_D_PL, "" },             
         { IDS_ATTACHED_S_TO_DEVICE_D_SV, "Anslt %s till enhet %d" },
         { IDS_ATTACHED_S_TO_DEVICE_D_TR, "%s aygt#%d'e balanm" },

         { IDS_VICE_QUESTION,    N_("VICE Question") },
         { IDS_VICE_QUESTION_DA, "VICE-sprgsml" },
         { IDS_VICE_QUESTION_DE, "VICE Frage" },
         { IDS_VICE_QUESTION_FR, "Question VICE" },
         { IDS_VICE_QUESTION_HU, "VICE krds" },
         { IDS_VICE_QUESTION_IT, "Domanda di VICE" },
         { IDS_VICE_QUESTION_NL, "VICE vraag" },
         { IDS_VICE_QUESTION_PL, "" },             
         { IDS_VICE_QUESTION_SV, "VICE-fraga" },
         { IDS_VICE_QUESTION_TR, "VICE Sorusu" },

         { IDS_EXTEND_TO_40_TRACK,    N_("Extend image to 40-track format?") },
         { IDS_EXTEND_TO_40_TRACK_DA, "Udvid disk-image til 40 spor?" },
         { IDS_EXTEND_TO_40_TRACK_DE, "Image Dateu auf 40-Spur Format erweitern?" },
         { IDS_EXTEND_TO_40_TRACK_FR, "tendre l'image au format 40 pistes?" },
         { IDS_EXTEND_TO_40_TRACK_HU, "Kiterjesszem a kpmst 40 svos formtumra?" },
         { IDS_EXTEND_TO_40_TRACK_IT, "Astendere l'immagine al formato 40 tracce?" },
         { IDS_EXTEND_TO_40_TRACK_NL, "Bestand uitbreiden naar 40-sporen formaat?" },
         { IDS_EXTEND_TO_40_TRACK_PL, "" },             
         { IDS_EXTEND_TO_40_TRACK_SV, "Utka avbildning till 40-sparsformat?" },
         { IDS_EXTEND_TO_40_TRACK_TR, "Imaj 40-track biimine geniletilsin mi?" },

         { IDS_YES_NO,    N_("Yes|No") },
         { IDS_YES_NO_DA, "Ja|Nej" },
         { IDS_YES_NO_DE, "Ja|Nein" },
         { IDS_YES_NO_FR, "Oui|Non" },
         { IDS_YES_NO_HU, "Igen|Nem" },
         { IDS_YES_NO_IT, "S|No" },
         { IDS_YES_NO_NL, "Ja|Nee" },
         { IDS_YES_NO_PL, "" },             
         { IDS_YES_NO_SV, "Ja|Nej" },
         { IDS_YES_NO_TR, "Evet|Hayr" },

         { IDS_DETACHED_TAPE,    N_("Detached tape") },
         { IDS_DETACHED_TAPE_DA, "Frakoblet bnd" },
         { IDS_DETACHED_TAPE_DE, "Band Image entfernt" },
         { IDS_DETACHED_TAPE_FR, "Datassette dtach" },
         { IDS_DETACHED_TAPE_HU, "Szalag levlasztva" },
         { IDS_DETACHED_TAPE_IT, "Cassetta rimossa" },
         { IDS_DETACHED_TAPE_NL, "Tape ontkoppelt" },
         { IDS_DETACHED_TAPE_PL, "" },             
         { IDS_DETACHED_TAPE_SV, "Kopplade fran band" },
         { IDS_DETACHED_TAPE_TR, "Teyp kartld" },

         { IDS_ATTACHED_TAPE_S,    N_("Attached tape %s") },
         { IDS_ATTACHED_TAPE_S_DA, "Tilsluttet bnd %s" },
         { IDS_ATTACHED_TAPE_S_DE, "Band Image %s eingelegt" },
         { IDS_ATTACHED_TAPE_S_FR, "Datassette %s attach" },
         { IDS_ATTACHED_TAPE_S_HU, "%s szalag csatolva" },
         { IDS_ATTACHED_TAPE_S_IT, "Cassetta %s selezionata" },
         { IDS_ATTACHED_TAPE_S_NL, "Tape %s gekoppelt" },
         { IDS_ATTACHED_TAPE_S_PL, "" },             
         { IDS_ATTACHED_TAPE_S_SV, "Anslt band %s" },
         { IDS_ATTACHED_TAPE_S_TR, "Yerletirilmi teyp %s" },

         { IDS_SELECT_START_SNAPSHOT,    N_("Select start snapshot for event history") },
         { IDS_SELECT_START_SNAPSHOT_DA, "Vlg start-snapshot for hndelseshistorik" },
         { IDS_SELECT_START_SNAPSHOT_DE, "Startsnapshot fr Ereignishistory festlegen" },
         { IDS_SELECT_START_SNAPSHOT_FR, "Slectionner l'instantan de dpart pour l'historique des vnements" },
         { IDS_SELECT_START_SNAPSHOT_HU, "Vlasszon kezdeti pillanatkpet az esemny rgztshez" },
         { IDS_SELECT_START_SNAPSHOT_IT, "Seleziona lo snapshot iniziale per la cronologia degli eventi" },
         { IDS_SELECT_START_SNAPSHOT_NL, "Selecteer start momentopname voor gebeurtenis geschiedenis" },
         { IDS_SELECT_START_SNAPSHOT_PL, "" },             
         { IDS_SELECT_START_SNAPSHOT_SV, "Vlj startgonblicksmodul fr hndelsehistorik" },
         { IDS_SELECT_START_SNAPSHOT_TR, "Olay tarihesi iin balang anlk grntsn se" },

         { IDS_SELECT_END_SNAPSHOT,    N_("Select end snapshot for event history") },
         { IDS_SELECT_END_SNAPSHOT_DA, "Vlg slut-snapshot for hndelseshistorik" },
         { IDS_SELECT_END_SNAPSHOT_DE, "Startsnapshot fr Ereignishistory festlegen" },
         { IDS_SELECT_END_SNAPSHOT_FR, "Slectionner l'instantan de dpart pour l'historique des vnements" },
         { IDS_SELECT_END_SNAPSHOT_HU, "Vlasszon vgs pillanatkpet az esemny rgztshez" },
         { IDS_SELECT_END_SNAPSHOT_IT, "Seleziona lo snapshot finale per la cronologia degli eventi" },
         { IDS_SELECT_END_SNAPSHOT_NL, "Selecteer eind momentopname voor gebeurtenis geschiedenis" },
         { IDS_SELECT_END_SNAPSHOT_PL, "" },             
         { IDS_SELECT_END_SNAPSHOT_SV, "Vlj slutgonblicksmodul fr hndelsehistorik" },
         { IDS_SELECT_END_SNAPSHOT_TR, "Olay tarihesi iin biti anlk grntsn se" },

         { IDS_REALLY_EXIT,    N_("Do you really want to exit?\n\nAll the data present in the emulated RAM will be lost.") },
         { IDS_REALLY_EXIT_DA, "Vil du virkelig afslutte?\n\nAlle data i emuleret RAM gr tabt." },
         { IDS_REALLY_EXIT_DE, "Willst Du wirklich beenden?\n\nDaten im emulierten Speicher RAM gehen verloren." },
         { IDS_REALLY_EXIT_FR, "Dsirez-vous vraiment quitter?\n\nToutes les donnes prsentes dans la mmoire de "
                              "l'mulateur seront perdues." },
         { IDS_REALLY_EXIT_HU, "Biztosan kilp?\n\nAz emullt memria teljes tartalma el fog veszni." },
         { IDS_REALLY_EXIT_IT, "Uscire davvero?\n\nTutti i dati presenti nella RAM emulata saranno persi." },
         { IDS_REALLY_EXIT_NL, "Wilt U echt afsluiten?\n\nAlle data in gemuleerd geheugen zal verloren gaan." },
         { IDS_REALLY_EXIT_PL, "" },             
         { IDS_REALLY_EXIT_SV, "Vill du verkligen avsluta?\n\nAlla data i emulerat RAM kommer frloras." },
         { IDS_REALLY_EXIT_TR, "kmak istediinizden emin misiniz?\n\nEmle edilmi RAM'de bulunan mevcut tm veri "
                              "kaybedilecektir." },

         { IDS_ATTACH_CRT_IMAGE,    N_("Attach CRT cartridge image") },
         { IDS_ATTACH_CRT_IMAGE_DA, "Tilslut CRT-cartridge image" },
         { IDS_ATTACH_CRT_IMAGE_DE, "CRT Erweiterungsmodul Image einlegen" },
         { IDS_ATTACH_CRT_IMAGE_FR, "Insrer une cartouche CRT" },
         { IDS_ATTACH_CRT_IMAGE_HU, "CRT cartridge kpms csatolsa" },
         { IDS_ATTACH_CRT_IMAGE_IT, "Seleziona l'immagine di una cartuccia CRT" },
         { IDS_ATTACH_CRT_IMAGE_NL, "Koppel CRT cartridge bestand" },
         { IDS_ATTACH_CRT_IMAGE_PL, "" },             
         { IDS_ATTACH_CRT_IMAGE_SV, "Anslut CRT-insticksmodulfil" },
         { IDS_ATTACH_CRT_IMAGE_TR, "CRT kartu imaj yerletir" },

         { IDS_ATTACH_RAW_8KB_IMAGE,    N_("Attach raw 8KB cartridge image") },
         { IDS_ATTACH_RAW_8KB_IMAGE_DA, "Tilslut rt 8KB-cartridge image" },
         { IDS_ATTACH_RAW_8KB_IMAGE_DE, "8KB Erweiterungsmodul (raw) Image einlegen" },
         { IDS_ATTACH_RAW_8KB_IMAGE_FR, "Insrer une cartouche 8KO" },
         { IDS_ATTACH_RAW_8KB_IMAGE_HU, "Nyers 8KB-os cartridge kpms csatolsa" },
         { IDS_ATTACH_RAW_8KB_IMAGE_IT, "Seleziona l'immagine di una cartuccia da 8KB" },
         { IDS_ATTACH_RAW_8KB_IMAGE_NL, "Koppel binair 8KB cartridgebestand" },
         { IDS_ATTACH_RAW_8KB_IMAGE_PL, "" },             
         { IDS_ATTACH_RAW_8KB_IMAGE_SV, "Anslut ra 8KB-insticksmodulavbilding" },
         { IDS_ATTACH_RAW_8KB_IMAGE_TR, "Dz 8KB kartu imaj yerletir" },

         { IDS_ATTACH_RAW_16KB_IMAGE,    N_("Attach raw 16KB cartridge image") },
         { IDS_ATTACH_RAW_16KB_IMAGE_DA, "Tilslut rt 16KB-cartridge image" },
         { IDS_ATTACH_RAW_16KB_IMAGE_DE, "16KB Erweiterungsmodul (raw) Image einlegen" },
         { IDS_ATTACH_RAW_16KB_IMAGE_FR, "Insrer une cartouche 16KO" },
         { IDS_ATTACH_RAW_16KB_IMAGE_HU, "Nyers 16KB-os cartridge kpms csatolsa" },
         { IDS_ATTACH_RAW_16KB_IMAGE_IT, "Seleziona l'immagine di una cartuccia da 16KB" },
         { IDS_ATTACH_RAW_16KB_IMAGE_NL, "Koppel binair 16KB cartridgebestand" },
         { IDS_ATTACH_RAW_16KB_IMAGE_PL, "" },             
         { IDS_ATTACH_RAW_16KB_IMAGE_SV, "Anslut ra 16KB-insticksmodulavbilding" },
         { IDS_ATTACH_RAW_16KB_IMAGE_TR, "Dz 16KB kartu imaj yerletir" },

         { IDS_ATTACH_ACTION_REPLAY_IMAGE,    N_("Attach Action Replay cartridge image") },
         { IDS_ATTACH_ACTION_REPLAY_IMAGE_DA, "Tilslut Action Replay-cartridge image" },
         { IDS_ATTACH_ACTION_REPLAY_IMAGE_DE, "Action Replay Erweiterungsmodul Image einlegen" },
         { IDS_ATTACH_ACTION_REPLAY_IMAGE_FR, "Insrer une cartouche Action Replay" },
         { IDS_ATTACH_ACTION_REPLAY_IMAGE_HU, "Action Replay cartridge kpms csatolsa" },
         { IDS_ATTACH_ACTION_REPLAY_IMAGE_IT, "Seleziona l'immagine di una cartuccia Action Replay" },
         { IDS_ATTACH_ACTION_REPLAY_IMAGE_NL, "Koppel Action Replay cartridgebestand" },
         { IDS_ATTACH_ACTION_REPLAY_IMAGE_PL, "" },             
         { IDS_ATTACH_ACTION_REPLAY_IMAGE_SV, "Anslut Action Replay-insticksmodulfil" },
         { IDS_ATTACH_ACTION_REPLAY_IMAGE_TR, "Action Replay kartu imaj yerletir" },

         { IDS_ATTACH_ACTION_REPLAY3_IMAGE,    N_("Attach Action Replay 3 cartridge image") },
         { IDS_ATTACH_ACTION_REPLAY3_IMAGE_DA, "Tilslut Action Replay 3-cartridge image" },
         { IDS_ATTACH_ACTION_REPLAY3_IMAGE_DE, "Action Replay 3 Erweiterungsmodul Image einlegen" },
         { IDS_ATTACH_ACTION_REPLAY3_IMAGE_FR, "Insrer une cartouche Action Replay 3" },
         { IDS_ATTACH_ACTION_REPLAY3_IMAGE_HU, "Action Replay 3 cartridge kpms csatolsa" },
         { IDS_ATTACH_ACTION_REPLAY3_IMAGE_IT, "Seleziona l'immagine di una cartuccia Action Replay 3" },
         { IDS_ATTACH_ACTION_REPLAY3_IMAGE_NL, "Koppel Action Replay 3 cartridgebestand" },
         { IDS_ATTACH_ACTION_REPLAY3_IMAGE_PL, "" },             
         { IDS_ATTACH_ACTION_REPLAY3_IMAGE_SV, "Anslut Action Replay 3-avbildningsfil" },
         { IDS_ATTACH_ACTION_REPLAY3_IMAGE_TR, "Action Replay 3 kartu imaj yerletir" },

         { IDS_ATTACH_ACTION_REPLAY4_IMAGE,    N_("Attach Action Replay 4 cartridge image") },
         { IDS_ATTACH_ACTION_REPLAY4_IMAGE_DA, "Tilslut Action Replay 4-cartridge image" },
         { IDS_ATTACH_ACTION_REPLAY4_IMAGE_DE, "Action Replay 4 Erweiterungsmodul Image einlegen" },
         { IDS_ATTACH_ACTION_REPLAY4_IMAGE_FR, "Insrer une cartouche Action Replay 4" },
         { IDS_ATTACH_ACTION_REPLAY4_IMAGE_HU, "Action Replay 4 cartridge kpms csatolsa" },
         { IDS_ATTACH_ACTION_REPLAY4_IMAGE_IT, "Seleziona l'immagine di una cartuccia Action Replay 4" },
         { IDS_ATTACH_ACTION_REPLAY4_IMAGE_NL, "Koppel Action Replay 4 cartridgebestand" },
         { IDS_ATTACH_ACTION_REPLAY4_IMAGE_PL, "" },             
         { IDS_ATTACH_ACTION_REPLAY4_IMAGE_SV, "Anslut Action Replay 4-insticksmodulfil" },
         { IDS_ATTACH_ACTION_REPLAY4_IMAGE_TR, "Action Replay 4 kartu imaj yerletir" },

         { IDS_ATTACH_STARDOS_IMAGE,    N_("Attach StarDOS cartridge image") },
         { IDS_ATTACH_STARDOS_IMAGE_DA, "Tilslut StarDOS-cartridge image" },
         { IDS_ATTACH_STARDOS_IMAGE_DE, "Erweiterungsmodul StarDOS Image einlegen" },
         { IDS_ATTACH_STARDOS_IMAGE_FR, "" },             
         { IDS_ATTACH_STARDOS_IMAGE_HU, "StarDOS cartridge kpms csatolsa" },
         { IDS_ATTACH_STARDOS_IMAGE_IT, "Seleziona l'immagine di una cartuccia StarDOS" },
         { IDS_ATTACH_STARDOS_IMAGE_NL, "Koppel StarDOS cartridgebestand" },
         { IDS_ATTACH_STARDOS_IMAGE_PL, "" },             
         { IDS_ATTACH_STARDOS_IMAGE_SV, "Anslut StarDOS-insticksmodulfil" },
         { IDS_ATTACH_STARDOS_IMAGE_TR, "StarDOS kartu imaj yerletir" },

         { IDS_ATTACH_ATOMIC_POWER_IMAGE,    N_("Attach Atomic Power cartridge image") },
         { IDS_ATTACH_ATOMIC_POWER_IMAGE_PL, "Tilslut Atomic Power-cartridge image" },
         { IDS_ATTACH_ATOMIC_POWER_IMAGE_DE, "Atomic Power Erweiterungsmodul Image einlegen" },
         { IDS_ATTACH_ATOMIC_POWER_IMAGE_FR, "Insrer une cartouche Atomic Power" },
         { IDS_ATTACH_ATOMIC_POWER_IMAGE_HU, "Atomic Power cartridge kpms csatolsa" },
         { IDS_ATTACH_ATOMIC_POWER_IMAGE_IT, "Seleziona l'immagine di una cartuccia Atomic Power" },
         { IDS_ATTACH_ATOMIC_POWER_IMAGE_NL, "Koppel Atomic Power cartridgebestand" },
         { IDS_ATTACH_ATOMIC_POWER_IMAGE_PL, "" },             
         { IDS_ATTACH_ATOMIC_POWER_IMAGE_SV, "Anslut Atomic Power-avbildningsfil" },
         { IDS_ATTACH_ATOMIC_POWER_IMAGE_TR, "Atomic Power kartu imaj yerletir" },

         { IDS_ATTACH_EPYX_FASTLOAD_IMAGE,    N_("Attach Epyx fastload cartridge image") },
         { IDS_ATTACH_EPYX_FASTLOAD_IMAGE_DA, "Tilslut Epyx fastload-cartridge image" },
         { IDS_ATTACH_EPYX_FASTLOAD_IMAGE_DE, "Epyx Fastload Erweiterungsmodul Image einlegen" },
         { IDS_ATTACH_EPYX_FASTLOAD_IMAGE_FR, "Insrer une cartouche Epyx FastLoad" },
         { IDS_ATTACH_EPYX_FASTLOAD_IMAGE_HU, "Epyx gyorstlt cartridge kpms csatolsa" },
         { IDS_ATTACH_EPYX_FASTLOAD_IMAGE_IT, "Seleziona l'immagine di una cartuccia Epyx fastload" },
         { IDS_ATTACH_EPYX_FASTLOAD_IMAGE_NL, "Koppel Epyx fastload cartridgebestand" },
         { IDS_ATTACH_EPYX_FASTLOAD_IMAGE_PL, "" },             
         { IDS_ATTACH_EPYX_FASTLOAD_IMAGE_SV, "Anslut Epyx fastload-avbildningsfil" },
         { IDS_ATTACH_EPYX_FASTLOAD_IMAGE_TR, "Epyx fastload kartu imaj yerletir" },

         { IDS_ATTACH_IEEE488_IMAGE,    N_("Attach IEEE interface cartridge image") },
         { IDS_ATTACH_IEEE488_IMAGE_DA, "Tilslut IEEE-interface cartridge image" },
         { IDS_ATTACH_IEEE488_IMAGE_DE, "IEEE Schnittstellen Erweiterungsmodul Image einlegen" },
         { IDS_ATTACH_IEEE488_IMAGE_FR, "Insrer une cartouche interface IEEE" },
         { IDS_ATTACH_IEEE488_IMAGE_HU, "IEEE interfsz cartridge kpms csatolsa" },
         { IDS_ATTACH_IEEE488_IMAGE_IT, "Seleziona l'immagine di una cartuccia di interfaccia IEEE" },
         { IDS_ATTACH_IEEE488_IMAGE_NL, "Koppel IEEE interface cartridgebestand" },
         { IDS_ATTACH_IEEE488_IMAGE_PL, "" },             
         { IDS_ATTACH_IEEE488_IMAGE_SV, "Anslut IEE-grnssnittsavbildningsfil" },
         { IDS_ATTACH_IEEE488_IMAGE_TR, "IEEE arabirimi kartu imaj yerletir" },

         { IDS_ATTACH_RETRO_REPLAY_IMAGE,    N_("Attach Retro Replay cartridge image") },
         { IDS_ATTACH_RETRO_REPLAY_IMAGE_DA, "Tilslut Retro Replay-cartridge image" },
         { IDS_ATTACH_RETRO_REPLAY_IMAGE_DE, "Retro Replay Erweiterungsmodul Image einlegen" },
         { IDS_ATTACH_RETRO_REPLAY_IMAGE_FR, "Insrer une cartouche Retro Replay" },
         { IDS_ATTACH_RETRO_REPLAY_IMAGE_HU, "Retro Replay cartridge kpms csatolsa" },
         { IDS_ATTACH_RETRO_REPLAY_IMAGE_IT, "Seleziona l'immagine di una cartuccia Retro Replay" },
         { IDS_ATTACH_RETRO_REPLAY_IMAGE_NL, "Koppel Retro Replay cartridgebestand" },
         { IDS_ATTACH_RETRO_REPLAY_IMAGE_PL, "" },             
         { IDS_ATTACH_RETRO_REPLAY_IMAGE_SV, "Anslut Retro Replay-avbildningsfil" },
         { IDS_ATTACH_RETRO_REPLAY_IMAGE_TR, "Retro Replay kartu imaj yerletir" },

         { IDS_ATTACH_IDE64_IMAGE,    N_("Attach IDE64 interface cartridge image") },
         { IDS_ATTACH_IDE64_IMAGE_DA, "Tilslut IDE64-interface cartridge image" },
         { IDS_ATTACH_IDE64_IMAGE_DE, "IDE64 Schnittstellen Erweiterungsmodul Image einlegen" },
         { IDS_ATTACH_IDE64_IMAGE_FR, "Insrer une cartouche interface IDE64" },
         { IDS_ATTACH_IDE64_IMAGE_HU, "IDE64 interfsz kpms csatolsa" },
         { IDS_ATTACH_IDE64_IMAGE_IT, "Seleziona l'immagine di una cartuccia di interfaccia IDE64" },
         { IDS_ATTACH_IDE64_IMAGE_NL, "Koppel IDE64 interface cartridgebestand" },
         { IDS_ATTACH_IDE64_IMAGE_PL, "" },             
         { IDS_ATTACH_IDE64_IMAGE_SV, "Anslut IDE64-grnssnittsavbildningsfil" },
         { IDS_ATTACH_IDE64_IMAGE_TR, "IDE64 arabirimi kartu imaj yerletir" },

         { IDS_ATTACH_SS4_IMAGE,    N_("Attach Super Snapshot 4 cartridge image") },
         { IDS_ATTACH_SS4_IMAGE_DA, "Tilslut Super Snapshot 4-cartridge image" },
         { IDS_ATTACH_SS4_IMAGE_DE, "Super Snapshot 4 Erweiterungsmodul Image einlegen" },
         { IDS_ATTACH_SS4_IMAGE_FR, "Insrer une cartouche Super Snapshot 4" },
         { IDS_ATTACH_SS4_IMAGE_HU, "Super Snapshot 4 cartridge kpms csatolsa" },
         { IDS_ATTACH_SS4_IMAGE_IT, "Seleziona l'immagine di una cartuccia Super Snapshot 4" },
         { IDS_ATTACH_SS4_IMAGE_NL, "Koppel Super Snapshot 4 cartridgebestand" },
         { IDS_ATTACH_SS4_IMAGE_PL, "" },             
         { IDS_ATTACH_SS4_IMAGE_SV, "Anslut Super Snapshot 4-avbildningsfil" },
         { IDS_ATTACH_SS4_IMAGE_TR, "Super Snapshot 4 kartu imaj yerletir" },

         { IDS_ATTACH_SS5_IMAGE,    N_("Attach Super Snapshot 5 cartridge image") },
         { IDS_ATTACH_SS5_IMAGE_DA, "Tilslut Super Snapshot 5-cartridge image" },
         { IDS_ATTACH_SS5_IMAGE_DE, "Super Snapshot 5 Erweiterungsmodul Image einlegen" },
         { IDS_ATTACH_SS5_IMAGE_FR, "Insrer une cartouche Super Snapshot 5" },
         { IDS_ATTACH_SS5_IMAGE_HU, "Super Snapshot 5 cartridge kpms csatolsa" },
         { IDS_ATTACH_SS5_IMAGE_IT, "Seleziona l'immagine di una cartuccia Super Snapshot 5" },
         { IDS_ATTACH_SS5_IMAGE_NL, "Koppel Super Snapshot 5 cartridgebestand" },
         { IDS_ATTACH_SS5_IMAGE_PL, "" },             
         { IDS_ATTACH_SS5_IMAGE_SV, "Anslut Super Snapshot 5-avbildningsfil" },
         { IDS_ATTACH_SS5_IMAGE_TR, "Super Snapshot 5 kartu imaj yerletir" },

         { IDS_ATTACH_SB_IMAGE,    N_("Attach Structured Basic cartridge image") },
         { IDS_ATTACH_SB_IMAGE_DA, "Tilslut Strucured Basic-cartridge image" },
         { IDS_ATTACH_SB_IMAGE_DE, "Erweiterungsmodul Structured Basic einlegen" },
         { IDS_ATTACH_SB_IMAGE_FR, "" },             
         { IDS_ATTACH_SB_IMAGE_HU, "Structured Basic cartridge kpms csatolsa" },
         { IDS_ATTACH_SB_IMAGE_IT, "Seleziona l'immagine di una cartuccia Structured Basic" },
         { IDS_ATTACH_SB_IMAGE_NL, "Koppel Structured Basic cartridgebestand" },
         { IDS_ATTACH_SB_IMAGE_PL, "" },             
         { IDS_ATTACH_SB_IMAGE_SV, "Anslut Structured Basic insticksavbildningsfil" },
         { IDS_ATTACH_SB_IMAGE_TR, "Structured Basic kartu imaj yerletir" },

         { IDS_AVAILABLE_CMDLINE_OPTIONS,    N_("\nAvailable command-line options:\n\n") },
         { IDS_AVAILABLE_CMDLINE_OPTIONS_DA, "\nMulige kommandolinjeparametre:\n\n" },
         { IDS_AVAILABLE_CMDLINE_OPTIONS_DE, "\nZulssige Kommandozeilen Optionen:\n\n" },
         { IDS_AVAILABLE_CMDLINE_OPTIONS_FR, "\nOptions de ligne de commande disponibles:\n\n" },
         { IDS_AVAILABLE_CMDLINE_OPTIONS_HU, "\nLehetsges parancssori opcik:\n\n" },
         { IDS_AVAILABLE_CMDLINE_OPTIONS_IT, "\nOpzioni disponibili da riga di comando:\n\n" },
         { IDS_AVAILABLE_CMDLINE_OPTIONS_NL, "\nBeschikbare command-line opties:\n\n" },
         { IDS_AVAILABLE_CMDLINE_OPTIONS_PL, "" },             
         { IDS_AVAILABLE_CMDLINE_OPTIONS_SV, "\nTillgngliga kommandoradsargument:\n\n" },
         { IDS_AVAILABLE_CMDLINE_OPTIONS_TR, "\nMevcut komut satr seenekleri:\n\n" },

         { IDS_ATTACH_4_8_16KB_AT_2000,    N_("Attach 4/8/16KB cartridge image at $2000") },
         { IDS_ATTACH_4_8_16KB_AT_2000_DA, "Tilslut 4/8/16KB-cartridge image p $2000" },
         { IDS_ATTACH_4_8_16KB_AT_2000_DE, "4/8/16KB Modul Image bei $2000 einlegen" },
         { IDS_ATTACH_4_8_16KB_AT_2000_FR, "Insertion d'une image 4/8/16Ko   $2000" },
         { IDS_ATTACH_4_8_16KB_AT_2000_HU, "4/8/16KB kpms csatolsa $2000 cmre" },
         { IDS_ATTACH_4_8_16KB_AT_2000_IT, "Seleziona l'immagine di una cartuccia da 4/8/16KB a $2000" },
         { IDS_ATTACH_4_8_16KB_AT_2000_NL, "Koppel 4/8/16KB-bestand op $2000" },
         { IDS_ATTACH_4_8_16KB_AT_2000_PL, "" },             
         { IDS_ATTACH_4_8_16KB_AT_2000_SV, "Anslut 4/8/16KB-modulfil vid $2000" },
         { IDS_ATTACH_4_8_16KB_AT_2000_TR, "$2000 adresine 4/8/16KB kartu imaj yerletir" },

         { IDS_ATTACH_4_8_16KB_AT_4000,    N_("Attach 4/8/16KB cartridge image at $4000") },
         { IDS_ATTACH_4_8_16KB_AT_4000_DA, "Tilslut 4/8/16KB-cartridge image p $4000" },
         { IDS_ATTACH_4_8_16KB_AT_4000_DE, "4/8/16KB Modul Image bei $4000 einlegen" },
         { IDS_ATTACH_4_8_16KB_AT_4000_FR, "Insertion d'une image 4/8/16Ko   $4000" },
         { IDS_ATTACH_4_8_16KB_AT_4000_HU, "4/8/16KB kpms csatolsa $4000 cmre" },
         { IDS_ATTACH_4_8_16KB_AT_4000_IT, "Seleziona l'immagine di una cartuccia da 4/8/16KB a $4000" },
         { IDS_ATTACH_4_8_16KB_AT_4000_NL, "Koppel 4/8/16KB-bestand op $4000" },
         { IDS_ATTACH_4_8_16KB_AT_4000_PL, "" },             
         { IDS_ATTACH_4_8_16KB_AT_4000_SV, "Anslut 4/8/16KB-modulfil vid $4000" },
         { IDS_ATTACH_4_8_16KB_AT_4000_TR, "$4000 adresine 4/8/16KB kartu imaj yerletir" },

         { IDS_ATTACH_4_8_16KB_AT_6000,    N_("Attach 4/8/16KB cartridge image at $6000") },
         { IDS_ATTACH_4_8_16KB_AT_6000_DA, "Tilslut 4/8/16KB-cartridge image p $6000" },
         { IDS_ATTACH_4_8_16KB_AT_6000_DE, "4/8/16KB Modul Image bei $6000 einlegen" },
         { IDS_ATTACH_4_8_16KB_AT_6000_FR, "Insertion d'une image 4/8/16Ko   $6000" },
         { IDS_ATTACH_4_8_16KB_AT_6000_HU, "4/8/16KB kpms csatolsa $6000 cmre" },
         { IDS_ATTACH_4_8_16KB_AT_6000_IT, "Seleziona l'immagine di una cartuccia da 4/8/16KB a $6000" },
         { IDS_ATTACH_4_8_16KB_AT_6000_NL, "Koppel 4/8/16KB-bestand op $6000" },
         { IDS_ATTACH_4_8_16KB_AT_6000_PL, "" },             
         { IDS_ATTACH_4_8_16KB_AT_6000_SV, "Anslut 4/8/16KB-modulfil vid $6000" },
         { IDS_ATTACH_4_8_16KB_AT_6000_TR, "$6000 adresine 4/8/16KB kartu imaj yerletir" },

         { IDS_ATTACH_4_8KB_AT_A000,    N_("Attach 4/8KB cartridge image at $A000") },
         { IDS_ATTACH_4_8KB_AT_A000_DA, "Tilslut 4/8KB-cartridge image p $A000" },
         { IDS_ATTACH_4_8KB_AT_A000_DE, "4/8KB Modul Image bei $A000 einlegen" },
         { IDS_ATTACH_4_8KB_AT_A000_FR, "Insertion d'une image 4/8Ko   $A000" },
         { IDS_ATTACH_4_8KB_AT_A000_HU, "4/8KB kpms csatolsa $A000 cmre" },
         { IDS_ATTACH_4_8KB_AT_A000_IT, "Seleziona l'immagine di una cartuccia da 4/8KB a $A000" },
         { IDS_ATTACH_4_8KB_AT_A000_NL, "Koppel 4/8KB-bestand op $A000" },
         { IDS_ATTACH_4_8KB_AT_A000_PL, "" },             
         { IDS_ATTACH_4_8KB_AT_A000_SV, "Anslut 4/8KB-modulfil vid $A000" },
         { IDS_ATTACH_4_8KB_AT_A000_TR, "$A000 adresine 4/8KB kartu imaj yerletir" },

         { IDS_ATTACH_4KB_AT_B000,    N_("Attach 4KB cartridge image at $B000") },
         { IDS_ATTACH_4KB_AT_B000_DA, "Tilslut 4KB-cartridge image p $B000" },
         { IDS_ATTACH_4KB_AT_B000_DE, "4KB Modul Image bei $B000 einlegen" },
         { IDS_ATTACH_4KB_AT_B000_FR, "Insertion d'une image 4Ko   $B000" },
         { IDS_ATTACH_4KB_AT_B000_HU, "4KB kpms csatolsa $B000 cmre" },
         { IDS_ATTACH_4KB_AT_B000_IT, "Seleziona l'immagine di una cartuccia da 4KB a $B000" },
         { IDS_ATTACH_4KB_AT_B000_NL, "Koppel 4KB-bestand op $B000" },
         { IDS_ATTACH_4KB_AT_B000_PL, "" },             
         { IDS_ATTACH_4KB_AT_B000_SV, "Anslut 4KB-modulfil vid $B000" },
         { IDS_ATTACH_4KB_AT_B000_TR, "$B000 adresine 4KB kartu imaj yerletir" },

         { IDS_S_AT_D_SPEED,    N_("%s at %d%% speed, %d fps%s") },
         { IDS_S_AT_D_SPEED_DA, "%s med %d%% hastighed, %d b/s%s" },
         { IDS_S_AT_D_SPEED_DE, "%s bei %d%% Geschwindigkeit, %d fps%s" },
         { IDS_S_AT_D_SPEED_FR, "%s   une vitesse de %d%%,   %d img/s%s" },
         { IDS_S_AT_D_SPEED_HU, "%s %d%% sebessgen, %d fps%s" },
         { IDS_S_AT_D_SPEED_IT, "velocit %s al %d%%, %d fps%s" },
         { IDS_S_AT_D_SPEED_NL, "%s met %d%% snelheid, %d fps%s" },
         { IDS_S_AT_D_SPEED_PL, "" },             
         { IDS_S_AT_D_SPEED_SV, "%s med %d%% hastighet, %d b/s%s" },
         { IDS_S_AT_D_SPEED_TR, "%s %d%% hznda, %d fps%s" },

         { IDS_ATTACH,    N_("Attach") },
         { IDS_ATTACH_DA, "Tilslut" },
         { IDS_ATTACH_DE, "Einlegen" },
         { IDS_ATTACH_FR, "" },             
         { IDS_ATTACH_HU, "Csatols" },
         { IDS_ATTACH_IT, "Seleziona" },
         { IDS_ATTACH_NL, "Koppel" },
         { IDS_ATTACH_PL, "" },             
         { IDS_ATTACH_SV, "Anslut" },
         { IDS_ATTACH_TR, "Yerletir" },

         { IDS_PARENT,    N_("Parent") },
         { IDS_PARENT_DA, "Forlder" },
         { IDS_PARENT_DE, "Vorgnger" },
         { IDS_PARENT_FR, "" },             
         { IDS_PARENT_HU, "Szl" },
         { IDS_PARENT_IT, "Livello superiore" },
         { IDS_PARENT_NL, "Bovenliggende directory" },
         { IDS_PARENT_PL, "" },             
         { IDS_PARENT_SV, "Moderlda" },
         { IDS_PARENT_TR, "st e" },

         { IDS_ATTACH_READ_ONLY,    N_("Attach read only") },
         { IDS_ATTACH_READ_ONLY_DA, "Tilslut skrivebeskyttet" },
         { IDS_ATTACH_READ_ONLY_DE, "Schreibgeschtzt einlegen" },
         { IDS_ATTACH_READ_ONLY_FR, "Insrer en lecture seule" },
         { IDS_ATTACH_READ_ONLY_HU, "Csatols csak olvashat mdon" },
         { IDS_ATTACH_READ_ONLY_IT, "Seleziona in sola lettura" },
         { IDS_ATTACH_READ_ONLY_NL, "Alleen lezen" },
         { IDS_ATTACH_READ_ONLY_PL, "" },             
         { IDS_ATTACH_READ_ONLY_SV, "Anslut skrivskyddat" },
         { IDS_ATTACH_READ_ONLY_TR, "Salt okunur yerletir" },

         { IDS_NAME,    N_("Name") },
         { IDS_NAME_DA, "Navn" },
         { IDS_NAME_DE, "Name" },
         { IDS_NAME_FR, "Nom" },
         { IDS_NAME_HU, "Nv" },
         { IDS_NAME_IT, "Nome" },
         { IDS_NAME_NL, "Naam" },
         { IDS_NAME_PL, "" },             
         { IDS_NAME_SV, "Namn" },
         { IDS_NAME_TR, "sim" },

         { IDS_CREATE_IMAGE,    N_("Create Image") },
         { IDS_CREATE_IMAGE_DA, "Opret image" },
         { IDS_CREATE_IMAGE_DE, "Image Datei erzeugen" },
         { IDS_CREATE_IMAGE_FR, "Cration d'image" },
         { IDS_CREATE_IMAGE_HU, "Kpms ltrehozsa" },
         { IDS_CREATE_IMAGE_IT, "Crea immagine" },
         { IDS_CREATE_IMAGE_NL, "Maak Bestand" },
         { IDS_CREATE_IMAGE_PL, "" },             
         { IDS_CREATE_IMAGE_SV, "Skapa avbildning" },
         { IDS_CREATE_IMAGE_TR, "Imaj Yarat" },

         { IDS_NEW_IMAGE,    N_("New Image") },
         { IDS_NEW_IMAGE_DA, "Nyt image" },
         { IDS_NEW_IMAGE_DE, "Neue Image Datei" },
         { IDS_NEW_IMAGE_FR, "Nouvelle image" },
         { IDS_NEW_IMAGE_HU, "j kpms" },
         { IDS_NEW_IMAGE_IT, "Nuova immagine" },
         { IDS_NEW_IMAGE_NL, "Nieuw Bestand" },
         { IDS_NEW_IMAGE_PL, "" },             
         { IDS_NEW_IMAGE_SV, "Ny avbildning" },
         { IDS_NEW_IMAGE_TR, "Yeni maj" },

         { IDS_NEW_TAP_IMAGE,    N_("New TAP Image") },
         { IDS_NEW_TAP_IMAGE_DA, "Nyt TAP-image" },
         { IDS_NEW_TAP_IMAGE_DE, "Neue TAP Image Datei" },
         { IDS_NEW_TAP_IMAGE_FR, "Nouvelle image TAP" },
         { IDS_NEW_TAP_IMAGE_HU, "j TAP kpms" },
         { IDS_NEW_TAP_IMAGE_IT, "Nuova immagine TAP" },
         { IDS_NEW_TAP_IMAGE_NL, "Nieuw TAP-bestand" },
         { IDS_NEW_TAP_IMAGE_PL, "" },             
         { IDS_NEW_TAP_IMAGE_SV, "Ny TAP-avbildning" },
         { IDS_NEW_TAP_IMAGE_TR, "Yeni TAP Imaj" },

         { IDS_OVERWRITE_EXISTING_IMAGE,    N_("Overwrite existing image?") },
         { IDS_OVERWRITE_EXISTING_IMAGE_DA, "Overskriv eksisterende image?" },
         { IDS_OVERWRITE_EXISTING_IMAGE_DE, "Existierende Datei berschreiben?" },
         { IDS_OVERWRITE_EXISTING_IMAGE_FR, "craser les images existantes?" },
         { IDS_OVERWRITE_EXISTING_IMAGE_HU, "Fellrjam a meglv kpmst?" },
         { IDS_OVERWRITE_EXISTING_IMAGE_IT, "Sovrascrivo immagine esistente?" },
         { IDS_OVERWRITE_EXISTING_IMAGE_NL, "Bestaand bestand overschrijven?" },
         { IDS_OVERWRITE_EXISTING_IMAGE_PL, "" },             
         { IDS_OVERWRITE_EXISTING_IMAGE_SV, "Skriva ver existerande avbildning?" },
         { IDS_OVERWRITE_EXISTING_IMAGE_TR, "Varolan imajn zerine yazlsn m?" },

         { IDS_ABOUT,    N_("About") },
         { IDS_ABOUT_DA, "Om" },
         { IDS_ABOUT_DE, "ber VICE" },
         { IDS_ABOUT_FR, " Propos" },
         { IDS_ABOUT_HU, "Nvjegy" },
         { IDS_ABOUT_IT, "Informazioni" },
         { IDS_ABOUT_NL, "Over VICE" },
         { IDS_ABOUT_PL, "" },             
         { IDS_ABOUT_SV, "Om VICE" },
         { IDS_ABOUT_TR, "Hakknda" },

         { IDS_IMAGE_CONTENTS,    N_("Image Contents") },
         { IDS_IMAGE_CONTENTS_DA, "Indhold i image" },
         { IDS_IMAGE_CONTENTS_DE, "Image Datei Inhalt" },
         { IDS_IMAGE_CONTENTS_FR, "Contenu de l'image" },
         { IDS_IMAGE_CONTENTS_HU, "Tartalom" },
         { IDS_IMAGE_CONTENTS_IT, "Contenuti immagine" },
         { IDS_IMAGE_CONTENTS_NL, "Bestandsinhoud" },
         { IDS_IMAGE_CONTENTS_PL, "" },             
         { IDS_IMAGE_CONTENTS_SV, "Innehall i avbildning" },
         { IDS_IMAGE_CONTENTS_TR, "Imaj erii" },

         { IDMS_DISABLED,    N_("Disabled") },
         { IDMS_DISABLED_DA, "Deaktiveret" },
         { IDMS_DISABLED_DE, "Deaktiviert" },
         { IDMS_DISABLED_FR, "Dsactiv" },
         { IDMS_DISABLED_HU, "Tiltva" },
         { IDMS_DISABLED_IT, "Disattivo" },
         { IDMS_DISABLED_NL, "Uit" },
         { IDMS_DISABLED_PL, "" },             
         { IDMS_DISABLED_SV, "Av" },
         { IDMS_DISABLED_TR, "Pasif" },

         { IDS_ENABLED,    N_("Enabled") },
         { IDS_ENABLED_DA, "Aktiveret" },
         { IDS_ENABLED_DE, "Aktiviert" },
         { IDS_ENABLED_FR, "" },             
         { IDS_ENABLED_HU, "Engedlyezve" },
         { IDS_ENABLED_IT, "Attivo" },
         { IDS_ENABLED_NL, "Aan" },
         { IDS_ENABLED_PL, "" },             
         { IDS_ENABLED_SV, "P" },
         { IDS_ENABLED_TR, "Aktif" },

         { IDS_RS232_DEVICE_1,    N_("RS232 Device 1") },
         { IDS_RS232_DEVICE_1_DA, "RS232-enhed 1" },
         { IDS_RS232_DEVICE_1_DE, "RS232 Gert 1" },
         { IDS_RS232_DEVICE_1_FR, "1er Priphrique RS232" },
         { IDS_RS232_DEVICE_1_HU, "RS232 1-es eszkz" },
         { IDS_RS232_DEVICE_1_IT, "Dispositivo RS232 1" },
         { IDS_RS232_DEVICE_1_NL, "RS232 apparaat 1" },
         { IDS_RS232_DEVICE_1_PL, "" },             
         { IDS_RS232_DEVICE_1_SV, "RS232-enhet 1" },
         { IDS_RS232_DEVICE_1_TR, "RS232 Aygt 1" },

         { IDS_RS232_DEVICE_2,    N_("RS232 Device 2") },
         { IDS_RS232_DEVICE_2_DA, "RS232-enhed 2" },
         { IDS_RS232_DEVICE_2_DE, "RS232 Gert 2" },
         { IDS_RS232_DEVICE_2_FR, "2e Priphrique RS232" },
         { IDS_RS232_DEVICE_2_HU, "RS232 2-es eszkz" },
         { IDS_RS232_DEVICE_2_IT, "Dispositivo RS232 2" },
         { IDS_RS232_DEVICE_2_NL, "RS232 apparaat 2" },
         { IDS_RS232_DEVICE_2_PL, "" },             
         { IDS_RS232_DEVICE_2_SV, "RS232-enhet 2" },
         { IDS_RS232_DEVICE_2_TR, "RS232 Aygt 2" },

         { IDS_RS232_DEVICE_3,    N_("RS232 Device 3") },
         { IDS_RS232_DEVICE_3_DA, "RS232-enhed 3" },
         { IDS_RS232_DEVICE_3_DE, "RS232 Gert 3" },
         { IDS_RS232_DEVICE_3_FR, "3e Priphrique RS232" },
         { IDS_RS232_DEVICE_3_HU, "RS232 3-as eszkz" },
         { IDS_RS232_DEVICE_3_IT, "Dispositivo RS232 3" },
         { IDS_RS232_DEVICE_3_NL, "RS232 apparaat 3" },
         { IDS_RS232_DEVICE_3_PL, "" },             
         { IDS_RS232_DEVICE_3_SV, "RS232-enhet 3" },
         { IDS_RS232_DEVICE_3_TR, "RS232 Aygt 3" },

         { IDS_RS232_DEVICE_4,    N_("RS232 Device 4") },
         { IDS_RS232_DEVICE_4_DA, "RS232-enhed 4" },
         { IDS_RS232_DEVICE_4_DE, "RS232 Gert 4" },
         { IDS_RS232_DEVICE_4_FR, "4e Priphrique RS232" },
         { IDS_RS232_DEVICE_4_HU, "RS232 4-es eszkz" },
         { IDS_RS232_DEVICE_4_IT, "Dispositivo RS232 4" },
         { IDS_RS232_DEVICE_4_NL, "RS232 apparaat 4" },
         { IDS_RS232_DEVICE_4_PL, "" },             
         { IDS_RS232_DEVICE_4_SV, "RS232-enhet 4" },
         { IDS_RS232_DEVICE_4_TR, "RS232 Aygt 4" },

         { IDS_NONE,    N_("None") },
         { IDS_NONE_DA, "Ingen" },
         { IDS_NONE_DE, "Kein" },
         { IDS_NONE_FR, "Aucun" },
         { IDS_NONE_HU, "Nincs" },
         { IDS_NONE_IT, "Nessuno" },
         { IDS_NONE_NL, "Geen" },
         { IDS_NONE_PL, "" },             
         { IDS_NONE_SV, "Ingen" },
         { IDS_NONE_TR, "Yok" },

         { IDS_ADC,    N_("ADC") },
         { IDS_ADC_DA, "ADC" },
         { IDS_ADC_DE, "ADC" },
         { IDS_ADC_FR, "ADC" },
         { IDS_ADC_HU, "ADC" },
         { IDS_ADC_IT, "ADC" },
         { IDS_ADC_NL, "ADC" },
         { IDS_ADC_PL, "ADC" },
         { IDS_ADC_SV, "ADC" },
         { IDS_ADC_TR, "ADC" },

         { IDS_JOYSTICK,    N_("Joystick") },
         { IDS_JOYSTICK_DA, "Joystick" },
         { IDS_JOYSTICK_DE, "Joystick" },
         { IDS_JOYSTICK_FR, "" },             
         { IDS_JOYSTICK_HU, "Botkormny" },
         { IDS_JOYSTICK_IT, "Joystick" },
         { IDS_JOYSTICK_NL, "Joystick" },
         { IDS_JOYSTICK_PL, "" },             
         { IDS_JOYSTICK_SV, "Styrspak" },
         { IDS_JOYSTICK_TR, "Joystick" },

         { IDS_IRQ,    N_("IRQ") },
         { IDS_IRQ_DA, "IRQ" },
         { IDS_IRQ_DE, "IRQ" },
         { IDS_IRQ_FR, "IRQ" },
         { IDS_IRQ_HU, "IRQ" },
         { IDS_IRQ_IT, "IRQ" },
         { IDS_IRQ_NL, "IRQ" },
         { IDS_IRQ_PL, "IRQ" },
         { IDS_IRQ_SV, "IRQ" },
         { IDS_IRQ_TR, "IRQ" },

         { IDS_NMI,    N_("NMI") },
         { IDS_NMI_DA, "NMI" },
         { IDS_NMI_DE, "NMI" },
         { IDS_NMI_FR, "NMI" },
         { IDS_NMI_HU, "NMI" },
         { IDS_NMI_IT, "NMI" },
         { IDS_NMI_NL, "NMI" },
         { IDS_NMI_PL, "NMI" },
         { IDS_NMI_SV, "NMI" },
         { IDS_NMI_TR, "NMI" },

         { IDS_ACIA_DEVICE,    N_("ACIA device") },
         { IDS_ACIA_DEVICE_DA, "ACIA-enhed" },
         { IDS_ACIA_DEVICE_DE, "ACIA Gert" },
         { IDS_ACIA_DEVICE_FR, "Priphrique ACIA" },
         { IDS_ACIA_DEVICE_HU, "ACIA eszkz" },
         { IDS_ACIA_DEVICE_IT, "Dispositivo ACIA" },
         { IDS_ACIA_DEVICE_NL, "ACIA-apparaat" },
         { IDS_ACIA_DEVICE_PL, "" },             
         { IDS_ACIA_DEVICE_SV, "ACIA-enhet" },
         { IDS_ACIA_DEVICE_TR, "ACIA Aygt" },

         { IDS_ACIA_INTERRUPT,    N_("ACIA Interrupt") },
         { IDS_ACIA_INTERRUPT_DA, "ACIA-interrupt" },
         { IDS_ACIA_INTERRUPT_DE, "ACIA Interrupt" },
         { IDS_ACIA_INTERRUPT_FR, "Interruption ACIA" },
         { IDS_ACIA_INTERRUPT_HU, "ACIA megszakts" },
         { IDS_ACIA_INTERRUPT_IT, "Interrupt dell'ACIA" },
         { IDS_ACIA_INTERRUPT_NL, "ACIA-interrupt" },
         { IDS_ACIA_INTERRUPT_PL, "" },             
         { IDS_ACIA_INTERRUPT_SV, "ACIA-avbrott" },
         { IDS_ACIA_INTERRUPT_TR, "ACIA Kesmesi" },

         { IDS_ACIA_MODE,    N_("ACIA Mode") },
         { IDS_ACIA_MODE_DA, "ACIA-tilstand" },
         { IDS_ACIA_MODE_DE, "ACIA Modus" },
         { IDS_ACIA_MODE_FR, "" },             
         { IDS_ACIA_MODE_HU, "ACIA md" },
         { IDS_ACIA_MODE_IT, "Modalit ACIA" },
         { IDS_ACIA_MODE_NL, "ACIA-modus" },
         { IDS_ACIA_MODE_PL, "" },             
         { IDS_ACIA_MODE_SV, "ACIA lge" },
         { IDS_ACIA_MODE_TR, "ACIA Modu" },

         { IDS_ACIA_SETTINGS,    N_("ACIA Settings") },
         { IDS_ACIA_SETTINGS_DA, "ACIA-indstillinger" },
         { IDS_ACIA_SETTINGS_DE, "ACIA Einstellungen" },
         { IDS_ACIA_SETTINGS_FR, "Parametres ACIA" },
         { IDS_ACIA_SETTINGS_HU, "ACIA belltsai" },
         { IDS_ACIA_SETTINGS_IT, "Impostazioni ACIA" },
         { IDS_ACIA_SETTINGS_NL, "ACIA-instellingen" },
         { IDS_ACIA_SETTINGS_PL, "" },             
         { IDS_ACIA_SETTINGS_SV, "ACIA-instllningar" },
         { IDS_ACIA_SETTINGS_TR, "ACIA Ayarlar" },

         { IDS_256K_ENABLED,    N_("256K Enabled") },
         { IDS_256K_ENABLED_DA, "256K aktiveret" },
         { IDS_256K_ENABLED_DE, "256K aktiviert" },
         { IDS_256K_ENABLED_FR, "" },             
         { IDS_256K_ENABLED_HU, "256K engedlyezve" },
         { IDS_256K_ENABLED_IT, "256K attivi" },
         { IDS_256K_ENABLED_NL, "256K Aan/Uit" },
         { IDS_256K_ENABLED_PL, "" },             
         { IDS_256K_ENABLED_SV, "256K aktiverat" },
         { IDS_256K_ENABLED_TR, "256K Aktif" },

         { IDS_256K_BASE,    N_("256K Base") },
         { IDS_256K_BASE_DA, "256K-base" },
         { IDS_256K_BASE_DE, "256K Basis" },
         { IDS_256K_BASE_FR, "" },             
         { IDS_256K_BASE_HU, "256K bziscm" },
         { IDS_256K_BASE_IT, "Indirizzo base 256K" },
         { IDS_256K_BASE_NL, "256K basis adres" },
         { IDS_256K_BASE_PL, "" },             
         { IDS_256K_BASE_SV, "256K bas-adress" },
         { IDS_256K_BASE_TR, "256K Taban" },

         { IDS_256K_FILENAME,    N_("256K file") },
         { IDS_256K_FILENAME_DA, "256K-fil" },
         { IDS_256K_FILENAME_DE, "256K Datei" },
         { IDS_256K_FILENAME_FR, "Fichier 256K" },
         { IDS_256K_FILENAME_HU, "256K fjl" },
         { IDS_256K_FILENAME_IT, "File 256K" },
         { IDS_256K_FILENAME_NL, "256K-bestand" },
         { IDS_256K_FILENAME_PL, "" },             
         { IDS_256K_FILENAME_SV, "256K-fil" },
         { IDS_256K_FILENAME_TR, "256K dosyas" },

         { IDS_256K_FILENAME_SELECT,    N_("Select file for 256K") },
         { IDS_256K_FILENAME_SELECT_DA, "Angiv fil for 256K" },
         { IDS_256K_FILENAME_SELECT_DE, "Datei fr 256K auswhlen" },
         { IDS_256K_FILENAME_SELECT_FR, "Slectionner fichier pour 256K" },
         { IDS_256K_FILENAME_SELECT_HU, "Vlasszon fjlt a 256K-hoz" },
         { IDS_256K_FILENAME_SELECT_IT, "Seleziona il file per il 256K" },
         { IDS_256K_FILENAME_SELECT_NL, "Selecteer bestand voor 256K" },
         { IDS_256K_FILENAME_SELECT_PL, "" },             
         { IDS_256K_FILENAME_SELECT_SV, "Ange fil fr 256K" },
         { IDS_256K_FILENAME_SELECT_TR, "256K iin dosya sein" },

         { IDS_256K_SETTINGS,    N_("256K Settings") },
         { IDS_256K_SETTINGS_DA, "256K-indstillinger" },
         { IDS_256K_SETTINGS_DE, "256K Einstellungen" },
         { IDS_256K_SETTINGS_FR, "Paramtres 256K" },
         { IDS_256K_SETTINGS_HU, "256K belltsai" },
         { IDS_256K_SETTINGS_IT, "Impostazioni 256K" },
         { IDS_256K_SETTINGS_NL, "256K-instellingen" },
         { IDS_256K_SETTINGS_PL, "" },             
         { IDS_256K_SETTINGS_SV, "256K-instllningar" },
         { IDS_256K_SETTINGS_TR, "256K Ayarlar" },

         { IDS_C64DTV_ROM_FILENAME_SELECT,    N_("Select file for C64DTV ROM") },
         { IDS_C64DTV_ROM_FILENAME_SELECT_DA, "Vlg fil for C64DTV-ROM" },
         { IDS_C64DTV_ROM_FILENAME_SELECT_DE, "Datei fr C64DTV ROM auswhlen" },
         { IDS_C64DTV_ROM_FILENAME_SELECT_FR, "" },             
         { IDS_C64DTV_ROM_FILENAME_SELECT_HU, "Vlasszon fjlt a C64DTV ROM-hoz" },
         { IDS_C64DTV_ROM_FILENAME_SELECT_IT, "Seleziona il file per la ROM C64DTV" },
         { IDS_C64DTV_ROM_FILENAME_SELECT_NL, "Selecteer bestand voor C64DTV ROM" },
         { IDS_C64DTV_ROM_FILENAME_SELECT_PL, "" },             
         { IDS_C64DTV_ROM_FILENAME_SELECT_SV, "Vlj fil fr C64DTV-ROM" },
         { IDS_C64DTV_ROM_FILENAME_SELECT_TR, "C64DTV ROM'u iin dosya sein" },

         { IDS_C64DTV_ROM_FILENAME,    N_("C64DTV ROM file") },
         { IDS_C64DTV_ROM_FILENAME_DA, "C64DTV-ROM-fil" },
         { IDS_C64DTV_ROM_FILENAME_DE, "C64DTV ROM Datei" },
         { IDS_C64DTV_ROM_FILENAME_FR, "" },             
         { IDS_C64DTV_ROM_FILENAME_HU, "C64DTV ROM fjl" },
         { IDS_C64DTV_ROM_FILENAME_IT, "File ROM C64DTV" },
         { IDS_C64DTV_ROM_FILENAME_NL, "C64DTV ROM bestand" },
         { IDS_C64DTV_ROM_FILENAME_PL, "" },             
         { IDS_C64DTV_ROM_FILENAME_SV, "C64DTV-ROM-fil" },
         { IDS_C64DTV_ROM_FILENAME_TR, "C64DTV ROM dosyas" },

         { IDS_C64DTV_REVISION,    N_("C64DTV revision") },
         { IDS_C64DTV_REVISION_DA, "C64DTV-revision" },
         { IDS_C64DTV_REVISION_DE, "C64DTV Revision" },
         { IDS_C64DTV_REVISION_FR, "" },             
         { IDS_C64DTV_REVISION_HU, "C64DTV vltozat" },
         { IDS_C64DTV_REVISION_IT, "Revisione C64DTV" },
         { IDS_C64DTV_REVISION_NL, "C64DTV revisie" },
         { IDS_C64DTV_REVISION_PL, "" },             
         { IDS_C64DTV_REVISION_SV, "C64DTV-utgva" },
         { IDS_C64DTV_REVISION_TR, "C64DTV revizyonu" },

         { IDS_C64DTV_WRITE_ENABLE,    N_("Writes to C64DTV ROM") },
         { IDS_C64DTV_WRITE_ENABLE_DA, "Skrivning til C64DTV-ROM" },
         { IDS_C64DTV_WRITE_ENABLE_DE, "Schreibzugriff auf C64DTV ROM" },
         { IDS_C64DTV_WRITE_ENABLE_FR, "" },             
         { IDS_C64DTV_WRITE_ENABLE_HU, "C64DTV ROM-ba rsok" },
         { IDS_C64DTV_WRITE_ENABLE_IT, "Scrivi sulla ROM C64DTV" },
         { IDS_C64DTV_WRITE_ENABLE_NL, "Schrijven naar C64DTV ROM" },
         { IDS_C64DTV_WRITE_ENABLE_PL, "" },             
         { IDS_C64DTV_WRITE_ENABLE_SV, "Skrivningar till C64DTV-ROM" },
         { IDS_C64DTV_WRITE_ENABLE_TR, "C64DTV ROM'una yazar" },

         { IDS_C64DTV_HUMMER_ADC,    N_("Hummer ADC") },
         { IDS_C64DTV_HUMMER_ADC_DA, "" },             
         { IDS_C64DTV_HUMMER_ADC_DE, "Hummer ADC" },
         { IDS_C64DTV_HUMMER_ADC_FR, "" },             
         { IDS_C64DTV_HUMMER_ADC_HU, "" },             
         { IDS_C64DTV_HUMMER_ADC_IT, "Hummer ADC" },
         { IDS_C64DTV_HUMMER_ADC_NL, "Hummer ADC" },
         { IDS_C64DTV_HUMMER_ADC_PL, "" },             
         { IDS_C64DTV_HUMMER_ADC_SV, "Hummer A/D-omvandlare" },
         { IDS_C64DTV_HUMMER_ADC_TR, "Hummer ADC" },

         { IDS_C64DTV_SETTINGS,    N_("C64DTV Settings") },
         { IDS_C64DTV_SETTINGS_DA, "C64DTV-indstillinger" },
         { IDS_C64DTV_SETTINGS_DE, "C64DTV Einstellungen" },
         { IDS_C64DTV_SETTINGS_FR, "" },             
         { IDS_C64DTV_SETTINGS_HU, "C64DTV belltsai" },
         { IDS_C64DTV_SETTINGS_IT, "Impostazioni C64DTV" },
         { IDS_C64DTV_SETTINGS_NL, "C64DTV Instellingen" },
         { IDS_C64DTV_SETTINGS_PL, "" },             
         { IDS_C64DTV_SETTINGS_SV, "C64DTV-instllningar" },
         { IDS_C64DTV_SETTINGS_TR, "C64DTV Ayarlar" },

         { IDS_MODEL_LINE,    N_("model line") },
         { IDS_MODEL_LINE_DA, "modeltype" },
         { IDS_MODEL_LINE_DE, "modell linie" },
         { IDS_MODEL_LINE_FR, "ligne du modele" },
         { IDS_MODEL_LINE_HU, "modell sor" },
         { IDS_MODEL_LINE_IT, "impostazioni del modello" },
         { IDS_MODEL_LINE_NL, "modellijn" },
         { IDS_MODEL_LINE_PL, "" },             
         { IDS_MODEL_LINE_SV, "modelltyp" },
         { IDS_MODEL_LINE_TR, "model hatt" },

         { IDS_RAM_SIZE,    N_("RAM Size") },
         { IDS_RAM_SIZE_DA, "RAM-strrelse" },
         { IDS_RAM_SIZE_DE, "RAM Gre" },
         { IDS_RAM_SIZE_FR, "Taille du RAM" },
         { IDS_RAM_SIZE_HU, "RAM mrete" },
         { IDS_RAM_SIZE_IT, "Dimensione RAM" },
         { IDS_RAM_SIZE_NL, "RAM-grootte" },
         { IDS_RAM_SIZE_PL, "" },             
         { IDS_RAM_SIZE_SV, "RAM-storlek" },
         { IDS_RAM_SIZE_TR, "RAM Boyutu" },

         { IDS_RAM_BLOCK_0400_0FFF,    N_("RAM Block $0400-$0FFF") },
         { IDS_RAM_BLOCK_0400_0FFF_DA, "RAM-blok $0400-$0FFF" },
         { IDS_RAM_BLOCK_0400_0FFF_DE, "RAM in $0400-$0FFF" },
         { IDS_RAM_BLOCK_0400_0FFF_FR, "RAM dans $0400-$0FFF" },
         { IDS_RAM_BLOCK_0400_0FFF_HU, "Memria blokk $0400-$0FFF" },
         { IDS_RAM_BLOCK_0400_0FFF_IT, "Blocco RAM $0400-$0FFF" },
         { IDS_RAM_BLOCK_0400_0FFF_NL, "RAM-blok $0400-$0FFF" },
         { IDS_RAM_BLOCK_0400_0FFF_PL, "" },             
         { IDS_RAM_BLOCK_0400_0FFF_SV, "RAM pa $0400-$0FFF" },
         { IDS_RAM_BLOCK_0400_0FFF_TR, "RAM Blok $0400-$0FFF" },

         { IDS_RAM_BLOCK_0800_0FFF,    N_("RAM Block $0800-$0FFF") },
         { IDS_RAM_BLOCK_0800_0FFF_DA, "RAM-blok $0800-$0FFF" },
         { IDS_RAM_BLOCK_0800_0FFF_DE, "RAM in $0800-$0FFF" },
         { IDS_RAM_BLOCK_0800_0FFF_FR, "RAM dans $0800-$0FFF" },
         { IDS_RAM_BLOCK_0800_0FFF_HU, "Memria blokk $0800-$0FFF" },
         { IDS_RAM_BLOCK_0800_0FFF_IT, "Blocco RAM $0800-$0FFF" },
         { IDS_RAM_BLOCK_0800_0FFF_NL, "RAM-blok $0800-$0FFF" },
         { IDS_RAM_BLOCK_0800_0FFF_PL, "" },             
         { IDS_RAM_BLOCK_0800_0FFF_SV, "RAM pa $0800-$0FFF" },
         { IDS_RAM_BLOCK_0800_0FFF_TR, "RAM Blok $0800-$0FFF" },

         { IDS_RAM_BLOCK_1000_1FFF,    N_("RAM Block $1000-$1FFF") },
         { IDS_RAM_BLOCK_1000_1FFF_DA, "RAM-blok $1000-$1FFF" },
         { IDS_RAM_BLOCK_1000_1FFF_DE, "RAM in $1000-$1FFF" },
         { IDS_RAM_BLOCK_1000_1FFF_FR, "RAM dans $1000-$1FFF" },
         { IDS_RAM_BLOCK_1000_1FFF_HU, "Memria blokk $1000-$1FFF" },
         { IDS_RAM_BLOCK_1000_1FFF_IT, "Blocco RAM $1000-$1FFF" },
         { IDS_RAM_BLOCK_1000_1FFF_NL, "RAM-blok $1000-$1FFF" },
         { IDS_RAM_BLOCK_1000_1FFF_PL, "" },             
         { IDS_RAM_BLOCK_1000_1FFF_SV, "RAM pa $1000-$1FFF" },
         { IDS_RAM_BLOCK_1000_1FFF_TR, "RAM Blok $1000-$1FFF" },

         { IDS_RAM_BLOCK_2000_3FFF,    N_("RAM Block $2000-$3FFF") },
         { IDS_RAM_BLOCK_2000_3FFF_DA, "RAM-blok $2000-$3FFF" },
         { IDS_RAM_BLOCK_2000_3FFF_DE, "RAM in $2000-$3FFF" },
         { IDS_RAM_BLOCK_2000_3FFF_FR, "RAM dans $2000-$3FFF" },
         { IDS_RAM_BLOCK_2000_3FFF_HU, "Memria blokk $2000-$3FFF" },
         { IDS_RAM_BLOCK_2000_3FFF_IT, "Blocco RAM $2000-$3FFF" },
         { IDS_RAM_BLOCK_2000_3FFF_NL, "RAM-blok $2000-$3FFF" },
         { IDS_RAM_BLOCK_2000_3FFF_PL, "" },             
         { IDS_RAM_BLOCK_2000_3FFF_SV, "RAM pa $2000-$3FFF" },
         { IDS_RAM_BLOCK_2000_3FFF_TR, "RAM Blok $2000-$3FFF" },

         { IDS_RAM_BLOCK_4000_5FFF,    N_("RAM Block $4000-$5FFF") },
         { IDS_RAM_BLOCK_4000_5FFF_DA, "RAM-blok $4000-$5FFF" },
         { IDS_RAM_BLOCK_4000_5FFF_DE, "RAM in $4000-$5FFF" },
         { IDS_RAM_BLOCK_4000_5FFF_FR, "RAM dans $4000-$5FFF" },
         { IDS_RAM_BLOCK_4000_5FFF_HU, "Memria blokk $4000-$5FFF" },
         { IDS_RAM_BLOCK_4000_5FFF_IT, "Blocco RAM $4000-$5FFF" },
         { IDS_RAM_BLOCK_4000_5FFF_NL, "RAM-blok $4000-$5FFF" },
         { IDS_RAM_BLOCK_4000_5FFF_PL, "" },             
         { IDS_RAM_BLOCK_4000_5FFF_SV, "RAM pa $4000-$5FFF" },
         { IDS_RAM_BLOCK_4000_5FFF_TR, "RAM Blok $4000-$5FFF" },

         { IDS_RAM_BLOCK_6000_7FFF,    N_("RAM Block $6000-$7FFF") },
         { IDS_RAM_BLOCK_6000_7FFF_DA, "RAM-blok $6000-$7FFF" },
         { IDS_RAM_BLOCK_6000_7FFF_DE, "RAM in $6000-$7FFF" },
         { IDS_RAM_BLOCK_6000_7FFF_FR, "RAM dans $6000-$7FFF" },
         { IDS_RAM_BLOCK_6000_7FFF_HU, "Memria blokk $6000-$7FFF" },
         { IDS_RAM_BLOCK_6000_7FFF_IT, "Blocco RAM $6000-$7FFF" },
         { IDS_RAM_BLOCK_6000_7FFF_NL, "RAM-blok $6000-$7FFF" },
         { IDS_RAM_BLOCK_6000_7FFF_PL, "" },             
         { IDS_RAM_BLOCK_6000_7FFF_SV, "RAM pa $6000-$7FFF" },
         { IDS_RAM_BLOCK_6000_7FFF_TR, "RAM Blok $6000-$7FFF" },

         { IDS_RAM_BLOCK_A000_BFFF,    N_("RAM Block $A000-$BFFF") },
         { IDS_RAM_BLOCK_A000_BFFF_DA, "RAM-blok $A000-$BFFF" },
         { IDS_RAM_BLOCK_A000_BFFF_DE, "RAM in $A000-$BFFF" },
         { IDS_RAM_BLOCK_A000_BFFF_FR, "RAM dans $A000-$BFFF" },
         { IDS_RAM_BLOCK_A000_BFFF_HU, "Memria blokk $A000-$BFFF" },
         { IDS_RAM_BLOCK_A000_BFFF_IT, "Blocco RAM $A000-$BFFF" },
         { IDS_RAM_BLOCK_A000_BFFF_NL, "RAM-blok $A000-$BFFF" },
         { IDS_RAM_BLOCK_A000_BFFF_PL, "" },             
         { IDS_RAM_BLOCK_A000_BFFF_SV, "RAM pa $A000-$BFFF" },
         { IDS_RAM_BLOCK_A000_BFFF_TR, "RAM Blok $A000-$BFFF" },

         { IDS_RAM_BLOCK_C000_CFFF,    N_("RAM Block $C000-$CFFF") },
         { IDS_RAM_BLOCK_C000_CFFF_DA, "RAM-blok $C000-$CFFF" },
         { IDS_RAM_BLOCK_C000_CFFF_DE, "RAM in $C000-$CFFF" },
         { IDS_RAM_BLOCK_C000_CFFF_FR, "RAM dans $C000-$CFFF" },
         { IDS_RAM_BLOCK_C000_CFFF_HU, "Memria blokk $C000-$CFFF" },
         { IDS_RAM_BLOCK_C000_CFFF_IT, "Blocco RAM $C000-$CFFF" },
         { IDS_RAM_BLOCK_C000_CFFF_NL, "RAM-blok $C000-$CFFF" },
         { IDS_RAM_BLOCK_C000_CFFF_PL, "" },             
         { IDS_RAM_BLOCK_C000_CFFF_SV, "RAM pa $C000-$CFFF" },
         { IDS_RAM_BLOCK_C000_CFFF_TR, "RAM Blok $C000-$CFFF" },

         { IDS_CBM2_SETTINGS,    N_("CBM2 Settings") },
         { IDS_CBM2_SETTINGS_DA, "CBM2-indstillinger" },
         { IDS_CBM2_SETTINGS_DE, "CBM2 Einstellungen" },
         { IDS_CBM2_SETTINGS_FR, "Parametres CBM2" },
         { IDS_CBM2_SETTINGS_HU, "CBM2 Belltsai" },
         { IDS_CBM2_SETTINGS_IT, "Impostazioni CBM2" },
         { IDS_CBM2_SETTINGS_NL, "CBM2-instellingen" },
         { IDS_CBM2_SETTINGS_PL, "" },             
         { IDS_CBM2_SETTINGS_SV, "CBM2-instllningar" },
         { IDS_CBM2_SETTINGS_TR, "CBM2 Ayarlar" },

         { IDS_RESET_DATASETTE_WITH_CPU,    N_("Reset Datasette with CPU") },
         { IDS_RESET_DATASETTE_WITH_CPU_DA, "Reset Datasette ved CPU-reset" },
         { IDS_RESET_DATASETTE_WITH_CPU_DE, "Zurcksetzen des Bandlaufwerks bei CPU Reset" },
         { IDS_RESET_DATASETTE_WITH_CPU_FR, "Rinitialiser la datassette avec le CPU" },
         { IDS_RESET_DATASETTE_WITH_CPU_HU, "Alaphelyzetbe hozs CPU Reset esetn" },
         { IDS_RESET_DATASETTE_WITH_CPU_IT, "Reset del registratore al reset della CPU" },
         { IDS_RESET_DATASETTE_WITH_CPU_NL, "Reset Datasette met CPU" },
         { IDS_RESET_DATASETTE_WITH_CPU_PL, "" },             
         { IDS_RESET_DATASETTE_WITH_CPU_SV, "Nollstll Datasette med CPU" },
         { IDS_RESET_DATASETTE_WITH_CPU_TR, "CPU ile birlikte Teyp'i resetle" },

         { IDS_ADDITIONAL_DELAY,    N_("Additional Delay") },
         { IDS_ADDITIONAL_DELAY_DA, "Yderligere forsinkelse" },
         { IDS_ADDITIONAL_DELAY_DE, "Zustzliche Verzgerung" },
         { IDS_ADDITIONAL_DELAY_FR, "Dlai additionnel" },
         { IDS_ADDITIONAL_DELAY_HU, "Tbblet sznet" },
         { IDS_ADDITIONAL_DELAY_IT, "Ritardo aggiuntivo" },
         { IDS_ADDITIONAL_DELAY_NL, "Extra vertraging" },
         { IDS_ADDITIONAL_DELAY_PL, "" },             
         { IDS_ADDITIONAL_DELAY_SV, "Ytterligare frdrjning" },
         { IDS_ADDITIONAL_DELAY_TR, "Ekstra Bekletme" },

         { IDS_DELAY_AT_ZERO_VALUES,    N_("Delay at Zero Values") },
         { IDS_DELAY_AT_ZERO_VALUES_DA, "Forsinkelse ved nulvrdier" },
         { IDS_DELAY_AT_ZERO_VALUES_DE, "Verzgerung bei Zero-Werte" },
         { IDS_DELAY_AT_ZERO_VALUES_FR, "Dlai aux valeurs-zro" },
         { IDS_DELAY_AT_ZERO_VALUES_HU, "Sznet nulla rtkeknl" },
         { IDS_DELAY_AT_ZERO_VALUES_IT, "Ritardo ai valori di zero" },
         { IDS_DELAY_AT_ZERO_VALUES_NL, "Nul-waarden vertraging" },
         { IDS_DELAY_AT_ZERO_VALUES_PL, "" },             
         { IDS_DELAY_AT_ZERO_VALUES_SV, "Frdrjning vid &nollvrden" },
         { IDS_DELAY_AT_ZERO_VALUES_TR, "Zfr Deerlerinde Bekletme" },

         { IDS_DATASETTE_SETTINGS,    N_("Datasette Settings") },
         { IDS_DATASETTE_SETTINGS_DA, "Datasetteindstillinger" },
         { IDS_DATASETTE_SETTINGS_DE, "Datasette Einstellungen" },
         { IDS_DATASETTE_SETTINGS_FR, "Rglages datassette" },
         { IDS_DATASETTE_SETTINGS_HU, "Magn belltsai" },
         { IDS_DATASETTE_SETTINGS_IT, "Impostazioni registratore" },
         { IDS_DATASETTE_SETTINGS_NL, "Datasetteinstellingen" },
         { IDS_DATASETTE_SETTINGS_PL, "" },             
         { IDS_DATASETTE_SETTINGS_SV, "Datasetteinstllningar" },
         { IDS_DATASETTE_SETTINGS_TR, "Teyp Ayarlar" },

         { IDS_NEVER_EXTEND,    N_("Never extend") },
         { IDS_NEVER_EXTEND_DA, "Udvid aldrig" },
         { IDS_NEVER_EXTEND_DE, "Nie Erweitern" },
         { IDS_NEVER_EXTEND_FR, "Ne jamais &tendre" },
         { IDS_NEVER_EXTEND_HU, "Nincs kiterjeszts" },
         { IDS_NEVER_EXTEND_IT, "Non estendere mai" },
         { IDS_NEVER_EXTEND_NL, "Nooit uitbreiden" },
         { IDS_NEVER_EXTEND_PL, "" },             
         { IDS_NEVER_EXTEND_SV, "Utka aldrig" },
         { IDS_NEVER_EXTEND_TR, "Asla geniletme" },

         { IDS_ASK_ON_EXTEND,    N_("Ask on extend") },
         { IDS_ASK_ON_EXTEND_DA, "Sprg ved udviddelse" },
         { IDS_ASK_ON_EXTEND_DE, "Bei Erweiterung Rckfrage" },
         { IDS_ASK_ON_EXTEND_FR, "Demander avant d'tendre" },
         { IDS_ASK_ON_EXTEND_HU, "Krds kiterjeszts esetn" },
         { IDS_ASK_ON_EXTEND_IT, "Estendi su richiesta" },
         { IDS_ASK_ON_EXTEND_NL, "Vragen bij uitbreiden" },
         { IDS_ASK_ON_EXTEND_PL, "" },             
         { IDS_ASK_ON_EXTEND_SV, "Fraga vid utkning" },
         { IDS_ASK_ON_EXTEND_TR, "Geniletirken sor" },

         { IDS_EXTEND_ON_ACCESS,    N_("Extend on access") },
         { IDS_EXTEND_ON_ACCESS_DA, "Udvid ved tilgang" },
         { IDS_EXTEND_ON_ACCESS_DE, "Erweitern wenn ntig" },
         { IDS_EXTEND_ON_ACCESS_FR, "tendre   l'acces" },
         { IDS_EXTEND_ON_ACCESS_HU, "Kiterjeszts hozzfrskor" },
         { IDS_EXTEND_ON_ACCESS_IT, "All'accesso" },
         { IDS_EXTEND_ON_ACCESS_NL, "Uitbreiden bij toegang" },
         { IDS_EXTEND_ON_ACCESS_PL, "" },             
         { IDS_EXTEND_ON_ACCESS_SV, "Utka vid atkomst" },
         { IDS_EXTEND_ON_ACCESS_TR, "Eriildiinde genilet" },

         { IDS_NO_TRAPS,    N_("No traps") },
         { IDS_NO_TRAPS_DA, "Ingen traps" },
         { IDS_NO_TRAPS_DE, "Kein Traps" },
         { IDS_NO_TRAPS_FR, "No traps" },
         { IDS_NO_TRAPS_HU, "Folyamatos emulci" },
         { IDS_NO_TRAPS_IT, "Non rilevare" },
         { IDS_NO_TRAPS_NL, "Geen traps" },
         { IDS_NO_TRAPS_PL, "" },             
         { IDS_NO_TRAPS_SV, "Inga Traps" },
         { IDS_NO_TRAPS_TR, "Trap Yok" },

         { IDS_SKIP_CYCLES,    N_("Skip cycles") },
         { IDS_SKIP_CYCLES_DA, "Spring over cykler" },
         { IDS_SKIP_CYCLES_DE, "Zyklen verwerfen" },
         { IDS_SKIP_CYCLES_FR, "Sauter des cycles" },
         { IDS_SKIP_CYCLES_HU, "Ciklusok kihagysa" },
         { IDS_SKIP_CYCLES_IT, "Salta cicli" },
         { IDS_SKIP_CYCLES_NL, "Sla cycli over" },
         { IDS_SKIP_CYCLES_PL, "" },             
         { IDS_SKIP_CYCLES_SV, "Hoppa cykler" },
         { IDS_SKIP_CYCLES_TR, "Cyclelar atla" },

         { IDS_TRAP_IDLE,    N_("Trap idle") },
         { IDS_TRAP_IDLE_DA, "Fang inaktive" },
         { IDS_TRAP_IDLE_DE, "Trap idle" },
         { IDS_TRAP_IDLE_FR, "Traper linactivit" },
         { IDS_TRAP_IDLE_HU, "res ciklusok kihagysa" },
         { IDS_TRAP_IDLE_IT, "Rileva inattivit" },
         { IDS_TRAP_IDLE_NL, "Trap idle" },
         { IDS_TRAP_IDLE_PL, "" },             
         { IDS_TRAP_IDLE_SV, "Fnga inaktiva" },
         { IDS_TRAP_IDLE_TR, "Trap boa vakit geirme" },

         { IDS_DRIVE_TYPE,    N_("Drive type") },
         { IDS_DRIVE_TYPE_DA, "Drevtype" },
         { IDS_DRIVE_TYPE_DE, "Gerte Typ" },
         { IDS_DRIVE_TYPE_FR, "Type de lecteur" },
         { IDS_DRIVE_TYPE_HU, "Lemezegysg tpus" },
         { IDS_DRIVE_TYPE_IT, "Tipo di drive" },
         { IDS_DRIVE_TYPE_NL, "Drivesoort" },
         { IDS_DRIVE_TYPE_PL, "" },             
         { IDS_DRIVE_TYPE_SV, "Enhetstyp" },
         { IDS_DRIVE_TYPE_TR, "Src tipi" },

         { IDS_40_TRACK_HANDLING,    N_("40 track handling") },
         { IDS_40_TRACK_HANDLING_DA, "Hndtering af 40 spor" },
         { IDS_40_TRACK_HANDLING_DE, "40 Spur Umgang" },
         { IDS_40_TRACK_HANDLING_FR, "Prise en charge du 40 pistes" },
         { IDS_40_TRACK_HANDLING_HU, "40 sv kezelse" },
         { IDS_40_TRACK_HANDLING_IT, "Gestione 40 tracce" },
         { IDS_40_TRACK_HANDLING_NL, "40-sporenondersteuning" },
         { IDS_40_TRACK_HANDLING_PL, "" },             
         { IDS_40_TRACK_HANDLING_SV, "Hantering av 40 spar" },
         { IDS_40_TRACK_HANDLING_TR, "40 track ileme" },

         { IDS_DRIVE_EXPANSION,    N_("Drive expansion") },
         { IDS_DRIVE_EXPANSION_DA, "Drevudviddelse" },
         { IDS_DRIVE_EXPANSION_DE, "Laufwerk Erweiterung" },
         { IDS_DRIVE_EXPANSION_FR, "Expansion de lecteur" },
         { IDS_DRIVE_EXPANSION_HU, "Lemezegysg bvts" },
         { IDS_DRIVE_EXPANSION_IT, "Espasione del drive" },
         { IDS_DRIVE_EXPANSION_NL, "Drive uitbreiding" },
         { IDS_DRIVE_EXPANSION_PL, "" },             
         { IDS_DRIVE_EXPANSION_SV, "Enhetsutkning" },
         { IDS_DRIVE_EXPANSION_TR, "Src genilemesi" },

         { IDS_IDLE_METHOD,    N_("Idle method") },
         { IDS_IDLE_METHOD_DA, "Pausemetode" },
         { IDS_IDLE_METHOD_DE, "Idle Methode" },
         { IDS_IDLE_METHOD_FR, "Mthode d'idle" },
         { IDS_IDLE_METHOD_HU, "resjrat md" },
         { IDS_IDLE_METHOD_IT, "Rileva inattivit" },
         { IDS_IDLE_METHOD_NL, "Idlemethode" },
         { IDS_IDLE_METHOD_PL, "" },             
         { IDS_IDLE_METHOD_SV, "Pausmetod" },
         { IDS_IDLE_METHOD_TR, "Boa vakit geirme metodu" },

         { IDS_PARALLEL_CABLE,    N_("Parallel cable") },
         { IDS_PARALLEL_CABLE_DA, "Parallelkabel" },
         { IDS_PARALLEL_CABLE_DE, "Parallel Kabel" },
         { IDS_PARALLEL_CABLE_FR, "Cble parallele" },
         { IDS_PARALLEL_CABLE_HU, "Prhuzamos kbel" },
         { IDS_PARALLEL_CABLE_IT, "Cavo parallelo" },
         { IDS_PARALLEL_CABLE_NL, "Parallelle kabel" },
         { IDS_PARALLEL_CABLE_PL, "" },             
         { IDS_PARALLEL_CABLE_SV, "Parallellkabel" },
         { IDS_PARALLEL_CABLE_TR, "Paralel kablo" },

         { IDS_DRIVE_SETTINGS,    N_("Drive Settings") },
         { IDS_DRIVE_SETTINGS_DA, "Diskettedrevindstillinger" },
         { IDS_DRIVE_SETTINGS_DE, "Floppy Einstellungen" },
         { IDS_DRIVE_SETTINGS_FR, "Parametres des lecteurs" },
         { IDS_DRIVE_SETTINGS_HU, "Lemezegysg belltsai" },
         { IDS_DRIVE_SETTINGS_IT, "Impostazioni drive" },
         { IDS_DRIVE_SETTINGS_NL, "Drive-instellingen" },
         { IDS_DRIVE_SETTINGS_PL, "" },             
         { IDS_DRIVE_SETTINGS_SV, "Diskettenhetsinstllningar" },
         { IDS_DRIVE_SETTINGS_TR, "Src Ayarlar" },

         { IDS_GEORAM_SIZE,    N_("GEORAM Size") },
         { IDS_GEORAM_SIZE_DA, "GEORAM-strrelse" },
         { IDS_GEORAM_SIZE_DE, "GEORAM Gre" },
         { IDS_GEORAM_SIZE_FR, "Taille du GEORAM" },
         { IDS_GEORAM_SIZE_HU, "GEORAM mrete" },
         { IDS_GEORAM_SIZE_IT, "Dimensione GEORAM" },
         { IDS_GEORAM_SIZE_NL, "GEORAM-grootte" },
         { IDS_GEORAM_SIZE_PL, "" },             
         { IDS_GEORAM_SIZE_SV, "GEORAM-storlek" },
         { IDS_GEORAM_SIZE_TR, "GEORAM Boyutu" },

         { IDS_GEORAM_FILENAME,    N_("GEORAM file") },
         { IDS_GEORAM_FILENAME_DA, "GEORAM-fil" },
         { IDS_GEORAM_FILENAME_DE, "GEORAM Datei" },
         { IDS_GEORAM_FILENAME_FR, "Fichier GEORAM" },
         { IDS_GEORAM_FILENAME_HU, "GEORAM fjl" },
         { IDS_GEORAM_FILENAME_IT, "File GEORAM" },
         { IDS_GEORAM_FILENAME_NL, "GEORAM-bestand" },
         { IDS_GEORAM_FILENAME_PL, "" },             
         { IDS_GEORAM_FILENAME_SV, "GEORAM-fil" },
         { IDS_GEORAM_FILENAME_TR, "GEORAM dosyas" },

         { IDS_GEORAM_FILENAME_SELECT,    N_("Select file for GEORAM") },
         { IDS_GEORAM_FILENAME_SELECT_DA, "Vlg fil for GEORAM" },
         { IDS_GEORAM_FILENAME_SELECT_DE, "Datei fr GEORAM auswhlen" },
         { IDS_GEORAM_FILENAME_SELECT_FR, "Slectionner fichier pour GEORAM" },
         { IDS_GEORAM_FILENAME_SELECT_HU, "Vlasszon fjlt a GEORAM-hoz" },
         { IDS_GEORAM_FILENAME_SELECT_IT, "Seleziona il file per il GEORAM" },
         { IDS_GEORAM_FILENAME_SELECT_NL, "Selecteer bestand voor GEORAM" },
         { IDS_GEORAM_FILENAME_SELECT_PL, "" },             
         { IDS_GEORAM_FILENAME_SELECT_SV, "Vlj fil fr GEORAM" },
         { IDS_GEORAM_FILENAME_SELECT_TR, "GEORAM iin dosya sein" },

         { IDS_GEORAM_SETTINGS,    N_("GEORAM Settings") },
         { IDS_GEORAM_SETTINGS_DA, "GEORAM-indstillinger" },
         { IDS_GEORAM_SETTINGS_DE, "GEORAM Einstellungen" },
         { IDS_GEORAM_SETTINGS_FR, "Parametres GEORAM" },
         { IDS_GEORAM_SETTINGS_HU, "GEORAM belltsai" },
         { IDS_GEORAM_SETTINGS_IT, "Impostazioni GEORAM" },
         { IDS_GEORAM_SETTINGS_NL, "GEORAM-instellingen" },
         { IDS_GEORAM_SETTINGS_PL, "" },             
         { IDS_GEORAM_SETTINGS_SV, "GEORAM-instllningar" },
         { IDS_GEORAM_SETTINGS_TR, "GEORAM Ayarlar" },

         { IDS_DQBB_FILENAME,    N_("DQBB file") },
         { IDS_DQBB_FILENAME_DA, "DQBB-fil" },
         { IDS_DQBB_FILENAME_DE, "DQBB Datei" },
         { IDS_DQBB_FILENAME_FR, "" },             
         { IDS_DQBB_FILENAME_HU, "DQBB fjl" },
         { IDS_DQBB_FILENAME_IT, "File DQBB" },
         { IDS_DQBB_FILENAME_NL, "DQBB bestand" },
         { IDS_DQBB_FILENAME_PL, "" },             
         { IDS_DQBB_FILENAME_SV, "DQBB-fil" },
         { IDS_DQBB_FILENAME_TR, "DQBB dosyas" },

         { IDS_DQBB_FILENAME_SELECT,    N_("Select file for DQBB") },
         { IDS_DQBB_FILENAME_SELECT_DA, "Vlg fil for DQBB" },
         { IDS_DQBB_FILENAME_SELECT_DE, "Datei fr DQBB auswhlen" },
         { IDS_DQBB_FILENAME_SELECT_FR, "" },             
         { IDS_DQBB_FILENAME_SELECT_HU, "Vlasszon fjlt a DQBB-hez" },
         { IDS_DQBB_FILENAME_SELECT_IT, "Seleziona il file per DQBB" },
         { IDS_DQBB_FILENAME_SELECT_NL, "Selecteer bestand voor DQBB" },
         { IDS_DQBB_FILENAME_SELECT_PL, "" },             
         { IDS_DQBB_FILENAME_SELECT_SV, "Vlj fil fr DQBB" },
         { IDS_DQBB_FILENAME_SELECT_TR, "DQBB iin dosya se" },

         { IDS_DQBB_SETTINGS,    N_("DQBB Settings") },
         { IDS_DQBB_SETTINGS_DA, "DQBB-indstillinger" },
         { IDS_DQBB_SETTINGS_DE, "DQBB Einstellungen" },
         { IDS_DQBB_SETTINGS_FR, "" },             
         { IDS_DQBB_SETTINGS_HU, "DQBB belltsai" },
         { IDS_DQBB_SETTINGS_IT, "Impostazioni DQBB" },
         { IDS_DQBB_SETTINGS_NL, "DQBB instellingen" },
         { IDS_DQBB_SETTINGS_PL, "" },             
         { IDS_DQBB_SETTINGS_SV, "DQBB-instllningar" },
         { IDS_DQBB_SETTINGS_TR, "DQBB Ayarlar" },

         { IDS_ISEPIC_SETTINGS,    N_("Isepic Settings") },
         { IDS_ISEPIC_SETTINGS_DA, "Isepic-indstillinger" },
         { IDS_ISEPIC_SETTINGS_DE, "Isepic Einstellungen" },
         { IDS_ISEPIC_SETTINGS_FR, "" },             
         { IDS_ISEPIC_SETTINGS_HU, "Isepic belltsok" },
         { IDS_ISEPIC_SETTINGS_IT, "Impostazioni Isepic" },
         { IDS_ISEPIC_SETTINGS_NL, "Isepic instellingen" },
         { IDS_ISEPIC_SETTINGS_PL, "" },             
         { IDS_ISEPIC_SETTINGS_SV, "Isepic-instllningar" },
         { IDS_ISEPIC_SETTINGS_TR, "Isepic Ayarlar" },

         { IDS_ISEPIC_SWITCH,    N_("Isepic Switch") },
         { IDS_ISEPIC_SWITCH_DA, "Isepic-kontakt" },
         { IDS_ISEPIC_SWITCH_DE, "Isepic Schalter" },
         { IDS_ISEPIC_SWITCH_FR, "" },             
         { IDS_ISEPIC_SWITCH_HU, "Isepic kapcsol" },
         { IDS_ISEPIC_SWITCH_IT, "Interruttore Isepic" },
         { IDS_ISEPIC_SWITCH_NL, "Isepic schakelaar" },
         { IDS_ISEPIC_SWITCH_PL, "" },             
         { IDS_ISEPIC_SWITCH_SV, "Isepic-omkopplare" },
         { IDS_ISEPIC_SWITCH_TR, "Isepic Anahtar" },

         { IDS_EASYFLASH_SETTINGS,    N_("EasyFlash Settings") },
         { IDS_EASYFLASH_SETTINGS_DA, "" },             
         { IDS_EASYFLASH_SETTINGS_DE, "EasyFlash Einstellungen" },
         { IDS_EASYFLASH_SETTINGS_FR, "" },             
         { IDS_EASYFLASH_SETTINGS_HU, "" },             
         { IDS_EASYFLASH_SETTINGS_IT, "Impostazioni EasyFlash" },
         { IDS_EASYFLASH_SETTINGS_NL, "EasyFlash instellingen" },
         { IDS_EASYFLASH_SETTINGS_PL, "" },             
         { IDS_EASYFLASH_SETTINGS_SV, "EasyFlash-instllningar" },
         { IDS_EASYFLASH_SETTINGS_TR, "EasyFlash Ayarlar" },

         { IDS_CONFIG_FILENAME_SELECT,    N_("Select config file") },
         { IDS_CONFIG_FILENAME_SELECT_DA, "Vlg konfigurationsfil" },
         { IDS_CONFIG_FILENAME_SELECT_DE, "Konfigurationsdateiname definieren" },
         { IDS_CONFIG_FILENAME_SELECT_FR, "" },             
         { IDS_CONFIG_FILENAME_SELECT_HU, "Vlassza ki a konfigurcis fjlt" },
         { IDS_CONFIG_FILENAME_SELECT_IT, "Seleziona il file di configurazione" },
         { IDS_CONFIG_FILENAME_SELECT_NL, "Selecteer configuratie bestand" },
         { IDS_CONFIG_FILENAME_SELECT_PL, "" },             
         { IDS_CONFIG_FILENAME_SELECT_SV, "Ange instllningsfil" },
         { IDS_CONFIG_FILENAME_SELECT_TR, "Konfigrasyon dosyasn sein" },

         { IDS_JOYSTICK_IN_PORT_1,    N_("Joystick in port #1") },
         { IDS_JOYSTICK_IN_PORT_1_DA, "Joystick i port 1" },
         { IDS_JOYSTICK_IN_PORT_1_DE, "Joystick in Port #1" },
         { IDS_JOYSTICK_IN_PORT_1_FR, "Joystick dans le port #1" },
         { IDS_JOYSTICK_IN_PORT_1_HU, "Botkormny az 1-es porton" },
         { IDS_JOYSTICK_IN_PORT_1_IT, "Joystick nella porta #1" },
         { IDS_JOYSTICK_IN_PORT_1_NL, "Joystick in poort #1" },
         { IDS_JOYSTICK_IN_PORT_1_PL, "" },             
         { IDS_JOYSTICK_IN_PORT_1_SV, "Joystick i spelport 1" },
         { IDS_JOYSTICK_IN_PORT_1_TR, "Joystick port #1'de" },

         { IDS_JOYSTICK_IN_PORT_2,    N_("Joystick in port #2") },
         { IDS_JOYSTICK_IN_PORT_2_DA, "Joystick i port 2" },
         { IDS_JOYSTICK_IN_PORT_2_DE, "Joystick in Port #2" },
         { IDS_JOYSTICK_IN_PORT_2_FR, "Joystick dans le port #2" },
         { IDS_JOYSTICK_IN_PORT_2_HU, "Botkormny a 2-es porton" },
         { IDS_JOYSTICK_IN_PORT_2_IT, "Joystick nella porta #2" },
         { IDS_JOYSTICK_IN_PORT_2_NL, "Joystick in poort #2" },
         { IDS_JOYSTICK_IN_PORT_2_PL, "" },             
         { IDS_JOYSTICK_IN_PORT_2_SV, "Joystick i spelport 2" },
         { IDS_JOYSTICK_IN_PORT_2_TR, "Joystick port #2'de" },

         { IDS_USERPORT_ADAPTER,    N_("Userport joystick adapter") },
         { IDS_USERPORT_ADAPTER_DA, "" },             
         { IDS_USERPORT_ADAPTER_DE, "Userport Joystick Adapter" },
         { IDS_USERPORT_ADAPTER_FR, "" },             
         { IDS_USERPORT_ADAPTER_HU, "" },             
         { IDS_USERPORT_ADAPTER_IT, "Adattatore joystick su userport" },
         { IDS_USERPORT_ADAPTER_NL, "Userport joystick adapter" },
         { IDS_USERPORT_ADAPTER_PL, "" },             
         { IDS_USERPORT_ADAPTER_SV, "Adapter fr anvndarportstyrspakar" },
         { IDS_USERPORT_ADAPTER_TR, "Userport joystick dntrc" },

         { IDS_USERPORT_ADAPTER_TYPE,    N_("Userport joystick adapter type") },
         { IDS_USERPORT_ADAPTER_TYPE_DA, "" },             
         { IDS_USERPORT_ADAPTER_TYPE_DE, "Userport Joystick Adadptertype" },
         { IDS_USERPORT_ADAPTER_TYPE_FR, "" },             
         { IDS_USERPORT_ADAPTER_TYPE_HU, "" },             
         { IDS_USERPORT_ADAPTER_TYPE_IT, "Tipo adattatore joystick su userport" },
         { IDS_USERPORT_ADAPTER_TYPE_NL, "Userport joystick adapter model" },
         { IDS_USERPORT_ADAPTER_TYPE_PL, "" },             
         { IDS_USERPORT_ADAPTER_TYPE_SV, "Typ av adapter fr anvndarportstyrspakar" },
         { IDS_USERPORT_ADAPTER_TYPE_TR, "Userport joystick dntrc tipi" },

         { IDS_JOYSTICK_IN_USERPORT_PORT_1,    N_("Joystick in userport adapter port #1") },
         { IDS_JOYSTICK_IN_USERPORT_PORT_1_DA, "" },             
         { IDS_JOYSTICK_IN_USERPORT_PORT_1_DE, "Joystick in Userport Adapter Port #1" },
         { IDS_JOYSTICK_IN_USERPORT_PORT_1_FR, "" },             
         { IDS_JOYSTICK_IN_USERPORT_PORT_1_HU, "" },             
         { IDS_JOYSTICK_IN_USERPORT_PORT_1_IT, "Joystick su adattatore su userport porta #1" },
         { IDS_JOYSTICK_IN_USERPORT_PORT_1_NL, "Joystick in userport adapter poort #1" },
         { IDS_JOYSTICK_IN_USERPORT_PORT_1_PL, "" },             
         { IDS_JOYSTICK_IN_USERPORT_PORT_1_SV, "Styrspak i anvndarportsadapterport 1" },
         { IDS_JOYSTICK_IN_USERPORT_PORT_1_TR, "Joystick userport dntrc port #1'de" },

         { IDS_JOYSTICK_IN_USERPORT_PORT_2,    N_("Joystick in userport adapter port #2") },
         { IDS_JOYSTICK_IN_USERPORT_PORT_2_DA, "" },             
         { IDS_JOYSTICK_IN_USERPORT_PORT_2_DE, "Joystick in Userport Adapter Port #2" },
         { IDS_JOYSTICK_IN_USERPORT_PORT_2_FR, "" },             
         { IDS_JOYSTICK_IN_USERPORT_PORT_2_HU, "" },             
         { IDS_JOYSTICK_IN_USERPORT_PORT_2_IT, "Joystick su adattatore su userport porta #2" },
         { IDS_JOYSTICK_IN_USERPORT_PORT_2_NL, "Joystick in userport adapter poort #2" },
         { IDS_JOYSTICK_IN_USERPORT_PORT_2_PL, "" },             
         { IDS_JOYSTICK_IN_USERPORT_PORT_2_SV, "Styrspak i anvndarportsadapterport 1" },
         { IDS_JOYSTICK_IN_USERPORT_PORT_2_TR, "Joystick userport dntrc port #2'de" },

         { IDS_SIDCART_JOY,    N_("SIDcart joystick") },
         { IDS_SIDCART_JOY_DA, "" },             
         { IDS_SIDCART_JOY_DE, "SIDcart Joystick" },
         { IDS_SIDCART_JOY_FR, "" },             
         { IDS_SIDCART_JOY_HU, "" },             
         { IDS_SIDCART_JOY_IT, "Joystick SIDcart" },
         { IDS_SIDCART_JOY_NL, "SIDcart joystick" },
         { IDS_SIDCART_JOY_PL, "" },             
         { IDS_SIDCART_JOY_SV, "SIDcart-styrspak" },
         { IDS_SIDCART_JOY_TR, "SID kartuu joystick'i" },

         { IDS_JOYSTICK_IN_SIDCART_PORT,    N_("Joystick in SIDcart joystick port") },
         { IDS_JOYSTICK_IN_SIDCART_PORT_DA, "" },             
         { IDS_JOYSTICK_IN_SIDCART_PORT_DE, "Joystick in SIDcart Joystick Port" },
         { IDS_JOYSTICK_IN_SIDCART_PORT_FR, "" },             
         { IDS_JOYSTICK_IN_SIDCART_PORT_HU, "" },             
         { IDS_JOYSTICK_IN_SIDCART_PORT_IT, "Joystick nella porta joystick su SIDcart" },
         { IDS_JOYSTICK_IN_SIDCART_PORT_NL, "Joystick in SIDcart joystick poort" },
         { IDS_JOYSTICK_IN_SIDCART_PORT_PL, "" },             
         { IDS_JOYSTICK_IN_SIDCART_PORT_SV, "Styrspak i SIDcart-spelport" },
         { IDS_JOYSTICK_IN_SIDCART_PORT_TR, "Joystick SID kartuu joystick portuna takl" },

         { IDS_JOYSTICK_SETTINGS,    N_("Joystick Settings") },
         { IDS_JOYSTICK_SETTINGS_DA, "Joystickindstillinger" },
         { IDS_JOYSTICK_SETTINGS_DE, "Joystick Einstellungen" },
         { IDS_JOYSTICK_SETTINGS_FR, "Parametres des joysticks" },
         { IDS_JOYSTICK_SETTINGS_HU, "Botkormny belltsai" },
         { IDS_JOYSTICK_SETTINGS_IT, "Impostazioni joystick" },
         { IDS_JOYSTICK_SETTINGS_NL, "Joystickinstellingen" },
         { IDS_JOYSTICK_SETTINGS_PL, "" },             
         { IDS_JOYSTICK_SETTINGS_SV, "Instllningar fr joystick" },
         { IDS_JOYSTICK_SETTINGS_TR, "Joystick Ayarlar" },

         { IDS_KEYPAD,    N_("Numpad") },
         { IDS_KEYPAD_DA, "Numerisk tastatur" },
         { IDS_KEYPAD_DE, "Ziffernblock" },
         { IDS_KEYPAD_FR, "" },             
         { IDS_KEYPAD_HU, "Numerikus billentyk" },
         { IDS_KEYPAD_IT, "Tastierino numerico" },
         { IDS_KEYPAD_NL, "Numpad" },
         { IDS_KEYPAD_PL, "" },             
         { IDS_KEYPAD_SV, "Numreriskt tangentbord" },
         { IDS_KEYPAD_TR, "Numpad" },

         { IDS_JOY_PORT_0,    N_("Joy Port 0") },
         { IDS_JOY_PORT_0_DA, "Joystickport 0" },
         { IDS_JOY_PORT_0_DE, "Joystick Port 0" },
         { IDS_JOY_PORT_0_FR, "Port joystick 0" },
         { IDS_JOY_PORT_0_HU, "Botkormny port 0" },
         { IDS_JOY_PORT_0_IT, "Joy Porta 0" },
         { IDS_JOY_PORT_0_NL, "Joy Poort 0" },
         { IDS_JOY_PORT_0_PL, "" },             
         { IDS_JOY_PORT_0_SV, "Joy port 0" },
         { IDS_JOY_PORT_0_TR, "Joy Port 0" },

         { IDS_JOY_PORT_1,    N_("Joy Port 1") },
         { IDS_JOY_PORT_1_DA, "Joystickport 1" },
         { IDS_JOY_PORT_1_DE, "Joystick Port 1" },
         { IDS_JOY_PORT_1_FR, "Port joystick 1" },
         { IDS_JOY_PORT_1_HU, "Botkormny port 1" },
         { IDS_JOY_PORT_1_IT, "Joy Porta 1" },
         { IDS_JOY_PORT_1_NL, "Joy Poort 1" },
         { IDS_JOY_PORT_1_PL, "" },             
         { IDS_JOY_PORT_1_SV, "Joy Port 1" },
         { IDS_JOY_PORT_1_TR, "Joy Port 1" },

         { IDS_JOY_PORT_2,    N_("Joy Port 2") },
         { IDS_JOY_PORT_2_DA, "Joystickport 2" },
         { IDS_JOY_PORT_2_DE, "Joystick Port 2" },
         { IDS_JOY_PORT_2_FR, "Port joystick 2" },
         { IDS_JOY_PORT_2_HU, "Botkormny port 2" },
         { IDS_JOY_PORT_2_IT, "Joy Porta 2" },
         { IDS_JOY_PORT_2_NL, "Joy Poort 2" },
         { IDS_JOY_PORT_2_PL, "" },             
         { IDS_JOY_PORT_2_SV, "Joy Port 2" },
         { IDS_JOY_PORT_2_TR, "Joy Port 2" },

         { IDS_JOY_PORT_3,    N_("Joy Port 3") },
         { IDS_JOY_PORT_3_DA, "Joystickport 3" },
         { IDS_JOY_PORT_3_DE, "Joystick Port 3" },
         { IDS_JOY_PORT_3_FR, "Port joystick 3" },
         { IDS_JOY_PORT_3_HU, "Botkormny port 3" },
         { IDS_JOY_PORT_3_IT, "Joy Porta 3" },
         { IDS_JOY_PORT_3_NL, "Joy Poort 3" },
         { IDS_JOY_PORT_3_PL, "" },             
         { IDS_JOY_PORT_3_SV, "Joy Port 3" },
         { IDS_JOY_PORT_3_TR, "Joy Port 3" },

         { IDS_STOP_BLUE,    N_("Stop/Blue") },
         { IDS_STOP_BLUE_DA, "Stop/Bl" },
         { IDS_STOP_BLUE_DE, "Stop/Blau" },
         { IDS_STOP_BLUE_FR, "Arrt/Bleu" },
         { IDS_STOP_BLUE_HU, "Lellt/Kk" },
         { IDS_STOP_BLUE_IT, "Stop/Blu" },
         { IDS_STOP_BLUE_NL, "Stop/Blauw" },
         { IDS_STOP_BLUE_PL, "" },             
         { IDS_STOP_BLUE_SV, "Stop/Bl" },
         { IDS_STOP_BLUE_TR, "Durdur/Mavi" },

         { IDS_SELECT_RED,    N_("Select/Red") },
         { IDS_SELECT_RED_DA, "Vlg/Rd" },
         { IDS_SELECT_RED_DE, "Auswahl/Rot" },
         { IDS_SELECT_RED_FR, "Slectionner/Rouge" },
         { IDS_SELECT_RED_HU, "Kivlaszt/Piros" },
         { IDS_SELECT_RED_IT, "Seleziona/Rosso" },
         { IDS_SELECT_RED_NL, "Select/Rood" },
         { IDS_SELECT_RED_PL, "" },             
         { IDS_SELECT_RED_SV, "Select/Rd" },
         { IDS_SELECT_RED_TR, "Seim/Krmz" },

         { IDS_REPEAT_YELLOW,    N_("Repeat/Yellow") },
         { IDS_REPEAT_YELLOW_DA, "Gentag/Gul" },
         { IDS_REPEAT_YELLOW_DE, "Wiederhole/Gelb" },
         { IDS_REPEAT_YELLOW_FR, "Rpter/Jaune" },
         { IDS_REPEAT_YELLOW_HU, "Ismtel/Srga" },
         { IDS_REPEAT_YELLOW_IT, "Ripeti/Giallo" },
         { IDS_REPEAT_YELLOW_NL, "Repeat/Geel" },
         { IDS_REPEAT_YELLOW_PL, "" },             
         { IDS_REPEAT_YELLOW_SV, "Repeat/Gul" },
         { IDS_REPEAT_YELLOW_TR, "Tekrar/Sar" },

         { IDS_SHUFFLE_GREEN,    N_("Shuffle/Green") },
         { IDS_SHUFFLE_GREEN_DA, "Bland/Grn" },
         { IDS_SHUFFLE_GREEN_DE, "Mische/Grn" },
         { IDS_SHUFFLE_GREEN_FR, "Mlanger/Vert" },
         { IDS_SHUFFLE_GREEN_HU, "Vletlenszer/Zld" },
         { IDS_SHUFFLE_GREEN_IT, "Mischia/Verde" },
         { IDS_SHUFFLE_GREEN_NL, "Shuffle/Groen" },
         { IDS_SHUFFLE_GREEN_PL, "" },             
         { IDS_SHUFFLE_GREEN_SV, "Shuffle/Grn" },
         { IDS_SHUFFLE_GREEN_TR, "Kartr/Yeil" },

         { IDS_FORWARD_CHARCOAL,    N_("Forward/Charcoal") },
         { IDS_FORWARD_CHARCOAL_DA, "Fremad/Grafit" },
         { IDS_FORWARD_CHARCOAL_DE, "Vorwrts/Kohle" },
         { IDS_FORWARD_CHARCOAL_FR, "Avancer/Charcoal" },
         { IDS_FORWARD_CHARCOAL_HU, "Elre/Fekete" },
         { IDS_FORWARD_CHARCOAL_IT, "Avanti/Carboncino" },
         { IDS_FORWARD_CHARCOAL_NL, "Forward/Charcoal" },
         { IDS_FORWARD_CHARCOAL_PL, "" },             
         { IDS_FORWARD_CHARCOAL_SV, "Forward/Trkol" },
         { IDS_FORWARD_CHARCOAL_TR, "leri/Kmr" },

         { IDS_REVERSE_CHARCOAL,    N_("Reverse/Charcoal") },
         { IDS_REVERSE_CHARCOAL_DA, "Bagud/Grafit" },
         { IDS_REVERSE_CHARCOAL_DE, "Rckwrts/Kohle" },
         { IDS_REVERSE_CHARCOAL_FR, "Reculer/Charcoal" },
         { IDS_REVERSE_CHARCOAL_HU, "Vissza/Fekete" },
         { IDS_REVERSE_CHARCOAL_IT, "Indietro/Carboncino" },
         { IDS_REVERSE_CHARCOAL_NL, "Reverse/Charcoal" },
         { IDS_REVERSE_CHARCOAL_PL, "" },             
         { IDS_REVERSE_CHARCOAL_SV, "Reverse/Trkol" },
         { IDS_REVERSE_CHARCOAL_TR, "Ters/Kmr" },

         { IDS_PLAY_PAUSE_GREY,    N_("Play-Pause/Grey") },
         { IDS_PLAY_PAUSE_GREY_DA, "Play-Pause/Gr" },
         { IDS_PLAY_PAUSE_GREY_DE, "Play-Pause/Grau" },
         { IDS_PLAY_PAUSE_GREY_FR, "Play-Pause/Gris" },
         { IDS_PLAY_PAUSE_GREY_HU, "Lejtszs-Megllts/Szrke" },
         { IDS_PLAY_PAUSE_GREY_IT, "Avvia-Pausa/Grigio" },
         { IDS_PLAY_PAUSE_GREY_NL, "Play-Pause/Grijs" },
         { IDS_PLAY_PAUSE_GREY_PL, "" },             
         { IDS_PLAY_PAUSE_GREY_SV, "[Play/Pause]/Gr" },
         { IDS_PLAY_PAUSE_GREY_TR, "al-Duraklat/Gri" },

         { IDS_JOY_1_DEVICE,    N_("Joy 1 Device") },
         { IDS_JOY_1_DEVICE_DA, "Joystick 1 enhed" },
         { IDS_JOY_1_DEVICE_DE, "Joystick 1 Gert" },
         { IDS_JOY_1_DEVICE_FR, "Priphrique joystick 1" },
         { IDS_JOY_1_DEVICE_HU, "1-es botkormny eszkz" },
         { IDS_JOY_1_DEVICE_IT, "Dispositivo Joystick 1" },
         { IDS_JOY_1_DEVICE_NL, "Joy 1-apparaat" },
         { IDS_JOY_1_DEVICE_PL, "" },             
         { IDS_JOY_1_DEVICE_SV, "Joy 1-enhet" },
         { IDS_JOY_1_DEVICE_TR, "Joy 1 Aygt" },

         { IDS_JOY_2_DEVICE,    N_("Joy 2 Device") },
         { IDS_JOY_2_DEVICE_DA, "Joystick 2 enhed" },
         { IDS_JOY_2_DEVICE_DE, "Joystick 2 Gert" },
         { IDS_JOY_2_DEVICE_FR, "Priphrique joystick 2" },
         { IDS_JOY_2_DEVICE_HU, "2-es botkormny eszkz" },
         { IDS_JOY_2_DEVICE_IT, "Dispositivo Joystick 2" },
         { IDS_JOY_2_DEVICE_NL, "Joy 2-apparaat" },
         { IDS_JOY_2_DEVICE_PL, "" },             
         { IDS_JOY_2_DEVICE_SV, "Joy 2-enhet" },
         { IDS_JOY_2_DEVICE_TR, "Joy 2 Aygt" },

         { IDS_USERPORT_JOY_1_DEVICE,    N_("Userport Joy 1 Device") },
         { IDS_USERPORT_JOY_1_DEVICE_DA, "" },             
         { IDS_USERPORT_JOY_1_DEVICE_DE, "Userport Joystick 1 Gert" },
         { IDS_USERPORT_JOY_1_DEVICE_FR, "" },             
         { IDS_USERPORT_JOY_1_DEVICE_HU, "" },             
         { IDS_USERPORT_JOY_1_DEVICE_IT, "Dispositivo joystick 1 su userport" },
         { IDS_USERPORT_JOY_1_DEVICE_NL, "Userport Joy 1-apparaat" },
         { IDS_USERPORT_JOY_1_DEVICE_PL, "" },             
         { IDS_USERPORT_JOY_1_DEVICE_SV, "Anvndarportspak 1 enhet" },
         { IDS_USERPORT_JOY_1_DEVICE_TR, "Userport Joy 1 Aygt" },

         { IDS_USERPORT_JOY_2_DEVICE,    N_("Userport Joy 2 Device") },
         { IDS_USERPORT_JOY_2_DEVICE_DA, "" },             
         { IDS_USERPORT_JOY_2_DEVICE_DE, "Userport Joystick 2 Gert" },
         { IDS_USERPORT_JOY_2_DEVICE_FR, "" },             
         { IDS_USERPORT_JOY_2_DEVICE_HU, "" },             
         { IDS_USERPORT_JOY_2_DEVICE_IT, "Dispositivo joystick 2 su userport" },
         { IDS_USERPORT_JOY_2_DEVICE_NL, "Userport Joy 2-apparaat" },
         { IDS_USERPORT_JOY_2_DEVICE_PL, "" },             
         { IDS_USERPORT_JOY_2_DEVICE_SV, "Anvndarportspak 2 enhet" },
         { IDS_USERPORT_JOY_2_DEVICE_TR, "Userport Joy 2 Aygt" },

         { IDS_SIDCART_JOY_DEVICE,    N_("SIDcart Joy Device") },
         { IDS_SIDCART_JOY_DEVICE_DA, "" },             
         { IDS_SIDCART_JOY_DEVICE_DE, "SIDcart Joystick Gert" },
         { IDS_SIDCART_JOY_DEVICE_FR, "" },             
         { IDS_SIDCART_JOY_DEVICE_HU, "" },             
         { IDS_SIDCART_JOY_DEVICE_IT, "Dispositivo Joystick SIDcart" },
         { IDS_SIDCART_JOY_DEVICE_NL, "SIDcart Joy apparaat" },
         { IDS_SIDCART_JOY_DEVICE_PL, "" },             
         { IDS_SIDCART_JOY_DEVICE_SV, "SIDcart-spakenhet" },
         { IDS_SIDCART_JOY_DEVICE_TR, "SID Kartuu Joy Aygt" },

         { IDS_JOY_1_FIRE,    N_("Joy 1 Fire") },
         { IDS_JOY_1_FIRE_DA, "Joystick 1 skydeknap" },
         { IDS_JOY_1_FIRE_DE, "Joystick 1 Feuer" },
         { IDS_JOY_1_FIRE_FR, "Jeu joystick 1" },
         { IDS_JOY_1_FIRE_HU, "1-es botkormny tz" },
         { IDS_JOY_1_FIRE_IT, "Fuoco Joystick 1" },
         { IDS_JOY_1_FIRE_NL, "Joy 1 Vuur" },
         { IDS_JOY_1_FIRE_PL, "" },             
         { IDS_JOY_1_FIRE_SV, "Joy 1 Fire" },
         { IDS_JOY_1_FIRE_TR, "Joy 1 Ate" },

         { IDS_JOY_2_FIRE,    N_("Joy 2 Fire") },
         { IDS_JOY_2_FIRE_DA, "Joystick 2 skydeknap" },
         { IDS_JOY_2_FIRE_DE, "Joystick 2 Feuer" },
         { IDS_JOY_2_FIRE_FR, "Jeu joystick 2" },
         { IDS_JOY_2_FIRE_HU, "2-es botkormny tz" },
         { IDS_JOY_2_FIRE_IT, "Fuoco Joystick 2" },
         { IDS_JOY_2_FIRE_NL, "Joy 2 Vuur" },
         { IDS_JOY_2_FIRE_PL, "" },             
         { IDS_JOY_2_FIRE_SV, "Joy 2 Fire" },
         { IDS_JOY_2_FIRE_TR, "Joy 2 Ate" },

         { IDS_USERPORT_JOY_1_FIRE,    N_("Userport Joy 1 Fire") },
         { IDS_USERPORT_JOY_1_FIRE_DA, "" },             
         { IDS_USERPORT_JOY_1_FIRE_DE, "Userport Joystick 1 Feuer" },
         { IDS_USERPORT_JOY_1_FIRE_FR, "" },             
         { IDS_USERPORT_JOY_1_FIRE_HU, "" },             
         { IDS_USERPORT_JOY_1_FIRE_IT, "Fuoco joystick 1 su userport" },
         { IDS_USERPORT_JOY_1_FIRE_NL, "Userport Joy 1 Vuur" },
         { IDS_USERPORT_JOY_1_FIRE_PL, "" },             
         { IDS_USERPORT_JOY_1_FIRE_SV, "Anvndarportspak 1 fire" },
         { IDS_USERPORT_JOY_1_FIRE_TR, "Userport Joy 1 Ate" },

         { IDS_USERPORT_JOY_2_FIRE,    N_("Userport Joy 2 Fire") },
         { IDS_USERPORT_JOY_2_FIRE_DA, "" },             
         { IDS_USERPORT_JOY_2_FIRE_DE, "Userport Joystick 1 Feuer" },
         { IDS_USERPORT_JOY_2_FIRE_FR, "" },             
         { IDS_USERPORT_JOY_2_FIRE_HU, "" },             
         { IDS_USERPORT_JOY_2_FIRE_IT, "Fuoco joystick 1 su userport" },
         { IDS_USERPORT_JOY_2_FIRE_NL, "Userport Joy 2 Vuur" },
         { IDS_USERPORT_JOY_2_FIRE_PL, "" },             
         { IDS_USERPORT_JOY_2_FIRE_SV, "Anvndarportspak 2 fire" },
         { IDS_USERPORT_JOY_2_FIRE_TR, "Userport Joy 2 Ate" },

         { IDS_SIDCART_JOY_FIRE,    N_("SIDcart Joy Fire") },
         { IDS_SIDCART_JOY_FIRE_DA, "" },             
         { IDS_SIDCART_JOY_FIRE_DE, "SIDcart Joystick Feuer" },
         { IDS_SIDCART_JOY_FIRE_FR, "" },             
         { IDS_SIDCART_JOY_FIRE_HU, "" },             
         { IDS_SIDCART_JOY_FIRE_IT, "Fuoco joystick su SIDcart" },
         { IDS_SIDCART_JOY_FIRE_NL, "SIDcart Joy Vuur" },
         { IDS_SIDCART_JOY_FIRE_PL, "" },             
         { IDS_SIDCART_JOY_FIRE_SV, "SIDcart-spak fire" },
         { IDS_SIDCART_JOY_FIRE_TR, "SID kartuu Joy Ate" },

         { IDS_SET_INPUT_JOYSTICK_1,    N_("Joystick #1 emulation: (0:None, 1: Numpad, 2: Keyset A/AI, 3: Keyset B/AI)") },
         { IDS_SET_INPUT_JOYSTICK_1_DA, "Emulering af Joystick 1: (0: ingen, 1: numerisk, 2: tastest A/AI, 3: tastest "
                                       "B/AI)" },
         { IDS_SET_INPUT_JOYSTICK_1_DE, "Joystick #1 Emulation: (0:Keine, 1: Numpad, 2: Keysatz A/AI, 3: Keysatz B/AI)" },
         { IDS_SET_INPUT_JOYSTICK_1_FR, "mulation Joystick #1: (0:Aucun, 1: Numpad, 2: Keyset A/AI, 3: Keyset B/AI)" },
         { IDS_SET_INPUT_JOYSTICK_1_HU, "#1-es botkormny emulci: (0: Nincs, 1: numerikus, 2: 'A' gombkszlet, 3: 'B' "
                                       "gombkszlet)" },
         { IDS_SET_INPUT_JOYSTICK_1_IT, "Emulazione joystick #1: (0: Nessuna, 1: Tastierino numerico, 2: Keyset A/AI, 3: "
                                        "Keyset B/AI)" },
         { IDS_SET_INPUT_JOYSTICK_1_NL, "Emulatie joystick #1: (0: Geen, 1: Numpad, 2: Keyset A/AI, 3: Keyset B/AI)" },
         { IDS_SET_INPUT_JOYSTICK_1_PL, "" },             
         { IDS_SET_INPUT_JOYSTICK_1_SV, "Joystick #1 emulation: (0:Ingen, 1: Numeriskt tangentbord, 2: Teckenuppsttning "
                                       "A/AI, 3: Teckenuppsttning B/AI)" },
         { IDS_SET_INPUT_JOYSTICK_1_TR, "Joystick #1 emlasyonu: (0:Yok, 1: Numpad, 2: Tu Seti A/AI, 3: Tu Seti B/AI)" },

         { IDS_SET_INPUT_JOYSTICK_2,    N_("Joystick #2 emulation: (0: None, 1: Numpad, 2: Keyset A/AI, 3: Keyset B/AI)") },
         { IDS_SET_INPUT_JOYSTICK_2_DA, "Emulering af Joystick 2: (0: ingen, 1: numerisk, 2: tastest A/AI, 3: tastest "
                                       "B/AI)" },
         { IDS_SET_INPUT_JOYSTICK_2_DE, "Joystick #2 Emulation: (0:Keine, 1: Numpad, 2: Keysatz A/AI, 3: Keysatz B/AI)" },
         { IDS_SET_INPUT_JOYSTICK_2_FR, "mulation Joystick #2: (0:Aucun, 1: Numpad, 2: Keyset A/AI, 3: Keyset B/AI)" },
         { IDS_SET_INPUT_JOYSTICK_2_HU, "#2-es botkormny emulci: (0: Nincs, 1: numerikus, 2: 'A' gombkszlet, 3: 'B' "
                                        "gombkszlet)" },
         { IDS_SET_INPUT_JOYSTICK_2_IT, "Emulazione joystick #2: (0: Nessuna, 1: Tastierino numerico, 2: Keyset A/AI, 3: "
                                        "Keyset B/AI)" },
         { IDS_SET_INPUT_JOYSTICK_2_NL, "Emulatie joystick #2: (0: Geen, 1: Numpad, 2: Keyset A/AI, 3: Keyset B/AI)" },
         { IDS_SET_INPUT_JOYSTICK_2_PL, "" },             
         { IDS_SET_INPUT_JOYSTICK_2_SV, "Joystick #2 emulation: (0:Ingen, 1: Numeriskt tangentbord, 2: Teckenuppsttning "
                                        "A/AI, 3: Teckenuppsttning B/AI)" },
         { IDS_SET_INPUT_JOYSTICK_2_TR, "Joystick #2 emlasyonu: (0:Yok, 1: Numpad, 2: Tu Seti A/AI, 3: Tu Seti B/AI)" },

         { IDS_SET_INPUT_EXTRA_JOYSTICK_1,    N_("Extra joystick #1 emulation: (0:None, 1: Numpad, 2: Keyset A/AI, 3: Keyset B/AI)") },
         { IDS_SET_INPUT_EXTRA_JOYSTICK_1_DA, "" },             
         { IDS_SET_INPUT_EXTRA_JOYSTICK_1_DE, "Extra Joystick #1 Emulation: (0: Keine, 1: Numpad, 2: Keysatz A/AI, 3: "
                                              "Keysatz B/AI)" },
         { IDS_SET_INPUT_EXTRA_JOYSTICK_1_FR, "" },             
         { IDS_SET_INPUT_EXTRA_JOYSTICK_1_HU, "" },             
         { IDS_SET_INPUT_EXTRA_JOYSTICK_1_IT, "Emulazione joystick supplementare #1: (0: Nessuna, 1: Tastierino numerico, "
                                              "2: Keyset A/AI, 3: Keyset B/AI)" },
         { IDS_SET_INPUT_EXTRA_JOYSTICK_1_NL, "Emulatie extra joystick #1: (0: Geen, 1: Numpad, 2: Keyset A/AI, 3: Keyset "
                                              "B/AI)" },
         { IDS_SET_INPUT_EXTRA_JOYSTICK_1_PL, "" },             
         { IDS_SET_INPUT_EXTRA_JOYSTICK_1_SV, "Emulering fr extra styrspak 1: (0: ingen, 1: numerisk, 2: "
                                              "tangentuppsttning A/AI, 3: tangentuppsttning B/AI)" },
         { IDS_SET_INPUT_EXTRA_JOYSTICK_1_TR, "Ekstra joystick #1 emlasyonu: (0:Yok, 1: Numpad, 2: Tu Seti A/AI, 3: "
                                              "Tu Seti B/AI)" },

         { IDS_SET_INPUT_EXTRA_JOYSTICK_2,    N_("Extra joystick #2 emulation: (0: None, 1: Numpad, 2: Keyset A/AI, 3: Keyset B/AI)") },
         { IDS_SET_INPUT_EXTRA_JOYSTICK_2_DA, "" },             
         { IDS_SET_INPUT_EXTRA_JOYSTICK_2_DE, "Extra Joystick #2 Emulation: (0: Keine, 1: Numpad, 2: Keysatz A/AI, 3: "
                                              "Keysatz B/AI)" },
         { IDS_SET_INPUT_EXTRA_JOYSTICK_2_FR, "" },             
         { IDS_SET_INPUT_EXTRA_JOYSTICK_2_HU, "" },             
         { IDS_SET_INPUT_EXTRA_JOYSTICK_2_IT, "Emulazione joystick supplementare #2: (0: Nessuna, 1: Tastierino numerico, "
                                              "2: Keyset A/AI, 3: Keyset B/AI)" },
         { IDS_SET_INPUT_EXTRA_JOYSTICK_2_NL, "Emulatie extra joystick #2: (0: Geen, 1: Numpad, 2: Keyset A/AI, 3: Keyset "
                                              "B/AI)" },
         { IDS_SET_INPUT_EXTRA_JOYSTICK_2_PL, "" },             
         { IDS_SET_INPUT_EXTRA_JOYSTICK_2_SV, "Emulering fr extra styrspak 1: (0: ingen, 1: numerisk, 2: "
                                              "tangentuppsttning A/AI, 3: tangentuppsttning B/AI)" },
         { IDS_SET_INPUT_EXTRA_JOYSTICK_2_TR, "Ekstra joystick #2 emlasyonu: (0:Yok, 1: Numpad, 2: Tu Seti A/AI, 3: Tu "
                                              "Seti B/AI)" },

         { IDS_SET_INPUT_JOYLL_1,    N_("Joystick #1 emulation: (0: None, 1: Numpad, 2-5: Amiga Joy 0-3)") },
         { IDS_SET_INPUT_JOYLL_1_DA, "Joystick 1 emularing: (0: ingen, 1: numerisk, 2-5: Amigajoystick 0-3)" },
         { IDS_SET_INPUT_JOYLL_1_DE, "Joystick #1 Emulation: (0: Keine, 1: Numpad, 2-5: Amiga Joystick 0-3)" },
         { IDS_SET_INPUT_JOYLL_1_FR, "" },             
         { IDS_SET_INPUT_JOYLL_1_HU, "#1-es botkormny emulci: (0: nincs, 1: numerikus billentyk, 2-5: amiga "
                                     "botkormny 0-3)" },
         { IDS_SET_INPUT_JOYLL_1_IT, "Emulazione joystick #1: (0: Nessuna, 1: Tastierino numerico, 2-5: Joy Amiga 0-3)" },
         { IDS_SET_INPUT_JOYLL_1_NL, "Emulatie joystick #1: (0: Geen, 1: Numpad, 2-5: Amiga Joy 0-3)" },
         { IDS_SET_INPUT_JOYLL_1_PL, "" },             
         { IDS_SET_INPUT_JOYLL_1_SV, "Joystick #1 emulation: (0:Ingen, 1: Numeriskt tangentbord, 2-5: Amiga Joy 0-3)" },
         { IDS_SET_INPUT_JOYLL_1_TR, "Joystick #1 emlasyonu: (0: Yok, 1: Numpad, 2-5: Amiga Joy 0-3)" },

         { IDS_SET_INPUT_JOYLL_2,    N_("Joystick #2 emulation: (0: None, 1: Numpad, 2-5: Amiga Joy 0-3)") },
         { IDS_SET_INPUT_JOYLL_2_DA, "Joystick 2 emularing: (0: ingen, 1: numerisk, 2-5: Amigajoystick 0-3)" },
         { IDS_SET_INPUT_JOYLL_2_DE, "Joystick #2 Emulation: (0: Keine, 1: Numpad, 2-5: Amiga Joystick 0-3)" },
         { IDS_SET_INPUT_JOYLL_2_FR, "" },             
         { IDS_SET_INPUT_JOYLL_2_HU, "#2-es botkormny emulci: (0: nincs, 1: numerikus billentyk, 2-5: amiga "
                                     "botkormny 0-3)" },
         { IDS_SET_INPUT_JOYLL_2_IT, "Emulazione joystick #2: (0: Nessuna, 1: Tastierino numerico, 2-5: Joy Amiga 0-3)" },
         { IDS_SET_INPUT_JOYLL_2_NL, "Emulatie Joystick #2: (0: Geen, 1: Numpad, 2-5: Amiga Joy 0-3)" },
         { IDS_SET_INPUT_JOYLL_2_PL, "" },             
         { IDS_SET_INPUT_JOYLL_2_SV, "Joystick #2 emulation: (0:Ingen, 1: Numeriskt tangentbord, 2-5: Amiga Joy 0-3)" },
         { IDS_SET_INPUT_JOYLL_2_TR, "Joystick #2 emlasyonu: (0: Yok, 1: Numpad, 2-5: Amiga Joy 0-3)" },

         { IDS_SET_INPUT_EXTRA_JOYLL_1,    N_("Extra joystick #1 emulation: (0: None, 1: Numpad, 2-5: Amiga Joy 0-3)") },
         { IDS_SET_INPUT_EXTRA_JOYLL_1_DA, "" },             
         { IDS_SET_INPUT_EXTRA_JOYLL_1_DE, "Extra Joystick #1 Emulation: (0: Keine, 1: Numpad, 2-5: Amiga Joystick 0-3)" },
         { IDS_SET_INPUT_EXTRA_JOYLL_1_FR, "" },             
         { IDS_SET_INPUT_EXTRA_JOYLL_1_HU, "" },             
         { IDS_SET_INPUT_EXTRA_JOYLL_1_IT, "Emulazione joystick supplementare #1: (0: Nessuna, 1: Tastierino numerico, "
                                           "2-5: Joy Amiga 0-3)" },
         { IDS_SET_INPUT_EXTRA_JOYLL_1_NL, "Emulatie extra joystick #1: (0: Geen, 1: Numpad, 2-5: Amiga Joy 0-3)" },
         { IDS_SET_INPUT_EXTRA_JOYLL_1_PL, "" },             
         { IDS_SET_INPUT_EXTRA_JOYLL_1_SV, "Emulering fr extra styrspak 1: (0: ingen, 1: numerisk, 2-5: Amigastyrspak "
                                           "0-3)" },
         { IDS_SET_INPUT_EXTRA_JOYLL_1_TR, "Ekstra joystick #1 emlasyonu: (0: Yok, 1: Numpad, 2-5: Amiga Joy 0-3)" },

         { IDS_SET_INPUT_EXTRA_JOYLL_2,    N_("Extra joystick #2 emulation: (0: None, 1: Numpad, 2-5: Amiga Joy 0-3)") },
         { IDS_SET_INPUT_EXTRA_JOYLL_2_DA, "" },             
         { IDS_SET_INPUT_EXTRA_JOYLL_2_DE, "Extra Joystick #2 Emulation: (0: Keine, 1: Numpad, 2-5: Amiga Joystick 0-3)" },
         { IDS_SET_INPUT_EXTRA_JOYLL_2_FR, "" },             
         { IDS_SET_INPUT_EXTRA_JOYLL_2_HU, "" },             
         { IDS_SET_INPUT_EXTRA_JOYLL_2_IT, "Emulazione joystick supplementare #2: (0: Nessuna, 1: Tastierino numerico, "
                                           "2-5: Joy Amiga 0-3)" },
         { IDS_SET_INPUT_EXTRA_JOYLL_2_NL, "Emulatie extra joystick #2: (0: Geen, 1: Numpad, 2-5: Amiga Joy 0-3)" },
         { IDS_SET_INPUT_EXTRA_JOYLL_2_PL, "" },             
         { IDS_SET_INPUT_EXTRA_JOYLL_2_SV, "Emulering fr extra styrspak 2: (0: ingen, 1: numerisk, 2-5: Amigastyrspak "
                                           "0-3)" },
         { IDS_SET_INPUT_EXTRA_JOYLL_2_TR, "Ekstra joystick #2 emlasyonu: (0: Yok, 1: Numpad, 2-5: Amiga Joy 0-3)" },

         { IDS_SAVE_SETTINGS_ON_EXIT,    N_("Save settings (resources) on exit") },
         { IDS_SAVE_SETTINGS_ON_EXIT_DA, "Gem indstillinger nr programmet afsluttes" },
         { IDS_SAVE_SETTINGS_ON_EXIT_DE, "Einstellungen (Ressourcen) beim Beenden speichern" },
         { IDS_SAVE_SETTINGS_ON_EXIT_FR, "Sauvegarder les parametres   la sortie" },
         { IDS_SAVE_SETTINGS_ON_EXIT_HU, "Belltsok (erforrsok) mentse kilpskor" },
         { IDS_SAVE_SETTINGS_ON_EXIT_IT, "Salva le impostazioni in uscita" },
         { IDS_SAVE_SETTINGS_ON_EXIT_NL, "Instellingen (resources) opslaan bij afsluiten" },
         { IDS_SAVE_SETTINGS_ON_EXIT_PL, "" },             
         { IDS_SAVE_SETTINGS_ON_EXIT_SV, "Spara instllningar (resurser) vid avslut" },
         { IDS_SAVE_SETTINGS_ON_EXIT_TR, "kta ayarlar (kaynaklar) kaydet" },

         { IDS_NEVER_SAVE_SETTINGS_EXIT,    N_("Never save settings (resources) on exit") },
         { IDS_NEVER_SAVE_SETTINGS_EXIT_DA, "Gem aldrig indstillinger nr programmet afsluttes" },
         { IDS_NEVER_SAVE_SETTINGS_EXIT_DE, "Einstellungen beim Beenden nie speichern" },
         { IDS_NEVER_SAVE_SETTINGS_EXIT_FR, "Ne jamais enregistrer les parametres   la sortie" },
         { IDS_NEVER_SAVE_SETTINGS_EXIT_HU, "Sose mentse a belltsokat (erforrsokat) kilpskor" },
         { IDS_NEVER_SAVE_SETTINGS_EXIT_IT, "Non salvare mai le impostazioni in uscita" },
         { IDS_NEVER_SAVE_SETTINGS_EXIT_NL, "Instellingen (resources) niet opslaan bij afsluiten" },
         { IDS_NEVER_SAVE_SETTINGS_EXIT_PL, "" },             
         { IDS_NEVER_SAVE_SETTINGS_EXIT_SV, "Spara aldrig instllningar (resurser) vid avslut" },
         { IDS_NEVER_SAVE_SETTINGS_EXIT_TR, "kta asla ayarlar (kaynaklar) kaydetme" },

         { IDS_CONFIRM_QUITING_VICE,    N_("Confirm quiting VICE") },
         { IDS_CONFIRM_QUITING_VICE_DA, "Bekrft programafslutning" },
         { IDS_CONFIRM_QUITING_VICE_DE, "Besttige beenden von VICE" },
         { IDS_CONFIRM_QUITING_VICE_FR, "Demander une confirmation avant de quitter VICE" },
         { IDS_CONFIRM_QUITING_VICE_HU, "Megersts kilps eltt" },
         { IDS_CONFIRM_QUITING_VICE_IT, "Conferma l'uscita da VICE" },
         { IDS_CONFIRM_QUITING_VICE_NL, "Bevestigen van het aflsuiten van VICE" },
         { IDS_CONFIRM_QUITING_VICE_PL, "" },             
         { IDS_CONFIRM_QUITING_VICE_SV, "Bekrfta fr att avsluta VICE" },
         { IDS_CONFIRM_QUITING_VICE_TR, "VICE'dan karken teyit et" },

         { IDS_NEVER_CONFIRM_QUITING_VICE,    N_("Never confirm quiting VICE") },
         { IDS_NEVER_CONFIRM_QUITING_VICE_DA, "Bekrft ikke programafslutning" },
         { IDS_NEVER_CONFIRM_QUITING_VICE_DE, "Keine Besttigung beim Beenden von VICE" },
         { IDS_NEVER_CONFIRM_QUITING_VICE_FR, "Ne pas demander de confirmation pour quitter VICE" },
         { IDS_NEVER_CONFIRM_QUITING_VICE_HU, "Sosem kr megerstst kilps eltt" },
         { IDS_NEVER_CONFIRM_QUITING_VICE_IT, "Non confermare mai l'uscita da VICE" },
         { IDS_NEVER_CONFIRM_QUITING_VICE_NL, "Niet bevestigen van het afsluiten van VICE" },
         { IDS_NEVER_CONFIRM_QUITING_VICE_PL, "" },             
         { IDS_NEVER_CONFIRM_QUITING_VICE_SV, "Bekrfta inte fr att avsluta VICE" },
         { IDS_NEVER_CONFIRM_QUITING_VICE_TR, "VICE'dan karken asla teyit etme" },

         { IDS_PET_REU_SIZE,    N_("PET REU size") },
         { IDS_PET_REU_SIZE_DA, "PET REU-strrelse" },
         { IDS_PET_REU_SIZE_DE, "PET REU Gre" },
         { IDS_PET_REU_SIZE_FR, "Taille du PET REU" },
         { IDS_PET_REU_SIZE_HU, "PET REU mrete" },
         { IDS_PET_REU_SIZE_IT, "Dimensione PET REU" },
         { IDS_PET_REU_SIZE_NL, "PET REU-grootte" },
         { IDS_PET_REU_SIZE_PL, "" },             
         { IDS_PET_REU_SIZE_SV, "PET REU-storlek" },
         { IDS_PET_REU_SIZE_TR, "PET REU Boyutu" },

         { IDS_PET_REU_FILENAME,    N_("PET REU file") },
         { IDS_PET_REU_FILENAME_DA, "PET REU-fil" },
         { IDS_PET_REU_FILENAME_DE, "PET REU Datei" },
         { IDS_PET_REU_FILENAME_FR, "Fichier PET REU" },
         { IDS_PET_REU_FILENAME_HU, "PET REU fjl" },
         { IDS_PET_REU_FILENAME_IT, "File PET REU" },
         { IDS_PET_REU_FILENAME_NL, "PET REU-bestand" },
         { IDS_PET_REU_FILENAME_PL, "" },             
         { IDS_PET_REU_FILENAME_SV, "PET REU-fil" },
         { IDS_PET_REU_FILENAME_TR, "PET REU dosyas" },

         { IDS_PET_REU_FILENAME_SELECT,    N_("Select file for PET REU") },
         { IDS_PET_REU_FILENAME_SELECT_DA, "Vlg fil for PET REU" },
         { IDS_PET_REU_FILENAME_SELECT_DE, "Datei fr PET REU auswhlen" },
         { IDS_PET_REU_FILENAME_SELECT_FR, "Slectionner fichier pour PET REU" },
         { IDS_PET_REU_FILENAME_SELECT_HU, "Vlasszon fjlt a PET REU-hoz" },
         { IDS_PET_REU_FILENAME_SELECT_IT, "Seleziona il file per il PET REU" },
         { IDS_PET_REU_FILENAME_SELECT_NL, "Selecteer bestand voor PET REU" },
         { IDS_PET_REU_FILENAME_SELECT_PL, "" },             
         { IDS_PET_REU_FILENAME_SELECT_SV, "Vlj fil fr PET REU" },
         { IDS_PET_REU_FILENAME_SELECT_TR, "PET REU iin dosya sein" },

         { IDS_PET_REU_SETTINGS,    N_("PET REU Settings") },
         { IDS_PET_REU_SETTINGS_DA, "PET REU-indstillinger" },
         { IDS_PET_REU_SETTINGS_DE, "PET REU Einstellungen" },
         { IDS_PET_REU_SETTINGS_FR, "" },             
         { IDS_PET_REU_SETTINGS_HU, "PET REU belltsai" },
         { IDS_PET_REU_SETTINGS_IT, "Impostazioni PET REU" },
         { IDS_PET_REU_SETTINGS_NL, "PET REU-instellingen" },
         { IDS_PET_REU_SETTINGS_PL, "" },             
         { IDS_PET_REU_SETTINGS_SV, "PET REU-Instllningar" },
         { IDS_PET_REU_SETTINGS_TR, "PET REU Ayarlar" },

         { IDS_PLUS256K_SETTINGS,    N_("PLUS256K Settings") },
         { IDS_PLUS256K_SETTINGS_DA, "PLUS256K-indstillinger" },
         { IDS_PLUS256K_SETTINGS_DE, "PLUS256K Einstellungen" },
         { IDS_PLUS256K_SETTINGS_FR, "Paramtres PLUS256K" },
         { IDS_PLUS256K_SETTINGS_HU, "PLUS256K belltsai" },
         { IDS_PLUS256K_SETTINGS_IT, "Impostazioni PLUS256K" },
         { IDS_PLUS256K_SETTINGS_NL, "PLUS256K-instellingen" },
         { IDS_PLUS256K_SETTINGS_PL, "" },             
         { IDS_PLUS256K_SETTINGS_SV, "PLUS256K-instllningar" },
         { IDS_PLUS256K_SETTINGS_TR, "PLUS256K Ayarlar" },

         { IDS_PLUS60K_BASE,    N_("PLUS60K Base") },
         { IDS_PLUS60K_BASE_DA, "Baseadresse for PLUS60K" },
         { IDS_PLUS60K_BASE_DE, "PLUS60K Basis Adresse" },
         { IDS_PLUS60K_BASE_FR, "Base PLUS60K" },
         { IDS_PLUS60K_BASE_HU, "PLUS60K bziscme" },
         { IDS_PLUS60K_BASE_IT, "Indirizzo base PLUS60K" },
         { IDS_PLUS60K_BASE_NL, "PLUS60K-basisadres" },
         { IDS_PLUS60K_BASE_PL, "" },             
         { IDS_PLUS60K_BASE_SV, "PLUS60K bas-adress" },
         { IDS_PLUS60K_BASE_TR, "PLUS60K Taban" },

         { IDS_PLUS60K_FILENAME,    N_("PLUS60K file") },
         { IDS_PLUS60K_FILENAME_DA, "PLUS60K-fil" },
         { IDS_PLUS60K_FILENAME_DE, "PLUS60K Datei" },
         { IDS_PLUS60K_FILENAME_FR, "Fichier PLUS60K" },
         { IDS_PLUS60K_FILENAME_HU, "PLUS60K fjl" },
         { IDS_PLUS60K_FILENAME_IT, "File PLUS60K" },
         { IDS_PLUS60K_FILENAME_NL, "PLUS60K-bestand" },
         { IDS_PLUS60K_FILENAME_PL, "" },             
         { IDS_PLUS60K_FILENAME_SV, "PLUS60K-fil" },
         { IDS_PLUS60K_FILENAME_TR, "PLUS60K dosyas" },

         { IDS_PLUS60K_FILENAME_SELECT,    N_("Select file for PLUS60K") },
         { IDS_PLUS60K_FILENAME_SELECT_DA, "Vlg fil for PLUS60K" },
         { IDS_PLUS60K_FILENAME_SELECT_DE, "Datei fr PLUS60K auswhlen" },
         { IDS_PLUS60K_FILENAME_SELECT_FR, "Slectionner fichier pour PLUS60K" },
         { IDS_PLUS60K_FILENAME_SELECT_HU, "Vlasszon fjlt a PLUS60K-hoz" },
         { IDS_PLUS60K_FILENAME_SELECT_IT, "Seleziona file per PLUS60K" },
         { IDS_PLUS60K_FILENAME_SELECT_NL, "Selecteer bestand voor PLUS60K" },
         { IDS_PLUS60K_FILENAME_SELECT_PL, "" },             
         { IDS_PLUS60K_FILENAME_SELECT_SV, "Ange fil fr PLUS60K" },
         { IDS_PLUS60K_FILENAME_SELECT_TR, "PLUS60K iin dosya sein" },

         { IDS_PLUS60K_SETTINGS,    N_("PLUS60K Settings") },
         { IDS_PLUS60K_SETTINGS_DA, "PLUS60K-indstillinger" },
         { IDS_PLUS60K_SETTINGS_DE, "PLUS60K Einstellungen" },
         { IDS_PLUS60K_SETTINGS_FR, "Paramtres PLUS60K" },
         { IDS_PLUS60K_SETTINGS_HU, "PLUS60K belltsai" },
         { IDS_PLUS60K_SETTINGS_IT, "Impostazioni PLUS60K" },
         { IDS_PLUS60K_SETTINGS_NL, "PLUS60K-instellingen" },
         { IDS_PLUS60K_SETTINGS_PL, "" },             
         { IDS_PLUS60K_SETTINGS_SV, "PLUS60K-instllningar" },
         { IDS_PLUS60K_SETTINGS_TR, "PLUS60K Ayarlar" },

         { IDS_VALUE_FIRST_BYTE,    N_("Value of first byte") },
         { IDS_VALUE_FIRST_BYTE_DA, "Vrdi p frste byte" },
         { IDS_VALUE_FIRST_BYTE_DE, "Wert erstes Byte" },
         { IDS_VALUE_FIRST_BYTE_FR, "Valeur du premier octet" },
         { IDS_VALUE_FIRST_BYTE_HU, "Els bjt rtke" },
         { IDS_VALUE_FIRST_BYTE_IT, "Valore del primo byte" },
         { IDS_VALUE_FIRST_BYTE_NL, "Waarde van eerste byte" },
         { IDS_VALUE_FIRST_BYTE_PL, "" },             
         { IDS_VALUE_FIRST_BYTE_SV, "Vrde pa frsta byte" },
         { IDS_VALUE_FIRST_BYTE_TR, "lk byte deeri" },

         { IDS_LENGTH_CONSTANT_VALUES,    N_("Length of constant values") },
         { IDS_LENGTH_CONSTANT_VALUES_DA, "Lngde af konstant vrdi" },
         { IDS_LENGTH_CONSTANT_VALUES_DE, "Lnge der konstaten Werte" },
         { IDS_LENGTH_CONSTANT_VALUES_FR, "Longeur des valeurs constantes" },
         { IDS_LENGTH_CONSTANT_VALUES_HU, "lland rtkek hossza" },
         { IDS_LENGTH_CONSTANT_VALUES_IT, "Numero di valori costanti" },
         { IDS_LENGTH_CONSTANT_VALUES_NL, "Lengte van constante waarden" },
         { IDS_LENGTH_CONSTANT_VALUES_PL, "" },             
         { IDS_LENGTH_CONSTANT_VALUES_SV, "Lngd pa konstanta vrden" },
         { IDS_LENGTH_CONSTANT_VALUES_TR, "Sabit deerlerin uzunluu" },

         { IDS_LENGTH_CONSTANT_PATTERN,    N_("Length of constant pattern") },
         { IDS_LENGTH_CONSTANT_PATTERN_DA, "Lngde af konstant mnster" },
         { IDS_LENGTH_CONSTANT_PATTERN_DE, "Lnge des konstanten Musters" },
         { IDS_LENGTH_CONSTANT_PATTERN_FR, "Longeur des contantes pattern" },
         { IDS_LENGTH_CONSTANT_PATTERN_HU, "lland minta hossza" },
         { IDS_LENGTH_CONSTANT_PATTERN_IT, "Dimensione del pattern costante" },
         { IDS_LENGTH_CONSTANT_PATTERN_NL, "Lengte van constant patroon" },
         { IDS_LENGTH_CONSTANT_PATTERN_PL, "" },             
         { IDS_LENGTH_CONSTANT_PATTERN_SV, "Lngd pa konstant mnster" },
         { IDS_LENGTH_CONSTANT_PATTERN_TR, "Sabit desenlerin uzunluu" },

         { IDS_RAM_SETTINGS,    N_("RAM Settings") },
         { IDS_RAM_SETTINGS_DA, "RAM-indstillinger" },
         { IDS_RAM_SETTINGS_DE, "RAM Einstellungen" },
         { IDS_RAM_SETTINGS_FR, "Parametres de la RAM" },
         { IDS_RAM_SETTINGS_HU, "RAM belltsai" },
         { IDS_RAM_SETTINGS_IT, "Impostazioni RAM" },
         { IDS_RAM_SETTINGS_NL, "RAM-instellingen" },
         { IDS_RAM_SETTINGS_PL, "" },             
         { IDS_RAM_SETTINGS_SV, "RAM-instllningar" },
         { IDS_RAM_SETTINGS_TR, "RAM ayarlar" },

         { IDS_READ_WRITE,    N_("read/write") },
         { IDS_READ_WRITE_DA, "skrivbar" },
         { IDS_READ_WRITE_DE, "lese/schreibe" },
         { IDS_READ_WRITE_FR, "lecture/criture" },
         { IDS_READ_WRITE_HU, "rhat/olvashat" },
         { IDS_READ_WRITE_IT, "lettura/scrittura" },
         { IDS_READ_WRITE_NL, "lezen/schrijven" },
         { IDS_READ_WRITE_PL, "" },             
         { IDS_READ_WRITE_SV, "ls/skriv" },
         { IDS_READ_WRITE_TR, "oku/yaz" },

         { IDS_READ_ONLY,    N_("read-only") },
         { IDS_READ_ONLY_DA, "skrivebeskyttet" },
         { IDS_READ_ONLY_DE, "Schreibgschutz" },
         { IDS_READ_ONLY_FR, "lecture seule" },
         { IDS_READ_ONLY_HU, "csak olvashat" },
         { IDS_READ_ONLY_IT, "a sola lettura" },
         { IDS_READ_ONLY_NL, "alleen lezen" },
         { IDS_READ_ONLY_PL, "" },             
         { IDS_READ_ONLY_SV, "Endast lsatkomst" },
         { IDS_READ_ONLY_TR, "salt-okunur" },

         { IDS_RAMCART_READ_WRITE,    N_("RAMCART Read/Write") },
         { IDS_RAMCART_READ_WRITE_DA, "RAMCART ls/skriv" },
         { IDS_RAMCART_READ_WRITE_DE, "RAMCART Lesen/Schreiben" },
         { IDS_RAMCART_READ_WRITE_FR, "Lecture/criture RAMCART" },
         { IDS_RAMCART_READ_WRITE_HU, "RAMCART rhat/olvashat" },
         { IDS_RAMCART_READ_WRITE_IT, "Lettura/Scrittura RAMCART" },
         { IDS_RAMCART_READ_WRITE_NL, "RAMCART Lezen/Schrijven" },
         { IDS_RAMCART_READ_WRITE_PL, "" },             
         { IDS_RAMCART_READ_WRITE_SV, "RAMCART ls/skriv" },
         { IDS_RAMCART_READ_WRITE_TR, "RAMCART Oku/Yaz" },

         { IDS_RAMCART_SIZE,    N_("RAMCART Size") },
         { IDS_RAMCART_SIZE_DA, "RAMCART strrelse" },
         { IDS_RAMCART_SIZE_DE, "RAMCART Gre" },
         { IDS_RAMCART_SIZE_FR, "Taille du RAMCART" },
         { IDS_RAMCART_SIZE_HU, "RAMCART mrete" },
         { IDS_RAMCART_SIZE_IT, "Dimensione RAMCART" },
         { IDS_RAMCART_SIZE_NL, "RAMCART-grootte" },
         { IDS_RAMCART_SIZE_PL, "" },             
         { IDS_RAMCART_SIZE_SV, "Storlek pa RAMCART" },
         { IDS_RAMCART_SIZE_TR, "RAMCART Boyutu" },

         { IDS_RAMCART_FILENAME,    N_("RAMCART file") },
         { IDS_RAMCART_FILENAME_DA, "RAMCART-fil" },
         { IDS_RAMCART_FILENAME_DE, "RAMCART Datei" },
         { IDS_RAMCART_FILENAME_FR, "Fichier RAMCART" },
         { IDS_RAMCART_FILENAME_HU, "RAMCART fjl" },
         { IDS_RAMCART_FILENAME_IT, "File RAMCART" },
         { IDS_RAMCART_FILENAME_NL, "RAMCART-bestand" },
         { IDS_RAMCART_FILENAME_PL, "" },             
         { IDS_RAMCART_FILENAME_SV, "RAMCART-fil" },
         { IDS_RAMCART_FILENAME_TR, "RAMCART dosyas" },

         { IDS_RAMCART_FILENAME_SELECT,    N_("Select file for RAMCART") },
         { IDS_RAMCART_FILENAME_SELECT_DA, "Vlg fil for RAMCART" },
         { IDS_RAMCART_FILENAME_SELECT_DE, "Datei fr RAMCART auswhlen" },
         { IDS_RAMCART_FILENAME_SELECT_FR, "Slectionner fichier pour RAMCART" },
         { IDS_RAMCART_FILENAME_SELECT_HU, "Vlasszon fjlt a RAMCART-hoz" },
         { IDS_RAMCART_FILENAME_SELECT_IT, "Seleziona il file per il RAMCART" },
         { IDS_RAMCART_FILENAME_SELECT_NL, "Selecteer bestand voor RAMCART" },
         { IDS_RAMCART_FILENAME_SELECT_PL, "" },             
         { IDS_RAMCART_FILENAME_SELECT_SV, "Vlj fil fr RAMCART" },
         { IDS_RAMCART_FILENAME_SELECT_TR, "RAMCART iin dosya sein" },

         { IDS_RAMCART_SETTINGS,    N_("RAMCART Settings") },
         { IDS_RAMCART_SETTINGS_DA, "RAMCART-indstillinger" },
         { IDS_RAMCART_SETTINGS_DE, "RAMCART Einstellungen" },
         { IDS_RAMCART_SETTINGS_FR, "Parametres RAMCART" },
         { IDS_RAMCART_SETTINGS_HU, "RAMCART belltsai" },
         { IDS_RAMCART_SETTINGS_IT, "Impostazioni RAMCART" },
         { IDS_RAMCART_SETTINGS_NL, "RAMCART-instellingen" },
         { IDS_RAMCART_SETTINGS_PL, "" },             
         { IDS_RAMCART_SETTINGS_SV, "RAMCART-instllningar" },
         { IDS_RAMCART_SETTINGS_TR, "RAMCART Ayarlar" },

         { IDS_REU_SIZE,    N_("REU Size") },
         { IDS_REU_SIZE_DA, "REU-strrelse" },
         { IDS_REU_SIZE_DE, "REU Gre" },
         { IDS_REU_SIZE_FR, "Taille du REU" },
         { IDS_REU_SIZE_HU, "REU mrete" },
         { IDS_REU_SIZE_IT, "Dimensione REU" },
         { IDS_REU_SIZE_NL, "REU-grootte" },
         { IDS_REU_SIZE_PL, "" },             
         { IDS_REU_SIZE_SV, "Storlek pa minnesexpansion" },
         { IDS_REU_SIZE_TR, "REU Boyutu" },

         { IDS_REU_FILENAME,    N_("REU file") },
         { IDS_REU_FILENAME_DA, "REU-fil" },
         { IDS_REU_FILENAME_DE, "REU Datei" },
         { IDS_REU_FILENAME_FR, "Fichier REU" },
         { IDS_REU_FILENAME_HU, "REU fjl" },
         { IDS_REU_FILENAME_IT, "File REU" },
         { IDS_REU_FILENAME_NL, "REU-bestand" },
         { IDS_REU_FILENAME_PL, "" },             
         { IDS_REU_FILENAME_SV, "REU-fil" },
         { IDS_REU_FILENAME_TR, "REU dosyas" },

         { IDS_REU_FILENAME_SELECT,    N_("Select file for REU") },
         { IDS_REU_FILENAME_SELECT_DA, "Vlg fil for REU" },
         { IDS_REU_FILENAME_SELECT_DE, "Datei fr REU auswhlen" },
         { IDS_REU_FILENAME_SELECT_FR, "Slectionner fichier pour REU" },
         { IDS_REU_FILENAME_SELECT_HU, "Vlasszon fjlt a REU-hoz" },
         { IDS_REU_FILENAME_SELECT_IT, "Seleziona il file per il REU" },
         { IDS_REU_FILENAME_SELECT_NL, "Selecteer bestand voor REU" },
         { IDS_REU_FILENAME_SELECT_PL, "" },             
         { IDS_REU_FILENAME_SELECT_SV, "Vlj fil fr REU" },
         { IDS_REU_FILENAME_SELECT_TR, "REU iin dosya sein" },

         { IDS_REU_SETTINGS,    N_("REU Settings") },
         { IDS_REU_SETTINGS_DA, "REU-indstillinger" },
         { IDS_REU_SETTINGS_DE, "REU Einstellungen" },
         { IDS_REU_SETTINGS_FR, "Parametres REU" },
         { IDS_REU_SETTINGS_HU, "REU belltsai" },
         { IDS_REU_SETTINGS_IT, "Impostazioni REU" },
         { IDS_REU_SETTINGS_NL, "REU-instellingen" },
         { IDS_REU_SETTINGS_PL, "" },             
         { IDS_REU_SETTINGS_SV, "REU-Instllningar" },
         { IDS_REU_SETTINGS_TR, "REU Ayarlar" },

         { IDS_USERPORT_RS232,    N_("Userport RS232") },
         { IDS_USERPORT_RS232_DA, "Brugerport RS232" },
         { IDS_USERPORT_RS232_DE, "Userport RS232" },
         { IDS_USERPORT_RS232_FR, "Port utilisateur RS232" },
         { IDS_USERPORT_RS232_HU, "Userport RS232" },
         { IDS_USERPORT_RS232_IT, "Userport RS232" },
         { IDS_USERPORT_RS232_NL, "Userport RS232" },
         { IDS_USERPORT_RS232_PL, "" },             
         { IDS_USERPORT_RS232_SV, "Anvndarport-RS232" },
         { IDS_USERPORT_RS232_TR, "Userport RS232" },

         { IDS_USERPORT_DEVICE,    N_("Userport RS232 Device") },
         { IDS_USERPORT_DEVICE_DA, "Brugerportens RS232-enhed" },
         { IDS_USERPORT_DEVICE_DE, "Userport RS232 Gert" },
         { IDS_USERPORT_DEVICE_FR, "Priphrique de port utilisateur RS232" },
         { IDS_USERPORT_DEVICE_HU, "Userport RS232 eszkz" },
         { IDS_USERPORT_DEVICE_IT, "Dispositivo Userport RS232" },
         { IDS_USERPORT_DEVICE_NL, "Userport RS232-apparaat" },
         { IDS_USERPORT_DEVICE_PL, "" },             
         { IDS_USERPORT_DEVICE_SV, "Anvndarportens RS232-enhet" },
         { IDS_USERPORT_DEVICE_TR, "Userport RS232 Aygt" },

         { IDS_USERPORT_BAUD_RATE,    N_("Userport RS232 baud rate") },
         { IDS_USERPORT_BAUD_RATE_DA, "Brugerportens RS232-baudhastighet" },
         { IDS_USERPORT_BAUD_RATE_DE, "Userport RS232 Baud Rate" },
         { IDS_USERPORT_BAUD_RATE_FR, "Priphrique de port utilisateur RS232" },
         { IDS_USERPORT_BAUD_RATE_HU, "Userport RS232 tviteli rta" },
         { IDS_USERPORT_BAUD_RATE_IT, "Velocit della RS232 su Userport" },
         { IDS_USERPORT_BAUD_RATE_NL, "Userport RS232 baudrate" },
         { IDS_USERPORT_BAUD_RATE_PL, "" },             
         { IDS_USERPORT_BAUD_RATE_SV, "Anvndarportens RS232-baudhastighet" },
         { IDS_USERPORT_BAUD_RATE_TR, "Userport RS232 baud rate" },

         { IDS_RS232_USERPORT_SETTINGS,    N_("RS232 Userport Settings") },
         { IDS_RS232_USERPORT_SETTINGS_DA, "RS232-brugerportindstillinger" },
         { IDS_RS232_USERPORT_SETTINGS_DE, "RS232 Userport Einstellungen" },
         { IDS_RS232_USERPORT_SETTINGS_FR, "Parametres RS232 Userport" },
         { IDS_RS232_USERPORT_SETTINGS_HU, "RS232 Userport belltsai" },
         { IDS_RS232_USERPORT_SETTINGS_IT, "Impostazioni RS232 su userport" },
         { IDS_RS232_USERPORT_SETTINGS_NL, "RS232 Userport-instellingen" },
         { IDS_RS232_USERPORT_SETTINGS_PL, "" },             
         { IDS_RS232_USERPORT_SETTINGS_SV, "RS232-anvndarportinstllningar" },
         { IDS_RS232_USERPORT_SETTINGS_TR, "RS232 Userport Ayarlar" },

         { IDS_FAST,    N_("fast") },
         { IDS_FAST_DA, "hurtig" },
         { IDS_FAST_DE, "Schnell" },
         { IDS_FAST_FR, "rapide" },
         { IDS_FAST_HU, "gyors" },
         { IDS_FAST_IT, "Veloce" },
         { IDS_FAST_NL, "snel" },
         { IDS_FAST_PL, "" },             
         { IDS_FAST_SV, "snabbt" },
         { IDS_FAST_TR, "hzl" },

         { IDS_INTERPOLATING,    N_("interpolating") },
         { IDS_INTERPOLATING_DA, "interpolerende" },
         { IDS_INTERPOLATING_DE, "Interpolierend" },
         { IDS_INTERPOLATING_FR, "par interpolation" },
         { IDS_INTERPOLATING_HU, "interpoll" },
         { IDS_INTERPOLATING_IT, "Interpolazione" },
         { IDS_INTERPOLATING_NL, "interpolating" },
         { IDS_INTERPOLATING_PL, "" },             
         { IDS_INTERPOLATING_SV, "interpolerande" },
         { IDS_INTERPOLATING_TR, "ara deer bulma" },

         { IDS_RESAMPLING,    N_("resampling") },
         { IDS_RESAMPLING_DA, "om-samplende" },
         { IDS_RESAMPLING_DE, "Resampling" },
         { IDS_RESAMPLING_FR, "rchantillonage" },
         { IDS_RESAMPLING_HU, "jramintavtelez" },
         { IDS_RESAMPLING_IT, "ricampionamento" },
         { IDS_RESAMPLING_NL, "resampling" },
         { IDS_RESAMPLING_PL, "" },             
         { IDS_RESAMPLING_SV, "omsamplande" },
         { IDS_RESAMPLING_TR, "yeniden rnekleme" },

         { IDS_FAST_RESAMPLING,    N_("fast resampling") },
         { IDS_FAST_RESAMPLING_DA, "hurtig omsampling" },
         { IDS_FAST_RESAMPLING_DE, "Schnelles Resampling" },
         { IDS_FAST_RESAMPLING_FR, "rchantillonage rapide" },
         { IDS_FAST_RESAMPLING_HU, "gyors jramintavtelez" },
         { IDS_FAST_RESAMPLING_IT, "ricampionamento veloce" },
         { IDS_FAST_RESAMPLING_NL, "snelle resampling" },
         { IDS_FAST_RESAMPLING_PL, "" },             
         { IDS_FAST_RESAMPLING_SV, "snabb omsampling" },
         { IDS_FAST_RESAMPLING_TR, "hzl yeniden rnekleme" },

         { IDS_6581_OLD,    N_("6581 (old)") },
         { IDS_6581_OLD_DA, "6581 (gammel)" },
         { IDS_6581_OLD_DE, "6581 (alt)" },
         { IDS_6581_OLD_FR, "6581 (ancien)" },
         { IDS_6581_OLD_HU, "6581 (rgi)" },
         { IDS_6581_OLD_IT, "6581 (vecchio)" },
         { IDS_6581_OLD_NL, "6581 (oud)" },
         { IDS_6581_OLD_PL, "" },             
         { IDS_6581_OLD_SV, "6581 (gammal)" },
         { IDS_6581_OLD_TR, "6581 (eski)" },

         { IDS_8580_NEW,    N_("8580 (new)") },
         { IDS_8580_NEW_DA, "8580 (ny)" },
         { IDS_8580_NEW_DE, "8580 (neu)" },
         { IDS_8580_NEW_FR, "8580 (nouveau)" },
         { IDS_8580_NEW_HU, "8580 (j)" },
         { IDS_8580_NEW_IT, "8580 (nuovo)" },
         { IDS_8580_NEW_NL, "8580 (nieuw)" },
         { IDS_8580_NEW_PL, "" },             
         { IDS_8580_NEW_SV, "8580 (ny)" },
         { IDS_8580_NEW_TR, "8580 (yeni)" },

         { IDS_SID_STEREO,    N_("SID Stereo") },
         { IDS_SID_STEREO_DA, "SID-stereo" },
         { IDS_SID_STEREO_DE, "SID Stereo" },
         { IDS_SID_STEREO_FR, "SID Stro" },
         { IDS_SID_STEREO_HU, "SID sztere" },
         { IDS_SID_STEREO_IT, "SID Stereo" },
         { IDS_SID_STEREO_NL, "Stereo-SID" },
         { IDS_SID_STEREO_PL, "" },             
         { IDS_SID_STEREO_SV, "SID-stereo" },
         { IDS_SID_STEREO_TR, "Stereo SID" },

         { IDS_STEREO_SID_AT,    N_("Stereo SID at") },
         { IDS_STEREO_SID_AT_PL, "Stereo-SID p" },
         { IDS_STEREO_SID_AT_DE, "Stereo SID bei" },
         { IDS_STEREO_SID_AT_FR, "SID Stro  " },
         { IDS_STEREO_SID_AT_HU, "Sztere SID itt:" },
         { IDS_STEREO_SID_AT_IT, "SID Stereo a" },
         { IDS_STEREO_SID_AT_NL, "Stereo-SID op" },
         { IDS_STEREO_SID_AT_PL, "" },             
         { IDS_STEREO_SID_AT_SV, "Stereo-SID pa" },
         { IDS_STEREO_SID_AT_TR, "Stereo SID konumu" },

         { IDS_SID_FILTERS,    N_("SID Filters") },
         { IDS_SID_FILTERS_DA, "SID-filter" },
         { IDS_SID_FILTERS_DE, "SID Filter" },
         { IDS_SID_FILTERS_FR, "Filtres SID" },
         { IDS_SID_FILTERS_HU, "SID szrk" },
         { IDS_SID_FILTERS_IT, "Filtri SID" },
         { IDS_SID_FILTERS_NL, "SID-filters" },
         { IDS_SID_FILTERS_PL, "" },             
         { IDS_SID_FILTERS_SV, "SID-filter" },
         { IDS_SID_FILTERS_TR, "SID Filtreleri" },

         { IDS_SAMPLE_METHOD,    N_("Sample method") },
         { IDS_SAMPLE_METHOD_DA, "Samplingmetode" },
         { IDS_SAMPLE_METHOD_DE, "Sample Methode" },
         { IDS_SAMPLE_METHOD_FR, "Mthode d'chantillonnage" },
         { IDS_SAMPLE_METHOD_HU, "Mintavtelezs mdja" },
         { IDS_SAMPLE_METHOD_IT, "Metodo di campionamento" },
         { IDS_SAMPLE_METHOD_NL, "Sample methode" },
         { IDS_SAMPLE_METHOD_PL, "" },             
         { IDS_SAMPLE_METHOD_SV, "Samplingsmetod" },
         { IDS_SAMPLE_METHOD_TR, "rnekleme metodu" },

         { IDS_PASSBAND_0_90,    N_("Passband (0-90%)") },
         { IDS_PASSBAND_0_90_DA, "Pasbnd (0-90%)" },
         { IDS_PASSBAND_0_90_DE, "Passband (0-90%)" },
         { IDS_PASSBAND_0_90_FR, "Bande passante (0-90%)" },
         { IDS_PASSBAND_0_90_HU, "teresztsg (0-90%)" },
         { IDS_PASSBAND_0_90_IT, "Passabanda (0-90%)" },
         { IDS_PASSBAND_0_90_NL, "Passband (0-90%)" },
         { IDS_PASSBAND_0_90_PL, "" },             
         { IDS_PASSBAND_0_90_SV, "Passband (0-90%)" },
         { IDS_PASSBAND_0_90_TR, "Passband (0-90%)" },

         { IDS_NOT_IMPLEMENTED_YET,    N_("Not implemented yet!") },
         { IDS_NOT_IMPLEMENTED_YET_DA, "Ikke implementeret endnu!" },
         { IDS_NOT_IMPLEMENTED_YET_DE, "Noch nicht implementiert!" },
         { IDS_NOT_IMPLEMENTED_YET_FR, "Pas encore implment!" },
         { IDS_NOT_IMPLEMENTED_YET_HU, "Nincs mg implementlva!" },
         { IDS_NOT_IMPLEMENTED_YET_IT, "Non ancora implementato!" },
         { IDS_NOT_IMPLEMENTED_YET_NL, "Nog niet ondersteund!" },
         { IDS_NOT_IMPLEMENTED_YET_PL, "" },             
         { IDS_NOT_IMPLEMENTED_YET_SV, "Ej implementerat!" },
         { IDS_NOT_IMPLEMENTED_YET_TR, "Henz tamamlanmad!" },

         { IDS_SID_SETTINGS,    N_("SID Settings") },
         { IDS_SID_SETTINGS_DA, "SID-indstillinger" },
         { IDS_SID_SETTINGS_DE, "SID Einstellungen" },
         { IDS_SID_SETTINGS_FR, "Parametres SID" },
         { IDS_SID_SETTINGS_HU, "SID belltsai" },
         { IDS_SID_SETTINGS_IT, "Impostazioni SID" },
         { IDS_SID_SETTINGS_NL, "SID-instellingen" },
         { IDS_SID_SETTINGS_PL, "" },             
         { IDS_SID_SETTINGS_SV, "SID-instllningar" },
         { IDS_SID_SETTINGS_TR, "SID Ayarlar" },

         { IDS_FLEXIBLE,    N_("Flexible") },
         { IDS_FLEXIBLE_DA, "Fleksibel" },
         { IDS_FLEXIBLE_DE, "Flexibel" },
         { IDS_FLEXIBLE_FR, "Flexible" },
         { IDS_FLEXIBLE_HU, "Rugalmas" },
         { IDS_FLEXIBLE_IT, "Flessibile" },
         { IDS_FLEXIBLE_NL, "Flexibel" },
         { IDS_FLEXIBLE_PL, "" },             
         { IDS_FLEXIBLE_SV, "Flexibel" },
         { IDS_FLEXIBLE_TR, "Esnek" },

         { IDS_ADJUSTING,    N_("Adjusting") },
         { IDS_ADJUSTING_DA, "Tilpassende" },
         { IDS_ADJUSTING_DE, "Anpassend" },
         { IDS_ADJUSTING_FR, "Ajust" },
         { IDS_ADJUSTING_HU, "Igazod" },
         { IDS_ADJUSTING_IT, "Adattamento in corso" },
         { IDS_ADJUSTING_NL, "Aanpassend" },
         { IDS_ADJUSTING_PL, "" },             
         { IDS_ADJUSTING_SV, "Anpassande" },
         { IDS_ADJUSTING_TR, "Dzeltme" },

         { IDS_EXACT,    N_("Exact") },
         { IDS_EXACT_DA, "Njagtig" },
         { IDS_EXACT_DE, "Exakt" },
         { IDS_EXACT_FR, "Exact" },
         { IDS_EXACT_HU, "Pontos" },
         { IDS_EXACT_IT, "Esatta" },
         { IDS_EXACT_NL, "Exact" },
         { IDS_EXACT_PL, "" },             
         { IDS_EXACT_SV, "Exakt" },
         { IDS_EXACT_TR, "Aynen" },

         { IDS_SAMPLE_RATE,    N_("Sample Rate") },
         { IDS_SAMPLE_RATE_DA, "Samplingfrekvens" },
         { IDS_SAMPLE_RATE_DE, "Sample Rate" },
         { IDS_SAMPLE_RATE_FR, "Taux d'chantillonage" },
         { IDS_SAMPLE_RATE_HU, "Mintavtelezsi rta" },
         { IDS_SAMPLE_RATE_IT, "Frequenza di campionamento" },
         { IDS_SAMPLE_RATE_NL, "Sample snelheid" },
         { IDS_SAMPLE_RATE_PL, "" },             
         { IDS_SAMPLE_RATE_SV, "Samplingshastighet" },
         { IDS_SAMPLE_RATE_TR, "rnekleme Hz" },

         { IDS_BUFFER_SIZE,    N_("Buffer Size") },
         { IDS_BUFFER_SIZE_DA, "Bufferstrrelse" },
         { IDS_BUFFER_SIZE_DE, "Puffergre" },
         { IDS_BUFFER_SIZE_FR, "Taille du tampon" },
         { IDS_BUFFER_SIZE_HU, "Puffer mret" },
         { IDS_BUFFER_SIZE_IT, "Dimensione del buffer" },
         { IDS_BUFFER_SIZE_NL, "Buffergrootte" },
         { IDS_BUFFER_SIZE_PL, "" },             
         { IDS_BUFFER_SIZE_SV, "Buffertstorlek" },
         { IDS_BUFFER_SIZE_TR, "Arabellek Boyutu" },

         { IDS_FRAGMENT_SIZE,    N_("Fragment Size") },
         { IDS_FRAGMENT_SIZE_DA, "" },             
         { IDS_FRAGMENT_SIZE_DE, "Fragmentgre" },
         { IDS_FRAGMENT_SIZE_FR, "" },             
         { IDS_FRAGMENT_SIZE_HU, "" },             
         { IDS_FRAGMENT_SIZE_IT, "Dimensione del frammento" },
         { IDS_FRAGMENT_SIZE_NL, "Fragment grootte" },
         { IDS_FRAGMENT_SIZE_PL, "" },             
         { IDS_FRAGMENT_SIZE_SV, "Fragmentstorlek" },
         { IDS_FRAGMENT_SIZE_TR, "Para boyutu" },

         { IDS_OVERSAMPLE,    N_("Oversample") },
         { IDS_OVERSAMPLE_DA, "Oversampling" },
         { IDS_OVERSAMPLE_DE, "Oversample" },
         { IDS_OVERSAMPLE_FR, "Surchantillonage" },
         { IDS_OVERSAMPLE_HU, "Tlmintavtelezs" },
         { IDS_OVERSAMPLE_IT, "Sovracampionamento" },
         { IDS_OVERSAMPLE_NL, "Oversample" },
         { IDS_OVERSAMPLE_PL, "" },             
         { IDS_OVERSAMPLE_SV, "Oversampling" },
         { IDS_OVERSAMPLE_TR, "Yksek hzda rnekleme" },

         { IDS_SPEED_ADJUSTMENT,    N_("Speed Adjustment") },
         { IDS_SPEED_ADJUSTMENT_DA, "Hastighedsjustering" },
         { IDS_SPEED_ADJUSTMENT_DE, "Geschwindigkeitsanpassung" },
         { IDS_SPEED_ADJUSTMENT_FR, "Ajustement de vitesse" },
         { IDS_SPEED_ADJUSTMENT_HU, "Sebessg mdosts" },
         { IDS_SPEED_ADJUSTMENT_IT, "Variazione velocit" },
         { IDS_SPEED_ADJUSTMENT_NL, "Snelheidsaanpassing" },
         { IDS_SPEED_ADJUSTMENT_PL, "" },             
         { IDS_SPEED_ADJUSTMENT_SV, "Hastighetsjustering" },
         { IDS_SPEED_ADJUSTMENT_TR, "Hz Ayarlamas" },

         { IDS_SOUND_SETTINGS,    N_("Sound Settings") },
         { IDS_SOUND_SETTINGS_DA, "Lydindstillinger" },
         { IDS_SOUND_SETTINGS_DE, "Sound Einstellungen" },
         { IDS_SOUND_SETTINGS_FR, "Parametres son" },
         { IDS_SOUND_SETTINGS_HU, "Hang belltsai" },
         { IDS_SOUND_SETTINGS_IT, "Impostazioni audio" },
         { IDS_SOUND_SETTINGS_NL, "Geluidsinstellingen" },
         { IDS_SOUND_SETTINGS_PL, "" },             
         { IDS_SOUND_SETTINGS_SV, "Ljudinstllningar" },
         { IDS_SOUND_SETTINGS_TR, "Ses Ayarlar" },

         { IDS_VIC_SETTINGS,    N_("VIC Settings") },
         { IDS_VIC_SETTINGS_DA, "VIC-indstillinger" },
         { IDS_VIC_SETTINGS_DE, "VIC Einstellungen" },
         { IDS_VIC_SETTINGS_FR, "Parametres VIC" },
         { IDS_VIC_SETTINGS_HU, "VIC belltsai" },
         { IDS_VIC_SETTINGS_IT, "Impostazioni VIC" },
         { IDS_VIC_SETTINGS_NL, "VIC-instellingen" },
         { IDS_VIC_SETTINGS_PL, "" },             
         { IDS_VIC_SETTINGS_SV, "VIC-instllningar" },
         { IDS_VIC_SETTINGS_TR, "VIC ayarlar" },

         { IDS_SPRITE_SPRITE_COL,    N_("Sprite Sprite Collisions") },
         { IDS_SPRITE_SPRITE_COL_DA, "Sprite-sprite-kollisioner" },
         { IDS_SPRITE_SPRITE_COL_DE, "Sprite-sprite Kollisionen" },
         { IDS_SPRITE_SPRITE_COL_FR, "Collisions sprite avec sprite" },
         { IDS_SPRITE_SPRITE_COL_HU, "Sprite-sprite tkzsek" },
         { IDS_SPRITE_SPRITE_COL_IT, "Collisioni sprite-sprite" },
         { IDS_SPRITE_SPRITE_COL_NL, "Sprite-sprite botsingen" },
         { IDS_SPRITE_SPRITE_COL_PL, "" },             
         { IDS_SPRITE_SPRITE_COL_SV, "Sprite-sprite-kollisioner" },
         { IDS_SPRITE_SPRITE_COL_TR, "Yaratk Yaratk arpmalar" },

         { IDS_SPRITE_BACKGROUND_COL,    N_("Sprite Background Collisions") },
         { IDS_SPRITE_BACKGROUND_COL_DA, "Sprite-baggrundskollisioner" },
         { IDS_SPRITE_BACKGROUND_COL_DE, "Sprite-Hintergrund Kollisionen" },
         { IDS_SPRITE_BACKGROUND_COL_FR, "Collisions sprite avec arrire-plan" },
         { IDS_SPRITE_BACKGROUND_COL_HU, "Sprite-httr tkzsek" },
         { IDS_SPRITE_BACKGROUND_COL_IT, "Collisioni sprite-sfondo" },
         { IDS_SPRITE_BACKGROUND_COL_NL, "Sprite-achtergrond botsingen" },
         { IDS_SPRITE_BACKGROUND_COL_PL, "" },             
         { IDS_SPRITE_BACKGROUND_COL_SV, "Sprite-bakgrundkollisioner" },
         { IDS_SPRITE_BACKGROUND_COL_TR, "Yaratk Arka Plan arpmalar" },

         { IDS_NEW_LUMINANCES,    N_("New Luminances") },
         { IDS_NEW_LUMINANCES_DA, "Nye lysstyrker" },
         { IDS_NEW_LUMINANCES_DE, "Neue Helligkeitsemulation" },
         { IDS_NEW_LUMINANCES_FR, "Nouvelles luminescences" },
         { IDS_NEW_LUMINANCES_HU, "j fnyerk" },
         { IDS_NEW_LUMINANCES_IT, "Nuove luminanze" },
         { IDS_NEW_LUMINANCES_NL, "Nieuwe kleuren" },
         { IDS_NEW_LUMINANCES_PL, "" },             
         { IDS_NEW_LUMINANCES_SV, "Nya ljusstyrkor" },
         { IDS_NEW_LUMINANCES_TR, "Yeni Parlaklklar" },

         { IDS_VICII_SETTINGS,    N_("VIC-II Settings") },
         { IDS_VICII_SETTINGS_DA, "VIC-II-indstillinger" },
         { IDS_VICII_SETTINGS_DE, "VIC-II Einstellungen" },
         { IDS_VICII_SETTINGS_FR, "Parametres VIC-II" },
         { IDS_VICII_SETTINGS_HU, "VIC-II belltsai" },
         { IDS_VICII_SETTINGS_IT, "Impostazioni VIC-II" },
         { IDS_VICII_SETTINGS_NL, "VIC-II-instellingen" },
         { IDS_VICII_SETTINGS_PL, "" },             
         { IDS_VICII_SETTINGS_SV, "VIC-II-instllningar" },
         { IDS_VICII_SETTINGS_TR, "VIC-II ayarlar" },

         { IDS_ATTACH_TAPE_IMAGE,    N_("Attach tape image") },
         { IDS_ATTACH_TAPE_IMAGE_DA, "Tilslut bnd-image" },
         { IDS_ATTACH_TAPE_IMAGE_DE, "Band Image einlegen" },
         { IDS_ATTACH_TAPE_IMAGE_FR, "Insrer une image datassette" },
         { IDS_ATTACH_TAPE_IMAGE_HU, "Szalag kpms csatolsa" },
         { IDS_ATTACH_TAPE_IMAGE_IT, "Seleziona l'immagine di una cassetta" },
         { IDS_ATTACH_TAPE_IMAGE_NL, "Koppel tapebestand aan" },
         { IDS_ATTACH_TAPE_IMAGE_PL, "" },             
         { IDS_ATTACH_TAPE_IMAGE_SV, "Anslut en bandavbildningsfil" },
         { IDS_ATTACH_TAPE_IMAGE_TR, "Teyp imajn yerletir" },

         { IDS_AUTOSTART_IMAGE,    N_("Autostart disk/tape image") },
         { IDS_AUTOSTART_IMAGE_DA, "Autostart disk-/bnd-image" },
         { IDS_AUTOSTART_IMAGE_DE, "Autostart Disk/Band Image" },
         { IDS_AUTOSTART_IMAGE_FR, "Dmarrage automatique d'une image datassette" },
         { IDS_AUTOSTART_IMAGE_HU, "Lemez/szalag kpms automatikus indtsa" },
         { IDS_AUTOSTART_IMAGE_IT, "Avvia automaticamente l'immagine di un disco/cassetta" },
         { IDS_AUTOSTART_IMAGE_NL, "Autostart disk-/tapebestand" },
         { IDS_AUTOSTART_IMAGE_PL, "" },             
         { IDS_AUTOSTART_IMAGE_SV, "Autostarta disk-/bandavbildningsfil" },
         { IDS_AUTOSTART_IMAGE_TR, "Disk/Teyp imajn otomatik balat" },

         { IDS_IDE64_FILENAME,    N_("HD image file") },
         { IDS_IDE64_FILENAME_DA, "HD-image fil" },
         { IDS_IDE64_FILENAME_DE, "HD Image Name" },
         { IDS_IDE64_FILENAME_FR, "Nom d'image DD" },
         { IDS_IDE64_FILENAME_HU, "Merevlemez kpms fjl" },
         { IDS_IDE64_FILENAME_IT, "File immagine dell'HD" },
         { IDS_IDE64_FILENAME_NL, "HD-bestand" },
         { IDS_IDE64_FILENAME_PL, "" },             
         { IDS_IDE64_FILENAME_SV, "HD-avbildningsfil" },
         { IDS_IDE64_FILENAME_TR, "HD imaj dosyas" },

         { IDS_IDE64_FILENAME_SELECT,    N_("Select HD image file") },
         { IDS_IDE64_FILENAME_SELECT_DA, "Angiv HD-imagefil" },
         { IDS_IDE64_FILENAME_SELECT_DE, "HD Image Datei auswhlen" },
         { IDS_IDE64_FILENAME_SELECT_FR, "Slectionnez le fichier image du D.D." },
         { IDS_IDE64_FILENAME_SELECT_HU, "Vlassza ki a merevlemez kpms fjlt" },
         { IDS_IDE64_FILENAME_SELECT_IT, "Seleziona il file immagine dell'HD" },
         { IDS_IDE64_FILENAME_SELECT_NL, "Selecteer HD-bestand" },
         { IDS_IDE64_FILENAME_SELECT_PL, "" },             
         { IDS_IDE64_FILENAME_SELECT_SV, "Ange HD-avbildningsfil" },
         { IDS_IDE64_FILENAME_SELECT_TR, "HD imaj dosyas se" },

         { IDS_AUTODETECT,    N_("Autodetect") },
         { IDS_AUTODETECT_DA, "Autodetektr" },
         { IDS_AUTODETECT_DE, "Automatische Erkennung" },
         { IDS_AUTODETECT_FR, "Autodtection" },
         { IDS_AUTODETECT_HU, "Automatikus rzkels" },
         { IDS_AUTODETECT_IT, "Rileva automaticamente" },
         { IDS_AUTODETECT_NL, "Autodetectie" },
         { IDS_AUTODETECT_PL, "" },             
         { IDS_AUTODETECT_SV, "Autodetektera" },
         { IDS_AUTODETECT_TR, "Otomatik algla" },

         { IDS_CYLINDERS,    N_("Cylinders") },
         { IDS_CYLINDERS_DA, "Cylindrer" },
         { IDS_CYLINDERS_DE, "Zylinder" },
         { IDS_CYLINDERS_FR, "Cylindres" },
         { IDS_CYLINDERS_HU, "Svok" },
         { IDS_CYLINDERS_IT, "Cilindri" },
         { IDS_CYLINDERS_NL, "Cylinders" },
         { IDS_CYLINDERS_PL, "" },             
         { IDS_CYLINDERS_SV, "Cylindrar" },
         { IDS_CYLINDERS_TR, "Silindirler" },

         { IDS_HEADS,    N_("Heads") },
         { IDS_HEADS_DA, "Hoveder" },
         { IDS_HEADS_DE, "Kpfe" },
         { IDS_HEADS_FR, "Ttes" },
         { IDS_HEADS_HU, "Fejek" },
         { IDS_HEADS_IT, "Testine" },
         { IDS_HEADS_NL, "Koppen" },
         { IDS_HEADS_PL, "" },             
         { IDS_HEADS_SV, "Huvuden" },
         { IDS_HEADS_TR, "Kafalar" },

         { IDS_SECTORS,    N_("Sectors") },
         { IDS_SECTORS_DA, "Sektorer" },
         { IDS_SECTORS_DE, "Sektoren" },
         { IDS_SECTORS_FR, "Secteurs" },
         { IDS_SECTORS_HU, "Szektorok" },
         { IDS_SECTORS_IT, "Settori" },
         { IDS_SECTORS_NL, "Sectors" },
         { IDS_SECTORS_PL, "" },             
         { IDS_SECTORS_SV, "Sektorer" },
         { IDS_SECTORS_TR, "Sektrler" },

         { IDS_IDE64_SETTINGS,    N_("IDE64 settings") },
         { IDS_IDE64_SETTINGS_DA, "IDE64-indstillinger" },
         { IDS_IDE64_SETTINGS_DE, "IDE64 Einstellungen" },
         { IDS_IDE64_SETTINGS_FR, "Paramtres IDE64" },
         { IDS_IDE64_SETTINGS_HU, "IDE64 belltsai" },
         { IDS_IDE64_SETTINGS_IT, "Impostazioni IDE64" },
         { IDS_IDE64_SETTINGS_NL, "IDE64-instellingen" },
         { IDS_IDE64_SETTINGS_PL, "" },             
         { IDS_IDE64_SETTINGS_SV, "IDE64-instllningar" },
         { IDS_IDE64_SETTINGS_TR, "IDE64 ayarlar" },

         { IDS_BIOS_REVISION,    N_("BIOS Revision") },
         { IDS_BIOS_REVISION_DA, "BIOS-revision" },
         { IDS_BIOS_REVISION_DE, "BIOS Revision" },
         { IDS_BIOS_REVISION_FR, "" },             
         { IDS_BIOS_REVISION_HU, "BIOS vltozat" },
         { IDS_BIOS_REVISION_IT, "Revisione BIOS" },
         { IDS_BIOS_REVISION_NL, "BIOS-revisie" },
         { IDS_BIOS_REVISION_PL, "" },             
         { IDS_BIOS_REVISION_SV, "BIOS-utgva" },
         { IDS_BIOS_REVISION_TR, "BIOS Revizyonu" },

         { IDS_BIOS_FLASH_JUMPER,    N_("BIOS Flash Jumper") },
         { IDS_BIOS_FLASH_JUMPER_DA, "BIOS-flashjumper" },
         { IDS_BIOS_FLASH_JUMPER_DE, "BIOS Flashjumper" },
         { IDS_BIOS_FLASH_JUMPER_FR, "Flash Jumper BIOS" },
         { IDS_BIOS_FLASH_JUMPER_HU, "BIOS Flash jumper" },
         { IDS_BIOS_FLASH_JUMPER_IT, "Flash Jumper del BIOS" },
         { IDS_BIOS_FLASH_JUMPER_NL, "BIOS Flash Jumper" },
         { IDS_BIOS_FLASH_JUMPER_PL, "" },             
         { IDS_BIOS_FLASH_JUMPER_SV, "BIOS-flashbygel" },
         { IDS_BIOS_FLASH_JUMPER_TR, "BIOS Flash Jumper" },

         { IDS_SAVE_BIOS_WHEN_CHANGED,    N_("Save BIOS when changed") },
         { IDS_SAVE_BIOS_WHEN_CHANGED_DA, "Gem BIOS ved ndringer" },
         { IDS_SAVE_BIOS_WHEN_CHANGED_DE, "BIOS bei nderung speichern" },
         { IDS_SAVE_BIOS_WHEN_CHANGED_FR, "Enregistrer le BIOS lorsque modifi" },
         { IDS_SAVE_BIOS_WHEN_CHANGED_HU, "BIOS mentse vltozs utn" },
         { IDS_SAVE_BIOS_WHEN_CHANGED_IT, "Salva il BIOS al cambio" },
         { IDS_SAVE_BIOS_WHEN_CHANGED_NL, "BIOS Opslaan indien gewijzigd" },
         { IDS_SAVE_BIOS_WHEN_CHANGED_PL, "" },             
         { IDS_SAVE_BIOS_WHEN_CHANGED_SV, "Spara BIOS vid ndring" },
         { IDS_SAVE_BIOS_WHEN_CHANGED_TR, "BIOS deitiinde kaydet" },

         { IDS_BIOS_FILE,    N_("BIOS File") },
         { IDS_BIOS_FILE_DA, "BIOS-fil" },
         { IDS_BIOS_FILE_DE, "BIOS Datei" },
         { IDS_BIOS_FILE_FR, "Fichier du BIOS" },
         { IDS_BIOS_FILE_HU, "BIOS fjl" },
         { IDS_BIOS_FILE_IT, "File del BIOS" },
         { IDS_BIOS_FILE_NL, "BIOS-bestand" },
         { IDS_BIOS_FILE_PL, "" },             
         { IDS_BIOS_FILE_SV, "BIOS-fil" },
         { IDS_BIOS_FILE_TR, "BIOS Dosyas" },

         { IDS_SELECT_BIOS_FILE,    N_("Select BIOS file") },
         { IDS_SELECT_BIOS_FILE_DA, "Vlg BIOS-fil" },
         { IDS_SELECT_BIOS_FILE_DE, "BIOS Datei whlen" },
         { IDS_SELECT_BIOS_FILE_FR, "Slectionner le fichier du BIOS " },
         { IDS_SELECT_BIOS_FILE_HU, "Vlasszon BIOS fjlt" },
         { IDS_SELECT_BIOS_FILE_IT, "Seleziona il file del BIOS" },
         { IDS_SELECT_BIOS_FILE_NL, "Selecteer BIOS-bestand" },
         { IDS_SELECT_BIOS_FILE_PL, "" },             
         { IDS_SELECT_BIOS_FILE_SV, "Vlj BIOS-fil" },
         { IDS_SELECT_BIOS_FILE_TR, "BIOS dosyas sein" },

         { IDS_MMC64_IMAGE_READ_ONLY,    N_("MMC/SD Image read-only") },
         { IDS_MMC64_IMAGE_READ_ONLY_DA, "MMC/SD-image skrivebeskyttet" },
         { IDS_MMC64_IMAGE_READ_ONLY_DE, "MMC/SD Image Schreibschutz" },
         { IDS_MMC64_IMAGE_READ_ONLY_FR, "Image MMC/SD en lecture seule" },
         { IDS_MMC64_IMAGE_READ_ONLY_HU, "MMC/SD kpms csak olvashat" },
         { IDS_MMC64_IMAGE_READ_ONLY_IT, "Immagine MMC/SD in sola lettura" },
         { IDS_MMC64_IMAGE_READ_ONLY_NL, "MMC/SD-bestand alleen-lezen" },
         { IDS_MMC64_IMAGE_READ_ONLY_PL, "" },             
         { IDS_MMC64_IMAGE_READ_ONLY_SV, "MMC/SD-avbildning skrivskyddad" },
         { IDS_MMC64_IMAGE_READ_ONLY_TR, "Salt Okunur MMC/SD Imaj" },

         { IDS_MMC64_IMAGE_FILE,    N_("MMC/SD Image File") },
         { IDS_MMC64_IMAGE_FILE_DA, "MMC/SD-image" },
         { IDS_MMC64_IMAGE_FILE_DE, "MMC/SD Image Name" },
         { IDS_MMC64_IMAGE_FILE_FR, "Nom d'image MMC/SD" },
         { IDS_MMC64_IMAGE_FILE_HU, "MMC/SD kpms fjl" },
         { IDS_MMC64_IMAGE_FILE_IT, "File immagine MMC/SD" },
         { IDS_MMC64_IMAGE_FILE_NL, "MMC/SD-bestand" },
         { IDS_MMC64_IMAGE_FILE_PL, "" },             
         { IDS_MMC64_IMAGE_FILE_SV, "MMC/SD-avbildningsfil" },
         { IDS_MMC64_IMAGE_FILE_TR, "MMC/SD Imaj Dosyas" },

         { IDS_SELECT_MMC64_IMAGE_FILE,    N_("Select MMC/SD image file") },
         { IDS_SELECT_MMC64_IMAGE_FILE_DA, "Vlg MMC/SD-image" },
         { IDS_SELECT_MMC64_IMAGE_FILE_DE, "MMC/SD Image Date whlen" },
         { IDS_SELECT_MMC64_IMAGE_FILE_FR, "Slectionnez le fichier image du MMC/SD" },
         { IDS_SELECT_MMC64_IMAGE_FILE_HU, "Vlassza ki az MMC/SD kpms fjlt" },
         { IDS_SELECT_MMC64_IMAGE_FILE_IT, "Seleziona il file immagine MMC/SD" },
         { IDS_SELECT_MMC64_IMAGE_FILE_NL, "Selecteer MMC/SD-bestand" },
         { IDS_SELECT_MMC64_IMAGE_FILE_PL, "" },             
         { IDS_SELECT_MMC64_IMAGE_FILE_SV, "Ange MMC/SD-avbildningsfil" },
         { IDS_SELECT_MMC64_IMAGE_FILE_TR, "MMC/SD imaj dosyas sein" },

         { IDS_MMC64_SETTINGS,    N_("MMC64 settings") },
         { IDS_MMC64_SETTINGS_DA, "MMC64-indstillinger" },
         { IDS_MMC64_SETTINGS_DE, "MMC64 Einstellungen" },
         { IDS_MMC64_SETTINGS_FR, "Paramtres MMC64" },
         { IDS_MMC64_SETTINGS_HU, "MMC64 belltsai" },
         { IDS_MMC64_SETTINGS_IT, "Impostazioni MMC64" },
         { IDS_MMC64_SETTINGS_NL, "MMC64-instellingen" },
         { IDS_MMC64_SETTINGS_PL, "" },             
         { IDS_MMC64_SETTINGS_SV, "MMC64-instllningar" },
         { IDS_MMC64_SETTINGS_TR, "MMC64 ayarlar" },

         { IDS_SELECT_GENERIC,    N_("Select generic cartridge file") },
         { IDS_SELECT_GENERIC_DA, "" },             
         { IDS_SELECT_GENERIC_DE, "Unverselles Erweiterungsmodul Image Datei whlen" },
         { IDS_SELECT_GENERIC_FR, "" },             
         { IDS_SELECT_GENERIC_HU, "" },             
         { IDS_SELECT_GENERIC_IT, "Seleziona file cartuccia generica" },
         { IDS_SELECT_GENERIC_NL, "Selecteer algemeen cartridge bestand" },
         { IDS_SELECT_GENERIC_PL, "" },             
         { IDS_SELECT_GENERIC_SV, "Vlj generisk insticksmodulfil" },
         { IDS_SELECT_GENERIC_TR, "Jenerik kartu dosyasn se" },

         { IDS_SELECT_MEGACART,    N_("Select Mega-Cart file") },
         { IDS_SELECT_MEGACART_DA, "" },             
         { IDS_SELECT_MEGACART_DE, "Mega-Cart Image Datei whlen" },
         { IDS_SELECT_MEGACART_FR, "" },             
         { IDS_SELECT_MEGACART_HU, "" },             
         { IDS_SELECT_MEGACART_IT, "Seleziona file Mega-Cart" },
         { IDS_SELECT_MEGACART_NL, "Selecteer Mega-Cart bestand" },
         { IDS_SELECT_MEGACART_PL, "" },             
         { IDS_SELECT_MEGACART_SV, "Vlj Mega-Cart-fil" },
         { IDS_SELECT_MEGACART_TR, "Mega-Cart dosyasn se" },

         { IDS_SELECT_FINAL_EXPANSION,    N_("Select Final Expansion file") },
         { IDS_SELECT_FINAL_EXPANSION_DA, "" },             
         { IDS_SELECT_FINAL_EXPANSION_DE, "Final Expansion Datei whlen" },
         { IDS_SELECT_FINAL_EXPANSION_FR, "" },             
         { IDS_SELECT_FINAL_EXPANSION_HU, "" },             
         { IDS_SELECT_FINAL_EXPANSION_IT, "Seleziona file Final Expansion" },
         { IDS_SELECT_FINAL_EXPANSION_NL, "Selecteer Final Expansion bestand" },
         { IDS_SELECT_FINAL_EXPANSION_PL, "" },             
         { IDS_SELECT_FINAL_EXPANSION_SV, "Vlj Final Expansion-fil" },
         { IDS_SELECT_FINAL_EXPANSION_TR, "Final Expansion dosyasn se" },

         { IDS_SELECT_CARTRIDGE_IMAGE,    N_("Select cartridge file") },
         { IDS_SELECT_CARTRIDGE_IMAGE_DA, "" },             
         { IDS_SELECT_CARTRIDGE_IMAGE_DE, "Erweiterungsmodul Image Datei whlen" },
         { IDS_SELECT_CARTRIDGE_IMAGE_FR, "" },             
         { IDS_SELECT_CARTRIDGE_IMAGE_HU, "" },             
         { IDS_SELECT_CARTRIDGE_IMAGE_IT, "Seleziona file cartuccia" },
         { IDS_SELECT_CARTRIDGE_IMAGE_NL, "Selecteer cartridge bestand" },
         { IDS_SELECT_CARTRIDGE_IMAGE_PL, "" },             
         { IDS_SELECT_CARTRIDGE_IMAGE_SV, "Vlj insticksmodulfil" },
         { IDS_SELECT_CARTRIDGE_IMAGE_TR, "Kartu dosyasn se" },

         { IDS_SID_CART,    N_("SID Cart") },
         { IDS_SID_CART_DA, "SID-cartridge" },
         { IDS_SID_CART_DE, "SID Modul" },
         { IDS_SID_CART_FR, "SID Cart" },
         { IDS_SID_CART_HU, "SID krtya" },
         { IDS_SID_CART_IT, "Cartuccia SID" },
         { IDS_SID_CART_NL, "SID-cart" },
         { IDS_SID_CART_PL, "" },             
         { IDS_SID_CART_SV, "SID-modul" },
         { IDS_SID_CART_TR, "SID Kartuu" },

         { IDS_SID_ENGINE_MODEL,    N_("SID engine/model") },
         { IDS_SID_ENGINE_MODEL_DA, "" },             
         { IDS_SID_ENGINE_MODEL_DE, "SID Engine/Modell" },
         { IDS_SID_ENGINE_MODEL_FR, "" },             
         { IDS_SID_ENGINE_MODEL_HU, "" },             
         { IDS_SID_ENGINE_MODEL_IT, "Motore/modello SID" },
         { IDS_SID_ENGINE_MODEL_NL, "SID-kern/model" },
         { IDS_SID_ENGINE_MODEL_PL, "" },             
         { IDS_SID_ENGINE_MODEL_SV, "SID-motor/-modell" },
         { IDS_SID_ENGINE_MODEL_TR, "SID motoru/modeli" },

         { IDS_SID_ADDRESS,    N_("SID address") },
         { IDS_SID_ADDRESS_DA, "SID-adresse" },
         { IDS_SID_ADDRESS_DE, "SID Adresse" },
         { IDS_SID_ADDRESS_FR, "Adresse SID" },
         { IDS_SID_ADDRESS_HU, "SID cm" },
         { IDS_SID_ADDRESS_IT, "Indirizzo SID" },
         { IDS_SID_ADDRESS_NL, "SID-adres" },
         { IDS_SID_ADDRESS_PL, "" },             
         { IDS_SID_ADDRESS_SV, "SID-adress" },
         { IDS_SID_ADDRESS_TR, "SID Adresi" },

         { IDS_SID_CLOCK,    N_("SID clock") },
         { IDS_SID_CLOCK_DA, "SID-klok" },
         { IDS_SID_CLOCK_DE, "SID Uhr" },
         { IDS_SID_CLOCK_FR, "Horloge SID" },
         { IDS_SID_CLOCK_HU, "SID rajel" },
         { IDS_SID_CLOCK_IT, "SID Clock" },
         { IDS_SID_CLOCK_NL, "SID-klok" },
         { IDS_SID_CLOCK_PL, "" },             
         { IDS_SID_CLOCK_SV, "SID-klocka" },
         { IDS_SID_CLOCK_TR, "SID Saati" },

         { IDS_SID_JOY,    N_("SID Cart joystick") },
         { IDS_SID_JOY_DA, "" },             
         { IDS_SID_JOY_DE, "SIDcart Joystick" },
         { IDS_SID_JOY_FR, "" },             
         { IDS_SID_JOY_HU, "" },             
         { IDS_SID_JOY_IT, "Joystick SID Cart" },
         { IDS_SID_JOY_NL, "SID-cart joystick" },
         { IDS_SID_JOY_PL, "" },             
         { IDS_SID_JOY_SV, "SIDcart-styrspak" },
         { IDS_SID_JOY_TR, "SID kartuu joystick'i" },

         { IDS_SID_DIGIBLASTER,    N_("Digiblaster add-on") },
         { IDS_SID_DIGIBLASTER_DA, "" },             
         { IDS_SID_DIGIBLASTER_DE, "Digiblaster add-on" },
         { IDS_SID_DIGIBLASTER_FR, "" },             
         { IDS_SID_DIGIBLASTER_HU, "" },             
         { IDS_SID_DIGIBLASTER_IT, "Estensione digiblaster" },
         { IDS_SID_DIGIBLASTER_NL, "Digiblaster add-on" },
         { IDS_SID_DIGIBLASTER_PL, "" },             
         { IDS_SID_DIGIBLASTER_SV, "Digiblaster-tillgg" },
         { IDS_SID_DIGIBLASTER_TR, "Digiblaster eklentisi" },

         { IDS_SIDCART_SETTINGS,    N_("SID cart settings") },
         { IDS_SIDCART_SETTINGS_DA, "SID-cartridgeindstillinger" },
         { IDS_SIDCART_SETTINGS_DE, "SID Modul Einstellungen" },
         { IDS_SIDCART_SETTINGS_FR, "" },             
         { IDS_SIDCART_SETTINGS_HU, "SID krtya belltsai..." },
         { IDS_SIDCART_SETTINGS_IT, "Impostazioni cartuccia SID" },
         { IDS_SIDCART_SETTINGS_NL, "SID-cartinstellingen" },
         { IDS_SIDCART_SETTINGS_PL, "" },             
         { IDS_SIDCART_SETTINGS_SV, "SID-modulinstllningarg" },
         { IDS_SIDCART_SETTINGS_TR, "SID kartuu ayarlar" },

         { IDS_LOAD_FLIP_LIST_FILE,    N_("Load flip list file") },
         { IDS_LOAD_FLIP_LIST_FILE_DA, "Indls bladrelistefil" },
         { IDS_LOAD_FLIP_LIST_FILE_DE, "Fliplist Datei Laden" },
         { IDS_LOAD_FLIP_LIST_FILE_FR, "Charger un fichier de groupement de disques" },
         { IDS_LOAD_FLIP_LIST_FILE_HU, "Lemezlista betltse" },
         { IDS_LOAD_FLIP_LIST_FILE_IT, "Carica il file della fliplist" },
         { IDS_LOAD_FLIP_LIST_FILE_NL, "Laad fliplijstbestand" },
         { IDS_LOAD_FLIP_LIST_FILE_PL, "" },             
         { IDS_LOAD_FLIP_LIST_FILE_SV, "Ls vallistefil" },
         { IDS_LOAD_FLIP_LIST_FILE_TR, "Sralama listesi dosyasn ykle" },

         { IDS_CANNOT_READ_FLIP_LIST,    N_("Cannot read flip list file") },
         { IDS_CANNOT_READ_FLIP_LIST_DA, "Kunne ikke lse bladrelistefil" },
         { IDS_CANNOT_READ_FLIP_LIST_DE, "Lesen von Fliplist Datei fehlgeschlagen" },
         { IDS_CANNOT_READ_FLIP_LIST_FR, "" },             
         { IDS_CANNOT_READ_FLIP_LIST_HU, "Nem lehet olvasni a lemezlista fjlt" },
         { IDS_CANNOT_READ_FLIP_LIST_IT, "Non  possibile caricare il file della flip list" },
         { IDS_CANNOT_READ_FLIP_LIST_NL, "Kan het fliplijstbestand niet lezen" },
         { IDS_CANNOT_READ_FLIP_LIST_PL, "" },             
         { IDS_CANNOT_READ_FLIP_LIST_SV, "Kunde inte lsa vallistefil" },
         { IDS_CANNOT_READ_FLIP_LIST_TR, "Sralama listesi dosyas okunamad." },

         { IDS_SAVE_FLIP_LIST_FILE,    N_("Save flip list file") },
         { IDS_SAVE_FLIP_LIST_FILE_DA, "Gem bladrelistefil" },
         { IDS_SAVE_FLIP_LIST_FILE_DE, "Fliplist Datei Speichern" },
         { IDS_SAVE_FLIP_LIST_FILE_FR, "Enregistrer le fichier de groupement de disques actuel" },
         { IDS_SAVE_FLIP_LIST_FILE_HU, "Lemezlista mentse fjlba" },
         { IDS_SAVE_FLIP_LIST_FILE_IT, "Salva il file della fliplist" },
         { IDS_SAVE_FLIP_LIST_FILE_NL, "Fliplijstbestand opslaan" },
         { IDS_SAVE_FLIP_LIST_FILE_PL, "" },             
         { IDS_SAVE_FLIP_LIST_FILE_SV, "Spara vallistefil" },
         { IDS_SAVE_FLIP_LIST_FILE_TR, "Sralama listesi dosyasn kaydet" },

         { IDS_CANNOT_WRITE_FLIP_LIST,    N_("Cannot write flip list file") },
         { IDS_CANNOT_WRITE_FLIP_LIST_DA, "Kunne ikke skrive bladrelistefil" },
         { IDS_CANNOT_WRITE_FLIP_LIST_DE, "Schreiben von Fliplist Datei fehlgeschlagen" },
         { IDS_CANNOT_WRITE_FLIP_LIST_FR, "Impossible d'crire le fichier de groupement de disques" },
         { IDS_CANNOT_WRITE_FLIP_LIST_HU, "Nem sikerlt a lemezlistt fjlba rni" },
         { IDS_CANNOT_WRITE_FLIP_LIST_IT, "Non  possibile scrivere il file della flip list" },
         { IDS_CANNOT_WRITE_FLIP_LIST_NL, "Kan fliplijstbestand niet schrijven" },
         { IDS_CANNOT_WRITE_FLIP_LIST_PL, "" },             
         { IDS_CANNOT_WRITE_FLIP_LIST_SV, "Kan inte skriva vallistefil" },
         { IDS_CANNOT_WRITE_FLIP_LIST_TR, "Sralama listesi dosyas yazlamad" },

         { IDS_ATTACH_FUNCTION_LOW_CART,    N_("Attach cartridge image for Function Low") },
         { IDS_ATTACH_FUNCTION_LOW_CART_DA, "Tilslut cartridge for Function Lav" },
         { IDS_ATTACH_FUNCTION_LOW_CART_DE, "Funktions ROM (low) Erweiterungsmodul einlegen" },
         { IDS_ATTACH_FUNCTION_LOW_CART_FR, "Insrer une cartouche Fonction basse" },
         { IDS_ATTACH_FUNCTION_LOW_CART_HU, "Cartridge kpms csatolsa Function Low-hoz" },
         { IDS_ATTACH_FUNCTION_LOW_CART_IT, "Seleziona l'immagine di una cartuccia per la Function Low" },
         { IDS_ATTACH_FUNCTION_LOW_CART_NL, "Koppel cartridgebestand voor 'Function Low'" },
         { IDS_ATTACH_FUNCTION_LOW_CART_PL, "" },             
         { IDS_ATTACH_FUNCTION_LOW_CART_SV, "Anslut insticksmodulfil fr funktion lg" },
         { IDS_ATTACH_FUNCTION_LOW_CART_TR, "Function Low iin kartu imaj yerletirin" },

         { IDS_ATTACH_FUNCTION_HIGH_CART,    N_("Attach cartridge image for Function High") },
         { IDS_ATTACH_FUNCTION_HIGH_CART_DA, "Tilslut cartridge for Function Hj" },
         { IDS_ATTACH_FUNCTION_HIGH_CART_DE, "Funktions ROM (high) Erweiterungsmodul einlegen" },
         { IDS_ATTACH_FUNCTION_HIGH_CART_FR, "Insrer une cartouche Fonction haute" },
         { IDS_ATTACH_FUNCTION_HIGH_CART_HU, "Cartridge kpms csatolsa Function High-hez" },
         { IDS_ATTACH_FUNCTION_HIGH_CART_IT, "Seleziona l'immagine di una cartuccia per la Function High" },
         { IDS_ATTACH_FUNCTION_HIGH_CART_NL, "Koppel cartridgebestand voor 'Function High'" },
         { IDS_ATTACH_FUNCTION_HIGH_CART_PL, "" },             
         { IDS_ATTACH_FUNCTION_HIGH_CART_SV, "Anslut insticksmodulfil fr funktion hg" },
         { IDS_ATTACH_FUNCTION_HIGH_CART_TR, "Function High iin kartu imaj yerletirin" },

         { IDS_ATTACH_CART1_LOW,    N_("Attach cartridge image for Cartridge1 Low") },
         { IDS_ATTACH_CART1_LOW_DA, "Tilslut cartridge image for Cartridge1 Lav" },
         { IDS_ATTACH_CART1_LOW_DE, "Cartridge1 (low) Erweiterungsmodul einlegen" },
         { IDS_ATTACH_CART1_LOW_FR, "Insrer une cartouche pour Cartouche1 basse" },
         { IDS_ATTACH_CART1_LOW_HU, "Cartridge kpms csatolsa als Cartridge1-hez" },
         { IDS_ATTACH_CART1_LOW_IT, "Seleziona l'immagine di una cartuccia per la Cartridge1 Low" },
         { IDS_ATTACH_CART1_LOW_NL, "Koppel cartridgebestand voor 'Cartridge1 Low'" },
         { IDS_ATTACH_CART1_LOW_PL, "" },             
         { IDS_ATTACH_CART1_LOW_SV, "Anslut insticksmodulfil fr modul1 lg" },
         { IDS_ATTACH_CART1_LOW_TR, "Kartu1 Low iin kartu imaj yerletirin" },

         { IDS_ATTACH_CART1_HIGH,    N_("Attach cartridge image for Cartridge1 High") },
         { IDS_ATTACH_CART1_HIGH_DA, "Tilslut cartridge image for Cartridge1 Hj" },
         { IDS_ATTACH_CART1_HIGH_DE, "Cartridge1 (high) Erweiterungsmodul einlegen" },
         { IDS_ATTACH_CART1_HIGH_FR, "Insrer une cartouche pour Cartouche1 haute" },
         { IDS_ATTACH_CART1_HIGH_HU, "Cartridge kpms csatolsa fels Cartridge1-hez" },
         { IDS_ATTACH_CART1_HIGH_IT, "Seleziona l'immagine di una cartuccia per la Cartridge1 High" },
         { IDS_ATTACH_CART1_HIGH_NL, "Koppel cartridgebestand voor 'Cartridge1 High'" },
         { IDS_ATTACH_CART1_HIGH_PL, "" },             
         { IDS_ATTACH_CART1_HIGH_SV, "Anslut insticksmodulfil fr modul1 hg" },
         { IDS_ATTACH_CART1_HIGH_TR, "Kartu1 High iin kartu imaj yerletirin" },

         { IDS_ATTACH_CART2_LOW,    N_("Attach cartridge image for Cartridge2 Low") },
         { IDS_ATTACH_CART2_LOW_DA, "Tilslut cartridge image for Cartridge2 Lav" },
         { IDS_ATTACH_CART2_LOW_DE, "Cartridge2 (low) Erweiterungsmodul einlegen" },
         { IDS_ATTACH_CART2_LOW_FR, "Insrer une cartouche pour Cartouche2 basse" },
         { IDS_ATTACH_CART2_LOW_HU, "Cartridge kpms csatolsa als Cartridge2-hz" },
         { IDS_ATTACH_CART2_LOW_IT, "Seleziona l'immagine di una cartuccia per la Cartridge2 Low" },
         { IDS_ATTACH_CART2_LOW_NL, "Koppel cartridgebestand voor 'Cartridge2 Low'" },
         { IDS_ATTACH_CART2_LOW_PL, "" },             
         { IDS_ATTACH_CART2_LOW_SV, "Anslut insticksmodulfil fr modul2 lg" },
         { IDS_ATTACH_CART2_LOW_TR, "Kartu2 Low iin kartu imaj yerletirin" },

         { IDS_ATTACH_CART2_HIGH,    N_("Attach cartridge image for Cartridge2 High") },
         { IDS_ATTACH_CART2_HIGH_DA, "Tilslut cartridge image for Cartridge2 Hj" },
         { IDS_ATTACH_CART2_HIGH_DE, "Cartridge2 (high) Erweiterungsmodul einlegen" },
         { IDS_ATTACH_CART2_HIGH_FR, "Insrer une cartouche pour Cartouche2 haute" },
         { IDS_ATTACH_CART2_HIGH_HU, "Cartridge kpms csatolsa fels Cartridge2-hz" },
         { IDS_ATTACH_CART2_HIGH_IT, "Seleziona l'immagine di una cartuccia per la Cartridge2 High" },
         { IDS_ATTACH_CART2_HIGH_NL, "Koppel cartridgebestand voor 'Cartridge2 High'" },
         { IDS_ATTACH_CART2_HIGH_PL, "" },             
         { IDS_ATTACH_CART2_HIGH_SV, "Anslut insticksmodulfil fr modul2 hg" },
         { IDS_ATTACH_CART2_HIGH_TR, "Kartu2 High iin kartu imaj yerletirin" },

         { IDS_SAVE_SNAPSHOT_IMAGE,    N_("Save snapshot image") },
         { IDS_SAVE_SNAPSHOT_IMAGE_DA, "Gem snapshot" },
         { IDS_SAVE_SNAPSHOT_IMAGE_DE, "Snapshot Datei speichern" },
         { IDS_SAVE_SNAPSHOT_IMAGE_FR, "Enregistrer le fichier de sauvegarde" },
         { IDS_SAVE_SNAPSHOT_IMAGE_HU, "Pillanatkp fjl mentse" },
         { IDS_SAVE_SNAPSHOT_IMAGE_IT, "Salva l'immagine dello snapshot" },
         { IDS_SAVE_SNAPSHOT_IMAGE_NL, "Momentopnamebestand opslaan" },
         { IDS_SAVE_SNAPSHOT_IMAGE_PL, "" },             
         { IDS_SAVE_SNAPSHOT_IMAGE_SV, "Spara gonblicksbildfil" },
         { IDS_SAVE_SNAPSHOT_IMAGE_TR, "Anlk grnt imajn kaydet" },

         { IDS_LOAD_SNAPSHOT_IMAGE,    N_("Load snapshot image") },
         { IDS_LOAD_SNAPSHOT_IMAGE_DA, "Indls snapshot" },
         { IDS_LOAD_SNAPSHOT_IMAGE_DE, "Snapshot laden" },
         { IDS_LOAD_SNAPSHOT_IMAGE_FR, "Charger le fichier de sauvegarde" },
         { IDS_LOAD_SNAPSHOT_IMAGE_HU, "Pillanatkp betltse" },
         { IDS_LOAD_SNAPSHOT_IMAGE_IT, "Carica immagine dello snapshot" },
         { IDS_LOAD_SNAPSHOT_IMAGE_NL, "Laad momentopnamebestand" },
         { IDS_LOAD_SNAPSHOT_IMAGE_PL, "" },             
         { IDS_LOAD_SNAPSHOT_IMAGE_SV, "Lser in gonblicksbild" },
         { IDS_LOAD_SNAPSHOT_IMAGE_TR, "Anlk grnt imajn ykle" },

         { IDS_SAVE_CURRENTLY_ATTACHED_DISKS,    N_("Save currently attached disk images") },
         { IDS_SAVE_CURRENTLY_ATTACHED_DISKS_DA, "Gem tilsluttede disk-images" },
         { IDS_SAVE_CURRENTLY_ATTACHED_DISKS_DE, "Aktuell eingelegte Diskimages speichern" },
         { IDS_SAVE_CURRENTLY_ATTACHED_DISKS_FR, "Sauvegarder les disques prsentement insrs" },
         { IDS_SAVE_CURRENTLY_ATTACHED_DISKS_HU, "A jelenleg csatolt lemezek mentse" },
         { IDS_SAVE_CURRENTLY_ATTACHED_DISKS_IT, "Salva le immagini dei dischi attualmente selezionati" },
         { IDS_SAVE_CURRENTLY_ATTACHED_DISKS_NL, "Opslaan huidige gekoppelde schijfbestanden" },
         { IDS_SAVE_CURRENTLY_ATTACHED_DISKS_PL, "" },             
         { IDS_SAVE_CURRENTLY_ATTACHED_DISKS_SV, "Spara anslutna disketter diskettavbildningar" },
         { IDS_SAVE_CURRENTLY_ATTACHED_DISKS_TR, "Halihazrda yerletirilmi disk imajlarn kaydet" },

         { IDS_SAVE_CURRENTLY_ATTACHED_ROMS,    N_("Save currently loaded ROM images") },
         { IDS_SAVE_CURRENTLY_ATTACHED_ROMS_DA, "Gem tilsluttede ROM-images" },
         { IDS_SAVE_CURRENTLY_ATTACHED_ROMS_DE, "Aktuelle ROMs speichern" },
         { IDS_SAVE_CURRENTLY_ATTACHED_ROMS_FR, "Sauvegarder les images ROM prsentement chargs" },
         { IDS_SAVE_CURRENTLY_ATTACHED_ROMS_HU, "A jelenleg betlttt ROM-ok mentse" },
         { IDS_SAVE_CURRENTLY_ATTACHED_ROMS_IT, "Salva le immagini delle ROM attualmente caricate" },
         { IDS_SAVE_CURRENTLY_ATTACHED_ROMS_NL, "Opslaan huidig gekoppelde ROMs" },
         { IDS_SAVE_CURRENTLY_ATTACHED_ROMS_PL, "" },             
         { IDS_SAVE_CURRENTLY_ATTACHED_ROMS_SV, "Spara lsta ROM-avbildningar" },
         { IDS_SAVE_CURRENTLY_ATTACHED_ROMS_TR, "Halihazrda yklenmi ROM imajlarn kaydet" },

         { IDS_CANNOT_WRITE_SNAPSHOT_S,    N_("Cannot write snapshot file `%s'.") },
         { IDS_CANNOT_WRITE_SNAPSHOT_S_DA, "Kunne ikke gemme snapshot \"%s\"." },
         { IDS_CANNOT_WRITE_SNAPSHOT_S_DE, "Kann Snapshot Datei `%s' nicht speichern." },
         { IDS_CANNOT_WRITE_SNAPSHOT_S_FR, "" },             
         { IDS_CANNOT_WRITE_SNAPSHOT_S_HU, "Nem sikerlt a pillanatkp rsa %s fjlba." },
         { IDS_CANNOT_WRITE_SNAPSHOT_S_IT, "Non  possibile scrivere il file di snapshot `%s'." },
         { IDS_CANNOT_WRITE_SNAPSHOT_S_NL, "Kan momentopnamebestand `%s' niet schrijven." },
         { IDS_CANNOT_WRITE_SNAPSHOT_S_PL, "" },             
         { IDS_CANNOT_WRITE_SNAPSHOT_S_SV, "Kan inte skriva gonblicksbildfil \"%s\"." },
         { IDS_CANNOT_WRITE_SNAPSHOT_S_TR, "Anlk grnt dosyas yazlamad `%s'." },

         { IDS_CANNOT_READ_SNAPSHOT_IMG,    N_("Cannot read snapshot image") },
         { IDS_CANNOT_READ_SNAPSHOT_IMG_DA, "Kunne ikke indlse snapshot fil" },
         { IDS_CANNOT_READ_SNAPSHOT_IMG_DE, "Kann Snapshot Datei nicht laden" },
         { IDS_CANNOT_READ_SNAPSHOT_IMG_FR, "Impossible de charger l'instantan." },
         { IDS_CANNOT_READ_SNAPSHOT_IMG_HU, "A pillanatkp fjl nem olvashat" },
         { IDS_CANNOT_READ_SNAPSHOT_IMG_IT, "Non  possibile leggere l'immagine dello snapshot" },
         { IDS_CANNOT_READ_SNAPSHOT_IMG_NL, "Kan momentopname bestand niet lezen" },
         { IDS_CANNOT_READ_SNAPSHOT_IMG_PL, "" },             
         { IDS_CANNOT_READ_SNAPSHOT_IMG_SV, "Kan inte lsa in gonblicksbildfil" },
         { IDS_CANNOT_READ_SNAPSHOT_IMG_TR, "Anlk grnt dosyas okunamad." },

         { IDS_SNAPSHOT_FILE,    N_("snapshot file") },
         { IDS_SNAPSHOT_FILE_DA, "snapshot-fil" },
         { IDS_SNAPSHOT_FILE_DE, "Snapshot Datei" },
         { IDS_SNAPSHOT_FILE_FR, "Fichier de sauvegarde" },
         { IDS_SNAPSHOT_FILE_HU, "pillanatkp fjl" },
         { IDS_SNAPSHOT_FILE_IT, "File di snapshot" },
         { IDS_SNAPSHOT_FILE_NL, "momentopnamebestand" },
         { IDS_SNAPSHOT_FILE_PL, "" },             
         { IDS_SNAPSHOT_FILE_SV, "gonblicksbildfil" },
         { IDS_SNAPSHOT_FILE_TR, "Anlk grnt dosyas" },

         { IDS_SELECT_SNAPSHOT_FILE,    N_("Select snapshot file") },
         { IDS_SELECT_SNAPSHOT_FILE_DA, "Vlg snapshot-fil" },
         { IDS_SELECT_SNAPSHOT_FILE_DE, "Snapshot Datei whlen" },
         { IDS_SELECT_SNAPSHOT_FILE_FR, "Slectionner le fichier de sauvegarde" },
         { IDS_SELECT_SNAPSHOT_FILE_HU, "Vlasszon pillanatkp fjlt" },
         { IDS_SELECT_SNAPSHOT_FILE_IT, "Seleziona il file di snapshot" },
         { IDS_SELECT_SNAPSHOT_FILE_NL, "Selecteer momentopnamebestand" },
         { IDS_SELECT_SNAPSHOT_FILE_PL, "" },             
         { IDS_SELECT_SNAPSHOT_FILE_SV, "Vlj gonblicksbildfil" },
         { IDS_SELECT_SNAPSHOT_FILE_TR, "Anlk grnt dosyas sein" },

         { IDS_EXTERNAL_PALETTE_SELECT,    N_("Select External Palette file") },
         { IDS_EXTERNAL_PALETTE_SELECT_DA, "Brug ekstern palette-fil" },
         { IDS_EXTERNAL_PALETTE_SELECT_DE, "Benutze externe Palette (Datei)" },
         { IDS_EXTERNAL_PALETTE_SELECT_FR, "" },             
         { IDS_EXTERNAL_PALETTE_SELECT_HU, "Vlasszon kls paletta fjlt" },
         { IDS_EXTERNAL_PALETTE_SELECT_IT, "Seleziona il file per la palette esterna" },
         { IDS_EXTERNAL_PALETTE_SELECT_NL, "Selecteer extern paletbestand" },
         { IDS_EXTERNAL_PALETTE_SELECT_PL, "" },             
         { IDS_EXTERNAL_PALETTE_SELECT_SV, "Anvnd en extern palett (fil)" },
         { IDS_EXTERNAL_PALETTE_SELECT_TR, "Harici Palet dosyas sein" },

         { IDS_GAMMA_0_2,    N_("Gamma (0..2)") },
         { IDS_GAMMA_0_2_DA, "Gamma (0..2)" },
         { IDS_GAMMA_0_2_DE, "Gamma (0..2)" },
         { IDS_GAMMA_0_2_FR, "Gamma (0..2)" },
         { IDS_GAMMA_0_2_HU, "Gamma (0..2)" },
         { IDS_GAMMA_0_2_IT, "Gamma (0..2)" },
         { IDS_GAMMA_0_2_NL, "Gamma (0..2)" },
         { IDS_GAMMA_0_2_PL, "" },             
         { IDS_GAMMA_0_2_SV, "Gamma (0..2)" },
         { IDS_GAMMA_0_2_TR, "Gama (0..2)" },

         { IDS_PAL_SHADE_0_1,    N_("PAL Shade (0..1)") },
         { IDS_PAL_SHADE_0_1_DA, "Skanlinjeskygge (0..1)" },
         { IDS_PAL_SHADE_0_1_DE, "PAL Schatten (0..1)" },
         { IDS_PAL_SHADE_0_1_FR, "Ombrage PAL (0..1)" },
         { IDS_PAL_SHADE_0_1_HU, "PAL pszta rnyals (0..1)" },
         { IDS_PAL_SHADE_0_1_IT, "Ombra PAL (0..1)" },
         { IDS_PAL_SHADE_0_1_NL, "PAL-Schaduw (0..1)" },
         { IDS_PAL_SHADE_0_1_PL, "" },             
         { IDS_PAL_SHADE_0_1_SV, "PAL-skuggning (0..1)" },
         { IDS_PAL_SHADE_0_1_TR, "PAL Nans (0..1)" },

         { IDS_PAL_BLUR_0_1,    N_("PAL Blur (0..1)") },
         { IDS_PAL_BLUR_0_1_DA, "PAL-udtvring (0..1)" },
         { IDS_PAL_BLUR_0_1_DE, "PAL Unschrfe (0..1)" },
         { IDS_PAL_BLUR_0_1_FR, "Flou PAL (0..1)" },
         { IDS_PAL_BLUR_0_1_HU, "PAL elmoss (0..1)" },
         { IDS_PAL_BLUR_0_1_IT, "Sfuocatura PAL (0..1)" },
         { IDS_PAL_BLUR_0_1_NL, "PAL-Wazigheid (0..1)" },
         { IDS_PAL_BLUR_0_1_PL, "" },             
         { IDS_PAL_BLUR_0_1_SV, "PAL-suddighet (0..1)" },
         { IDS_PAL_BLUR_0_1_TR, "PAL Bulankl (0..1)" },

         { IDS_NEW_PAL_TINT_0_2,    N_("Tint (0..2)") },
         { IDS_NEW_PAL_TINT_0_2_DA, "Farvetone (0..2)" },
         { IDS_NEW_PAL_TINT_0_2_DE, "Farbton (0..2)" },
         { IDS_NEW_PAL_TINT_0_2_FR, "" },             
         { IDS_NEW_PAL_TINT_0_2_HU, "Szn (0..2)" },
         { IDS_NEW_PAL_TINT_0_2_IT, "Sfumatura (0..2)" },
         { IDS_NEW_PAL_TINT_0_2_NL, "Tint (0..2)" },
         { IDS_NEW_PAL_TINT_0_2_PL, "" },             
         { IDS_NEW_PAL_TINT_0_2_SV, "Frgton (0..2)" },
         { IDS_NEW_PAL_TINT_0_2_TR, "Ton (0..2)" },

         { IDS_NEW_PAL_PHASE_0_2,    N_("Odd Lines Phase (0..2)") },
         { IDS_NEW_PAL_PHASE_0_2_DA, "Fase for ulige linjer (0..2)" },
         { IDS_NEW_PAL_PHASE_0_2_DE, "Ungerade Zeilenphase (0..2)" },
         { IDS_NEW_PAL_PHASE_0_2_FR, "" },             
         { IDS_NEW_PAL_PHASE_0_2_HU, "Pratlan sorok fzisa (0..2)" },
         { IDS_NEW_PAL_PHASE_0_2_IT, "Fase linee dispari (0..2)" },
         { IDS_NEW_PAL_PHASE_0_2_NL, "Oneven lijnen fase (0..2)" },
         { IDS_NEW_PAL_PHASE_0_2_PL, "" },             
         { IDS_NEW_PAL_PHASE_0_2_SV, "Fas fr udda linjer (0..2)" },
         { IDS_NEW_PAL_PHASE_0_2_TR, "Tek Satrlar Faz (0..2)" },

         { IDS_NEW_PAL_OFFSET_0_2,    N_("Odd Lines Offset (0..2)") },
         { IDS_NEW_PAL_OFFSET_0_2_DA, "Offset for ulige linjer (0..2)" },
         { IDS_NEW_PAL_OFFSET_0_2_DE, "Ungerader Zeilenoffset (0..2)" },
         { IDS_NEW_PAL_OFFSET_0_2_FR, "" },             
         { IDS_NEW_PAL_OFFSET_0_2_HU, "Pratlan sorok offszetje (0..2)" },
         { IDS_NEW_PAL_OFFSET_0_2_IT, "Offset linee dispari (0..2)" },
         { IDS_NEW_PAL_OFFSET_0_2_NL, "Oneven lijnen compensatie (0..2)" },
         { IDS_NEW_PAL_OFFSET_0_2_PL, "" },             
         { IDS_NEW_PAL_OFFSET_0_2_SV, "Utjmning fr udda linjer (0..2)" },
         { IDS_NEW_PAL_OFFSET_0_2_TR, "Tek Satrlar Ofseti (0..2)" },

         { IDS_EXTERNAL_PALETTE,    N_("External Palette") },
         { IDS_EXTERNAL_PALETTE_DA, "Ekstern palette" },
         { IDS_EXTERNAL_PALETTE_DE, "Externe Palette" },
         { IDS_EXTERNAL_PALETTE_FR, "Palette externe" },
         { IDS_EXTERNAL_PALETTE_HU, "Kls sznkszlet" },
         { IDS_EXTERNAL_PALETTE_IT, "Palette esterna" },
         { IDS_EXTERNAL_PALETTE_NL, "Extern Palet" },
         { IDS_EXTERNAL_PALETTE_PL, "" },             
         { IDS_EXTERNAL_PALETTE_SV, "Extern palett" },
         { IDS_EXTERNAL_PALETTE_TR, "Harici Palet" },

         { IDS_PALETTE_FILENAME,    N_("Palette file") },
         { IDS_PALETTE_FILENAME_DA, "Palettefil" },
         { IDS_PALETTE_FILENAME_DE, "Palette Datei" },
         { IDS_PALETTE_FILENAME_FR, "Fichiers de palette" },
         { IDS_PALETTE_FILENAME_HU, "Paletta fjl" },
         { IDS_PALETTE_FILENAME_IT, "File di palette" },
         { IDS_PALETTE_FILENAME_NL, "Paletbestand" },
         { IDS_PALETTE_FILENAME_PL, "" },             
         { IDS_PALETTE_FILENAME_SV, "Palettfiler" },
         { IDS_PALETTE_FILENAME_TR, "Palet dosyas" },

         { IDS_SATURATION_0_2,    N_("Saturation (0..2)") },
         { IDS_SATURATION_0_2_DA, "Mtning (0..2)" },
         { IDS_SATURATION_0_2_DE, "Sttigung (0..2)" },
         { IDS_SATURATION_0_2_FR, "Saturation (0..2)" },
         { IDS_SATURATION_0_2_HU, "Teltettsg (0..2)" },
         { IDS_SATURATION_0_2_IT, "Saturazione (0..2)" },
         { IDS_SATURATION_0_2_NL, "Verzadiging (0..2)" },
         { IDS_SATURATION_0_2_PL, "" },             
         { IDS_SATURATION_0_2_SV, "Mttnad (0..2)" },
         { IDS_SATURATION_0_2_TR, "Doygunluk (0..2)" },

         { IDS_CONTRAST_0_2,    N_("Contrast (0..2)") },
         { IDS_CONTRAST_0_2_DA, "Kontrast (0..2)" },
         { IDS_CONTRAST_0_2_DE, "Kontrast (0..2)" },
         { IDS_CONTRAST_0_2_FR, "Contraste (0..2)" },
         { IDS_CONTRAST_0_2_HU, "Kontraszt (0..2)" },
         { IDS_CONTRAST_0_2_IT, "Contrasto (0..2)" },
         { IDS_CONTRAST_0_2_NL, "Contrast (0..2)" },
         { IDS_CONTRAST_0_2_PL, "" },             
         { IDS_CONTRAST_0_2_SV, "Kontrast (0..2)" },
         { IDS_CONTRAST_0_2_TR, "Kartlk (0..2)" },

         { IDS_BRIGHTNESS_0_2,    N_("Brightness (0..2)") },
         { IDS_BRIGHTNESS_0_2_DA, "Lysstyrke (0..2)" },
         { IDS_BRIGHTNESS_0_2_DE, "Helligkeit (0..2)" },
         { IDS_BRIGHTNESS_0_2_FR, "Luminosit (0..2)" },
         { IDS_BRIGHTNESS_0_2_HU, "Fnyessg (0..2)" },
         { IDS_BRIGHTNESS_0_2_IT, "Luminosit (0..2)" },
         { IDS_BRIGHTNESS_0_2_NL, "Helderheid (0..2)" },
         { IDS_BRIGHTNESS_0_2_PL, "" },             
         { IDS_BRIGHTNESS_0_2_SV, "Ljusstyrka (0..2)" },
         { IDS_BRIGHTNESS_0_2_TR, "Parlaklk (0..2)" },

         { IDS_VIDEO_SETTINGS,    N_("Video settings") },
         { IDS_VIDEO_SETTINGS_DA, "Grafikindstillinger" },
         { IDS_VIDEO_SETTINGS_DE, "Video Einstellungen" },
         { IDS_VIDEO_SETTINGS_FR, "Paramtres vido" },
         { IDS_VIDEO_SETTINGS_HU, "Vide belltsai" },
         { IDS_VIDEO_SETTINGS_IT, "Impostazioni video" },
         { IDS_VIDEO_SETTINGS_NL, "Videoinstellingen" },
         { IDS_VIDEO_SETTINGS_PL, "" },             
         { IDS_VIDEO_SETTINGS_SV, "Grafikinstllningar" },
         { IDS_VIDEO_SETTINGS_TR, "Grnt ayarlar" },

         { IDS_VICII_PALETTE_FILENAME,    N_("VICII Palette file") },
         { IDS_VICII_PALETTE_FILENAME_DA, "Indls VICII-palettefil" },
         { IDS_VICII_PALETTE_FILENAME_DE, "VICII Paletten Datei" },
         { IDS_VICII_PALETTE_FILENAME_FR, "Fichier de palette VICII" },
         { IDS_VICII_PALETTE_FILENAME_HU, "VICII paletta fjl" },
         { IDS_VICII_PALETTE_FILENAME_IT, "File di palette VICII" },
         { IDS_VICII_PALETTE_FILENAME_NL, "VICII paletbestand" },
         { IDS_VICII_PALETTE_FILENAME_PL, "" },             
         { IDS_VICII_PALETTE_FILENAME_SV, "Ls in VICII-palettfil" },
         { IDS_VICII_PALETTE_FILENAME_TR, "VICII Palet dosyas" },

         { IDS_VDC_PALETTE_FILENAME,    N_("VDC Palette file") },
         { IDS_VDC_PALETTE_FILENAME_DA, "Indls VDC-palettefil" },
         { IDS_VDC_PALETTE_FILENAME_DE, "VDC Paletten Datei" },
         { IDS_VDC_PALETTE_FILENAME_FR, "Fichier de palette VDC" },
         { IDS_VDC_PALETTE_FILENAME_HU, "VDC paletta fjl" },
         { IDS_VDC_PALETTE_FILENAME_IT, "File di palette VDC" },
         { IDS_VDC_PALETTE_FILENAME_NL, "VDC-paletbestand" },
         { IDS_VDC_PALETTE_FILENAME_PL, "" },             
         { IDS_VDC_PALETTE_FILENAME_SV, "Ls in VDC-palettfil" },
         { IDS_VDC_PALETTE_FILENAME_TR, "VDC Palet dosyas" },

         { IDS_AUTO_FROM_ROM,    N_("Auto (from ROM)") },
         { IDS_AUTO_FROM_ROM_DA, "Automatisk (fra ROM)" },
         { IDS_AUTO_FROM_ROM_DE, "Automatisch (von ROM)" },
         { IDS_AUTO_FROM_ROM_FR, "" },             
         { IDS_AUTO_FROM_ROM_HU, "Automatikus (ROM-bl)" },
         { IDS_AUTO_FROM_ROM_IT, "Auto (dalla ROM)" },
         { IDS_AUTO_FROM_ROM_NL, "Automatisch (van ROM)" },
         { IDS_AUTO_FROM_ROM_PL, "" },             
         { IDS_AUTO_FROM_ROM_SV, "Automatisk (frn ROM)" },
         { IDS_AUTO_FROM_ROM_TR, "Otomatik (ROM'dan)" },

         { IDS_40_COLUMNS,    N_("40 Columns") },
         { IDS_40_COLUMNS_DA, "40 kolonner" },
         { IDS_40_COLUMNS_DE, "40 Spalten" },
         { IDS_40_COLUMNS_FR, "" },             
         { IDS_40_COLUMNS_HU, "40 Oszlop" },
         { IDS_40_COLUMNS_IT, "40 Colonne" },
         { IDS_40_COLUMNS_NL, "40 Kolommen" },
         { IDS_40_COLUMNS_PL, "" },             
         { IDS_40_COLUMNS_SV, "40 kolumner" },
         { IDS_40_COLUMNS_TR, "40 Stun" },

         { IDS_80_COLUMNS,    N_("80 Columns") },
         { IDS_80_COLUMNS_DA, "80 kolonner" },
         { IDS_80_COLUMNS_DE, "80 Spalten" },
         { IDS_80_COLUMNS_FR, "" },             
         { IDS_80_COLUMNS_HU, "80 Oszlop" },
         { IDS_80_COLUMNS_IT, "80 Colonne" },
         { IDS_80_COLUMNS_NL, "80 Kolommen" },
         { IDS_80_COLUMNS_PL, "" },             
         { IDS_80_COLUMNS_SV, "80 kolumner" },
         { IDS_80_COLUMNS_TR, "80 Stun" },

         { IDS_256_BYTE,    N_("256 Byte") },
         { IDS_256_BYTE_DA, "256 byte" },
         { IDS_256_BYTE_DE, "256 Byte" },
         { IDS_256_BYTE_FR, "" },             
         { IDS_256_BYTE_HU, "256 Bjt" },
         { IDS_256_BYTE_IT, "256 Byte" },
         { IDS_256_BYTE_NL, "256 Byte" },
         { IDS_256_BYTE_PL, "" },             
         { IDS_256_BYTE_SV, "256 byte" },
         { IDS_256_BYTE_TR, "256 Byte" },

         { IDS_2_KBYTE,    N_("2 kByte") },
         { IDS_2_KBYTE_DA, "2 kbyte" },
         { IDS_2_KBYTE_DE, "2 kByte" },
         { IDS_2_KBYTE_FR, "" },             
         { IDS_2_KBYTE_HU, "2 kBjt" },
         { IDS_2_KBYTE_IT, "2 kByte" },
         { IDS_2_KBYTE_NL, "2 kByte" },
         { IDS_2_KBYTE_PL, "" },             
         { IDS_2_KBYTE_SV, "2 kbyte" },
         { IDS_2_KBYTE_TR, "2 kByte" },

         { IDS_GRAPHICS,    N_("Graphics") },
         { IDS_GRAPHICS_DA, "Grafisk" },
         { IDS_GRAPHICS_DE, "Grafik" },
         { IDS_GRAPHICS_FR, "" },             
         { IDS_GRAPHICS_HU, "Grafikus" },
         { IDS_GRAPHICS_IT, "Grafica" },
         { IDS_GRAPHICS_NL, "Graphics" },
         { IDS_GRAPHICS_PL, "" },             
         { IDS_GRAPHICS_SV, "Grafisk" },
         { IDS_GRAPHICS_TR, "Grafikler" },

         { IDS_BUSINESS_UK,    N_("Business (UK)") },
         { IDS_BUSINESS_UK_DA, "Business (Storbritannien)" },
         { IDS_BUSINESS_UK_DE, "Business (UK)" },
         { IDS_BUSINESS_UK_FR, "" },             
         { IDS_BUSINESS_UK_HU, "Hivatalos (UK)" },
         { IDS_BUSINESS_UK_IT, "Business (UK)" },
         { IDS_BUSINESS_UK_NL, "Business (UK)" },
         { IDS_BUSINESS_UK_PL, "" },             
         { IDS_BUSINESS_UK_SV, "Business (Storbritannien)" },
         { IDS_BUSINESS_UK_TR, "Business (UK)" },

         { IDS_SET_PET_MODEL,    N_("Set PET Model") },
         { IDS_SET_PET_MODEL_DA, "Vlg PET-model" },
         { IDS_SET_PET_MODEL_DE, "Whle PET Modell" },
         { IDS_SET_PET_MODEL_FR, "" },             
         { IDS_SET_PET_MODEL_HU, "PET modell kivlasztsa" },
         { IDS_SET_PET_MODEL_IT, "Imposta modello di PET" },
         { IDS_SET_PET_MODEL_NL, "Stel PET-model in" },
         { IDS_SET_PET_MODEL_PL, "" },             
         { IDS_SET_PET_MODEL_SV, "Vlj PET-modell" },
         { IDS_SET_PET_MODEL_TR, "PET Modelini Belirle" },

         { IDS_MEMORY,    N_("Memory") },
         { IDS_MEMORY_DA, "Hukommelse" },
         { IDS_MEMORY_DE, "Speicher" },
         { IDS_MEMORY_FR, "Mmoire" },
         { IDS_MEMORY_HU, "Memria" },
         { IDS_MEMORY_IT, "Memoria" },
         { IDS_MEMORY_NL, "Geheugen" },
         { IDS_MEMORY_PL, "" },             
         { IDS_MEMORY_SV, "Minne" },
         { IDS_MEMORY_TR, "Bellek" },

         { IDS_VIDEO_SIZE,    N_("Video size") },
         { IDS_VIDEO_SIZE_DA, "Skrmbredde" },
         { IDS_VIDEO_SIZE_DE, "Videospeichergre" },
         { IDS_VIDEO_SIZE_FR, "Taille vido" },
         { IDS_VIDEO_SIZE_HU, "Vide mret" },
         { IDS_VIDEO_SIZE_IT, "Dimensione dello schermo" },
         { IDS_VIDEO_SIZE_NL, "Videogrootte" },
         { IDS_VIDEO_SIZE_PL, "" },             
         { IDS_VIDEO_SIZE_SV, "Skrmbredd" },
         { IDS_VIDEO_SIZE_TR, "Grnt boyutu" },

         { IDS_IO_SIZE,    N_("I/O size") },
         { IDS_IO_SIZE_DA, "I/O-strrelse" },
         { IDS_IO_SIZE_DE, "I/O Gre" },
         { IDS_IO_SIZE_FR, "Taille d'E/S" },
         { IDS_IO_SIZE_HU, "I/O mret" },
         { IDS_IO_SIZE_IT, "Dimensione di I/O" },
         { IDS_IO_SIZE_NL, "I/O-grootte" },
         { IDS_IO_SIZE_PL, "" },             
         { IDS_IO_SIZE_SV, "I/O-utrymme" },
         { IDS_IO_SIZE_TR, "G/ boyutu" },

         { IDS_KEYBOARD,    N_("Keyboard") },
         { IDS_KEYBOARD_DA, "Tastatur" },
         { IDS_KEYBOARD_DE, "Tastatur" },
         { IDS_KEYBOARD_FR, "" },             
         { IDS_KEYBOARD_HU, "Billentyzet" },
         { IDS_KEYBOARD_IT, "Tastiera" },
         { IDS_KEYBOARD_NL, "Toetsenbord" },
         { IDS_KEYBOARD_PL, "" },             
         { IDS_KEYBOARD_SV, "Tangentbord" },
         { IDS_KEYBOARD_TR, "Klavye" },

         { IDS_CRTC_CHIP,    N_("CRTC chip") },
         { IDS_CRTC_CHIP_DA, "CRTC-kreds" },
         { IDS_CRTC_CHIP_DE, "CRTC Chip" },
         { IDS_CRTC_CHIP_FR, "" },             
         { IDS_CRTC_CHIP_HU, "CRTC csip" },
         { IDS_CRTC_CHIP_IT, "Chip CRTC" },
         { IDS_CRTC_CHIP_NL, "CRTC-chip" },
         { IDS_CRTC_CHIP_PL, "" },             
         { IDS_CRTC_CHIP_SV, "CRTC-krets" },
         { IDS_CRTC_CHIP_TR, "CRTC ipi" },

         { IDS_SUPERPET_IO,    N_("SuperPET I/O enable (disables 8x96)") },
         { IDS_SUPERPET_IO_DA, "Aktivr SuperPET-I/O (ideaktiverer 8x96)" },
         { IDS_SUPERPET_IO_DE, "SuperPET I/O aktivieren (deaktiviert 8x96)" },
         { IDS_SUPERPET_IO_FR, "" },             
         { IDS_SUPERPET_IO_HU, "SuperPET I/O engedlyezse (8x96-ot tiltja)" },
         { IDS_SUPERPET_IO_IT, "Attiva I/O del SuperPET (disattiva 8x96)" },
         { IDS_SUPERPET_IO_NL, "SuperPET-I/O activeren (zet 8x96 uit)" },
         { IDS_SUPERPET_IO_PL, "" },             
         { IDS_SUPERPET_IO_SV, "Aktivera SuperPET-I/O (inaktiverar 8x96)" },
         { IDS_SUPERPET_IO_TR, "SuperPET G/ aktif et (8x96'y pasifletir)" },

         { IDS_9xxx_AS_RAM,    N_("$9*** as RAM") },
         { IDS_9xxx_AS_RAM_DA, "$9*** som RAM" },
         { IDS_9xxx_AS_RAM_DE, "$9*** als RAM" },
         { IDS_9xxx_AS_RAM_FR, "" },             
         { IDS_9xxx_AS_RAM_HU, "$9*** RAM-knt" },
         { IDS_9xxx_AS_RAM_IT, "$9*** come RAM" },
         { IDS_9xxx_AS_RAM_NL, "$9*** als RAM" },
         { IDS_9xxx_AS_RAM_PL, "" },             
         { IDS_9xxx_AS_RAM_SV, "$9*** som RAM" },
         { IDS_9xxx_AS_RAM_TR, "RAM olarak $9***" },

         { IDS_Axxx_AS_RAM,    N_("$A*** as RAM") },
         { IDS_Axxx_AS_RAM_DA, "$A*** som RAM" },
         { IDS_Axxx_AS_RAM_DE, "$A*** als RAM" },
         { IDS_Axxx_AS_RAM_FR, "" },             
         { IDS_Axxx_AS_RAM_HU, "$A*** RAM-knt" },
         { IDS_Axxx_AS_RAM_IT, "$A*** come RAM" },
         { IDS_Axxx_AS_RAM_NL, "$A*** als RAM" },
         { IDS_Axxx_AS_RAM_PL, "" },             
         { IDS_Axxx_AS_RAM_SV, "$A*** som RAM" },
         { IDS_Axxx_AS_RAM_TR, "RAM olarak $A***" },

         { IDS_PET_SETTINGS,    N_("PET settings") },
         { IDS_PET_SETTINGS_DA, "PET-indstillinger" },
         { IDS_PET_SETTINGS_DE, "PET Einstellungen" },
         { IDS_PET_SETTINGS_FR, "Paramtres PET" },
         { IDS_PET_SETTINGS_HU, "PET belltsai" },
         { IDS_PET_SETTINGS_IT, "Impostazioni PET" },
         { IDS_PET_SETTINGS_NL, "PET-instellingen" },
         { IDS_PET_SETTINGS_PL, "" },             
         { IDS_PET_SETTINGS_SV, "PET-instllningar" },
         { IDS_PET_SETTINGS_TR, "PET ayarlar" },

         { IDS_CURRENT_MODEL,    N_("Current Model") },
         { IDS_CURRENT_MODEL_DA, "Nuvrende model" },
         { IDS_CURRENT_MODEL_DE, "Aktuelles Modell" },
         { IDS_CURRENT_MODEL_FR, "" },             
         { IDS_CURRENT_MODEL_HU, "Jelenlegi modell" },
         { IDS_CURRENT_MODEL_IT, "Modello attuale" },
         { IDS_CURRENT_MODEL_NL, "Huidig model" },
         { IDS_CURRENT_MODEL_PL, "" },             
         { IDS_CURRENT_MODEL_SV, "Aktuell modell" },
         { IDS_CURRENT_MODEL_TR, "Geerli Model" },

         { IDS_PET_MODEL,    N_("PET Model") },
         { IDS_PET_MODEL_DA, "PET-model" },
         { IDS_PET_MODEL_DE, "PET Modell" },
         { IDS_PET_MODEL_FR, "" },             
         { IDS_PET_MODEL_HU, "PET modell" },
         { IDS_PET_MODEL_IT, "Modello PET" },
         { IDS_PET_MODEL_NL, "PET-model" },
         { IDS_PET_MODEL_PL, "" },             
         { IDS_PET_MODEL_SV, "PET-modell" },
         { IDS_PET_MODEL_TR, "PET Modeli" },

         { IDS_PLUS4_SETTINGS,    N_("PLUS4 settings") },
         { IDS_PLUS4_SETTINGS_DA, "PLUS4-indstillinger" },
         { IDS_PLUS4_SETTINGS_DE, "PLUS4 Einstellungen" },
         { IDS_PLUS4_SETTINGS_FR, "Paramtres PLUS4" },
         { IDS_PLUS4_SETTINGS_HU, "PLUS4 belltsai" },
         { IDS_PLUS4_SETTINGS_IT, "Impostazioni PLUS4" },
         { IDS_PLUS4_SETTINGS_NL, "PLUS4-instellingen" },
         { IDS_PLUS4_SETTINGS_PL, "" },             
         { IDS_PLUS4_SETTINGS_SV, "PLUS4-instllningar" },
         { IDS_PLUS4_SETTINGS_TR, "PLUS4 ayarlar" },

         { IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME,    N_("Select Internal Function ROM file") },
         { IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME_DA, "Vlg image for intern funktions-ROM" },
         { IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME_DE, "Internes Funktions ROM Image Datei auswhlen" },
         { IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME_FR, "" },             
         { IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME_HU, "Adja meg a bels Function ROM kpms nevt" },
         { IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME_IT, "Seleziona il file della function ROM interna" },
         { IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME_NL, "Selecteer Intern functie-ROM-bestand" },
         { IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME_PL, "" },             
         { IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME_SV, "Vlj avbildning fr internt funktions-ROM" },
         { IDS_SELECT_INTERNAL_FUNCTION_ROM_FILENAME_TR, "Dahili Function ROM dosyas sein" },

         { IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME,    N_("Select External Function ROM file") },
         { IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME_DA, "Vlg image for ekstern funktions-ROM" },
         { IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME_DE, "Externes Funktions ROM Image Datei auswhlen" },
         { IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME_FR, "" },             
         { IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME_HU, "Adja meg a kls Function ROM kpms nevt" },
         { IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME_IT, "Seleziona il file della function ROM esterna" },
         { IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME_NL, "Selecteer Extern functie-ROM-bestand" },
         { IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME_PL, "" },             
         { IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME_SV, "Vlj avbildning fr externt funktions-ROM" },
         { IDS_SELECT_EXTERNAL_FUNCTION_ROM_FILENAME_TR, "Harici Function ROM dosyas sein" },

         { IDS_MACHINE_TYPE,    N_("Machine type") },
         { IDS_MACHINE_TYPE_DA, "Maskintype" },
         { IDS_MACHINE_TYPE_DE, "Maschinen Typ" },
         { IDS_MACHINE_TYPE_FR, "Type de machine" },
         { IDS_MACHINE_TYPE_HU, "Gp tpus" },
         { IDS_MACHINE_TYPE_IT, "Tipo di macchina" },
         { IDS_MACHINE_TYPE_NL, "Machinesoort" },
         { IDS_MACHINE_TYPE_PL, "" },             
         { IDS_MACHINE_TYPE_SV, "Maskintyp" },
         { IDS_MACHINE_TYPE_TR, "Makine tipi" },

         { IDS_INTERNAL_FUNCTION_ROM,    N_("Internal Function ROM") },
         { IDS_INTERNAL_FUNCTION_ROM_DA, "Intern funktions-ROM" },
         { IDS_INTERNAL_FUNCTION_ROM_DE, "Internes Funktions ROM" },
         { IDS_INTERNAL_FUNCTION_ROM_FR, "Image ROM Fonction interne" },
         { IDS_INTERNAL_FUNCTION_ROM_HU, "Bels Function ROM" },
         { IDS_INTERNAL_FUNCTION_ROM_IT, "Function ROM interna" },
         { IDS_INTERNAL_FUNCTION_ROM_NL, "Intern functie-ROM" },
         { IDS_INTERNAL_FUNCTION_ROM_PL, "" },             
         { IDS_INTERNAL_FUNCTION_ROM_SV, "Internt funktions-ROM" },
         { IDS_INTERNAL_FUNCTION_ROM_TR, "Uluslararas Function ROM" },

         { IDS_INTERNAL_FUNCTION_ROM_FILENAME,    N_("Internal Function ROM file") },
         { IDS_INTERNAL_FUNCTION_ROM_FILENAME_DA, "Intern funktions-ROM" },
         { IDS_INTERNAL_FUNCTION_ROM_FILENAME_DE, "Interne Funktions ROM Datei" },
         { IDS_INTERNAL_FUNCTION_ROM_FILENAME_FR, "" },             
         { IDS_INTERNAL_FUNCTION_ROM_FILENAME_HU, "Bels Function ROM fjl" },
         { IDS_INTERNAL_FUNCTION_ROM_FILENAME_IT, "File della function ROM interna" },
         { IDS_INTERNAL_FUNCTION_ROM_FILENAME_NL, "Intern functie-ROM-bestand" },
         { IDS_INTERNAL_FUNCTION_ROM_FILENAME_PL, "" },             
         { IDS_INTERNAL_FUNCTION_ROM_FILENAME_SV, "Internt funktions-ROM" },
         { IDS_INTERNAL_FUNCTION_ROM_FILENAME_TR, "Dahili Function ROM dosyas" },

         { IDS_EXTERNAL_FUNCTION_ROM,    N_("External Function ROM") },
         { IDS_EXTERNAL_FUNCTION_ROM_DA, "Extern funktions-ROM" },
         { IDS_EXTERNAL_FUNCTION_ROM_DE, "Externes Funktions ROM" },
         { IDS_EXTERNAL_FUNCTION_ROM_FR, "Image ROM Fonction externe" },
         { IDS_EXTERNAL_FUNCTION_ROM_HU, "Kls Function ROM" },
         { IDS_EXTERNAL_FUNCTION_ROM_IT, "Function ROM esterna" },
         { IDS_EXTERNAL_FUNCTION_ROM_NL, "Extern functie-ROM" },
         { IDS_EXTERNAL_FUNCTION_ROM_PL, "" },             
         { IDS_EXTERNAL_FUNCTION_ROM_SV, "Externt funktions-ROM" },
         { IDS_EXTERNAL_FUNCTION_ROM_TR, "Harici Function ROM" },

         { IDS_EXTERNAL_FUNCTION_ROM_FILENAME,    N_("External Function ROM file") },
         { IDS_EXTERNAL_FUNCTION_ROM_FILENAME_DA, "Extern funktions-ROM" },
         { IDS_EXTERNAL_FUNCTION_ROM_FILENAME_DE, "Externe Funktions ROM Datei" },
         { IDS_EXTERNAL_FUNCTION_ROM_FILENAME_FR, "" },             
         { IDS_EXTERNAL_FUNCTION_ROM_FILENAME_HU, "Kls Function ROM fjl" },
         { IDS_EXTERNAL_FUNCTION_ROM_FILENAME_IT, "File della function ROM esterna" },
         { IDS_EXTERNAL_FUNCTION_ROM_FILENAME_NL, "Extern functie-ROM-bestand" },
         { IDS_EXTERNAL_FUNCTION_ROM_FILENAME_PL, "" },             
         { IDS_EXTERNAL_FUNCTION_ROM_FILENAME_SV, "Externt funktions-ROM" },
         { IDS_EXTERNAL_FUNCTION_ROM_FILENAME_TR, "Harici Function ROM dosyas" },

         { IDS_RAM_BANKS_2_AND_3,    N_("RAM banks 2 & 3") },
         { IDS_RAM_BANKS_2_AND_3_DA, "" },             
         { IDS_RAM_BANKS_2_AND_3_DE, "RAM Bnkte 2 & 3" },
         { IDS_RAM_BANKS_2_AND_3_FR, "" },             
         { IDS_RAM_BANKS_2_AND_3_HU, "" },             
         { IDS_RAM_BANKS_2_AND_3_IT, "Banchi di RAM 2 & 3" },
         { IDS_RAM_BANKS_2_AND_3_NL, "RAM bank 2 & 3" },
         { IDS_RAM_BANKS_2_AND_3_PL, "" },             
         { IDS_RAM_BANKS_2_AND_3_SV, "RAM-bank 2 & 3" },
         { IDS_RAM_BANKS_2_AND_3_TR, "RAM banklar 2 & 3" },

         { IDS_C128_SETTINGS,    N_("C128 settings") },
         { IDS_C128_SETTINGS_DA, "C128-indstillinger" },
         { IDS_C128_SETTINGS_DE, "C128 Einstellungen" },
         { IDS_C128_SETTINGS_FR, "Paramtres C128" },
         { IDS_C128_SETTINGS_HU, "C128 belltsai" },
         { IDS_C128_SETTINGS_IT, "Impostazioni C128" },
         { IDS_C128_SETTINGS_NL, "C128-instellingen" },
         { IDS_C128_SETTINGS_PL, "" },             
         { IDS_C128_SETTINGS_SV, "C128-instllningar" },
         { IDS_C128_SETTINGS_TR, "C128 ayarlar" },

         { IDS_SELECT_ROM_FILE,    N_("Select ROM file") },
         { IDS_SELECT_ROM_FILE_DA, "Vlg ROM-fil" },
         { IDS_SELECT_ROM_FILE_DE, "ROM Datei whlen" },
         { IDS_SELECT_ROM_FILE_FR, "" },             
         { IDS_SELECT_ROM_FILE_HU, "Vlasszon ROM fjlt" },
         { IDS_SELECT_ROM_FILE_IT, "Seleziona file della ROM" },
         { IDS_SELECT_ROM_FILE_NL, "Selecteer ROM-bestand" },
         { IDS_SELECT_ROM_FILE_PL, "" },             
         { IDS_SELECT_ROM_FILE_SV, "Vlj ROM-fil" },
         { IDS_SELECT_ROM_FILE_TR, "ROM dosyas sein" },

         { IDS_COMPUTER_ROM_SETTINGS,    N_("Computer ROM settings") },
         { IDS_COMPUTER_ROM_SETTINGS_DA, "Computer ROM-indstillinger" },
         { IDS_COMPUTER_ROM_SETTINGS_DE, "Computer ROM Einstellungen" },
         { IDS_COMPUTER_ROM_SETTINGS_FR, "" },             
         { IDS_COMPUTER_ROM_SETTINGS_HU, "Szmtgp ROM belltsai" },
         { IDS_COMPUTER_ROM_SETTINGS_IT, "Impostazioni ROM del computer" },
         { IDS_COMPUTER_ROM_SETTINGS_NL, "Computer-ROM-instellingen" },
         { IDS_COMPUTER_ROM_SETTINGS_PL, "" },             
         { IDS_COMPUTER_ROM_SETTINGS_SV, "ROM-instllningar fr dator" },
         { IDS_COMPUTER_ROM_SETTINGS_TR, "Bilgisayar ROM ayarlar" },

         { IDS_DRIVE_ROM_SETTINGS,    N_("Drive ROM settings") },
         { IDS_DRIVE_ROM_SETTINGS_DA, "Drev ROM-indstillinger" },
         { IDS_DRIVE_ROM_SETTINGS_DE, "Floppy ROM Einstellungen" },
         { IDS_DRIVE_ROM_SETTINGS_FR, "" },             
         { IDS_DRIVE_ROM_SETTINGS_HU, "Lemezegysg ROM belltsai" },
         { IDS_DRIVE_ROM_SETTINGS_IT, "Impostazioni ROM del drive" },
         { IDS_DRIVE_ROM_SETTINGS_NL, "Drive-ROM-instellingen" },
         { IDS_DRIVE_ROM_SETTINGS_PL, "" },             
         { IDS_DRIVE_ROM_SETTINGS_SV, "ROM-instllningar fr diskettenhet" },
         { IDS_DRIVE_ROM_SETTINGS_TR, "Src ROM ayarlar" },

         { IDS_DIGIMAX_ENABLED,    N_("Digimax Enabled") },
         { IDS_DIGIMAX_ENABLED_DA, "Digimax aktiveret" },
         { IDS_DIGIMAX_ENABLED_DE, "Digimax aktiviert" },
         { IDS_DIGIMAX_ENABLED_FR, "" },             
         { IDS_DIGIMAX_ENABLED_HU, "Digimax engedlyezve" },
         { IDS_DIGIMAX_ENABLED_IT, "Digimax attivato" },
         { IDS_DIGIMAX_ENABLED_NL, "Digimax Aan/Uit" },
         { IDS_DIGIMAX_ENABLED_PL, "" },             
         { IDS_DIGIMAX_ENABLED_SV, "Digimax aktiverad" },
         { IDS_DIGIMAX_ENABLED_TR, "Digimax' Aktif Et" },

         { IDS_DIGIMAX_BASE,    N_("Digimax Base") },
         { IDS_DIGIMAX_BASE_DA, "Digimaxbase" },
         { IDS_DIGIMAX_BASE_DE, "Digimax Basis" },
         { IDS_DIGIMAX_BASE_FR, "Base Digimax" },
         { IDS_DIGIMAX_BASE_HU, "Digimax bziscm" },
         { IDS_DIGIMAX_BASE_IT, "Base Digimax" },
         { IDS_DIGIMAX_BASE_NL, "Digimax basisadres" },
         { IDS_DIGIMAX_BASE_PL, "" },             
         { IDS_DIGIMAX_BASE_SV, "Digimaxbas" },
         { IDS_DIGIMAX_BASE_TR, "Digimax Taban" },

         { IDS_DIGIMAX_SETTINGS,    N_("Digimax Settings") },
         { IDS_DIGIMAX_SETTINGS_DA, "Digimaxindstillinger" },
         { IDS_DIGIMAX_SETTINGS_DE, "Digimax Einstellungen" },
         { IDS_DIGIMAX_SETTINGS_FR, "" },             
         { IDS_DIGIMAX_SETTINGS_HU, "Digimax belltsai" },
         { IDS_DIGIMAX_SETTINGS_IT, "Impostazioni digimax" },
         { IDS_DIGIMAX_SETTINGS_NL, "Digimaxinstellingen" },
         { IDS_DIGIMAX_SETTINGS_PL, "" },             
         { IDS_DIGIMAX_SETTINGS_SV, "Digimaxinstllningar" },
         { IDS_DIGIMAX_SETTINGS_TR, "Digimax Ayarlar" },

         { IDS_SFX_SE_ENABLED,    N_("SFX Sound Expander Enabled") },
         { IDS_SFX_SE_ENABLED_DA, "" },             
         { IDS_SFX_SE_ENABLED_DE, "SFX Sound Expander aktiviert" },
         { IDS_SFX_SE_ENABLED_FR, "" },             
         { IDS_SFX_SE_ENABLED_HU, "" },             
         { IDS_SFX_SE_ENABLED_IT, "Attiva SFX Sound Expander" },
         { IDS_SFX_SE_ENABLED_NL, "SFX Sound Expander Aan/Uit" },
         { IDS_SFX_SE_ENABLED_PL, "" },             
         { IDS_SFX_SE_ENABLED_SV, "SFX Sound Expander aktiverad" },
         { IDS_SFX_SE_ENABLED_TR, "SFX Sound Expander Aktif" },

         { IDS_SFX_SE_CHIP,    N_("SFX Sound Expander Chip") },
         { IDS_SFX_SE_CHIP_DA, "" },             
         { IDS_SFX_SE_CHIP_DE, "SFX Sound Expander Chip" },
         { IDS_SFX_SE_CHIP_FR, "" },             
         { IDS_SFX_SE_CHIP_HU, "" },             
         { IDS_SFX_SE_CHIP_IT, "Chip SFX Sound Expander" },
         { IDS_SFX_SE_CHIP_NL, "SFX Sound Expander Chip" },
         { IDS_SFX_SE_CHIP_PL, "" },             
         { IDS_SFX_SE_CHIP_SV, "SFX Sound Expander-krets" },
         { IDS_SFX_SE_CHIP_TR, "SFX Sound Expander ipi" },

         { IDS_SFX_SE_SETTINGS,    N_("SFX Sound Expander Settings") },
         { IDS_SFX_SE_SETTINGS_DA, "" },             
         { IDS_SFX_SE_SETTINGS_DE, "SFX Sound Expander Einstellungen" },
         { IDS_SFX_SE_SETTINGS_FR, "" },             
         { IDS_SFX_SE_SETTINGS_HU, "" },             
         { IDS_SFX_SE_SETTINGS_IT, "Impostazioni SFX Sound Expander" },
         { IDS_SFX_SE_SETTINGS_NL, "SFX Sound Expander instellingen" },
         { IDS_SFX_SE_SETTINGS_PL, "" },             
         { IDS_SFX_SE_SETTINGS_SV, "Instllningar fr SFX Sound Expander" },
         { IDS_SFX_SE_SETTINGS_TR, "SFX Sound Expander Ayarlar" },

         { IDS_SOUND_RECORDING_STOPPED,    N_("Sound Recording stopped...") },
         { IDS_SOUND_RECORDING_STOPPED_DA, "Lydoptagelse stoppet..." },
         { IDS_SOUND_RECORDING_STOPPED_DE, "Tonaufnahme gestoppt..." },
         { IDS_SOUND_RECORDING_STOPPED_FR, "" },             
         { IDS_SOUND_RECORDING_STOPPED_HU, "Hangfelvtel lelltva..." },
         { IDS_SOUND_RECORDING_STOPPED_IT, "Registrazione audio interrotta..." },
         { IDS_SOUND_RECORDING_STOPPED_NL, "Geluidsopname gestopt..." },
         { IDS_SOUND_RECORDING_STOPPED_PL, "" },             
         { IDS_SOUND_RECORDING_STOPPED_SV, "Ljudinspelning stoppad..." },
         { IDS_SOUND_RECORDING_STOPPED_TR, "Ses Kayd durduruldu" },

         { IDS_SOUND_RECORDING_STARTED,    N_("Sound Recording started...") },
         { IDS_SOUND_RECORDING_STARTED_DA, "Lydoptagelse startet..." },
         { IDS_SOUND_RECORDING_STARTED_DE, "Tonaufnahme gestartet..." },
         { IDS_SOUND_RECORDING_STARTED_FR, "" },             
         { IDS_SOUND_RECORDING_STARTED_HU, "Hangfelvtel elindtva..." },
         { IDS_SOUND_RECORDING_STARTED_IT, "Registrazione audio avviata..." },
         { IDS_SOUND_RECORDING_STARTED_NL, "Geluidsopname gestart..." },
         { IDS_SOUND_RECORDING_STARTED_PL, "" },             
         { IDS_SOUND_RECORDING_STARTED_SV, "Ljudinspelning startad..." },
         { IDS_SOUND_RECORDING_STARTED_TR, "Ses Kayd balad..." },

         { IDS_SELECT_RECORD_FILE,    N_("Select Sound Record File") },
         { IDS_SELECT_RECORD_FILE_DA, "Vlg lydoptagelsesfil" },
         { IDS_SELECT_RECORD_FILE_DE, "Tonaufnahmedatei definieren" },
         { IDS_SELECT_RECORD_FILE_FR, "" },             
         { IDS_SELECT_RECORD_FILE_HU, "Vlassza ki a hangfelvtel kimeneti fjlt" },
         { IDS_SELECT_RECORD_FILE_IT, "Seleziona il file per la registrazione dell'audio" },
         { IDS_SELECT_RECORD_FILE_NL, "Selecteer geluidsopnamebestand" },
         { IDS_SELECT_RECORD_FILE_PL, "" },             
         { IDS_SELECT_RECORD_FILE_SV, "Vlj ljudinspelningsfil" },
         { IDS_SELECT_RECORD_FILE_TR, "Ses Kayt Dosyas Sein" },

         { IDS_SOUND_RECORD_FORMAT,    N_("Sound Record Format") },
         { IDS_SOUND_RECORD_FORMAT_DA, "Format for lydoptagelse" },
         { IDS_SOUND_RECORD_FORMAT_DE, "Tonaufnahmeformat" },
         { IDS_SOUND_RECORD_FORMAT_FR, "" },             
         { IDS_SOUND_RECORD_FORMAT_HU, "Hangfelvtel formtuma" },
         { IDS_SOUND_RECORD_FORMAT_IT, "Formato di registrazione dell'audio" },
         { IDS_SOUND_RECORD_FORMAT_NL, "Geluid Opname Formaat" },
         { IDS_SOUND_RECORD_FORMAT_PL, "" },             
         { IDS_SOUND_RECORD_FORMAT_SV, "Format fr ljudinspelning" },
         { IDS_SOUND_RECORD_FORMAT_TR, "Ses Kayt Biimi" },

         { IDS_SOUND_RECORD_FILE,    N_("Sound Record File") },
         { IDS_SOUND_RECORD_FILE_DA, "Lydoptagelsesfil" },
         { IDS_SOUND_RECORD_FILE_DE, "Tonaufnahmedatei" },
         { IDS_SOUND_RECORD_FILE_FR, "" },             
         { IDS_SOUND_RECORD_FILE_HU, "Hangfelvtel fjl" },
         { IDS_SOUND_RECORD_FILE_IT, "File per la registrazione dell'audio" },
         { IDS_SOUND_RECORD_FILE_NL, "Geluid opnamebestand" },
         { IDS_SOUND_RECORD_FILE_PL, "" },             
         { IDS_SOUND_RECORD_FILE_SV, "Ljudinspelningsfil" },
         { IDS_SOUND_RECORD_FILE_TR, "Ses Kayt Dosyas" },

         { IDS_SOUND_RECORD_SETTINGS,    N_("Sound Record Settings") },
         { IDS_SOUND_RECORD_SETTINGS_DA, "Lydoptagelsesindstillinger" },
         { IDS_SOUND_RECORD_SETTINGS_DE, "Tonaufnahme Einstellungen" },
         { IDS_SOUND_RECORD_SETTINGS_FR, "" },             
         { IDS_SOUND_RECORD_SETTINGS_HU, "Hangfelvtel belltsai" },
         { IDS_SOUND_RECORD_SETTINGS_IT, "Impostazioni di registrazione audio" },
         { IDS_SOUND_RECORD_SETTINGS_NL, "Geluidsopnameinstellingen" },
         { IDS_SOUND_RECORD_SETTINGS_PL, "" },             
         { IDS_SOUND_RECORD_SETTINGS_SV, "Instllningar fr ljudinspelning" },
         { IDS_SOUND_RECORD_SETTINGS_TR, "Ses Kayt Ayarlar" },

         { IDS_SMALL,    N_("Small") },
         { IDS_SMALL_DA, "" },             
         { IDS_SMALL_DE, "Klein" },
         { IDS_SMALL_FR, "" },             
         { IDS_SMALL_HU, "" },             
         { IDS_SMALL_IT, "" },             
         { IDS_SMALL_NL, "Klein" },
         { IDS_SMALL_PL, "" },             
         { IDS_SMALL_SV, "Liten" },
         { IDS_SMALL_TR, "Kk" },

         { IDS_MEDIUM,    N_("Medium") },
         { IDS_MEDIUM_DA, "" },             
         { IDS_MEDIUM_DE, "Mittel" },
         { IDS_MEDIUM_FR, "" },             
         { IDS_MEDIUM_HU, "" },             
         { IDS_MEDIUM_IT, "" },             
         { IDS_MEDIUM_NL, "Medium" },
         { IDS_MEDIUM_PL, "" },             
         { IDS_MEDIUM_SV, "Medium" },
         { IDS_MEDIUM_TR, "Orta" },

         { IDS_LARGE,    N_("Large") },
         { IDS_LARGE_DA, "" },             
         { IDS_LARGE_DE, "Gro" },
         { IDS_LARGE_FR, "" },             
         { IDS_LARGE_HU, "" },             
         { IDS_LARGE_IT, "" },             
         { IDS_LARGE_NL, "Groot" },
         { IDS_LARGE_PL, "" },             
         { IDS_LARGE_SV, "Stor" },
         { IDS_LARGE_TR, "Byk" },

         { IDS_BORDER_MODE,    N_("Border mode") },
         { IDS_BORDER_MODE_DA, "Ramme-tilstand" },
         { IDS_BORDER_MODE_DE, "Rahmen Modus" },
         { IDS_BORDER_MODE_FR, "" },             
         { IDS_BORDER_MODE_HU, "Keret md" },
         { IDS_BORDER_MODE_IT, "Modalit del bordo" },
         { IDS_BORDER_MODE_NL, "Bordermodus" },
         { IDS_BORDER_MODE_PL, "" },             
         { IDS_BORDER_MODE_SV, "Ramlge" },
         { IDS_BORDER_MODE_TR, "ereve modu" },

         { IDMS_NORMAL,    N_("Normal") },
         { IDMS_NORMAL_DA, "Normal" },
         { IDMS_NORMAL_DE, "Normal" },
         { IDMS_NORMAL_FR, "" },             
         { IDMS_NORMAL_HU, "Norml" },
         { IDMS_NORMAL_IT, "Normale" },
         { IDMS_NORMAL_NL, "Normaal" },
         { IDMS_NORMAL_PL, "" },             
         { IDMS_NORMAL_SV, "Normal" },
         { IDMS_NORMAL_TR, "Normal" },

         { IDS_FULL,    N_("Full") },
         { IDS_FULL_DA, "Fuld" },
         { IDS_FULL_DE, "Full" },
         { IDS_FULL_FR, "" },             
         { IDS_FULL_HU, "Teljes" },
         { IDS_FULL_IT, "Intero" },
         { IDS_FULL_NL, "Volledig" },
         { IDS_FULL_PL, "" },             
         { IDS_FULL_SV, "Full" },
         { IDS_FULL_TR, "Tam" },

         { IDS_DEBUG,    N_("Debug") },
         { IDS_DEBUG_DA, "Debug" },
         { IDS_DEBUG_DE, "Debug" },
         { IDS_DEBUG_FR, "" },             
         { IDS_DEBUG_HU, "Nyomkvets" },
         { IDS_DEBUG_IT, "Debug" },
         { IDS_DEBUG_NL, "Debug" },
         { IDS_DEBUG_PL, "" },             
         { IDS_DEBUG_SV, "Felsk" },
         { IDS_DEBUG_TR, "Hata Ayklama" },

         { IDS_VOLUME,    N_("Volume (0-100%)") },
         { IDS_VOLUME_DA, "Volume (0-100 %)" },
         { IDS_VOLUME_DE, "Lautstrke (0-100%)" },
         { IDS_VOLUME_FR, "Volume (0-100%)" },
         { IDS_VOLUME_HU, "Hanger (0-100%)" },
         { IDS_VOLUME_IT, "Volume (0-100%)" },
         { IDS_VOLUME_NL, "Volume (0-100%)" },
         { IDS_VOLUME_PL, "" },             
         { IDS_VOLUME_SV, "Volym (0-100 %)" },
         { IDS_VOLUME_TR, "Ses Dzeyi (0-100%)" },

         { IDS_MOUSE_TYPE,    N_("Mouse type") },
         { IDS_MOUSE_TYPE_DA, "Mussetype" },
         { IDS_MOUSE_TYPE_DE, "Maustyp" },
         { IDS_MOUSE_TYPE_FR, "Type de souris" },
         { IDS_MOUSE_TYPE_HU, "Egr tpusa" },
         { IDS_MOUSE_TYPE_IT, "Tipo di mouse" },
         { IDS_MOUSE_TYPE_NL, "Muis soort" },
         { IDS_MOUSE_TYPE_PL, "" },             
         { IDS_MOUSE_TYPE_SV, "Mustyp" },
         { IDS_MOUSE_TYPE_TR, "Mouse tipi" },

         { IDS_MOUSE_SETTINGS,    N_("Mouse Settings") },
         { IDS_MOUSE_SETTINGS_DA, "Musseindstillinger" },
         { IDS_MOUSE_SETTINGS_DE, "Maus Einstellungen" },
         { IDS_MOUSE_SETTINGS_FR, "Paramtres de souris" },
         { IDS_MOUSE_SETTINGS_HU, "Egr belltsok" },
         { IDS_MOUSE_SETTINGS_IT, "Impostazioni mouse" },
         { IDS_MOUSE_SETTINGS_NL, "Muis Instellingen" },
         { IDS_MOUSE_SETTINGS_PL, "" },             
         { IDS_MOUSE_SETTINGS_SV, "Musinstllningar" },
         { IDS_MOUSE_SETTINGS_TR, "Mouse Ayarlar" },

         { IDS_MOUSE_PORT,    N_("Mouse port") },
         { IDS_MOUSE_PORT_DA, "Musseport" },
         { IDS_MOUSE_PORT_DE, "Maus Port" },
         { IDS_MOUSE_PORT_FR, "Port de la souris" },
         { IDS_MOUSE_PORT_HU, "Egr port" },
         { IDS_MOUSE_PORT_IT, "Porta del mouse" },
         { IDS_MOUSE_PORT_NL, "Muis poort" },
         { IDS_MOUSE_PORT_PL, "" },             
         { IDS_MOUSE_PORT_SV, "Musport" },
         { IDS_MOUSE_PORT_TR, "Mouse portu" },

         { IDS_MOUSE_1351,    N_("1351 mouse") },
         { IDS_MOUSE_1351_DA, "1351-mus" },
         { IDS_MOUSE_1351_DE, "1351 Maus" },
         { IDS_MOUSE_1351_FR, "Souris 1351" },
         { IDS_MOUSE_1351_HU, "1351 egr" },
         { IDS_MOUSE_1351_IT, "Mouse 1351" },
         { IDS_MOUSE_1351_NL, "1351 muis" },
         { IDS_MOUSE_1351_PL, "" },             
         { IDS_MOUSE_1351_SV, "1351-mus" },
         { IDS_MOUSE_1351_TR, "1351 mouse" },

         { IDS_MOUSE_NEOS,    N_("NEOS mouse") },
         { IDS_MOUSE_NEOS_DA, "NEOS-mus" },
         { IDS_MOUSE_NEOS_DE, "NEOS Maus" },
         { IDS_MOUSE_NEOS_FR, "Souris NEOS" },
         { IDS_MOUSE_NEOS_HU, "NEOS egr" },
         { IDS_MOUSE_NEOS_IT, "Mouse NEOS" },
         { IDS_MOUSE_NEOS_NL, "NEOS muis" },
         { IDS_MOUSE_NEOS_PL, "" },             
         { IDS_MOUSE_NEOS_SV, "NEOS-mus" },
         { IDS_MOUSE_NEOS_PL, "NEOS mouse" },

         { IDS_MOUSE_AMIGA,    N_("Amiga mouse") },
         { IDS_MOUSE_AMIGA_DA, "Amigamus" },
         { IDS_MOUSE_AMIGA_DE, "Amiga Maus" },
         { IDS_MOUSE_AMIGA_FR, "Souris Amiga" },
         { IDS_MOUSE_AMIGA_HU, "Amiga egr" },
         { IDS_MOUSE_AMIGA_IT, "Mouse Amiga" },
         { IDS_MOUSE_AMIGA_NL, "Amiga muis" },
         { IDS_MOUSE_AMIGA_PL, "" },             
         { IDS_MOUSE_AMIGA_SV, "Amigamus" },
         { IDS_MOUSE_AMIGA_TR, "Amiga mouse" },

         { IDS_MOUSE_PADDLES,    N_("Paddle") },
         { IDS_MOUSE_PADDLES_DA, "" },             
         { IDS_MOUSE_PADDLES_DE, "Paddle" },
         { IDS_MOUSE_PADDLES_FR, "" },             
         { IDS_MOUSE_PADDLES_HU, "" },             
         { IDS_MOUSE_PADDLES_IT, "Paddle" },
         { IDS_MOUSE_PADDLES_NL, "Paddle" },
         { IDS_MOUSE_PADDLES_PL, "" },             
         { IDS_MOUSE_PADDLES_SV, "Paddel" },
         { IDS_MOUSE_PADDLES_TR, "Paddle" },

         { IDS_AUTOSTART_VIRTUAL_FS,    N_("Virtual FS") },
         { IDS_AUTOSTART_VIRTUAL_FS_DA, "" },             
         { IDS_AUTOSTART_VIRTUAL_FS_DE, "Virtual FS" },
         { IDS_AUTOSTART_VIRTUAL_FS_FR, "" },             
         { IDS_AUTOSTART_VIRTUAL_FS_HU, "" },             
         { IDS_AUTOSTART_VIRTUAL_FS_IT, "Virtual FS" },
         { IDS_AUTOSTART_VIRTUAL_FS_NL, "Virtueel Bestandssysteem" },
         { IDS_AUTOSTART_VIRTUAL_FS_PL, "" },             
         { IDS_AUTOSTART_VIRTUAL_FS_SV, "Virtuellt FS" },
         { IDS_AUTOSTART_VIRTUAL_FS_TR, "Sanal FS" },

         { IDS_AUTOSTART_INJECT,    N_("Inject") },
         { IDS_AUTOSTART_INJECT_DA, "" },             
         { IDS_AUTOSTART_INJECT_DE, "Inject" },
         { IDS_AUTOSTART_INJECT_FR, "" },             
         { IDS_AUTOSTART_INJECT_HU, "" },             
         { IDS_AUTOSTART_INJECT_IT, "Immettere" },
         { IDS_AUTOSTART_INJECT_NL, "Inject" },
         { IDS_AUTOSTART_INJECT_PL, "" },             
         { IDS_AUTOSTART_INJECT_SV, "Stt in" },
         { IDS_AUTOSTART_INJECT_TR, "Enjekte et" },

         { IDS_AUTOSTART_DISK,    N_("Disk image") },
         { IDS_AUTOSTART_DISK_DA, "" },             
         { IDS_AUTOSTART_DISK_DE, "Disk Image" },
         { IDS_AUTOSTART_DISK_FR, "" },             
         { IDS_AUTOSTART_DISK_HU, "" },             
         { IDS_AUTOSTART_DISK_IT, "Immagine disco" },
         { IDS_AUTOSTART_DISK_NL, "Disk bestand" },
         { IDS_AUTOSTART_DISK_PL, "" },             
         { IDS_AUTOSTART_DISK_SV, "Diskavbildning" },
         { IDS_AUTOSTART_DISK_TR, "Disk imaj" },

         { IDS_AUTOSTART_DISK_IMAGE_SELECT,    N_("Select file for PRG autostart disk") },
         { IDS_AUTOSTART_DISK_IMAGE_SELECT_DA, "" },             
         { IDS_AUTOSTART_DISK_IMAGE_SELECT_DE, "Datei fr PRG Autostart auswhlen" },
         { IDS_AUTOSTART_DISK_IMAGE_SELECT_FR, "" },             
         { IDS_AUTOSTART_DISK_IMAGE_SELECT_HU, "" },             
         { IDS_AUTOSTART_DISK_IMAGE_SELECT_IT, "Seleziona file per avvio automatico PRG" },
         { IDS_AUTOSTART_DISK_IMAGE_SELECT_NL, "Selecteer bestand voor PRG autostart disk" },
         { IDS_AUTOSTART_DISK_IMAGE_SELECT_PL, "" },             
         { IDS_AUTOSTART_DISK_IMAGE_SELECT_SV, "Vlj fil fr PRG-autostartdisk" },
         { IDS_AUTOSTART_DISK_IMAGE_SELECT_TR, "PRG otomatik balatma iin dosya sein" },

         { IDS_WARP_ON_AUTOSTART,    N_("Autostart warp") },
         { IDS_WARP_ON_AUTOSTART_DA, "" },             
         { IDS_WARP_ON_AUTOSTART_DE, "Autostart Warp" },
         { IDS_WARP_ON_AUTOSTART_FR, "" },             
         { IDS_WARP_ON_AUTOSTART_HU, "" },             
         { IDS_WARP_ON_AUTOSTART_IT, "Avvio automatico in turbo" },
         { IDS_WARP_ON_AUTOSTART_NL, "Autostart warp" },
         { IDS_WARP_ON_AUTOSTART_PL, "" },             
         { IDS_WARP_ON_AUTOSTART_SV, "Starta warp automatiskt" },
         { IDS_WARP_ON_AUTOSTART_TR, "Warp modunda otomatik balat" },

         { IDS_RUN_WITH_COLON,    N_("Use ':' with run") },
         { IDS_RUN_WITH_COLON_DA, "" },             
         { IDS_RUN_WITH_COLON_DE, "Verwende ':' mit RUN" },
         { IDS_RUN_WITH_COLON_FR, "" },             
         { IDS_RUN_WITH_COLON_HU, "" },             
         { IDS_RUN_WITH_COLON_IT, "Usa ':' con run" },
         { IDS_RUN_WITH_COLON_NL, "Gebruik ':' met run" },
         { IDS_RUN_WITH_COLON_PL, "" },             
         { IDS_RUN_WITH_COLON_SV, "Anvnd ':' med run" },
         { IDS_RUN_WITH_COLON_TR, "altr ile ':' kullan" },

         { IDS_AUTOSTART_PRG_MODE,    N_("PRG autostart mode") },
         { IDS_AUTOSTART_PRG_MODE_DA, "" },             
         { IDS_AUTOSTART_PRG_MODE_DE, "PRG Autostartmodus" },
         { IDS_AUTOSTART_PRG_MODE_FR, "" },             
         { IDS_AUTOSTART_PRG_MODE_HU, "" },             
         { IDS_AUTOSTART_PRG_MODE_IT, "Avvio automatico PRG" },
         { IDS_AUTOSTART_PRG_MODE_NL, "PRG autostart modus" },
         { IDS_AUTOSTART_PRG_MODE_PL, "" },             
         { IDS_AUTOSTART_PRG_MODE_SV, "Autostartlge fr PRG" },
         { IDS_AUTOSTART_PRG_MODE_TR, "PRG otomatik balatma modu" },

         { IDS_AUTOSTART_DISK_IMAGE_FILENAME,    N_("PRG autostart disk image") },
         { IDS_AUTOSTART_DISK_IMAGE_FILENAME_DA, "" },             
         { IDS_AUTOSTART_DISK_IMAGE_FILENAME_DE, "PRG Autostart Disk Image" },
         { IDS_AUTOSTART_DISK_IMAGE_FILENAME_FR, "" },             
         { IDS_AUTOSTART_DISK_IMAGE_FILENAME_HU, "" },             
         { IDS_AUTOSTART_DISK_IMAGE_FILENAME_IT, "Immagine disco avvio automatico PRG" },
         { IDS_AUTOSTART_DISK_IMAGE_FILENAME_NL, "PRG autostart disk bestand" },
         { IDS_AUTOSTART_DISK_IMAGE_FILENAME_PL, "" },             
         { IDS_AUTOSTART_DISK_IMAGE_FILENAME_SV, "Autostartdiskavbildning fr PRG" },
         { IDS_AUTOSTART_DISK_IMAGE_FILENAME_TR, "PRG otomatik balatma disk imaj" },

         { IDS_AUTOSTART_SETTINGS,    N_("Autostart Settings") },
         { IDS_AUTOSTART_SETTINGS_DA, "" },             
         { IDS_AUTOSTART_SETTINGS_DE, "Autostart Einstellungen" },
         { IDS_AUTOSTART_SETTINGS_FR, "" },             
         { IDS_AUTOSTART_SETTINGS_HU, "" },             
         { IDS_AUTOSTART_SETTINGS_IT, "Impostazioni avvio automatico" },
         { IDS_AUTOSTART_SETTINGS_NL, "Autostart Instellingen" },
         { IDS_AUTOSTART_SETTINGS_PL, "" },             
         { IDS_AUTOSTART_SETTINGS_SV, "Autostartinstllningar" },
         { IDS_AUTOSTART_SETTINGS_TR, "Otomatik balatma ayarlar" },

         { IDS_ERROR_SAVING_EASYFLASH_CRT,    N_("Error saving EasyFlash crt file") },
         { IDS_ERROR_SAVING_EASYFLASH_CRT_DA, "" },             
         { IDS_ERROR_SAVING_EASYFLASH_CRT_DE, "Fehler beim Speichern der EasyFlash CRT Datei" },
         { IDS_ERROR_SAVING_EASYFLASH_CRT_FR, "" },             
         { IDS_ERROR_SAVING_EASYFLASH_CRT_HU, "" },             
         { IDS_ERROR_SAVING_EASYFLASH_CRT_IT, "Errore durante il salvataggio del file crt EasyFlash" },
         { IDS_ERROR_SAVING_EASYFLASH_CRT_NL, "Kan het EasyFlash crt bestand niet opslaan" },
         { IDS_ERROR_SAVING_EASYFLASH_CRT_PL, "" },             
         { IDS_ERROR_SAVING_EASYFLASH_CRT_SV, "Fel vid skrivning av EasyFlash-crt-fil." },
         { IDS_ERROR_SAVING_EASYFLASH_CRT_TR, "EasyFlash crt dosyas kayt hatas" },

         { IDS_EASYFLASH_JUMPER,    N_("EasyFlash jumper") },
         { IDS_EASYFLASH_JUMPER_DA, "" },             
         { IDS_EASYFLASH_JUMPER_DE, "EasyFlash Jumper" },
         { IDS_EASYFLASH_JUMPER_FR, "" },             
         { IDS_EASYFLASH_JUMPER_HU, "" },             
         { IDS_EASYFLASH_JUMPER_IT, "Ponticello EasyFlash" },
         { IDS_EASYFLASH_JUMPER_NL, "EasyFlash jumper" },
         { IDS_EASYFLASH_JUMPER_PL, "" },             
         { IDS_EASYFLASH_JUMPER_SV, "EasyFlash-bygel" },
         { IDS_EASYFLASH_JUMPER_TR, "EasyFlash jumper" },

         { IDS_SAVE_EASYFLASH_CRT_ON_DETACH,    N_("Save to EasyFlash CRT file on detach") },
         { IDS_SAVE_EASYFLASH_CRT_ON_DETACH_DA, "" },             
         { IDS_SAVE_EASYFLASH_CRT_ON_DETACH_DE, "EasyFlash CRT Imagedatei beim entfernen speichern" },
         { IDS_SAVE_EASYFLASH_CRT_ON_DETACH_FR, "" },             
         { IDS_SAVE_EASYFLASH_CRT_ON_DETACH_HU, "" },             
         { IDS_SAVE_EASYFLASH_CRT_ON_DETACH_IT, "Salva su file CRT EasyFlash alla rimozione" },
         { IDS_SAVE_EASYFLASH_CRT_ON_DETACH_NL, "Sla op naar het EasyFlash CRT bestand bij ontkoppelen" },
         { IDS_SAVE_EASYFLASH_CRT_ON_DETACH_PL, "" },             
         { IDS_SAVE_EASYFLASH_CRT_ON_DETACH_SV, "Spara till EasyFlash-CRT-fil vid frnkoppling" },
         { IDS_SAVE_EASYFLASH_CRT_ON_DETACH_TR, "kartldnda EasyFlash CRT dosyasna kaydet" },

         { IDS_SAVE_EASYFLASH_CRT_NOW,    N_("Save to EasyFlash CRT now") },
         { IDS_SAVE_EASYFLASH_CRT_NOW_DA, "" },             
         { IDS_SAVE_EASYFLASH_CRT_NOW_DE, "EasyFlash CRT Imagedatei jetzt speichern" },
         { IDS_SAVE_EASYFLASH_CRT_NOW_FR, "" },             
         { IDS_SAVE_EASYFLASH_CRT_NOW_HU, "" },             
         { IDS_SAVE_EASYFLASH_CRT_NOW_IT, "Salva su CRT EasyFlash ora" },
         { IDS_SAVE_EASYFLASH_CRT_NOW_NL, "Sla nu op naar het EasyFlash CRT bestand" },
         { IDS_SAVE_EASYFLASH_CRT_NOW_PL, "" },             
         { IDS_SAVE_EASYFLASH_CRT_NOW_SV, "Spara till EasyFlash-CRT nu" },
         { IDS_SAVE_EASYFLASH_CRT_NOW_TR, "Hemen EasyFlash CRT'ye kaydet" }

};

#include "intl_table.h"

                                                                           

static char *intl_text_table[countof(intl_translate_text_table)][countof(language_table)];

void intl_convert_mui_table(int text_id[], char *text[])
{
    int i;

    for (i = 0; text_id[i] > 0; i++) {
        text[i] = intl_translate_text(text_id[i]);
    }
    if (text_id[i] == 0) {
        text[i] = NULL;
    }
}

                                            

char *intl_convert_cp(char *text, int cp)
{
    int len;
    char *buffer;

    if (text == NULL) {
        return NULL;
    }

    len = strlen(text);

    if (len == 0) {
        return NULL;
    }

    buffer = lib_stralloc(text);

    return buffer;
}

static char *intl_get_string_by_id(int id)
{
    unsigned int k;

    for (k = 0; k < countof(intl_string_table); k++) {
        if (intl_string_table[k].resource_id==id) {
            return intl_string_table[k].text;
        }
    }
    return NULL;
}

char *intl_translate_text(int en_resource)
{
    unsigned int i;

    for (i = 0; i < countof(intl_translate_text_table); i++) {
        if (intl_translate_text_table[i][0] == en_resource) {
            if (intl_translate_text_table[i][current_language_index] != 0 &&
                intl_text_table[i][current_language_index] != NULL &&
                strlen(intl_text_table[i][current_language_index]) != 0) {
                return intl_text_table[i][current_language_index];
            } else {
                return intl_text_table[i][0];
            }
        }
    }
    return "";
}

                                                                                                                      

char *intl_speed_at_text;

                                                                           

void intl_init(void)
{
    unsigned int i,j;

    for (i = 0; i < countof(language_table); i++) {
        for (j = 0; j < countof(intl_translate_text_table); j++) {
            if (intl_translate_text_table[j][i] == 0) {
                intl_text_table[j][i] = NULL;
            } else {
                intl_text_table[j][i] = (char *)intl_get_string_by_id(intl_translate_text_table[j][i]);
            }
        }
    }
}

int intl_translate_res(int resource)
{
    return resource;
}

void intl_shutdown(void)
{
}

                                                                           


static void intl_update_pre_translated_text(void)
{
    intl_speed_at_text = intl_translate_text(IDS_S_AT_D_SPEED);
}

char *intl_arch_language_init(void)
{
    int i;
    struct Locale *amigalang;

    amigalang = OpenLocale(NULL);
    CloseLocale(amigalang);
    for (i = 0; amiga_to_iso[i].iso_language_code != NULL; i++) {
        if (!strcasecmp(amiga_to_iso[i].amiga_locale_language, amigalang->loc_LanguageName)) {
            return amiga_to_iso[i].iso_language_code;
        }
    }
    return "en";
}

void intl_update_ui(void)
{
    intl_update_pre_translated_text();
    ui_update_menus();
}
