
#include "debug.h"
#include "config.h"
#include "res.h"
#include "rescommon.h"

#pragma code_page(28591)

#define FILE_DESCRIPTION  "Vice CBM2 Emulator"



IDR_MENUCBM2 MENU DISCARDABLE
BEGIN
    POPUP N_("&File")
    BEGIN
        MENUITEM "", IDM_AUTOSTART
        MENUITEM SEPARATOR
        POPUP N_("Attach &disk image")
        BEGIN
            MENUITEM "", IDM_ATTACH_8
            MENUITEM "", IDM_ATTACH_9
            MENUITEM "", IDM_ATTACH_10
            MENUITEM "", IDM_ATTACH_11
        END
        POPUP N_("D&etach disk image")
        BEGIN
            MENUITEM "", IDM_DETACH_8
            MENUITEM "", IDM_DETACH_9
            MENUITEM "", IDM_DETACH_10
            MENUITEM "", IDM_DETACH_11
            MENUITEM SEPARATOR
            MENUITEM "", IDM_DETACH_ALL
        END
        POPUP N_("&Flip list")
        BEGIN
            MENUITEM "", IDM_FLIP_ADD
            MENUITEM "", IDM_FLIP_REMOVE
            MENUITEM "", IDM_FLIP_NEXT
            MENUITEM "", IDM_FLIP_PREVIOUS
            MENUITEM SEPARATOR
            MENUITEM "", IDM_FLIP_LOAD
            MENUITEM "", IDM_FLIP_SAVE
        END
        MENUITEM SEPARATOR
        MENUITEM "", IDM_ATTACH_TAPE
        MENUITEM "", IDM_DETACH_TAPE
        POPUP N_("Datassette contro&l")
        BEGIN
            MENUITEM "", IDM_DATASETTE_CONTROL_STOP
            MENUITEM "", IDM_DATASETTE_CONTROL_START
            MENUITEM "", IDM_DATASETTE_CONTROL_FORWARD
            MENUITEM "", IDM_DATASETTE_CONTROL_REWIND
            MENUITEM "", IDM_DATASETTE_CONTROL_RECORD
            MENUITEM "", IDM_DATASETTE_CONTROL_RESET
            MENUITEM "", IDM_DATASETTE_RESET_COUNTER
        END
        MENUITEM SEPARATOR
        MENUITEM "", IDM_PAUSE, CHECKED
        MENUITEM "", IDM_MONITOR
        POPUP N_("&Reset")
        BEGIN
            MENUITEM "", IDM_RESET_HARD
            MENUITEM "", IDM_RESET_SOFT
            MENUITEM SEPARATOR
            MENUITEM "", IDM_RESET_DRIVE8
            MENUITEM "", IDM_RESET_DRIVE9
            MENUITEM "", IDM_RESET_DRIVE10
            MENUITEM "", IDM_RESET_DRIVE11
        END
#ifdef DEBUG
        POPUP N_("&Debug")
        BEGIN
            POPUP N_("M&ode")
            BEGIN
                MENUITEM "", IDM_DEBUG_MODE_NORMAL
                MENUITEM "", IDM_DEBUG_MODE_SMALL
                MENUITEM "", IDM_DEBUG_MODE_HISTORY
                MENUITEM "", IDM_DEBUG_MODE_AUTOPLAY
            END
            MENUITEM "", IDM_TOGGLE_MAINCPU_TRACE, CHECKED
            MENUITEM "", IDM_TOGGLE_DRIVE0CPU_TRACE, CHECKED
            MENUITEM "", IDM_TOGGLE_DRIVE1CPU_TRACE, CHECKED
        END
#endif
        MENUITEM SEPARATOR
        MENUITEM "", IDM_EXIT
    END
    POPUP N_("Edit")
    BEGIN
        MENUITEM "", IDM_EDIT_COPY
        MENUITEM "", IDM_EDIT_PASTE
    END
    POPUP N_("Sna&pshot")
    BEGIN
        MENUITEM "", IDM_SNAPSHOT_LOAD
        MENUITEM "", IDM_SNAPSHOT_SAVE
        MENUITEM "", IDM_LOADQUICK
        MENUITEM "", IDM_SAVEQUICK
        MENUITEM SEPARATOR
        MENUITEM "", IDM_EVENT_TOGGLE_RECORD
        MENUITEM "", IDM_EVENT_TOGGLE_PLAYBACK
        MENUITEM "", IDM_EVENT_SETMILESTONE
        MENUITEM "", IDM_EVENT_RESETMILESTONE
        POPUP N_("Recording start mode")
        BEGIN
            MENUITEM "", IDM_EVENT_START_MODE_SAVE
            MENUITEM "", IDM_EVENT_START_MODE_LOAD
            MENUITEM "", IDM_EVENT_START_MODE_RESET
            MENUITEM "", IDM_EVENT_START_MODE_PLAYBACK
        END
        MENUITEM "", IDM_EVENT_DIRECTORY
        MENUITEM SEPARATOR
        MENUITEM "", IDM_MEDIAFILE
        MENUITEM SEPARATOR
        MENUITEM "", IDM_SOUND_RECORD_START
        MENUITEM "", IDM_SOUND_RECORD_STOP
    END
    POPUP N_("&Options")
    BEGIN
        POPUP N_("&Refresh rate")
        BEGIN
            MENUITEM "",      IDM_REFRESH_RATE_AUTO
            MENUITEM N_("1/&1"),  IDM_REFRESH_RATE_1
            MENUITEM N_("1/&2"),  IDM_REFRESH_RATE_2
            MENUITEM N_("1/&3"),  IDM_REFRESH_RATE_3
            MENUITEM N_("1/&4"),  IDM_REFRESH_RATE_4
            MENUITEM N_("1/&5"),  IDM_REFRESH_RATE_5
            MENUITEM N_("1/&6"),  IDM_REFRESH_RATE_6
            MENUITEM N_("1/&7"),  IDM_REFRESH_RATE_7
            MENUITEM N_("1/&8"),  IDM_REFRESH_RATE_8
            MENUITEM N_("1/&9"),  IDM_REFRESH_RATE_9
            MENUITEM N_("1/1&0"), IDM_REFRESH_RATE_10
        END
        POPUP N_("&Maximum Speed")
        BEGIN
            MENUITEM N_("&200%"), IDM_MAXIMUM_SPEED_200
            MENUITEM N_("&100%"), IDM_MAXIMUM_SPEED_100
            MENUITEM N_("&50%"),  IDM_MAXIMUM_SPEED_50
            MENUITEM N_("&20%"),  IDM_MAXIMUM_SPEED_20
            MENUITEM N_("1&0%"),  IDM_MAXIMUM_SPEED_10
            MENUITEM "",      IDM_MAXIMUM_SPEED_NO_LIMIT
            MENUITEM SEPARATOR
            MENUITEM "",      IDM_MAXIMUM_SPEED_CUSTOM
        END
        MENUITEM "", IDM_TOGGLE_WARP_MODE, CHECKED
        MENUITEM SEPARATOR
        MENUITEM "", IDM_TOGGLE_FULLSCREEN
        MENUITEM "", IDM_TOGGLE_ALWAYSONTOP
        MENUITEM SEPARATOR
        MENUITEM "", IDM_TOGGLE_CRTCVIDEOCACHE, CHECKED
        MENUITEM "", IDM_TOGGLE_CRTCDOUBLESIZE, CHECKED
        MENUITEM "", IDM_TOGGLE_CRTCDOUBLESCAN, CHECKED
        MENUITEM SEPARATOR
        MENUITEM "", IDM_SWAP_JOYSTICK
        MENUITEM "", IDM_ALLOW_JOY_OPPOSITE_TOGGLE
        MENUITEM "", IDM_JOYKEYS_TOGGLE
        MENUITEM SEPARATOR
        MENUITEM "", IDM_TOGGLE_SOUND, CHECKED
        MENUITEM SEPARATOR
        MENUITEM "", IDM_TOGGLE_DRIVE_TRUE_EMULATION, CHECKED
        MENUITEM "", IDM_TOGGLE_AUTOSTART_HANDLE_TDE
        MENUITEM "", IDM_TOGGLE_VIRTUAL_DEVICES
        POPUP N_("Drive s&ync factor")
        BEGIN
            MENUITEM N_("&PAL"),  IDM_SYNC_FACTOR_PAL
            MENUITEM N_("&NTSC"), IDM_SYNC_FACTOR_NTSC
        END
        MENUITEM SEPARATOR
        MENUITEM "", IDM_TOGGLE_EMUID
    END
    POPUP N_("S&ettings")
    BEGIN
        MENUITEM "", IDM_AUTOSTART_SETTINGS
        MENUITEM "", IDM_VIDEO_SETTINGS
        MENUITEM "", IDM_CBM2_SETTINGS
        MENUITEM "", IDM_DEVICEMANAGER
        MENUITEM "", IDM_DRIVE_SETTINGS
        MENUITEM "", IDM_DATASETTE_SETTINGS
        MENUITEM "", IDM_JOY_SETTINGS
        MENUITEM "", IDM_KEYBOARD_SETTINGS
        MENUITEM "", IDM_SOUND_SETTINGS
        MENUITEM "", IDM_SID_SETTINGS
        MENUITEM "", IDM_ROM_SETTINGS
        MENUITEM "", IDM_RAM_SETTINGS
        MENUITEM "", IDM_RS232_SETTINGS
        POPUP N_("&Cartridge/IO Settings")
        BEGIN
            MENUITEM "", IDM_ACIA_SETTINGS
        END
        MENUITEM SEPARATOR
        MENUITEM "", IDM_SETTINGS_SAVE_FILE
        MENUITEM "", IDM_SETTINGS_LOAD_FILE
        MENUITEM "", IDM_SETTINGS_SAVE
        MENUITEM "", IDM_SETTINGS_LOAD
        MENUITEM "", IDM_SETTINGS_DEFAULT
        MENUITEM SEPARATOR
        MENUITEM "", IDM_TOGGLE_SAVE_SETTINGS_ON_EXIT
        MENUITEM "", IDM_TOGGLE_CONFIRM_ON_EXIT
    END
    POPUP N_("&Language")
    BEGIN
        MENUITEM "", IDM_LANG_EN
        MENUITEM "", IDM_LANG_DA
        MENUITEM "", IDM_LANG_DE
        MENUITEM "", IDM_LANG_FR
        MENUITEM "", IDM_LANG_HU
        MENUITEM "", IDM_LANG_IT
        MENUITEM "", IDM_LANG_NL
        MENUITEM "", IDM_LANG_PL
        MENUITEM "", IDM_LANG_SV
        MENUITEM "", IDM_LANG_TR
    END
    POPUP N_("&Help")
    BEGIN
        MENUITEM "", IDM_HELP
        MENUITEM SEPARATOR
        MENUITEM "", IDM_ABOUT
        MENUITEM SEPARATOR
        MENUITEM "", IDM_CMDLINE
        MENUITEM SEPARATOR
        MENUITEM "", IDM_CONTRIBUTORS
        MENUITEM "", IDM_LICENSE
        MENUITEM "", IDM_WARRANTY
    END
END



IDD_CBM2ROM_SETTINGS_DIALOG DIALOG DISCARDABLE  0, 0, 240, 150
BEGIN
    LTEXT       "", IDC_KERNAL,
                9, 8, 40, 8
    EDITTEXT    IDC_CBM2ROM_KERNAL_FILE,
                55, 7, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON  "", IDC_CBM2ROM_KERNAL_BROWSE,
                185, 7, 50, 14, 0

    LTEXT       "", IDC_BASIC,
                9, 28, 40, 8
    EDITTEXT    IDC_CBM2ROM_BASIC_FILE,
                55, 27, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON  "", IDC_CBM2ROM_BASIC_BROWSE,
                185, 27, 50, 14, 0

    LTEXT       "", IDC_CHARACTER,
                9, 48, 40, 8
    EDITTEXT    IDC_CBM2ROM_CHARGEN_FILE,
                55, 47, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON  "", IDC_CBM2ROM_CHARGEN_BROWSE,
                185, 47, 50, 14, 0

    LTEXT       "", IDC_CART_1,
                9, 68, 40, 8
    EDITTEXT    IDC_CBM2ROM_CART1_FILE,
                55, 67, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON  "", IDC_CBM2ROM_CART1_BROWSE,
                185, 67, 50, 14, 0

    LTEXT       "", IDC_CART_2,
                9, 88, 40, 8
    EDITTEXT    IDC_CBM2ROM_CART2_FILE,
                55, 87, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON  "", IDC_CBM2ROM_CART2_BROWSE,
                185, 87, 50, 14, 0

    LTEXT       "", IDC_CART_4,
                9, 108, 40, 8
    EDITTEXT    IDC_CBM2ROM_CART4_FILE,
                55, 107, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON  "", IDC_CBM2ROM_CART4_BROWSE,
                185, 107, 50, 14, 0

    LTEXT       "", IDC_CART_6,
                9, 128, 40, 8
    EDITTEXT    IDC_CBM2ROM_CART6_FILE,
                55, 127, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON  "", IDC_CBM2ROM_CART6_BROWSE,
                185, 127, 50, 14, 0
END



IDD_CBM2DRIVEROM_SETTINGS_DIALOG DIALOG DISCARDABLE  0, 0, 240, 110
BEGIN
    LTEXT       N_("2031"), IDC_2031,
                9, 8, 40, 8
    EDITTEXT    IDC_DRIVEROM_2031_FILE,
                55, 7, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON  "", IDC_DRIVEROM_2031_BROWSE,
                185, 7, 50, 14, 0

    LTEXT       N_("2040"), IDC_2040,
                9, 28, 40, 8
    EDITTEXT    IDC_DRIVEROM_2040_FILE,
                55, 27, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON  "", IDC_DRIVEROM_2040_BROWSE,
                185, 27, 50, 14, 0

    LTEXT       N_("3040"), IDC_3040,
                9, 48, 40, 8
    EDITTEXT    IDC_DRIVEROM_3040_FILE,
                55, 47, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON  "", IDC_DRIVEROM_3040_BROWSE,
                185, 47, 50, 14, 0

    LTEXT       N_("4040"), IDC_4040,
                9, 68, 40, 8
    EDITTEXT    IDC_DRIVEROM_4040_FILE,
                55, 67, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON  "", IDC_DRIVEROM_4040_BROWSE,
                185, 67, 50, 14, 0

    LTEXT       N_("1001"), IDC_1001,
                9, 88, 40, 8
    EDITTEXT    IDC_DRIVEROM_1001_FILE,
                55, 87, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON  "", IDC_DRIVEROM_1001_BROWSE,
                185, 87, 50, 14, 0
END



IDD_CBM2ROM_RESOURCE_DIALOG DIALOG DISCARDABLE 0, 0, 160, 145
BEGIN
    GROUPBOX        "", IDC_COMPUTER_RESOURCES,
                    4, 3, 151, 115
    AUTOCHECKBOX    "", IDC_CBM2ROM_KERNAL_RESOURCE,
                    11, 13, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX    "", IDC_CBM2ROM_BASIC_RESOURCE,
                    11, 28, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX    "", IDC_CBM2ROM_CHARGEN_RESOURCE,
                    11, 43, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX    "", IDC_CBM2ROM_CART1_RESOURCE,
                    11, 58, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX    "", IDC_CBM2ROM_CART2_RESOURCE,
                    11, 73, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX    "", IDC_CBM2ROM_CART4_RESOURCE,
                    11, 88, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX    "", IDC_CBM2ROM_CART6_RESOURCE,
                    11, 103, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP

    DEFPUSHBUTTON   "", IDOK,
                    20, 125, 50, 14, WS_TABSTOP
    PUSHBUTTON      "", IDCANCEL,
                    80, 125, 50, 14, WS_TABSTOP
END



IDD_CBM2ROMDRIVE_RESOURCE_DIALOG DIALOG DISCARDABLE 0, 0, 160, 115
BEGIN
    GROUPBOX        "", IDC_DRIVE_RESOURCES,
                    4, 3, 151, 85
    AUTOCHECKBOX    N_("2031"), IDC_DRIVEROM_2031_RESOURCE,
                    11, 13, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX    N_("2040"), IDC_DRIVEROM_2040_RESOURCE,
                    11, 28, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX    N_("3040"), IDC_DRIVEROM_3040_RESOURCE,
                    11, 43, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX    N_("4040"), IDC_DRIVEROM_4040_RESOURCE,
                    11, 58, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX    N_("1001"), IDC_DRIVEROM_1001_RESOURCE,
                    11, 73, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP

    DEFPUSHBUTTON   "", IDOK,
                    20, 95, 50, 14, WS_TABSTOP
    PUSHBUTTON      "", IDCANCEL,
                    80, 95, 50, 14, WS_TABSTOP
END



IDD_CBMII_SETTINGS_MODEL_DIALOG DIALOG DISCARDABLE 0, 0, 230, 145
BEGIN
    GROUPBOX        "", IDC_MACHINE_DEFAULTS,
                    5, 15, 70, 111
    PUSHBUTTON      N_("CBM 610"),IDC_SELECT_CBMII_610,
                    15, 28, 50, 14, WS_GROUP
    PUSHBUTTON      N_("CBM 620"),IDC_SELECT_CBMII_620,
                    15, 43, 50, 14, WS_GROUP
    PUSHBUTTON      N_("CBM 620+"), IDC_SELECT_CBMII_620P,
                    15, 58, 50, 14, WS_GROUP
    PUSHBUTTON      N_("CBM 710"), IDC_SELECT_CBMII_710,
                    15, 73, 50, 14, WS_GROUP
    PUSHBUTTON      N_("CBM 720"), IDC_SELECT_CBMII_720,
                    15, 88, 50, 14, WS_GROUP
    PUSHBUTTON      N_("CBM 720+"), IDC_SELECT_CBMII_720P,
                    15, 103, 50, 14, WS_GROUP
    GROUPBOX        "", IDC_MODEL_LINE,
                    95, 15, 80, 60
    AUTORADIOBUTTON N_("&7x0 (50 Hz)"), IDC_SELECT_CBMII_HW0,
                    105, 30, 65, 10, BS_AUTORADIOBUTTON | WS_GROUP | WS_TABSTOP
    AUTORADIOBUTTON N_("6x0 &60 Hz"), IDC_SELECT_CBMII_HW1,
                    105, 45, 65, 10, BS_AUTORADIOBUTTON
    AUTORADIOBUTTON N_("6x0 &50 Hz"), IDC_SELECT_CBMII_HW2,
                    105,60,65,10, BS_AUTORADIOBUTTON
END



IDD_CBMII_SETTINGS_IO_DIALOG DIALOG DISCARDABLE 0, 0, 230, 145
BEGIN
    GROUPBOX        "", IDC_CBM2_MEMORY,
                    5, 15, 70, 75
    AUTORADIOBUTTON "", IDC_SELECT_CBMII_MEM_128,
                    15, 30, 55, 10, BS_AUTORADIOBUTTON | WS_GROUP | WS_TABSTOP
    AUTORADIOBUTTON "", IDC_SELECT_CBMII_MEM_256,
                    15, 45, 55, 10, BS_AUTORADIOBUTTON
    AUTORADIOBUTTON "", IDC_SELECT_CBMII_MEM_512,
                    15, 60, 55, 10, BS_AUTORADIOBUTTON
    AUTORADIOBUTTON "",IDC_SELECT_CBMII_MEM_1024,
                    15, 75, 55, 10, BS_AUTORADIOBUTTON
    GROUPBOX        "", IDC_RAM_BANKS,
                    95, 15, 130, 105
    AUTOCHECKBOX    "", IDC_TOGGLE_CBMII_RAM08,
                    105, 30, 115, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX    "", IDC_TOGGLE_CBMII_RAM1,
                    105, 45, 115, 10, BS_AUTOCHECKBOX
    AUTOCHECKBOX    "", IDC_TOGGLE_CBMII_RAM2,
                    105, 60, 115, 10, BS_AUTOCHECKBOX
    AUTOCHECKBOX    "", IDC_TOGGLE_CBMII_RAM4,
                    105, 75, 115, 10, BS_AUTOCHECKBOX
    AUTOCHECKBOX    "", IDC_TOGGLE_CBMII_RAM6,
                    105, 90, 115, 10, BS_AUTOCHECKBOX
    AUTOCHECKBOX    "",IDC_TOGGLE_CBMII_RAMC,
                    105, 105, 115, 10, BS_AUTOCHECKBOX
END



IDD_CBM2KBD_MAPPING_SETTINGS_DIALOG DIALOG DISCARDABLE 0, 0, 240, 180
BEGIN
    AUTORADIOBUTTON "", IDC_CBM2KBD_MAPPING_SELECT_GRSYM,
                    10, 10, 54, 10, BS_AUTORADIOBUTTON | WS_GROUP | WS_TABSTOP
    AUTORADIOBUTTON "", IDC_CBM2KBD_MAPPING_SELECT_GRPOS,
                    10, 30, 54, 10, BS_AUTORADIOBUTTON
    AUTORADIOBUTTON "", IDC_CBM2KBD_MAPPING_SELECT_UKSYM,
                    10, 50, 54, 10, BS_AUTORADIOBUTTON | WS_GROUP | WS_TABSTOP
    AUTORADIOBUTTON "", IDC_CBM2KBD_MAPPING_SELECT_UKPOS,
                    10, 70, 54, 10, BS_AUTORADIOBUTTON
    AUTORADIOBUTTON "", IDC_CBM2KBD_MAPPING_SELECT_DESYM,
                    10, 90, 54, 10, BS_AUTORADIOBUTTON | WS_GROUP | WS_TABSTOP
    AUTORADIOBUTTON "", IDC_CBM2KBD_MAPPING_SELECT_DEPOS,
                    10, 110, 54, 10, BS_AUTORADIOBUTTON

    EDITTEXT        IDC_CBM2KBD_MAPPING_GRSYM,
                    65, 9, 110, 12, WS_TABSTOP
    PUSHBUTTON      "", IDC_CBM2KBD_MAPPING_GRSYM_BROWSE,
                    185, 9, 50, 14, 0
    EDITTEXT        IDC_CBM2KBD_MAPPING_GRPOS,
                    65, 29, 110, 12, WS_TABSTOP
    PUSHBUTTON      "", IDC_CBM2KBD_MAPPING_GRPOS_BROWSE,
                    185, 29, 50, 14, 0
    EDITTEXT        IDC_CBM2KBD_MAPPING_UKSYM,
                    65, 49, 110, 12, WS_TABSTOP
    PUSHBUTTON      "", IDC_CBM2KBD_MAPPING_UKSYM_BROWSE,
                    185, 49, 50, 14, 0
    EDITTEXT        IDC_CBM2KBD_MAPPING_UKPOS,
                    65, 69, 110, 12, WS_TABSTOP
    PUSHBUTTON      "", IDC_CBM2KBD_MAPPING_UKPOS_BROWSE,
                    185, 69, 50, 14, 0
    EDITTEXT        IDC_CBM2KBD_MAPPING_DESYM,
                    65, 89, 110, 12, WS_TABSTOP
    PUSHBUTTON      "", IDC_CBM2KBD_MAPPING_DESYM_BROWSE,
                    185, 89, 50, 14, 0
    EDITTEXT        IDC_CBM2KBD_MAPPING_DEPOS,
                    65, 109, 110, 12, WS_TABSTOP
    PUSHBUTTON      "", IDC_CBM2KBD_MAPPING_DEPOS_BROWSE,
                    185, 109, 50, 14, 0

    PUSHBUTTON      "", IDC_CBM2KBD_MAPPING_DUMP,
                    10, 134, 60, 14, 0
    PUSHBUTTON      "", IDC_KBD_SHORTCUT_DUMP,
                    80, 134, 60, 14, 0

    DEFPUSHBUTTON   "", IDOK,
                    20, 160, 50, 14, WS_TABSTOP
    PUSHBUTTON      "", IDCANCEL,
                    80, 160, 50, 14, WS_TABSTOP
END



STRINGTABLE
BEGIN
  IDS_MEMORY                N_("Memory")
  IDS_CBM2_SETTINGS         N_("CBM2 settings")
  IDS_CART_1                N_("Cart 1")
  IDS_CART_2                N_("Cart 2")
  IDS_CART_4                N_("Cart 4")
  IDS_CART_6                N_("Cart 6")
  IDS_MACHINE_DEFAULTS      N_("Machine &defaults")
  IDS_MODEL_LINE            N_("&Model line")
  IDS_SELECT_CBMII_MEM_128  N_("12&8 kByte")
  IDS_SELECT_CBMII_MEM_256  N_("2&56 kByte")
  IDS_SELECT_CBMII_MEM_512  N_("512 &kByte")
  IDS_SELECT_CBMII_MEM_1024 N_("1024 kByt&e")
  IDS_CBM2_RAM_BANKS        N_("&Ram banks")
  IDS_TOGGLE_CBMII_RAM08    N_("Bank 15 $&0800-$0FFF RAM")
  IDS_TOGGLE_CBMII_RAM1     N_("Bank 15 $&1000-$1FFF RAM")
  IDS_TOGGLE_CBMII_RAM2     N_("Bank 15 $&2000-$3FFF RAM")
  IDS_TOGGLE_CBMII_RAM4     N_("Bank 15 $&4000-$5FFF RAM")
  IDS_TOGGLE_CBMII_RAM6     N_("Bank 15 $&6000-$7FFF RAM")
  IDS_TOGGLE_CBMII_RAMC     N_("Bank 15 $&C000-$CFFF RAM")
  IDS_MI_CBM2_SETTINGS      N_("&CBM2 settings...")
END



STRINGTABLE
LANGUAGE LANG_DANISH, SUBLANG_NEUTRAL
BEGIN
  IDS_MEMORY                "Hukommelse"
  IDS_CBM2_SETTINGS         "CBM2-indstillinger"
  IDS_CART_1                "Cartridge 1"
  IDS_CART_2                "Cartridge 2"
  IDS_CART_4                "Cartridge 4"
  IDS_CART_6                "Cartridge 6"
  IDS_MACHINE_DEFAULTS      "Maskinens stan&dardindstillinger"
  IDS_MODEL_LINE            "&Modelltyp"
  IDS_SELECT_CBMII_MEM_128  "12&8 kByte"
  IDS_SELECT_CBMII_MEM_256  "2&56 kByte"
  IDS_SELECT_CBMII_MEM_512  "512 &kByte"
  IDS_SELECT_CBMII_MEM_1024 "1024 kByt&e"
  IDS_CBM2_RAM_BANKS        "&RAM-banker"
  IDS_TOGGLE_CBMII_RAM08    "Bank 15 $&0800-$0FFF RAM"
  IDS_TOGGLE_CBMII_RAM1     "Bank 15 $&1000-$1FFF RAM"
  IDS_TOGGLE_CBMII_RAM2     "Bank 15 $&2000-$3FFF RAM"
  IDS_TOGGLE_CBMII_RAM4     "Bank 15 $&4000-$5FFF RAM"
  IDS_TOGGLE_CBMII_RAM6     "Bank 15 $&6000-$7FFF RAM"
  IDS_TOGGLE_CBMII_RAMC     "Bank 15 $&C000-$CFFF RAM"
  IDS_MI_CBM2_SETTINGS      "&CBM2-indstillinger..."
END



STRINGTABLE
LANGUAGE LANG_GERMAN, SUBLANG_NEUTRAL
BEGIN
  IDS_MEMORY                "Speicher"
  IDS_CBM2_SETTINGS         "CBM2 Einstellungen"
  IDS_CART_1                "Cart 1"
  IDS_CART_2                "Cart 2"
  IDS_CART_4                "Cart 4"
  IDS_CART_6                "Cart 6"
  IDS_MACHINE_DEFAULTS      "Modell Stan&dardeinstellungen"
  IDS_MODEL_LINE            "&Modell Linie"
  IDS_SELECT_CBMII_MEM_128  "12&8 kByte"
  IDS_SELECT_CBMII_MEM_256  "2&56 kByte"
  IDS_SELECT_CBMII_MEM_512  "512 &kByte"
  IDS_SELECT_CBMII_MEM_1024 "1024 kByt&e"
  IDS_CBM2_RAM_BANKS        "&Ram Bnke"
  IDS_TOGGLE_CBMII_RAM08    "Bank 15 $&0800-$0FFF RAM"
  IDS_TOGGLE_CBMII_RAM1     "Bank 15 $&1000-$1FFF RAM"
  IDS_TOGGLE_CBMII_RAM2     "Bank 15 $&2000-$3FFF RAM"
  IDS_TOGGLE_CBMII_RAM4     "Bank 15 $&4000-$5FFF RAM"
  IDS_TOGGLE_CBMII_RAM6     "Bank 15 $&6000-$7FFF RAM"
  IDS_TOGGLE_CBMII_RAMC     "Bank 15 $&C000-$CFFF RAM"
  IDS_MI_CBM2_SETTINGS      "&CBM2 Einstellungen..."
END



STRINGTABLE
LANGUAGE LANG_FRENCH, SUBLANG_NEUTRAL
BEGIN
  IDS_MEMORY                "Mmoire"
  IDS_CBM2_SETTINGS         "Paramtres CBM2"
  IDS_CART_1                "Cartouche 1"
  IDS_CART_2                "Cartouche 2"
  IDS_CART_4                "Cartouche 4"
  IDS_CART_6                "Cartouche 6"
  IDS_MACHINE_DEFAULTS      "Valeurs par d&faut du modle"
  IDS_MODEL_LINE            "Ligne du &modle"
  IDS_SELECT_CBMII_MEM_128  "12&8 kOctets"
  IDS_SELECT_CBMII_MEM_256  "2&56 kOctets"
  IDS_SELECT_CBMII_MEM_512  "512 &kOctets"
  IDS_SELECT_CBMII_MEM_1024 "102&4 kOctets"
  IDS_CBM2_RAM_BANKS        "Banques de &RAM"
  IDS_TOGGLE_CBMII_RAM08    "Banque 15 $&0800-$0FFF RAM"
  IDS_TOGGLE_CBMII_RAM1     "Banque 15 $&1000-$1FFF RAM"
  IDS_TOGGLE_CBMII_RAM2     "Banque 15 $&2000-$3FFF RAM"
  IDS_TOGGLE_CBMII_RAM4     "Banque 15 $&4000-$5FFF RAM"
  IDS_TOGGLE_CBMII_RAM6     "Banque 15 $&6000-$7FFF RAM"
  IDS_TOGGLE_CBMII_RAMC     "Banque 15 $&C000-$CFFF RAM"
  IDS_MI_CBM2_SETTINGS      "Paramtres &CBM2..."
END



#pragma code_page(28592)
STRINGTABLE
LANGUAGE LANG_HUNGARIAN, SUBLANG_NEUTRAL
BEGIN
  IDS_MEMORY                "Memria"
  IDS_CBM2_SETTINGS         "CBM2 belltsai"
  IDS_CART_1                "Cart 1"
  IDS_CART_2                "Cart 2"
  IDS_CART_4                "Cart 4"
  IDS_CART_6                "Cart 6"
  IDS_MACHINE_DEFAULTS      "Gp &alaprtelmezsei"
  IDS_MODEL_LINE            "&Modell sor"
  IDS_SELECT_CBMII_MEM_128  "12&8 kBjt"
  IDS_SELECT_CBMII_MEM_256  "2&56 kBjt"
  IDS_SELECT_CBMII_MEM_512  "512 &kBjt"
  IDS_SELECT_CBMII_MEM_1024 "1024 kBj&t"
  IDS_CBM2_RAM_BANKS        "&Ram bankok"
  IDS_TOGGLE_CBMII_RAM08    "Bank 15 $&0800-$0FFF RAM"
  IDS_TOGGLE_CBMII_RAM1     "Bank 15 $&1000-$1FFF RAM"
  IDS_TOGGLE_CBMII_RAM2     "Bank 15 $&2000-$3FFF RAM"
  IDS_TOGGLE_CBMII_RAM4     "Bank 15 $&4000-$5FFF RAM"
  IDS_TOGGLE_CBMII_RAM6     "Bank 15 $&6000-$7FFF RAM"
  IDS_TOGGLE_CBMII_RAMC     "Bank 15 $&C000-$CFFF RAM"
  IDS_MI_CBM2_SETTINGS      "&CBM2 belltsai..."
END
#pragma code_page(28591)



STRINGTABLE
LANGUAGE LANG_ITALIAN, SUBLANG_NEUTRAL
BEGIN
  IDS_MEMORY                "Memoria"
  IDS_CBM2_SETTINGS         "Impostazioni CBM2"
  IDS_CART_1                "Cart 1"
  IDS_CART_2                "Cart 2"
  IDS_CART_4                "Cart 4"
  IDS_CART_6                "Cart 6"
  IDS_MACHINE_DEFAULTS      "Impostazioni &predefinite"
  IDS_MODEL_LINE            "&Linea"
  IDS_SELECT_CBMII_MEM_128  "12&8 kByte"
  IDS_SELECT_CBMII_MEM_256  "2&56 kByte"
  IDS_SELECT_CBMII_MEM_512  "512 &kByte"
  IDS_SELECT_CBMII_MEM_1024 "1024 kByt&e"
  IDS_CBM2_RAM_BANKS        "Banchi di &Ram"
  IDS_TOGGLE_CBMII_RAM08    "RAM del banco 15 a $&0800-$0FFF"
  IDS_TOGGLE_CBMII_RAM1     "RAM del banco 15 a $&1000-$1FFF"
  IDS_TOGGLE_CBMII_RAM2     "RAM del banco 15 a $&2000-$3FFF"
  IDS_TOGGLE_CBMII_RAM4     "RAM del banco 15 a $&4000-$5FFF"
  IDS_TOGGLE_CBMII_RAM6     "RAM del banco 15 a $&6000-$7FFF"
  IDS_TOGGLE_CBMII_RAMC     "RAM del banco 15 a $&C000-$CFFF"
  IDS_MI_CBM2_SETTINGS      "Impostazioni &CBM2..."
END



STRINGTABLE
LANGUAGE LANG_DUTCH, SUBLANG_NEUTRAL
BEGIN
  IDS_MEMORY                "Geheugen"
  IDS_CBM2_SETTINGS         "CBM2 instellingen"
  IDS_CART_1                "Cart 1"
  IDS_CART_2                "Cart 2"
  IDS_CART_4                "Cart 4"
  IDS_CART_6                "Cart 6"
  IDS_MACHINE_DEFAULTS      "Machine &standaards"
  IDS_MODEL_LINE            "&Model lijn"
  IDS_SELECT_CBMII_MEM_128  "12&8 kByte"
  IDS_SELECT_CBMII_MEM_256  "2&56 kByte"
  IDS_SELECT_CBMII_MEM_512  "512 &kByte"
  IDS_SELECT_CBMII_MEM_1024 "1024 kByt&e"
  IDS_CBM2_RAM_BANKS        "&Ram banken"
  IDS_TOGGLE_CBMII_RAM08    "Bank 15 $&0800-$0FFF RAM"
  IDS_TOGGLE_CBMII_RAM1     "Bank 15 $&1000-$1FFF RAM"
  IDS_TOGGLE_CBMII_RAM2     "Bank 15 $&2000-$3FFF RAM"
  IDS_TOGGLE_CBMII_RAM4     "Bank 15 $&4000-$5FFF RAM"
  IDS_TOGGLE_CBMII_RAM6     "Bank 15 $&6000-$7FFF RAM"
  IDS_TOGGLE_CBMII_RAMC     "Bank 15 $&C000-$CFFF RAM"
  IDS_MI_CBM2_SETTINGS      "&CBM2 instellingen..."
END



#pragma code_page(28592)
STRINGTABLE
LANGUAGE LANG_POLISH, SUBLANG_NEUTRAL
BEGIN
  IDS_MEMORY                "Memory"
  IDS_CBM2_SETTINGS         "CBM2 settings"
  IDS_CART_1                "Kartrid 1"
  IDS_CART_2                "Kartrid 2"
  IDS_CART_4                "Kartrid 4"
  IDS_CART_6                "Kartrid 6"
  IDS_MACHINE_DEFAULTS      "Model &domylny"
  IDS_MODEL_LINE            "&Model line"
  IDS_SELECT_CBMII_MEM_128  "12&8 kBajty"
  IDS_SELECT_CBMII_MEM_256  "2&56 kBajty"
  IDS_SELECT_CBMII_MEM_512  "512 &kBajty"
  IDS_SELECT_CBMII_MEM_1024 "1024 kBajt&y"
  IDS_CBM2_RAM_BANKS        "&Ram banks"
  IDS_TOGGLE_CBMII_RAM08    "Bank 15 $&0800-$0FFF RAM"
  IDS_TOGGLE_CBMII_RAM1     "Bank 15 $&1000-$1FFF RAM"
  IDS_TOGGLE_CBMII_RAM2     "Bank 15 $&2000-$3FFF RAM"
  IDS_TOGGLE_CBMII_RAM4     "Bank 15 $&4000-$5FFF RAM"
  IDS_TOGGLE_CBMII_RAM6     "Bank 15 $&6000-$7FFF RAM"
  IDS_TOGGLE_CBMII_RAMC     "Bank 15 $&C000-$CFFF RAM"
  IDS_MI_CBM2_SETTINGS      "Ustawienia &CBM2..."
END
#pragma code_page(28591)



STRINGTABLE
LANGUAGE LANG_SWEDISH, SUBLANG_NEUTRAL
BEGIN
  IDS_MEMORY                "Minne"
  IDS_CBM2_SETTINGS         "CBM2-instllningar"
  IDS_CART_1                "Modul 1"
  IDS_CART_2                "Modul 2"
  IDS_CART_4                "Modul 4"
  IDS_CART_6                "Modul 6"
  IDS_MACHINE_DEFAULTS      "Modellens &frval"
  IDS_MODEL_LINE            "&Modelltyp"
  IDS_SELECT_CBMII_MEM_128  "12&8 kByte"
  IDS_SELECT_CBMII_MEM_256  "2&56 kByte"
  IDS_SELECT_CBMII_MEM_512  "512 &kByte"
  IDS_SELECT_CBMII_MEM_1024 "1024 kByt&e"
  IDS_CBM2_RAM_BANKS        "&Ram-bankar"
  IDS_TOGGLE_CBMII_RAM08    "Bank 15 $&0800-$0FFF RAM"
  IDS_TOGGLE_CBMII_RAM1     "Bank 15 $&1000-$1FFF RAM"
  IDS_TOGGLE_CBMII_RAM2     "Bank 15 $&2000-$3FFF RAM"
  IDS_TOGGLE_CBMII_RAM4     "Bank 15 $&4000-$5FFF RAM"
  IDS_TOGGLE_CBMII_RAM6     "Bank 15 $&6000-$7FFF RAM"
  IDS_TOGGLE_CBMII_RAMC     "Bank 15 $&C000-$CFFF RAM"
  IDS_MI_CBM2_SETTINGS      "&CBM2-instllningar..."
END



#pragma code_page(28599)
STRINGTABLE
LANGUAGE LANG_TURKISH, SUBLANG_NEUTRAL
BEGIN
  IDS_MEMORY                "Bellek"
  IDS_CBM2_SETTINGS         "CBM2 ayarlar"
  IDS_CART_1                "Kartu 1"
  IDS_CART_2                "Kartu 2"
  IDS_CART_4                "Kartu 4"
  IDS_CART_6                "Kartu 6"
  IDS_MACHINE_DEFAULTS      "Makine &varsaylan ayarlar"
  IDS_MODEL_LINE            "&Model hatt"
  IDS_SELECT_CBMII_MEM_128  "12&8 kByte"
  IDS_SELECT_CBMII_MEM_256  "2&56 kByte"
  IDS_SELECT_CBMII_MEM_512  "512 &kByte"
  IDS_SELECT_CBMII_MEM_1024 "1024 kByt&e"
  IDS_CBM2_RAM_BANKS        "&Ram banklar"
  IDS_TOGGLE_CBMII_RAM08    "Bank 15 $&0800-$0FFF RAM"
  IDS_TOGGLE_CBMII_RAM1     "Bank 15 $&1000-$1FFF RAM"
  IDS_TOGGLE_CBMII_RAM2     "Bank 15 $&2000-$3FFF RAM"
  IDS_TOGGLE_CBMII_RAM4     "Bank 15 $&4000-$5FFF RAM"
  IDS_TOGGLE_CBMII_RAM6     "Bank 15 $&6000-$7FFF RAM"
  IDS_TOGGLE_CBMII_RAMC     "Bank 15 $&C000-$CFFF RAM"
  IDS_MI_CBM2_SETTINGS      "&CBM2 ayarlar..."
END
#pragma code_page(28591)
