/*
 * res.rc - Common UI resources.
 *
 * Written by
 *  Andreas Boose <viceteam@t-online.de>
 *  Ettore Perazzoli <ettore@comm2000.it>
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */

#include "config.h"
#include "debug.h"
#include "version.h"
#include "res.h"
#include "rescommon.h"
#if defined(MSVC_RC) && !defined(WATCOM_COMPILE)
#include "msvc_ver.h"
#endif

#pragma code_page(28591)

1 VERSIONINFO
 FILEVERSION VERSION_RC_NUMBER
 PRODUCTVERSION VERSION_RC_NUMBER
 FILEFLAGSMASK 0x3fL
#ifdef _DEBUG
 FILEFLAGS 0x1L
#else
 FILEFLAGS 0x0L
#endif
 FILEOS 0x4L
 FILETYPE 0x1L
 FILESUBTYPE 0x0L
BEGIN
    BLOCK "StringFileInfo"
    BEGIN
        BLOCK "04090000"
        BEGIN
            VALUE "CompanyName",     "Vice Team"
            VALUE "FileDescription", FILE_DESCRIPTION
            VALUE "FileVersion",     VERSION
            VALUE "ProductName",     FILE_DESCRIPTION
            VALUE "ProductVersion",  VERSION
        END
    END
    BLOCK "VarFileInfo"
    BEGIN
        VALUE "Translation", 0x409, 0
    END
END

#ifndef MSVC_RC
1 RT_MANIFEST "vice.manifest"
#else
#if MSVC_VER < 1400
1 RT_MANIFEST "vice.manifest"
#endif
#endif



IDR_MENUMONITOR MENU DISCARDABLE
BEGIN
    POPUP N_("&File")
    BEGIN
        MENUITEM "", IDM_MON_OPEN
        MENUITEM "", IDM_MON_SAVE
        MENUITEM "", IDM_MON_PRINT
        MENUITEM SEPARATOR
        MENUITEM "", IDM_EXIT
    END
    POPUP N_("&Debug")
    BEGIN
        MENUITEM "", IDM_MON_STOP_DEBUG
        MENUITEM "", IDM_MON_STOP_EXEC
        MENUITEM SEPARATOR
        MENUITEM "", IDM_MON_STEP_INTO
        MENUITEM "", IDM_MON_STEP_OVER
        MENUITEM "", IDM_MON_SKIP_RETURN
        MENUITEM "", IDM_MON_GOTO_CURSOR
        MENUITEM SEPARATOR
        MENUITEM "", IDM_MON_EVAL
    END
    POPUP N_("&View")
    BEGIN
        MENUITEM "", IDM_MON_CURRENT
        MENUITEM SEPARATOR
        MENUITEM "", IDM_MON_WND_EVAL
        MENUITEM "", IDM_MON_WND_REG
        MENUITEM "", IDM_MON_WND_MEM
        MENUITEM "", IDM_MON_WND_DIS
        MENUITEM "", IDM_MON_WND_CONSOLE
        MENUITEM SEPARATOR
        MENUITEM "", IDM_MON_COMPUTER
        MENUITEM "", IDM_MON_DRIVE8
        MENUITEM "", IDM_MON_DRIVE9
        MENUITEM "", IDM_MON_DRIVE10
        MENUITEM "", IDM_MON_DRIVE11
    END
    POPUP N_("&Window")
    BEGIN
        MENUITEM "", IDM_MON_CASCADE
        MENUITEM "", IDM_MON_TILE_VERT
        MENUITEM "", IDM_MON_TILE_HORIZ
        MENUITEM "", IDM_MON_ARRANGE_ICONS
    END
END


IDR_MONTOOLBAR           BITMAP  MOVEABLE PURE   "montb.bmp"



IDR_MONTOOLBAR 2410 DISCARDABLE
BEGIN
    1, // wVersion
    16, // wWidth
    15, // wHeight
    27, // wItemCount
    IDM_MON_OPEN,
    IDM_MON_SAVE,
    IDM_MON_PRINT,
    0,
    IDM_MON_STOP_DEBUG,
    IDM_MON_STOP_EXEC,
    IDM_MON_CURRENT,
    0,
    IDM_MON_STEP_INTO,
    IDM_MON_STEP_OVER,
    IDM_MON_SKIP_RETURN,
    IDM_MON_GOTO_CURSOR,
    0,
    IDM_MON_EVAL,
    IDM_MON_WND_EVAL,
    IDM_MON_WND_REG,
    IDM_MON_WND_MEM,
    IDM_MON_WND_DIS,
    0,
    IDM_MON_WND_CONSOLE,
    0,
    IDM_MON_COMPUTER,
    IDM_MON_DRIVE8,
    IDM_MON_DRIVE9,
    IDM_MON_DRIVE10,
    IDM_MON_DRIVE11,
    0,
    IDM_MON_HELP
END


IDI_ICON1               ICON    DISCARDABLE     "c64.ico"



IDD_ABOUT DIALOG DISCARDABLE 0, 0, 195, 210
CAPTION N_("About VICE")
BEGIN
    DEFPUSHBUTTON N_("OK"),                                           IDOK,              132,  14,  50, 14
    CTEXT         N_("VICE"),                                         IDC_STATIC,          7,   5, 118,  8
    CTEXT         N_("Versatile Commodore Emulator"),                 IDC_STATIC,          7,  18, 118,  8
    CTEXT         N_("Version 0.0"),                                  IDC_ABOUT_VERSION,   7,  31, 180,  8
    LTEXT         N_("Copyright (c) 1998-2009 Andreas Boose"),        IDC_STATIC,          5,  50, 158,  8
    LTEXT         N_("Copyright (c) 1998-2009 Dag Lem"),              IDC_STATIC,          5,  59, 158,  8
    LTEXT         N_("Copyright (c) 1998-2009 Tibor Biczo"),          IDC_STATIC,          5,  68, 158,  8
    LTEXT         N_("Copyright (c) 1999-2009 Andreas Matthies"),     IDC_STATIC,          5,  77, 180,  8
    LTEXT         N_("Copyright (c) 1999-2009 Martin Pottendorfer"),  IDC_STATIC,          5,  86, 180,  8
    LTEXT         N_("Copyright (c) 2000-2009 Spiro Trikaliotis"),    IDC_STATIC,          5,  95, 180,  8
    LTEXT         N_("Copyright (c) 2005-2009 Marco van den Heuvel"), IDC_STATIC,          5, 104, 180,  8
    LTEXT         N_("Copyright (c) 2006-2009 Christian Vogelgsang"), IDC_STATIC,          5, 113, 180,  8
    LTEXT         N_("Copyright (c) 2007-2009 Fabrizio Gennari"),     IDC_STATIC,          5, 122, 180,  8
    LTEXT         N_("Copyright (c) 2007-2009 M. Kiesel"),            IDC_STATIC,          5, 131, 180,  8
    LTEXT         N_("Copyright (c) 2007-2009 Hannu Nuotio"),         IDC_STATIC,          5, 140, 180,  8
    LTEXT         N_("Copyright (c) 2007-2009 Daniel Kahlin"),        IDC_STATIC,          5, 149, 180,  8
    LTEXT         N_("Copyright (c) 2008-2009 Antti S. Lankila"),     IDC_STATIC,          5, 158, 180,  8
    LTEXT         N_("Copyright (c) 1999-2007 Andreas Dehmel"),       IDC_STATIC,          5, 167, 158,  8
    LTEXT         N_("Copyright (c) 1999-2005 Thomas Bretz"),         IDC_STATIC,          5, 176, 180,  8
    LTEXT         N_("Copyright (c) 2003-2005 David Hansel"),         IDC_STATIC,          5, 185, 180,  8
    LTEXT         N_("Copyright (c) 2000-2004 Markus Brenner"),       IDC_STATIC,          5, 194, 180,  8
    LTEXT         N_(" "),                                            IDC_STATIC,          5, 203, 180,  8
END



IDD_DISKDEVICE_DIALOG DIALOG DISCARDABLE 0, 0, 287, 190
BEGIN
    AUTOCHECKBOX    "", IDC_TOGGLE_USEIECDEVICE,
                    15, 10, 100, 10, BS_AUTOCHECKBOX | WS_TABSTOP
    AUTORADIOBUTTON "", IDC_SELECTDISK,
                    15, 30, 51, 10, BS_AUTORADIOBUTTON | WS_GROUP | WS_TABSTOP
    AUTORADIOBUTTON "", IDC_SELECTDIR,
                    15, 75, 44, 10, BS_AUTORADIOBUTTON
#ifdef HAVE_OPENCBM
    AUTORADIOBUTTON "", IDC_SELECTREAL,
                    15, 120, 70, 10, BS_AUTORADIOBUTTON
#endif
    AUTORADIOBUTTON "", IDC_SELECTNONE,
                    15, 160, 33, 10, BS_AUTORADIOBUTTON
    COMBOBOX        IDC_DISKIMAGE,
                    81, 29, 190, 12, CBS_DROPDOWN | CBS_SORT | WS_VSCROLL | WS_GROUP | WS_TABSTOP
    PUSHBUTTON      "", IDC_BROWSEDISK,
                    81, 47, 50, 14, WS_GROUP
    PUSHBUTTON      "", IDC_AUTOSTART,
                    141, 47, 50,  14, WS_GROUP
    AUTOCHECKBOX    "", IDC_TOGGLE_ATTACH_READONLY,
                    201, 47, 80, 14, BS_AUTOCHECKBOX | WS_TABSTOP
    COMBOBOX        IDC_DIR,
                    81, 74, 190, 12, CBS_DROPDOWN | CBS_SORT | WS_VSCROLL | WS_GROUP | WS_TABSTOP
    PUSHBUTTON      "", IDC_BROWSEDIR,
                    81, 92, 50, 14, WS_GROUP
    GROUPBOX        "", IDC_DISKDEVICE_OPTIONS,
                    175, 90, 95, 63
    AUTOCHECKBOX    "", IDC_TOGGLE_READP00,
                    185, 105, 62, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX    "", IDC_TOGGLE_WRITEP00,
                    185, 120, 61, 10, BS_AUTOCHECKBOX | WS_TABSTOP
    AUTOCHECKBOX    "", IDC_TOGGLE_HIDENONP00,
                    185, 135, 73, 10, BS_AUTOCHECKBOX | WS_TABSTOP
END




IDD_DATASETTE_SETTINGS_DIALOG DIALOG DISCARDABLE 0, 0, 170, 110
BEGIN
    AUTOCHECKBOX  "", IDC_DATASETTE_RESET_WITH_CPU,
                  7, 7, 99, 10, BS_AUTOCHECKBOX | WS_TABSTOP
    GROUPBOX      "", IDC_DATASETTE_MOTOR_GROUP,
                  5, 25, 160, 60
    LTEXT         "", IDC_DATASETTE_DELAY_TRIGGER,
                  42, 42, 120, 8
    COMBOBOX      IDC_DATASETTE_SPEED_TUNING,
                  9, 41, 30, 80, CBS_DROPDOWNLIST | WS_VSCROLL | WS_TABSTOP
    LTEXT         "", IDC_DATASETTE_DELAY_AT_ZERO,
                  60, 62, 100, 8
    COMBOBOX      IDC_DATASETTE_ZERO_GAP_DELAY,
                  9, 61, 48, 80, CBS_DROPDOWNLIST | WS_VSCROLL | WS_TABSTOP
    DEFPUSHBUTTON "", IDOK,
                  30, 90, 50, 14, WS_TABSTOP
    PUSHBUTTON    "", IDCANCEL,
                  90, 90, 50, 14, WS_TABSTOP
END



IDD_JOY_SETTINGS_DIALOG DIALOG DISCARDABLE 0, 0, 226, 161
BEGIN
    GROUPBOX      "", IDC_JOYSTICK_IN_PORT_1,
                  7, 5, 102, 113
    COMBOBOX      IDC_JOY_DEV1,
                  12, 16, 93, 68, CBS_DROPDOWNLIST | WS_GROUP | WS_TABSTOP | WS_VSCROLL
    LTEXT         "", IDC_SELECT_FIRE_BUTTON_1,
                  12, 34, 70, 8
    COMBOBOX      IDC_JOY_FIRE1_BUTTON,
                  12, 47, 93, 60, CBS_DROPDOWNLIST | WS_GROUP | WS_TABSTOP | WS_VSCROLL
    LTEXT         "", IDC_AUTO_FIRE_BUTTON_SETTINGS_1,
                  12, 61, 93, 8
    LTEXT         "", IDC_AUTOFIRE_SPEED_1,
                  12, 74, 70, 8
    EDITTEXT      IDC_JOY_FIRE1_SPEED,
                  87, 72, 18, 12, WS_TABSTOP | 0x2000L
    COMBOBOX      IDC_JOY_FIRE1_AXIS,
                  12, 87, 93, 60, CBS_DROPDOWNLIST | WS_GROUP | WS_TABSTOP | WS_VSCROLL
    COMBOBOX      IDC_JOY_AUTOFIRE1_BUTTON,
                  12, 102, 93, 60, CBS_DROPDOWNLIST | WS_GROUP | WS_TABSTOP | WS_VSCROLL
    GROUPBOX      "", IDC_JOYSTICK_IN_PORT_2,
                  117, 5, 102, 113
    COMBOBOX      IDC_JOY_DEV2,
                  122, 16, 93, 68, CBS_DROPDOWNLIST | WS_GROUP | WS_TABSTOP | WS_VSCROLL
    LTEXT         "", IDC_SELECT_FIRE_BUTTON_2,
                  122, 34, 70, 8
    COMBOBOX      IDC_JOY_FIRE2_BUTTON,
                  122, 47, 93, 60, CBS_DROPDOWNLIST | WS_GROUP | WS_TABSTOP | WS_VSCROLL
    LTEXT         "", IDC_AUTO_FIRE_BUTTON_SETTINGS_2,
                  122, 61, 93, 8
    LTEXT         "", IDC_AUTOFIRE_SPEED_2,
                  122, 74, 70, 8
    EDITTEXT      IDC_JOY_FIRE2_SPEED,
                  197, 72, 18, 12, WS_TABSTOP | 0x2000L
    COMBOBOX      IDC_JOY_FIRE2_AXIS,
                  122, 87, 93, 60, CBS_DROPDOWNLIST | WS_GROUP | WS_TABSTOP | WS_VSCROLL
    COMBOBOX      IDC_JOY_AUTOFIRE2_BUTTON,
                  122, 102, 93, 60, CBS_DROPDOWNLIST | WS_GROUP | WS_TABSTOP | WS_VSCROLL
    PUSHBUTTON    "", IDC_JOY_CONFIG_A,
                  8, 120, 60, 14, WS_TABSTOP
    PUSHBUTTON    "", IDC_JOY_CONFIG_B,
                  159, 120, 60, 14, WS_TABSTOP
    PUSHBUTTON    "", IDC_JOY_CALIBRATE,
                  78, 120, 70, 14, WS_TABSTOP
    DEFPUSHBUTTON "", IDOK,
                  48, 141, 50, 14, WS_TABSTOP
    PUSHBUTTON    "", IDCANCEL,
                  129, 141, 50, 14, WS_TABSTOP
END



IDD_EXTRA_JOY_SETTINGS_DIALOG DIALOG DISCARDABLE 0, 0, 226, 181
BEGIN
    COMBOBOX      IDC_EXTRA_JOY_ADAPTER,
                  9, 9, 93, 68, CBS_DROPDOWNLIST | WS_GROUP | WS_VSCROLL | WS_TABSTOP
    GROUPBOX      "", IDC_JOYSTICK_IN_PORT_1,
                  7, 25, 102, 113
    COMBOBOX      IDC_JOY_DEV1,
                  12, 36, 93, 68, CBS_DROPDOWNLIST | WS_GROUP | WS_VSCROLL | WS_TABSTOP
    LTEXT         "", IDC_SELECT_FIRE_BUTTON_1,
                  12, 54, 70, 8
    COMBOBOX      IDC_JOY_FIRE1_BUTTON,
                  12, 67, 93, 60, CBS_DROPDOWNLIST | WS_GROUP | WS_TABSTOP | WS_VSCROLL
    LTEXT         "", IDC_AUTO_FIRE_BUTTON_SETTINGS_1,
                  12, 81, 93, 8
    LTEXT         "", IDC_AUTOFIRE_SPEED_1,
                  12, 94, 70, 8
    EDITTEXT      IDC_JOY_FIRE1_SPEED,
                  87, 92, 18, 12, WS_TABSTOP | 0x2000L
    COMBOBOX      IDC_JOY_FIRE1_AXIS,
                  12, 107, 93, 60, CBS_DROPDOWNLIST | WS_GROUP | WS_TABSTOP | WS_VSCROLL
    COMBOBOX      IDC_JOY_AUTOFIRE1_BUTTON,
                  12, 122, 93, 60, CBS_DROPDOWNLIST | WS_GROUP | WS_TABSTOP | WS_VSCROLL
    GROUPBOX      "", IDC_JOYSTICK_IN_PORT_2,
                  117, 25, 102, 113
    COMBOBOX      IDC_JOY_DEV2,
                  122, 36, 93, 68, CBS_DROPDOWNLIST | WS_GROUP | WS_TABSTOP | WS_VSCROLL
    LTEXT         "", IDC_SELECT_FIRE_BUTTON_2,
                  122, 54, 70, 8
    COMBOBOX      IDC_JOY_FIRE2_BUTTON,
                  122, 67, 93, 60, CBS_DROPDOWNLIST | WS_GROUP | WS_TABSTOP | WS_VSCROLL
    LTEXT         "", IDC_AUTO_FIRE_BUTTON_SETTINGS_2,
                  122, 81, 93, 8
    LTEXT         "", IDC_AUTOFIRE_SPEED_2,
                  122, 94, 70, 8
    EDITTEXT      IDC_JOY_FIRE2_SPEED,
                  197, 92, 18, 12, WS_TABSTOP | 0x2000L
    COMBOBOX      IDC_JOY_FIRE2_AXIS,
                  122, 107, 93, 60, CBS_DROPDOWNLIST | WS_GROUP | WS_TABSTOP | WS_VSCROLL
    COMBOBOX      IDC_JOY_AUTOFIRE2_BUTTON,
                  122, 122, 93, 60, CBS_DROPDOWNLIST | WS_GROUP | WS_TABSTOP | WS_VSCROLL
    PUSHBUTTON    "", IDC_JOY_CONFIG_A,
                  8, 140, 60, 14, WS_TABSTOP
    PUSHBUTTON    "", IDC_JOY_CONFIG_B,
                  159, 140, 60, 14, WS_TABSTOP
    PUSHBUTTON    "", IDC_JOY_CALIBRATE,
                  78, 140, 70, 14, WS_TABSTOP
    DEFPUSHBUTTON "", IDOK,
                  48, 161, 50, 14, WS_TABSTOP
    PUSHBUTTON    "", IDCANCEL,
                  129, 161, 50, 14, WS_TABSTOP
END




IDD_CONFIG_KEYSET_DIALOG DIALOG DISCARDABLE 0, 0, 130, 190
BEGIN
    PUSHBUTTON    "", IDC_KEYSET_SW,    7,   5,  60, 14, WS_TABSTOP
    LTEXT         "", IDC_KEY_SW,      80,   8, 100,  8
    PUSHBUTTON    "", IDC_KEYSET_S,     7,  23,  60, 14, WS_TABSTOP
    LTEXT         "", IDC_KEY_S,       80,  26, 100,  8
    PUSHBUTTON    "", IDC_KEYSET_SE,    7,  41,  60, 14, WS_TABSTOP
    LTEXT         "", IDC_KEY_SE,      80,  44, 100,  8
    PUSHBUTTON    "", IDC_KEYSET_W,     7,  59,  60, 14, WS_TABSTOP
    LTEXT         "", IDC_KEY_W,       80,  62, 100,  8
    PUSHBUTTON    "", IDC_KEYSET_E,     7,  77,  60, 14, WS_TABSTOP
    LTEXT         "", IDC_KEY_E,       80,  80, 100,  8
    PUSHBUTTON    "", IDC_KEYSET_NW,    7,  95,  60, 14, WS_TABSTOP
    LTEXT         "", IDC_KEY_NW,      80,  98, 100,  8
    PUSHBUTTON    "", IDC_KEYSET_N,     7, 113,  60, 14, WS_TABSTOP
    LTEXT         "", IDC_KEY_N,       80, 116, 100,  8
    PUSHBUTTON    "", IDC_KEYSET_NE,    7, 131,  60, 14, WS_TABSTOP
    LTEXT         "", IDC_KEY_NE,      80, 134, 100,  8
    PUSHBUTTON    "", IDC_KEYSET_FIRE,  7, 149,  60, 14, WS_TABSTOP
    LTEXT         "", IDC_KEY_FIRE,    80, 152, 100,  8
    DEFPUSHBUTTON "", IDOK,            15, 170,  50, 14, WS_TABSTOP
    PUSHBUTTON    "", IDCANCEL,        70, 170,  50, 14, WS_TABSTOP
END



IDD_CONFIG_KEY_DIALOG DIALOG DISCARDABLE 0, 0, 120, 24
BEGIN
END



IDD_SOUND_SETTINGS_DIALOG DIALOG DISCARDABLE 0, 0, 180, 100
BEGIN
    AUTORADIOBUTTON "", IDC_SOUND_DIRECTX,
                    10, 10, 60, 10, BS_AUTORADIOBUTTON | WS_GROUP | WS_TABSTOP
    AUTORADIOBUTTON "", IDC_SOUND_WMM,
                    75, 10, 60, 10, BS_AUTORADIOBUTTON
    LTEXT           "", IDC_SOUND_SAMPLE_FREQUENCY,
                    7, 25, 118, 8
    COMBOBOX        IDC_SOUND_FREQ,
                    100, 22, 70, 68, CBS_DROPDOWNLIST | WS_GROUP | WS_TABSTOP
    LTEXT           "", IDC_SOUND_BUFFER_SIZE,
                    7, 38, 118, 8
    COMBOBOX        IDC_SOUND_BUFFER,
                    100, 35, 70, 76, CBS_DROPDOWNLIST | WS_GROUP | WS_TABSTOP
    LTEXT           "", IDC_SOUND_FRAGMENT_SIZE_LABEL,
                    7, 51, 118, 8
    COMBOBOX        IDC_SOUND_FRAGMENT_SIZE,
                    100, 48, 70, 68, CBS_DROPDOWNLIST | WS_GROUP | WS_TABSTOP
    LTEXT           "", IDC_SOUND_SYNCH_METHOD,
                    7, 64, 118, 8
    COMBOBOX        IDC_SOUND_SYNCH,
                    100, 61, 70, 68, CBS_DROPDOWNLIST | WS_GROUP | WS_TABSTOP
    DEFPUSHBUTTON   "", IDOK,
                    40, 80, 50, 14, WS_TABSTOP
    PUSHBUTTON      "", IDCANCEL,
                    95, 80, 50, 14, WS_TABSTOP
END




IDD_OPEN_TEMPLATE DIALOG DISCARDABLE 0, 0, 350, 140
BEGIN
    GROUPBOX        "", IDC_IMAGE_CONTENTS,
                    3, 0, 185, 138
    LISTBOX         IDC_PREVIEW,
                    6, 9, 178, 125, WS_BORDER | WS_VSCROLL | LBS_NOTIFY | LBS_NOINTEGRALHEIGHT
    AUTOCHECKBOX    "", IDC_TOGGLE_ATTACH_READONLY,
                    195, 0, 80, 20, BS_AUTOCHECKBOX | WS_TABSTOP
END



IDD_OPENDISK_TEMPLATE DIALOG DISCARDABLE 0, 0, 350, 140
BEGIN
    GROUPBOX     "", IDC_IMAGE_CONTENTS,
                 3, 0, 185, 138
    LISTBOX      IDC_PREVIEW,
                 6, 9, 178, 125, WS_BORDER | WS_VSCROLL | LBS_NOTIFY | LBS_NOINTEGRALHEIGHT
    AUTOCHECKBOX "", IDC_TOGGLE_ATTACH_READONLY,
                 195, 0, 80, 20, BS_AUTOCHECKBOX | WS_TABSTOP
    GROUPBOX     "", IDC_NEW_IMAGE,
                 190, 25, 80, 90
    LTEXT        "", IDC_NAME,
                 198, 40, 20, 8
    EDITTEXT     IDC_BLANK_IMAGE_NAME,
                 195, 48, 70, 12, WS_TABSTOP
    LTEXT        "", IDC_ID,
                 198, 63, 15, 8
    EDITTEXT     IDC_BLANK_IMAGE_ID,
                 195, 71, 20, 12, WS_TABSTOP
    LTEXT        "", IDC_TYPE,
                 233, 63, 20, 8
    COMBOBOX     IDC_BLANK_IMAGE_TYPE,
                 230, 71, 35, 80, CBS_DROPDOWNLIST | WS_GROUP | WS_TABSTOP
    PUSHBUTTON   "", IDC_BLANK_IMAGE,
                 205, 93, 50, 14, WS_TABSTOP
END



IDD_OPENTAPE_TEMPLATE DIALOG DISCARDABLE 0, 0, 350, 140
BEGIN
    GROUPBOX   "", IDC_IMAGE_CONTENTS,
               3, 0, 185, 138
    LISTBOX    IDC_PREVIEW,
               6, 9, 178, 125, WS_BORDER | WS_VSCROLL | LBS_NOTIFY | LBS_NOINTEGRALHEIGHT
    GROUPBOX   "", IDC_NEW_TAP_IMAGE,
               190, 0, 80, 40
    PUSHBUTTON "", IDC_BLANK_IMAGE,
               205, 20, 50, 14, WS_TABSTOP
END



IDD_SNAPSHOT_SAVE_DIALOG DIALOG DISCARDABLE 0, 0, 250, 35
BEGIN
    AUTOCHECKBOX "", IDC_TOGGLE_SNAPSHOT_SAVE_DISKS,
                 10, 5, 135, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX "", IDC_TOGGLE_SNAPSHOT_SAVE_ROMS,
                 10, 18, 135, 10, BS_AUTOCHECKBOX | WS_TABSTOP
END



IDD_MEDIAFILE_DIALOG DIALOG DISCARDABLE 0, 0, 300, 100
BEGIN
    LTEXT    "", IDC_SELECT_DRIVER,
             5, 0, 45, 20
    COMBOBOX IDC_SCREENSHOT_DRIVER,
             55, 0, 155, 200, CBS_DROPDOWNLIST | WS_GROUP | WS_TABSTOP
    GROUPBOX "", IDC_FFMPEG_SETTINGS,
             5, 20, 250, 75
    LTEXT    "", IDC_FORMAT,
             15, 37, 40, 20
    COMBOBOX IDC_SCREENSHOT_FFMPEGFORMAT,
             50, 35, 60, 200, CBS_DROPDOWNLIST | WS_GROUP | WS_TABSTOP
    LTEXT    "", IDC_AUDIO_CODEC,
             15, 57, 45, 15
    COMBOBOX IDC_SCREENSHOT_FFMPEGAUDIOCODEC,
             65, 55, 80, 200, CBS_DROPDOWNLIST | WS_GROUP | WS_TABSTOP
    LTEXT    "", IDC_AUDIO_BITRATE,
             155, 57, 25, 15
    EDITTEXT IDC_SCREENSHOT_FFMPEGAUDIOBITRATE,
             180, 55, 40, 12, WS_GROUP | WS_TABSTOP
    LTEXT    "", IDC_VIDEO_CODEC,
             15, 77, 45, 15
    COMBOBOX IDC_SCREENSHOT_FFMPEGVIDEOCODEC,
             65, 75, 80, 200, CBS_DROPDOWNLIST | WS_GROUP | WS_TABSTOP
    LTEXT    "", IDC_VIDEO_BITRATE,
             155, 77, 25, 15
    EDITTEXT IDC_SCREENSHOT_FFMPEGVIDEOBITRATE,
             180, 75, 40, 12, WS_GROUP | WS_TABSTOP
END



IDD_CONSOLE_SAVE_DIALOG DIALOG DISCARDABLE 0, 0, 250, 22
BEGIN
    AUTOCHECKBOX "", IDC_TOGGLE_CONSOLE_APPEND,
                 10, 5, 135, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
END



IDD_FULLSCREEN_SETTINGS_DIALOG DIALOG DISCARDABLE  0, 0, 180,87
BEGIN
    LTEXT        "", IDC_FULLSCREEN_DRIVER,
                 9, 2, 120, 8
    COMBOBOX     IDC_FULLSCREEN_DEVICE,
                 9, 13, 150, 80, CBS_DROPDOWNLIST | WS_VSCROLL | WS_TABSTOP
    LTEXT        "", IDC_FULLSCREEN_DRIVER_BITDEPTH,
                 9, 32, 100, 8
    COMBOBOX     IDC_FULLSCREEN_BITDEPTH,
                 99, 28, 60, 80, CBS_DROPDOWNLIST | WS_VSCROLL | WS_TABSTOP
    LTEXT        "", IDC_FULLSCREEN_DRIVER_RESOLUTION,
                 9, 47, 100, 8
    COMBOBOX     IDC_FULLSCREEN_RESOLUTION,
                 99, 43, 60, 80, CBS_DROPDOWNLIST | WS_VSCROLL | WS_TABSTOP
    LTEXT        "", IDC_FULLSCREEN_DRIVER_REFRESHRATE,
                 9, 62, 100, 8
    COMBOBOX     IDC_FULLSCREEN_REFRESHRATE,
                 99, 58, 60, 80, CBS_DROPDOWNLIST | WS_VSCROLL | WS_TABSTOP
    AUTOCHECKBOX "", IDC_TOGGLE_VIDEO_VBLANK_SYNC,
                 9, 77, 100, 8, BS_AUTOCHECKBOX | WS_TABSTOP
    AUTOCHECKBOX "", IDC_TOGGLE_VIDEO_DX_PRIMARY,
                 9, 89, 120, 8, BS_AUTOCHECKBOX | WS_TABSTOP
    AUTOCHECKBOX "", IDC_TOGGLE_KEEP_ASPECT_RATIO,
                 9, 101, 115, 8, BS_AUTOCHECKBOX | WS_TABSTOP
    EDITTEXT     IDC_ASPECT_RATIO,
                 127, 99, 32, 12, WS_TABSTOP
END



IDD_VIDEO_COLORS_DIALOG DIALOG DISCARDABLE  0, 0, 180, 87
BEGIN
    LTEXT    "", IDC_COLORS_SATURATION,
             12, 12, 40, 8
    EDITTEXT IDC_VIDEO_COLORS_SAT,
             85, 10, 32, 12, WS_TABSTOP
    LTEXT    "", IDC_COLORS_CONTRAST,
             12, 24, 40, 8
    EDITTEXT IDC_VIDEO_COLORS_CON,
             85, 22, 32, 12, WS_TABSTOP
    LTEXT    "", IDC_COLORS_BRIGHTNESS,
             12, 36, 40, 8
    EDITTEXT IDC_VIDEO_COLORS_BRI,
             85, 34, 32, 12, WS_TABSTOP
END



IDD_VIDEO_NEW_PAL_DIALOG DIALOG DISCARDABLE  0, 0, 180, 87
BEGIN
    LTEXT    "", IDC_NEW_PAL_TINT,
             12, 12, 60, 8
    EDITTEXT IDC_VIDEO_NEW_PAL_TINT,
             105, 10, 32, 12, WS_TABSTOP
    LTEXT    "", IDC_NEW_PAL_ODD_LINES_PHASE,
             12, 24, 60, 8
    EDITTEXT IDC_VIDEO_NEW_PAL_PHASE,
             105, 22, 32, 12, WS_TABSTOP
    LTEXT    "", IDC_NEW_PAL_ODD_LINES_OFFSET,
             12, 36, 60, 8
    EDITTEXT IDC_VIDEO_NEW_PAL_OFFSET,
             105, 34, 32, 12, WS_TABSTOP
END



IDD_VIDEO_ADVANCED_DIALOG DIALOG DISCARDABLE  0, 0, 180, 87
BEGIN
    LTEXT        "", IDC_VIDEO_GAMMA,
                 12, 12, 40, 8
    EDITTEXT     IDC_VIDEO_COLORS_GAM,
                 85, 10, 32, 12, WS_TABSTOP
    LTEXT        "", IDC_VIDEO_PHASE,
                 12, 24, 40, 8
    EDITTEXT     IDC_VIDEO_COLORS_PHA,
                 85, 22, 32, 12, WS_TABSTOP
    LTEXT        "", IDC_VIDEO_PAL_SHADE,
                 12, 41, 40, 8
    EDITTEXT     IDC_VIDEO_ADVANCED_SHADE,
                 85, 39, 32, 12, WS_TABSTOP
    LTEXT        "", IDC_VIDEO_PAL_BLUR,
                 12, 53, 40, 8
    EDITTEXT     IDC_VIDEO_ADVANCED_BLUR,
                 85, 51, 32, 12, WS_TABSTOP

    AUTOCHECKBOX "", IDC_TOGGLE_VIDEO_EXTPALETTE,
                 12, 47+23+12, 70, 10, BS_AUTOCHECKBOX | WS_TABSTOP
    COMBOBOX     IDC_VIDEO_CUSTOM_NAME,
                 85, 45+23+12, 120, 112, CBS_DROPDOWN | CBS_AUTOHSCROLL | WS_VSCROLL | WS_GROUP | WS_TABSTOP
    PUSHBUTTON   "", IDC_VIDEO_CUSTOM_BROWSE,
                 85, 63+23+12, 50, 14, WS_GROUP
END



IDD_VIDEO_PALETTE_DIALOG DIALOG DISCARDABLE  0, 0, 180, 87
BEGIN
    COMBOBOX   IDC_VIDEO_CUSTOM_NAME,
               12, 12, 120, 112, CBS_DROPDOWN | WS_VSCROLL | WS_GROUP | WS_TABSTOP
    PUSHBUTTON N_("&Browse..."), IDC_VIDEO_CUSTOM_BROWSE,
               12, 12+18, 50, 14, WS_GROUP
END



IDD_RAM_SETTINGS_DIALOG DIALOG DISCARDABLE  0, 0, 170, 210
BEGIN
    GROUPBOX      "", IDC_RAM_INIT_AT_POWERUP,
                  5, 5, 160, 180
    LTEXT         "", IDC_RAM_VALUE_FIRST_BYTE,
                  55, 17, 100, 8
    COMBOBOX      IDC_RAMINIT_STARTVALUE, 9, 15, 40, 80,
                  CBS_DROPDOWNLIST | WS_VSCROLL | WS_TABSTOP
    LTEXT         "", IDC_RAM_LENGTH_CONSTANT_VALUES,
                  55, 32, 100, 8
    COMBOBOX      IDC_RAMINIT_VALUEINVERT,
                  9, 30, 40, 80, CBS_DROPDOWNLIST | WS_VSCROLL | WS_TABSTOP
    LTEXT         "", IDC_RAM_LENGTH_CONSTANT_PATTERN,
                  55, 47, 100, 8
    COMBOBOX      IDC_RAMINIT_PATTERNINVERT,
                  9, 45, 40, 80, CBS_DROPDOWNLIST | WS_VSCROLL | WS_TABSTOP
    EDITTEXT      IDC_RAMINIT_PREVIEW,
                  9, 60, 152, 110, (0x4L) | WS_VSCROLL | ES_READONLY
    DEFPUSHBUTTON "", IDOK, 30, 187, 50, 14, WS_TABSTOP
    PUSHBUTTON    "", IDCANCEL, 90, 187, 50, 14, WS_TABSTOP
END



IDD_CUSTOM_SPEED_DIALOG DIALOG DISCARDABLE  0, 0, 160, 55
BEGIN
    LTEXT         "", IDC_ENTER_CUSTOM_SPEED,
                  5, 7, 80, 8
    EDITTEXT      IDC_CUSTOM_SPEED,
                  90, 7, 60, 12, WS_TABSTOP

    DEFPUSHBUTTON N_("OK"), IDOK,
                  25, 35, 50, 14, WS_TABSTOP
    PUSHBUTTON    N_("Cancel"), IDCANCEL,
                  85, 35, 50, 14, WS_TABSTOP
END



IDD_PRINTER_SETTINGS_DIALOG DIALOG DISCARDABLE 0, 0, 285, 175
BEGIN
    AUTOCHECKBOX    "", IDC_PRINTER_USEIECDEVICE,
                    15, 10, 100, 10, BS_AUTOCHECKBOX | WS_TABSTOP
    LTEXT           "", IDC_PRINTER_EMULATION,
                    15, 25, 70, 8
    COMBOBOX        IDC_PRINTER_TYPE,
                    80, 23, 55, 50, CBS_DROPDOWNLIST | WS_GROUP | WS_TABSTOP | WS_VSCROLL
    PUSHBUTTON      "", IDC_PRINTER_FORMFEED,
                    220, 23, 60, 15
    GROUPBOX        "", IDC_FILESYSTEM_PRINTER,
                    5, 40, 275, 130
    LTEXT           "", IDC_PRINTER_DRVR,
                    15, 52, 70, 8
    COMBOBOX        IDC_PRINTER_DRIVER,
                    80, 50, 55, 50, CBS_DROPDOWNLIST | WS_GROUP | WS_TABSTOP | WS_VSCROLL
    LTEXT           "", IDC_OUTPUT,
                    15, 72, 70, 8
    COMBOBOX        IDC_PRINTER_OUTPUT,
                    80, 70, 55, 50, CBS_DROPDOWNLIST | WS_GROUP | WS_TABSTOP | WS_VSCROLL
    LTEXT           "", IDC_OUTPUT_TO_FILE,
                    15, 92, 70, 8
    COMBOBOX        IDC_PRINTER_TEXTOUT,
                    80, 90, 55, 50, CBS_DROPDOWNLIST | WS_GROUP | WS_TABSTOP | WS_VSCROLL
    LTEXT           "", IDC_OUTPUT_FILE1_NAME,
                    15, 112, 70, 8
    EDITTEXT        IDC_PRINTER_OUTPUT_FILE1_NAME,
                    80, 110, 190, 12, WS_TABSTOP
    LTEXT           "", IDC_OUTPUT_FILE2_NAME,
                    15, 132, 70, 8
    EDITTEXT        IDC_PRINTER_OUTPUT_FILE2_NAME,
                    80, 130, 190, 12, WS_TABSTOP
    LTEXT           "", IDC_OUTPUT_FILE3_NAME,
                    15, 152, 70, 8
    EDITTEXT        IDC_PRINTER_OUTPUT_FILE3_NAME,
                    80, 150, 190, 12, WS_TABSTOP
END



IDD_ROMSET_SETTINGS_DIALOG DIALOG DISCARDABLE 0, 0, 265, 265
BEGIN
    AUTORADIOBUTTON "", IDC_ROMSET_SELECT_ARCHIVE,
                    13, 8, 70, 10, BS_AUTORADIOBUTTON | WS_GROUP | WS_TABSTOP
    EDITTEXT        IDC_ROMSET_ARCHIVE_NAME,
                    13, 23, 150, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON      "", IDC_ROMSET_ARCHIVE_BROWSE,
                    178, 22, 60, 15
    PUSHBUTTON      "", IDC_ROMSET_ARCHIVE_LOAD,
                    13, 42, 60, 15
    PUSHBUTTON      "", IDC_ROMSET_ARCHIVE_SAVE,
                    85, 42, 60, 15
    GROUPBOX        "", IDC_ROMSET_CONFIGURATION,
                    13, 60, 230, 60
    COMBOBOX        IDC_ROMSET_ARCHIVE_ACTIVE,
                    23, 75, 90, 80, CBS_DROPDOWNLIST | CBS_SORT | WS_GROUP | WS_TABSTOP | WS_VSCROLL
    PUSHBUTTON      "", IDC_ROMSET_ARCHIVE_APPLY,
                    23, 95, 60, 15
    PUSHBUTTON      "", IDC_ROMSET_ARCHIVE_NEW,
                    95, 95, 60, 15
    PUSHBUTTON      "", IDC_ROMSET_ARCHIVE_DELETE,
                    167, 95, 60, 15
    AUTORADIOBUTTON "", IDC_ROMSET_SELECT_FILE,
                    13, 130, 60, 10, BS_AUTORADIOBUTTON
    EDITTEXT        IDC_ROMSET_FILE_NAME,
                    13, 145, 150, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON      "", IDC_ROMSET_FILE_BROWSE,
                    178, 145, 60, 15
    PUSHBUTTON      "", IDC_ROMSET_FILE_LOAD,
                    13, 165, 60, 15
    PUSHBUTTON      "", IDC_ROMSET_FILE_SAVE,
                    85, 165, 60, 15
    EDITTEXT        IDC_ROMSET_PREVIEW,
                    13, 195, 180, 60, (0x4L) | WS_VSCROLL | ES_READONLY | ES_AUTOHSCROLL
    PUSHBUTTON      "", IDC_ROMSET_RESOURCE_COMPUTER,
                    200, 195, 60, 15
    PUSHBUTTON      "", IDC_ROMSET_RESOURCE_DRIVE,
                    200, 215, 60, 15
END



IDD_ROMSET_ENTER_NAME_DIALOG DIALOG DISCARDABLE  0, 0, 180, 55
BEGIN
    LTEXT         "", IDC_ENTER_CONFIGURATION_NAME,
                  5, 7, 80, 8
    EDITTEXT      IDC_ROMSET_ENTER_NAME,
                  90, 7, 80, 12, WS_TABSTOP | ES_AUTOHSCROLL
    DEFPUSHBUTTON "", IDOK,
                  35, 35, 50, 14, WS_TABSTOP
    PUSHBUTTON    "", IDCANCEL,
                  95, 35, 50, 14, WS_TABSTOP
END



IDD_RS232_SETTINGS_DIALOG DIALOG DISCARDABLE  0, 0, 180, 120
BEGIN
    LTEXT         "", IDC_RS232_DEV_1,
                  9, 8, 60, 8
    EDITTEXT      IDC_RS232_DEVICE1,
                  75, 7, 85, 12, WS_TABSTOP | ES_AUTOHSCROLL
    LTEXT         "", IDC_RS232_DEV_2,
                  9, 28, 60, 8
    EDITTEXT      IDC_RS232_DEVICE2,
                  75, 27, 85, 12, WS_TABSTOP | ES_AUTOHSCROLL
    LTEXT         "", IDC_RS232_DEV_3,
                  9, 48, 60, 8
    EDITTEXT      IDC_RS232_DEVICE3,
                  75, 47, 85, 12, WS_TABSTOP | ES_AUTOHSCROLL
    LTEXT         "", IDC_RS232_DEV_4,
                  9, 68, 60, 8
    EDITTEXT      IDC_RS232_DEVICE4,
                  75, 67, 85, 12, WS_TABSTOP | ES_AUTOHSCROLL
    DEFPUSHBUTTON "", IDOK,
                  30, 100, 50, 14, WS_TABSTOP
    PUSHBUTTON    "", IDCANCEL,
                  90, 100, 50, 14, WS_TABSTOP
END



IDD_NETWORK_SETTINGS_DIALOG DIALOG DISCARDABLE 0, 0, 260, 110
BEGIN
    LTEXT        "", IDC_CURRENT_MODE,
                 9, 8, 45, 8
    EDITTEXT     IDC_NETWORK_MODE,
                 60, 7, 75, 12, WS_TABSTOP
    LTEXT        "", IDC_SERVER_BIND,
                 9, 27, 50, 8
    EDITTEXT     IDC_NETWORK_SERVER_BIND,
                 51, 26, 84, 12, WS_TABSTOP | ES_AUTOHSCROLL
    LTEXT        "", IDC_TCP_PORT,
                 9, 42, 30, 8
    EDITTEXT     IDC_NETWORK_PORT,
                 51, 41, 30, 12, WS_TABSTOP
    PUSHBUTTON   "", IDC_NETWORK_SERVER,
                 85, 40, 51, 14, WS_TABSTOP
    PUSHBUTTON   "", IDC_NETWORK_CLIENT,
                 9, 64, 50, 14, WS_TABSTOP
    EDITTEXT     IDC_NETWORK_SERVERNAME,
                 65, 65, 70, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON   "", IDC_NETWORK_DISCONNECT,
                 27, 83, 70, 14, WS_TABSTOP
    GROUPBOX     "", IDC_CONTROL,
                 140, 5, 115, 100
    LTEXT        "", IDC_SERVER,
                 195, 15, 25, 10
    LTEXT        "", IDC_CLIENT,
                 225, 15, 25, 10
    LTEXT        "", IDC_KEYBOARD,
                 150, 30, 45, 10
    AUTOCHECKBOX "", IDC_NETWORK_KEYB_SERVER,
                 200, 30, 10, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX "", IDC_NETWORK_KEYB_CLIENT,
                 230, 30, 10, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    LTEXT        "", IDC_JOYSTICK_1,
                 150, 42, 45, 10
    AUTOCHECKBOX "", IDC_NETWORK_JOY1_SERVER,
                 200, 42, 10, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX "", IDC_NETWORK_JOY1_CLIENT,
                 230, 42, 10, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    LTEXT        "", IDC_JOYSTICK_2,
                 150, 54, 45, 10
    AUTOCHECKBOX "", IDC_NETWORK_JOY2_SERVER,
                 200, 54, 10, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX "", IDC_NETWORK_JOY2_CLIENT,
                 230, 54, 10, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    LTEXT        "", IDC_DEVICES,
                 150, 66, 45, 10
    AUTOCHECKBOX "",IDC_NETWORK_DEVC_SERVER,
                 200, 66, 10, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX "", IDC_NETWORK_DEVC_CLIENT,
                 230, 66, 10, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    LTEXT        "", IDC_SETTINGS,
                 150, 78, 45, 10
    AUTOCHECKBOX "", IDC_NETWORK_RSRC_SERVER,
                 200, 78, 10, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX "", IDC_NETWORK_RSRC_CLIENT,
                 230, 78, 10, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
END



IDD_TEXTDLG DIALOG DISCARDABLE  0, 0, 279, 242
BEGIN
    DEFPUSHBUTTON   "", IDOK,
                    118, 221, 50, 14
    LTEXT           "", IDC_HEADER,
                    7, 7, 156, 10
    EDITTEXT        IDC_TEXT,
                    7, 23, 265, 187, (0x4L) | WS_VSCROLL | WS_HSCROLL
END



IDD_SOUND_RECORD_SETTINGS_DIALOG DIALOG DISCARDABLE 0, 0, 180, 90
BEGIN
    LTEXT         "", IDC_SOUND_RECORD_FORMAT_LABEL,
                  9, 9, 53, 8
    COMBOBOX      IDC_SOUND_RECORD_FORMAT,
                  66, 7, 50, 80, CBS_DROPDOWNLIST | WS_VSCROLL | WS_TABSTOP
    LTEXT         "", IDC_SOUND_RECORD_FILE_LABEL,
                  9, 24, 50, 8
    PUSHBUTTON    "", IDC_SOUND_RECORD_BROWSE,
                  66, 24, 50, 14, 0
    EDITTEXT      IDC_SOUND_RECORD_FILE,
                  9, 40, 160, 12, WS_TABSTOP
    DEFPUSHBUTTON "", IDOK,
                  30, 64, 50, 14, WS_TABSTOP
    PUSHBUTTON    "", IDCANCEL,
                  90, 64, 50, 14, WS_TABSTOP
END



STRINGTABLE
BEGIN
  IDS_VICE_ERROR                  N_("VICE Error!")
  IDS_VICE_INFORMATION            N_("VICE Information")
  IDS_VICE_QUESTION               N_("VICE question")
  IDS_FFMPEG_DLL_MISMATCH         N_("Your ffmpeg dll version doesn't match.")
  IDS_DIRECTDRAW_ERROR            N_("DirectDraw error: Code:%8x Error:%s")
  IDS_CANNOT_SAVE_SETTINGS        N_("Cannot save settings.")
  IDS_CANNOT_LOAD_SETTINGS        N_("Cannot load settings.")
  IDS_DEFAULT_SETTINGS_RESTORED   N_("Default settings restored.")
  IDS_CANNOT_ATTACH_FILE          N_("Cannot attach specified file")
  IDS_START_MONITOR               N_("%s\012\012Start monitor? (No will reset, cancel will continue)")
  IDS_VICE_CPU_JAM                N_("VICE CPU JAM")
  IDS_EXTEND_TO_40_TRACKS         N_("Extend image to 40-track format?")
  IDS_DETACHED_DEVICE_S           N_("Detached device %s")
  IDS_ATTACHED_S_TO_DEVICE_S      N_("Attached %s to device#%s")
  IDS_DETACHED_TAPE               N_("Detached tape")
  IDS_HISTORY_RECORDED_UNKNOWN    N_("History recorded with unknown release")
  IDS_HISTORY_RECORDED_VICE_S     N_("History recorded with VICE-%s")
  IDS_PAUSED                      N_("paused")
  IDS_FRAME_NUMBER                N_("frame #")
  IDS_RESUMED                     N_("resumed")
  IDS_REALLY_EXIT                 N_("Do you really want to exit?\012\012All the data present in the emulated RAM will be lost.")
  IDS_CANNOT_AUTOSTART_FILE       N_("Cannot autostart specified file.")
  IDS_ATTACHED_TAPE_S             N_("Attached tape %s")
  IDS_SETTINGS_SAVED_SUCCESS      N_("Settings saved successfully.")
  IDS_SETTINGS_LOADED_SUCCESS     N_("Settings loaded successfully.")
  IDS_ATTACH_DISK_IMAGE           N_("Attach disk image")
  IDS_ATTACH_TAPE_IMAGE           N_("Attach tape image")
  IDS_AUTOSTART_IMAGE             N_("Autostart disk/tape image")
  IDS_INVALID_CARTRIDGE           N_("Invalid cartridge")
  IDS_BAD_CARTRIDGE_CONFIG        N_("Bad cartridge config in UI!")
  IDS_INVALID_CARTRIDGE_IMAGE     N_("Invalid cartridge image")
  IDS_LOG_CONSOLE_OUTPUT_IMAGE    N_("Logging console output image")
  IDS_LOG_FILES_TYPE              N_("VICE console logging files (*.dbg)")
  IDS_CANNOT_WRITE_LOGFILE_S      N_("Cannot write log file `%s'.")
  IDS_LOAD_FLIP_LIST_FILE         N_("Load flip list file")
  IDS_CANNOT_READ_FLIP_LIST       N_("Cannot read flip list file")
  IDS_SAVE_FLIP_LIST_FILE         N_("Save flip list file")
  IDS_CANNOT_WRITE_FLIP_LIST      N_("Cannot write flip list file")
  IDS_SELECT_KEYMAP_FILE          N_("Select keymap file")
  IDS_SAVE_KEYMAP_FILE            N_("Save keymap file")
  IDS_CANNOT_WRITE_KEYMAP_FILE    N_("Cannot write keymap file")
  IDS_SAVE_CONFIG_FILE            N_("Save config file")
  IDS_LOAD_CONFIG_FILE            N_("Load config file")
  IDS_MAPPING                     N_("Mapping")
  IDS_KEYBOARD_SETTINGS           N_("Keyboard settings")
  IDS_ATTACH                      N_("&Attach")
  IDS_PLEASE_ENTER_A_FILENAME     N_("Please enter a filename.")
  IDS_OVERWRITE_EXISTING_IMAGE    N_("Overwrite existing image?")
  IDS_CANNOT_CREATE_IMAGE         N_("Cannot create image")
  IDS_COMMAND_LINE_OPTIONS        N_("Command line options")
  IDS_COMMAND_OPTIONS_AVAIL       N_("Which command line options are available?")
  IDS_NO_DRIVER_SELECT_SUPPORT    N_("No driver selected or selected driver not supported")
  IDS_CANT_WRITE_SCREENSHOT_S     N_("Cannot write screenshot file `%s'.")
  IDS_AUTOSTART_DISK_IMAGE        N_("Autostart disk image")
  IDS_SELECT_FS_DIRECTORY         N_("Select file system directory")
  IDS_PRINTER_USERPORT            N_("Printer Userport")
  IDS_PRINTER_4                   N_("Printer 4")
  IDS_PRINTER_5                   N_("Printer 5")
  IDS_DRIVE_8                     N_("Drive 8")
  IDS_DRIVE_9                     N_("Drive 9")
  IDS_DRIVE_10                    N_("Drive 10")
  IDS_DRIVE_11                    N_("Drive 11")
  IDS_PERIPHERAL_SETTINGS         N_("Peripheral Settings")
  IDS_CANT_WRITE_SNAPSHOT_FILE    N_("Can't write snapshot file.")
  IDS_CANNOT_READ_SNAPSHOT_IMG    N_("Cannot read snapshot image")
  IDS_LOAD_S_ROM_IMAGE            N_("Load %s ROM image")
  IDS_SELECT_ROMSET_ARCHIVE       N_("Select romset archive")
  IDS_CANNOT_LOAD_ROMSET_ARCH     N_("Cannot load romset archive!")
  IDS_CANNOT_SAVE_ROMSET_ARCH     N_("Cannot save romset archive!")
  IDS_CANNOT_LOAD_ROMSET_FILE     N_("Cannot load romset file!")
  IDS_CANNOT_SAVE_ROMSET_FILE     N_("Cannot save romset file!")
  IDS_SELECT_ROMSET_FILE          N_("Select romset file")
  IDS_ROMSET                      N_("Romset")
  IDS_COMPUTER                    N_("Computer")
  IDS_DRIVE                       N_("Drive")
  IDS_ROM_SETTINGS                N_("ROM settings")
  IDS_SAVE_SNAPSHOT_IMAGE         N_("Save snapshot image")
  IDS_CANNOT_WRITE_SNAPSHOT_S     N_("Cannot write snapshot file `%s'.")
  IDS_LOAD_SNAPSHOT_IMAGE         N_("Load snapshot image")
  IDS_COULD_NOT_LOAD_PALETTE      N_("Could not load palette file.")
  IDS_LOAD_VICE_PALETTE_FILE      N_("Load VICE palette file")
  IDS_FULLSCREEN                  N_("Fullscreen/DirectX")
  IDS_COLORS                      N_("Colors")
  IDS_NEW_PAL                     N_("New PAL emulation")
  IDS_VIDEO_SETTINGS              N_("Video settings")
  IDS_FILE_SYSTEM                 N_("File system")
#ifdef HAVE_OPENCBM
  IDS_REAL_IEC_DEVICE             N_("Real IEC device")
#endif
  IDS_RS232_DEVICE_I              N_("RS232 device %i")
  IDS_ATTACH_CRT_CART_IMAGE       N_("Attach CRT cartridge image")
  IDS_ATTACH_RAW_8KB_CART_IMAGE   N_("Attach raw 8KB cartridge image")
  IDS_ATTACH_RAW_16KB_CART_IMG    N_("Attach raw 16KB cartridge image")
  IDS_ATTACH_AR_CART_IMAGE        N_("Attach Action Replay cartridge image")
  IDS_ATTACH_AR3_CART_IMAGE       N_("Attach Action Replay III cartridge image")
  IDS_ATTACH_AR4_CART_IMAGE       N_("Attach Action Replay 4 cartridge image")
  IDS_ATTACH_STARDOS_CART_IMAGE   N_("Attach StarDOS cartridge image")
  IDS_ATTACH_ATOMIC_P_CART_IMG    N_("Attach Atomic Power cartridge image")
  IDS_ATTACH_EPYX_FL_CART_IMG     N_("Attach Epyx fastload cartridge image")
  IDS_ATTACH_IEEE488_CART_IMG     N_("Attach IEEE interface cartridge image")
  IDS_ATTACH_RETRO_R_CART_IMG     N_("Attach Retro Replay cartridge image")
  IDS_ATTACH_IDE64_CART_IMAGE     N_("Attach IDE64 interface cartridge image")
  IDS_ATTACH_SS4_CART_IMAGE       N_("Attach Super Snapshot 4 cartridge image")
  IDS_ATTACH_SS5_CART_IMAGE       N_("Attach Super Snapshot 5 cartridge image")
  IDS_ATTACH_STB_CART_IMAGE       N_("Attach Structured Basic cartridge image")
  IDS_MODEL                       N_("Model")
  IDS_DRIVE_SETTINGS              N_("Drive Settings")
  IDS_SELECT_START_SNAP_EVENT     N_("Select start snapshot for event history")
  IDS_SELECT_END_SNAP_EVENT       N_("Select end snapshot for event history")
#ifdef UNSTABLE
  IDS_VERSION_S_UNSTABLE          N_("Version %s *UNSTABLE* (%s)")
#else
  IDS_VERSION_S                   N_("Version %s (%s)")
#endif
  IDS_VICE_CONTRIBUTORS           N_("VICE contributors")
  IDS_WHO_MADE_WHAT               N_("Who made what?")
  IDS_LICENSE                     N_("License")
  IDS_NO_WARRANTY                 N_("No warranty!")
  IDS_VICE_WITHOUT_WARRANTY       N_("VICE is distributed WITHOUT ANY WARRANTY!")
  IDS_PRESS_KEY_NORTHWEST         N_("Press key for NorthWest")
  IDS_PRESS_KEY_NORTH             N_("Press key for North")
  IDS_PRESS_KEY_NORTHEAST         N_("Press key for NorthEast")
  IDS_PRESS_KEY_EAST              N_("Press key for East")
  IDS_PRESS_KEY_SOUTHEAST         N_("Press key for SouthEast")
  IDS_PRESS_KEY_SOUTH             N_("Press key for South")
  IDS_PRESS_KEY_SOUTHWEST         N_("Press key for SouthWest")
  IDS_PRESS_KEY_WEST              N_("Press key for West")
  IDS_PRESS_KEY_FIRE              N_("Press key for Fire")
  IDS_NO_USERPORT_ADAPTER         N_("No userport joy adapter")
  IDS_CGA_USERPORT_ADAPTER        N_("CGA userport joy adapter")
  IDS_PET_USERPORT_ADAPTER        N_("PET userport joy adapter")
  IDS_HUMMER_USERPORT_ADAPTER     N_("HUMMER userport joy adapter")
  IDS_OEM_USERPORT_ADAPTER        N_("OEM userport joy adapter")
  IDS_HIT_USERPORT_ADAPTER        N_("HIT userport joy adapter")
  IDS_NO_SIDCART_JOY              N_("Disable SIDcart joy")
  IDS_SIDCART_JOY                 N_("Enable SIDcart joy")
  IDS_NUMPAD_AND_RCTRL            N_("Numpad + RCtrl")
  IDS_KEYSET_A                    N_("Keyset A")
  IDS_KEYSET_B                    N_("Keyset B")
  IDS_ALL_BUTTONS_AS_FIRE         N_("All buttons used as fire")
  IDS_NUMERIC_SEE_ABOVE           N_("numeric (see above)")
  IDS_NO_BUTTON_NO_AUTOFIRE       N_("No button - Autofire disabled")
  IDS_ALL_FILES_FILTER            N_("All files (*.*)")
  IDS_PALETTE_FILES_FILTER        N_("VICE palette files (*.vpl)")
  IDS_SNAPSHOT_FILES_FILTER       N_("VICE snapshot files (*.vsf)")
  IDS_CBM_IMAGE_FILES_FILTER      N_("CBM files (*.d64;*.d71;*.d80;*.d81;*.d82;*.g64;*.g41;*.x64;*.t64;*.tap;*.prg;*.p00)")
  IDS_DISK_IMAGE_FILES_FILTER     N_("Disk image files (*.d64;*.d71;*.d80;*.d81;*.d82;*.g64;*.g41;*.x64)")
  IDS_TAPE_IMAGE_FILES_FILTER     N_("Tape image files (*.t64;*.tap)")
  IDS_ZIPPED_FILES_FILTER         N_("Zipped files (*.zip;*.bz2;*.gz;*.d6z;*.d7z;*.d8z;*.g6z;*.g4z;*.x6z)")
  IDS_CRT_FILES_FILTER            N_("CRT cartridge image files (*.crt)")
  IDS_RAW_CART_FILES_FILTER       N_("Raw cartridge image files (*.bin)")
  IDS_FLIP_LIST_FILES_FILTER      N_("VICE flip list files (*.vfl)")
  IDS_ROMSET_FILES_FILTER         N_("VICE romset files (*.vrs)")
  IDS_ROMSET_ARCHIVES_FILTER      N_("VICE romset archives (*.vra)")
  IDS_KEYMAP_FILES_FILTER         N_("VICE keymap files (*.vkm)")
  IDS_PRGP00_FILES_FILTER         N_("Commodore emulator files (*.prg;*.p00)")
  IDS_FLEXIBLE                    N_("Flexible")
  IDS_ADJUSTING                   N_("Adjusting")
  IDS_EXACT                       N_("Exact")
  IDS_SOUND_DRIVER_DIRECTX        N_("Sound driver: DirectX")
  IDS_SOUND_DRIVER_WMM            N_("Sound driver: WMM")
  IDS_MEDIA_FILES_FILTER          N_("Media files (*.bmp;*.gif;*.iff;*.jpg;*.pcx;*.png;*.ppm;*.wav;*.mp3;*.avi;*.mpg)")
  IDS_SPACE_KB                    N_(" kB")
  IDS_CONFIGURE_KEYSET_A          N_("Configure Keyset A")
  IDS_CONFIGURE_KEYSET_B          N_("Configure Keyset B")
  IDS_SAVE_MEDIA_IMAGE            N_("Save media image")
  IDS_S_AT_D_SPEED                N_("%s at %d%% speed, %d fps%s")
  IDS_TAPE                        N_("Tape:")
  IDS_JOYSTICK_C                  N_("Joystick:")
  IDS_RECORDING                   N_("Recording\n%02d:%02d")
  IDS_PLAYBACK                    N_("Playback\n%02d:%02d (%02d:%02d)")
  IDS_UNKNOWN                     N_("Unknown")
  IDS_P_NUMBER                    N_("<number>")
  IDS_SET_INPUT_JOYSTICK_1        N_("Set input device for joystick #1")
  IDS_SET_INPUT_JOYSTICK_2        N_("Set input device for joystick #2")
  IDS_SET_INPUT_EXTRA_JOYSTICK_1  N_("Set input device for extra joystick #1")
  IDS_SET_INPUT_EXTRA_JOYSTICK_2  N_("Set input device for extra joystick #2")
  IDS_SAVE_SETTINGS_ON_EXIT       N_("Save settings (resources) on exit")
  IDS_NO_SAVE_SETTINGS_ON_EXIT    N_("Never save settings (resources) on exit")
  IDS_CONFIRM_QUIT_VICE           N_("Confirm quiting VICE")
  IDS_NO_CONFIRM_QUIT_VICE        N_("Never confirm quiting VICE")
  IDS_USE_ALL_CPU_SMP             N_("Use all CPU on SMP systems")
  IDS_USE_FIRST_CPU_SMP           N_("Use only first CPU on SMP systems")
  IDS_START_VICE_FULLSCREEN_MODE  N_("Start VICE in fullscreen mode")
  IDS_DISABLE_DX9                 N_("Disable DirectX9 video driver")
#ifdef SYS_SIGLIST_DECLARED
  IDS_RECEIVED_SIGNAL_D_S         N_("An unexpected error occured. Received signal %d (%s).")
#else
  IDS_RECEIVED_SIGNAL_D           N_("An unexpected error occured. Received signal %d.")
#endif
#ifdef HAVE_NETWORK
  IDS_IDLE                        N_("Idle")
  IDS_SERVER_LISTENING            N_("Server listening")
  IDS_CONNECTED_SERVER            N_("Connected server")
  IDS_CONNECTED_CLIENT            N_("Connected Client")
  IDS_INVALID_PORT_NUMBER         N_("Invalid port number")
  IDS_ERROR_STARTING_SERVER       N_("An error occured starting the server.")
  IDS_ERROR_CONNECTING_CLIENT     N_("An error occured connecting the client.")
#endif
  IDS_SOUND_RECORDING_STARTED     N_("Sound Recording started...")
  IDS_SOUND_RECORDING_STOPPED     N_("Sound Recording stopped...")
  IDS_OK                          N_("OK")
  IDS_CANCEL                      N_("Cancel")
  IDS_NONE                        N_("None")
  IDS_BROWSE                      N_("&Browse...")
  IDS_SPECIFY_MIDI_IN             N_("Specify MIDI-In device")
  IDS_SPECIFY_MIDI_OUT            N_("Specify MIDI-Out device")
  IDS_ERROR_SAVING_EASYFLASH_CRT  N_("Error saving EasyFlash crt file")
  IDS_DATASETTE_CAPTION           N_("Datasette Settings")
  IDS_DATASETTE_RESET_WITH_CPU    N_("&Reset Datasette with CPU")
  IDS_DATASETTE_MOTOR_GROUP       N_("Speed of motor while reading")
  IDS_DATASETTE_DELAY_TRIGGER     N_("cycle(s) additional &delay each trigger")
  IDS_DATASETTE_DELAY_AT_ZERO     N_("cycles delay at &zero-values")
  IDS_TOGGLE_USEIECDEVICE         N_("&Use IEC Device")
  IDS_SELECTDISK                  N_("Disk &image")
  IDS_SELECTDIR                   N_("&Directory")
#ifdef HAVE_OPENCBM
  IDS_SELECTREAL                  N_("Rea&l IEC device")
#endif
  IDS_SELECTNONE                  N_("&None")
  IDS_AUTOSTART                   N_("&Autostart")
  IDS_BROWSEDIR                   N_("Bro&wse...")
  IDS_TOGGLE_ATTACH_READONLY      N_("Attach read only")
  IDS_TOGGLE_READP00              N_("&Read P00 files")
  IDS_TOGGLE_WRITEP00             N_("&Write P00 files")
  IDS_TOGGLE_HIDENONP00           N_("&Hide non-P00 files")
  IDS_JOYSTICK_CAPTION            N_("Joystick settings")
  IDS_JOYSTICK_IN_PORT_1          N_("Joystick in port #&1")
  IDS_SELECT_FIRE_BUTTON          N_("Select fire button")
  IDS_AUTO_FIRE_BUTTON_SETTINGS   N_("Auto fire button settings")
  IDS_AUTOFIRE_SPEED              N_("Autofire &speed (1..32)")
  IDS_JOYSTICK_IN_PORT_2          N_("Joystick in port #&2")
  IDS_JOY_CONFIG_A                N_("Config Keyset &A")
  IDS_JOY_CONFIG_B                N_("Config Keyset &B")
  IDS_JOY_CALIBRATE               N_("&Calibrate Joystick(s)")
  IDS_EXTRA_JOYSTICK_CAPTION      N_("Extra joystick settings")
  IDS_JOYSTICK_IN_EXTRA_PORT_1    N_("Joystick in extra port #&1")
  IDS_JOYSTICK_IN_EXTRA_PORT_2    N_("Joystick in extra port #&2")
  IDS_KEYSET_SW                   N_("S&outh West")
  IDS_KEYSET_S                    N_("&South")
  IDS_KEYSET_SE                   N_("So&uth East")
  IDS_KEYSET_W                    N_("&West")
  IDS_KEYSET_E                    N_("&East")
  IDS_KEYSET_NW                   N_("No&rth West")
  IDS_KEYSET_N                    N_("&North")
  IDS_KEYSET_NE                   N_("Nor&th East")
  IDS_KEYSET_FIRE                 N_("&Fire button")
  IDS_SOUND_CAPTION               N_("Configure Sound Device Settings")
  IDS_SOUND_DIRECTX               N_("DirectX driver")
  IDS_SOUND_WMM                   N_("WMM driver")
  IDS_SOUND_SAMPLE_FREQUENCY      N_("Sample &Frequency :")
  IDS_SOUND_BUFFER_SIZE           N_("Sound Buffer &Size :")
  IDS_SOUND_FRAGMENT_SIZE_LABEL   N_("Sound Fragment Size :")
  IDS_SOUND_FRAGMENT_SIZE_SMALL   N_("Small")
  IDS_SOUND_FRAGMENT_SIZE_MEDIUM  N_("Medium")
  IDS_SOUND_FRAGMENT_SIZE_LARGE   N_("Large")
  IDS_SOUND_SYNCH_METHOD          N_("Synchronization &Method :")
  IDS_TOGGLE_SNAPSHOT_SAVE_DISKS  N_("Save currently attached &disks images")
  IDS_TOGGLE_SNAPSHOT_SAVE_ROMS   N_("Save currently loaded &ROM images")
  IDS_FULLSCREEN_DRIVER           N_("Driver:")
  IDS_FULLSCREEN_DRVR_BITDEPTH    N_("Bitdepth:")
  IDS_FULLSCREEN_DRVR_RESOLUTION  N_("Resolution:")
  IDS_FULLSCREEN_DRVR_REFRESHRATE N_("Refreshrate:")
  IDS_TOGGLE_VIDEO_VBLANK_SYNC    N_("VBLANK synchronization")
  IDS_TOGGLE_VIDEO_DX_PRIMARY     N_("Render to DX Primary surface")
  IDS_TOGGLE_KEEP_ASPECT_RATIO    N_("Keep aspect ratio (0,5..2)")
  IDS_COLORS_SATURATION           N_("Saturation (0..2)")
  IDS_COLORS_CONTRAST             N_("Contrast (0..2)")
  IDS_COLORS_BRIGHTNESS           N_("Brightness (0..2)")
  IDS_NEW_PAL_TINT                N_("Tint (0..2)")
  IDS_NEW_PAL_ODD_LINES_PHASE     N_("Odd lines phase (0..2)")
  IDS_NEW_PAL_ODD_LINES_OFFSET    N_("Odd lines offset (0..2)")
  IDS_VIDEO_GAMMA                 N_("Gamma (0..2)")
  IDS_VIDEO_PHASE                 N_("Phase (0..2)")
  IDS_VIDEO_PAL_SHADE             N_("PAL Shade (0..1)")
  IDS_VIDEO_PAL_BLUR              N_("PAL Blur (0..1)")
  IDS_TOGGLE_VIDEO_EXTPALETTE     N_("External Palette:")
  IDS_RAM_CAPTION                 N_("RAM Settings")
  IDS_RAM_INIT_AT_POWERUP         N_("Initialization at powerup")
  IDS_RAM_VALUE_FIRST_BYTE        N_("Value of first byte")
  IDS_RAM_LENGTH_CONSTANT_VALUES  N_("Length of constant values")
  IDS_RAM_LENGTH_CONSTANT_PATTERN N_("Length of constant pattern")
  IDS_PRINTER_EMULATION           N_("Printer emulation")
  IDS_PRINTER_FORMFEED            N_("Send Formfeed")
  IDS_FILESYSTEM_PRINTER          N_("File system printer")
  IDS_PRINTER_DRVR                N_("Printer driver")
  IDS_OUTPUT                      N_("Output")
  IDS_OUTPUT_TO_FILE              N_("Output to file #")
  IDS_OUTPUT_FILE1_NAME           N_("Output file #1 name")
  IDS_OUTPUT_FILE2_NAME           N_("Output file #2 name")
  IDS_OUTPUT_FILE3_NAME           N_("Output file #3 name")
  IDS_ROMSET_SELECT_ARCHIVE       N_("Romset archive")
  IDS_ROMSET_ARCHIVE_LOAD         N_("Load archive")
  IDS_ROMSET_ARCHIVE_SAVE         N_("Save archive")
  IDS_ROMSET_CONFIGURATION        N_("&Configuration")
  IDS_ROMSET_ARCHIVE_APPLY        N_("Apply")
  IDS_ROMSET_ARCHIVE_NEW          N_("New")
  IDS_ROMSET_ARCHIVE_DELETE       N_("Delete")
  IDS_ROMSET_SELECT_FILE          N_("Romset file")
  IDS_ROMSET_FILE_LOAD            N_("Load romset")
  IDS_ROMSET_FILE_SAVE            N_("Save romset")
  IDS_CUSTOM_SPEED_CAPTION        N_("Custom speed")
  IDS_ENTER_CUSTOM_SPEED          N_("Enter custom speed [%]")
  IDS_NEW_CONFIGURATION           N_("New configuration")
  IDS_ENTER_CONFIGURATION_NAME    N_("Enter configuration name")
  IDS_RS232_CAPTION               N_("RS232 Settings")
  IDS_RS232_DEV_1                 N_("RS232 device 1")
  IDS_RS232_DEV_2                 N_("RS232 device 2")
  IDS_RS232_DEV_3                 N_("RS232 device 3")
  IDS_RS232_DEV_4                 N_("RS232 device 4")
  IDS_NETWORK_CAPTION             N_("Netplay Settings")
  IDS_CURRENT_MODE                N_("Current mode")
  IDS_SERVER_BIND                 N_("Server Bind")
  IDS_TCP_PORT                    N_("TCP-Port")
  IDS_NETWORK_SERVER              N_("Start server")
  IDS_NETWORK_CLIENT              N_("Connect to")
  IDS_NETWORK_DISCONNECT          N_("Disconnect")
  IDS_CONTROL                     N_("Control")
  IDS_SERVER                      N_("Server")
  IDS_CLIENT                      N_("Client")
  IDS_KEYBOARD                    N_("Keyboard")
  IDS_JOYSTICK_1                  N_("Joystick 1")
  IDS_JOYSTICK_2                  N_("Joystick 2")
  IDS_DEVICES                     N_("Devices")
  IDS_SETTINGS                    N_("Settings")
  IDS_TOGGLE_CONSOLE_APPEND       N_("&Append log to existing file")
  IDS_IMAGE_CONTENTS              N_("Image Contents")
  IDS_NEW_IMAGE                   N_("New Image")
  IDS_NAME                        N_("Name")
  IDS_ID                          N_("ID")
  IDS_TYPE                        N_("Type")
  IDS_BLANK_IMAGE                 N_("Create Image")
  IDS_NEW_TAP_IMAGE               N_("New TAP Image")
  IDS_SAVE                        N_("Save")
  IDS_SELECT_DRIVER               N_("Select Driver")
  IDS_FFMPEG_SETTINGS             N_("FFMPEG settings")
  IDS_FORMAT                      N_("Format")
  IDS_AUDIO_CODEC                 N_("Audio codec")
  IDS_BITRATE                     N_("bitrate")
  IDS_VIDEO_CODEC                 N_("Video codec")
  IDS_SOUND_RECORD_CAPTION        N_("Sound record settings")
  IDS_SOUND_RECORD_FORMAT_LABEL   N_("Sound Record Format")
  IDS_SOUND_RECORD_FILE_LABEL     N_("Sound Record File")
  IDS_KERNAL                      N_("Kernal")
  IDS_BASIC                       N_("Basic")
  IDS_CHARACTER                   N_("Character")
  IDS_COMPUTER_RESOURCES_CAPTION  N_("Computer resources")
  IDS_COMPUTER_RESOURCES          N_("Computer resources saved to romset")
  IDS_DRIVE_RESOURCES_CAPTION     N_("Drive resources")
  IDS_DRIVE_RESOURCES             N_("Drive resources saved to romset")
  IDS_SYMBOLIC                    N_("&Symbolic")
  IDS_POSITIONAL                  N_("&Positional")
  IDS_DUMP_KEYSET                 N_("Dump keyset")
  IDS_DUMP_SHORTCUTS              N_("Dump shortcuts")
  IDS_SYMBOLIC_US                 N_("&Symbolic US")
  IDS_SYMBOLIC_DE                 N_("&Symbolic DE")
  IDS_GR_SYM                      N_("&Gr Sym.")
  IDS_GR_POS                      N_("G&r Pos.")
  IDS_UK_SYM                      N_("&UK Sym.")
  IDS_UK_POS                      N_("U&K Pos.")
  IDS_DE_SYM                      N_("&DE Sym.")
  IDS_DE_POS                      N_("D&E Pos.")
  IDS_A_MEMORY                    N_("&Memory")
  IDS_DRIVE_TYPE                  N_("&Drive type")
  IDS_40_TRACK_HANDLING           N_("40 &track handling")
  IDS_SELECT_DRIVE_EXTEND_NEVER   N_("Never extend")
  IDS_SELECT_DRIVE_EXTEND_ASK     N_("Ask on extend")
  IDS_SELECT_DRIVE_EXTEND_ACCESS  N_("Extend on access")
  IDS_IDLE_METHOD                 N_("Id&le method")
  IDS_SELECT_DRIVE_IDLE_TRAP_IDLE N_("Trap idle")
  IDS_SELECT_DRIVE_IDLE_SKIP_CYC  N_("Skip cycles")
  IDS_TOGGLE_DRIVE_PARALLEL_CABLE N_("&Parallel cable")
  IDS_DRIVE_EXPANSION             N_("Drive &expansion")
  IDS_TOGGLE_DRIVE_EXPANSION_2000 N_("$2000-$3FFF &RAM")
  IDS_TOGGLE_DRIVE_EXPANSION_4000 N_("$&4000-$5FFF RAM")
  IDS_TOGGLE_DRIVE_EXPANSION_6000 N_("$&6000-$7FFF RAM")
  IDS_TOGGLE_DRIVE_EXPANSION_8000 N_("$8000-$9FFF RA&M")
  IDS_TOGGLE_DRIVE_EXPANSION_A000 N_("$&A000-$BFFF RAM")
  IDS_PLUS4_VIC20_MEMORY          N_("&Memory")
  IDS_SID_GENGROUP1               N_("SID Engine/Model")
  IDS_SID_FILTERS                 N_("SID Filters")
  IDS_MP_FILE                     N_("&File")
  IDS_MP_ATTACH_DISK_IMAGE        N_("Attach &disk image")
  IDS_MP_DETACH_DISK_IMAGE        N_("D&etach disk image")
  IDS_MP_FLIP_LIST                N_("&Flip list")
  IDS_MP_DATASETTE_CONTROL        N_("Datassette contro&l")
  IDS_MP_ATTACH_CARTRIDGE_IMAGE   N_("Attach &cartridge image...")
  IDS_MP_EXPERT_CARTRIDGE         N_("Expert Cartridge")
  IDS_MP_RESET                    N_("&Reset")
  IDS_MP_DEBUG                    N_("&Debug")
#ifdef DEBUG
  IDS_MP_MODE                     N_("M&ode")
#endif
  IDS_MP_EDIT                     N_("Edit")
  IDS_MP_SNAPSHOT                 N_("Sna&pshot")
  IDS_MP_RECORDING_START_MODE     N_("Recording start mode")
  IDS_MP_OPTIONS                  N_("&Options")
  IDS_MP_REFRESH_RATE             N_("&Refresh rate")
  IDS_MP_MAXIMUM_SPEED            N_("&Maximum Speed")
  IDS_MP_VIDEO_STANDARD           N_("Vide&o standard")
  IDS_MP_DRIVE_SYNC_FACTOR        N_("Drive s&ync factor")
  IDS_MP_SETTINGS                 N_("S&ettings")
  IDS_MP_CARTRIDGE_IO_SETTINGS    N_("&Cartridge/IO settings")
  IDS_MP_LANGUAGE                 N_("&Language")
  IDS_MP_HELP                     N_("&Help")
  IDS_MP_VIEW                     N_("&View")
  IDS_MP_WINDOW                   N_("&Window")
  IDS_MI_EXIT                     N_("E&xit")
  IDS_MI_ABOUT                    N_("&About...")
  IDS_MI_PAUSE                    N_("&Pause")
  IDS_MI_EDIT_COPY                N_("&Copy")
  IDS_MI_EDIT_PASTE               N_("&Paste")
  IDS_MI_AUTOSTART                N_("&Autostart disk/tape image...")
  IDS_MI_RESET_HARD               N_("&Hard")
  IDS_MI_RESET_SOFT               N_("&Soft")
  IDS_MI_DRIVE8                   N_("Drive &8")
  IDS_MI_DRIVE9                   N_("Drive &9")
  IDS_MI_DRIVE10                  N_("Drive 1&0")
  IDS_MI_DRIVE11                  N_("Drive 1&1")
  IDS_MI_ATTACH_TAPE              N_("Attach &tape image...")
  IDS_MI_DETACH_TAPE              N_("Detac&h tape image")
  IDS_MI_DETACH_ALL               N_("&All")
  IDS_MI_TOGGLE_SOUND             N_("&Sound playback")
  IDS_MI_TOGGLE_DOUBLESIZE        N_("&Double size")
  IDS_MI_TOGGLE_DOUBLESCAN        N_("Dou&ble scan")
  IDS_MI_DRIVE_TRUE_EMULATION     N_("&True drive emulation")
  IDS_MI_AUTOSTART_HANDLE_TDE     N_("Ha&ndle TDE for autostart")
  IDS_MI_TOGGLE_VIDEOCACHE        N_("Video &cache")
  IDS_MI_DRIVE_SETTINGS           N_("&Drive settings...")
  IDS_MI_CART_ATTACH_CRT          N_("&CRT image...")
  IDS_MI_CART_ATTACH_8KB          N_("Generic &8KB image...")
  IDS_MI_CART_ATTACH_16KB         N_("Generic &16KB image...")
  IDS_MI_CART_ATTACH_AR           N_("&Action Replay image...")
  IDS_MI_CART_ATTACH_AR3          N_("&Action Replay 3 image...")
  IDS_MI_CART_ATTACH_AR4          N_("&Action Replay 4 image...")
  IDS_MI_CART_ATTACH_STARDOS      N_("&StarDOS image...")
  IDS_MI_CART_ATTACH_AT           N_("Atomic &Power image...")
  IDS_MI_CART_ATTACH_EPYX         N_("&Epyx fastload image...")
  IDS_MI_CART_ATTACH_IEEE488      N_("&IEEE488 interface image...")
  IDS_MI_CART_ATTACH_RR           N_("&Retro Replay image...")
  IDS_MI_CART_ATTACH_IDE64        N_("IDE&64 interface image...")
  IDS_MI_CART_ATTACH_SS4          N_("Super Snapshot &4 image...")
  IDS_MI_CART_ATTACH_SS5          N_("Super Snapshot &5 image...")
  IDS_MI_CART_ATTACH_STB          N_("Structured &Basic image...")
  IDS_MI_FLIP_ADD                 N_("&Add current image")
  IDS_MI_FLIP_REMOVE              N_("&Remove current image")
  IDS_MI_FLIP_NEXT                N_("Attach &next image")
  IDS_MI_FLIP_PREVIOUS            N_("Attach &previous image")
  IDS_MI_FLIP_LOAD                N_("&Load flip list")
  IDS_MI_FLIP_SAVE                N_("&Save flip list")
  IDS_MI_DATASETTE_STOP           N_("S&top")
  IDS_MI_DATASETTE_START          N_("&Start")
  IDS_MI_DATASETTE_FORWARD        N_("&Forward")
  IDS_MI_DATASETTE_REWIND         N_("&Rewind")
  IDS_MI_DATASETTE_RECORD         N_("Re&cord")
  IDS_MI_DATASETTE_RESET          N_("R&eset")
  IDS_MI_DATASETTE_RESET_COUNTER  N_("Reset C&ounter")
  IDS_MI_CART_ENABLE_EXPERT       N_("Enable")
  IDS_MI_CART_MODE_OFF            N_("Off")
  IDS_MI_CART_MODE_ON             N_("On")
  IDS_MI_CART_SET_DEFAULT         N_("Set cartridge as &default")
  IDS_MI_TOGGLE_CART_RESET        N_("Reset &on cart change")
  IDS_MI_CART_DETACH              N_("Detach cartridge &image")
  IDS_MI_CART_FREEZE              N_("Cartridge free&ze")
  IDS_MI_MONITOR                  N_("&Monitor")
#ifdef DEBUG
  IDS_MI_DEBUG_MODE_NORMAL        N_("&Normal")
  IDS_MI_DEBUG_MODE_SMALL         N_("&Small")
  IDS_MI_DEBUG_MODE_HISTORY       N_("&History")
  IDS_MI_DEBUG_MODE_AUTOPLAY      N_("&History Autoplay")
  IDS_MI_TOGGLE_MAINCPU_TRACE     N_("&Main CPU Trace")
  IDS_MI_TOGGLE_DRIVE0CPU_TRACE   N_("Drive&0 CPU Trace")
  IDS_MI_TOGGLE_DRIVE1CPU_TRACE   N_("Drive&1 CPU Trace")
#endif
  IDS_MI_SNAPSHOT_LOAD            N_("Load snapshot &image...")
  IDS_MI_SNAPSHOT_SAVE            N_("Save sna&pshot image...")
  IDS_MI_LOADQUICK                N_("&Load quicksnapshot image")
  IDS_MI_SAVEQUICK                N_("&Save quicksnapshot image")
  IDS_MI_EVENT_TOGGLE_RECORD      N_("Start/Stop &Recording History")
  IDS_MI_EVENT_TOGGLE_PLAYBACK    N_("Start/Stop Pl&ayback History")
  IDS_MI_EVENT_SETMILESTONE       N_("Set Recording Milestone")
  IDS_MI_EVENT_RESETMILESTONE     N_("Return to Milestone")
  IDS_MI_EVENT_START_MODE_SAVE    N_("&Save new snapshot")
  IDS_MI_EVENT_START_MODE_LOAD    N_("&Load existing snapshot")
  IDS_MI_EVENT_START_MODE_RESET   N_("Start with &reset")
  IDS_MI_EVENT_START_MODE_PLAYBCK N_("Overwrite &Playback")
  IDS_MI_EVENT_DIRECTORY          N_("Select History files/directory")
  IDS_MI_MEDIAFILE                N_("Save/stop media file...")
  IDS_MI_SOUND_RECORD_START       N_("Record Sound...")
  IDS_MI_SOUND_RECORD_STOP        N_("Stop Sound Recording")
  IDS_MI_REFRESH_RATE_AUTO        N_("&Auto")
  IDS_MI_MAXIMUM_SPEED_NO_LIMIT   N_("No &limit")
  IDS_MI_MAXIMUM_SPEED_CUSTOM     N_("&Custom")
  IDS_MI_TOGGLE_WARP_MODE         N_("&Warp mode")
  IDS_MI_TOGGLE_ALWAYSONTOP       N_("Always on Top")
  IDS_MI_TOGGLE_FASTPAL           N_("PAL Emulation")
  IDS_MI_TOGGLE_SCALE2X           N_("Scale2x")
  IDS_MI_SWAP_JOYSTICK            N_("Swap &Joysticks")
  IDS_MI_SWAP_EXTRA_JOYSTICK      N_("Swap &Userport joysticks")
  IDS_MI_ALLOW_JOY_OPPOSITE       N_("Allow opposite joystick directions")
  IDS_MI_JOYKEYS_TOGGLE           N_("Enable Joy Keys")
  IDS_MI_TOGGLE_VIRTUAL_DEVICES   N_("&Virtual device traps")
  IDS_MI_TOGGLE_EMUID             N_("Emulator &Identification")
  IDS_MI_MOUSE                    N_("&Grab mouse events")
  IDS_MI_AUTOSTART_SETTINGS       N_("&Autostart settings...")
  IDS_MI_VIDEO_SETTINGS           N_("&Video settings...")
  IDS_MI_DEVICEMANAGER            N_("&Peripheral settings...")
  IDS_MI_JOY_SETTINGS             N_("&Joystick settings...")
  IDS_MI_USERPORT_JOY_SETTINGS    N_("&Userport joystick settings...")
  IDS_MI_SIDCART_JOY_SETTINGS     N_("&Sidcart joystick settings...")
  IDS_MI_KEYBOARD_SETTINGS        N_("&Keyboard settings...")
  IDS_MI_SOUND_SETTINGS           N_("S&ound settings...")
  IDS_MI_ROM_SETTINGS             N_("&ROM settings...")
  IDS_MI_RAM_SETTINGS             N_("RA&M settings...")
  IDS_MI_DATASETTE_SETTINGS       N_("D&atasette settings...")
  IDS_MI_VICII_SETTINGS           N_("VIC-II settings...")
  IDS_MI_MOUSE_SETTINGS           N_("Mo&use settings...")
  IDS_MI_SID_SETTINGS             N_("S&ID settings...")
  IDS_MI_RS232_SETTINGS           N_("RS&232 settings...")
  IDS_MI_REU_SETTINGS             N_("&REU settings...")
  IDS_MI_GEORAM_SETTINGS          N_("&GEORAM settings...")
  IDS_MI_RAMCART_SETTINGS         N_("&RAMCART settings...")
  IDS_MI_DQBB_SETTINGS            N_("&Double Quick Brown Box settings...")
  IDS_MI_ISEPIC_SETTINGS          N_("I&sepic settings...")
  IDS_MI_MMC64_SETTINGS           N_("&MMC64 settings...")
  IDS_MI_MIDI_SETTINGS            N_("M&IDI settings...")
  IDS_MI_DIGIMAX_SETTINGS         N_("&DIGIMAX settings...")
  IDS_MI_LIGHTPEN_SETTINGS        N_("&Lightpen settings...")
  IDS_MI_IDE64_SETTINGS           N_("&IDE64 settings...")
#ifdef HAVE_TFE
  IDS_MI_TFE_SETTINGS             N_("&Ethernet settings...")
#endif
  IDS_MI_ACIA_SETTINGS            N_("&ACIA settings...")
  IDS_MI_RS232USER_SETTINGS       N_("RS&232 userport settings...")
  IDS_MI_EASYFLASH_SETTINGS       N_("EasyFlash settings...")
  IDS_MI_SFX_SE_SETTINGS          N_("SFX Sound Expander settings...")
  IDS_MI_TOGGLE_SFX_SS            N_("Enable SFX Sound Sampler")
  IDS_MI_SETTINGS_SAVE_FILE       N_("Save current settings to specified file")
  IDS_MI_SETTINGS_LOAD_FILE       N_("Load settings from specified file")
  IDS_MI_SETTINGS_SAVE            N_("&Save current settings")
  IDS_MI_SETTINGS_LOAD            N_("&Load saved settings")
  IDS_MI_SETTINGS_DEFAULT         N_("Set de&fault settings")
  IDS_MI_SAVE_SETTINGS_ON_EXIT    N_("Save settings on e&xit")
  IDS_MI_CONFIRM_ON_EXIT          N_("&Confirm on exit")
  IDS_MI_LANG_EN                  N_("&English")
  IDS_MI_LANG_DA                  N_("D&anish")
  IDS_MI_LANG_DE                  N_("&German")
  IDS_MI_LANG_FR                  N_("&French")
  IDS_MI_LANG_HU                  N_("&Hungarian")
  IDS_MI_LANG_IT                  N_("&Italian")
  IDS_MI_LANG_NL                  N_("&Dutch")
  IDS_MI_LANG_PL                  N_("&Polish")
  IDS_MI_LANG_SV                  N_("&Swedish")
  IDS_MI_LANG_TR                  N_("&Turkish")
  IDS_MI_CMDLINE                  N_("Command line &options")
  IDS_MI_CONTRIBUTORS             N_("&Contributors")
  IDS_MI_LICENSE                  N_("&License")
  IDS_MI_WARRANTY                 N_("No &warranty")
  IDS_MI_TOGGLE_FULLSCREEN        N_("Fullscreen")
  IDS_MI_SIDCART_SETTINGS         N_("&SID cart settings...")
  IDS_MI_MON_OPEN                 N_("&Open")
  IDS_MI_MON_SAVE                 N_("&Save")
  IDS_MI_MON_PRINT                N_("&Print")
  IDS_MI_MON_EXIT                 N_("E&xit\tAlt+F4")
  IDS_MI_MON_STOP_DEBUG           N_("&Stop Debug")
  IDS_MI_MON_STOP_EXEC            N_("Stop E&xecution")
  IDS_MI_MON_STEP_INTO            N_("Step &into")
  IDS_MI_MON_STEP_OVER            N_("Step &over")
  IDS_MI_MON_SKIP_RETURN          N_("Step until &return")
  IDS_MI_MON_GOTO_CURSOR          N_("Go to &cursor")
  IDS_MI_MON_EVAL                 N_("&Evaluate")
  IDS_MI_MON_CURRENT              N_("&Current instruction")
  IDS_MI_MON_WND_EVAL             N_("Evaluation &window")
  IDS_MI_MON_WND_REG              N_("&Register window")
  IDS_MI_MON_WND_MEM              N_("&Memory window")
  IDS_MI_MON_WND_DIS              N_("&Disassembly window")
  IDS_MI_MON_WND_CONSOLE          N_("&Console window")
  IDS_MI_MON_COMPUTER             N_("&Computer")
  IDS_MI_MON_DRIVE8               N_("Drive &8")
  IDS_MI_MON_DRIVE9               N_("Drive &9")
  IDS_MI_MON_CASCADE              N_("&Cascade")
  IDS_MI_MON_TILE_VERT            N_("Tile &vertically")
  IDS_MI_MON_TILE_HORIZ           N_("Tile &horizontally")
  IDS_MI_MON_ARRANGE_ICONS        N_("&Arrange icons")
END



STRINGTABLE
LANGUAGE LANG_DANISH, SUBLANG_NEUTRAL
BEGIN
  IDS_VICE_ERROR                  "VICE-fejl!"
  IDS_VICE_INFORMATION            "VICE-information"
  IDS_VICE_QUESTION               "VICE-sprgsml"
  IDS_FFMPEG_DLL_MISMATCH         "Versionen p din ffmpeg-dll passer ikke."
  IDS_DIRECTDRAW_ERROR            "DirectDraw-fejl: Kode:%8x Fejl:%s"
  IDS_CANNOT_SAVE_SETTINGS        "Kunne ikke gemme indstillinger."
  IDS_CANNOT_LOAD_SETTINGS        "Kunne ikke indlse indstillinger."
  IDS_DEFAULT_SETTINGS_RESTORED   "Standardindstillinger gendannet."
  IDS_CANNOT_ATTACH_FILE          "Kan ikke tilslutte den valgte fil"
  IDS_START_MONITOR               "%s\012\012Start monitor? (Nej resetter, Annuler Fortstter)"
  IDS_VICE_CPU_JAM                "VICE CPU JAM"
  IDS_EXTEND_TO_40_TRACKS         "Udvid disk-image til 40 spor?"
  IDS_DETACHED_DEVICE_S           "Frakoblet enhed %s"
  IDS_ATTACHED_S_TO_DEVICE_S      "Tilsluttet %s til enhed %s"
  IDS_DETACHED_TAPE               "Frakoblet bnd"
  IDS_HISTORY_RECORDED_UNKNOWN    "Historik optaget med ukendt version"
  IDS_HISTORY_RECORDED_VICE_S     "Historik optaget med VICE-%s"
  IDS_PAUSED                      "pauset"
  IDS_FRAME_NUMBER                "frame #"
  IDS_RESUMED                     "fortsat"
  IDS_REALLY_EXIT                 "Vil du virkelig afslutte?\012\012Alle data i emuleret RAM gr tabt."
  IDS_CANNOT_AUTOSTART_FILE       "Kan ikke autostarte valgt fil"
  IDS_ATTACHED_TAPE_S             "Tilsluttet bnd %s"
  IDS_SETTINGS_SAVED_SUCCESS      "Indstillingerne er gemt."
  IDS_SETTINGS_LOADED_SUCCESS     "Indstillinger indlst med success."
  IDS_ATTACH_DISK_IMAGE           "Tilslut disk-image"
  IDS_ATTACH_TAPE_IMAGE           "Tilslut bnd-image"
  IDS_AUTOSTART_IMAGE             "Autostart disk-/bnd-image"
  IDS_INVALID_CARTRIDGE           "Ugyldigt cartridge"
  IDS_BAD_CARTRIDGE_CONFIG        "Ugyldig cartridgekonfiguration i brugergrnseflade!"
  IDS_INVALID_CARTRIDGE_IMAGE     "Ugyldigt cartridge-image"
  IDS_LOG_CONSOLE_OUTPUT_IMAGE    "Log konsol uddata image"
  IDS_LOG_FILES_TYPE              "VICE konsolloggfiler (*.dbg)"
  IDS_CANNOT_WRITE_LOGFILE_S      "Kan ikke skrive logfil \042%s\042."
  IDS_LOAD_FLIP_LIST_FILE         "Indls bladrelistefil"
  IDS_CANNOT_READ_FLIP_LIST       "Kunne ikke lse bladrelistefil"
  IDS_SAVE_FLIP_LIST_FILE         "Gem bladrelistefil"
  IDS_CANNOT_WRITE_FLIP_LIST      "Kunne ikke skrive bladrelistefil"
  IDS_SELECT_KEYMAP_FILE          "Vlg tastelayout"
  IDS_SAVE_KEYMAP_FILE            "Gem tastelayout"
  IDS_CANNOT_WRITE_KEYMAP_FILE    "Kunne ikke gemme tastelayour"
  IDS_SAVE_CONFIG_FILE            "Gem indstillinger"
  IDS_LOAD_CONFIG_FILE            "Indls indstillinger"
  IDS_MAPPING                     "Mapning"
  IDS_KEYBOARD_SETTINGS           "Tastaturindstillinger"
  IDS_ATTACH                      "&Tilslut"
  IDS_PLEASE_ENTER_A_FILENAME     "Angiv filnavn."
  IDS_OVERWRITE_EXISTING_IMAGE    "Overskriv eksisterende image?"
  IDS_CANNOT_CREATE_IMAGE         "Kunne ikke oprette image"
  IDS_COMMAND_LINE_OPTIONS        "Kommandolinjeparametre"
  IDS_COMMAND_OPTIONS_AVAIL       "Hvilke kommandolinjeparametre er tilgngelige?"
  IDS_NO_DRIVER_SELECT_SUPPORT    "Ingen driver valgt, eller valgt driver ikke understttet"
  IDS_CANT_WRITE_SCREENSHOT_S     "Kunne ikke gemme screenshot \042%s\042."
  IDS_AUTOSTART_DISK_IMAGE        "Autostart disk-image"
  IDS_SELECT_FS_DIRECTORY         "Angiv katalog"
  IDS_PRINTER_USERPORT            "Printer brugerport"
  IDS_PRINTER_4                   "Printer 4"
  IDS_PRINTER_5                   "Printer 5"
  IDS_DRIVE_8                     "Drev 8"
  IDS_DRIVE_9                     "Drev 9"
  IDS_DRIVE_10                    "Drev 10"
  IDS_DRIVE_11                    "Drev 11"
  IDS_PERIPHERAL_SETTINGS         "Indstillinger for eksterne enheder"
  IDS_CANT_WRITE_SNAPSHOT_FILE    "Kunne ikke skrive snapshot fil."
  IDS_CANNOT_READ_SNAPSHOT_IMG    "Kunne ikke indlse snapshot fil"
  IDS_LOAD_S_ROM_IMAGE            "Indls %s-ROM-fil"
  IDS_SELECT_ROMSET_ARCHIVE       "Vlg ROM-set arkiv"
  IDS_CANNOT_LOAD_ROMSET_ARCH     "Kunne ikke indlse ROM-set arkiv!"
  IDS_CANNOT_SAVE_ROMSET_ARCH     "Kunne ikke gemme ROM-set arkiv!"
  IDS_CANNOT_LOAD_ROMSET_FILE     "Kunne ikke indlse ROM-set fil!"
  IDS_CANNOT_SAVE_ROMSET_FILE     "Kunne ikke gemme ROM-set fil!"
  IDS_SELECT_ROMSET_FILE          "Vlg ROM-set fil"
  IDS_ROMSET                      "ROM-set"
  IDS_COMPUTER                    "Computer"
  IDS_DRIVE                       "Drev"
  IDS_ROM_SETTINGS                "ROM-indstillinger"
  IDS_SAVE_SNAPSHOT_IMAGE         "Gem snapshot"
  IDS_CANNOT_WRITE_SNAPSHOT_S     "Kunne ikke gemme snapshot \042%s\042."
  IDS_LOAD_SNAPSHOT_IMAGE         "Indls snapshot"
  IDS_COULD_NOT_LOAD_PALETTE      "Kunne ikke indlse palettefil."
  IDS_LOAD_VICE_PALETTE_FILE      "Indls VICE-palette"
  IDS_FULLSCREEN                  "Fuldskrm/DirectX"
  IDS_COLORS                      "Farver"
  IDS_NEW_PAL                     "Ny PAL-emulering"
  IDS_VIDEO_SETTINGS              "Grafikindstillinger"
  IDS_FILE_SYSTEM                 "Filsystem"
#ifdef HAVE_OPENCBM
  IDS_REAL_IEC_DEVICE             "gte IEC-enhed"
#endif
  IDS_RS232_DEVICE_I              "RS232-enhed %i"
  IDS_ATTACH_CRT_CART_IMAGE       "Tilslut CRT-cartridge image"
  IDS_ATTACH_RAW_8KB_CART_IMAGE   "Tilslut rt 8KB-cartridge image"
  IDS_ATTACH_RAW_16KB_CART_IMG    "Tilslut rt 16KB-cartridge image"
  IDS_ATTACH_AR_CART_IMAGE        "Tilslut Action Replay-cartridge image"
  IDS_ATTACH_AR3_CART_IMAGE       "Tilslut Action Replay III-cartridge image"
  IDS_ATTACH_AR4_CART_IMAGE       "Tilslut Action Replay 4-cartridge image"
  IDS_ATTACH_STARDOS_CART_IMAGE   "Tilslut StarDOS-cartridge image"
  IDS_ATTACH_ATOMIC_P_CART_IMG    "Tilslut Atomic Power-cartridge image"
  IDS_ATTACH_EPYX_FL_CART_IMG     "Tilslut Epyx fastload-cartridge image"
  IDS_ATTACH_IEEE488_CART_IMG     "Tilslut IEEE-interface cartridge image"
  IDS_ATTACH_RETRO_R_CART_IMG     "Tilslut Retro Replay-cartridge image"
  IDS_ATTACH_IDE64_CART_IMAGE     "Tilslut IDE64-interface cartridge image"
  IDS_ATTACH_SS4_CART_IMAGE       "Tilslut Super Snapshot 4-cartridge image"
  IDS_ATTACH_SS5_CART_IMAGE       "Tilslut Super Snapshot 5-cartridge image"
  IDS_ATTACH_STB_CART_IMAGE       "Tilslut Strucured Basic-cartridge image"
  IDS_MODEL                       "Model"
  IDS_DRIVE_SETTINGS              "Diskettedrevindstillinger"
  IDS_SELECT_START_SNAP_EVENT     "Vlg start-snapshot for hndelseshistorik"
  IDS_SELECT_END_SNAP_EVENT       "Vlg slut-snapshot for hndelseshistorik"
#ifdef UNSTABLE
  IDS_VERSION_S_UNSTABLE          "Version %s *USTABIL* (%s)"
#else
  IDS_VERSION_S                   "Version %s (%s)"
#endif
  IDS_VICE_CONTRIBUTORS           "VICE bidragsydere"
  IDS_WHO_MADE_WHAT               "Hvem har lavet hvad?"
  IDS_LICENSE                     "Licens"
  IDS_NO_WARRANTY                 "Ingen garanti!"
  IDS_VICE_WITHOUT_WARRANTY       "VICE distribueres UDEN NOGEN SOM HELST GARANTI!"
  IDS_PRESS_KEY_NORTHWEST         "Tryk tast for nordvest"
  IDS_PRESS_KEY_NORTH             "Tryk tast for nord"
  IDS_PRESS_KEY_NORTHEAST         "Tryk tast for nordst"
  IDS_PRESS_KEY_EAST              "Tryk tast for st"
  IDS_PRESS_KEY_SOUTHEAST         "Tryk tast for sydst"
  IDS_PRESS_KEY_SOUTH             "Tryk tast for syd"
  IDS_PRESS_KEY_SOUTHWEST         "Tryk tast for sydvest"
  IDS_PRESS_KEY_WEST              "Tryk tast for vest"
  IDS_PRESS_KEY_FIRE              "Tryk tast for skyd"
  IDS_NO_USERPORT_ADAPTER         "No userport joy adapter"
  IDS_CGA_USERPORT_ADAPTER        "CGA userport joy adapter"
  IDS_PET_USERPORT_ADAPTER        "PET userport joy adapter"
  IDS_HUMMER_USERPORT_ADAPTER     "HUMMER userport joy adapter"
  IDS_OEM_USERPORT_ADAPTER        "OEM userport joy adapter"
  IDS_HIT_USERPORT_ADAPTER        "HIT userport joy adapter"
  IDS_NO_SIDCART_JOY              "Disable SIDcart joy"
  IDS_SIDCART_JOY                 "Enable SIDcart joy"
  IDS_NUMPAD_AND_RCTRL            "Numerisk tastatur + hjre Ctrl"
  IDS_KEYSET_A                    "Tastest A"
  IDS_KEYSET_B                    "Tastest B"
  IDS_ALL_BUTTONS_AS_FIRE         "Alle knapper bruges som skydeknap"
  IDS_NUMERIC_SEE_ABOVE           "numerisk (se ovenfor)"
  IDS_NO_BUTTON_NO_AUTOFIRE       "Ingen knap - Autofire inaktiv"
  IDS_ALL_FILES_FILTER            "Alle filer (*.*)"
  IDS_PALETTE_FILES_FILTER        "VICE-palettefiler (*.vpl)"
  IDS_SNAPSHOT_FILES_FILTER       "VICE-snapshot filer (*.vsf)"
  IDS_CBM_IMAGE_FILES_FILTER      "CBM-filer (*.d64;*.d71;*.d80;*.d81;*.d82;*.g64;*.g41;*.x64;*.t64;*.tap;*.prg;*.p00)"
  IDS_DISK_IMAGE_FILES_FILTER     "Disk-image filer (*.d64;*.d71;*.d80;*.d81;*.d82;*.g64;*.g41;*.x64)"
  IDS_TAPE_IMAGE_FILES_FILTER     "Bnd-image filer (*.t64;*.tap)"
  IDS_ZIPPED_FILES_FILTER         "Pakkede filer (*.zip;*.bz2;*.gz;*.d6z;*.d7z;*.d8z;*.g6z;*.g4z;*.x6z)"
  IDS_CRT_FILES_FILTER            "CRT cartridge-image filer (*.crt)"
  IDS_RAW_CART_FILES_FILTER       "R cartridge-image filer (*.bin)"
  IDS_FLIP_LIST_FILES_FILTER      "VICE-bladrelistefiler (*.vfl)"
  IDS_ROMSET_FILES_FILTER         "VICE-ROM-set filer (*.vrs)"
  IDS_ROMSET_ARCHIVES_FILTER      "VICE-ROM-set arkiver (*.vra)"
  IDS_KEYMAP_FILES_FILTER         "VICE-tastest filer (*.vkm)"
  IDS_PRGP00_FILES_FILTER         "Commodoreemulatorfiler (*.prg;*.p00)"
  IDS_FLEXIBLE                    "Fleksibel"
  IDS_ADJUSTING                   "Tilpassende"
  IDS_EXACT                       "Njagtig"
  IDS_SOUND_DRIVER_DIRECTX        "Lyd-driver: DirectX"
  IDS_SOUND_DRIVER_WMM            "Lyd-driver: WMM"
  IDS_MEDIA_FILES_FILTER          "Mediefiler (*.bmp;*.gif;*.iff;*.jpg;*.pcx;*.png;*.ppm;*.wav;*.mp3;*.avi;*.mpg)"
  IDS_SPACE_KB                    " kB"
  IDS_CONFIGURE_KEYSET_A          "Konfigurr tastest A"
  IDS_CONFIGURE_KEYSET_B          "Konfigurr tastest B"
  IDS_SAVE_MEDIA_IMAGE            "Gem medie-image"
  IDS_S_AT_D_SPEED                "%s med %d%% hastighed, %d b/s%s"
  IDS_TAPE                        "Bnd:"
  IDS_JOYSTICK_C                  "Joystick:"
  IDS_RECORDING                   "Optager\n%02d:%02d"
  IDS_PLAYBACK                    "Afspiller\n%02d:%02d (%02d:%02d)"
  IDS_UNKNOWN                     "Ukendt"
  IDS_P_NUMBER                    "<nummer>"
  IDS_SET_INPUT_JOYSTICK_1        "Vlg inddataenhed for joystick 1"
  IDS_SET_INPUT_JOYSTICK_2        "Vlg inddataenhed for joystick 2"
  IDS_SET_INPUT_EXTRA_JOYSTICK_1  "Set input device for extra joystick #1"
  IDS_SET_INPUT_EXTRA_JOYSTICK_2  "Set input device for extra joystick #2"
  IDS_SAVE_SETTINGS_ON_EXIT       "Gem indstillinger nr programmet afsluttes"
  IDS_NO_SAVE_SETTINGS_ON_EXIT    "Gem aldrig indstillinger nr programmet afsluttes"
  IDS_CONFIRM_QUIT_VICE           "Bekrft programafslutning"
  IDS_NO_CONFIRM_QUIT_VICE        "Bekrft ikke programafslutning"
  IDS_USE_ALL_CPU_SMP             "Brug alle CPU'er p SMP-systemer"
  IDS_USE_FIRST_CPU_SMP           "Brug kun frste CPU p SMP-systemer"
  IDS_START_VICE_FULLSCREEN_MODE  "Start VICE i fullscreen-tilstand"
  IDS_DISABLE_DX9                 "Disable DirectX9 video driver"
#ifdef SYS_SIGLIST_DECLARED
  IDS_RECEIVED_SIGNAL_D_S         "Uventet fejl. Modtog signal %d (%s)."
#else
  IDS_RECEIVED_SIGNAL_D           "Uventet fejl. Modtog signal %d."
#endif
#ifdef HAVE_NETWORK
  IDS_IDLE                        "Venter"
  IDS_SERVER_LISTENING            "Server lytter"
  IDS_CONNECTED_SERVER            "Tilsluttet server"
  IDS_CONNECTED_CLIENT            "Tilsluttet klient"
  IDS_INVALID_PORT_NUMBER         "Ugyldigt portnummer"
  IDS_ERROR_STARTING_SERVER       "Fejl under start af serveren."
  IDS_ERROR_CONNECTING_CLIENT     "Fejl under tilslutning af klienten."
#endif
  IDS_SOUND_RECORDING_STARTED     "Lydoptagelse startet..."
  IDS_SOUND_RECORDING_STOPPED     "Lydoptagelse stoppet..."
  IDS_OK                          "OK"
  IDS_CANCEL                      "Annullr"
  IDS_NONE                        "Ingen"
  IDS_BROWSE                      "&Gennemse..."
  IDS_SPECIFY_MIDI_IN             "Angiv enhed for MIDI-ind"
  IDS_SPECIFY_MIDI_OUT            "Angiv enhed for MIDI-ud"
  IDS_ERROR_SAVING_EASYFLASH_CRT  "Error saving EasyFlash crt file"
  IDS_DATASETTE_CAPTION           "Datasetteindstillinger"
  IDS_DATASETTE_RESET_WITH_CPU    "&Reset Datasette ved CPU-reset"
  IDS_DATASETTE_MOTOR_GROUP       "Datasettehastighed under lsning"
  IDS_DATASETTE_DELAY_TRIGGER     "klok ekstra &forsinkelse per puls"
  IDS_DATASETTE_DELAY_AT_ZERO     "klok forsinkelse ved &nulvrdier"
  IDS_TOGGLE_USEIECDEVICE         "&Anvend IEC-enhed"
  IDS_SELECTDISK                  "Disk&image"
  IDS_SELECTDIR                   "&Katalog"
#ifdef HAVE_OPENCBM
  IDS_SELECTREAL                  "&gte IEC-enhed"
#endif
  IDS_SELECTNONE                  "&Ingen"
  IDS_AUTOSTART                   "Start &Automatisk"
  IDS_BROWSEDIR                   "&Gennemse..."
  IDS_TOGGLE_ATTACH_READONLY      "Tilslut skrivebeskyttet"
  IDS_TOGGLE_READP00              "&Ls P00-filer"
  IDS_TOGGLE_WRITEP00             "&Skriv P00-filer"
  IDS_TOGGLE_HIDENONP00           "&Gem ikke-P00-filer"
  IDS_JOYSTICK_CAPTION            "Joystickindstillinger"
  IDS_JOYSTICK_IN_PORT_1          "Joystick i port &1"
  IDS_SELECT_FIRE_BUTTON          "Vlg skydeknap"
  IDS_AUTO_FIRE_BUTTON_SETTINGS   "Autofireindstillinger"
  IDS_AUTOFIRE_SPEED              "Autofire&hastighed (1..32)"
  IDS_JOYSTICK_IN_PORT_2          "Joystick i port &2"
  IDS_JOY_CONFIG_A                "Tastest &A"
  IDS_JOY_CONFIG_B                "Tastest &B"
  IDS_JOY_CALIBRATE               "&Kalibrr Joystick(s)"
  IDS_EXTRA_JOYSTICK_CAPTION      "Extra joystick settings"
  IDS_JOYSTICK_IN_EXTRA_PORT_1    "Joystick in extra port #&1"
  IDS_JOYSTICK_IN_EXTRA_PORT_2    "Joystick in extra port #&2"
  IDS_KEYSET_SW                   "S&ydvest"
  IDS_KEYSET_S                    "&Syd"
  IDS_KEYSET_SE                   "Sy&dst"
  IDS_KEYSET_W                    "&Vest"
  IDS_KEYSET_E                    "&st"
  IDS_KEYSET_NW                   "No&rdvest"
  IDS_KEYSET_N                    "&Nord"
  IDS_KEYSET_NE                   "N&ordst"
  IDS_KEYSET_FIRE                 "Skyde&knap"
  IDS_SOUND_CAPTION               "Indstillinger for lydenheder"
  IDS_SOUND_DIRECTX               "DirectX-driver"
  IDS_SOUND_WMM                   "WMM-driver"
  IDS_SOUND_SAMPLE_FREQUENCY      "Sampling&frekvens:"
  IDS_SOUND_BUFFER_SIZE           "Lydbuffer&strrelse:"
  IDS_SOUND_FRAGMENT_SIZE_LABEL   "Sound Fragment Size :"
  IDS_SOUND_FRAGMENT_SIZE_SMALL   "Small"
  IDS_SOUND_FRAGMENT_SIZE_MEDIUM  "Medium"
  IDS_SOUND_FRAGMENT_SIZE_LARGE   "Large"
  IDS_SOUND_SYNCH_METHOD          "Synkroniserings&metode:"
  IDS_TOGGLE_SNAPSHOT_SAVE_DISKS  "Gem tilsluttede &disk-images"
  IDS_TOGGLE_SNAPSHOT_SAVE_ROMS   "Gem tilsluttede &ROM-images"
  IDS_FULLSCREEN_DRIVER           "Driver:"
  IDS_FULLSCREEN_DRVR_BITDEPTH    "Bitdybde:"
  IDS_FULLSCREEN_DRVR_RESOLUTION  "Oplsning:"
  IDS_FULLSCREEN_DRVR_REFRESHRATE "Opdateringsfrekvens:"
  IDS_TOGGLE_VIDEO_VBLANK_SYNC    "VBLANK-synkronisering"
  IDS_TOGGLE_VIDEO_DX_PRIMARY     "Rendr til DXs primre overflade"
  IDS_TOGGLE_KEEP_ASPECT_RATIO    "Keep aspect ratio (0,5..2)"
  IDS_COLORS_SATURATION           "Mttethed (0..2)"
  IDS_COLORS_CONTRAST             "Kontrast (0..2)"
  IDS_COLORS_BRIGHTNESS           "Lysstyrke (0..2)"
  IDS_NEW_PAL_TINT                "Farvetone (0..2)"
  IDS_NEW_PAL_ODD_LINES_PHASE     "Fase for ulige linjer (0..2)"
  IDS_NEW_PAL_ODD_LINES_OFFSET    "Offset for ulige linjer (0..2)"
  IDS_VIDEO_GAMMA                 "Gamma (0..2)"
  IDS_VIDEO_PHASE                 "Fase (0..2)"
  IDS_VIDEO_PAL_SHADE             "Skanlinjeskygge (0..1)"
  IDS_VIDEO_PAL_BLUR              "PAL-udtvring (0..1)"
  IDS_TOGGLE_VIDEO_EXTPALETTE     "Ekstern palette:"
  IDS_RAM_CAPTION                 "RAM-indstillinger"
  IDS_RAM_INIT_AT_POWERUP         "Initialisering ved power-up"
  IDS_RAM_VALUE_FIRST_BYTE        "Vrdi p frste byte"
  IDS_RAM_LENGTH_CONSTANT_VALUES  "Lngde af konstant vrdi"
  IDS_RAM_LENGTH_CONSTANT_PATTERN "Lngde af konstant mnster"
  IDS_PRINTER_EMULATION           "Printeremulering"
  IDS_PRINTER_FORMFEED            "Send sideskift"
  IDS_FILESYSTEM_PRINTER          "Filsystemprinter"
  IDS_PRINTER_DRVR                "Printerdriver"
  IDS_OUTPUT                      "Uddata"
  IDS_OUTPUT_TO_FILE              "Uddata til fil #"
  IDS_OUTPUT_FILE1_NAME           "Navn p uddatafil #1"
  IDS_OUTPUT_FILE2_NAME           "Navn p uddatafil #2"
  IDS_OUTPUT_FILE3_NAME           "Navn p uddatafil #3"
  IDS_ROMSET_SELECT_ARCHIVE       "ROM-set arkiv"
  IDS_ROMSET_ARCHIVE_LOAD         "Indls arkiv"
  IDS_ROMSET_ARCHIVE_SAVE         "Gem arkiv"
  IDS_ROMSET_CONFIGURATION        "&Indstillinger"
  IDS_ROMSET_ARCHIVE_APPLY        "Anvend"
  IDS_ROMSET_ARCHIVE_NEW          "Ny"
  IDS_ROMSET_ARCHIVE_DELETE       "Slet"
  IDS_ROMSET_SELECT_FILE          "ROM-set fil"
  IDS_ROMSET_FILE_LOAD            "Indls ROM-set"
  IDS_ROMSET_FILE_SAVE            "Gem ROM-set"
  IDS_CUSTOM_SPEED_CAPTION        "Egen hastighet"
  IDS_ENTER_CUSTOM_SPEED          "Angiv hastighed [%]"
  IDS_NEW_CONFIGURATION           "Ny indstillingsfil"
  IDS_ENTER_CONFIGURATION_NAME    "Angiv konfigurationsnavn"
  IDS_RS232_CAPTION               "RS232-indstillinger"
  IDS_RS232_DEV_1                 "RS232-enhed 1"
  IDS_RS232_DEV_2                 "RS232-enhed 2"
  IDS_RS232_DEV_3                 "RS232-enhed 3"
  IDS_RS232_DEV_4                 "RS232-enhed 4"
  IDS_NETWORK_CAPTION             "Ntvrksspilindstillinger"
  IDS_CURRENT_MODE                "Nuvrende tilstand"
  IDS_SERVER_BIND                 "Server Bind"
  IDS_TCP_PORT                    "TCP-Port"
  IDS_NETWORK_SERVER              "Start server"
  IDS_NETWORK_CLIENT              "Tilslut til"
  IDS_NETWORK_DISCONNECT          "Afbryd forbindelse"
  IDS_CONTROL                     "Styring"
  IDS_SERVER                      "Server"
  IDS_CLIENT                      "Klient"
  IDS_KEYBOARD                    "Tastatur"
  IDS_JOYSTICK_1                  "Joystick 1"
  IDS_JOYSTICK_2                  "Joystick 2"
  IDS_DEVICES                     "Enheder"
  IDS_SETTINGS                    "Indstillinger"
  IDS_TOGGLE_CONSOLE_APPEND       "&Tilfj log i eksisterende fil"
  IDS_IMAGE_CONTENTS              "Indhold i image"
  IDS_NEW_IMAGE                   "Nyt image"
  IDS_NAME                        "Navn"
  IDS_ID                          "ID"
  IDS_TYPE                        "Type"
  IDS_BLANK_IMAGE                 "Opret image"
  IDS_NEW_TAP_IMAGE               "Nyt TAP-image"
  IDS_SAVE                        "Gem"
  IDS_SELECT_DRIVER               "Vlg driver"
  IDS_FFMPEG_SETTINGS             "FFMPEG-indstillinger"
  IDS_FORMAT                      "Format"
  IDS_AUDIO_CODEC                 "Lyd kodeks"
  IDS_BITRATE                     "bitrate"
  IDS_VIDEO_CODEC                 "Video kodeks"
  IDS_SOUND_RECORD_CAPTION        "Sound record settings"
  IDS_SOUND_RECORD_FORMAT_LABEL   "Format for lydoptagelse"
  IDS_SOUND_RECORD_FILE_LABEL     "Fil for lydoptagelse"
  IDS_KERNAL                      "Kernal"
  IDS_BASIC                       "Basic"
  IDS_CHARACTER                   "Tegngenerator"
  IDS_COMPUTER_RESOURCES_CAPTION  "Computerressourcer"
  IDS_COMPUTER_RESOURCES          "Computerressourcer gemt i ROM-set"
  IDS_DRIVE_RESOURCES_CAPTION     "Drev-ressourcer"
  IDS_DRIVE_RESOURCES             "Drev-ressourcer gemt i ROM-set"
  IDS_SYMBOLIC                    "&Symbolsk"
  IDS_POSITIONAL                  "&Positionsbestemt"
  IDS_DUMP_KEYSET                 "Gem tastest"
  IDS_DUMP_SHORTCUTS              "Gem genveje"
  IDS_SYMBOLIC_US                 "&Symbolsk US"
  IDS_SYMBOLIC_DE                 "&Symbolsk DE"
  IDS_A_MEMORY                    "&Hukommelse"
  IDS_GR_SYM                      "&Gr Sym."
  IDS_GR_POS                      "G&r Pos."
  IDS_UK_SYM                      "&UK Sym."
  IDS_UK_POS                      "U&K Pos."
  IDS_DE_SYM                      "&DE Sym."
  IDS_DE_POS                      "D&E Pos."
  IDS_DRIVE_TYPE                  "&Enhedstype"
  IDS_40_TRACK_HANDLING           "Hndtering af 40 &spor"
  IDS_SELECT_DRIVE_EXTEND_NEVER   "Udvid aldrig"
  IDS_SELECT_DRIVE_EXTEND_ASK     "Sprg ved udviddelse"
  IDS_SELECT_DRIVE_EXTEND_ACCESS  "Udvid ved tilgang"
  IDS_IDLE_METHOD                 "Pa&usemetode"
  IDS_SELECT_DRIVE_IDLE_TRAP_IDLE "Fang inaktive"
  IDS_SELECT_DRIVE_IDLE_SKIP_CYC  "Spring over cykler"
  IDS_TOGGLE_DRIVE_PARALLEL_CABLE "&Parallellkabel"
  IDS_DRIVE_EXPANSION             "Enheds&udviddelse"
  IDS_TOGGLE_DRIVE_EXPANSION_2000 "$2000-$3FFF &RAM"
  IDS_TOGGLE_DRIVE_EXPANSION_4000 "$&4000-$5FFF RAM"
  IDS_TOGGLE_DRIVE_EXPANSION_6000 "$&6000-$7FFF RAM"
  IDS_TOGGLE_DRIVE_EXPANSION_8000 "$8000-$9FFF RA&M"
  IDS_TOGGLE_DRIVE_EXPANSION_A000 "$&A000-$BFFF RAM"
  IDS_PLUS4_VIC20_MEMORY          "&Hukommelse"
  IDS_SID_GENGROUP1               "SID Engine/Model"
  IDS_SID_FILTERS                 "SID-filter"
  IDS_MP_FILE                     "&Fil"
  IDS_MP_ATTACH_DISK_IMAGE        "Tilslut &Disk-image"
  IDS_MP_DETACH_DISK_IMAGE        "&Frakobl disk-image"
  IDS_MP_FLIP_LIST                "&Bladreliste"
  IDS_MP_DATASETTE_CONTROL        "Datasette kontro&l"
  IDS_MP_ATTACH_CARTRIDGE_IMAGE   "Tilslut &cartridge-image..."
  IDS_MP_EXPERT_CARTRIDGE         "Expert Cartridge"
  IDS_MP_RESET                    "&Reset"
  IDS_MP_DEBUG                    "&Debug"
#ifdef DEBUG
  IDS_MP_MODE                     "&Tilstand"
#endif
  IDS_MP_EDIT                     "Redigr"
  IDS_MP_SNAPSHOT                 "Sna&pshot"
  IDS_MP_RECORDING_START_MODE     "Start-tilstand for optagelse"
  IDS_MP_OPTIONS                  "&Indstillinger"
  IDS_MP_REFRESH_RATE             "&Opdateringsfrekvens"
  IDS_MP_MAXIMUM_SPEED            "&Maksimal hastighed"
  IDS_MP_VIDEO_STANDARD           "&TV-standard"
  IDS_MP_DRIVE_SYNC_FACTOR        "S&ynkfaktor for diskettedrev"
  IDS_MP_SETTINGS                 "&Indstillinger"
  IDS_MP_CARTRIDGE_IO_SETTINGS    "&Cartridge/IO-indstillinger"
  IDS_MP_LANGUAGE                 "&Sprog"
  IDS_MP_HELP                     "&Hjlp"
  IDS_MP_VIEW                     "&Vis"
  IDS_MP_WINDOW                   "Vi&ndue"
  IDS_MI_EXIT                     "Af&slut"
  IDS_MI_ABOUT                    "&Om VICE..."
  IDS_MI_PAUSE                    "&Pause"
  IDS_MI_EDIT_COPY                "&Kopir"
  IDS_MI_EDIT_PASTE               "&Indst"
  IDS_MI_AUTOSTART                "&Autostart disk-/bnd-image..."
  IDS_MI_RESET_HARD               "&Hrd"
  IDS_MI_RESET_SOFT               "&Bld"
  IDS_MI_DRIVE8                   "Enhed &8"
  IDS_MI_DRIVE9                   "Enhed &9"
  IDS_MI_DRIVE10                  "Enhed 1&0"
  IDS_MI_DRIVE11                  "Enhed 1&1"
  IDS_MI_ATTACH_TAPE              "&Tilslut et bnd-image..."
  IDS_MI_DETACH_TAPE              "F&rakobl bnd-image"
  IDS_MI_DETACH_ALL               "&Alle"
  IDS_MI_TOGGLE_SOUND             "Aktivr l&ydemulering"
  IDS_MI_TOGGLE_DOUBLESIZE        "&Dobbelt strrelse"
  IDS_MI_TOGGLE_DOUBLESCAN        "Do&bbelt-skan"
  IDS_MI_DRIVE_TRUE_EMULATION     "g&te drev-emulering"
  IDS_MI_AUTOSTART_HANDLE_TDE     "Brug TDE ved autostart"
  IDS_MI_TOGGLE_VIDEOCACHE        "Grafik&cache"
  IDS_MI_DRIVE_SETTINGS           "&Diskettedrevsindstillinger..."
  IDS_MI_CART_ATTACH_CRT          "&CRT-image..."
  IDS_MI_CART_ATTACH_8KB          "Almindeligt &8KB-image..."
  IDS_MI_CART_ATTACH_16KB         "Almindeligt &16KB-image..."
  IDS_MI_CART_ATTACH_AR           "&Action Replay-image..."
  IDS_MI_CART_ATTACH_AR3          "&Action Replay 3-image..."
  IDS_MI_CART_ATTACH_AR4          "&Action Replay 4-image..."
  IDS_MI_CART_ATTACH_STARDOS      "&StarDOS-image..."
  IDS_MI_CART_ATTACH_AT           "Atomic &Power-image..."
  IDS_MI_CART_ATTACH_EPYX         "&Epyx FastLoad-image..."
  IDS_MI_CART_ATTACH_IEEE488      "&IEEE488-interface image..."
  IDS_MI_CART_ATTACH_RR           "&Retro Replay-image..."
  IDS_MI_CART_ATTACH_IDE64        "IDE&64-interface image..."
  IDS_MI_CART_ATTACH_SS4          "Super Snapshot &4-image..."
  IDS_MI_CART_ATTACH_SS5          "Super Snapshot &5-image..."
  IDS_MI_CART_ATTACH_STB          "Structured &BASIC-image..."
  IDS_MI_FLIP_ADD                 "&Tilfj nuvrende image"
  IDS_MI_FLIP_REMOVE              "&Fjern nuvrende image"
  IDS_MI_FLIP_NEXT                "Tilslut &nste image"
  IDS_MI_FLIP_PREVIOUS            "Tilslut f&orrige image"
  IDS_MI_FLIP_LOAD                "Ind&ls bladreliste"
  IDS_MI_FLIP_SAVE                "Gem Bladreli&ste"
  IDS_MI_DATASETTE_STOP           "S&top"
  IDS_MI_DATASETTE_START          "&Start"
  IDS_MI_DATASETTE_FORWARD        "Spol &frem"
  IDS_MI_DATASETTE_REWIND         "Spol Til&bage"
  IDS_MI_DATASETTE_RECORD         "&Optag"
  IDS_MI_DATASETTE_RESET          "R&eset"
  IDS_MI_DATASETTE_RESET_COUNTER  "Nulstil T&ller"
  IDS_MI_CART_ENABLE_EXPERT       "Aktivr"
  IDS_MI_CART_MODE_OFF            "Slukket"
  IDS_MI_CART_MODE_ON             "Tndt"
  IDS_MI_CART_SET_DEFAULT         "Vlg cartridge som stan&dard"
  IDS_MI_TOGGLE_CART_RESET        "Reset &ved cartridge-skift"
  IDS_MI_CART_DETACH              "Frakobl cartridge-&image"
  IDS_MI_CART_FREEZE              "Cartridge &frys-funktion"
  IDS_MI_MONITOR                  "&Monitor"
#ifdef DEBUG
  IDS_MI_DEBUG_MODE_NORMAL        "&Normal"
  IDS_MI_DEBUG_MODE_SMALL         "&Lille"
  IDS_MI_DEBUG_MODE_HISTORY       "&Historik"
  IDS_MI_DEBUG_MODE_AUTOPLAY      "Automatisk afspilning af &Historik"
  IDS_MI_TOGGLE_MAINCPU_TRACE     "Hoved-&CPU trace"
  IDS_MI_TOGGLE_DRIVE0CPU_TRACE   "Enhed &0 CPU trace"
  IDS_MI_TOGGLE_DRIVE1CPU_TRACE   "Enhed &1 CPU trace"
#endif
  IDS_MI_SNAPSHOT_LOAD            "&Indls snapshot..."
  IDS_MI_SNAPSHOT_SAVE            "Gem Sna&pshot..."
  IDS_MI_LOADQUICK                "Hurtigind&ls snapshot"
  IDS_MI_SAVEQUICK                "Hurtig-gem &snapshot"
  IDS_MI_EVENT_TOGGLE_RECORD      "Start/stop optagelse af &hndelser"
  IDS_MI_EVENT_TOGGLE_PLAYBACK    "Start/stop afspilning af &hndelser"
  IDS_MI_EVENT_SETMILESTONE       "Angiv optagelses-bogmrke"
  IDS_MI_EVENT_RESETMILESTONE     "G til bogmrke"
  IDS_MI_EVENT_START_MODE_SAVE    "Gem nyt &snapshot"
  IDS_MI_EVENT_START_MODE_LOAD    "Ind&ls eksisterende snapshot"
  IDS_MI_EVENT_START_MODE_RESET   "Start med &reset"
  IDS_MI_EVENT_START_MODE_PLAYBCK "Overskriv eksisterende o&ptagelse"
  IDS_MI_EVENT_DIRECTORY          "Vlg historikfiler/-katalog"
  IDS_MI_MEDIAFILE                "Gem/stop mediefil..."
  IDS_MI_SOUND_RECORD_START       "Optag lyd..."
  IDS_MI_SOUND_RECORD_STOP        "Stop lydoptagelse"
  IDS_MI_REFRESH_RATE_AUTO        "&Auto"
  IDS_MI_MAXIMUM_SPEED_NO_LIMIT   "&Ubegrnset"
  IDS_MI_MAXIMUM_SPEED_CUSTOM     "&Egen"
  IDS_MI_TOGGLE_WARP_MODE         "&Warp-tilstand"
  IDS_MI_TOGGLE_ALWAYSONTOP       "Altid verst"
  IDS_MI_TOGGLE_FASTPAL           "PAL-emulering"
  IDS_MI_TOGGLE_SCALE2X           "Scale2x"
  IDS_MI_SWAP_JOYSTICK            "Byt om p &joystickportene"
  IDS_MI_SWAP_EXTRA_JOYSTICK      "Swap &Userport joysticks"
  IDS_MI_ALLOW_JOY_OPPOSITE       "Allow opposite joystick directions"
  IDS_MI_JOYKEYS_TOGGLE           "Aktivr joystick via keyboard"
  IDS_MI_TOGGLE_VIRTUAL_DEVICES   "&Virtuelle enheds-traps"
  IDS_MI_TOGGLE_EMUID             "Emulator&identificering"
  IDS_MI_MOUSE                    "Fan&g mussehndelser"
  IDS_MI_AUTOSTART_SETTINGS       "&Autostart settings..."
  IDS_MI_VIDEO_SETTINGS           "&Grafikindstillinger..."
  IDS_MI_DEVICEMANAGER            "&Ekstern-enhedsindstillinger..."
  IDS_MI_JOY_SETTINGS             "&Joystick indstillinger..."
  IDS_MI_USERPORT_JOY_SETTINGS    "&Userport joystick settings..."
  IDS_MI_SIDCART_JOY_SETTINGS     "&Sidcart joystick settings..."
  IDS_MI_KEYBOARD_SETTINGS        "&Tastaturindstillinger..."
  IDS_MI_SOUND_SETTINGS           "L&ydindstillinger..."
  IDS_MI_ROM_SETTINGS             "&ROM-indstillinger..."
  IDS_MI_RAM_SETTINGS             "RA&M-indstillinger..."
  IDS_MI_DATASETTE_SETTINGS       "D&atasetteindstillinger..."
  IDS_MI_VICII_SETTINGS           "VIC-II-indstillinger..."
  IDS_MI_MOUSE_SETTINGS           "M&usseindstillinger..."
  IDS_MI_SID_SETTINGS             "S&ID-indstillinger..."
  IDS_MI_RS232_SETTINGS           "RS&232-indstillinger..."
  IDS_MI_REU_SETTINGS             "&REU-indstillinger..."
  IDS_MI_GEORAM_SETTINGS          "&GEORAM-indstillinger..."
  IDS_MI_RAMCART_SETTINGS         "&RAMCART-indstillinger..."
  IDS_MI_DQBB_SETTINGS            "&Double Quick Brown Box indstillinger..."
  IDS_MI_ISEPIC_SETTINGS          "I&sepic-indstillinger..."
  IDS_MI_MMC64_SETTINGS           "&MMC64-indstillinger..."
  IDS_MI_MIDI_SETTINGS            "M&IDI-indstillinger..."
  IDS_MI_DIGIMAX_SETTINGS         "&DIGIMAX-indstillinger..."
  IDS_MI_LIGHTPEN_SETTINGS        "&Lightpen settings..."
  IDS_MI_IDE64_SETTINGS           "&IDE64-indstillinger..."
#ifdef HAVE_TFE
  IDS_MI_TFE_SETTINGS             "&Ethernetindstillinger..."
#endif
  IDS_MI_ACIA_SETTINGS            "&ACIA-indstillinger..."
  IDS_MI_RS232USER_SETTINGS       "RS&232-brugerportsindstillinger..."
  IDS_MI_EASYFLASH_SETTINGS       "EasyFlash settings..."
  IDS_MI_SFX_SE_SETTINGS          "SFX Sound Expander settings..."
  IDS_MI_TOGGLE_SFX_SS            "Enable SFX Sound Sampler"
  IDS_MI_SETTINGS_SAVE_FILE       "Gem indstillinger som"
  IDS_MI_SETTINGS_LOAD_FILE       "Indls indstillinger fra"
  IDS_MI_SETTINGS_SAVE            "Gem nuvrende ind&stillinger"
  IDS_MI_SETTINGS_LOAD            "Ind&ls gemte indstillinger"
  IDS_MI_SETTINGS_DEFAULT         "Gen&dan standardindstillinger"
  IDS_MI_SAVE_SETTINGS_ON_EXIT    "Gem indstillinger nr programmet afs&luttes"
  IDS_MI_CONFIRM_ON_EXIT          "&Bekrft programafslutning"
  IDS_MI_LANG_EN                  "&Engelsk"
  IDS_MI_LANG_DA                  "D&anish"
  IDS_MI_LANG_DE                  "&Tysk"
  IDS_MI_LANG_FR                  "&Fransk"
  IDS_MI_LANG_HU                  "&Ungersk"
  IDS_MI_LANG_IT                  "&Italiensk"
  IDS_MI_LANG_NL                  "&Hollandsk"
  IDS_MI_LANG_PL                  "&Polsk"
  IDS_MI_LANG_SV                  "&Svensk"
  IDS_MI_LANG_TR                  "&Turkish"
  IDS_MI_CMDLINE                  "Kommand&olinjeparametre"
  IDS_MI_CONTRIBUTORS             "&Bidragsydere"
  IDS_MI_LICENSE                  "&Licens"
  IDS_MI_WARRANTY                 "Ingen &garanti"
  IDS_MI_TOGGLE_FULLSCREEN        "Fuldskrm"
  IDS_MI_SIDCART_SETTINGS         "&SID-cartridge indstillinger..."
  IDS_MI_MON_OPEN                 "&bn"
  IDS_MI_MON_SAVE                 "&Gem"
  IDS_MI_MON_PRINT                "&Print"
  IDS_MI_MON_EXIT                 "&Afslut\tAlt+F4"
  IDS_MI_MON_STOP_DEBUG           "&Stop debugging"
  IDS_MI_MON_STOP_EXEC            "Stop E&ksekvering"
  IDS_MI_MON_STEP_INTO            "Step &ind i"
  IDS_MI_MON_STEP_OVER            "Step &over"
  IDS_MI_MON_SKIP_RETURN          "Step til &retur"
  IDS_MI_MON_GOTO_CURSOR          "G til &cursor"
  IDS_MI_MON_EVAL                 "&Evalur udtryk"
  IDS_MI_MON_CURRENT              "&Aktuel instruktion"
  IDS_MI_MON_WND_EVAL             "Evaluerings&vindue"
  IDS_MI_MON_WND_REG              "&Registervindue"
  IDS_MI_MON_WND_MEM              "&Hukommelsesvindue"
  IDS_MI_MON_WND_DIS              "&Disassembleringsvindue"
  IDS_MI_MON_WND_CONSOLE          "&Konsolvindue"
  IDS_MI_MON_COMPUTER             "&Computer"
  IDS_MI_MON_DRIVE8               "Enhed &8"
  IDS_MI_MON_DRIVE9               "Enhed &9"
  IDS_MI_MON_CASCADE              "&Kaskade"
  IDS_MI_MON_TILE_VERT            "&Side om side"
  IDS_MI_MON_TILE_HORIZ           "&Over og under"
  IDS_MI_MON_ARRANGE_ICONS        "&Arrangr ikoner"
END



STRINGTABLE
LANGUAGE LANG_GERMAN, SUBLANG_NEUTRAL
BEGIN
  IDS_VICE_ERROR                  "VICE Fehler!"
  IDS_VICE_INFORMATION            "VICE Information"
  IDS_VICE_QUESTION               "VICE Frage"
  IDS_FFMPEG_DLL_MISMATCH         "Deube ffmpeg dll Version passt leider nicht."
  IDS_DIRECTDRAW_ERROR            "DirectDraw error: Code:%8x Error:%s"
  IDS_CANNOT_SAVE_SETTINGS        "Fehler beim Speichern der Einstellungen."
  IDS_CANNOT_LOAD_SETTINGS        "Fehler beim Laden der Einstellungen."
  IDS_DEFAULT_SETTINGS_RESTORED   "Standard wiederhergestellt"
  IDS_CANNOT_ATTACH_FILE          "Kann Image Datei nicht einlegen"
  IDS_START_MONITOR               "%s\012\012Monitor starten? (Nein: reset, Abbruch: weiter)"
  IDS_VICE_CPU_JAM                "VICE CPU JAM"
  IDS_EXTEND_TO_40_TRACKS         "Image Dateu auf 40-Spur Format erweitern?"
  IDS_DETACHED_DEVICE_S           "Gert %s entfernt"
  IDS_ATTACHED_S_TO_DEVICE_S      "%s mit Gert#%s verbunden"
  IDS_DETACHED_TAPE               "Band Image entfernt"
  IDS_HISTORY_RECORDED_UNKNOWN    "History mit unbekanter Version aufgezeichnet"
  IDS_HISTORY_RECORDED_VICE_S     "History mit Vice-%s aufgezeichnet"
  IDS_PAUSED                      "pausiert"
  IDS_FRAME_NUMBER                "Rahmen #"
  IDS_RESUMED                     "wiederhergestellt"
  IDS_REALLY_EXIT                 "Willst Du wirklich beenden?\012\012Daten im emulierten Speicher RAM gehen verloren."
  IDS_CANNOT_AUTOSTART_FILE       "Autostart von angeforderter Datei fehlgeschlagen."
  IDS_ATTACHED_TAPE_S             "Band Image %s eingelegt"
  IDS_SETTINGS_SAVED_SUCCESS      "Einstellungen erfolgreich gespeichert"
  IDS_SETTINGS_LOADED_SUCCESS     "Einstellungen erfolgreich geladen."
  IDS_ATTACH_DISK_IMAGE           "Disk Image einlegen"
  IDS_ATTACH_TAPE_IMAGE           "Band Image einlegen"
  IDS_AUTOSTART_IMAGE             "Autostart von Disk/Band Image"
  IDS_INVALID_CARTRIDGE           "Ungltiges Erweiterungsmodul"
  IDS_BAD_CARTRIDGE_CONFIG        "Fehlerhafte Modul Konfiguration im UI!"
  IDS_INVALID_CARTRIDGE_IMAGE     "Ungltiges Erweiterungsmodul Image"
  IDS_LOG_CONSOLE_OUTPUT_IMAGE    "Konsole Log Ausgabe Image"
  IDS_LOG_FILES_TYPE              "VICE Konsole Log Dateien (*.dbg)"
  IDS_CANNOT_WRITE_LOGFILE_S      "Kann Logdatei %s nicht schreiben."
  IDS_LOAD_FLIP_LIST_FILE         "Fliplist Datei Laden"
  IDS_CANNOT_READ_FLIP_LIST       "Lesen von Fliplist Datei fehlgeschlagen"
  IDS_SAVE_FLIP_LIST_FILE         "Fliplist Datei Speichern"
  IDS_CANNOT_WRITE_FLIP_LIST      "Schreiben von Fliplist Datei fehlgeschlagen"
  IDS_SELECT_KEYMAP_FILE          "Symbolische Keymap Datei definieren"
  IDS_SAVE_KEYMAP_FILE            "Keymap Datei speichern"
  IDS_CANNOT_WRITE_KEYMAP_FILE    "Schreiben von keymap Datei fehlgeschlagen"
  IDS_SAVE_CONFIG_FILE            "Speichere Konfigurationsdatei"
  IDS_LOAD_CONFIG_FILE            "Lade Konfigurationsdatei"
  IDS_MAPPING                     "Zuordnung"
  IDS_KEYBOARD_SETTINGS           "Tastatur Einstellungen"
  IDS_ATTACH                      "&Einlegen"
  IDS_PLEASE_ENTER_A_FILENAME     "Bitte Dateinamen eingeben."
  IDS_OVERWRITE_EXISTING_IMAGE    "Existierende Datei berschreiben?"
  IDS_CANNOT_CREATE_IMAGE         "Kann Image Datei nicht erzeugen"
  IDS_COMMAND_LINE_OPTIONS        "Kommandozeilen Paramteter"
  IDS_COMMAND_OPTIONS_AVAIL       "Welche Kommandozeilen Parameter sind verfgbar?"
  IDS_NO_DRIVER_SELECT_SUPPORT    "Kein Treiber ausgewhlt oder gewhlter Treiber wird nicht untersttzt"
  IDS_CANT_WRITE_SCREENSHOT_S     "Kann Snapshot Datei `%s' nicht speichern."
  IDS_AUTOSTART_DISK_IMAGE        "Autostart Disk Image"
  IDS_SELECT_FS_DIRECTORY         "Systemverzeichnis whlen"
  IDS_PRINTER_USERPORT            "Drucker Userport"
  IDS_PRINTER_4                   "Drucker 4"
  IDS_PRINTER_5                   "Drucker 5"
  IDS_DRIVE_8                     "Laufwerk 8"
  IDS_DRIVE_9                     "Laufwerk 9"
  IDS_DRIVE_10                    "Laufwerk 10"
  IDS_DRIVE_11                    "Laufwerk 11"
  IDS_PERIPHERAL_SETTINGS         "Peripherie Einstellungen"
  IDS_CANT_WRITE_SNAPSHOT_FILE    "Kann Snapshot Datei nicht speichern."
  IDS_CANNOT_READ_SNAPSHOT_IMG    "Kann Snapshot Datei nicht laden."
  IDS_LOAD_S_ROM_IMAGE            "Lade %s ROM Image Datei"
  IDS_SELECT_ROMSET_ARCHIVE       "ROM Satz Archiv whlen"
  IDS_CANNOT_LOAD_ROMSET_ARCH     "Kann ROM Satz Archiv nicht laden!"
  IDS_CANNOT_SAVE_ROMSET_ARCH     "Fehler beim Speichern des ROM Satz Archivs!"
  IDS_CANNOT_LOAD_ROMSET_FILE     "Kann ROM Satz Datei nicht laden!"
  IDS_CANNOT_SAVE_ROMSET_FILE     "Fehler beim Speichern der ROM Satz Datei!"
  IDS_SELECT_ROMSET_FILE          "ROM Satz Datei whlen"
  IDS_ROMSET                      "Rom Satz"
  IDS_COMPUTER                    "Computer"
  IDS_DRIVE                       "Laufwerk"
  IDS_ROM_SETTINGS                "ROM Einstellungen"
  IDS_SAVE_SNAPSHOT_IMAGE         "Snapshot Datei Speichern"
  IDS_CANNOT_WRITE_SNAPSHOT_S     "Kann Snapshot Datei `%s' nicht speichern."
  IDS_LOAD_SNAPSHOT_IMAGE         "Snapshot Laden"
  IDS_COULD_NOT_LOAD_PALETTE      "Kann Paletten Datei nicht laden."
  IDS_LOAD_VICE_PALETTE_FILE      "VICE Paletten Datei laden"
  IDS_FULLSCREEN                  "Vollbild/Direct X"
  IDS_COLORS                      "Farben"
  IDS_NEW_PAL                     "PAL Emulation"
  IDS_VIDEO_SETTINGS              "Video Einstellungen"
  IDS_FILE_SYSTEM                 "Dateisystem"
#ifdef HAVE_OPENCBM
  IDS_REAL_IEC_DEVICE             "Reales IEC Gert"
#endif
  IDS_RS232_DEVICE_I              "RS232 Gert %i"
  IDS_ATTACH_CRT_CART_IMAGE       "CRT Erweiterungsmodul Image einlegen"
  IDS_ATTACH_RAW_8KB_CART_IMAGE   "8KB Erweiterungsmodul (raw) Image einlegen"
  IDS_ATTACH_RAW_16KB_CART_IMG    "16KB Erweiterungsmodul (raw) Image einlegen"
  IDS_ATTACH_AR_CART_IMAGE        "Action Replay Erweiterungsmodul Image einlegen"
  IDS_ATTACH_AR3_CART_IMAGE       "Action Replay III Erweiterungsmodul Image einlegen"
  IDS_ATTACH_AR4_CART_IMAGE       "Action Replay 4 Erweiterungsmodul Image einlegen"
  IDS_ATTACH_STARDOS_CART_IMAGE   "Erweiterungsmodul StarDOS Image einlegen"
  IDS_ATTACH_ATOMIC_P_CART_IMG    "Atomic Power Erweiterungsmodul Image einlegen"
  IDS_ATTACH_EPYX_FL_CART_IMG     "Epyx Fastload Erweiterungsmodul Image einlegen"
  IDS_ATTACH_IEEE488_CART_IMG     "IEEE Schnittstellen Erweiterungsmodul Image einlegen"
  IDS_ATTACH_RETRO_R_CART_IMG     "Retro Replay Erweiterungsmodul Image einlegen"
  IDS_ATTACH_IDE64_CART_IMAGE     "IDE64 Schnittstellen Erweiterungsmodul Image einlegen"
  IDS_ATTACH_SS4_CART_IMAGE       "Super Snapshot 4 Erweiterungsmodul Image einlegen"
  IDS_ATTACH_SS5_CART_IMAGE       "Super Snapshot 5 Erweiterungsmodul Image einlegen"
  IDS_ATTACH_STB_CART_IMAGE       "Structured Basic Erweiterungsmodul Image einlegen"
  IDS_MODEL                       "Modell"
  IDS_DRIVE_SETTINGS              "Floppy Einstellungen"
  IDS_SELECT_START_SNAP_EVENT     "Startsnapshot fr Ereignishistory festlegen"
  IDS_SELECT_END_SNAP_EVENT       "Endsnapshot fr Ereignishistory festlegen"
#ifdef UNSTABLE
  IDS_VERSION_S_UNSTABLE          "Version %s *INSTABIL* (%s)"
#else
  IDS_VERSION_S                   "Version %s (%s)"
#endif
  IDS_VICE_CONTRIBUTORS           "VICE Hackers"
  IDS_WHO_MADE_WHAT               "Wer hat was gemacht?"
  IDS_LICENSE                     "Lizenz"
  IDS_NO_WARRANTY                 "Keine Garantie!"
  IDS_VICE_WITHOUT_WARRANTY       "VICE ist ohne Garantie"
  IDS_PRESS_KEY_NORTHWEST         "Drcke Taste fr NordWest"
  IDS_PRESS_KEY_NORTH             "Drcke Taste fr Nord"
  IDS_PRESS_KEY_NORTHEAST         "Drcke Taste fr NordOst"
  IDS_PRESS_KEY_EAST              "Drcke Taste fr Ost"
  IDS_PRESS_KEY_SOUTHEAST         "Drcke Taste fr SdOst"
  IDS_PRESS_KEY_SOUTH             "Drcke Taste fr Sd"
  IDS_PRESS_KEY_SOUTHWEST         "Drcke Taste fr SdWest"
  IDS_PRESS_KEY_WEST              "Drcke Taste fr West"
  IDS_PRESS_KEY_FIRE              "Drcke Taste fr Feuer"
  IDS_NO_USERPORT_ADAPTER         "Kein Userport Joystick Adapter"
  IDS_CGA_USERPORT_ADAPTER        "CGA Userport Joystick Adapter"
  IDS_PET_USERPORT_ADAPTER        "PET Userport Joystick Adapter"
  IDS_HUMMER_USERPORT_ADAPTER     "HUMMER Userport Joystock Adapter"
  IDS_OEM_USERPORT_ADAPTER        "OEM Userport Joystick Adapter"
  IDS_HIT_USERPORT_ADAPTER        "HIT Userport Joystick Adapter"
  IDS_NO_SIDCART_JOY              "SIDcart Joystick deaktivieren"
  IDS_SIDCART_JOY                 "SIDcart Joystick aktivieren"
  IDS_NUMPAD_AND_RCTRL            "Numpad + RCtrl"
  IDS_KEYSET_A                    "Tastaturbelegung A"
  IDS_KEYSET_B                    "Tastaturbelegung B"
  IDS_ALL_BUTTONS_AS_FIRE         "Alle Knpfe als Feuer"
  IDS_NUMERIC_SEE_ABOVE           "Numerisch (siehe oben)"
  IDS_NO_BUTTON_NO_AUTOFIRE       "Kein Knopf - Autofeuer deaktiviert"
  IDS_ALL_FILES_FILTER            "Alle Dateien (*.*)"
  IDS_PALETTE_FILES_FILTER        "Vice Paletten Dateien (*.vpl)"
  IDS_SNAPSHOT_FILES_FILTER       "VICE Snapshot Dateien (*.vsf)"
  IDS_CBM_IMAGE_FILES_FILTER      "CBM Dateien (*.d64;*.d71;*.d80;*.d81;*.d82;*.g64;*.g41;*.x64;*.t64;*.tap;*.prg;*.p00)"
  IDS_DISK_IMAGE_FILES_FILTER     "Disk Image Dateien (*.d64;*.d71;*.d80;*.d81;*.d82;*.g64;*.g41;*.x64)"
  IDS_TAPE_IMAGE_FILES_FILTER     "Band Image Dateien (*.t64;*.tap)"
  IDS_ZIPPED_FILES_FILTER         "Komprimierte Dateien (*.zip;*.bz2;*.gz;*.d6z;*.d7z;*.d8z;*.g6z;*.g4z;*.x6z)"
  IDS_CRT_FILES_FILTER            "CRT Erweiterungsmodul Dateien (*.crt)"
  IDS_RAW_CART_FILES_FILTER       "Raw Erweiterungsmodul Dateien (*.bin)"
  IDS_FLIP_LIST_FILES_FILTER      "VICE Fliplist Dateien (*.vfl)"
  IDS_ROMSET_FILES_FILTER         "VICE ROM Satzs Dateien (*.vrs)"
  IDS_ROMSET_ARCHIVES_FILTER      "VICE ROM Satz Archiv Dateien (*.vra)"
  IDS_KEYMAP_FILES_FILTER         "VICE Keymap Dateien (*.vkm)"
  IDS_PRGP00_FILES_FILTER         "Commodore Emulator Dateien (*.prg;*.p00)"
  IDS_FLEXIBLE                    "Flexibel"
  IDS_ADJUSTING                   "Anpassend"
  IDS_EXACT                       "Exakt"
  IDS_SOUND_DRIVER_DIRECTX        "Sound Treiber: DirectX"
  IDS_SOUND_DRIVER_WMM            "Sound Treiber: WMM"
  IDS_MEDIA_FILES_FILTER          "Media Dateien (*.bmp;*.gif;*.iff;*.jpg;*.pcx;*.png;*.ppm;*.wav;*.mp3;*.avi;*.mpg)"
  IDS_SPACE_KB                    " kB"
  IDS_CONFIGURE_KEYSET_A          "Konfiguriere Tastaturbelegung A"
  IDS_CONFIGURE_KEYSET_B          "Konfiguriere Tastaturbelegung B"
  IDS_SAVE_MEDIA_IMAGE            "Media Image speichern"
  IDS_S_AT_D_SPEED                "%s bei %d%% Geschwindigkeit, %d fps%s"
  IDS_TAPE                        "Band:"
  IDS_JOYSTICK_C                  "Joystick:"
  IDS_RECORDING                   "Aufnahme\n%02d:%02d"
  IDS_PLAYBACK                    "Wiedergabe\n%02d:%02d (%02d:%02d)"
  IDS_UNKNOWN                     "Unbekannt"
  IDS_P_NUMBER                    "<Nummer>"
  IDS_SET_INPUT_JOYSTICK_1        "Input Gert fr Joystick #1 definieren"
  IDS_SET_INPUT_JOYSTICK_2        "Input Gert fr Joystick #2 definieren"
  IDS_SET_INPUT_EXTRA_JOYSTICK_1  "Input Gert fr extra Joystick #1 definieren"
  IDS_SET_INPUT_EXTRA_JOYSTICK_2  "Input Gert fr extra Joystick #2 definieren"
  IDS_SAVE_SETTINGS_ON_EXIT       "Einstellungen (Ressourcen) beim Beenden speichern"
  IDS_NO_SAVE_SETTINGS_ON_EXIT    "Einstellungen beim Beenden nie speichern"
  IDS_CONFIRM_QUIT_VICE           "Besttige beenden von VICE"
  IDS_NO_CONFIRM_QUIT_VICE        "Keine Besttigung beim Beenden von Vice"
  IDS_USE_ALL_CPU_SMP             "Alle SMP CPUs benutzen"
  IDS_USE_FIRST_CPU_SMP           "Nur erste SMP SPU nutzen"
  IDS_START_VICE_FULLSCREEN_MODE  "Aktiviere VICE Vollbild Modus"
  IDS_DISABLE_DX9                 "DirectX9 Video Treiber deaktivieren"
#ifdef SYS_SIGLIST_DECLARED
  IDS_RECEIVED_SIGNAL_D_S         "Ein unerwarteter Fehler ist aufgetreten. Signal %d (%s) empfangen."
#else
  IDS_RECEIVED_SIGNAL_D           "Ein unerwarteter Fehler ist aufgetreten. Signal %d empfangen."
#endif
#ifdef HAVE_NETWORK
  IDS_IDLE                        "Idle"
  IDS_SERVER_LISTENING            "Server wartet auf Verbindung"
  IDS_CONNECTED_SERVER            "Verbunden, Server"
  IDS_CONNECTED_CLIENT            "Verbunden, Client"
  IDS_INVALID_PORT_NUMBER         "Ungltige Port Nummer"
  IDS_ERROR_STARTING_SERVER       "Fehler beim Starten des Netplay Servers."
  IDS_ERROR_CONNECTING_CLIENT     "Fehler beim Verbindungsaufbau zum Client."
#endif
  IDS_SOUND_RECORDING_STARTED     "Tonaufnahme gestartet..."
  IDS_SOUND_RECORDING_STOPPED     "Tonaufnahme gestoppt..."
  IDS_OK                          "OK"
  IDS_CANCEL                      "Abbruch"
  IDS_NONE                        "Kein"
  IDS_BROWSE                      "&Stbern..."
  IDS_SPECIFY_MIDI_IN             "MIDI-In Gert spezifieren"
  IDS_SPECIFY_MIDI_OUT            "MIDI-Out Gert spezifieren"
  IDS_ERROR_SAVING_EASYFLASH_CRT  "Fehler beim Speichern der EasyFlash CRT Datei"
  IDS_DATASETTE_CAPTION           "Datasette Einstellungen"
  IDS_DATASETTE_RESET_WITH_CPU    "Zu&rcksetzen des Bandlaufwerks bei CPU Reset"
  IDS_DATASETTE_MOTOR_GROUP       "Motorgeschwindigkeit beim Lesen"
  IDS_DATASETTE_DELAY_TRIGGER     "Zyklen zustzliche Verzgerung bei je&dem Trigger"
  IDS_DATASETTE_DELAY_AT_ZERO     "Zyklen Verzgerung bei &Zero-Werte"
  IDS_TOGGLE_USEIECDEVICE         "IEC Gert &aktivieren"
  IDS_SELECTDISK                  "Disk &Image"
  IDS_SELECTDIR                   "&Directory"
#ifdef HAVE_OPENCBM
  IDS_SELECTREAL                  "Rea&les IEC Gert"
#endif
  IDS_SELECTNONE                  "Kei&n"
  IDS_AUTOSTART                   "&Autostart"
  IDS_BROWSEDIR                   "St&bern..."
  IDS_TOGGLE_ATTACH_READONLY      "Schreibgeschtzt einlegen"
  IDS_TOGGLE_READP00              "P00 Datei &Laden"
  IDS_TOGGLE_WRITEP00             "P00 Dateien &Schreiben"
  IDS_TOGGLE_HIDENONP00           "Non-P00 Dateien &ausblenden"
  IDS_JOYSTICK_CAPTION            "Joystick Einstellungen"
  IDS_JOYSTICK_IN_PORT_1          "Joystick in Port #&1"
  IDS_SELECT_FIRE_BUTTON          "Feuerknopf auswhlen"
  IDS_AUTO_FIRE_BUTTON_SETTINGS   "Automatische Feuerknopf Einstellungen"
  IDS_AUTOFIRE_SPEED              "Autofeuer Ge&schwindigkeit (1..32)"
  IDS_JOYSTICK_IN_PORT_2          "Joystick in Port #&2"
  IDS_JOY_CONFIG_A                "Tastaturbelegung &A konfigurieren"
  IDS_JOY_CONFIG_B                "Tastaturbelegung &B konfigurieren"
  IDS_JOY_CALIBRATE               "Joysticks &kalibrieren"
  IDS_EXTRA_JOYSTICK_CAPTION      "Extra Joystick Einstellungen"
  IDS_JOYSTICK_IN_EXTRA_PORT_1    "Joystick in extra Port #&1"
  IDS_JOYSTICK_IN_EXTRA_PORT_2    "Joystick in extra Port #&2"
  IDS_KEYSET_SW                   "Sd West"
  IDS_KEYSET_S                    "&Sden"
  IDS_KEYSET_SE                   "Sd Ost"
  IDS_KEYSET_W                    "&Westen"
  IDS_KEYSET_E                    "&Osten"
  IDS_KEYSET_NW                   "Nord West"
  IDS_KEYSET_N                    "&Norden"
  IDS_KEYSET_NE                   "Nord Ost"
  IDS_KEYSET_FIRE                 "&Feuerknopf"
  IDS_SOUND_CAPTION               "Sound Gert Einstellungen konfigurieren"
  IDS_SOUND_DIRECTX               "DirectX treiber"
  IDS_SOUND_WMM                   "WMM treiber"
  IDS_SOUND_SAMPLE_FREQUENCY      "Sample &Frequenz"
  IDS_SOUND_BUFFER_SIZE           "Sound Puffergre"
  IDS_SOUND_FRAGMENT_SIZE_LABEL   "Sound Fragmentgre :"
  IDS_SOUND_FRAGMENT_SIZE_SMALL   "Klein"
  IDS_SOUND_FRAGMENT_SIZE_MEDIUM  "Mittel"
  IDS_SOUND_FRAGMENT_SIZE_LARGE   "Gro"
  IDS_SOUND_SYNCH_METHOD          "Synchronisations&methode"
  IDS_TOGGLE_SNAPSHOT_SAVE_DISKS  "Aktuell eingelegte &Diskimages speichern"
  IDS_TOGGLE_SNAPSHOT_SAVE_ROMS   "Aktuelle ROMs speichern"
  IDS_FULLSCREEN_DRIVER           "Treiber:"
  IDS_FULLSCREEN_DRVR_BITDEPTH    "Farbtiefe:"
  IDS_FULLSCREEN_DRVR_RESOLUTION  "Auflsung:"
  IDS_FULLSCREEN_DRVR_REFRESHRATE "Wiederholrate:"
  IDS_TOGGLE_VIDEO_VBLANK_SYNC    "VBLANK Synchronisation"
  IDS_TOGGLE_VIDEO_DX_PRIMARY     "DX Primary Oberflchenrendering"
  IDS_TOGGLE_KEEP_ASPECT_RATIO    "Seitenverhltnis beibehalten (0,5..2)"
  IDS_COLORS_SATURATION           "Sttigung (0..2)"
  IDS_COLORS_CONTRAST             "Kontrast (0..2)"
  IDS_COLORS_BRIGHTNESS           "Helligkeit (0..2)"
  IDS_NEW_PAL_TINT                "Farbton (0..2)"
  IDS_NEW_PAL_ODD_LINES_PHASE     "Ungerade Zeilenphase (0..2)"
  IDS_NEW_PAL_ODD_LINES_OFFSET    "Ungerader Zeilenoffset (0..2)"
  IDS_VIDEO_GAMMA                 "Gamma (0..2)"
  IDS_VIDEO_PHASE                 "Phase (0..2)"
  IDS_VIDEO_PAL_SHADE             "PAL Schatten (0..1)"
  IDS_VIDEO_PAL_BLUR              "PAL Unschrfe (0..1)"
  IDS_TOGGLE_VIDEO_EXTPALETTE     "Externe Farbtabelle:"
  IDS_RAM_CAPTION                 "RAM Einstellungen"
  IDS_RAM_INIT_AT_POWERUP         "Initialisierung beim Kaltstart"
  IDS_RAM_VALUE_FIRST_BYTE        "Wert erstes Byte"
  IDS_RAM_LENGTH_CONSTANT_VALUES  "Lnge der konstaten Werte"
  IDS_RAM_LENGTH_CONSTANT_PATTERN "Lnge des konstanten Musters"
  IDS_PRINTER_EMULATION           "Drucker Emulation"
  IDS_PRINTER_FORMFEED            "Seitenvorschub senden"
  IDS_FILESYSTEM_PRINTER          "Druck auf Dateisystem"
  IDS_PRINTER_DRVR                "Drucker Treiber"
  IDS_OUTPUT                      "Ausgabe"
  IDS_OUTPUT_TO_FILE              "Ausgabe auf Datei #"
  IDS_OUTPUT_FILE1_NAME           "Ausgabe Datei #1 Name"
  IDS_OUTPUT_FILE2_NAME           "Ausgabe Datei #2 Name"
  IDS_OUTPUT_FILE3_NAME           "Ausgabe Datei #3 Name"
  IDS_ROMSET_SELECT_ARCHIVE       "ROM Satz Archiv"
  IDS_ROMSET_ARCHIVE_LOAD         "Archiv laden"
  IDS_ROMSET_ARCHIVE_SAVE         "Archiv speichern"
  IDS_ROMSET_CONFIGURATION        "&Konfigurationen"
  IDS_ROMSET_ARCHIVE_APPLY        "Besttigen"
  IDS_ROMSET_ARCHIVE_NEW          "Neu"
  IDS_ROMSET_ARCHIVE_DELETE       "Lschen"
  IDS_ROMSET_SELECT_FILE          "ROM Satz Datei"
  IDS_ROMSET_FILE_LOAD            "Romsatz laden"
  IDS_ROMSET_FILE_SAVE            "Romsatz speichern"
  IDS_CUSTOM_SPEED_CAPTION        "Benutzerdefinierte Geschwindigkeit"
  IDS_ENTER_CUSTOM_SPEED          "Geschwindigkeit [%] einstellen"
  IDS_NEW_CONFIGURATION           "Neue Konfiguration"
  IDS_ENTER_CONFIGURATION_NAME    "Konfigurationsnamen eingeben"
  IDS_RS232_CAPTION               "RS232 Einstellungen"
  IDS_RS232_DEV_1                 "RS232 Gert 1"
  IDS_RS232_DEV_2                 "RS232 Gert 2"
  IDS_RS232_DEV_3                 "RS232 Gert 3"
  IDS_RS232_DEV_4                 "RS232 Gert 4"
  IDS_NETWORK_CAPTION             "Netplay Einstellungen"
  IDS_CURRENT_MODE                "Aktueller Modus"
  IDS_SERVER_BIND                 "Server Bind"
  IDS_TCP_PORT                    "TCP-Port"
  IDS_NETWORK_SERVER              "Server Starten"
  IDS_NETWORK_CLIENT              "Verbinden mit"
  IDS_NETWORK_DISCONNECT          "Verbindung Trennen"
  IDS_CONTROL                     "Kontrolle"
  IDS_SERVER                      "Server"
  IDS_CLIENT                      "Client"
  IDS_KEYBOARD                    "Tastatur"
  IDS_JOYSTICK_1                  "Joystick 1"
  IDS_JOYSTICK_2                  "Joystick 2"
  IDS_DEVICES                     "Gerte"
  IDS_SETTINGS                    "Einstellungen"
  IDS_TOGGLE_CONSOLE_APPEND       "An bestehende Log Datei &anhngen"
  IDS_IMAGE_CONTENTS              "Image Datei Inhalt"
  IDS_NEW_IMAGE                   "Neue Image Datei"
  IDS_NAME                        "Name"
  IDS_ID                          "ID"
  IDS_TYPE                        "Typ"
  IDS_BLANK_IMAGE                 "Image Datei erzeugen"
  IDS_NEW_TAP_IMAGE               "Neue TAP Image Datei"
  IDS_SAVE                        "Speichern"
  IDS_SELECT_DRIVER               "Treiber auswhlen"
  IDS_FFMPEG_SETTINGS             "FFMPEG Einstellungen"
  IDS_FORMAT                      "Format"
  IDS_AUDIO_CODEC                 "Audiocodec"
  IDS_BITRATE                     "Bitrate"
  IDS_VIDEO_CODEC                 "Videocodec"
  IDS_SOUND_RECORD_CAPTION        "Tonaufnahme Einstellungen"
  IDS_SOUND_RECORD_FORMAT_LABEL   "Tonaufnahmeformat"
  IDS_SOUND_RECORD_FILE_LABEL     "Tonaufnahme Datei"
  IDS_KERNAL                      "Kernal"
  IDS_BASIC                       "Basic"
  IDS_CHARACTER                   "Zeichensatz"
  IDS_COMPUTER_RESOURCES_CAPTION  "Computer resourcen"
  IDS_COMPUTER_RESOURCES          "Computer Resourcen zum ROM Satz gespeichert"
  IDS_DRIVE_RESOURCES_CAPTION     "Floppy resourcen"
  IDS_DRIVE_RESOURCES             "Floppy Resourcen zum ROM Satz gespeichert"
  IDS_SYMBOLIC                    "&Symbolisch"
  IDS_POSITIONAL                  "&Positional"
  IDS_DUMP_KEYSET                 "Aktuelle Keymap auf Datei speichern"
  IDS_DUMP_SHORTCUTS              "Aktuelle Tastenkrzel auf Datei speichern"
  IDS_SYMBOLIC_US                 "&Symbolisch US"
  IDS_SYMBOLIC_DE                 "&Symbolisch DE"
  IDS_GR_SYM                      "&Gr Sym."
  IDS_GR_POS                      "G&r Pos."
  IDS_UK_SYM                      "&UK Sym."
  IDS_UK_POS                      "U&K Pos."
  IDS_DE_SYM                      "&DE Sym."
  IDS_DE_POS                      "D&E Pos."
  IDS_A_MEMORY                    "&Speicher"
  IDS_DRIVE_TYPE                  "&Gerte Typ"
  IDS_40_TRACK_HANDLING           "40 &Spur Umgang"
  IDS_SELECT_DRIVE_EXTEND_NEVER   "Nie Erweitern"
  IDS_SELECT_DRIVE_EXTEND_ASK     "Bei Erweiterung Rckfrage"
  IDS_SELECT_DRIVE_EXTEND_ACCESS  "Erweitern wenn ntig"
  IDS_IDLE_METHOD                 "Id&le Methode"
  IDS_SELECT_DRIVE_IDLE_TRAP_IDLE "Trap idle"
  IDS_SELECT_DRIVE_IDLE_SKIP_CYC  "Zyklen auslassen"
  IDS_TOGGLE_DRIVE_PARALLEL_CABLE "&Parallel Kabel"
  IDS_DRIVE_EXPANSION             "Laufwerk &erweiterung"
  IDS_TOGGLE_DRIVE_EXPANSION_2000 "$2000-$3FFF &RAM"
  IDS_TOGGLE_DRIVE_EXPANSION_4000 "$&4000-$5FFF RAM"
  IDS_TOGGLE_DRIVE_EXPANSION_6000 "$&6000-$7FFF RAM"
  IDS_TOGGLE_DRIVE_EXPANSION_8000 "$8000-$9FFF RA&M"
  IDS_TOGGLE_DRIVE_EXPANSION_A000 "$&A000-$BFFF RAM"
  IDS_PLUS4_VIC20_MEMORY          "&Speicher"
  IDS_SID_GENGROUP1               "SID Engine/Modell"
  IDS_SID_FILTERS                 "SID Filter"
  IDS_MP_FILE                     "&Datei"
  IDS_MP_ATTACH_DISK_IMAGE        "&Disk Image einlegen"
  IDS_MP_DETACH_DISK_IMAGE        "Disk Image &entfernen"
  IDS_MP_FLIP_LIST                "&Flipliste"
  IDS_MP_DATASETTE_CONTROL        "Bandlaufwerk Kontro&lle"
  IDS_MP_ATTACH_CARTRIDGE_IMAGE   "Erweiterungsmodule einlegen..."
  IDS_MP_EXPERT_CARTRIDGE         "Expert Cartridge"
  IDS_MP_RESET                    "&Reset"
  IDS_MP_DEBUG                    "&Debug"
#ifdef DEBUG
  IDS_MP_MODE                     "M&odus"
#endif
  IDS_MP_EDIT                     "B&earbeiten"
  IDS_MP_SNAPSHOT                 "Sna&pshot"
  IDS_MP_RECORDING_START_MODE     "Aufnahme Start Modus"
  IDS_MP_OPTIONS                  "&Optionen"
  IDS_MP_REFRESH_RATE             "Wiederhol&rate"
  IDS_MP_MAXIMUM_SPEED            "&Maximale Geschwindigkeit"
  IDS_MP_VIDEO_STANDARD           "Vide&o standard"
  IDS_MP_DRIVE_SYNC_FACTOR        "Laufwerkt S&ync Faktor"
  IDS_MP_SETTINGS                 "&Einstellungen"
  IDS_MP_CARTRIDGE_IO_SETTINGS    "&Erweiterungsmodul Einstellungen"
  IDS_MP_LANGUAGE                 "Sprache"
  IDS_MP_HELP                     "&Hilfe"
  IDS_MP_VIEW                     "An&sehen"
  IDS_MP_WINDOW                   "&Fenster"
  IDS_MI_EXIT                     "E&xit"
  IDS_MI_ABOUT                    "&ber VICE..."
  IDS_MI_PAUSE                    "&Pause"
  IDS_MI_EDIT_COPY                "&Kopieren"
  IDS_MI_EDIT_PASTE               "&Einfgen"
  IDS_MI_AUTOSTART                "&Autostart Disk/Band Image..."
  IDS_MI_RESET_HARD               "&Hart"
  IDS_MI_RESET_SOFT               "&Weich"
  IDS_MI_DRIVE8                   "Laufwerk &8"
  IDS_MI_DRIVE9                   "Laufwerk &9"
  IDS_MI_DRIVE10                  "Laufwerk 1&0"
  IDS_MI_DRIVE11                  "Laufwerk 1&1"
  IDS_MI_ATTACH_TAPE              "&Band Image einlegen..."
  IDS_MI_DETACH_TAPE              "Band Image entfernen"
  IDS_MI_DETACH_ALL               "&Alle"
  IDS_MI_TOGGLE_SOUND             "&Sound Einschalten"
  IDS_MI_TOGGLE_DOUBLESIZE        "&Doppelte Gre"
  IDS_MI_TOGGLE_DOUBLESCAN        "Do&ppelt Scan"
  IDS_MI_DRIVE_TRUE_EMULATION     "&Przise Floppy Emulation"
  IDS_MI_AUTOSTART_HANDLE_TDE     "&Autostart mit TDE"
  IDS_MI_TOGGLE_VIDEOCACHE        "Video &cache"
  IDS_MI_DRIVE_SETTINGS           "&Floppy Einstellungen..."
  IDS_MI_CART_ATTACH_CRT          "&CRT Image Datei..."
  IDS_MI_CART_ATTACH_8KB          "Generische 8Kb Image..."
  IDS_MI_CART_ATTACH_16KB         "Generische 16Kb Image..."
  IDS_MI_CART_ATTACH_AR           "&Action Replay Image..."
  IDS_MI_CART_ATTACH_AR3          "Action Replay &III Image..."
  IDS_MI_CART_ATTACH_AR4          "Action Replay &4 Image..."
  IDS_MI_CART_ATTACH_STARDOS      "Star&DOS Image..."
  IDS_MI_CART_ATTACH_AT           "Atomic Power &Image..."
  IDS_MI_CART_ATTACH_EPYX         "&Epyx Fastload Image..."
  IDS_MI_CART_ATTACH_IEEE488      "&IEEE 488 Schnittstellenmodul..."
  IDS_MI_CART_ATTACH_RR           "&Retro Replay Image..."
  IDS_MI_CART_ATTACH_IDE64        "IDE&64 Schnittstellenmodul..."
  IDS_MI_CART_ATTACH_SS4          "Super Snapshot &4 Image..."
  IDS_MI_CART_ATTACH_SS5          "Super Snapshot &5 Image..."
  IDS_MI_CART_ATTACH_STB          "Structured &Basic Image..."
  IDS_MI_FLIP_ADD                 "&Aktuelles Image hinzufgen"
  IDS_MI_FLIP_REMOVE              "Aktuelles Image entfe&rnen"
  IDS_MI_FLIP_NEXT                "&Nchstes Image"
  IDS_MI_FLIP_PREVIOUS            "&Voriges Image"
  IDS_MI_FLIP_LOAD                "Fliplist Datei &Laden"
  IDS_MI_FLIP_SAVE                "Fliplist Datei &Speichern"
  IDS_MI_DATASETTE_STOP           "S&top"
  IDS_MI_DATASETTE_START          "&Start"
  IDS_MI_DATASETTE_FORWARD        "&Forward"
  IDS_MI_DATASETTE_REWIND         "&Rewind"
  IDS_MI_DATASETTE_RECORD         "Re&cord"
  IDS_MI_DATASETTE_RESET          "R&eset"
  IDS_MI_DATASETTE_RESET_COUNTER  "Z&hler zurcksetzen"
  IDS_MI_CART_ENABLE_EXPERT       "Aktivieren"
  IDS_MI_CART_MODE_OFF            "Aus"
  IDS_MI_CART_MODE_ON             "Ein"
  IDS_MI_CART_SET_DEFAULT         "Aktuelles Erweiterungsmodul als standar&d aktivieren"
  IDS_MI_TOGGLE_CART_RESET        "Reset bei Wechsel von Erweiterungsmodulen"
  IDS_MI_CART_DETACH              "Erweiterungsmodul &Image entfernen"
  IDS_MI_CART_FREEZE              "Erweiterungsmodul Free&ze"
  IDS_MI_MONITOR                  "&Monitor"
#ifdef DEBUG
  IDS_MI_DEBUG_MODE_NORMAL        "&Normal"
  IDS_MI_DEBUG_MODE_SMALL         "&Klein"
  IDS_MI_DEBUG_MODE_HISTORY       "&History"
  IDS_MI_DEBUG_MODE_AUTOPLAY      "&History Automatische Wiedergabe"
  IDS_MI_TOGGLE_MAINCPU_TRACE     "&Haupt CPU Trace"
  IDS_MI_TOGGLE_DRIVE0CPU_TRACE   "Laufwerk&0 CPU Trace"
  IDS_MI_TOGGLE_DRIVE1CPU_TRACE   "Laufwerk&1 CPU Trace"
#endif
  IDS_MI_SNAPSHOT_LOAD            "Snapshot &Image Laden..."
  IDS_MI_SNAPSHOT_SAVE            "Sna&pshot Image Speichern..."
  IDS_MI_LOADQUICK                "Quick-Snapshot Image &laden"
  IDS_MI_SAVEQUICK                "Quick-Snapshot Datei &speichern"
  IDS_MI_EVENT_TOGGLE_RECORD      "Sta&rt/Stop Aufnahme History"
  IDS_MI_EVENT_TOGGLE_PLAYBACK    "St&art/Stop Wiedergabe History"
  IDS_MI_EVENT_SETMILESTONE       "Setze Aufnahme Meilenstein"
  IDS_MI_EVENT_RESETMILESTONE     "Rckkehr zum Meilenstein"
  IDS_MI_EVENT_START_MODE_SAVE    "&Speichere neuen Snapshot"
  IDS_MI_EVENT_START_MODE_LOAD    "&Lade existierenden Snapshot"
  IDS_MI_EVENT_START_MODE_RESET   "Mit &Reset starten"
  IDS_MI_EVENT_START_MODE_PLAYBCK "Laufende Aufnahme berschreiben"
  IDS_MI_EVENT_DIRECTORY          "Verzeichnis fr Event Aufnahme"
  IDS_MI_MEDIAFILE                "Speichern/stop media Datei..."
  IDS_MI_SOUND_RECORD_START       "Aufnahme..."
  IDS_MI_SOUND_RECORD_STOP        "Aufnahme Stop"
  IDS_MI_REFRESH_RATE_AUTO        "&Automatisch"
  IDS_MI_MAXIMUM_SPEED_NO_LIMIT   "Kein &Limit"
  IDS_MI_MAXIMUM_SPEED_CUSTOM     "&Benutzerdefiniert"
  IDS_MI_TOGGLE_WARP_MODE         "&Warp modus"
  IDS_MI_TOGGLE_ALWAYSONTOP       "Immer im Vordergrund"
  IDS_MI_TOGGLE_FASTPAL           "PAL Emulation"
  IDS_MI_TOGGLE_SCALE2X           "Scale2x"
  IDS_MI_SWAP_JOYSTICK            "&Joystick ports austauschen"
  IDS_MI_SWAP_EXTRA_JOYSTICK      "&Userport Joystick ports austauschen"
  IDS_MI_ALLOW_JOY_OPPOSITE       "Gegnberliegende Richtungen zulassen"
  IDS_MI_JOYKEYS_TOGGLE           "Joystick Tasten aktivieren"
  IDS_MI_TOGGLE_VIRTUAL_DEVICES   "&Virtuelle Gerte Traps"
  IDS_MI_TOGGLE_EMUID             "Emulator &Identifikation"
  IDS_MI_MOUSE                    "Maus Ereignisse abfan&gen"
  IDS_MI_AUTOSTART_SETTINGS       "&Autostart settings..."
  IDS_MI_VIDEO_SETTINGS           "&Video Einstellungen..."
  IDS_MI_DEVICEMANAGER            "&Peripherie Einstellungen..."
  IDS_MI_JOY_SETTINGS             "&Joystick Einstellungen..."
  IDS_MI_USERPORT_JOY_SETTINGS    "&Userport Joystick Einstellungen..."
  IDS_MI_SIDCART_JOY_SETTINGS     "&Sidcart Joystick Einstellungen..."
  IDS_MI_KEYBOARD_SETTINGS        "&Tastatur Einstellungen..."
  IDS_MI_SOUND_SETTINGS           "S&ound Einstellungen..."
  IDS_MI_ROM_SETTINGS             "&ROM Einstellungen..."
  IDS_MI_RAM_SETTINGS             "RA&M Einstellungen..."
  IDS_MI_DATASETTE_SETTINGS       "B&andlaufwerk Einstellungen"
  IDS_MI_VICII_SETTINGS           "VIC-II Einstellungen..."
  IDS_MI_MOUSE_SETTINGS           "Ma&us Einstellungen..."
  IDS_MI_SID_SETTINGS             "S&ID Einstellungen..."
  IDS_MI_RS232_SETTINGS           "RS&232 Einstellungen..."
  IDS_MI_REU_SETTINGS             "&REU Einstellungen..."
  IDS_MI_GEORAM_SETTINGS          "&GEORAM Einstellungen..."
  IDS_MI_RAMCART_SETTINGS         "&RAMCART Einstellungen..."
  IDS_MI_DQBB_SETTINGS            "&Double Quick Brown Box Einstellungen..."
  IDS_MI_ISEPIC_SETTINGS          "I&sepic Einstellungen..."
  IDS_MI_MMC64_SETTINGS           "&MMC64 Einstellungen..."
  IDS_MI_MIDI_SETTINGS            "M&IDI Einstellungen..."
  IDS_MI_DIGIMAX_SETTINGS         "&Digimax Einstellungen..."
  IDS_MI_LIGHTPEN_SETTINGS        "&Lichtgriffel Einstellungen..."
  IDS_MI_IDE64_SETTINGS           "&IDE64 Einstellungen..."
#ifdef HAVE_TFE
  IDS_MI_TFE_SETTINGS             "&Ethernet Einstellungen..."
#endif
  IDS_MI_ACIA_SETTINGS            "&ACIA Einstellungen..."
  IDS_MI_RS232USER_SETTINGS       "RS&232 Userport Einstellungen..."
  IDS_MI_EASYFLASH_SETTINGS       "EasyFlash Einstellungen..."
  IDS_MI_SFX_SE_SETTINGS          "SFX Sound Expander Einstellungen..."
  IDS_MI_TOGGLE_SFX_SS            "SFX Sound Sampler aktivieren"
  IDS_MI_SETTINGS_SAVE_FILE       "Speichere Einstellungen in angegebene Datei"
  IDS_MI_SETTINGS_LOAD_FILE       "Lade Einstellungen von Datei"
  IDS_MI_SETTINGS_SAVE            "Einstellungen &speichern"
  IDS_MI_SETTINGS_LOAD            "Einstellungen &Laden"
  IDS_MI_SETTINGS_DEFAULT         "&Wiederherstellen Standard Einstellungen"
  IDS_MI_SAVE_SETTINGS_ON_EXIT    "Einstellungen beim Beenden speichern"
  IDS_MI_CONFIRM_ON_EXIT          "&Besttigung beim Beenden"
  IDS_MI_LANG_EN                  "&Englisch"
  IDS_MI_LANG_DA                  "D&nisch"
  IDS_MI_LANG_DE                  "&Deutsch"
  IDS_MI_LANG_FR                  "&Franzsisch"
  IDS_MI_LANG_HU                  "&Ungarisch"
  IDS_MI_LANG_IT                  "&Italienisch"
  IDS_MI_LANG_NL                  "&Hollndisch"
  IDS_MI_LANG_PL                  "&Polnisch"
  IDS_MI_LANG_SV                  "&Schwedisch"
  IDS_MI_LANG_TR                  "&Trkisch"
  IDS_MI_CMDLINE                  "Kommandozeilen &Optionen"
  IDS_MI_CONTRIBUTORS             "VICE Hackers"
  IDS_MI_LICENSE                  "&Lizenz"
  IDS_MI_WARRANTY                 "Keine &Garantie!"
  IDS_MI_TOGGLE_FULLSCREEN        "Vollbild"
  IDS_MI_SIDCART_SETTINGS         "&SID Modul Einstellungen..."
  IDS_MI_MON_OPEN                 "&ffnen"
  IDS_MI_MON_SAVE                 "&Sspeichern"
  IDS_MI_MON_PRINT                "&Drucken"
  IDS_MI_MON_EXIT                 "&Beenden\tAlt+F4"
  IDS_MI_MON_STOP_DEBUG           "&Stop Debug"
  IDS_MI_MON_STOP_EXEC            "Stop &Ausfhrung"
  IDS_MI_MON_STEP_INTO            "Step &in"
  IDS_MI_MON_STEP_OVER            "Step &ber"
  IDS_MI_MON_SKIP_RETURN          "Step bis &return"
  IDS_MI_MON_GOTO_CURSOR          "Gehe zu &cursor"
  IDS_MI_MON_EVAL                 "A&uswerten"
  IDS_MI_MON_CURRENT              "Aktuelle I&nstruktion"
  IDS_MI_MON_WND_EVAL             "Auswertungs&fenster"
  IDS_MI_MON_WND_REG              "&Registerfenster"
  IDS_MI_MON_WND_MEM              "S&peicherfenster"
  IDS_MI_MON_WND_DIS              "Disassemblerfenster"
  IDS_MI_MON_WND_CONSOLE          "&Konsolenfenster"
  IDS_MI_MON_COMPUTER             "&Computer"
  IDS_MI_MON_DRIVE8               "Laufwerk &8"
  IDS_MI_MON_DRIVE9               "Laufwerk &9"
  IDS_MI_MON_CASCADE              "&Kaskadiert"
  IDS_MI_MON_TILE_VERT            "&Vertical anordnen"
  IDS_MI_MON_TILE_HORIZ           "&Horizontal anordnen"
  IDS_MI_MON_ARRANGE_ICONS        "Icons &Anordnen"
END



STRINGTABLE
LANGUAGE LANG_FRENCH, SUBLANG_NEUTRAL
BEGIN
  IDS_VICE_ERROR                  "Erreur VICE!"
  IDS_VICE_INFORMATION            "Information VICE"
  IDS_VICE_QUESTION               "Question VICE"
  IDS_FFMPEG_DLL_MISMATCH         "La version du DLL ffmpeg ne correspond pas."
  IDS_DIRECTDRAW_ERROR            "Erreur DirectDraw: Code:%8x Erreur:%s"
  IDS_CANNOT_SAVE_SETTINGS        "Impossible d'enregistrer les paramtres."
  IDS_CANNOT_LOAD_SETTINGS        "Impossible de charger les paramtres."
  IDS_DEFAULT_SETTINGS_RESTORED   "Paramtres par dfaut restaurs."
  IDS_CANNOT_ATTACH_FILE          "Impossible d'attacher le fichier spcifi"
  IDS_START_MONITOR               "%s\012\012Start monitor? (Non va rinitialiser, canceler va continuer)"
  IDS_VICE_CPU_JAM                "ERREUR CPU VICE"
  IDS_EXTEND_TO_40_TRACKS         "tendre l'image au format 40 pistes?"
  IDS_DETACHED_DEVICE_S           "Priphrique dtach %s"
  IDS_ATTACHED_S_TO_DEVICE_S      "%s attach au priphrique #%s"
  IDS_DETACHED_TAPE               "Datassette dtach"
  IDS_HISTORY_RECORDED_UNKNOWN    "Historique enregistre avec une release inconnue"
  IDS_HISTORY_RECORDED_VICE_S     "Historique enregistre avec VICE-%s"
  IDS_PAUSED                      "en pause"
  IDS_FRAME_NUMBER                "image #"
  IDS_RESUMED                     "rsum"
  IDS_REALLY_EXIT                 "Dsirez-vous vraiment quitter?\012\012Toutes les donnes prsentes dans la mmoire de l'mulateur seront perdues."
  IDS_CANNOT_AUTOSTART_FILE       "Impossible de dmarrer automatiquement le fichier spcifi"
  IDS_ATTACHED_TAPE_S             "Datassette %s attach"
  IDS_SETTINGS_SAVED_SUCCESS      "Sauvegarde des paramtres effectue correctement."
  IDS_SETTINGS_LOADED_SUCCESS     "Chargement des paramtres russi."
  IDS_ATTACH_DISK_IMAGE           "Insrer une image de disque"
  IDS_ATTACH_TAPE_IMAGE           "Insrer une image de datassette"
  IDS_AUTOSTART_IMAGE             "Dmarrer automatiquement une image de disque/datassette"
  IDS_INVALID_CARTRIDGE           "Cartouche invalide"
  IDS_BAD_CARTRIDGE_CONFIG        "Mauvaise configuration de la cartouche dans l'interface utilisateur!"
  IDS_INVALID_CARTRIDGE_IMAGE     "Image de cartouche invalide"
  IDS_LOG_CONSOLE_OUTPUT_IMAGE    "Log de l'image de sortie console"
  IDS_LOG_FILES_TYPE              "Fichier de dbuggage VICE (*.dbg)"
  IDS_CANNOT_WRITE_LOGFILE_S      "Impossible d'crire le fichier log `%s'."
  IDS_LOAD_FLIP_LIST_FILE         "Charger un fichier de groupement de disques"
  IDS_CANNOT_READ_FLIP_LIST       "Cannot read flip list file"
  IDS_SAVE_FLIP_LIST_FILE         "Enregistrer le fichier de groupement de disques actuel"
  IDS_CANNOT_WRITE_FLIP_LIST      "Impossible d'crire le fichier de groupement de disques"
  IDS_SELECT_KEYMAP_FILE          "Slectionner le fichier de mappage clavier"
  IDS_SAVE_KEYMAP_FILE            "Sauvegarder le fichier de mappage clavier"
  IDS_CANNOT_WRITE_KEYMAP_FILE    "Impossible d'crire sur le fichier de mappage clavier"
  IDS_SAVE_CONFIG_FILE            "Save config file"
  IDS_LOAD_CONFIG_FILE            "Load config file"
  IDS_MAPPING                     "Mappage"
  IDS_KEYBOARD_SETTINGS           "Paramtres du clavier"
  IDS_ATTACH                      "&Insrer"
  IDS_PLEASE_ENTER_A_FILENAME     "Entrer un nom de fichier."
  IDS_OVERWRITE_EXISTING_IMAGE    "craser les images existantes?"
  IDS_CANNOT_CREATE_IMAGE         "Impossible de crer l'image"
  IDS_COMMAND_LINE_OPTIONS        "Options de ligne de commande"
  IDS_COMMAND_OPTIONS_AVAIL       "Quelles sont les lignes de commandes disponibles?"
  IDS_NO_DRIVER_SELECT_SUPPORT    "Aucun pilote slectionn, ou le pilote n'est pas support"
  IDS_CANT_WRITE_SCREENSHOT_S     "Impossible d'crire le fichier de capture `%s'."
  IDS_AUTOSTART_DISK_IMAGE        "Dmarrer automatiquement une image de disque"
  IDS_SELECT_FS_DIRECTORY         "Slectionnez le rpertoire du systme de fichiers"
  IDS_PRINTER_USERPORT            "Imprimante Userport"
  IDS_PRINTER_4                   "Imprimante #4"
  IDS_PRINTER_5                   "Imprimante #5"
  IDS_DRIVE_8                     "Lecteur #8"
  IDS_DRIVE_9                     "Lecteur #9"
  IDS_DRIVE_10                    "Lecteur #10"
  IDS_DRIVE_11                    "Lecteur #11"
  IDS_PERIPHERAL_SETTINGS         "Paramtres des priphriques"
  IDS_CANT_WRITE_SNAPSHOT_FILE    "Impossible d'crire le fichier de sauvegarde"
  IDS_CANNOT_READ_SNAPSHOT_IMG    "Impossible de charger l'instantan."
  IDS_LOAD_S_ROM_IMAGE            "Charger image ROM %s"
  IDS_SELECT_ROMSET_ARCHIVE       "Slectionner archive Romset"
  IDS_CANNOT_LOAD_ROMSET_ARCH     "Impossible de charger l'archive Romset!"
  IDS_CANNOT_SAVE_ROMSET_ARCH     "Impossible d'enregistrer l'archive Romset!"
  IDS_CANNOT_LOAD_ROMSET_FILE     "Impossible de charger le fichier Romset!"
  IDS_CANNOT_SAVE_ROMSET_FILE     "Impossible d'enregistrer le fichier Romset!"
  IDS_SELECT_ROMSET_FILE          "Slectionner le fichier Romset"
  IDS_ROMSET                      "Romset"
  IDS_COMPUTER                    "Ordinateur"
  IDS_DRIVE                       "Lecteur"
  IDS_ROM_SETTINGS                "Paramtres ROM"
  IDS_SAVE_SNAPSHOT_IMAGE         "Enregistrer le fichier de sauvegarde"
  IDS_CANNOT_WRITE_SNAPSHOT_S     "Impossible d'crire le fichier de sauvegarde `%s'."
  IDS_LOAD_SNAPSHOT_IMAGE         "Charger le fichier de sauvegarde"
  IDS_COULD_NOT_LOAD_PALETTE      "Impossible de charger le fichier de palette."
  IDS_LOAD_VICE_PALETTE_FILE      "Charger un fichier de palette VICE"
  IDS_FULLSCREEN                  "Plein cran/DirectX"
  IDS_COLORS                      "Couleurs"
  IDS_NEW_PAL                     "New PAL emulation"
  IDS_VIDEO_SETTINGS              "Paramtres vido"
  IDS_FILE_SYSTEM                 "Systme de fichiers"
#ifdef HAVE_OPENCBM
  IDS_REAL_IEC_DEVICE             "Priphrique IEC rel"
#endif
  IDS_RS232_DEVICE_I              "Priphrique RS232 #%i"
  IDS_ATTACH_CRT_CART_IMAGE       "Insrer une cartouche CRT"
  IDS_ATTACH_RAW_8KB_CART_IMAGE   "Insrer une cartouche 8KO"
  IDS_ATTACH_RAW_16KB_CART_IMG    "Insrer une cartouche 16KO"
  IDS_ATTACH_AR_CART_IMAGE        "Insrer une cartouche Action Replay"
  IDS_ATTACH_AR3_CART_IMAGE       "Insrer une cartouche Action Replay III"
  IDS_ATTACH_AR4_CART_IMAGE       "Insrer une cartouche Action Replay 4"
  IDS_ATTACH_STARDOS_CART_IMAGE   "Insrer une cartouche StarDOS"
  IDS_ATTACH_ATOMIC_P_CART_IMG    "Insrer une cartouche Atomic Power"
  IDS_ATTACH_EPYX_FL_CART_IMG     "Insrer une cartouche Epyx FastLoad"
  IDS_ATTACH_IEEE488_CART_IMG     "Insrer une cartouche interface IEEE"
  IDS_ATTACH_RETRO_R_CART_IMG     "Insrer une cartouche Retro Replay"
  IDS_ATTACH_IDE64_CART_IMAGE     "Insrer une cartouche interface IDE64"
  IDS_ATTACH_SS4_CART_IMAGE       "Insrer une cartouche Super Snapshot 4"
  IDS_ATTACH_SS5_CART_IMAGE       "Insrer une cartouche Super Snapshot 5"
  IDS_ATTACH_STB_CART_IMAGE       "Insrer une cartouche Structured Basic"
  IDS_MODEL                       "Modle"
  IDS_DRIVE_SETTINGS              "Paramtres des lecteurs"
  IDS_SELECT_START_SNAP_EVENT     "Slectionner l'instantan de dpart pour l'historique des vnements"
  IDS_SELECT_END_SNAP_EVENT       "Slectionner la sauvegarde de fin pour l'historique des vnements"
#ifdef UNSTABLE
  IDS_VERSION_S_UNSTABLE          "Version %s *INSTABLE* (%s)"
#else
  IDS_VERSION_S                   "Version %s (%s)"
#endif
  IDS_VICE_CONTRIBUTORS           "Contributeurs  VICE"
  IDS_WHO_MADE_WHAT               "Qui fait quoi?"
  IDS_LICENSE                     "License"
  IDS_NO_WARRANTY                 "Aucune garantie!"
  IDS_VICE_WITHOUT_WARRANTY       "VICE est distribu SANS AUCUN GARANTIE!"
  IDS_PRESS_KEY_NORTHWEST         "Appuyer sur la touche pour Nord Ouest"
  IDS_PRESS_KEY_NORTH             "Appuyer sur la touche pour Nord"
  IDS_PRESS_KEY_NORTHEAST         "Appuyer sur la touche pour Nord Est"
  IDS_PRESS_KEY_EAST              "Appuyer sur la touche pour Est"
  IDS_PRESS_KEY_SOUTHEAST         "Appuyer sur la touche pour Sud Est"
  IDS_PRESS_KEY_SOUTH             "Appuyer sur la touche pour Sud"
  IDS_PRESS_KEY_SOUTHWEST         "Appuyer sur la touche pour Sud Ouest"
  IDS_PRESS_KEY_WEST              "Appuyer sur la touche pour Ouest"
  IDS_PRESS_KEY_FIRE              "Appuyer sur la touche pour Bouton de tir"
  IDS_NO_USERPORT_ADAPTER         "No userport joy adapter"
  IDS_CGA_USERPORT_ADAPTER        "CGA userport joy adapter"
  IDS_PET_USERPORT_ADAPTER        "PET userport joy adapter"
  IDS_HUMMER_USERPORT_ADAPTER     "HUMMER userport joy adapter"
  IDS_OEM_USERPORT_ADAPTER        "OEM userport joy adapter"
  IDS_HIT_USERPORT_ADAPTER        "HIT userport joy adapter"
  IDS_NO_SIDCART_JOY              "Disable SIDcart joy"
  IDS_SIDCART_JOY                 "Enable SIDcart joy"
  IDS_NUMPAD_AND_RCTRL            "Clavier numrique + Ctrl Droite"
  IDS_KEYSET_A                    "Touches A"
  IDS_KEYSET_B                    "Touches B"
  IDS_ALL_BUTTONS_AS_FIRE         "Tous les boutons sont utiliss comme boutons de tir"
  IDS_NUMERIC_SEE_ABOVE           "numrique (voir ci-dessus)"
  IDS_NO_BUTTON_NO_AUTOFIRE       "Aucun bouton - Tir automatique dsactiv"
  IDS_ALL_FILES_FILTER            "Tous les fichiers (*.*)"
  IDS_PALETTE_FILES_FILTER        "Fichiers de palette VICE (*.vpl)"
  IDS_SNAPSHOT_FILES_FILTER       "Fichiers de sauvegarde VICE (*.vsf)"
  IDS_CBM_IMAGE_FILES_FILTER      "CBM files (*.d64;*.d71;*.d80;*.d81;*.d82;*.g64;*.g41;*.x64;*.t64;*.tap;*.prg;*.p00)"
  IDS_DISK_IMAGE_FILES_FILTER     "Images de disques (*.d64;*.d71;*.d80;*.d81;*.d82;*.g64;*.g41;*.x64)"
  IDS_TAPE_IMAGE_FILES_FILTER     "Images de datassette (*.t64;*.tap)"
  IDS_ZIPPED_FILES_FILTER         "Fichiers compresss (*.zip;*.bz2;*.gz;*.d6z;*.d7z;*.d8z;*.g6z;*.g4z;*.x6z)"
  IDS_CRT_FILES_FILTER            "Images de cartouches CRT (*.crt)"
  IDS_RAW_CART_FILES_FILTER       "Images brutes de cartouches (*.bin)"
  IDS_FLIP_LIST_FILES_FILTER      "Fichiers de groupement de disques (*.vfl)"
  IDS_ROMSET_FILES_FILTER         "Fichiers Romset VICE (*.vrs)"
  IDS_ROMSET_ARCHIVES_FILTER      "Archives Romset VICE (*.vra)"
  IDS_KEYMAP_FILES_FILTER         "Fichiers de mappage clavier VICE (*.vkm)"
  IDS_PRGP00_FILES_FILTER         "Fichiers dmulation de Commodore (*.prg;*.p00)"
  IDS_FLEXIBLE                    "Flexible"
  IDS_ADJUSTING                   "Ajust"
  IDS_EXACT                       "Exact"
  IDS_SOUND_DRIVER_DIRECTX        "Pilote son: DirectX"
  IDS_SOUND_DRIVER_WMM            "Pilote son: WMM"
  IDS_MEDIA_FILES_FILTER          "Fichiers mdia (*.bmp;*.gif;*.iff;*.jpg;*.pcx;*.png;*.ppm;*.wav;*.mp3;*.avi;*.mpg)"
  IDS_SPACE_KB                    " kO"
  IDS_CONFIGURE_KEYSET_A          "Configurer Touches A"
  IDS_CONFIGURE_KEYSET_B          "Configurer Touches B"
  IDS_SAVE_MEDIA_IMAGE            "Sauvegarder un fichier mdia"
  IDS_S_AT_D_SPEED                "%s  une vitesse de %d%%,  %d img/s%s"
  IDS_TAPE                        "Datassette:"
  IDS_JOYSTICK_C                  "Joystick:"
  IDS_RECORDING                   "Enregistrement\n%02d:%02d"
  IDS_PLAYBACK                    "Lecture\n%02d:%02d (%02d:%02d)"
  IDS_UNKNOWN                     "Inconnu"
  IDS_P_NUMBER                    "<numro>"
  IDS_SET_INPUT_JOYSTICK_1        "Slectionner le priphique branch au port joystick #1"
  IDS_SET_INPUT_JOYSTICK_2        "Slectionner le priphique branch au port joystick #2"
  IDS_SET_INPUT_EXTRA_JOYSTICK_1  "Set input device for extra joystick #1"
  IDS_SET_INPUT_EXTRA_JOYSTICK_2  "Set input device for extra joystick #2"
  IDS_SAVE_SETTINGS_ON_EXIT       "Sauvegarder les paramtres  la sortie"
  IDS_NO_SAVE_SETTINGS_ON_EXIT    "Ne jamais enregistrer les paramtres  la sortie"
  IDS_CONFIRM_QUIT_VICE           "Demander une confirmation avant de quitter VICE"
  IDS_NO_CONFIRM_QUIT_VICE        "Ne pas demander de confirmation pour quitter VICE"
  IDS_USE_ALL_CPU_SMP             "Utiliser tous les processeurs (systmes SMP)"
  IDS_USE_FIRST_CPU_SMP           "N'utiliser que le premier processeur (systmes SMP)"
  IDS_START_VICE_FULLSCREEN_MODE  "Activer le mode plein cran au dmarrage de VICE"
  IDS_DISABLE_DX9                 "Disable DirectX9 video driver"
#ifdef SYS_SIGLIST_DECLARED
  IDS_RECEIVED_SIGNAL_D_S         "An unexpected error occured. Received signal %d (%s)."
#else
  IDS_RECEIVED_SIGNAL_D           "An unexpected error occured. Received signal %d."
#endif
#ifdef HAVE_NETWORK
  IDS_IDLE                        "Inactif"
  IDS_SERVER_LISTENING            "Server listening"
  IDS_CONNECTED_SERVER            "Connect au serveur"
  IDS_CONNECTED_CLIENT            "Client connect"
  IDS_INVALID_PORT_NUMBER         "Numro de port invalide"
  IDS_ERROR_STARTING_SERVER       "Il y a eu une erreur au dmarrage du serveur."
  IDS_ERROR_CONNECTING_CLIENT     "An error occured connecting the client."
#endif
  IDS_SOUND_RECORDING_STARTED     "Sound Recording started..."
  IDS_SOUND_RECORDING_STOPPED     "Sound Recording stopped..."
  IDS_OK                          "OK"
  IDS_CANCEL                      "Annuler"
  IDS_NONE                        "Aucun"
  IDS_BROWSE                      "&Parcourir..."
  IDS_SPECIFY_MIDI_IN             "Specify MIDI-In device"
  IDS_SPECIFY_MIDI_OUT            "Specify MIDI-Out device"
  IDS_ERROR_SAVING_EASYFLASH_CRT  "Error saving EasyFlash crt file"
  IDS_DATASETTE_CAPTION           "Rglages datassette"
  IDS_DATASETTE_RESET_WITH_CPU    "&Rinitialiser la datassette avec l'UCT"
  IDS_DATASETTE_MOTOR_GROUP       "Vitesse du moteur lors de la lecture"
  IDS_DATASETTE_DELAY_TRIGGER     "cycle(s) additionnel(s) &dlai aprs trigger"
  IDS_DATASETTE_DELAY_AT_ZERO     "cycles dlai aux valeurs-&zro"
  IDS_TOGGLE_USEIECDEVICE         "&Utiliser le priphrique IEC"
  IDS_SELECTDISK                  "&Image de disque"
  IDS_SELECTDIR                   "&Rpertoire"
#ifdef HAVE_OPENCBM
  IDS_SELECTREAL                  "Priphrique IEC Rel"
#endif
  IDS_SELECTNONE                  "&Aucun"
  IDS_AUTOSTART                   "&Dmarrage automatique"
  IDS_BROWSEDIR                   "Pa&rcourir..."
  IDS_TOGGLE_ATTACH_READONLY      "Insrer en lecture seule"
  IDS_TOGGLE_READP00              "&Lire les fichier P00"
  IDS_TOGGLE_WRITEP00             "&crire sur les fichier P00"
  IDS_TOGGLE_HIDENONP00           "&Cacher les fichiers non-P00"
  IDS_JOYSTICK_CAPTION            "Paramtres des joysticks"
  IDS_JOYSTICK_IN_PORT_1          "Joystick dans le port #1"
  IDS_SELECT_FIRE_BUTTON          "Slectionner le bouton de feu"
  IDS_AUTO_FIRE_BUTTON_SETTINGS   "Auto fire button settings"
  IDS_AUTOFIRE_SPEED              "Vitesse tir automatique (1..32)"
  IDS_JOYSTICK_IN_PORT_2          "Joystick dans le port #2"
  IDS_JOY_CONFIG_A                "Configurer &A"
  IDS_JOY_CONFIG_B                "Configurer &B"
  IDS_JOY_CALIBRATE               "&Calibration des joystick(s)"
  IDS_EXTRA_JOYSTICK_CAPTION      "Extra joystick adapter settings"
  IDS_JOYSTICK_IN_EXTRA_PORT_1    "Joystick in extra port #&1"
  IDS_JOYSTICK_IN_EXTRA_PORT_2    "Joystick in extra port #&2"
  IDS_KEYSET_SW                   "Su&d Ouest"
  IDS_KEYSET_S                    "&Sud"
  IDS_KEYSET_SE                   "S&ud Est"
  IDS_KEYSET_W                    "&Ouest"
  IDS_KEYSET_E                    "&Est"
  IDS_KEYSET_NW                   "No&rd Ouest"
  IDS_KEYSET_N                    "&Nord"
  IDS_KEYSET_NE                   "N&ord Est"
  IDS_KEYSET_FIRE                 "&Bouton de tir"
  IDS_SOUND_CAPTION               "Configurer les paramtres du priphrique son"
  IDS_SOUND_DIRECTX               "Pilote DirectX"
  IDS_SOUND_WMM                   "Pilote WMM"
  IDS_SOUND_SAMPLE_FREQUENCY      "Frquence d'chantillonage :"
  IDS_SOUND_BUFFER_SIZE           "Taille du &tampon son :"
  IDS_SOUND_FRAGMENT_SIZE_LABEL   "Sound Fragment Size :"
  IDS_SOUND_FRAGMENT_SIZE_SMALL   "Small"
  IDS_SOUND_FRAGMENT_SIZE_MEDIUM  "Medium"
  IDS_SOUND_FRAGMENT_SIZE_LARGE   "Large"
  IDS_SOUND_SYNCH_METHOD          "&Mthode de synchronisation :"
  IDS_TOGGLE_SNAPSHOT_SAVE_DISKS  "Sauvegarder les &disques prsentement insrs"
  IDS_TOGGLE_SNAPSHOT_SAVE_ROMS   "Sauvegarder les images &ROM prsentement chargs"
  IDS_FULLSCREEN_DRIVER           "Pilote:"
  IDS_FULLSCREEN_DRVR_BITDEPTH    "Bitdepth:"
  IDS_FULLSCREEN_DRVR_RESOLUTION  "Rsolution:"
  IDS_FULLSCREEN_DRVR_REFRESHRATE "Taux de rafrachissement:"
  IDS_TOGGLE_VIDEO_VBLANK_SYNC    "Synchronisation VBLANK"
  IDS_TOGGLE_VIDEO_DX_PRIMARY     "Rendu  la surface primaire DX"
  IDS_TOGGLE_KEEP_ASPECT_RATIO    "Keep aspect ratio (0,5..2)"
  IDS_COLORS_SATURATION           "Saturation (0..2)"
  IDS_COLORS_CONTRAST             "Contraste (0..2)"
  IDS_COLORS_BRIGHTNESS           "Luminosit (0..2)"
  IDS_NEW_PAL_TINT                "Tint (0..2)"
  IDS_NEW_PAL_ODD_LINES_PHASE     "Odd lines phase (0..2)"
  IDS_NEW_PAL_ODD_LINES_OFFSET    "Odd lines offset (0..2)"
  IDS_VIDEO_GAMMA                 "Intensit (0..2)"
  IDS_VIDEO_PHASE                 "Phase (0..2)"
  IDS_VIDEO_PAL_SHADE             "Ombrage PAL (0..1)"
  IDS_VIDEO_PAL_BLUR              "Flou PAL (0..1)"
  IDS_TOGGLE_VIDEO_EXTPALETTE     "Palette externe:"
  IDS_RAM_CAPTION                 "Paramtres de la RAM"
  IDS_RAM_INIT_AT_POWERUP         "Initialisation au dmarrage"
  IDS_RAM_VALUE_FIRST_BYTE        "Valeur du premier octet"
  IDS_RAM_LENGTH_CONSTANT_VALUES  "Longeur des valeurs constantes"
  IDS_RAM_LENGTH_CONSTANT_PATTERN "Longeur des contantes pattern"
  IDS_PRINTER_EMULATION           "mulation d'imprimante"
  IDS_PRINTER_FORMFEED            "Envoyer 'Form Feed'"
  IDS_FILESYSTEM_PRINTER          "Imprimante sur systme de fichiers"
  IDS_PRINTER_DRVR                "Pilote d'imprimante"
  IDS_OUTPUT                      "Sortie"
  IDS_OUTPUT_TO_FILE              "Rediriger vers le fichier #"
  IDS_OUTPUT_FILE1_NAME           "Nom du fichier de sortie #1"
  IDS_OUTPUT_FILE2_NAME           "Nom du fichier de sortie #2"
  IDS_OUTPUT_FILE3_NAME           "Nom du fichier de sortie #3"
  IDS_ROMSET_SELECT_ARCHIVE       "Archive Romset"
  IDS_ROMSET_ARCHIVE_LOAD         "Charger archive"
  IDS_ROMSET_ARCHIVE_SAVE         "Sauvegarder archive"
  IDS_ROMSET_CONFIGURATION        "&Configuration"
  IDS_ROMSET_ARCHIVE_APPLY        "Appliquer"
  IDS_ROMSET_ARCHIVE_NEW          "Nouveau"
  IDS_ROMSET_ARCHIVE_DELETE       "Supprimer"
  IDS_ROMSET_SELECT_FILE          "Fichier Romset"
  IDS_ROMSET_FILE_LOAD            "Charger Romset"
  IDS_ROMSET_FILE_SAVE            "Sauvegarder Romset"
  IDS_CUSTOM_SPEED_CAPTION        "Vitesse personnalise"
  IDS_ENTER_CUSTOM_SPEED          "Entrez la vitesse [%]"
  IDS_NEW_CONFIGURATION           "Nouvelle configuration"
  IDS_ENTER_CONFIGURATION_NAME    "Entrer le nom de la configuration"
  IDS_RS232_CAPTION               "Paramtres RS232"
  IDS_RS232_DEV_1                 "1er Priphrique RS232"
  IDS_RS232_DEV_2                 "2e Priphrique RS232"
  IDS_RS232_DEV_3                 "3e Priphrique RS232"
  IDS_RS232_DEV_4                 "4e Priphrique RS232"
  IDS_NETWORK_CAPTION             "Paramtres de jeu en rseau"
  IDS_CURRENT_MODE                "Current mode"
  IDS_SERVER_BIND                 "Server Bind"
  IDS_TCP_PORT                    "Port TCP"
  IDS_NETWORK_SERVER              "Dmarrer le serveur"
  IDS_NETWORK_CLIENT              "Se connecter "
  IDS_NETWORK_DISCONNECT          "Se dconnecter du serveur"
  IDS_CONTROL                     "Control"
  IDS_SERVER                      "Serveur"
  IDS_CLIENT                      "Client"
  IDS_KEYBOARD                    "Keyboard"
  IDS_JOYSTICK_1                  "Joystick 1"
  IDS_JOYSTICK_2                  "Joystick 2"
  IDS_DEVICES                     "Devices"
  IDS_SETTINGS                    "Settings"
  IDS_TOGGLE_CONSOLE_APPEND       "&Ajouter le log au fichier existant"
  IDS_IMAGE_CONTENTS              "Contenu de l'image"
  IDS_NEW_IMAGE                   "Nouvelle image"
  IDS_NAME                        "Nom"
  IDS_ID                          "ID"
  IDS_TYPE                        "Type"
  IDS_BLANK_IMAGE                 "Cration d'image"
  IDS_NEW_TAP_IMAGE               "Nouvelle image TAP"
  IDS_SAVE                        "Enregistrer"
  IDS_SELECT_DRIVER               "Select Driver"
  IDS_FFMPEG_SETTINGS             "FFMPEG settings"
  IDS_FORMAT                      "Format"
  IDS_AUDIO_CODEC                 "Audio codec"
  IDS_BITRATE                     "bitrate"
  IDS_VIDEO_CODEC                 "Video codec"
  IDS_SOUND_RECORD_CAPTION        "Sound record settings"
  IDS_SOUND_RECORD_FORMAT_LABEL   "Sound Record Format"
  IDS_SOUND_RECORD_FILE_LABEL     "Sound Record File"
  IDS_KERNAL                      "Kernal"
  IDS_BASIC                       "Basic"
  IDS_CHARACTER                   "Caractre"
  IDS_COMPUTER_RESOURCES_CAPTION  "Ressources de l'ordinateur"
  IDS_COMPUTER_RESOURCES          "Ressources de l'ordinateur enregistres au Romset"
  IDS_DRIVE_RESOURCES_CAPTION     "Ressources des lecteurs"
  IDS_DRIVE_RESOURCES             "Ressources du lecteur sauvegards dans le Romset"
  IDS_SYMBOLIC                    "&Symbolique"
  IDS_POSITIONAL                  "&Positionnel"
  IDS_DUMP_KEYSET                 "Exporter le mappage clavier dans un fichier"
  IDS_DUMP_SHORTCUTS              "Dump shortcuts"
  IDS_SYMBOLIC_US                 "Symbolique &US"
  IDS_SYMBOLIC_DE                 "Symbolique &DE"
  IDS_GR_SYM                      "&Gr Sym."
  IDS_GR_POS                      "G&r Pos."
  IDS_UK_SYM                      "&UK Sym."
  IDS_UK_POS                      "U&K Pos."
  IDS_DE_SYM                      "&DE Sym."
  IDS_DE_POS                      "D&E Pos."
  IDS_A_MEMORY                    "Taille de la &mmoire"
  IDS_DRIVE_TYPE                  "Type de &lecteur"
  IDS_40_TRACK_HANDLING           "Prise en charge du 40 pistes"
  IDS_SELECT_DRIVE_EXTEND_NEVER   "Ne jamais &tendre"
  IDS_SELECT_DRIVE_EXTEND_ASK     "Demander avant d'tendre"
  IDS_SELECT_DRIVE_EXTEND_ACCESS  "tendre  l'accs"
  IDS_IDLE_METHOD                 "Mthode dinactivit"
  IDS_SELECT_DRIVE_IDLE_TRAP_IDLE "Traper linactivit"
  IDS_SELECT_DRIVE_IDLE_SKIP_CYC  "Sauter des cycles"
  IDS_TOGGLE_DRIVE_PARALLEL_CABLE "Cble &parallle"
  IDS_DRIVE_EXPANSION             "&Expansion de lecteur"
  IDS_TOGGLE_DRIVE_EXPANSION_2000 "$2000-$3FFF &RAM"
  IDS_TOGGLE_DRIVE_EXPANSION_4000 "$&4000-$5FFF RAM"
  IDS_TOGGLE_DRIVE_EXPANSION_6000 "$&6000-$7FFF RAM"
  IDS_TOGGLE_DRIVE_EXPANSION_8000 "$8000-$9FFF RA&M"
  IDS_TOGGLE_DRIVE_EXPANSION_A000 "$&A000-$BFFF RAM"
  IDS_PLUS4_VIC20_MEMORY          "Taille de la &mmoire"
  IDS_SID_GENGROUP1               "SID Engine/Model"
  IDS_SID_FILTERS                 "Filtres SID"
  IDS_MP_FILE                     "&Fichier"
  IDS_MP_ATTACH_DISK_IMAGE        "Insrer une image de &disque"
  IDS_MP_DETACH_DISK_IMAGE        "&Retirer une image de disque"
  IDS_MP_FLIP_LIST                "&Groupement de disques"
  IDS_MP_DATASETTE_CONTROL        "Contr&le datassette"
  IDS_MP_ATTACH_CARTRIDGE_IMAGE   "Insrer une &cartouche..."
  IDS_MP_EXPERT_CARTRIDGE         "Activer les paramtres des cartouches experts"
  IDS_MP_RESET                    "&Rinitialiser"
  IDS_MP_DEBUG                    "&Debug"
#ifdef DEBUG
  IDS_MP_MODE                     "M&ode"
#endif
  IDS_MP_EDIT                     "Edit"
  IDS_MP_SNAPSHOT                 "&Sauvegarde"
  IDS_MP_RECORDING_START_MODE     "Mode de dpart d'enregistrement"
  IDS_MP_OPTIONS                  "&Options"
  IDS_MP_REFRESH_RATE             "Taux de &rafrachissement"
  IDS_MP_MAXIMUM_SPEED            "Vitesse &Maximale"
  IDS_MP_VIDEO_STANDARD           "Standar&d vido"
  IDS_MP_DRIVE_SYNC_FACTOR        "Facteur de s&ynchro du lecteur"
  IDS_MP_SETTINGS                 "&Paramtres"
  IDS_MP_CARTRIDGE_IO_SETTINGS    "Paramtres E/S &cartouche"
  IDS_MP_LANGUAGE                 "&Langage"
  IDS_MP_HELP                     "&Aide"
  IDS_MP_VIEW                     "&Affichage"
  IDS_MP_WINDOW                   "&Fentre"
  IDS_MI_EXIT                     "&Quitter"
  IDS_MI_ABOUT                    " &Propos..."
  IDS_MI_PAUSE                    "&Pause"
  IDS_MI_EDIT_COPY                "&Copy"
  IDS_MI_EDIT_PASTE               "&Paste"
  IDS_MI_AUTOSTART                "Dmarrage &automatique d'une image datassette..."
  IDS_MI_RESET_HARD               "&Physiquement"
  IDS_MI_RESET_SOFT               "&Logiciellement"
  IDS_MI_DRIVE8                   "Lecteur &8"
  IDS_MI_DRIVE9                   "Lecteur &9"
  IDS_MI_DRIVE10                  "Lecteur 1&0"
  IDS_MI_DRIVE11                  "Lecteur 1&1"
  IDS_MI_ATTACH_TAPE              "Insrer une image &datassette..."
  IDS_MI_DETACH_TAPE              "Reti&rer une image datassette"
  IDS_MI_DETACH_ALL               "&Tout"
  IDS_MI_TOGGLE_SOUND             "Lecture &audio"
  IDS_MI_TOGGLE_DOUBLESIZE        "&Taille double"
  IDS_MI_TOGGLE_DOUBLESCAN        "Dou&ble scan"
  IDS_MI_DRIVE_TRUE_EMULATION     "Activer l'mulation &relle des lecteurs"
  IDS_MI_AUTOSTART_HANDLE_TDE     "Handle TDE for autostart"
  IDS_MI_TOGGLE_VIDEOCACHE        "&Cache vido"
  IDS_MI_DRIVE_SETTINGS           "Paramtres des lecteurs..."
  IDS_MI_CART_ATTACH_CRT          "Nom du fichier image CRT..."
  IDS_MI_CART_ATTACH_8KB          "Insrer une image gnrique de 8Ko..."
  IDS_MI_CART_ATTACH_16KB         "Insrer une image gnrique de 16Ko..."
  IDS_MI_CART_ATTACH_AR           "Insrer une cartouche Action Replay..."
  IDS_MI_CART_ATTACH_AR3          "Insrer une cartouche Action Replay III..."
  IDS_MI_CART_ATTACH_AR4          "Insrer une cartouche Action Replay 4..."
  IDS_MI_CART_ATTACH_STARDOS      "Insrer une cartouche StarDOS..."
  IDS_MI_CART_ATTACH_AT           "Insrer une cartouche Atomic Power..."
  IDS_MI_CART_ATTACH_EPYX         "Insrer une cartouche Epyx FastLoad..."
  IDS_MI_CART_ATTACH_IEEE488      "Insrer une cartouche interface IEEE488..."
  IDS_MI_CART_ATTACH_RR           "Insrer une cartouche Retro Replay..."
  IDS_MI_CART_ATTACH_IDE64        "Insrer une cartouche interface IDE64..."
  IDS_MI_CART_ATTACH_SS4          "Insrer une cartouche Super Snapshot 4..."
  IDS_MI_CART_ATTACH_SS5          "Insrer une cartouche Super Snapshot 5..."
  IDS_MI_CART_ATTACH_STB          "Insrer une cartouche Structured &Basic..."
  IDS_MI_FLIP_ADD                 "&Ajouter l'image de disque courante"
  IDS_MI_FLIP_REMOVE              "&Retirer l'image de disque courante"
  IDS_MI_FLIP_NEXT                "Insrer la &prochaine image"
  IDS_MI_FLIP_PREVIOUS            "Insrer l'image p&rcdente"
  IDS_MI_FLIP_LOAD                "&Charger un groupement de disques"
  IDS_MI_FLIP_SAVE                "&Enregistrer le groupement de disques"
  IDS_MI_DATASETTE_STOP           "&Arrt"
  IDS_MI_DATASETTE_START          "&Dmarrer"
  IDS_MI_DATASETTE_FORWARD        "En &avant"
  IDS_MI_DATASETTE_REWIND         "En a&rrire"
  IDS_MI_DATASETTE_RECORD         "Enre&gistrer"
  IDS_MI_DATASETTE_RESET          "Rinitialis&er"
  IDS_MI_DATASETTE_RESET_COUNTER  "Rinialiser le c&ompteur"
  IDS_MI_CART_ENABLE_EXPERT       "Activer"
  IDS_MI_CART_MODE_OFF            "Off"
  IDS_MI_CART_MODE_ON             "On"
  IDS_MI_CART_SET_DEFAULT         "Dfinir cette cartouche par &dfaut"
  IDS_MI_TOGGLE_CART_RESET        "Rinialiser sur c&hangement de cartouche"
  IDS_MI_CART_DETACH              "Retirer une cart&ouche"
  IDS_MI_CART_FREEZE              "Geler la cartouche"
  IDS_MI_MONITOR                  "&Tracer"
#ifdef DEBUG
  IDS_MI_DEBUG_MODE_NORMAL        "&Normal"
  IDS_MI_DEBUG_MODE_SMALL         "&Petit"
  IDS_MI_DEBUG_MODE_HISTORY       "&Historique"
  IDS_MI_DEBUG_MODE_AUTOPLAY      "H&istorique automatique"
  IDS_MI_TOGGLE_MAINCPU_TRACE     "Tracer CPU &Principal"
  IDS_MI_TOGGLE_DRIVE0CPU_TRACE   "Tracer CPU Drive&0"
  IDS_MI_TOGGLE_DRIVE1CPU_TRACE   "Tracer CPU Drive&1"
#endif
  IDS_MI_SNAPSHOT_LOAD            "C&harger un instantan...."
  IDS_MI_SNAPSHOT_SAVE            "E&nregistrer une sauvegarde..."
  IDS_MI_LOADQUICK                "&Charger la sauvegarde rapide"
  IDS_MI_SAVEQUICK                "&Enregistrer la sauvegarde rapide"
  IDS_MI_EVENT_TOGGLE_RECORD      "Dmarrer/Arrter l'historique de l'enre&gistrement"
  IDS_MI_EVENT_TOGGLE_PLAYBACK    "Dmarrer/Arrter l'historique de la &lecture"
  IDS_MI_EVENT_SETMILESTONE       "Lever le Signet d'enregistrement"
  IDS_MI_EVENT_RESETMILESTONE     "Retourner au Signet d'enregistrement"
  IDS_MI_EVENT_START_MODE_SAVE    "&Enregistrer une nouvelle sauvegarde"
  IDS_MI_EVENT_START_MODE_LOAD    "&Charger un instantan"
  IDS_MI_EVENT_START_MODE_RESET   "&Rinitialiser au dmarrage"
  IDS_MI_EVENT_START_MODE_PLAYBCK "&craser la lecture actuelle"
  IDS_MI_EVENT_DIRECTORY          "Slectionnez le rpertoire des captures"
  IDS_MI_MEDIAFILE                "Enregistrer/Arrter fichier mdia..."
  IDS_MI_SOUND_RECORD_START       "Record Sound..."
  IDS_MI_SOUND_RECORD_STOP        "Stop Sound Recording"
  IDS_MI_REFRESH_RATE_AUTO        "&Automatique"
  IDS_MI_MAXIMUM_SPEED_NO_LIMIT   "Aucune &limite"
  IDS_MI_MAXIMUM_SPEED_CUSTOM     "&Personnalis"
  IDS_MI_TOGGLE_WARP_MODE         "&Mode turbo"
  IDS_MI_TOGGLE_ALWAYSONTOP       "Toujours au dessus"
  IDS_MI_TOGGLE_FASTPAL           "PAL Emulation"
  IDS_MI_TOGGLE_SCALE2X           "Scale2x"
  IDS_MI_SWAP_JOYSTICK            "Interchanger les joysticks"
  IDS_MI_SWAP_EXTRA_JOYSTICK      "Swap &Userport joysticks"
  IDS_MI_ALLOW_JOY_OPPOSITE       "Allow opposite joystick directions"
  IDS_MI_JOYKEYS_TOGGLE           "Enable Joy Keys"
  IDS_MI_TOGGLE_VIRTUAL_DEVICES   "Activer les priphriques &virtuels"
  IDS_MI_TOGGLE_EMUID             "&Identification de l'mulateur"
  IDS_MI_MOUSE                    "&Grab mouse events"
  IDS_MI_AUTOSTART_SETTINGS       "&Autostart settings..."
  IDS_MI_VIDEO_SETTINGS           "Paramtres vido..."
  IDS_MI_DEVICEMANAGER            "Paramtres des priphriques..."
  IDS_MI_JOY_SETTINGS             "Paramtres des joysticks..."
  IDS_MI_USERPORT_JOY_SETTINGS    "&Userport joystick settings..."
  IDS_MI_SIDCART_JOY_SETTINGS     "&Sidcart joystick settings..."
  IDS_MI_KEYBOARD_SETTINGS        "Paramtres du clavier..."
  IDS_MI_SOUND_SETTINGS           "Paramtres son..."
  IDS_MI_ROM_SETTINGS             "Paramtres ROM..."
  IDS_MI_RAM_SETTINGS             "Paramtres de la RAM..."
  IDS_MI_DATASETTE_SETTINGS       "Paramtres du datassette..."
  IDS_MI_VICII_SETTINGS           "Paramtres VIC-II..."
  IDS_MI_MOUSE_SETTINGS           "Mo&use settings..."
  IDS_MI_SID_SETTINGS             "Paramtres SID..."
  IDS_MI_RS232_SETTINGS           "Paramtres RS&232..."
  IDS_MI_REU_SETTINGS             "Paramtres RE&U..."
  IDS_MI_GEORAM_SETTINGS          "Paramtres &GEORAM..."
  IDS_MI_RAMCART_SETTINGS         "Paramtres &RAMCART..."
  IDS_MI_DQBB_SETTINGS            "&Double Quick Brown Box settings..."
  IDS_MI_ISEPIC_SETTINGS          "I&sepic settings..."
  IDS_MI_MMC64_SETTINGS           "&MMC64 settings..."
  IDS_MI_MIDI_SETTINGS            "M&IDI settings..."
  IDS_MI_DIGIMAX_SETTINGS         "&DIGIMAX settings..."
  IDS_MI_LIGHTPEN_SETTINGS        "&Lightpen settings..."
  IDS_MI_IDE64_SETTINGS           "Paramtres &IDE64..."
#ifdef HAVE_TFE
  IDS_MI_TFE_SETTINGS             "mulation &Ethernet..."
#endif
  IDS_MI_ACIA_SETTINGS            "Paramtres &ACIA..."
  IDS_MI_RS232USER_SETTINGS       "Paramtres RS&232 userport..."
  IDS_MI_EASYFLASH_SETTINGS       "EasyFlash settings..."
  IDS_MI_SFX_SE_SETTINGS          "SFX Sound Expander settings..."
  IDS_MI_TOGGLE_SFX_SS            "Enable SFX Sound Sampler"
  IDS_MI_SETTINGS_SAVE_FILE       "Save current settings to specified file"
  IDS_MI_SETTINGS_LOAD_FILE       "Load settings from specified file"
  IDS_MI_SETTINGS_SAVE            "&Enregistrer les paramtres courants"
  IDS_MI_SETTINGS_LOAD            "&Charger les paramtres"
  IDS_MI_SETTINGS_DEFAULT         "Rtablir les paramtres par d&faut"
  IDS_MI_SAVE_SETTINGS_ON_EXIT    "Enregistrer les pa&ramtres  la sortie"
  IDS_MI_CONFIRM_ON_EXIT          "&Confirmation  la sortie"
  IDS_MI_LANG_EN                  "&Anglais"
  IDS_MI_LANG_DA                  "D&anish"
  IDS_MI_LANG_DE                  "&Allemand"
  IDS_MI_LANG_FR                  "&Franais"
  IDS_MI_LANG_HU                  "&Hungarian"
  IDS_MI_LANG_IT                  "&Italien"
  IDS_MI_LANG_NL                  "&Hollandais"
  IDS_MI_LANG_PL                  "&Polonais"
  IDS_MI_LANG_SV                  "&Sudois"
  IDS_MI_LANG_TR                  "&Turkish"
  IDS_MI_CMDLINE                  "&Options de ligne de commande"
  IDS_MI_CONTRIBUTORS             "&Contributeurs"
  IDS_MI_LICENSE                  "&License"
  IDS_MI_WARRANTY                 "Aucune &garantie!"
  IDS_MI_TOGGLE_FULLSCREEN        "Priphrique plein cran"
  IDS_MI_SIDCART_SETTINGS         "Paramtres cart &SID..."
  IDS_MI_MON_OPEN                 "&Ouvrir"
  IDS_MI_MON_SAVE                 "&Enregistrer"
  IDS_MI_MON_PRINT                "&Imprimer"
  IDS_MI_MON_EXIT                 "&Quitter\tAlt+F4"
  IDS_MI_MON_STOP_DEBUG           "&Arrter dbug"
  IDS_MI_MON_STOP_EXEC            "Arrter l'e&xcution"
  IDS_MI_MON_STEP_INTO            "Tracer  l'&intrieur"
  IDS_MI_MON_STEP_OVER            "Tracer par de&ssus"
  IDS_MI_MON_SKIP_RETURN          "Sauter jusqu' &return"
  IDS_MI_MON_GOTO_CURSOR          "Aller au &curseur"
  IDS_MI_MON_EVAL                 "val&uer"
  IDS_MI_MON_CURRENT              "Instruction courante"
  IDS_MI_MON_WND_EVAL             "Fentre d'&valuation"
  IDS_MI_MON_WND_REG              "Fentre des &Registres"
  IDS_MI_MON_WND_MEM              "Fentre &mmoire"
  IDS_MI_MON_WND_DIS              "Fentre &Dsassemblage"
  IDS_MI_MON_WND_CONSOLE          "Fentre &Console"
  IDS_MI_MON_COMPUTER             "&Ordinateur"
  IDS_MI_MON_DRIVE8               "Lecteur #&8"
  IDS_MI_MON_DRIVE9               "Lecteur #&9"
  IDS_MI_MON_CASCADE              "&Cascade"
  IDS_MI_MON_TILE_VERT            "Fractionner &verticallement"
  IDS_MI_MON_TILE_HORIZ           "Fractionner &horizontalement"
  IDS_MI_MON_ARRANGE_ICONS        "&Arranger les cones"
END



#pragma code_page(28592)
STRINGTABLE
LANGUAGE LANG_HUNGARIAN, SUBLANG_NEUTRAL
BEGIN
  IDS_VICE_ERROR                  "VICE hiba!"
  IDS_VICE_INFORMATION            "VICE informci"
  IDS_VICE_QUESTION               "VICE krds"
  IDS_FFMPEG_DLL_MISMATCH         "Az ffmpeg.dll verzija nem egyezik."
  IDS_DIRECTDRAW_ERROR            "DirectDraw hiba: kd: %8x hiba: %s"
  IDS_CANNOT_SAVE_SETTINGS        "A belltsok mentse nem sikerlt."
  IDS_CANNOT_LOAD_SETTINGS        "A belltsok betltse nem sikerlt."
  IDS_DEFAULT_SETTINGS_RESTORED   "Alaprtelmezett belltsok visszalltva."
  IDS_CANNOT_ATTACH_FILE          "Nem lehet csatolni a megadott fjlt"
  IDS_START_MONITOR               "%s\n\nMonitorprogram indtsa? (Nem jraindtja, Mgsem folytatja)"
  IDS_VICE_CPU_JAM                "VICE CPU fagys"
  IDS_EXTEND_TO_40_TRACKS         "Kiterjesszem a kpmst 40 svos formtumra?"
  IDS_DETACHED_DEVICE_S           "%s eszkz levlasztva"
  IDS_ATTACHED_S_TO_DEVICE_S      "%s csatolva a #%s szm eszkzhz"
  IDS_DETACHED_TAPE               "Szalag levlasztva"
  IDS_HISTORY_RECORDED_UNKNOWN    "Esemny rgzts ismeretlen verzival kszlt"
  IDS_HISTORY_RECORDED_VICE_S     "Esemny rgzts VICE-%s verzival kszlt"
  IDS_PAUSED                      "sznet"
  IDS_FRAME_NUMBER                "kpkocka #"
  IDS_RESUMED                     "folytats"
  IDS_REALLY_EXIT                 "Biztosan kilp?\012\012Az emullt memria teljes tartalma el fog veszni."
  IDS_CANNOT_AUTOSTART_FILE       "Nem lehet automatikusan elindtani a megadott fjlt."
  IDS_ATTACHED_TAPE_S             "%s szalag csatolva"
  IDS_SETTINGS_SAVED_SUCCESS      "Belltsok sikeresen elmentve."
  IDS_SETTINGS_LOADED_SUCCESS     "Belltsok sikeresen elmentve."
  IDS_ATTACH_DISK_IMAGE           "Lemez kpms csatolsa"
  IDS_ATTACH_TAPE_IMAGE           "Szalag kpms csatolsa"
  IDS_AUTOSTART_IMAGE             "Lemez/szalag kpms automatikus indtsa"
  IDS_INVALID_CARTRIDGE           "rvnytelen cartridge"
  IDS_BAD_CARTRIDGE_CONFIG        "Rossz cartridge konfigurci!"
  IDS_INVALID_CARTRIDGE_IMAGE     "rvnytelen cartridge kpms"
  IDS_LOG_CONSOLE_OUTPUT_IMAGE    "Konzol kimenet naplzsa"
  IDS_LOG_FILES_TYPE              "VICE konzol napl fjlok (*.dbg)"
  IDS_CANNOT_WRITE_LOGFILE_S      "Nem sikerlt a(z) %s naplfjlba rni"
  IDS_LOAD_FLIP_LIST_FILE         "Lemezlista betltse"
  IDS_CANNOT_READ_FLIP_LIST       "Nem lehet olvasni a lemezlista fjlt"
  IDS_SAVE_FLIP_LIST_FILE         "Lemezlista mentse fjlba"
  IDS_CANNOT_WRITE_FLIP_LIST      "Nem sikerlt a lemezlistt fjlba rni"
  IDS_SELECT_KEYMAP_FILE          "Vlasszon billentyzetlekpezs fjlt"
  IDS_SAVE_KEYMAP_FILE            "Billentyzetlekpezs fjlba rsa"
  IDS_CANNOT_WRITE_KEYMAP_FILE    "Nem sikerlt a billentyzetlekpezst fjlba rni"
  IDS_SAVE_CONFIG_FILE            "Konfigurcis fjl rsa"
  IDS_LOAD_CONFIG_FILE            "Konfigurcis fjl betltse"
  IDS_MAPPING                     "Lekpezs"
  IDS_KEYBOARD_SETTINGS           "Billentyzet belltsai"
  IDS_ATTACH                      "&Csatols"
  IDS_PLEASE_ENTER_A_FILENAME     "rjon be egy fjlnevet."
  IDS_OVERWRITE_EXISTING_IMAGE    "Fellrjam a meglv kpmst?"
  IDS_CANNOT_CREATE_IMAGE         "Nem sikerlt a kpmst ltrehozni"
  IDS_COMMAND_LINE_OPTIONS        "Parancssori opcik"
  IDS_COMMAND_OPTIONS_AVAIL       "Milyen parancssori opcik lehetsgesek?"
  IDS_NO_DRIVER_SELECT_SUPPORT    "Nincs meghajt kivlasztva, vagy a kivlasztott nem tmogatott"
  IDS_CANT_WRITE_SCREENSHOT_S     "Nem sikerlt a fnykp rsa %s fjlba."
  IDS_AUTOSTART_DISK_IMAGE        "Lemezkpms automatikus indtsa"
  IDS_SELECT_FS_DIRECTORY         "Vlasszon knyvtrat"
  IDS_PRINTER_USERPORT            "Nyomtat userport"
  IDS_PRINTER_4                   "#4-es nyomtat"
  IDS_PRINTER_5                   "#5-s nyomtat"
  IDS_DRIVE_8                     "#8-as lemezegysg"
  IDS_DRIVE_9                     "#9-es lemezegysg"
  IDS_DRIVE_10                    "#10-es lemezegysg"
  IDS_DRIVE_11                    "#11-es lemezegysg"
  IDS_PERIPHERAL_SETTINGS         "Perifrik belltsai"
  IDS_CANT_WRITE_SNAPSHOT_FILE    "Nem sikerlt a pillanatkp fjl rsa."
  IDS_CANNOT_READ_SNAPSHOT_IMG    "A pillanatkp fjl nem olvashat"
  IDS_LOAD_S_ROM_IMAGE            "%s ROM kpms betltse"
  IDS_SELECT_ROMSET_ARCHIVE       "Vlasszon ROM kszlet archvumot"
  IDS_CANNOT_LOAD_ROMSET_ARCH     "Nem sikerlt a ROM kszlet archvum betltse!"
  IDS_CANNOT_SAVE_ROMSET_ARCH     "Nem sikerlt menteni a ROM kszlet archvumot!"
  IDS_CANNOT_LOAD_ROMSET_FILE     "Nem sikerlt betlteni a ROM kszlet fjlt."
  IDS_CANNOT_SAVE_ROMSET_FILE     "Nem sikerlt menteni a ROM kszlet fjlt."
  IDS_SELECT_ROMSET_FILE          "ROM kszlet fjl kivlasztsa"
  IDS_ROMSET                      "ROM kszlet"
  IDS_COMPUTER                    "Szmtgp"
  IDS_DRIVE                       "Lemezegysg"
  IDS_ROM_SETTINGS                "ROM-ok belltsai"
  IDS_SAVE_SNAPSHOT_IMAGE         "Pillanatkp fjl mentse"
  IDS_CANNOT_WRITE_SNAPSHOT_S     "Nem sikerlt a pillanatkp rsa %s fjlba."
  IDS_LOAD_SNAPSHOT_IMAGE         "Pillanatkp betltse"
  IDS_COULD_NOT_LOAD_PALETTE      "Nem sikerlt a palettt betlteni."
  IDS_LOAD_VICE_PALETTE_FILE      "VICE paletta fjl betltse"
  IDS_FULLSCREEN                  "Teljes kperny/DirectX"
  IDS_COLORS                      "Sznek"
  IDS_NEW_PAL                     "j PAL emulci"
  IDS_VIDEO_SETTINGS              "Vide belltsai"
  IDS_FILE_SYSTEM                 "Fjlrendszer"
#ifdef HAVE_OPENCBM
  IDS_REAL_IEC_DEVICE             "Valdi IEC eszkz"
#endif
  IDS_RS232_DEVICE_I              "%i. RS232 eszkz"
  IDS_ATTACH_CRT_CART_IMAGE       "CRT cartridge kpms csatolsa"
  IDS_ATTACH_RAW_8KB_CART_IMAGE   "Nyers 8KB-os cartridge kpms csatolsa"
  IDS_ATTACH_RAW_16KB_CART_IMG    "Nyers 16KB-os cartridge kpms csatolsa"
  IDS_ATTACH_AR_CART_IMAGE        "Action Replay cartridge kpms csatolsa"
  IDS_ATTACH_AR3_CART_IMAGE       "Action Replay III cartridge kpms csatolsa"
  IDS_ATTACH_AR4_CART_IMAGE       "Action Replay 4 cartridge kpms csatolsa"
  IDS_ATTACH_STARDOS_CART_IMAGE   "StarDOS cartridge kpms csatolsa"
  IDS_ATTACH_ATOMIC_P_CART_IMG    "Atomic Power cartridge kpms csatolsa"
  IDS_ATTACH_EPYX_FL_CART_IMG     "Epyx gyorstlt cartridge kpms csatolsa"
  IDS_ATTACH_IEEE488_CART_IMG     "IEEE interfsz cartridge kpms csatolsa"
  IDS_ATTACH_RETRO_R_CART_IMG     "Retro Replay cartridge kpms csatolsa"
  IDS_ATTACH_IDE64_CART_IMAGE     "IDE64 interfsz kpms csatolsa"
  IDS_ATTACH_SS4_CART_IMAGE       "Super Snapshot 4 cartridge kpms csatolsa"
  IDS_ATTACH_SS5_CART_IMAGE       "Super Snapshot 5 cartridge kpms csatolsa"
  IDS_ATTACH_STB_CART_IMAGE       "Structured Basic cartridge kpms csatolsa"
  IDS_MODEL                       "Modell"
  IDS_DRIVE_SETTINGS              "Lemezegysg belltsai"
  IDS_SELECT_START_SNAP_EVENT     "Vlasszon kezdeti pillanatkpet az esemny rgztshez"
  IDS_SELECT_END_SNAP_EVENT       "Vlasszon vgs pillanatkpet az esemny rgztshez"
#ifdef UNSTABLE
  IDS_VERSION_S_UNSTABLE          "%s verzi *INSTABIL* (%s)"
#else
  IDS_VERSION_S                   "%s verzi (%s)"
#endif
  IDS_VICE_CONTRIBUTORS           "VICE - kzremkdk"
  IDS_WHO_MADE_WHAT               "Ki mit csinlt?"
  IDS_LICENSE                     "Licensz"
  IDS_NO_WARRANTY                 "Nincs garancia!"
  IDS_VICE_WITHOUT_WARRANTY       "A VICE-t garancia nlkl terjesztjk!"
  IDS_PRESS_KEY_NORTHWEST         "Nyomjon egy billentyt szaknyugathoz"
  IDS_PRESS_KEY_NORTH             "Nyomjon egy billentyt szakhoz"
  IDS_PRESS_KEY_NORTHEAST         "Nyomjon egy billentyt szakkelethez"
  IDS_PRESS_KEY_EAST              "Nyomjon egy billentyt kelethez"
  IDS_PRESS_KEY_SOUTHEAST         "Nyomjon egy billentyt Dlkelethez"
  IDS_PRESS_KEY_SOUTH             "Nyomjon egy billentyt dlhez"
  IDS_PRESS_KEY_SOUTHWEST         "Nyomjon egy billentyt dlnyugathoz"
  IDS_PRESS_KEY_WEST              "Nyomjon egy billentyt nyugathoz"
  IDS_PRESS_KEY_FIRE              "Nyomjon egy billentyt a tzgombhoz"
  IDS_NO_USERPORT_ADAPTER         "No userport joy adapter"
  IDS_CGA_USERPORT_ADAPTER        "CGA userport joy adapter"
  IDS_PET_USERPORT_ADAPTER        "PET userport joy adapter"
  IDS_HUMMER_USERPORT_ADAPTER     "HUMMER userport joy adapter"
  IDS_OEM_USERPORT_ADAPTER        "OEM userport joy adapter"
  IDS_HIT_USERPORT_ADAPTER        "HIT userport joy adapter"
  IDS_NO_SIDCART_JOY              "Disable SIDcart joy"
  IDS_SIDCART_JOY                 "Enable SIDcart joy"
  IDS_NUMPAD_AND_RCTRL            "Numerikus + Jobb Ctrl"
  IDS_KEYSET_A                    "'A' gombkszlet"
  IDS_KEYSET_B                    "'B' gombkszlet"
  IDS_ALL_BUTTONS_AS_FIRE         "sszes gomb tzgombknt"
  IDS_NUMERIC_SEE_ABOVE           "Numerikus (lsd fent)"
  IDS_NO_BUTTON_NO_AUTOFIRE       "Nincs gomb - automatikus tz letiltva"
  IDS_ALL_FILES_FILTER            "sszes fjl (*.*)"
  IDS_PALETTE_FILES_FILTER        "VICE paletta fjlok (*.vpl)"
  IDS_SNAPSHOT_FILES_FILTER       "VICE pillanatkp fjlok (*.vsf)"
  IDS_CBM_IMAGE_FILES_FILTER      "CBM files (*.d64;*.d71;*.d80;*.d81;*.d82;*.g64;*.g41;*.x64;*.t64;*.tap;*.prg;*.p00)"
  IDS_DISK_IMAGE_FILES_FILTER     "Lemez kpms fjlok (*.d64;*.d71;*.d80;*.d81;*.d82;*.g64;*.g41;*.x64)"
  IDS_TAPE_IMAGE_FILES_FILTER     "Szalag kpms fjlok (*.t64;*.tap)"
  IDS_ZIPPED_FILES_FILTER         "Tmrtett fjlok (*.zip;*.bz2;*.gz;*.d6z;*.d7z;*.d8z;*.g6z;*.g4z;*.x6z)"
  IDS_CRT_FILES_FILTER            "CRT cartridge kpms fjlok (*.crt)"
  IDS_RAW_CART_FILES_FILTER       "Nyers cartridge kpms fjlok (*.bin)"
  IDS_FLIP_LIST_FILES_FILTER      "VICE lemezlista fjlok (*.vfl)"
  IDS_ROMSET_FILES_FILTER         "VICE ROM kszlet fjlok (*.vrs)"
  IDS_ROMSET_ARCHIVES_FILTER      "VICE ROM kszlet archvumok (*.vra)"
  IDS_KEYMAP_FILES_FILTER         "VICE billentylekpezs fjlok (*.vkm)"
  IDS_PRGP00_FILES_FILTER         "Commodore emultor fjlok (*.prg; *.p00)"
  IDS_FLEXIBLE                    "Rugalmas"
  IDS_ADJUSTING                   "Igazod"
  IDS_EXACT                       "Pontos"
  IDS_SOUND_DRIVER_DIRECTX        "Hang meghajt: DirectX"
  IDS_SOUND_DRIVER_WMM            "Hang meghajt: WMM"
  IDS_MEDIA_FILES_FILTER          "Mdia fjlok (*.bmp;*.gif;*.iff;*.jpg;*.pcx;*.png;*.ppm;*.wav;*.mp3;*.avi;*.mpg)"
  IDS_SPACE_KB                    " kB"
  IDS_CONFIGURE_KEYSET_A          "'A' gombkszlet belltsa"
  IDS_CONFIGURE_KEYSET_B          "'B' gombkszlet belltsa"
  IDS_SAVE_MEDIA_IMAGE            "Fnykp ksztse"
  IDS_S_AT_D_SPEED                "%s %d%% sebessgen, %d fps%s"
  IDS_TAPE                        "Szalag:"
  IDS_JOYSTICK_C                  "Botkormny:"
  IDS_RECORDING                   "Felvtel\n%02d:%02d"
  IDS_PLAYBACK                    "Visszajtszs\n%02d:%02d (%02d:%02d)"
  IDS_UNKNOWN                     "Ismeretlen"
  IDS_P_NUMBER                    "<szm>"
  IDS_SET_INPUT_JOYSTICK_1        "Port 1-es botkormny eszkz megadsa"
  IDS_SET_INPUT_JOYSTICK_2        "Port 2-es botkormny eszkz megadsa"
  IDS_SET_INPUT_EXTRA_JOYSTICK_1  "Set input device for extra joystick #1"
  IDS_SET_INPUT_EXTRA_JOYSTICK_2  "Set input device for extra joystick #2"
  IDS_SAVE_SETTINGS_ON_EXIT       "Belltsok (erforrsok) mentse kilpskor"
  IDS_NO_SAVE_SETTINGS_ON_EXIT    "Sose mentse a belltsokat (erforrsokat) kilpskor"
  IDS_CONFIRM_QUIT_VICE           "Megersts kilps eltt"
  IDS_NO_CONFIRM_QUIT_VICE        "Sosem kr megerstst kilps eltt"
  IDS_USE_ALL_CPU_SMP             "SMP rendszereken az sszes CPU hasznlata"
  IDS_USE_FIRST_CPU_SMP           "SMP rendszereken csak az els CPU hasznlata"
  IDS_START_VICE_FULLSCREEN_MODE  "A VICE indtsa teljes kpernys mdban"
  IDS_DISABLE_DX9                 "Disable DirectX9 video driver"
#ifdef SYS_SIGLIST_DECLARED
  IDS_RECEIVED_SIGNAL_D_S         "Vratlan hiba trtnt. %d szignl rkezett (%s)."
#else
  IDS_RECEIVED_SIGNAL_D           "Vratlan hiba trtnt. %d szignl rkezett."
#endif
#ifdef HAVE_NETWORK
  IDS_IDLE                        "Ttlen"
  IDS_SERVER_LISTENING            "Vrakozs kliensre"
  IDS_CONNECTED_SERVER            "Kapcsoldva kiszolglhoz"
  IDS_CONNECTED_CLIENT            "Kliens a kapcsolatban"
  IDS_INVALID_PORT_NUMBER         "rvnytelen port szm"
  IDS_ERROR_STARTING_SERVER       "Hiba trtnt a jtk kiszolgl indtsakor."
  IDS_ERROR_CONNECTING_CLIENT     "Hiba trtnt a kapcsoldskor."
#endif
  IDS_SOUND_RECORDING_STARTED     "Hangfelvtel elindtva..."
  IDS_SOUND_RECORDING_STOPPED     "Hangfelvtel lelltva..."
  IDS_OK                          "OK"
  IDS_CANCEL                      "Mgsem"
  IDS_NONE                        "Nincs"
  IDS_BROWSE                      "&Tallzs..."
  IDS_SPECIFY_MIDI_IN             "Adja meg a MIDI-In eszkzt"
  IDS_SPECIFY_MIDI_OUT            "Adja meg a MIDI-Out eszkzt"
  IDS_ERROR_SAVING_EASYFLASH_CRT  "Error saving EasyFlash crt file"
  IDS_DATASETTE_CAPTION           "Magn belltsai"
  IDS_DATASETTE_RESET_WITH_CPU    "&Alaphelyzetbe hozs CPU Reset esetn"
  IDS_DATASETTE_MOTOR_GROUP       "Motor sebessge olvass kzben"
  IDS_DATASETTE_DELAY_TRIGGER     "ciklus tbblet sznet minden jelzsnl"
  IDS_DATASETTE_DELAY_AT_ZERO     "ciklus sznet &nulla rtkeknl"
  IDS_TOGGLE_USEIECDEVICE         "&IEC eszkz &hasznlata"
  IDS_SELECTDISK                  "Lemez &kpms"
  IDS_SELECTDIR                   "K&nyvtr"
#ifdef HAVE_OPENCBM
  IDS_SELECTREAL                  "&Valdi IEC eszkz"
#endif
  IDS_SELECTNONE                  "&Nincs"
  IDS_AUTOSTART                   "&Automatikus indts"
  IDS_BROWSEDIR                   "&Tallzs..."
  IDS_TOGGLE_ATTACH_READONLY      "Csatols csak olvashat mdon"
  IDS_TOGGLE_READP00              "P00 fjlok &betltse"
  IDS_TOGGLE_WRITEP00             "P00 fjlok &mentse"
  IDS_TOGGLE_HIDENONP00           "Nem P00 fjlok &elrejtse"
  IDS_JOYSTICK_CAPTION            "Botkormny belltsa"
  IDS_JOYSTICK_IN_PORT_1          "Botkormny az &1-es porton"
  IDS_SELECT_FIRE_BUTTON          "Vlasszon tz gombot"
  IDS_AUTO_FIRE_BUTTON_SETTINGS   "Automatikus tz belltsai"
  IDS_AUTOFIRE_SPEED              "Automatikus tz &sebessge (1..32)"
  IDS_JOYSTICK_IN_PORT_2          "Botkormny a &2-es porton"
  IDS_JOY_CONFIG_A                "'&A' gombkszlet belltsa"
  IDS_JOY_CONFIG_B                "'&B' gombkszlet belltsa"
  IDS_JOY_CALIBRATE               "Botkormny(ok) &kalibrlsa"
  IDS_EXTRA_JOYSTICK_CAPTION      "Extra joystick adapter settings"
  IDS_JOYSTICK_IN_EXTRA_PORT_1    "Joystick in extra port #&1"
  IDS_JOYSTICK_IN_EXTRA_PORT_2    "Joystick in extra port #&2"
  IDS_KEYSET_SW                   "Dln&yugat"
  IDS_KEYSET_S                    "&Dl"
  IDS_KEYSET_SE                   "Dlke&let"
  IDS_KEYSET_W                    "&Nyugat"
  IDS_KEYSET_E                    "&Kelet"
  IDS_KEYSET_NW                   "szaknyu&gat"
  IDS_KEYSET_N                    "&szak"
  IDS_KEYSET_NE                   "szakk&elet"
  IDS_KEYSET_FIRE                 "&Tzgomb"
  IDS_SOUND_CAPTION               "Hang eszkz belltsa"
  IDS_SOUND_DIRECTX               "DirectX meghajt"
  IDS_SOUND_WMM                   "WMM meghajt"
  IDS_SOUND_SAMPLE_FREQUENCY      "Mintavtelezsi &frekvencia:"
  IDS_SOUND_BUFFER_SIZE           "Hang puffer &mret:"
  IDS_SOUND_FRAGMENT_SIZE_LABEL   "Sound Fragment Size :"
  IDS_SOUND_FRAGMENT_SIZE_SMALL   "Small"
  IDS_SOUND_FRAGMENT_SIZE_MEDIUM  "Medium"
  IDS_SOUND_FRAGMENT_SIZE_LARGE   "Large"
  IDS_SOUND_SYNCH_METHOD          "Szinkronizci mdja:"
  IDS_TOGGLE_SNAPSHOT_SAVE_DISKS  "A jelenleg csatolt lemezek &mentse"
  IDS_TOGGLE_SNAPSHOT_SAVE_ROMS   "A jelenleg betlttt &ROM-ok mentse"
  IDS_FULLSCREEN_DRIVER           "Meghajt:"
  IDS_FULLSCREEN_DRVR_BITDEPTH    "Bitmlysg:"
  IDS_FULLSCREEN_DRVR_RESOLUTION  "Felbonts:"
  IDS_FULLSCREEN_DRVR_REFRESHRATE "Frisstsi rta:"
  IDS_TOGGLE_VIDEO_VBLANK_SYNC    "VBLANK szinkronizci"
  IDS_TOGGLE_VIDEO_DX_PRIMARY     "Rajzols a DX elsdleges felletre"
  IDS_TOGGLE_KEEP_ASPECT_RATIO    "Keep aspect ratio (0,5..2)"
  IDS_COLORS_SATURATION           "Teltettsg (0..2)"
  IDS_COLORS_CONTRAST             "Kontraszt (0..2)"
  IDS_COLORS_BRIGHTNESS           "Fnyessg (0..2)"
  IDS_NEW_PAL_TINT                "Szn (0..2)"
  IDS_NEW_PAL_ODD_LINES_PHASE     "Pratlan sorok fzisa (0..2)"
  IDS_NEW_PAL_ODD_LINES_OFFSET    "Pratlan sorok offszete (0..2)"
  IDS_VIDEO_GAMMA                 "Gamma (0..2)"
  IDS_VIDEO_PHASE                 "Fzis (0..2)"
  IDS_VIDEO_PAL_SHADE             "PAL pszta rnyals (0..1)"
  IDS_VIDEO_PAL_BLUR              "PAL elmoss (0..1)"
  IDS_TOGGLE_VIDEO_EXTPALETTE     "Kls paletta:"
  IDS_RAM_CAPTION                 "RAM belltsai"
  IDS_RAM_INIT_AT_POWERUP         "Alaphelyzetbe llts bekapcsolskor"
  IDS_RAM_VALUE_FIRST_BYTE        "Els bjt rtke"
  IDS_RAM_LENGTH_CONSTANT_VALUES  "lland rtkek hossza"
  IDS_RAM_LENGTH_CONSTANT_PATTERN "lland minta hossza"
  IDS_PRINTER_EMULATION           "Nyomtat emulci"
  IDS_PRINTER_FORMFEED            "Lapdobs kldse"
  IDS_FILESYSTEM_PRINTER          "Fjlrendszer nyomtat"
  IDS_PRINTER_DRVR                "Nyomtat meghajt"
  IDS_OUTPUT                      "Kimenet"
  IDS_OUTPUT_TO_FILE              "Kimenet fjlba"
  IDS_OUTPUT_FILE1_NAME           "1-es kimeneti fjl"
  IDS_OUTPUT_FILE2_NAME           "2-es kimeneti fjl"
  IDS_OUTPUT_FILE3_NAME           "3-as kimeneti fjl"
  IDS_ROMSET_SELECT_ARCHIVE       "ROM kszlet archvum"
  IDS_ROMSET_ARCHIVE_LOAD         "Archvum betltse"
  IDS_ROMSET_ARCHIVE_SAVE         "Archvum mentse"
  IDS_ROMSET_CONFIGURATION        "&Konfigurci"
  IDS_ROMSET_ARCHIVE_APPLY        "Alkalmaz"
  IDS_ROMSET_ARCHIVE_NEW          "j"
  IDS_ROMSET_ARCHIVE_DELETE       "Trls"
  IDS_ROMSET_SELECT_FILE          "ROM kszlet fjl"
  IDS_ROMSET_FILE_LOAD            "ROM kszlet betltse"
  IDS_ROMSET_FILE_SAVE            "ROM kszlet mentse"
  IDS_CUSTOM_SPEED_CAPTION        "Egyni sebessg"
  IDS_ENTER_CUSTOM_SPEED          "Adja meg a sebessget [%]"
  IDS_NEW_CONFIGURATION           "j konfigurci"
  IDS_ENTER_CONFIGURATION_NAME    "rja be a konfigurci nevt"
  IDS_RS232_CAPTION               "RS232 belltsai"
  IDS_RS232_DEV_1                 "RS232 1-es eszkz"
  IDS_RS232_DEV_2                 "RS232 2-es eszkz"
  IDS_RS232_DEV_3                 "RS232 3-as eszkz"
  IDS_RS232_DEV_4                 "RS232 4-es eszkz"
  IDS_NETWORK_CAPTION             "Hlzati jtk belltsai"
  IDS_CURRENT_MODE                "Jelenlegi md"
  IDS_SERVER_BIND                 "Server Bind"
  IDS_TCP_PORT                    "TCP-Port"
  IDS_NETWORK_SERVER              "Kiszolgl indtsa"
  IDS_NETWORK_CLIENT              "Kapcsolds ehhez:"
  IDS_NETWORK_DISCONNECT          "Sztkapcsolds"
  IDS_CONTROL                     "Vezrl"
  IDS_SERVER                      "Kiszolgl"
  IDS_CLIENT                      "Kliens"
  IDS_KEYBOARD                    "Billentyzet"
  IDS_JOYSTICK_1                  "Botkormny 1"
  IDS_JOYSTICK_2                  "Botkormny 2"
  IDS_DEVICES                     "Eszkzk"
  IDS_SETTINGS                    "Belltsok"
  IDS_TOGGLE_CONSOLE_APPEND       "N&aplfjl hozzfzse a meglvhz"
  IDS_IMAGE_CONTENTS              "Kpms tartalma"
  IDS_NEW_IMAGE                   "j kpms"
  IDS_NAME                        "Nv"
  IDS_ID                          "ID"
  IDS_TYPE                        "Tpus"
  IDS_BLANK_IMAGE                 "Kpms ltrehozsa"
  IDS_NEW_TAP_IMAGE               "j TAP kpms"
  IDS_SAVE                        "Ments"
  IDS_SELECT_DRIVER               "Vlasszon meghajtt"
  IDS_FFMPEG_SETTINGS             "FFMPEG belltsai"
  IDS_FORMAT                      "Formtum"
  IDS_AUDIO_CODEC                 "Audi kodek"
  IDS_BITRATE                     "bitrta"
  IDS_VIDEO_CODEC                 "Vide kodek"
  IDS_SOUND_RECORD_CAPTION        "Sound record settings"
  IDS_SOUND_RECORD_FORMAT_LABEL   "Hangfelvtel formtuma"
  IDS_SOUND_RECORD_FILE_LABEL     "Hangfelvtel fjl..."
  IDS_KERNAL                      "Kernal"
  IDS_BASIC                       "Basic"
  IDS_CHARACTER                   "Karakter"
  IDS_COMPUTER_RESOURCES_CAPTION  "Szmtgp erforrsai"
  IDS_COMPUTER_RESOURCES          "Szmtgp erforrsai elmentve a ROM kszletbe"
  IDS_DRIVE_RESOURCES_CAPTION     "Lemezegysg erforrsai"
  IDS_DRIVE_RESOURCES             "Lemezegysgek erforrsai elmentve a ROM kszletbe"
  IDS_SYMBOLIC                    "&Szimbolikus"
  IDS_POSITIONAL                  "&Pozci szerinti"
  IDS_DUMP_KEYSET                 "Billentyzetlekpzs fjlba rsa"
  IDS_DUMP_SHORTCUTS              "Rvidtsek kirsa"
  IDS_SYMBOLIC_US                 "&Szimbolikus US"
  IDS_SYMBOLIC_DE                 "&Szimbolikus DE"
  IDS_GR_SYM                      "&Gr szim."
  IDS_GR_POS                      "G&r poz."
  IDS_UK_SYM                      "&UK szim."
  IDS_UK_POS                      "U&K poz."
  IDS_DE_SYM                      "&DE szim."
  IDS_DE_POS                      "D&E poz."
  IDS_A_MEMORY                    "&Memria"
  IDS_DRIVE_TYPE                  "&Lemezegysg tpus"
  IDS_40_TRACK_HANDLING           "40 &svos kpms kezelse"
  IDS_SELECT_DRIVE_EXTEND_NEVER   "Nincs kiterjeszts"
  IDS_SELECT_DRIVE_EXTEND_ASK     "Krds kiterjeszts esetn"
  IDS_SELECT_DRIVE_EXTEND_ACCESS  "Kiterjeszts hozzfrskor"
  IDS_IDLE_METHOD                 "res&jrat md"
  IDS_SELECT_DRIVE_IDLE_TRAP_IDLE "res ciklusok kihagysa"
  IDS_SELECT_DRIVE_IDLE_SKIP_CYC  "Ciklusok kihagysa"
  IDS_TOGGLE_DRIVE_PARALLEL_CABLE "&Prhuzamos kbel"
  IDS_DRIVE_EXPANSION             "Lemezegysg &bvts"
  IDS_TOGGLE_DRIVE_EXPANSION_2000 "$2000-$3FFF &RAM"
  IDS_TOGGLE_DRIVE_EXPANSION_4000 "$&4000-$5FFF RAM"
  IDS_TOGGLE_DRIVE_EXPANSION_6000 "$&6000-$7FFF RAM"
  IDS_TOGGLE_DRIVE_EXPANSION_8000 "$8000-$9FFF RA&M"
  IDS_TOGGLE_DRIVE_EXPANSION_A000 "$&A000-$BFFF RAM"
  IDS_PLUS4_VIC20_MEMORY          "&Memria"
  IDS_SID_GENGROUP1               "SID Engine/Model"
  IDS_SID_FILTERS                 "SID szrk"
  IDS_MP_FILE                     "&Fjl"
  IDS_MP_ATTACH_DISK_IMAGE        "Lemezkpms csatolsa"
  IDS_MP_DETACH_DISK_IMAGE        "Lemezkpms &levlasztsa"
  IDS_MP_FLIP_LIST                "Lemezl&ista"
  IDS_MP_DATASETTE_CONTROL        "Magn &vezrls"
  IDS_MP_ATTACH_CARTRIDGE_IMAGE   "Cartridge kpms csatolsa..."
  IDS_MP_EXPERT_CARTRIDGE         "Expert cartridge"
  IDS_MP_RESET                    "j&raindts"
  IDS_MP_DEBUG                    "&Nyomkvets"
#ifdef DEBUG
  IDS_MP_MODE                     "M&d"
#endif
  IDS_MP_EDIT                     "&Szerkeszt"
  IDS_MP_SNAPSHOT                 "&Pillanatkp"
  IDS_MP_RECORDING_START_MODE     "Rgzts indtsnak mdja"
  IDS_MP_OPTIONS                  "&Opcik"
  IDS_MP_REFRESH_RATE             "Frisstsi &rta"
  IDS_MP_MAXIMUM_SPEED            "&Maximlis sebessg"
  IDS_MP_VIDEO_STANDARD           "Vide &szabvny"
  IDS_MP_DRIVE_SYNC_FACTOR        "Lemezegysg sz&inkron faktor"
  IDS_MP_SETTINGS                 "B&elltsok"
  IDS_MP_CARTRIDGE_IO_SETTINGS    "&Cartridge/IO belltsai"
  IDS_MP_LANGUAGE                 "&Nyelv"
  IDS_MP_HELP                     "&Sg"
  IDS_MP_VIEW                     "&Nzet"
  IDS_MP_WINDOW                   "&Ablak"
  IDS_MI_EXIT                     "&Kilps"
  IDS_MI_ABOUT                    "&Nvjegy..."
  IDS_MI_PAUSE                    "&Sznet"
  IDS_MI_EDIT_COPY                "&Msol"
  IDS_MI_EDIT_PASTE               "&Beilleszt"
  IDS_MI_AUTOSTART                "Lemez/szalag kpms &automatikus indtsa..."
  IDS_MI_RESET_HARD               "&Hideg"
  IDS_MI_RESET_SOFT               "&Meleg"
  IDS_MI_DRIVE8                   "&8-as lemezegysg"
  IDS_MI_DRIVE9                   "&9-as lemezegysg"
  IDS_MI_DRIVE10                  "1&0-as lemezegysg"
  IDS_MI_DRIVE11                  "1&1-as lemezegysg"
  IDS_MI_ATTACH_TAPE              "&Szalag kpms csatolsa..."
  IDS_MI_DETACH_TAPE              "Sz&alag kpms levlasztsa"
  IDS_MI_DETACH_ALL               "&Mindegyik"
  IDS_MI_TOGGLE_SOUND             "&Hangok engedlyezse"
  IDS_MI_TOGGLE_DOUBLESIZE        "&Dupla mret"
  IDS_MI_TOGGLE_DOUBLESCAN        "Du&pla psztzs"
  IDS_MI_DRIVE_TRUE_EMULATION     "&Igazi lemezegysg emulci"
  IDS_MI_AUTOSTART_HANDLE_TDE     "Handle TDE for autostart"
  IDS_MI_TOGGLE_VIDEOCACHE        "Vide gyorsttr"
  IDS_MI_DRIVE_SETTINGS           "&Lemezegysg belltsai..."
  IDS_MI_CART_ATTACH_CRT          "&CRT kpms..."
  IDS_MI_CART_ATTACH_8KB          "ltalnos &8KB kpms..."
  IDS_MI_CART_ATTACH_16KB         "ltalnos &16KB kpms..."
  IDS_MI_CART_ATTACH_AR           "&Action Replay kpms..."
  IDS_MI_CART_ATTACH_AR3          "&Action Replay 3 kpms..."
  IDS_MI_CART_ATTACH_AR4          "&Action Replay 4 kpms..."
  IDS_MI_CART_ATTACH_STARDOS      "&StarDOS kpms..."
  IDS_MI_CART_ATTACH_AT           "Atomic &Power kpms..."
  IDS_MI_CART_ATTACH_EPYX         "&Epyx gyorstlt kpms..."
  IDS_MI_CART_ATTACH_IEEE488      "&IEEE488 interfsz kpms..."
  IDS_MI_CART_ATTACH_RR           "&Retro Replay kpms..."
  IDS_MI_CART_ATTACH_IDE64        "IDE&64 interfsz kpms..."
  IDS_MI_CART_ATTACH_SS4          "Super Snapshot &4 kpms..."
  IDS_MI_CART_ATTACH_SS5          "Super Snapshot &5 kpms..."
  IDS_MI_CART_ATTACH_STB          "Structured &Basic kpms..."
  IDS_MI_FLIP_ADD                 "Az aktulis kpms hozzadsa"
  IDS_MI_FLIP_REMOVE              "Az aktulis kpms eltvoltsa"
  IDS_MI_FLIP_NEXT                "&Kvetkez kpms csatolsa"
  IDS_MI_FLIP_PREVIOUS            "&Elz kpms csatolsa"
  IDS_MI_FLIP_LOAD                "&Lemezlista betltse"
  IDS_MI_FLIP_SAVE                "Lemezlista ment&se"
  IDS_MI_DATASETTE_STOP           "&Lellts"
  IDS_MI_DATASETTE_START          "&Indts"
  IDS_MI_DATASETTE_FORWARD        "&Elrecsvls"
  IDS_MI_DATASETTE_REWIND         "&Visszacsvls"
  IDS_MI_DATASETTE_RECORD         "Felvtel"
  IDS_MI_DATASETTE_RESET          "A&laphelyzet"
  IDS_MI_DATASETTE_RESET_COUNTER  "Szmll &nullzsa"
  IDS_MI_CART_ENABLE_EXPERT       "Engedlyezs"
  IDS_MI_CART_MODE_OFF            "Ki"
  IDS_MI_CART_MODE_ON             "Be"
  IDS_MI_CART_SET_DEFAULT         "Cartridge &alaprtelmezett ttele"
  IDS_MI_TOGGLE_CART_RESET        "jraindts cartridge &csernl"
  IDS_MI_CART_DETACH              "Cartridge kpms &levlasztsa"
  IDS_MI_CART_FREEZE              "&Fagyaszts Cartridge-dzsel"
  IDS_MI_MONITOR                  "&Monitor"
#ifdef DEBUG
  IDS_MI_DEBUG_MODE_NORMAL        "&Norml"
  IDS_MI_DEBUG_MODE_SMALL         "&Kicsi"
  IDS_MI_DEBUG_MODE_HISTORY       "&Elzmnyek"
  IDS_MI_DEBUG_MODE_AUTOPLAY      "E&lzmnyek lejtszsa"
  IDS_MI_TOGGLE_MAINCPU_TRACE     "&F CPU kvetse"
  IDS_MI_TOGGLE_DRIVE0CPU_TRACE   "&0. lemezegysg CPU kvetse"
  IDS_MI_TOGGLE_DRIVE1CPU_TRACE   "&1. lemezegysg CPU kvetse"
#endif
  IDS_MI_SNAPSHOT_LOAD            "Pillanatkp &betltse..."
  IDS_MI_SNAPSHOT_SAVE            "Pillanatkp &mentse..."
  IDS_MI_LOADQUICK                "Gyors pillanatkp &betltse"
  IDS_MI_SAVEQUICK                "Gyors pillanatkp fjl &mentse"
  IDS_MI_EVENT_TOGGLE_RECORD      "Esemny &felvtel indtsa/lelltsa"
  IDS_MI_EVENT_TOGGLE_PLAYBACK    "Esemny &visszajtszs indtsa/lelltsa"
  IDS_MI_EVENT_SETMILESTONE       "Kilmterk elhelyezse a felvtelben"
  IDS_MI_EVENT_RESETMILESTONE     "Visszatrs az elz kilmterkhz"
  IDS_MI_EVENT_START_MODE_SAVE    "j pillanatkp &mentse"
  IDS_MI_EVENT_START_MODE_LOAD    "Ltez pillanatkp &betltse"
  IDS_MI_EVENT_START_MODE_RESET   "Induls &RESET-tel egytt"
  IDS_MI_EVENT_START_MODE_PLAYBCK "A visszajtszs &fellrsa"
  IDS_MI_EVENT_DIRECTORY          "Vlassza ki a felvteleket/knyvtrat"
  IDS_MI_MEDIAFILE                "Vide ksztse/meglltsa..."
  IDS_MI_SOUND_RECORD_START       "Hang felvtele..."
  IDS_MI_SOUND_RECORD_STOP        "Hangfelvtel lelltsa"
  IDS_MI_REFRESH_RATE_AUTO        "&Automatikus"
  IDS_MI_MAXIMUM_SPEED_NO_LIMIT   "Nincs &hatr"
  IDS_MI_MAXIMUM_SPEED_CUSTOM     "&Egyni"
  IDS_MI_TOGGLE_WARP_MODE         "&Hipergyors md"
  IDS_MI_TOGGLE_ALWAYSONTOP       "Mindig fell"
  IDS_MI_TOGGLE_FASTPAL           "PAL emulci"
  IDS_MI_TOGGLE_SCALE2X           "lsimts"
  IDS_MI_SWAP_JOYSTICK            "Botkormnyok &felcserlse"
  IDS_MI_SWAP_EXTRA_JOYSTICK      "Swap &Userport joysticks"
  IDS_MI_ALLOW_JOY_OPPOSITE       "Allow opposite joystick directions"
  IDS_MI_JOYKEYS_TOGGLE           "Botkormny gombok engedlyezse"
  IDS_MI_TOGGLE_VIRTUAL_DEVICES   "&Virtulis eszkzk ciklus kihagysa"
  IDS_MI_TOGGLE_EMUID             "Emultor &azonost"
  IDS_MI_MOUSE                    "Egr &esemnyek elkapsa"
  IDS_MI_AUTOSTART_SETTINGS       "&Autostart settings..."
  IDS_MI_VIDEO_SETTINGS           "&Vide belltsai..."
  IDS_MI_DEVICEMANAGER            "&Perifrik belltsai..."
  IDS_MI_JOY_SETTINGS             "B&otkormny belltsai..."
  IDS_MI_USERPORT_JOY_SETTINGS    "&Userport joystick settings..."
  IDS_MI_SIDCART_JOY_SETTINGS     "&Sidcart joystick settings..."
  IDS_MI_KEYBOARD_SETTINGS        "&Billentyzet belltsai..."
  IDS_MI_SOUND_SETTINGS           "Hang belltsok..."
  IDS_MI_ROM_SETTINGS             "&ROM-ok belltsai..."
  IDS_MI_RAM_SETTINGS             "RA&M belltsai..."
  IDS_MI_DATASETTE_SETTINGS       "M&agn belltsai..."
  IDS_MI_VICII_SETTINGS           "VIC-II belltsai..."
  IDS_MI_MOUSE_SETTINGS           "Egr &belltsai..."
  IDS_MI_SID_SETTINGS             "S&ID belltsai..."
  IDS_MI_RS232_SETTINGS           "RS&232 belltsai..."
  IDS_MI_REU_SETTINGS             "&REU belltsai..."
  IDS_MI_GEORAM_SETTINGS          "&GEORAM belltsai..."
  IDS_MI_RAMCART_SETTINGS         "&RAMCART belltsai..."
  IDS_MI_DQBB_SETTINGS            "&Double Quick Brown Box belltsai..."
  IDS_MI_ISEPIC_SETTINGS          "I&sepic belltsai..."
  IDS_MI_MMC64_SETTINGS           "&MMC64 belltsai..."
  IDS_MI_MIDI_SETTINGS            "M&IDI belltsai..."
  IDS_MI_DIGIMAX_SETTINGS         "&DIGIMAX belltsai..."
  IDS_MI_LIGHTPEN_SETTINGS        "&Lightpen settings..."
  IDS_MI_IDE64_SETTINGS           "&IDE64 belltsai..."
#ifdef HAVE_TFE
  IDS_MI_TFE_SETTINGS             "&Ethernet belltsai..."
#endif
  IDS_MI_ACIA_SETTINGS            "&ACIA belltsai..."
  IDS_MI_RS232USER_SETTINGS       "RS&232 userport belltsai..."
  IDS_MI_EASYFLASH_SETTINGS       "EasyFlash settings..."
  IDS_MI_SFX_SE_SETTINGS          "SFX Sound Expander settings..."
  IDS_MI_TOGGLE_SFX_SS            "Enable SFX Sound Sampler"
  IDS_MI_SETTINGS_SAVE_FILE       "Jelenlegi belltsok mentse adott fjlba"
  IDS_MI_SETTINGS_LOAD_FILE       "Belltsok betltse a megadott fjlbl"
  IDS_MI_SETTINGS_SAVE            "Jelenlegi belltsok &mentse"
  IDS_MI_SETTINGS_LOAD            "Mentett belltsok &betltse"
  IDS_MI_SETTINGS_DEFAULT         "Alaprtelmezsek &belltsa"
  IDS_MI_SAVE_SETTINGS_ON_EXIT    "Belltsok mentse k&ilpskor"
  IDS_MI_CONFIRM_ON_EXIT          "&Megersts kilpskor"
  IDS_MI_LANG_DA                  "D&anish"
  IDS_MI_LANG_EN                  "&Angol"
  IDS_MI_LANG_DE                  "&Nmet"
  IDS_MI_LANG_FR                  "&Francia"
  IDS_MI_LANG_HU                  "&Magyar"
  IDS_MI_LANG_IT                  "&Olasz"
  IDS_MI_LANG_NL                  "&Holland"
  IDS_MI_LANG_PL                  "&Lengyel"
  IDS_MI_LANG_SV                  "&Svd"
  IDS_MI_LANG_TR                  "&Turkish"
  IDS_MI_CMDLINE                  "Parancssori &opcik"
  IDS_MI_CONTRIBUTORS             "&Kzremkdk"
  IDS_MI_LICENSE                  "&Licensz"
  IDS_MI_WARRANTY                 "Nincs &garancia"
  IDS_MI_TOGGLE_FULLSCREEN        "Teljes kperny"
  IDS_MI_SIDCART_SETTINGS         "&SID krtya belltsai..."
  IDS_MI_MON_OPEN                 "&Megnyits"
  IDS_MI_MON_SAVE                 "M&ents"
  IDS_MI_MON_PRINT                "&Nyomtats"
  IDS_MI_MON_EXIT                 "&Kilps\tAlt+F4"
  IDS_MI_MON_STOP_DEBUG           "Nyomkvets l&elltsa"
  IDS_MI_MON_STOP_EXEC            "Vgrehajts &lelltsa"
  IDS_MI_MON_STEP_INTO            "B&elp"
  IDS_MI_MON_STEP_OVER            "&tlp"
  IDS_MI_MON_SKIP_RETURN          "Lptets &visszatrsig"
  IDS_MI_MON_GOTO_CURSOR          "Ugrs a &kurzorhoz"
  IDS_MI_MON_EVAL                 "&Kirtkel"
  IDS_MI_MON_CURRENT              "&Jelenlegi utasts"
  IDS_MI_MON_WND_EVAL             "&Kirtkels ablak"
  IDS_MI_MON_WND_REG              "&Regiszter ablak"
  IDS_MI_MON_WND_MEM              "&Memria ablak"
  IDS_MI_MON_WND_DIS              "&Visszafejts ablak"
  IDS_MI_MON_WND_CONSOLE          "&Konzol ablak"
  IDS_MI_MON_COMPUTER             "&Szmtgp"
  IDS_MI_MON_DRIVE8               "&8-as lemezegysg"
  IDS_MI_MON_DRIVE9               "&9-es lemezegysg"
  IDS_MI_MON_CASCADE              "&Kaszkd"
  IDS_MI_MON_TILE_VERT            "Elrendezs &vzszintesen"
  IDS_MI_MON_TILE_HORIZ           "Elrendezs &fgglegesen"
  IDS_MI_MON_ARRANGE_ICONS        "&Ikonok elrendezse"
END
#pragma code_page(28591)



STRINGTABLE
LANGUAGE LANG_ITALIAN, SUBLANG_NEUTRAL
BEGIN
  IDS_VICE_ERROR                  "Errore di VICE!"
  IDS_VICE_INFORMATION            "Informazioni su VICE"
  IDS_VICE_QUESTION               "Domanda di VICE"
  IDS_FFMPEG_DLL_MISMATCH         "La versione della DLL ffmpeg non corrisponde."
  IDS_DIRECTDRAW_ERROR            "Errore DirectDraw: Codice:%8x Errore:%s"
  IDS_CANNOT_SAVE_SETTINGS        "Non  possibile salvare le impostazioni."
  IDS_CANNOT_LOAD_SETTINGS        "Non  possibile caricare le impostazioni."
  IDS_DEFAULT_SETTINGS_RESTORED   "Impostazioni originarie ripristinate."
  IDS_CANNOT_ATTACH_FILE          "Non  possibile selezionare il file specificato"
  IDS_START_MONITOR               "%s\012\012Avvio monitor? (No per reset, annulla per continuare)"
  IDS_VICE_CPU_JAM                "VICE CPU JAM"
  IDS_EXTEND_TO_40_TRACKS         "Astendere l'immagine al formato di 40 tracce?"
  IDS_DETACHED_DEVICE_S           "Rimosso dispositivo %s"
  IDS_ATTACHED_S_TO_DEVICE_S      "Selezionato %s per la periferica #%s"
  IDS_DETACHED_TAPE               "Cassetta rimossa"
  IDS_HISTORY_RECORDED_UNKNOWN    "Cronologia registrata con una release sconosciuta"
  IDS_HISTORY_RECORDED_VICE_S     "Cronologia registrata con VICE-%s"
  IDS_PAUSED                      "pausa"
  IDS_FRAME_NUMBER                "frame n."
  IDS_RESUMED                     "ripreso"
  IDS_REALLY_EXIT                 "Uscire davvero?\012\012Tutti i dati presenti nella RAM emulata saranno persi."
  IDS_CANNOT_AUTOSTART_FILE       "Non  possibile avviare automaticamente il file specificato."
  IDS_ATTACHED_TAPE_S             "Cassetta %s selezionata"
  IDS_SETTINGS_SAVED_SUCCESS      "Impostazioni salvate con successo."
  IDS_SETTINGS_LOADED_SUCCESS     "Impostazioni caricate con successo."
  IDS_ATTACH_DISK_IMAGE           "Seleziona l'immagine di un disco"
  IDS_ATTACH_TAPE_IMAGE           "Seleziona l'immagine di una cassetta"
  IDS_AUTOSTART_IMAGE             "Avvia automaticamente l'immagine del disco/cassetta"
  IDS_INVALID_CARTRIDGE           "Cartuccia non valida"
  IDS_BAD_CARTRIDGE_CONFIG        "Configurazione della cartuccia errata nell'IU!"
  IDS_INVALID_CARTRIDGE_IMAGE     "Immagine della cartuccia non valida"
  IDS_LOG_CONSOLE_OUTPUT_IMAGE    "Immagine dell'output della console di log"
  IDS_LOG_FILES_TYPE              "File di log (*.dbg)"
  IDS_CANNOT_WRITE_LOGFILE_S      "Non  possibile scrivere il file di log `%s'."
  IDS_LOAD_FLIP_LIST_FILE         "Carica il file della fliplist"
  IDS_CANNOT_READ_FLIP_LIST       "Non  possibile caricare il file della flip list"
  IDS_SAVE_FLIP_LIST_FILE         "Salva il file della fliplist"
  IDS_CANNOT_WRITE_FLIP_LIST      "Non  possibile scrivere il file della flip list"
  IDS_SELECT_KEYMAP_FILE          "Seleziona il file della mappa della tastiera"
  IDS_SAVE_KEYMAP_FILE            "Salva il file della mappa della tastiera"
  IDS_CANNOT_WRITE_KEYMAP_FILE    "Non  possibile scrivere il file della mappa della tastiera"
  IDS_SAVE_CONFIG_FILE            "Specifica il file di configurazione"
  IDS_LOAD_CONFIG_FILE            "Carica il file di configurazione"
  IDS_MAPPING                     "Mappatura"
  IDS_KEYBOARD_SETTINGS           "Impostazioni tastiera"
  IDS_ATTACH                      "&Seleziona"
  IDS_PLEASE_ENTER_A_FILENAME     "Specifica il nome del file."
  IDS_OVERWRITE_EXISTING_IMAGE    "Sovrascrivo l'immagine esistente?"
  IDS_CANNOT_CREATE_IMAGE         "Non  possibile creare l'immagine"
  IDS_COMMAND_LINE_OPTIONS        "Parametri della riga di comando"
  IDS_COMMAND_OPTIONS_AVAIL       "Quali parametri della riga di comando sono disponibili?"
  IDS_NO_DRIVER_SELECT_SUPPORT    "Nessun driver selezionato o driver selezionato non supportato"
  IDS_CANT_WRITE_SCREENSHOT_S     "Non  possibile scrivere il file di screenshot `%s'."
  IDS_AUTOSTART_DISK_IMAGE        "Avvia automaticamente l'immagine del disco"
  IDS_SELECT_FS_DIRECTORY         "Seleziona la directory del file system"
  IDS_PRINTER_USERPORT            "Stampante su userport"
  IDS_PRINTER_4                   "Stampante 4"
  IDS_PRINTER_5                   "Stampante 5"
  IDS_DRIVE_8                     "Drive 8"
  IDS_DRIVE_9                     "Drive 9"
  IDS_DRIVE_10                    "Drive 10"
  IDS_DRIVE_11                    "Drive 11"
  IDS_PERIPHERAL_SETTINGS         "Impostazioni periferiche"
  IDS_CANT_WRITE_SNAPSHOT_FILE    "Non  possibile scrivere il file di snapshot."
  IDS_CANNOT_READ_SNAPSHOT_IMG    "Non  possibile leggere l'immagine dello snapshot"
  IDS_LOAD_S_ROM_IMAGE            "Carica immagine della ROM %s"
  IDS_SELECT_ROMSET_ARCHIVE       "Seleziona l'archivio del ROM set"
  IDS_CANNOT_LOAD_ROMSET_ARCH     "Non  possibile caricare l'archivio del romset!"
  IDS_CANNOT_SAVE_ROMSET_ARCH     "Non  possibile salvare l'archivio del romset!"
  IDS_CANNOT_LOAD_ROMSET_FILE     "Non  possibile caricare il file del romset!"
  IDS_CANNOT_SAVE_ROMSET_FILE     "Non  possibile salvare il file del romset!"
  IDS_SELECT_ROMSET_FILE          "Seleziona il file del ROM set"
  IDS_ROMSET                      "Romset"
  IDS_COMPUTER                    "Computer"
  IDS_DRIVE                       "Drive"
  IDS_ROM_SETTINGS                "Impostazioni ROM"
  IDS_SAVE_SNAPSHOT_IMAGE         "Salva l'immagine dello snapshot"
  IDS_CANNOT_WRITE_SNAPSHOT_S     "Non  possibile scrivere il file di snapshot `%s'."
  IDS_LOAD_SNAPSHOT_IMAGE         "Carica immagine dello snapshot"
  IDS_COULD_NOT_LOAD_PALETTE      "Non  possibile caricare il file di palette."
  IDS_LOAD_VICE_PALETTE_FILE      "Carica il file di palette di VICE"
  IDS_FULLSCREEN                  "Schermo intero/DirectX"
  IDS_COLORS                      "Colori"
  IDS_NEW_PAL                     "Emulazione PAL"
  IDS_VIDEO_SETTINGS              "Impostazioni video"
  IDS_FILE_SYSTEM                 "File system"
#ifdef HAVE_OPENCBM
  IDS_REAL_IEC_DEVICE             "Periferica IEC reale"
#endif
  IDS_RS232_DEVICE_I              "Dispositivo RS232 #%i"
  IDS_ATTACH_CRT_CART_IMAGE       "Seleziona l'immagine di una cartuccia CRT"
  IDS_ATTACH_RAW_8KB_CART_IMAGE   "Seleziona l'immagine di una cartuccia di 8KB"
  IDS_ATTACH_RAW_16KB_CART_IMG    "Seleziona l'immagine di una cartuccia di 16KB"
  IDS_ATTACH_AR_CART_IMAGE        "Seleziona l'immagine di una cartuccia Action Replay"
  IDS_ATTACH_AR3_CART_IMAGE       "Seleziona l'immagine di una cartuccia Action Replay III"
  IDS_ATTACH_AR4_CART_IMAGE       "Seleziona l'immagine di una cartuccia Action Replay 4"
  IDS_ATTACH_STARDOS_CART_IMAGE   "Seleziona l'immagine di una cartuccia StarDOS"
  IDS_ATTACH_ATOMIC_P_CART_IMG    "Seleziona l'immagine di una cartuccia Atomic Power"
  IDS_ATTACH_EPYX_FL_CART_IMG     "Seleziona l'immagine di una cartuccia Epyx fastload"
  IDS_ATTACH_IEEE488_CART_IMG     "Seleziona l'immagine di una cartuccia di interfaccia IEEE"
  IDS_ATTACH_RETRO_R_CART_IMG     "Seleziona l'immagine di una cartuccia Retro Replay"
  IDS_ATTACH_IDE64_CART_IMAGE     "Seleziona l'immagine di una cartuccia di interfaccia IDE64"
  IDS_ATTACH_SS4_CART_IMAGE       "Seleziona l'immagine di una cartuccia Super Snapshot 4"
  IDS_ATTACH_SS5_CART_IMAGE       "Seleziona l'immagine di una cartuccia Super Snapshot 5"
  IDS_ATTACH_STB_CART_IMAGE       "Seleziona l'immagine di una cartuccia Structured Basic"
  IDS_MODEL                       "Modello"
  IDS_DRIVE_SETTINGS              "Impostazioni drive"
  IDS_SELECT_START_SNAP_EVENT     "Seleziona lo snapshot iniziale per la cronologia degli eventi"
  IDS_SELECT_END_SNAP_EVENT       "Seleziona lo snapshot finale per la cronologia degli eventi"
#ifdef UNSTABLE
  IDS_VERSION_S_UNSTABLE          "Versione %s *INSTABILE* (%s)"
#else
  IDS_VERSION_S                   "Versione %s (%s)"
#endif
  IDS_VICE_CONTRIBUTORS           "Collaboratori"
  IDS_WHO_MADE_WHAT               "Chi ha fatto cosa?"
  IDS_LICENSE                     "Licenza"
  IDS_NO_WARRANTY                 "Nessuna garanzia!"
  IDS_VICE_WITHOUT_WARRANTY       "VICE  distribuito SENZA NESSUNA GARANZIA!"
  IDS_PRESS_KEY_NORTHWEST         "Permi il tasto per nord ovest"
  IDS_PRESS_KEY_NORTH             "Premi il tasto per nord"
  IDS_PRESS_KEY_NORTHEAST         "Premi il tasto per nord est"
  IDS_PRESS_KEY_EAST              "Premi il tasto per est"
  IDS_PRESS_KEY_SOUTHEAST         "Premi il tasto per sud est"
  IDS_PRESS_KEY_SOUTH             "Premi il tasto per sud"
  IDS_PRESS_KEY_SOUTHWEST         "Premi il tasto per sud ovest"
  IDS_PRESS_KEY_WEST              "Premi il tasto per ovest"
  IDS_PRESS_KEY_FIRE              "Premi il tasto per il fuoco"
  IDS_NO_USERPORT_ADAPTER         "Nessun adattatore di joystick sulla userport"
  IDS_CGA_USERPORT_ADAPTER        "Adattatore joystick CGA su userport"
  IDS_PET_USERPORT_ADAPTER        "Adattatore joystick PET su userport"
  IDS_HUMMER_USERPORT_ADAPTER     "Adattatore joystick HUMMER su userport"
  IDS_OEM_USERPORT_ADAPTER        "Adattatore joystick OEM su userport"
  IDS_HIT_USERPORT_ADAPTER        "Adattatore joystick HIT su userport"
  IDS_NO_SIDCART_JOY              "Disattiva joystick SIDcart"
  IDS_SIDCART_JOY                 "Attiva joystick SIDcart"
  IDS_NUMPAD_AND_RCTRL            "Tastierino numerico + Ctrl destro"
  IDS_KEYSET_A                    "Keyset A"
  IDS_KEYSET_B                    "Keyset B"
  IDS_ALL_BUTTONS_AS_FIRE         "Tutti i pulsanti usati come fuoco"
  IDS_NUMERIC_SEE_ABOVE           "numerico (vedi sopra)"
  IDS_NO_BUTTON_NO_AUTOFIRE       "Pulsante mancante - Fuoco automatico disabilitato"
  IDS_ALL_FILES_FILTER            "Tutti i file (*.*)"
  IDS_PALETTE_FILES_FILTER        "Palette di VICE (*.vpl)"
  IDS_SNAPSHOT_FILES_FILTER       "Snapshot (*.vsf)"
  IDS_CBM_IMAGE_FILES_FILTER      "File CBM (*.d64;*.d71;*.d80;*.d81;*.d82;*.g64;*.g41;*.x64;*.t64;*.tap;*.prg;*.p00)"
  IDS_DISK_IMAGE_FILES_FILTER     "Immagini di dischi (*.d64;*.d71;*.d80;*.d81;*.d82;*.g64;*.g41;*.x64)"
  IDS_TAPE_IMAGE_FILES_FILTER     "Immagini di cassette (*.t64;*.tap)"
  IDS_ZIPPED_FILES_FILTER         "File compressi (*.zip;*.bz2;*.gz;*.d6z;*.d7z;*.d8z;*.g6z;*.g4z;*.x6z)"
  IDS_CRT_FILES_FILTER            "Immagini delle cartucce CRT (*.crt)"
  IDS_RAW_CART_FILES_FILTER       "Immagini delle cartucce (*.bin)"
  IDS_FLIP_LIST_FILES_FILTER      "Flip list (*.vfl)"
  IDS_ROMSET_FILES_FILTER         "ROM set (*.vrs)"
  IDS_ROMSET_ARCHIVES_FILTER      "Archivi del ROM set (*.vra)"
  IDS_KEYMAP_FILES_FILTER         "Mappe della tastiera (*.vkm)"
  IDS_PRGP00_FILES_FILTER         "File emulatore Commodore (*.prg;*.p00)"
  IDS_FLEXIBLE                    "Flessibile"
  IDS_ADJUSTING                   "Adattabile"
  IDS_EXACT                       "Esatta"
  IDS_SOUND_DRIVER_DIRECTX        "Driver audio: DirectX"
  IDS_SOUND_DRIVER_WMM            "Driver sonoro: WMM"
  IDS_MEDIA_FILES_FILTER          "File multimediali (*.bmp;*.gif;*.iff;*.jpg;*.pcx;*.png;*.ppm;*.wav;*.mp3;*.avi;*.mpg)"
  IDS_SPACE_KB                    " kB"
  IDS_CONFIGURE_KEYSET_A          "Configura Keyset A"
  IDS_CONFIGURE_KEYSET_B          "Configura Keyset B"
  IDS_SAVE_MEDIA_IMAGE            "Salva immagine multimediale"
  IDS_S_AT_D_SPEED                "velocit %s al %d%%, %d fps%s"
  IDS_TAPE                        "Cassetta:"
  IDS_JOYSTICK_C                  "Joystick:"
  IDS_RECORDING                   "Registrazione\n%02d:%02d"
  IDS_PLAYBACK                    "Riproduzione\n%02d:%02d (%02d:%02d)"
  IDS_UNKNOWN                     "Sconosciuto"
  IDS_P_NUMBER                    "<numero>"
  IDS_SET_INPUT_JOYSTICK_1        "Imposta il dispositivo di input per il joystick 1"
  IDS_SET_INPUT_JOYSTICK_2        "Imposta il dispositivo di input per il joystick 2"
  IDS_SET_INPUT_EXTRA_JOYSTICK_1  "Imposta il dispositivo di input per il joystick supplementare #1"
  IDS_SET_INPUT_EXTRA_JOYSTICK_2  "Imposta il dispositivo di input per il joystick supplementare #2"
  IDS_SAVE_SETTINGS_ON_EXIT       "Salva le impostazioni in uscita"
  IDS_NO_SAVE_SETTINGS_ON_EXIT    "Non salvare mai le impostazioni in uscita"
  IDS_CONFIRM_QUIT_VICE           "Conferma l'uscita da VICE"
  IDS_NO_CONFIRM_QUIT_VICE        "Non confermare mai l'uscita da VICE"
  IDS_USE_ALL_CPU_SMP             "Usa tutte le CPU sui sistemi SMP"
  IDS_USE_FIRST_CPU_SMP           "Usa solo la prima CPU sui sistemi SMP"
  IDS_START_VICE_FULLSCREEN_MODE  "Avvia VICE a tutto schermo"
  IDS_DISABLE_DX9                 "Disattiva i driver video DirectX9"
#ifdef SYS_SIGLIST_DECLARED
  IDS_RECEIVED_SIGNAL_D_S         "Si  verificato un errore imprevisto. E' stato ricevuto il segnale %d (%s)."
#else
  IDS_RECEIVED_SIGNAL_D           "Si  verificato un errore imprevisto. E' stato ricevuto il segnale %d."
#endif
#ifdef HAVE_NETWORK
  IDS_IDLE                        "Inattivo"
  IDS_SERVER_LISTENING            "Server in ascolto"
  IDS_CONNECTED_SERVER            "Server connesso"
  IDS_CONNECTED_CLIENT            "Client connesso"
  IDS_INVALID_PORT_NUMBER         "Numero di porta non valido"
  IDS_ERROR_STARTING_SERVER       "Si  verificato un errore all'avvio del server."
  IDS_ERROR_CONNECTING_CLIENT     "Si  verificato un errore durante il collegamento col client."
#endif
  IDS_SOUND_RECORDING_STARTED     "Registrazione audio avviata..."
  IDS_SOUND_RECORDING_STOPPED     "Registrazione audio interrotta..."
  IDS_OK                          "OK"
  IDS_CANCEL                      "Annulla"
  IDS_NONE                        "Nessuno"
  IDS_BROWSE                      "&Sfoglia..."
  IDS_SPECIFY_MIDI_IN             "Specifica device MIDI-In"
  IDS_SPECIFY_MIDI_OUT            "Specifica device MIDI-Out"
  IDS_ERROR_SAVING_EASYFLASH_CRT  "Errore durante il salvataggio del file crt EasyFlash"
  IDS_DATASETTE_CAPTION           "Impostazioni registratore"
  IDS_DATASETTE_RESET_WITH_CPU    "&Reset del registratore al reset della CPU"
  IDS_DATASETTE_MOTOR_GROUP       "Velocit del motore durante la lettura"
  IDS_DATASETTE_DELAY_TRIGGER     "ciclo/i addizionali di ritardo per ogni trigger"
  IDS_DATASETTE_DELAY_AT_ZERO     "cicli di ritardo ai valori di &zero"
  IDS_TOGGLE_USEIECDEVICE         "&Usa la periferica IEC"
  IDS_SELECTDISK                  "&Immagine disco"
  IDS_SELECTDIR                   "&Directory"
#ifdef HAVE_OPENCBM
  IDS_SELECTREAL                  "Periferica IEC rea&le"
#endif
  IDS_SELECTNONE                  "&Nessuno"
  IDS_AUTOSTART                   "&Avvio automatico"
  IDS_BROWSEDIR                   "&Sfoglia..."
  IDS_TOGGLE_ATTACH_READONLY      "Seleziona in sola lettura"
  IDS_TOGGLE_READP00              "&Leggi file P00"
  IDS_TOGGLE_WRITEP00             "&Scrivi file P00"
  IDS_TOGGLE_HIDENONP00           "&Nascondi i file non P00"
  IDS_JOYSTICK_CAPTION            "Impostazioni joystick"
  IDS_JOYSTICK_IN_PORT_1          "Joystick nella porta #&1"
  IDS_SELECT_FIRE_BUTTON          "Seleziona pulsante di fuoco"
  IDS_AUTO_FIRE_BUTTON_SETTINGS   "Impostazioni fuoco automatico"
  IDS_AUTOFIRE_SPEED              "&Velocit autofire (1..32)"
  IDS_JOYSTICK_IN_PORT_2          "Joystick nella porta #&2"
  IDS_JOY_CONFIG_A                "Configura il keyset &A"
  IDS_JOY_CONFIG_B                "Configura il keyset &B"
  IDS_JOY_CALIBRATE               "&Calibra Joystick"
  IDS_EXTRA_JOYSTICK_CAPTION      "Impostazioni joystick supplementari"
  IDS_JOYSTICK_IN_EXTRA_PORT_1    "Joystick nella porta supplementare #&1"
  IDS_JOYSTICK_IN_EXTRA_PORT_2    "Joystick nella porta supplementare #&2"
  IDS_KEYSET_SW                   "S&ud ovest"
  IDS_KEYSET_S                    "&Sud"
  IDS_KEYSET_SE                   "Su&d Est"
  IDS_KEYSET_W                    "&Ovest"
  IDS_KEYSET_E                    "&Est"
  IDS_KEYSET_NW                   "No&rd Ovest"
  IDS_KEYSET_N                    "&Nord"
  IDS_KEYSET_NE                   "Nor&d Est"
  IDS_KEYSET_FIRE                 "Pulsante di &Fuoco"
  IDS_SOUND_CAPTION               "Configura le impostazioni della scheda audio"
  IDS_SOUND_DIRECTX               "Driver DirectX"
  IDS_SOUND_WMM                   "Driver WMM"
  IDS_SOUND_SAMPLE_FREQUENCY      "&Frequenza di campionamento :"
  IDS_SOUND_BUFFER_SIZE           "Dimensione del buffer del suono :"
  IDS_SOUND_FRAGMENT_SIZE_LABEL   "Sound Fragment Size :"
  IDS_SOUND_FRAGMENT_SIZE_SMALL   "Small"
  IDS_SOUND_FRAGMENT_SIZE_MEDIUM  "Medium"
  IDS_SOUND_FRAGMENT_SIZE_LARGE   "Large"
  IDS_SOUND_SYNCH_METHOD          "&Metodo di sincronizzazione :"
  IDS_TOGGLE_SNAPSHOT_SAVE_DISKS  "Salva le immagini dei &dischi attualmente selezionati"
  IDS_TOGGLE_SNAPSHOT_SAVE_ROMS   "Salva le immagini delle &ROM attualmente caricate"
  IDS_FULLSCREEN_DRIVER           "Driver:"
  IDS_FULLSCREEN_DRVR_BITDEPTH    "Profondit:"
  IDS_FULLSCREEN_DRVR_RESOLUTION  "Risoluzione:"
  IDS_FULLSCREEN_DRVR_REFRESHRATE "Frequenza di aggiornamento:"
  IDS_TOGGLE_VIDEO_VBLANK_SYNC    "Sincronizzazione VBLANK"
  IDS_TOGGLE_VIDEO_DX_PRIMARY     "Visualizza sulla superficie primaria DX"
  IDS_TOGGLE_KEEP_ASPECT_RATIO    "Mantieni il rapporto di formato (0,5..2)"
  IDS_COLORS_SATURATION           "Saturazione (0..2)"
  IDS_COLORS_CONTRAST             "Contrasto (0..2)"
  IDS_COLORS_BRIGHTNESS           "Luminosit (0..2)"
  IDS_NEW_PAL_TINT                "Sfumatura (0..2)"
  IDS_NEW_PAL_ODD_LINES_PHASE     "Fase linee dispari (0..2)"
  IDS_NEW_PAL_ODD_LINES_OFFSET    "Offset linee pdispari (0..2)"
  IDS_VIDEO_GAMMA                 "Gamma (0..2)"
  IDS_VIDEO_PHASE                 "Fase (0..2)"
  IDS_VIDEO_PAL_SHADE             "Ombra PAL (0..1)"
  IDS_VIDEO_PAL_BLUR              "Sfuocatura PAL (0..1)"
  IDS_TOGGLE_VIDEO_EXTPALETTE     "Palette esterna:"
  IDS_RAM_CAPTION                 "Impostazioni RAM"
  IDS_RAM_INIT_AT_POWERUP         "Inizializzazione all'accensione"
  IDS_RAM_VALUE_FIRST_BYTE        "Valore del primo byte"
  IDS_RAM_LENGTH_CONSTANT_VALUES  "Lunghezza dei valori costanti"
  IDS_RAM_LENGTH_CONSTANT_PATTERN "Lunghezza dei pattern costanti"
  IDS_PRINTER_EMULATION           "Emulazione della stampante"
  IDS_PRINTER_FORMFEED            "Invia Formfeed"
  IDS_FILESYSTEM_PRINTER          "Stampante su file system"
  IDS_PRINTER_DRVR                "Driver di stampa"
  IDS_OUTPUT                      "Output"
  IDS_OUTPUT_TO_FILE              "Output su file #"
  IDS_OUTPUT_FILE1_NAME           "Nome del file di output #1"
  IDS_OUTPUT_FILE2_NAME           "Nome del file di output #2"
  IDS_OUTPUT_FILE3_NAME           "Nome del file di output #3"
  IDS_ROMSET_SELECT_ARCHIVE       "Archivio del ROM set"
  IDS_ROMSET_ARCHIVE_LOAD         "Carica archivio"
  IDS_ROMSET_ARCHIVE_SAVE         "Salva archivio"
  IDS_ROMSET_CONFIGURATION        "&Configurazione"
  IDS_ROMSET_ARCHIVE_APPLY        "Applica"
  IDS_ROMSET_ARCHIVE_NEW          "Nuovo"
  IDS_ROMSET_ARCHIVE_DELETE       "Cancella"
  IDS_ROMSET_SELECT_FILE          "File del ROM set"
  IDS_ROMSET_FILE_LOAD            "Carica romset"
  IDS_ROMSET_FILE_SAVE            "Salva romset"
  IDS_CUSTOM_SPEED_CAPTION        "Velocit personalizzata"
  IDS_ENTER_CUSTOM_SPEED          "Inserisci velocit personalizzata [%]"
  IDS_NEW_CONFIGURATION           "Nuova configurazione"
  IDS_ENTER_CONFIGURATION_NAME    "Inserisci il nome della configurazione"
  IDS_RS232_CAPTION               "Impostazioni RS232"
  IDS_RS232_DEV_1                 "Dispositivo RS232 #1"
  IDS_RS232_DEV_2                 "Dispositivo RS232 #2"
  IDS_RS232_DEV_3                 "Dispositivo RS232 #3"
  IDS_RS232_DEV_4                 "Dispositivo RS232 #4"
  IDS_NETWORK_CAPTION             "Impostazioni Netplay"
  IDS_CURRENT_MODE                "Modalit attuale"
  IDS_SERVER_BIND                 "Server Bind"
  IDS_TCP_PORT                    "Porta TCP"
  IDS_NETWORK_SERVER              "Avvia server"
  IDS_NETWORK_CLIENT              "Connetti a"
  IDS_NETWORK_DISCONNECT          "Disconnetti"
  IDS_CONTROL                     "Control"
  IDS_SERVER                      "Server"
  IDS_CLIENT                      "Client"
  IDS_KEYBOARD                    "Keyboard"
  IDS_JOYSTICK_1                  "Joystick 1"
  IDS_JOYSTICK_2                  "Joystick 2"
  IDS_DEVICES                     "Devices"
  IDS_SETTINGS                    "Settings"
  IDS_TOGGLE_CONSOLE_APPEND       "&Accoda i log al file esistente"
  IDS_IMAGE_CONTENTS              "Contenuti"
  IDS_NEW_IMAGE                   "Nuova immagine"
  IDS_NAME                        "Nome"
  IDS_ID                          "ID"
  IDS_TYPE                        "Tipo"
  IDS_BLANK_IMAGE                 "Crea immagine"
  IDS_NEW_TAP_IMAGE               "Nuova immagine TAP"
  IDS_SAVE                        "Salva"
  IDS_SELECT_DRIVER               "Seleziona Driver"
  IDS_FFMPEG_SETTINGS             "Impostazioni FFMPEG"
  IDS_FORMAT                      "Formato"
  IDS_AUDIO_CODEC                 "Audio codec"
  IDS_BITRATE                     "bitrate"
  IDS_VIDEO_CODEC                 "Video codec"
  IDS_SOUND_RECORD_CAPTION        "Impostazioni registrazione audio"
  IDS_SOUND_RECORD_FORMAT_LABEL   "Formato di registrazione dell'audio"
  IDS_SOUND_RECORD_FILE_LABEL     "File per la registrazione dell'audio"
  IDS_KERNAL                      "Kernal"
  IDS_BASIC                       "Basic"
  IDS_CHARACTER                   "Character"
  IDS_COMPUTER_RESOURCES_CAPTION  "Risorse del computer"
  IDS_COMPUTER_RESOURCES          "Risorse del computer salvate nel ROM set"
  IDS_DRIVE_RESOURCES_CAPTION     "Risorse dei drive"
  IDS_DRIVE_RESOURCES             "Risorse del drive salvate nel ROM set"
  IDS_SYMBOLIC                    "&Simbolico"
  IDS_POSITIONAL                  "&Posizionale"
  IDS_DUMP_KEYSET                 "Scrivi keyset"
  IDS_DUMP_SHORTCUTS              "Stampa scorciatoie"
  IDS_SYMBOLIC_US                 "&Simbolico US"
  IDS_SYMBOLIC_DE                 "&Simbolico GER"
  IDS_GR_SYM                      "&Gr Sim."
  IDS_GR_POS                      "G&r Pos."
  IDS_UK_SYM                      "&UK Sim."
  IDS_UK_POS                      "U&K Pos."
  IDS_DE_SYM                      "&DE Sim."
  IDS_DE_POS                      "D&E Pos."
  IDS_A_MEMORY                    "&Memoria"
  IDS_DRIVE_TYPE                  "Tipo di &drive"
  IDS_40_TRACK_HANDLING           "Gestisci 40 &tracce"
  IDS_SELECT_DRIVE_EXTEND_NEVER   "Mai"
  IDS_SELECT_DRIVE_EXTEND_ASK     "Chiedi all'accesso"
  IDS_SELECT_DRIVE_EXTEND_ACCESS  "All'accesso"
  IDS_IDLE_METHOD                 "Ri&leva inattivit"
  IDS_SELECT_DRIVE_IDLE_TRAP_IDLE "Rileva inattivit"
  IDS_SELECT_DRIVE_IDLE_SKIP_CYC  "Salta cicli"
  IDS_TOGGLE_DRIVE_PARALLEL_CABLE "Cavo &parallelo"
  IDS_DRIVE_EXPANSION             "&Espasione del drive"
  IDS_TOGGLE_DRIVE_EXPANSION_2000 "$2000-$3FFF &RAM"
  IDS_TOGGLE_DRIVE_EXPANSION_4000 "$&4000-$5FFF RAM"
  IDS_TOGGLE_DRIVE_EXPANSION_6000 "$&6000-$7FFF RAM"
  IDS_TOGGLE_DRIVE_EXPANSION_8000 "$8000-$9FFF RA&M"
  IDS_TOGGLE_DRIVE_EXPANSION_A000 "$&A000-$BFFF RAM"
  IDS_PLUS4_VIC20_MEMORY          "&Memoria"
  IDS_SID_GENGROUP1               "SID Engine/Model"
  IDS_SID_FILTERS                 "Filtri SID"
  IDS_MP_FILE                     "&File"
  IDS_MP_ATTACH_DISK_IMAGE        "Seleziona l'immagine di un &disco"
  IDS_MP_DETACH_DISK_IMAGE        "&Rimuovi l'immagine di un disco"
  IDS_MP_FLIP_LIST                "&Flip list"
  IDS_MP_DATASETTE_CONTROL        "Contro&llo del registratore"
  IDS_MP_ATTACH_CARTRIDGE_IMAGE   "Seleziona l'immagine di una &cartuccia..."
  IDS_MP_EXPERT_CARTRIDGE         "Expert Cartridge"
  IDS_MP_RESET                    "&Reset"
  IDS_MP_DEBUG                    "&Debug"
#ifdef DEBUG
  IDS_MP_MODE                     "M&odalit"
#endif
  IDS_MP_EDIT                     "&Modifica"
  IDS_MP_SNAPSHOT                 "Sna&pshot"
  IDS_MP_RECORDING_START_MODE     "Modalit di inizio registrazione"
  IDS_MP_OPTIONS                  "&Opzioni"
  IDS_MP_REFRESH_RATE             "Frequenza di &aggiornamento"
  IDS_MP_MAXIMUM_SPEED            "Velocit &massima"
  IDS_MP_VIDEO_STANDARD           "Standard vide&o"
  IDS_MP_DRIVE_SYNC_FACTOR        "Fattore di s&incronizzazione del drive"
  IDS_MP_SETTINGS                 "I&mpostazioni"
  IDS_MP_CARTRIDGE_IO_SETTINGS    "Impostazioni &cartuccia/IO"
  IDS_MP_LANGUAGE                 "&Lingua"
  IDS_MP_HELP                     "&Aiuto"
  IDS_MP_VIEW                     "&Vista"
  IDS_MP_WINDOW                   "&Finestra"
  IDS_MI_EXIT                     "&Esci"
  IDS_MI_ABOUT                    "&Informazioni su VICE..."
  IDS_MI_PAUSE                    "&Pausa"
  IDS_MI_EDIT_COPY                "&Copia"
  IDS_MI_EDIT_PASTE               "&Incolla"
  IDS_MI_AUTOSTART                "&Avvia automaticamente l'immagine di un disco/cassetta..."
  IDS_MI_RESET_HARD               "&Hard"
  IDS_MI_RESET_SOFT               "&Soft"
  IDS_MI_DRIVE8                   "Drive &8"
  IDS_MI_DRIVE9                   "Drive &9"
  IDS_MI_DRIVE10                  "Drive 1&0"
  IDS_MI_DRIVE11                  "Drive 1&1"
  IDS_MI_ATTACH_TAPE              "Seleziona l'immagine di una &cassetta..."
  IDS_MI_DETACH_TAPE              "Rimuo&vi l'immagine della cassetta"
  IDS_MI_DETACH_ALL               "&Tutti"
  IDS_MI_TOGGLE_SOUND             "Riproduzione del &suono"
  IDS_MI_TOGGLE_DOUBLESIZE        "&Dimensione doppia"
  IDS_MI_TOGGLE_DOUBLESCAN        "Scansione do&ppia"
  IDS_MI_DRIVE_TRUE_EMULATION     "Attiva l'emulazione &hardware dei drive"
  IDS_MI_AUTOSTART_HANDLE_TDE     "Emulazio&ne hardware dei drive all'avvio automatico"
  IDS_MI_TOGGLE_VIDEOCACHE        "&Cache video"
  IDS_MI_DRIVE_SETTINGS           "Impostazioni &drive..."
  IDS_MI_CART_ATTACH_CRT          "Immagine &CRT..."
  IDS_MI_CART_ATTACH_8KB          "Immagine generica di &8KB..."
  IDS_MI_CART_ATTACH_16KB         "Immagine generica di &16KB..."
  IDS_MI_CART_ATTACH_AR           "Immagine &Action Replay..."
  IDS_MI_CART_ATTACH_AR3          "Immagine &Action Replay 3..."
  IDS_MI_CART_ATTACH_AR4          "Immagine &Action Replay 4..."
  IDS_MI_CART_ATTACH_STARDOS      "Immagine &StarDOS..."
  IDS_MI_CART_ATTACH_AT           "Immagine Atomic &Power..."
  IDS_MI_CART_ATTACH_EPYX         "Immagine &Epyx fastload..."
  IDS_MI_CART_ATTACH_IEEE488      "Immagine interfaccia &IEEE488..."
  IDS_MI_CART_ATTACH_RR           "Immagine &Retro Replay..."
  IDS_MI_CART_ATTACH_IDE64        "Immagine interfaccia IDE&64..."
  IDS_MI_CART_ATTACH_SS4          "Immagine Super Snapshot &4..."
  IDS_MI_CART_ATTACH_SS5          "Immagine Super Snapshot &5..."
  IDS_MI_CART_ATTACH_STB          "Immagine Structured &Basic..."
  IDS_MI_FLIP_ADD                 "&Aggiungi l'immagine attuale"
  IDS_MI_FLIP_REMOVE              "&Rimuovi l'immagine attuale"
  IDS_MI_FLIP_NEXT                "Seleziona l'immagine &successiva"
  IDS_MI_FLIP_PREVIOUS            "Seleziona l'immagine &precedente"
  IDS_MI_FLIP_LOAD                "&Carica fliplist"
  IDS_MI_FLIP_SAVE                "&Salva fliplist"
  IDS_MI_DATASETTE_STOP           "S&top"
  IDS_MI_DATASETTE_START          "&Avvia"
  IDS_MI_DATASETTE_FORWARD        "&Avanti"
  IDS_MI_DATASETTE_REWIND         "&Indietro"
  IDS_MI_DATASETTE_RECORD         "Re&cord"
  IDS_MI_DATASETTE_RESET          "R&eset"
  IDS_MI_DATASETTE_RESET_COUNTER  "Reset c&ontantore"
  IDS_MI_CART_ENABLE_EXPERT       "Attivo"
  IDS_MI_CART_MODE_OFF            "No"
  IDS_MI_CART_MODE_ON             "S"
  IDS_MI_CART_SET_DEFAULT         "Imposta la cartuccia come &predefinita"
  IDS_MI_TOGGLE_CART_RESET        "Reset &al cambio di cartuccia"
  IDS_MI_CART_DETACH              "Rimuovi l'&immagine della cartuccia"
  IDS_MI_CART_FREEZE              "Free&ze della cartuccia"
  IDS_MI_MONITOR                  "&Monitor"
#ifdef DEBUG
  IDS_MI_DEBUG_MODE_NORMAL        "&Normale"
  IDS_MI_DEBUG_MODE_SMALL         "&Piccolo"
  IDS_MI_DEBUG_MODE_HISTORY       "&Cronologia"
  IDS_MI_DEBUG_MODE_AUTOPLAY      "Autoplay &Cronologia"
  IDS_MI_TOGGLE_MAINCPU_TRACE     "Traccia della CPU &principale"
  IDS_MI_TOGGLE_DRIVE0CPU_TRACE   "Traccia della CPU del drive&0"
  IDS_MI_TOGGLE_DRIVE1CPU_TRACE   "Traccia della CPU del drive&1"
#endif
  IDS_MI_SNAPSHOT_LOAD            "Carica &immagine dello snapshot..."
  IDS_MI_SNAPSHOT_SAVE            "Salva immagine dello sna&pshot..."
  IDS_MI_LOADQUICK                "&Carica immagine dello snapshot"
  IDS_MI_SAVEQUICK                "&Salva immagine dello snapshot"
  IDS_MI_EVENT_TOGGLE_RECORD      "Avvia/termina la &registrazione della cronologia"
  IDS_MI_EVENT_TOGGLE_PLAYBACK    "Avvia/termina la r&iproduzione della cronologia"
  IDS_MI_EVENT_SETMILESTONE       "Imposta segnalibro"
  IDS_MI_EVENT_RESETMILESTONE     "Vai al segnalibro"
  IDS_MI_EVENT_START_MODE_SAVE    "&Salva nuovo snapshot"
  IDS_MI_EVENT_START_MODE_LOAD    "&Carica snapshot esistente"
  IDS_MI_EVENT_START_MODE_RESET   "Avvia con &reset"
  IDS_MI_EVENT_START_MODE_PLAYBCK "Sovrascrivi la &riproduzione"
  IDS_MI_EVENT_DIRECTORY          "Seleziona i file/directory della cronologia"
  IDS_MI_MEDIAFILE                "Salva/arresta file multimediale..."
  IDS_MI_SOUND_RECORD_START       "Registra audio..."
  IDS_MI_SOUND_RECORD_STOP        "Interrompi la registrazione audio"
  IDS_MI_REFRESH_RATE_AUTO        "&Auto"
  IDS_MI_MAXIMUM_SPEED_NO_LIMIT   "Nessun &limite"
  IDS_MI_MAXIMUM_SPEED_CUSTOM     "&Personalizzata"
  IDS_MI_TOGGLE_WARP_MODE         "Modalit &turbo"
  IDS_MI_TOGGLE_ALWAYSONTOP       "Sempre in primo piano"
  IDS_MI_TOGGLE_FASTPAL           "Emulazione PAL"
  IDS_MI_TOGGLE_SCALE2X           "Scale2x"
  IDS_MI_SWAP_JOYSTICK            "Scambia &Joystick"
  IDS_MI_SWAP_EXTRA_JOYSTICK      "Scambia joystick su &Userport"
  IDS_MI_ALLOW_JOY_OPPOSITE       "Allow opposite joystick directions"
  IDS_MI_JOYKEYS_TOGGLE           "Attiva tasti joystick"
  IDS_MI_TOGGLE_VIRTUAL_DEVICES   "Attiva le periferiche &virtuali"
  IDS_MI_TOGGLE_EMUID             "&Identificazione dell'emulatore"
  IDS_MI_MOUSE                    "&Cattura eventi mouse"
  IDS_MI_AUTOSTART_SETTINGS       "Impostazioni &Avvio automatico..."
  IDS_MI_VIDEO_SETTINGS           "Impostazioni &video..."
  IDS_MI_DEVICEMANAGER            "Impostazioni &periferiche..."
  IDS_MI_JOY_SETTINGS             "Impostazioni &joystick..."
  IDS_MI_USERPORT_JOY_SETTINGS    "Impostazioni joystick su &Userport..."
  IDS_MI_SIDCART_JOY_SETTINGS     "Impostazioni joystick su %Sidcart..."
  IDS_MI_KEYBOARD_SETTINGS        "Impostazioni &tastiera..."
  IDS_MI_SOUND_SETTINGS           "Impostazioni a&udio..."
  IDS_MI_ROM_SETTINGS             "Impostazioni &ROM..."
  IDS_MI_RAM_SETTINGS             "Impostazioni RA&M..."
  IDS_MI_DATASETTE_SETTINGS       "Impostazioni r&egistratore..."
  IDS_MI_VICII_SETTINGS           "Impostazioni VIC-II..."
  IDS_MI_MOUSE_SETTINGS           "Impostazioni mo&use..."
  IDS_MI_SID_SETTINGS             "Impostazioni S&ID..."
  IDS_MI_RS232_SETTINGS           "Impostazioni RS&232..."
  IDS_MI_REU_SETTINGS             "Impostazioni &REU..."
  IDS_MI_GEORAM_SETTINGS          "Impostazioni &GEORAM..."
  IDS_MI_RAMCART_SETTINGS         "Impostazioni &RAMCART..."
  IDS_MI_DQBB_SETTINGS            "Impostazioni &Double Quick Brown Box..."
  IDS_MI_ISEPIC_SETTINGS          "Impostazioni I&sepic..."
  IDS_MI_MMC64_SETTINGS           "Impostazioni &MMC64..."
  IDS_MI_MIDI_SETTINGS            "Impostazioni M&IDI..."
  IDS_MI_DIGIMAX_SETTINGS         "Impostazioni &DIGIMAX..."
  IDS_MI_LIGHTPEN_SETTINGS        "Impostazioni &penna ottica..."
  IDS_MI_IDE64_SETTINGS           "Impostazioni &IDE64..."
#ifdef HAVE_TFE
  IDS_MI_TFE_SETTINGS             "Impostazioni &Ethernet..."
#endif
  IDS_MI_ACIA_SETTINGS            "Impostazioni &ACIA..."
  IDS_MI_RS232USER_SETTINGS       "Impostazioni RS&232 su userport..."
  IDS_MI_EASYFLASH_SETTINGS       "Impostazioni EasyFlash..."
  IDS_MI_SFX_SE_SETTINGS          "Impostazioni SFX Sound Expander..."
  IDS_MI_TOGGLE_SFX_SS            "Attiva SFX Sound Sampler"
  IDS_MI_SETTINGS_SAVE_FILE       "Salva le impostazioni attuali sul file specificato"
  IDS_MI_SETTINGS_LOAD_FILE       "Carica le impostazioni dal file specificato"
  IDS_MI_SETTINGS_SAVE            "&Salva le impostazioni attuali"
  IDS_MI_SETTINGS_LOAD            "&Carica le impostazioni salvate"
  IDS_MI_SETTINGS_DEFAULT         "&Ripristina le impostazioni originarie"
  IDS_MI_SAVE_SETTINGS_ON_EXIT    "Salva le impostazioni in u&scita"
  IDS_MI_CONFIRM_ON_EXIT          "&Conferma all'uscita"
  IDS_MI_LANG_EN                  "I&nglese"
  IDS_MI_LANG_DA                  "D&anese"
  IDS_MI_LANG_DE                  "&Tedesco"
  IDS_MI_LANG_FR                  "&Francese"
  IDS_MI_LANG_HU                  "&Ungherese"
  IDS_MI_LANG_IT                  "&Italiano"
  IDS_MI_LANG_NL                  "&Olandese"
  IDS_MI_LANG_PL                  "&Polacco"
  IDS_MI_LANG_SV                  "&Svedese"
  IDS_MI_LANG_TR                  "Tu&rco"
  IDS_MI_CMDLINE                  "&Opzioni della riga di comando"
  IDS_MI_CONTRIBUTORS             "&Collaboratori"
  IDS_MI_LICENSE                  "&Licenza"
  IDS_MI_WARRANTY                 "Nessuna &garanzia"
  IDS_MI_TOGGLE_FULLSCREEN        "A tutto schermo"
  IDS_MI_SIDCART_SETTINGS         "Impostazioni cartuccia &SID..."
  IDS_MI_MON_OPEN                 "&Apri"
  IDS_MI_MON_SAVE                 "&Salva"
  IDS_MI_MON_PRINT                "Stam&pa"
  IDS_MI_MON_EXIT                 "E&sci\tAlt+F4"
  IDS_MI_MON_STOP_DEBUG           "&Interrompi Debug"
  IDS_MI_MON_STOP_EXEC            "Interrompi E&secuzione"
  IDS_MI_MON_STEP_INTO            "Esegui &istruzione"
  IDS_MI_MON_STEP_OVER            "Esegui istruzione/&funzione"
  IDS_MI_MON_SKIP_RETURN          "Esegui fino al &ritorno"
  IDS_MI_MON_GOTO_CURSOR          "Vai al &cursore"
  IDS_MI_MON_EVAL                 "&Valutazione"
  IDS_MI_MON_CURRENT              "Istruzione &corrente"
  IDS_MI_MON_WND_EVAL             "&Finestra di valutazione"
  IDS_MI_MON_WND_REG              "Finestra dei &registri"
  IDS_MI_MON_WND_MEM              "Finestra di &memoria"
  IDS_MI_MON_WND_DIS              "Finestra di &disassemblaggio"
  IDS_MI_MON_WND_CONSOLE          "Finestra della &console"
  IDS_MI_MON_COMPUTER             "&Computer"
  IDS_MI_MON_DRIVE8               "Drive &8"
  IDS_MI_MON_DRIVE9               "Drive &9"
  IDS_MI_MON_CASCADE              "A &cascata"
  IDS_MI_MON_TILE_VERT            "Affianca &verticalmente"
  IDS_MI_MON_TILE_HORIZ           "Affianca &orizzontalmente"
  IDS_MI_MON_ARRANGE_ICONS        "&Disponi icone"
END



STRINGTABLE
LANGUAGE LANG_DUTCH, SUBLANG_NEUTRAL
BEGIN
  IDS_VICE_ERROR                  "VICE Fout!"
  IDS_VICE_INFORMATION            "VICE-informatie"
  IDS_VICE_QUESTION               "VICE vraag"
  IDS_FFMPEG_DLL_MISMATCH         "Uw ffmpeg dll versie is niet juist."
  IDS_DIRECTDRAW_ERROR            "DirectDraw fout: Code:%8x Fout:%s"
  IDS_CANNOT_SAVE_SETTINGS        "Kan de instellingen niet opslaan."
  IDS_CANNOT_LOAD_SETTINGS        "Kan de instellingen niet laden."
  IDS_DEFAULT_SETTINGS_RESTORED   "Standaardinstellingen hersteld."
  IDS_CANNOT_ATTACH_FILE          "Kan het opgegeven bestand niet koppelen"
  IDS_START_MONITOR               "%s\012\012Monitor starten? (Nee = reset, Annuleren = doorgaan"
  IDS_VICE_CPU_JAM                "VICE CPU HANGT"
  IDS_EXTEND_TO_40_TRACKS         "Bestand uitbreiden naar 40-sporen formaat?"
  IDS_DETACHED_DEVICE_S           "Apparaat %s ontkoppelt"
  IDS_ATTACHED_S_TO_DEVICE_S      "%s aan apparaat#%s gekoppelt"
  IDS_DETACHED_TAPE               "Tape ontkoppelt"
  IDS_HISTORY_RECORDED_UNKNOWN    "Geschiedenis opgenomen met onbekende VICE versie"
  IDS_HISTORY_RECORDED_VICE_S     "Geschiedenis opgenomen met VICE-%s"
  IDS_PAUSED                      "gepauzeerd"
  IDS_FRAME_NUMBER                "frame #"
  IDS_RESUMED                     "hervat"
  IDS_REALLY_EXIT                 "Wilt U echt afsluiten?\012\012Alle data in gemuleerd geheugen zal verloren gaan."
  IDS_CANNOT_AUTOSTART_FILE       "Kan opgegeven bestand niet autostarten."
  IDS_ATTACHED_TAPE_S             "Tape %s gekoppeld"
  IDS_SETTINGS_SAVED_SUCCESS      "Instellingen met succes opgeslagen."
  IDS_SETTINGS_LOADED_SUCCESS     "Instellingen met succes geladen."
  IDS_ATTACH_DISK_IMAGE           "Koppel schijfbestand aan"
  IDS_ATTACH_TAPE_IMAGE           "Koppel tapebestand aan"
  IDS_AUTOSTART_IMAGE             "Autostart disk-/tapebestand"
  IDS_INVALID_CARTRIDGE           "Ongeldige cartridge"
  IDS_BAD_CARTRIDGE_CONFIG        "Slechte cartridge configuratie in UI!"
  IDS_INVALID_CARTRIDGE_IMAGE     "Ongeldig cartridgebestand"
  IDS_LOG_CONSOLE_OUTPUT_IMAGE    "Logboek console uitvoer bestand"
  IDS_LOG_FILES_TYPE              "VICE console logboekbestanden (*.dbg)"
  IDS_CANNOT_WRITE_LOGFILE_S      "Kan logboekbestand `%s' niet schrijven."
  IDS_LOAD_FLIP_LIST_FILE         "Laad fliplijstbestand"
  IDS_CANNOT_READ_FLIP_LIST       "Kan het fliplijstbestand niet lezen"
  IDS_SAVE_FLIP_LIST_FILE         "Fliplijstbestand opslaan"
  IDS_CANNOT_WRITE_FLIP_LIST      "Kan fliplijstbestand niet schrijven"
  IDS_SELECT_KEYMAP_FILE          "Selecteer keymapbestand"
  IDS_SAVE_KEYMAP_FILE            "Keymapbestand opslaan"
  IDS_CANNOT_WRITE_KEYMAP_FILE    "Kan het keymapbestand niet schrijven"
  IDS_SAVE_CONFIG_FILE            "Sla configuratie bestand op"
  IDS_LOAD_CONFIG_FILE            "Laad configuratie bestand"
  IDS_MAPPING                     "Mapping"
  IDS_KEYBOARD_SETTINGS           "Toetsenbordinstellingen"
  IDS_ATTACH                      "&Koppel"
  IDS_PLEASE_ENTER_A_FILENAME     "Geef aub een bestandsnaam op."
  IDS_OVERWRITE_EXISTING_IMAGE    "Bestaand bestand overschrijven?"
  IDS_CANNOT_CREATE_IMAGE         "Kan bestand niet maken"
  IDS_COMMAND_LINE_OPTIONS        "Commando opties"
  IDS_COMMAND_OPTIONS_AVAIL       "Welke commando opties zijn beschikbaar?"
  IDS_NO_DRIVER_SELECT_SUPPORT    "Geen stuurprogramma geselecteerd, of geselecteerd stuurprogramma wordt niet ondersteund"
  IDS_CANT_WRITE_SCREENSHOT_S     "Kan schermafdrukbestand `%s' niet schrijven."
  IDS_AUTOSTART_DISK_IMAGE        "Autostart schijfbestand"
  IDS_SELECT_FS_DIRECTORY         "Selecteer bestandssysteemdirectory"
  IDS_PRINTER_USERPORT            "Printer Userport"
  IDS_PRINTER_4                   "Printer 4"
  IDS_PRINTER_5                   "Printer 5"
  IDS_DRIVE_8                     "Drive 8"
  IDS_DRIVE_9                     "Drive 9"
  IDS_DRIVE_10                    "Drive 10"
  IDS_DRIVE_11                    "Drive 11"
  IDS_PERIPHERAL_SETTINGS         "Randapparaatinstellingen"
  IDS_CANT_WRITE_SNAPSHOT_FILE    "Kan momentopnamebestand niet schrijven."
  IDS_CANNOT_READ_SNAPSHOT_IMG    "Kan momentopnamebestand niet lezen"
  IDS_LOAD_S_ROM_IMAGE            "Laad %s ROM-bestand"
  IDS_SELECT_ROMSET_ARCHIVE       "Selecteer romsetarchief"
  IDS_CANNOT_LOAD_ROMSET_ARCH     "Kan romsetarchief niet laden!"
  IDS_CANNOT_SAVE_ROMSET_ARCH     "Kan romsetarchief niet opslaan!"
  IDS_CANNOT_LOAD_ROMSET_FILE     "Kan romsetbestand niet laden!"
  IDS_CANNOT_SAVE_ROMSET_FILE     "Kan romsetbestand niet opslaan!"
  IDS_SELECT_ROMSET_FILE          "Selecteer romsetbestand"
  IDS_ROMSET                      "Romset"
  IDS_COMPUTER                    "Computer"
  IDS_DRIVE                       "Drive"
  IDS_ROM_SETTINGS                "ROM-instellingen"
  IDS_SAVE_SNAPSHOT_IMAGE         "Momentopnamebestand opslaan"
  IDS_CANNOT_WRITE_SNAPSHOT_S     "Kan momentopnamebestand `%s' niet schrijven."
  IDS_LOAD_SNAPSHOT_IMAGE         "Laad momentopnamebestand"
  IDS_COULD_NOT_LOAD_PALETTE      "Kon paletbestand niet laden."
  IDS_LOAD_VICE_PALETTE_FILE      "Laad VICE paletbestand"
  IDS_FULLSCREEN                  "Volscherm/DirectX"
  IDS_COLORS                      "Kleuren"
  IDS_NEW_PAL                     "Nieuwe PAL emulatie"
  IDS_VIDEO_SETTINGS              "Videoinstellingen"
  IDS_FILE_SYSTEM                 "Bestandssysteem"
#ifdef HAVE_OPENCBM
  IDS_REAL_IEC_DEVICE             "Echt IEC apparaat"
#endif
  IDS_RS232_DEVICE_I              "RS232 apparaat %i"
  IDS_ATTACH_CRT_CART_IMAGE       "Koppel CRT cartridgebestand"
  IDS_ATTACH_RAW_8KB_CART_IMAGE   "Koppel binair 8KB cartridgebestand"
  IDS_ATTACH_RAW_16KB_CART_IMG    "Koppel binair 16KB cartridgebestand"
  IDS_ATTACH_AR_CART_IMAGE        "Koppel Action Replay cartridgebestand"
  IDS_ATTACH_AR3_CART_IMAGE       "Koppel Action Replay III cartridgebestand"
  IDS_ATTACH_AR4_CART_IMAGE       "Koppel Action Replay 4 cartridgebestand"
  IDS_ATTACH_STARDOS_CART_IMAGE   "Koppel StarDOS cartridgebestand"
  IDS_ATTACH_ATOMIC_P_CART_IMG    "Koppel Atomic Power cartridgebestand"
  IDS_ATTACH_EPYX_FL_CART_IMG     "Koppel Epyx snellaad cartridgebestand"
  IDS_ATTACH_IEEE488_CART_IMG     "Koppel IEEE interface cartridgebestand"
  IDS_ATTACH_RETRO_R_CART_IMG     "Koppel Retro Replay cartridgebestand"
  IDS_ATTACH_IDE64_CART_IMAGE     "Koppel IDE64-interfacebestand"
  IDS_ATTACH_SS4_CART_IMAGE       "Koppel Super Snapshot 4 cartridgebestand"
  IDS_ATTACH_SS5_CART_IMAGE       "Koppel Super Snapshot 5 cartridgebestand"
  IDS_ATTACH_STB_CART_IMAGE       "Koppel Structured Basic cartidgebestand"
  IDS_MODEL                       "Model"
  IDS_DRIVE_SETTINGS              "Drive-instellingen"
  IDS_SELECT_START_SNAP_EVENT     "Selecteer start momentopname voor gebeurtenis geschiedenis"
  IDS_SELECT_END_SNAP_EVENT       "Selecteer eind momentopname voor gebeurtenis geschiedenis"
#ifdef UNSTABLE
  IDS_VERSION_S_UNSTABLE          "Versie %s *ONSTABIEL* (%s)"
#else
  IDS_VERSION_S                   "Versie %s (%s)"
#endif
  IDS_VICE_CONTRIBUTORS           "VICE medewerkers"
  IDS_WHO_MADE_WHAT               "Wie heeft wat gemaakt?"
  IDS_LICENSE                     "Licentie"
  IDS_NO_WARRANTY                 "Geen garantie!"
  IDS_VICE_WITHOUT_WARRANTY       "VICE heeft ABSOLUUT GEEN GARANTIE!"
  IDS_PRESS_KEY_NORTHWEST         "Druk toets voor NoordWest"
  IDS_PRESS_KEY_NORTH             "Druk toets voor Noord"
  IDS_PRESS_KEY_NORTHEAST         "Druk toets voor NoordOost"
  IDS_PRESS_KEY_EAST              "Druk toets voor Oost"
  IDS_PRESS_KEY_SOUTHEAST         "Druk toets voor ZuidOost"
  IDS_PRESS_KEY_SOUTH             "Druk toets voor Zuid"
  IDS_PRESS_KEY_SOUTHWEST         "Druk toets voor ZuidWest"
  IDS_PRESS_KEY_WEST              "Druk toets voor West"
  IDS_PRESS_KEY_FIRE              "Druk toets voor Vuur"
  IDS_NO_USERPORT_ADAPTER         "Geen userport joy adapter"
  IDS_CGA_USERPORT_ADAPTER        "CGA userport joy adapter"
  IDS_PET_USERPORT_ADAPTER        "PET userport joy adapter"
  IDS_HUMMER_USERPORT_ADAPTER     "HUMMER userport joy adapter"
  IDS_OEM_USERPORT_ADAPTER        "OEM userport joy adapter"
  IDS_HIT_USERPORT_ADAPTER        "HIT userport joy adapter"
  IDS_NO_SIDCART_JOY              "SIDcart joy uitschakelen"
  IDS_SIDCART_JOY                 "Activeer SIDcart joy"
  IDS_NUMPAD_AND_RCTRL            "Numpad + RCtrl"
  IDS_KEYSET_A                    "Keyset A"
  IDS_KEYSET_B                    "Keyset B"
  IDS_ALL_BUTTONS_AS_FIRE         "Alle knoppen gebruiken als vuur"
  IDS_NUMERIC_SEE_ABOVE           "numeriek (zie boven)"
  IDS_NO_BUTTON_NO_AUTOFIRE       "Geen knop - Autovuren is uit"
  IDS_ALL_FILES_FILTER            "Alle bestanden (*.*)"
  IDS_PALETTE_FILES_FILTER        "VICE paletbestanden (*.vpl)"
  IDS_SNAPSHOT_FILES_FILTER       "VICE momentopnamebestanden (*.vsf)"
  IDS_CBM_IMAGE_FILES_FILTER      "CBM bestanden (*.d64;*.d71;*.d80;*.d81;*.d82;*.g64;*.g41;*.x64;*.t64;*.tap;*.prg;*.p00)"
  IDS_DISK_IMAGE_FILES_FILTER     "Schijfbestanden (*.d64;*.d71;*.d80;*.d81;*.d82;*.g64;*.g41;*.x64)"
  IDS_TAPE_IMAGE_FILES_FILTER     "Tapebestanden (*.t64;*.tap)"
  IDS_ZIPPED_FILES_FILTER         "Ingepakte bestanden (*.zip;*.bz2;*.gz;*.d6z;*.d7z;*.d8z;*.g6z;*.g4z;*.x6z)"
  IDS_CRT_FILES_FILTER            "CRT cartridgebestanden (*.crt)"
  IDS_RAW_CART_FILES_FILTER       "Binaire cartridgebestanden (*.bin)"
  IDS_FLIP_LIST_FILES_FILTER      "VICE fliplijstbestanden (*.vfl)"
  IDS_ROMSET_FILES_FILTER         "VICE romsetbestanden (*.vrs)"
  IDS_ROMSET_ARCHIVES_FILTER      "VICE romsetarchieven (*.vra)"
  IDS_KEYMAP_FILES_FILTER         "VICE keymapbestanden (*.vkm)"
  IDS_PRGP00_FILES_FILTER         "Commodore emulator bestanden (*.prg;*.p00)"
  IDS_FLEXIBLE                    "Flexibel"
  IDS_ADJUSTING                   "Aanpassend"
  IDS_EXACT                       "Exact"
  IDS_SOUND_DRIVER_DIRECTX        "Geluid stuurprogramma: DirectX"
  IDS_SOUND_DRIVER_WMM            "Geluid stuurprogramma: WMM"
  IDS_MEDIA_FILES_FILTER          "Mediabestanden (*.bmp;*.gif;*.iff;*.jpg;*.pcx;*.png;*.ppm;*.wav;*.mp3;*.avi;*.mpg)"
  IDS_SPACE_KB                    " kB"
  IDS_CONFIGURE_KEYSET_A          "Configureer Keyset A"
  IDS_CONFIGURE_KEYSET_B          "Configureer Keyset B"
  IDS_SAVE_MEDIA_IMAGE            "Mediabestand opslaan"
  IDS_S_AT_D_SPEED                "%s met %d%% snelheid, %d fps%s"
  IDS_TAPE                        "Tape:"
  IDS_JOYSTICK_C                  "Joystick:"
  IDS_RECORDING                   "Opnemen\n%02d:%02d"
  IDS_PLAYBACK                    "Afspelen\n%02d:%02d (%02d:%02d)"
  IDS_UNKNOWN                     "Onbekend"
  IDS_P_NUMBER                    "<nummer>"
  IDS_SET_INPUT_JOYSTICK_1        "Zet invoer apparaat voor joystick #1"
  IDS_SET_INPUT_JOYSTICK_2        "Zet invoer apparaat voor joystick #2"
  IDS_SET_INPUT_EXTRA_JOYSTICK_1  "Zet invoer apparaat voor extra joystick #1"
  IDS_SET_INPUT_EXTRA_JOYSTICK_2  "Zet invoer apparaat voor extra joystick #2"
  IDS_SAVE_SETTINGS_ON_EXIT       "Instellingen (resources) opslaan bij afsluiten"
  IDS_NO_SAVE_SETTINGS_ON_EXIT    "Instellingen (resources) niet opslaan bij afsluiten"
  IDS_CONFIRM_QUIT_VICE           "Bevestigen van het afsluiten van VICE"
  IDS_NO_CONFIRM_QUIT_VICE        "Niet bevestigen van het afsluiten van VICE"
  IDS_USE_ALL_CPU_SMP             "Gebruik alle CPU's op SMP-systemen"
  IDS_USE_FIRST_CPU_SMP           "Gebruik alleen de eerste CPU op SMP-systemen"
  IDS_START_VICE_FULLSCREEN_MODE  "Start VICE in volschermmodus"
  IDS_DISABLE_DX9                 "DirectX9 video driver uitschakelen"
#ifdef SYS_SIGLIST_DECLARED
  IDS_RECEIVED_SIGNAL_D_S         "Onverwachte fout. Kreeg signaal %d (%s)."
#else
  IDS_RECEIVED_SIGNAL_D           "Onverwachte fout. Kreeg signaal %d."
#endif
#ifdef HAVE_NETWORK
  IDS_IDLE                        "Idle"
  IDS_SERVER_LISTENING            "Server wacht op verbinding"
  IDS_CONNECTED_SERVER            "Verbonden server"
  IDS_CONNECTED_CLIENT            "Verbonden client"
  IDS_INVALID_PORT_NUMBER         "Ongeldig poort nummer"
  IDS_ERROR_STARTING_SERVER       "Een fout is opgetreden bij het starten van de server."
  IDS_ERROR_CONNECTING_CLIENT     "Een fout is opgetreden bij het verbinden."
#endif
  IDS_SOUND_RECORDING_STARTED     "Geluidsopname gestart..."
  IDS_SOUND_RECORDING_STOPPED     "Geluidsopname gestopt..."
  IDS_OK                          "OK"
  IDS_CANCEL                      "Annuleren"
  IDS_NONE                        "Geen"
  IDS_BROWSE                      "&Bladeren..."
  IDS_SPECIFY_MIDI_IN             "kies MIDI-In apparaat"
  IDS_SPECIFY_MIDI_OUT            "Kies MIDI-uit apparaat"
  IDS_ERROR_SAVING_EASYFLASH_CRT  "Kan het EasyFlash crt bestand niet opslaan"
  IDS_DATASETTE_CAPTION           "Datasetteinstellingen"
  IDS_DATASETTE_RESET_WITH_CPU    "&Reset Datasette met CPU"
  IDS_DATASETTE_MOTOR_GROUP       "Snelheid van de motor tijdens lezen"
  IDS_DATASETTE_DELAY_TRIGGER     "Snelheidsinstellingen"
  IDS_DATASETTE_DELAY_AT_ZERO     "&nul-waarden cycli vertraging"
  IDS_TOGGLE_USEIECDEVICE         "&Gebruik IEC Apparaat"
  IDS_SELECTDISK                  "Disk &bestand"
  IDS_SELECTDIR                   "&Directory"
#ifdef HAVE_OPENCBM
  IDS_SELECTREAL                  "echt IEC appa&raat"
#endif
  IDS_SELECTNONE                  "G&een"
  IDS_AUTOSTART                   "&Autostart"
  IDS_BROWSEDIR                   "Bla&deren..."
  IDS_TOGGLE_ATTACH_READONLY      "Alleen lezen"
  IDS_TOGGLE_READP00              "&Lees P00-bestanden"
  IDS_TOGGLE_WRITEP00             "&Schrijf P00-bestanden"
  IDS_TOGGLE_HIDENONP00           "&Verberg non-P00-bestanden"
  IDS_JOYSTICK_CAPTION            "Joystickinstellingen"
  IDS_JOYSTICK_IN_PORT_1          "Joystick in poort #&1"
  IDS_SELECT_FIRE_BUTTON          "Selecteer vuur knop"
  IDS_AUTO_FIRE_BUTTON_SETTINGS   "Autofire knop instellingen"
  IDS_AUTOFIRE_SPEED              "Autofire &snelheid (1..32)"
  IDS_JOYSTICK_IN_PORT_2          "Joystick in poort #&2"
  IDS_JOY_CONFIG_A                "Configureer Keyset &A"
  IDS_JOY_CONFIG_B                "Configureer Keyset &B"
  IDS_JOY_CALIBRATE               "&Kalibreer Joystick(s)"
  IDS_EXTRA_JOYSTICK_CAPTION      "Extra joystick adapter instellingen"
  IDS_JOYSTICK_IN_EXTRA_PORT_1    "Joystick in extra poort #&1"
  IDS_JOYSTICK_IN_EXTRA_PORT_2    "Joystick in extra poort #&2"
  IDS_KEYSET_SW                   "Z&uid West"
  IDS_KEYSET_S                    "&Zuiden"
  IDS_KEYSET_SE                   "Z&uid Oost"
  IDS_KEYSET_W                    "&West"
  IDS_KEYSET_E                    "&Oost"
  IDS_KEYSET_NW                   "Noo&rd West"
  IDS_KEYSET_N                    "&Noord"
  IDS_KEYSET_NE                   "Noord Oos&t"
  IDS_KEYSET_FIRE                 "&Vuur knop"
  IDS_SOUND_CAPTION               "Geluidsapparaatinstellingen"
  IDS_SOUND_DIRECTX               "DirectX stuurprogramma"
  IDS_SOUND_WMM                   "WMM stuurprogramma"
  IDS_SOUND_SAMPLE_FREQUENCY      "Sample &Frequency :"
  IDS_SOUND_BUFFER_SIZE           "Geluidsbuffer&grootte :"
  IDS_SOUND_FRAGMENT_SIZE_LABEL   "Geluid fragment grootte :"
  IDS_SOUND_FRAGMENT_SIZE_SMALL   "Klein"
  IDS_SOUND_FRAGMENT_SIZE_MEDIUM  "Medium"
  IDS_SOUND_FRAGMENT_SIZE_LARGE   "Groot"
  IDS_SOUND_SYNCH_METHOD          "Synchronisatie&methode :"
  IDS_TOGGLE_SNAPSHOT_SAVE_DISKS  "Sla huidig gekoppelde &schijfbestanden op"
  IDS_TOGGLE_SNAPSHOT_SAVE_ROMS   "Sla huidig gekoppelde &ROMs op"
  IDS_FULLSCREEN_DRIVER           "Stuurprogramma:"
  IDS_FULLSCREEN_DRVR_BITDEPTH    "Bitdiepte:"
  IDS_FULLSCREEN_DRVR_RESOLUTION  "Resolutie:"
  IDS_FULLSCREEN_DRVR_REFRESHRATE "Vernieuwingssnelheid:"
  IDS_TOGGLE_VIDEO_VBLANK_SYNC    "VBLANK synchronisatie"
  IDS_TOGGLE_VIDEO_DX_PRIMARY     "Render naar DX Primaire oppervlakte"
  IDS_TOGGLE_KEEP_ASPECT_RATIO    "Aspect ratio gebruiken (0,5..2)"
  IDS_COLORS_SATURATION           "Verzadiging (0..2)"
  IDS_COLORS_CONTRAST             "Contrast (0..2)"
  IDS_COLORS_BRIGHTNESS           "Helderheid (0..2)"
  IDS_NEW_PAL_TINT                "Tint (0..2)"
  IDS_NEW_PAL_ODD_LINES_PHASE     "Oneven lijnen fase (0..2)"
  IDS_NEW_PAL_ODD_LINES_OFFSET    "Oneven lijnen compensatie (0..2)"
  IDS_VIDEO_GAMMA                 "Gamma (0..2)"
  IDS_VIDEO_PHASE                 "Fase (0..2)"
  IDS_VIDEO_PAL_SHADE             "PAL-schaduw (0..1)"
  IDS_VIDEO_PAL_BLUR              "PAL-wazigheid (0..1)"
  IDS_TOGGLE_VIDEO_EXTPALETTE     "Extern palet:"
  IDS_RAM_CAPTION                 "RAM-instellingen"
  IDS_RAM_INIT_AT_POWERUP         "Initialisatie bij opstarten"
  IDS_RAM_VALUE_FIRST_BYTE        "Waarde van eerste byte"
  IDS_RAM_LENGTH_CONSTANT_VALUES  "Lengte van constante waarden"
  IDS_RAM_LENGTH_CONSTANT_PATTERN "Lengte van constant patroon"
  IDS_PRINTER_EMULATION           "Printer emulatie"
  IDS_PRINTER_FORMFEED            "Zend Formfeed"
  IDS_FILESYSTEM_PRINTER          "Bestandssysteem printer"
  IDS_PRINTER_DRVR                "Printer stuurprogramma"
  IDS_OUTPUT                      "Uitvoer"
  IDS_OUTPUT_TO_FILE              "Uitvoer naar bestand #"
  IDS_OUTPUT_FILE1_NAME           "Uitvoer bestand #1 naam"
  IDS_OUTPUT_FILE2_NAME           "Uitvoer bestand #2 naam"
  IDS_OUTPUT_FILE3_NAME           "Uitvoer bestand #3 naam"
  IDS_ROMSET_SELECT_ARCHIVE       "Romset archief"
  IDS_ROMSET_ARCHIVE_LOAD         "Laad archief"
  IDS_ROMSET_ARCHIVE_SAVE         "Opslaan archief"
  IDS_ROMSET_CONFIGURATION        "&Configuratie"
  IDS_ROMSET_ARCHIVE_APPLY        "Toepassen"
  IDS_ROMSET_ARCHIVE_NEW          "Nieuw"
  IDS_ROMSET_ARCHIVE_DELETE       "Verwijderen"
  IDS_ROMSET_SELECT_FILE          "Romsetbestand"
  IDS_ROMSET_FILE_LOAD            "Laad romset"
  IDS_ROMSET_FILE_SAVE            "Opslaan romset"
  IDS_CUSTOM_SPEED_CAPTION        "Aangepaste snelheid"
  IDS_ENTER_CUSTOM_SPEED          "Geef snelheid op [%]"
  IDS_NEW_CONFIGURATION           "Nieuwe configuratie"
  IDS_ENTER_CONFIGURATION_NAME    "Geef configuratie naam op"
  IDS_RS232_CAPTION               "RS232-instellingen"
  IDS_RS232_DEV_1                 "RS232 apparaat 1"
  IDS_RS232_DEV_2                 "RS232 apparaat 2"
  IDS_RS232_DEV_3                 "RS232 apparaat 3"
  IDS_RS232_DEV_4                 "RS232 apparaat 4"
  IDS_NETWORK_CAPTION             "Netplayinstellingen"
  IDS_CURRENT_MODE                "Huidige modus"
  IDS_SERVER_BIND                 "Server binding"
  IDS_TCP_PORT                    "TCP-Poort"
  IDS_NETWORK_SERVER              "Start server"
  IDS_NETWORK_CLIENT              "Maak verbinding naar"
  IDS_NETWORK_DISCONNECT          "Verbreek verbinding"
  IDS_CONTROL                     "Besturing"
  IDS_SERVER                      "Server"
  IDS_CLIENT                      "Client"
  IDS_KEYBOARD                    "Toetsenbord"
  IDS_JOYSTICK_1                  "Joystick 1"
  IDS_JOYSTICK_2                  "Joystick 2"
  IDS_DEVICES                     "Apparaten"
  IDS_SETTINGS                    "Instellingen"
  IDS_TOGGLE_CONSOLE_APPEND       "&Logboek aan bestaand bestand toevoegen"
  IDS_IMAGE_CONTENTS              "Bestandsinhoud"
  IDS_NEW_IMAGE                   "Nieuw Bestand"
  IDS_NAME                        "Naam"
  IDS_ID                          "ID"
  IDS_TYPE                        "Soort"
  IDS_BLANK_IMAGE                 "Maak Bestand"
  IDS_NEW_TAP_IMAGE               "Nieuw TAP-bestand"
  IDS_SAVE                        "Opslaan"
  IDS_SELECT_DRIVER               "Selecteer Stuurprogramma"
  IDS_FFMPEG_SETTINGS             "FFMPEG-instellingen"
  IDS_FORMAT                      "Formaat"
  IDS_AUDIO_CODEC                 "Audio codec"
  IDS_BITRATE                     "bitrate"
  IDS_VIDEO_CODEC                 "Video codec"
  IDS_SOUND_RECORD_CAPTION        "Geluidsopname instellingen"
  IDS_SOUND_RECORD_FORMAT_LABEL   "Geluidsopname formaat"
  IDS_SOUND_RECORD_FILE_LABEL     "Geluidsopnamebestand"
  IDS_KERNAL                      "Kernal"
  IDS_BASIC                       "Basic"
  IDS_CHARACTER                   "Character"
  IDS_COMPUTER_RESOURCES_CAPTION  "Computer resources"
  IDS_COMPUTER_RESOURCES          "Computer resources opgeslagen naar romset"
  IDS_DRIVE_RESOURCES_CAPTION     "Drive resources"
  IDS_DRIVE_RESOURCES             "Drive resources opgeslagen naar romset"
  IDS_SYMBOLIC                    "&Symbolisch"
  IDS_POSITIONAL                  "&Positioneel"
  IDS_DUMP_KEYSET                 "Keyset opslaan"
  IDS_DUMP_SHORTCUTS              "Shortcuts opslaan"
  IDS_SYMBOLIC_US                 "&Symbolisch US"
  IDS_SYMBOLIC_DE                 "&Symbolisch DE"
  IDS_GR_SYM                      "&Gr Sym."
  IDS_GR_POS                      "G&r Pos."
  IDS_UK_SYM                      "&UK Sym."
  IDS_UK_POS                      "U&K Pos."
  IDS_DE_SYM                      "&DE Sym."
  IDS_DE_POS                      "D&E Pos."
  IDS_A_MEMORY                    "&Geheugen"
  IDS_DRIVE_TYPE                  "&Drivesoort"
  IDS_40_TRACK_HANDLING           "40 &sporen ondersteuning"
  IDS_SELECT_DRIVE_EXTEND_NEVER   "Nooit uitbreiden"
  IDS_SELECT_DRIVE_EXTEND_ASK     "Vragen bij uitbreiden"
  IDS_SELECT_DRIVE_EXTEND_ACCESS  "Uitbreiden bij toegang"
  IDS_IDLE_METHOD                 "Id&le methode"
  IDS_SELECT_DRIVE_IDLE_TRAP_IDLE "Trap idle"
  IDS_SELECT_DRIVE_IDLE_SKIP_CYC  "Sla cycli over"
  IDS_TOGGLE_DRIVE_PARALLEL_CABLE "&Parallele kabel"
  IDS_DRIVE_EXPANSION             "Drive &uitbreiding"
  IDS_TOGGLE_DRIVE_EXPANSION_2000 "$2000-$3FFF &RAM"
  IDS_TOGGLE_DRIVE_EXPANSION_4000 "$&4000-$5FFF RAM"
  IDS_TOGGLE_DRIVE_EXPANSION_6000 "$&6000-$7FFF RAM"
  IDS_TOGGLE_DRIVE_EXPANSION_8000 "$8000-$9FFF RA&M"
  IDS_TOGGLE_DRIVE_EXPANSION_A000 "$&A000-$BFFF RAM"
  IDS_PLUS4_VIC20_MEMORY          "&Geheugen"
  IDS_SID_GENGROUP1               "SID Engine/Model"
  IDS_SID_FILTERS                 "SID-filters"
  IDS_MP_FILE                     "&Bestand"
  IDS_MP_ATTACH_DISK_IMAGE        "Koppel &schijfbestand aan"
  IDS_MP_DETACH_DISK_IMAGE        "Ontkopp&el schijfbestand"
  IDS_MP_FLIP_LIST                "&Flip lijst"
  IDS_MP_DATASETTE_CONTROL        "Datassette bedie&ning"
  IDS_MP_ATTACH_CARTRIDGE_IMAGE   "Koppel &cartridgebestand..."
  IDS_MP_EXPERT_CARTRIDGE         "Expert Cartridge"
  IDS_MP_RESET                    "&Reset"
  IDS_MP_DEBUG                    "&Debug"
#ifdef DEBUG
  IDS_MP_MODE                     "M&odus"
#endif
  IDS_MP_EDIT                     "&Bewerken"
  IDS_MP_SNAPSHOT                 "Momento&pname"
  IDS_MP_RECORDING_START_MODE     "Opname start modus"
  IDS_MP_OPTIONS                  "&Opties"
  IDS_MP_REFRESH_RATE             "Ve&rversingssnelheid"
  IDS_MP_MAXIMUM_SPEED            "&Maximale Snelheid"
  IDS_MP_VIDEO_STANDARD           "Vide&ostandaard"
  IDS_MP_DRIVE_SYNC_FACTOR        "Drive s&ynchronisatie faktor"
  IDS_MP_SETTINGS                 "Inst&ellingen"
  IDS_MP_CARTRIDGE_IO_SETTINGS    "&Cartridge/IO-instellingen"
  IDS_MP_LANGUAGE                 "&Taal"
  IDS_MP_HELP                     "&Help"
  IDS_MP_VIEW                     "&Beeld"
  IDS_MP_WINDOW                   "&Venster"
  IDS_MI_EXIT                     "Af&sluiten"
  IDS_MI_ABOUT                    "&Over VICE..."
  IDS_MI_PAUSE                    "&Pauze"
  IDS_MI_EDIT_COPY                "&Kopie"
  IDS_MI_EDIT_PASTE               "&Plakken"
  IDS_MI_AUTOSTART                "&Autostart disk-/tapebestand..."
  IDS_MI_RESET_HARD               "&Hard"
  IDS_MI_RESET_SOFT               "&Zacht"
  IDS_MI_DRIVE8                   "Drive &8"
  IDS_MI_DRIVE9                   "Drive &9"
  IDS_MI_DRIVE10                  "Drive 1&0"
  IDS_MI_DRIVE11                  "Drive 1&1"
  IDS_MI_ATTACH_TAPE              "Koppel &tapebestand..."
  IDS_MI_DETACH_TAPE              "Ontkoppe&l tapebestand"
  IDS_MI_DETACH_ALL               "&Alles"
  IDS_MI_TOGGLE_SOUND             "Geluid&suitvoer"
  IDS_MI_TOGGLE_DOUBLESIZE        "&Dubbele grootte"
  IDS_MI_TOGGLE_DOUBLESCAN        "Du&bbele scan"
  IDS_MI_DRIVE_TRUE_EMULATION     "&Hardwarematige driveemulatie"
  IDS_MI_AUTOSTART_HANDLE_TDE     "Manipuleer hardwarematige drive emulatie bij autostarten"
  IDS_MI_TOGGLE_VIDEOCACHE        "Video &cache"
  IDS_MI_DRIVE_SETTINGS           "&Drive-instellingen..."
  IDS_MI_CART_ATTACH_CRT          "&CRT-bestand..."
  IDS_MI_CART_ATTACH_8KB          "Algemeen &8KB-bestand..."
  IDS_MI_CART_ATTACH_16KB         "Algemeen &16KB-bestand..."
  IDS_MI_CART_ATTACH_AR           "&Action Replay-bestand..."
  IDS_MI_CART_ATTACH_AR3          "Action Replay III-bestand..."
  IDS_MI_CART_ATTACH_AR4          "Action Replay 4-bestand..."
  IDS_MI_CART_ATTACH_STARDOS      "StarDOS-bestand..."
  IDS_MI_CART_ATTACH_AT           "Atomic &Power-bestand..."
  IDS_MI_CART_ATTACH_EPYX         "&Epyx fastloadbestand..."
  IDS_MI_CART_ATTACH_IEEE488      "&IEEE488-interfacebestand..."
  IDS_MI_CART_ATTACH_RR           "&Retro Replay-bestand..."
  IDS_MI_CART_ATTACH_IDE64        "IDE&64-interfacebestand..."
  IDS_MI_CART_ATTACH_SS4          "Super Snapshot &4-bestand..."
  IDS_MI_CART_ATTACH_SS5          "Super Snapshot &5-bestand..."
  IDS_MI_CART_ATTACH_STB          "Structured &Basic-bestand..."
  IDS_MI_FLIP_ADD                 "Voeg huidig best&and toe"
  IDS_MI_FLIP_REMOVE              "Ve&rwijder huidig bestand"
  IDS_MI_FLIP_NEXT                "Koppel volge&nd bestand"
  IDS_MI_FLIP_PREVIOUS            "Koppel vori&g bestand"
  IDS_MI_FLIP_LOAD                "&Laad fliplijst"
  IDS_MI_FLIP_SAVE                "Op&slaan fliplijst"
  IDS_MI_DATASETTE_STOP           "S&top"
  IDS_MI_DATASETTE_START          "&Start"
  IDS_MI_DATASETTE_FORWARD        "&Vooruit"
  IDS_MI_DATASETTE_REWIND         "Te&rug"
  IDS_MI_DATASETTE_RECORD         "Op&name"
  IDS_MI_DATASETTE_RESET          "R&eset"
  IDS_MI_DATASETTE_RESET_COUNTER  "Reset T&eller"
  IDS_MI_CART_ENABLE_EXPERT       "Activeer"
  IDS_MI_CART_MODE_OFF            "Uit"
  IDS_MI_CART_MODE_ON             "Aan"
  IDS_MI_CART_SET_DEFAULT         "Zet cartridge als stan&daard"
  IDS_MI_TOGGLE_CART_RESET        "Reset bij cart wisse&ling"
  IDS_MI_CART_DETACH              "Ontkoppel cartr&idgebestand"
  IDS_MI_CART_FREEZE              "Cartridge free&ze"
  IDS_MI_MONITOR                  "&Monitor"
#ifdef DEBUG
  IDS_MI_DEBUG_MODE_NORMAL        "&Normaal"
  IDS_MI_DEBUG_MODE_SMALL         "&Klein"
  IDS_MI_DEBUG_MODE_HISTORY       "&Geschiedenis"
  IDS_MI_DEBUG_MODE_AUTOPLAY      "&Autospeel geschiedenis"
  IDS_MI_TOGGLE_MAINCPU_TRACE     "&Hoofd CPU Trace"
  IDS_MI_TOGGLE_DRIVE0CPU_TRACE   "Drive&0 CPU Trace"
  IDS_MI_TOGGLE_DRIVE1CPU_TRACE   "Drive&1 CPU Trace"
#endif
  IDS_MI_SNAPSHOT_LOAD            "Laad momentopnamebest&and..."
  IDS_MI_SNAPSHOT_SAVE            "Opslaan momento&pnamebestand..."
  IDS_MI_LOADQUICK                "Snel&laad momentopnamebestand"
  IDS_MI_SAVEQUICK                "&Snelopslaan momentopnamebestand"
  IDS_MI_EVENT_TOGGLE_RECORD      "Sta&rt/Stop opnamegeschiedenis"
  IDS_MI_EVENT_TOGGLE_PLAYBACK    "Start/Stop &Afspeelgeschiedenis"
  IDS_MI_EVENT_SETMILESTONE       "Zet Opname Mijlpaal"
  IDS_MI_EVENT_RESETMILESTONE     "Ga terug naar Mijlpaal"
  IDS_MI_EVENT_START_MODE_SAVE    "Op&slaan nieuwe momentopname"
  IDS_MI_EVENT_START_MODE_LOAD    "&Laad bestaande momentopname"
  IDS_MI_EVENT_START_MODE_RESET   "Start bij &reset"
  IDS_MI_EVENT_START_MODE_PLAYBCK "Overschrijf weer&gave"
  IDS_MI_EVENT_DIRECTORY          "Selecteer geschiedenisdirectory"
  IDS_MI_MEDIAFILE                "Opslaan/stop mediabestand..."
  IDS_MI_SOUND_RECORD_START       "Geluidsopname..."
  IDS_MI_SOUND_RECORD_STOP        "Stop geluidsopname"
  IDS_MI_REFRESH_RATE_AUTO        "&Automatisch"
  IDS_MI_MAXIMUM_SPEED_NO_LIMIT   "Geen &limiet"
  IDS_MI_MAXIMUM_SPEED_CUSTOM     "&Aangepast"
  IDS_MI_TOGGLE_WARP_MODE         "&Warpmodus"
  IDS_MI_TOGGLE_ALWAYSONTOP       "Altijd in de voorgrond"
  IDS_MI_TOGGLE_FASTPAL           "PAL-emulatie"
  IDS_MI_TOGGLE_SCALE2X           "Schaal2x"
  IDS_MI_SWAP_JOYSTICK            "Verwissel &Joysticks"
  IDS_MI_SWAP_EXTRA_JOYSTICK      "Verwissel &Userport joysticks"
  IDS_MI_ALLOW_JOY_OPPOSITE       "Tegenovergestelde joystick richtingen toestaan"
  IDS_MI_JOYKEYS_TOGGLE           "Activeer Joy Keys"
  IDS_MI_TOGGLE_VIRTUAL_DEVICES   "&Virtuele apparaattraps"
  IDS_MI_TOGGLE_EMUID             "Emulator &Identificatie"
  IDS_MI_MOUSE                    "&Pak mouse gebeurtenissen"
  IDS_MI_AUTOSTART_SETTINGS       "&Autostart instellingen..."
  IDS_MI_VIDEO_SETTINGS           "&Videoinstellingen..."
  IDS_MI_DEVICEMANAGER            "Randa&pparateninstellingen..."
  IDS_MI_JOY_SETTINGS             "&Joystick-instellingen..."
  IDS_MI_USERPORT_JOY_SETTINGS    "&Userport joystick instellingen..."
  IDS_MI_SIDCART_JOY_SETTINGS     "&Sidcart joystick instellingen..."
  IDS_MI_KEYBOARD_SETTINGS        "&Toetsenbordinstellingen..."
  IDS_MI_SOUND_SETTINGS           "G&eluidsinstellingen..."
  IDS_MI_ROM_SETTINGS             "&ROM-instellingen..."
  IDS_MI_RAM_SETTINGS             "RA&M-instellingen..."
  IDS_MI_DATASETTE_SETTINGS       "D&atasette-instellingen..."
  IDS_MI_VICII_SETTINGS           "VIC-II-instellingen..."
  IDS_MI_MOUSE_SETTINGS           "M&uis instellingen..."
  IDS_MI_SID_SETTINGS             "S&ID-instellingen..."
  IDS_MI_RS232_SETTINGS           "RS&232-instellingen..."
  IDS_MI_REU_SETTINGS             "&REU-instellingen..."
  IDS_MI_GEORAM_SETTINGS          "&GEORAM-instellingen..."
  IDS_MI_RAMCART_SETTINGS         "&RAMCART-instellingen..."
  IDS_MI_DQBB_SETTINGS            "&Double Quick Brown Box instellingen..."
  IDS_MI_ISEPIC_SETTINGS          "I&sepic-instelling..."
  IDS_MI_MMC64_SETTINGS           "&MMC64-instellingen..."
  IDS_MI_MIDI_SETTINGS            "M&IDI-instellingen..."
  IDS_MI_DIGIMAX_SETTINGS         "&DIGIMAX-instellingen..."
  IDS_MI_LIGHTPEN_SETTINGS        "&Lichtpen instellingen..."
  IDS_MI_IDE64_SETTINGS           "&IDE64-instellingen..."
#ifdef HAVE_TFE
  IDS_MI_TFE_SETTINGS             "&Ethernetinstellingen..."
#endif
  IDS_MI_ACIA_SETTINGS            "&ACIA-instellingen..."
  IDS_MI_RS232USER_SETTINGS       "RS&232-userportinstellingen..."
  IDS_MI_EASYFLASH_SETTINGS       "EasyFlash instellingen..."
  IDS_MI_SFX_SE_SETTINGS          "SFX Sound Expander instellingen..."
  IDS_MI_TOGGLE_SFX_SS            "Activeer SFX Sound Sampler"
  IDS_MI_SETTINGS_SAVE_FILE       "Huidige instellingen opslaan naar opgegeven bestand"
  IDS_MI_SETTINGS_LOAD_FILE       "Instellingen laden van opgegeven bestand"
  IDS_MI_SETTINGS_SAVE            "Huidige instellingen op&slaan"
  IDS_MI_SETTINGS_LOAD            "Opges&lagen instelling laden"
  IDS_MI_SETTINGS_DEFAULT         "Herstel standaar&dinstellingen"
  IDS_MI_SAVE_SETTINGS_ON_EXIT    "Sla instellingen op bij afslui&ten"
  IDS_MI_CONFIRM_ON_EXIT          "Bevestigen bij afsl&uiten"
  IDS_MI_LANG_EN                  "&Engels"
  IDS_MI_LANG_DA                  "D&eens"
  IDS_MI_LANG_DE                  "&Duits"
  IDS_MI_LANG_FR                  "&Frans"
  IDS_MI_LANG_HU                  "&Hongaars"
  IDS_MI_LANG_IT                  "&Italiaans"
  IDS_MI_LANG_NL                  "&Nederlands"
  IDS_MI_LANG_PL                  "&Pools"
  IDS_MI_LANG_SV                  "&Zweeds"
  IDS_MI_LANG_TR                  "&Turks"
  IDS_MI_CMDLINE                  "Commando invoer &opties"
  IDS_MI_CONTRIBUTORS             "&Medewerkers aan het VICE project"
  IDS_MI_LICENSE                  "&Licensie"
  IDS_MI_WARRANTY                 "Geen &garantie"
  IDS_MI_TOGGLE_FULLSCREEN        "Volscherm"
  IDS_MI_SIDCART_SETTINGS         "&SID cart-instellingen..."
  IDS_MI_MON_OPEN                 "&Open"
  IDS_MI_MON_SAVE                 "Op&slaan"
  IDS_MI_MON_PRINT                "&Print"
  IDS_MI_MON_EXIT                 "A&fsluiten\tAlt+F4"
  IDS_MI_MON_STOP_DEBUG           "&Stop Debug"
  IDS_MI_MON_STOP_EXEC            "Stop &Uitvoering"
  IDS_MI_MON_STEP_INTO            "Stap i&n"
  IDS_MI_MON_STEP_OVER            "Stap o&ver"
  IDS_MI_MON_SKIP_RETURN          "Stap tot &terugkeer"
  IDS_MI_MON_GOTO_CURSOR          "Ga naar &cursor"
  IDS_MI_MON_EVAL                 "&Evalueren"
  IDS_MI_MON_CURRENT              "&Huidige instructie"
  IDS_MI_MON_WND_EVAL             "Ev&aluatie venster"
  IDS_MI_MON_WND_REG              "&Register venster"
  IDS_MI_MON_WND_MEM              "&Geheugen venster"
  IDS_MI_MON_WND_DIS              "&Disassemblyvenster"
  IDS_MI_MON_WND_CONSOLE          "&Console venster"
  IDS_MI_MON_COMPUTER             "&Computer"
  IDS_MI_MON_DRIVE8               "Drive &8"
  IDS_MI_MON_DRIVE9               "Drive &9"
  IDS_MI_MON_CASCADE              "&Alle vensters"
  IDS_MI_MON_TILE_VERT            "&Naast elkaar"
  IDS_MI_MON_TILE_HORIZ           "Onder &elkaar"
  IDS_MI_MON_ARRANGE_ICONS        "&Rangschik iconen"
END



#pragma code_page(28592)
STRINGTABLE
LANGUAGE LANG_POLISH, SUBLANG_NEUTRAL
BEGIN
  IDS_VICE_ERROR                  "VICE Error!"
  IDS_VICE_INFORMATION            "VICE Information"
  IDS_VICE_QUESTION               "VICE question"
  IDS_FFMPEG_DLL_MISMATCH         "Your ffmpeg dll version doesn't match."
  IDS_DIRECTDRAW_ERROR            "DirectDraw error: Code:%8x Error:%s"
  IDS_CANNOT_SAVE_SETTINGS        "Cannot save settings."
  IDS_CANNOT_LOAD_SETTINGS        "Cannot load settings."
  IDS_DEFAULT_SETTINGS_RESTORED   "Default settings restored."
  IDS_CANNOT_ATTACH_FILE          "Cannot attach specified file"
  IDS_START_MONITOR               "%s\012\012Start monitor?"
  IDS_VICE_CPU_JAM                "VICE CPU JAM"
  IDS_EXTEND_TO_40_TRACKS         "Extend image to 40-track format?"
  IDS_DETACHED_DEVICE_S           "Detached device %s"
  IDS_ATTACHED_S_TO_DEVICE_S      "Attached %s to device#%s"
  IDS_DETACHED_TAPE               "Detached tape"
  IDS_HISTORY_RECORDED_UNKNOWN    "History recorded with unknown release"
  IDS_HISTORY_RECORDED_VICE_S     "History recorded with VICE-%s"
  IDS_PAUSED                      "paused"
  IDS_FRAME_NUMBER                "frame #"
  IDS_RESUMED                     "resumed"
  IDS_REALLY_EXIT                 "Do you really want to exit?\012\012All the data present in the emulated RAM will be lost."
  IDS_CANNOT_AUTOSTART_FILE       "Cannot autostart specified file."
  IDS_ATTACHED_TAPE_S             "Attached tape %s"
  IDS_SETTINGS_SAVED_SUCCESS      "Settings saved successfully."
  IDS_SETTINGS_LOADED_SUCCESS     "Settings loaded successfully."
  IDS_ATTACH_DISK_IMAGE           "Attach disk image"
  IDS_ATTACH_TAPE_IMAGE           "Attach tape image"
  IDS_AUTOSTART_IMAGE             "Autostart disk/tape image"
  IDS_INVALID_CARTRIDGE           "Invalid cartridge"
  IDS_BAD_CARTRIDGE_CONFIG        "Bad cartridge config in UI!"
  IDS_INVALID_CARTRIDGE_IMAGE     "Invalid cartridge image"
  IDS_LOG_CONSOLE_OUTPUT_IMAGE    "Logging console output image"
  IDS_LOG_FILES_TYPE              "VICE console logging files (*.dbg)"
  IDS_CANNOT_WRITE_LOGFILE_S      "Cannot write log file `%s'."
  IDS_LOAD_FLIP_LIST_FILE         "Load flip list file"
  IDS_CANNOT_READ_FLIP_LIST       "Cannot read flip list file"
  IDS_SAVE_FLIP_LIST_FILE         "Save flip list file"
  IDS_CANNOT_WRITE_FLIP_LIST      "Cannot write flip list file"
  IDS_SELECT_KEYMAP_FILE          "Select keymap file"
  IDS_SAVE_KEYMAP_FILE            "Save keymap file"
  IDS_CANNOT_WRITE_KEYMAP_FILE    "Cannot write keymap file"
  IDS_SAVE_CONFIG_FILE            "Save config file"
  IDS_LOAD_CONFIG_FILE            "Load config file"
  IDS_MAPPING                     "Mapping"
  IDS_KEYBOARD_SETTINGS           "Keyboard settings"
  IDS_ATTACH                      "&Attach"
  IDS_PLEASE_ENTER_A_FILENAME     "Please enter a filename."
  IDS_OVERWRITE_EXISTING_IMAGE    "Overwrite existing image?"
  IDS_CANNOT_CREATE_IMAGE         "Cannot create image"
  IDS_COMMAND_LINE_OPTIONS        "Command line options"
  IDS_COMMAND_OPTIONS_AVAIL       "Which command line options are available?"
  IDS_NO_DRIVER_SELECT_SUPPORT    "No driver selected or selected driver not supported"
  IDS_CANT_WRITE_SCREENSHOT_S     "Cannot write screenshot file `%s'."
  IDS_AUTOSTART_DISK_IMAGE        "Autostart disk image"
  IDS_SELECT_FS_DIRECTORY         "Select file system directory"
  IDS_PRINTER_USERPORT            "Printer Userport"
  IDS_PRINTER_4                   "Printer 4"
  IDS_PRINTER_5                   "Printer 5"
  IDS_DRIVE_8                     "Drive 8"
  IDS_DRIVE_9                     "Drive 9"
  IDS_DRIVE_10                    "Drive 10"
  IDS_DRIVE_11                    "Drive 11"
  IDS_PERIPHERAL_SETTINGS         "Peripheral Settings"
  IDS_CANT_WRITE_SNAPSHOT_FILE    "Can't write snapshot file."
  IDS_CANNOT_READ_SNAPSHOT_IMG    "Cannot read snapshot image"
  IDS_LOAD_S_ROM_IMAGE            "Load %s ROM image"
  IDS_SELECT_ROMSET_ARCHIVE       "Select romset archive"
  IDS_CANNOT_LOAD_ROMSET_ARCH     "Cannot load romset archive!"
  IDS_CANNOT_SAVE_ROMSET_ARCH     "Cannot save romset archive!"
  IDS_CANNOT_LOAD_ROMSET_FILE     "Cannot load romset file!"
  IDS_CANNOT_SAVE_ROMSET_FILE     "Cannot save romset file!"
  IDS_SELECT_ROMSET_FILE          "Select romset file"
  IDS_ROMSET                      "Romset"
  IDS_COMPUTER                    "Computer"
  IDS_DRIVE                       "Drive"
  IDS_ROM_SETTINGS                "ROM settings"
  IDS_SAVE_SNAPSHOT_IMAGE         "Save snapshot image"
  IDS_CANNOT_WRITE_SNAPSHOT_S     "Cannot write snapshot file `%s'."
  IDS_LOAD_SNAPSHOT_IMAGE         "Load snapshot image"
  IDS_COULD_NOT_LOAD_PALETTE      "Could not load palette file."
  IDS_LOAD_VICE_PALETTE_FILE      "Load VICE palette file"
  IDS_FULLSCREEN                  "Fullscreen/DirectX"
  IDS_COLORS                      "Colors"
  IDS_NEW_PAL                     "New PAL emulation"
  IDS_VIDEO_SETTINGS              "Video settings"
  IDS_FILE_SYSTEM                 "File system"
#ifdef HAVE_OPENCBM
  IDS_REAL_IEC_DEVICE             "Real IEC device"
#endif
  IDS_RS232_DEVICE_I              "RS232 device %i"
  IDS_ATTACH_CRT_CART_IMAGE       "Attach CRT cartridge image"
  IDS_ATTACH_RAW_8KB_CART_IMAGE   "Attach raw 8KB cartridge image"
  IDS_ATTACH_RAW_16KB_CART_IMG    "Attach raw 16KB cartridge image"
  IDS_ATTACH_AR_CART_IMAGE        "Attach Action Replay cartridge image"
  IDS_ATTACH_AR3_CART_IMAGE       "Attach Action Replay III cartridge image"
  IDS_ATTACH_AR4_CART_IMAGE       "Attach Action Replay 4 cartridge image"
  IDS_ATTACH_STARDOS_CART_IMAGE   "Attach StarDOS cartridge image"
  IDS_ATTACH_ATOMIC_P_CART_IMG    "Attach Atomic Power cartridge image"
  IDS_ATTACH_EPYX_FL_CART_IMG     "Attach Epyx fastload cartridge image"
  IDS_ATTACH_IEEE488_CART_IMG     "Attach IEEE interface cartridge image"
  IDS_ATTACH_RETRO_R_CART_IMG     "Attach Retro Replay cartridge image"
  IDS_ATTACH_IDE64_CART_IMAGE     "Attach IDE64 interface cartridge image"
  IDS_ATTACH_SS4_CART_IMAGE       "Attach Super Snapshot 4 cartridge image"
  IDS_ATTACH_SS5_CART_IMAGE       "Attach Super Snapshot 5 cartridge image"
  IDS_ATTACH_STB_CART_IMAGE       "Attach Structured Basic cartridge image"
  IDS_MODEL                       "Model"
  IDS_DRIVE_SETTINGS              "Drive Settings"
  IDS_SELECT_START_SNAP_EVENT     "Select start snapshot for event history"
  IDS_SELECT_END_SNAP_EVENT       "Select end snapshot for event history"
#ifdef UNSTABLE
  IDS_VERSION_S_UNSTABLE          "Version %s *UNSTABLE* (%s)"
#else
  IDS_VERSION_S                   "Version %s (%s)"
#endif
  IDS_VICE_CONTRIBUTORS           "VICE contributors"
  IDS_WHO_MADE_WHAT               "Who made what?"
  IDS_LICENSE                     "License"
  IDS_NO_WARRANTY                 "No warranty!"
  IDS_VICE_WITHOUT_WARRANTY       "VICE is distributed WITHOUT ANY WARRANTY!"
  IDS_PRESS_KEY_NORTHWEST         "Press key for NorthWest"
  IDS_PRESS_KEY_NORTH             "Press key for North"
  IDS_PRESS_KEY_NORTHEAST         "Press key for NorthEast"
  IDS_PRESS_KEY_EAST              "Press key for East"
  IDS_PRESS_KEY_SOUTHEAST         "Press key for SouthEast"
  IDS_PRESS_KEY_SOUTH             "Press key for South"
  IDS_PRESS_KEY_SOUTHWEST         "Press key for SouthWest"
  IDS_PRESS_KEY_WEST              "Press key for West"
  IDS_PRESS_KEY_FIRE              "Press key for Fire"
  IDS_NO_USERPORT_ADAPTER         "No userport joy adapter"
  IDS_CGA_USERPORT_ADAPTER        "CGA userport joy adapter"
  IDS_PET_USERPORT_ADAPTER        "PET userport joy adapter"
  IDS_HUMMER_USERPORT_ADAPTER     "HUMMER userport joy adapter"
  IDS_OEM_USERPORT_ADAPTER        "OEM userport joy adapter"
  IDS_HIT_USERPORT_ADAPTER        "HIT userport joy adapter"
  IDS_NO_SIDCART_JOY              "Disable SIDcart joy"
  IDS_SIDCART_JOY                 "Enable SIDcart joy"
  IDS_NUMPAD_AND_RCTRL            "Numpad + RCtrl"
  IDS_KEYSET_A                    "Keyset A"
  IDS_KEYSET_B                    "Keyset B"
  IDS_ALL_BUTTONS_AS_FIRE         "All buttons used as fire"
  IDS_NUMERIC_SEE_ABOVE           "numeric (see above)"
  IDS_NO_BUTTON_NO_AUTOFIRE       "No button - Autofire disabled"
  IDS_ALL_FILES_FILTER            "All files (*.*)"
  IDS_PALETTE_FILES_FILTER        "VICE palette files (*.vpl)"
  IDS_SNAPSHOT_FILES_FILTER       "VICE snapshot files (*.vsf)"
  IDS_CBM_IMAGE_FILES_FILTER      "CBM files (*.d64;*.d71;*.d80;*.d81;*.d82;*.g64;*.g41;*.x64;*.t64;*.tap;*.prg;*.p00)"
  IDS_DISK_IMAGE_FILES_FILTER     "Disk image files (*.d64;*.d71;*.d80;*.d81;*.d82;*.g64;*.g41;*.x64)"
  IDS_TAPE_IMAGE_FILES_FILTER     "Tape image files (*.t64;*.tap)"
  IDS_ZIPPED_FILES_FILTER         "Zipped files (*.zip;*.bz2;*.gz;*.d6z;*.d7z;*.d8z;*.g6z;*.g4z;*.x6z)"
  IDS_CRT_FILES_FILTER            "CRT cartridge image files (*.crt)"
  IDS_RAW_CART_FILES_FILTER       "Raw cartridge image files (*.bin)"
  IDS_FLIP_LIST_FILES_FILTER      "VICE flip list files (*.vfl)"
  IDS_ROMSET_FILES_FILTER         "VICE romset files (*.vrs)"
  IDS_ROMSET_ARCHIVES_FILTER      "VICE romset archives (*.vra)"
  IDS_KEYMAP_FILES_FILTER         "VICE keymap files (*.vkm)"
  IDS_PRGP00_FILES_FILTER         "Commodore emulator files (*.prg;*.p00)"
  IDS_FLEXIBLE                    "Flexible"
  IDS_ADJUSTING                   "Adjusting"
  IDS_EXACT                       "Exact"
  IDS_SOUND_DRIVER_DIRECTX        "Sound driver: DirectX"
  IDS_SOUND_DRIVER_WMM            "Sound driver: WMM"
  IDS_MEDIA_FILES_FILTER          "Media files (*.bmp;*.gif;*.iff;*.jpg;*.pcx;*.png;*.ppm;*.wav;*.mp3;*.avi;*.mpg)"
  IDS_SPACE_KB                    " kB"
  IDS_CONFIGURE_KEYSET_A          "Configure Keyset A"
  IDS_CONFIGURE_KEYSET_B          "Configure Keyset B"
  IDS_SAVE_MEDIA_IMAGE            "Save media image"
  IDS_S_AT_D_SPEED                "%s at %d%% speed, %d fps%s"
  IDS_TAPE                        "Tape:"
  IDS_JOYSTICK_C                  "Joystick:"
  IDS_RECORDING                   "Recording\n%02d:%02d"
  IDS_PLAYBACK                    "Playback\n%02d:%02d (%02d:%02d)"
  IDS_UNKNOWN                     "Unknown"
  IDS_P_NUMBER                    "<number>"
  IDS_SET_INPUT_JOYSTICK_1        "Set input device for joystick #1"
  IDS_SET_INPUT_JOYSTICK_2        "Set input device for joystick #2"
  IDS_SET_INPUT_EXTRA_JOYSTICK_1  "Set input device for extra joystick #1"
  IDS_SET_INPUT_EXTRA_JOYSTICK_2  "Set input device for extra joystick #2"
  IDS_SAVE_SETTINGS_ON_EXIT       "Save settings (resources) on exit"
  IDS_NO_SAVE_SETTINGS_ON_EXIT    "Never save settings (resources) on exit"
  IDS_CONFIRM_QUIT_VICE           "Confirm quiting VICE"
  IDS_NO_CONFIRM_QUIT_VICE        "Never confirm quiting VICE"
  IDS_USE_ALL_CPU_SMP             "Use all CPU on SMP systems"
  IDS_USE_FIRST_CPU_SMP           "Use only first CPU on SMP systems"
  IDS_START_VICE_FULLSCREEN_MODE  "Start VICE in fullscreen mode"
  IDS_DISABLE_DX9                 "Disable DirectX9 video driver"
#ifdef SYS_SIGLIST_DECLARED
  IDS_RECEIVED_SIGNAL_D_S         "An unexpected error occured. Received signal %d (%s)."
#else
  IDS_RECEIVED_SIGNAL_D           "An unexpected error occured. Received signal %d."
#endif
#ifdef HAVE_NETWORK
  IDS_IDLE                        "Idle"
  IDS_SERVER_LISTENING            "Server listening"
  IDS_CONNECTED_SERVER            "Connected server"
  IDS_CONNECTED_CLIENT            "Connected client"
  IDS_INVALID_PORT_NUMBER         "Invalid port number"
  IDS_ERROR_STARTING_SERVER       "An error occured starting the server."
  IDS_ERROR_CONNECTING_CLIENT     "An error occured connecting the client."
#endif
  IDS_SOUND_RECORDING_STARTED     "Sound Recording started..."
  IDS_SOUND_RECORDING_STOPPED     "Sound Recording stopped..."
  IDS_OK                          "OK"
  IDS_CANCEL                      "Anuluj"
  IDS_NONE                        "Brak"
  IDS_BROWSE                      "&Przegldaj..."
  IDS_SPECIFY_MIDI_IN             "Specify MIDI-In device"
  IDS_SPECIFY_MIDI_OUT            "Specify MIDI-Out device"
  IDS_ERROR_SAVING_EASYFLASH_CRT  "Error saving EasyFlash crt file"
  IDS_DATASETTE_CAPTION           "Ustawienia Datasette"
  IDS_DATASETTE_RESET_WITH_CPU    "&Resetuj Datasette razem z CPU"
  IDS_DATASETTE_MOTOR_GROUP       "Speed of motor while reading"
  IDS_DATASETTE_DELAY_TRIGGER     "Regulacja pr&dkoci Datasette"
  IDS_DATASETTE_DELAY_AT_ZERO     "cycles delay at &zero-values"
  IDS_TOGGLE_USEIECDEVICE         "&Uyj IEC urzdzenia"
  IDS_SELECTDISK                  "obraz dysk&ietki"
  IDS_SELECTDIR                   "&Katalog"
#ifdef HAVE_OPENCBM
  IDS_SELECTREAL                  "Prawdzi&wy IEC urzdzenia"
#endif
  IDS_SELECTNONE                  "&Brak"
  IDS_AUTOSTART                   "&Autostart"
  IDS_BROWSEDIR                   "Przegl&daj..."
  IDS_TOGGLE_ATTACH_READONLY      "W zabezpieczone przed zapisem"
  IDS_TOGGLE_READP00              "&Read P00 files"
  IDS_TOGGLE_WRITEP00             "&Write P00 files"
  IDS_TOGGLE_HIDENONP00           "&Hide non-P00 files"
  IDS_JOYSTICK_CAPTION            "Ustawienia Joystick"
  IDS_JOYSTICK_IN_PORT_1          "Joystick w porcie #&1"
  IDS_SELECT_FIRE_BUTTON          "Select fire button"
  IDS_AUTO_FIRE_BUTTON_SETTINGS   "Auto fire button settings"
  IDS_AUTOFIRE_SPEED              "Autofire &speed (1..32)"
  IDS_JOYSTICK_IN_PORT_2          "Joystick w porcie #&2"
  IDS_JOY_CONFIG_A                "Config Keyset &A"
  IDS_JOY_CONFIG_B                "Config Keyset &B"
  IDS_JOY_CALIBRATE               "&Calibrate Joystick(s)"
  IDS_EXTRA_JOYSTICK_CAPTION      "Extra joystick adapter settings"
  IDS_JOYSTICK_IN_EXTRA_PORT_1    "Joystick in extra port #&1"
  IDS_JOYSTICK_IN_EXTRA_PORT_2    "Joystick in extra port #&2"
  IDS_KEYSET_SW                   "S&outh West"
  IDS_KEYSET_S                    "&South"
  IDS_KEYSET_SE                   "So&uth East"
  IDS_KEYSET_W                    "&West"
  IDS_KEYSET_E                    "&East"
  IDS_KEYSET_NW                   "No&rth West"
  IDS_KEYSET_N                    "&North"
  IDS_KEYSET_NE                   "Nor&th East"
  IDS_KEYSET_FIRE                 "&Fire button"
  IDS_SOUND_CAPTION               "Ustawienia dwiku"
  IDS_SOUND_DIRECTX               "Sterownik DirectX"
  IDS_SOUND_WMM                   "Sterownik WMM"
  IDS_SOUND_SAMPLE_FREQUENCY      "Pr&dko sampli :"
  IDS_SOUND_BUFFER_SIZE           "Ro&zmiar buffora :"
  IDS_SOUND_FRAGMENT_SIZE_LABEL   "Sound Fragment Size :"
  IDS_SOUND_FRAGMENT_SIZE_SMALL   "Small"
  IDS_SOUND_FRAGMENT_SIZE_MEDIUM  "Medium"
  IDS_SOUND_FRAGMENT_SIZE_LARGE   "Large"
  IDS_SOUND_SYNCH_METHOD          "Synchronizac&ja dwiku :"
  IDS_TOGGLE_SNAPSHOT_SAVE_DISKS  "Zapisz obecnie woony &dysk"
  IDS_TOGGLE_SNAPSHOT_SAVE_ROMS   "Zapisz obecnie woony &ROM"
  IDS_FULLSCREEN_DRIVER           "Sterownik:"
  IDS_FULLSCREEN_DRVR_BITDEPTH    "Gbi koloru:"
  IDS_FULLSCREEN_DRVR_RESOLUTION  "Rozdzielczo:"
  IDS_FULLSCREEN_DRVR_REFRESHRATE "Czstotliwo odwierzania:"
  IDS_TOGGLE_VIDEO_VBLANK_SYNC    "Synchronizacja VBLANK"
  IDS_TOGGLE_VIDEO_DX_PRIMARY     "Render to DX Primary surface"
  IDS_TOGGLE_KEEP_ASPECT_RATIO    "Keep aspect ratio (0,5..2)"
  IDS_COLORS_SATURATION           "Nasycenie (0..2)"
  IDS_COLORS_CONTRAST             "Kontrast (0..2)"
  IDS_COLORS_BRIGHTNESS           "Jaskrawo (0..2)"
  IDS_NEW_PAL_TINT                "Tint (0..2)"
  IDS_NEW_PAL_ODD_LINES_PHASE     "Odd lines phase (0..2)"
  IDS_NEW_PAL_ODD_LINES_OFFSET    "Odd lines offset (0..2)"
  IDS_VIDEO_GAMMA                 "Gamma (0..2)"
  IDS_VIDEO_PHASE                 "Phase (0..2)"
  IDS_VIDEO_PAL_SHADE             "Cieniowane PAL (0..1)"
  IDS_VIDEO_PAL_BLUR              "PAL Blur (0..1)"
  IDS_TOGGLE_VIDEO_EXTPALETTE     "Zewntrzne ustawienia kolorw:"
  IDS_RAM_CAPTION                 "Ustawienia RAM"
  IDS_RAM_INIT_AT_POWERUP         "Initialization at powerup"
  IDS_RAM_VALUE_FIRST_BYTE        "Value of first byte"
  IDS_RAM_LENGTH_CONSTANT_VALUES  "Length of constant values"
  IDS_RAM_LENGTH_CONSTANT_PATTERN "Length of constant pattern"
  IDS_PRINTER_EMULATION           "Port emulacji drukarki"
  IDS_PRINTER_FORMFEED            "Send Formfeed"
  IDS_FILESYSTEM_PRINTER          "File system printer"
  IDS_PRINTER_DRVR                "Printer driver"
  IDS_OUTPUT                      "Output"
  IDS_OUTPUT_TO_FILE              "Output to file #"
  IDS_OUTPUT_FILE1_NAME           "Output file #1 name"
  IDS_OUTPUT_FILE2_NAME           "Output file #2 name"
  IDS_OUTPUT_FILE3_NAME           "Output file #3 name"
  IDS_ROMSET_SELECT_ARCHIVE       "Plik ustawie ROM"
  IDS_ROMSET_ARCHIVE_LOAD         "Load archive"
  IDS_ROMSET_ARCHIVE_SAVE         "Save archive"
  IDS_ROMSET_CONFIGURATION        "&Konfiguracja"
  IDS_ROMSET_ARCHIVE_APPLY        "Apply"
  IDS_ROMSET_ARCHIVE_NEW          "Nowy"
  IDS_ROMSET_ARCHIVE_DELETE       "pozostaych elementw"
  IDS_ROMSET_SELECT_FILE          "Romset file"
  IDS_ROMSET_FILE_LOAD            "Load romset"
  IDS_ROMSET_FILE_SAVE            "Save romset"
  IDS_CUSTOM_SPEED_CAPTION        "Custom speed"
  IDS_ENTER_CUSTOM_SPEED          "Wprowad prdko [%]"
  IDS_NEW_CONFIGURATION           "New configuration"
  IDS_ENTER_CONFIGURATION_NAME    "Enter configuration name"
  IDS_RS232_CAPTION               "Ustawienia RS232"
  IDS_RS232_DEV_1                 "urzdzenia RS232 1"
  IDS_RS232_DEV_2                 "urzdzenia RS232 2"
  IDS_RS232_DEV_3                 "urzdzenia RS232 3"
  IDS_RS232_DEV_4                 "urzdzenia RS232 4"
  IDS_NETWORK_CAPTION             "Netplay Settings"
  IDS_CURRENT_MODE                "Current mode"
  IDS_SERVER_BIND                 "Server Bind"
  IDS_TCP_PORT                    "TCP-Port"
  IDS_NETWORK_SERVER              "Start server"
  IDS_NETWORK_CLIENT              "Connect to"
  IDS_NETWORK_DISCONNECT          "Disconnect"
  IDS_CONTROL                     "Control"
  IDS_SERVER                      "Server"
  IDS_CLIENT                      "Client"
  IDS_KEYBOARD                    "Keyboard"
  IDS_JOYSTICK_1                  "Joystick 1"
  IDS_JOYSTICK_2                  "Joystick 2"
  IDS_DEVICES                     "Devices"
  IDS_SETTINGS                    "Settings"
  IDS_TOGGLE_CONSOLE_APPEND       "&Append log to existing file"
  IDS_IMAGE_CONTENTS              "zawartoci obrazu"
  IDS_NEW_IMAGE                   "New Image"
  IDS_NAME                        "Nazwa"
  IDS_ID                          "ID"
  IDS_TYPE                        "Typ"
  IDS_BLANK_IMAGE                 "Stwrz dyskietk"
  IDS_NEW_TAP_IMAGE               "New TAP Image"
  IDS_SAVE                        "Zapisz"
  IDS_SELECT_DRIVER               "Vlj drivrutin"
  IDS_FFMPEG_SETTINGS             "FFMPEG-instllningar"
  IDS_FORMAT                      "Format"
  IDS_AUDIO_CODEC                 "Ljud omkodare"
  IDS_BITRATE                     "bithastighet"
  IDS_VIDEO_CODEC                 "Video omkodare"
  IDS_SOUND_RECORD_CAPTION        "Sound record settings"
  IDS_SOUND_RECORD_FORMAT_LABEL   "Sound Record Format"
  IDS_SOUND_RECORD_FILE_LABEL     "Sound Record File"
  IDS_KERNAL                      "Kernal"
  IDS_BASIC                       "Basic"
  IDS_CHARACTER                   "Character"
  IDS_COMPUTER_RESOURCES_CAPTION  "Computer zasoby"
  IDS_COMPUTER_RESOURCES          "Computer zasoby powiodo to romset"
  IDS_DRIVE_RESOURCES_CAPTION     "napdu zasoby"
  IDS_DRIVE_RESOURCES             "Napdu zasoby powiodo to romset"
  IDS_SYMBOLIC                    "&Symboli"
  IDS_POSITIONAL                  "&Pooenia"
  IDS_DUMP_KEYSET                 "Zapisz mapowanie klawiszy"
  IDS_DUMP_SHORTCUTS              "Dump shortcuts"
  IDS_SYMBOLIC_US                 "&Symboli US"
  IDS_SYMBOLIC_DE                 "&Symboli DE"
  IDS_GR_SYM                      "&Gr Sym."
  IDS_GR_POS                      "G&r Po."
  IDS_UK_SYM                      "&UK Sym."
  IDS_UK_POS                      "U&K Po."
  IDS_DE_SYM                      "&DE Sym."
  IDS_DE_POS                      "D&E Po."
  IDS_A_MEMORY                    "&Pami"
  IDS_DRIVE_TYPE                  "&typu stacja dyskietek"
  IDS_40_TRACK_HANDLING           "40-ciekowy &obraz"
  IDS_SELECT_DRIVE_EXTEND_NEVER   "Nigdy nie rozszerzaj"
  IDS_SELECT_DRIVE_EXTEND_ASK     "Wczeniej zapytaj"
  IDS_SELECT_DRIVE_EXTEND_ACCESS  "Rozszerz, kiedy nastpi uycie"
  IDS_IDLE_METHOD                 "metada &bezczynnoci"
  IDS_SELECT_DRIVE_IDLE_TRAP_IDLE "Wykrywaj"
  IDS_SELECT_DRIVE_IDLE_SKIP_CYC  "Opuszczaj cykcle"
  IDS_TOGGLE_DRIVE_PARALLEL_CABLE "&kabel rwnolegy"
  IDS_DRIVE_EXPANSION             "&Rozszerzenie napdu"
  IDS_TOGGLE_DRIVE_EXPANSION_2000 "$2000-$3FFF &RAM"
  IDS_TOGGLE_DRIVE_EXPANSION_4000 "$&4000-$5FFF RAM"
  IDS_TOGGLE_DRIVE_EXPANSION_6000 "$&6000-$7FFF RAM"
  IDS_TOGGLE_DRIVE_EXPANSION_8000 "$8000-$9FFF RA&M"
  IDS_TOGGLE_DRIVE_EXPANSION_A000 "$&A000-$BFFF RAM"
  IDS_PLUS4_VIC20_MEMORY          "&Pami"
  IDS_SID_GENGROUP1               "SID Engine/Model"
  IDS_SID_FILTERS                 "SID filtry"
  IDS_MP_FILE                     "&Plik"
  IDS_MP_ATTACH_DISK_IMAGE        "W obraz &dyskietki"
  IDS_MP_DETACH_DISK_IMAGE        "Wyjmij obraz dyski&etki"
  IDS_MP_FLIP_LIST                "&Zmie list"
  IDS_MP_DATASETTE_CONTROL        "Zarzdzanie ma&gnetofonem"
  IDS_MP_ATTACH_CARTRIDGE_IMAGE   "W obraz &kartrida..."
  IDS_MP_EXPERT_CARTRIDGE         "Expert Cartridge"
  IDS_MP_RESET                    "&Reset"
  IDS_MP_DEBUG                    "&Debug"
#ifdef DEBUG
  IDS_MP_MODE                     "M&ode"
#endif
  IDS_MP_EDIT                     "Edit"
  IDS_MP_SNAPSHOT                 "z&rzutu"
  IDS_MP_RECORDING_START_MODE     "Rozpocznij tryb zapisu"
  IDS_MP_OPTIONS                  "&Opcje"
  IDS_MP_REFRESH_RATE             "Czstot&liwo odwieania"
  IDS_MP_MAXIMUM_SPEED            "&Maksymalna prdko"
  IDS_MP_VIDEO_STANDARD           "Standard vide&o"
  IDS_MP_DRIVE_SYNC_FACTOR        "Drive s&ync factor"
  IDS_MP_SETTINGS                 "Ustawi&enia"
  IDS_MP_CARTRIDGE_IO_SETTINGS    "Ustawienia kart&rida"
  IDS_MP_LANGUAGE                 "&Language"
  IDS_MP_HELP                     "&Pomoc"
  IDS_MP_VIEW                     "&View"
  IDS_MP_WINDOW                   "&Okna"
  IDS_MI_EXIT                     "W&yjd"
  IDS_MI_ABOUT                    "&O VICE..."
  IDS_MI_PAUSE                    "&Pauza"
  IDS_MI_EDIT_COPY                "&Copy"
  IDS_MI_EDIT_PASTE               "&Paste"
  IDS_MI_AUTOSTART                "&Autostart disk/tape image..."
  IDS_MI_RESET_HARD               "T&wardy"
  IDS_MI_RESET_SOFT               "&Mikki"
  IDS_MI_DRIVE8                   "Napdu &8"
  IDS_MI_DRIVE9                   "Napdu &9"
  IDS_MI_DRIVE10                  "Napdu 1&0"
  IDS_MI_DRIVE11                  "Napdu 1&1"
  IDS_MI_ATTACH_TAPE              "W &obraz kasety..."
  IDS_MI_DETACH_TAPE              "Wyjmij obraz &kasety"
  IDS_MI_DETACH_ALL               "&Wszystko"
  IDS_MI_TOGGLE_SOUND             "dwi&k"
  IDS_MI_TOGGLE_DOUBLESIZE        "Po&dwjny rozmiar"
  IDS_MI_TOGGLE_DOUBLESCAN        "Podwj&ne scanlines"
  IDS_MI_DRIVE_TRUE_EMULATION     "rzeczywist emulac&j napdu"
  IDS_MI_AUTOSTART_HANDLE_TDE     "Handle TDE for autostart"
  IDS_MI_TOGGLE_VIDEOCACHE        "&Cache video"
  IDS_MI_DRIVE_SETTINGS           "Ustawienia nap&du..."
  IDS_MI_CART_ATTACH_CRT          "Obrazu &kartrida..."
  IDS_MI_CART_ATTACH_8KB          "Standardowy obraz &8KB..."
  IDS_MI_CART_ATTACH_16KB         "Standardowy obraz &16KB..."
  IDS_MI_CART_ATTACH_AR           "Obraz &Action Replay..."
  IDS_MI_CART_ATTACH_AR3          "Obraz Action Replay III..."
  IDS_MI_CART_ATTACH_AR4          "Obraz Action Replay 4..."
  IDS_MI_CART_ATTACH_STARDOS      "Obraz StarDOS..."
  IDS_MI_CART_ATTACH_AT           "Obraz Atomic &Power..."
  IDS_MI_CART_ATTACH_EPYX         "Obraz &Epyx fastload..."
  IDS_MI_CART_ATTACH_IEEE488      "Obraz interfejsu &IEEE488..."
  IDS_MI_CART_ATTACH_RR           "Obraz &Retro Replay..."
  IDS_MI_CART_ATTACH_IDE64        "Obraz interfejsu IDE&64..."
  IDS_MI_CART_ATTACH_SS4          "Obraz Super Snapshot &4..."
  IDS_MI_CART_ATTACH_SS5          "Obraz Super Snapshot &5..."
  IDS_MI_CART_ATTACH_STB          "Obraz Structured &Basic..."
  IDS_MI_FLIP_ADD                 "Dodaj &aktualny obraz"
  IDS_MI_FLIP_REMOVE              "Usu aktualny ob&raz"
  IDS_MI_FLIP_NEXT                "W &nastpny obraz"
  IDS_MI_FLIP_PREVIOUS            "W &poprzedni obraz"
  IDS_MI_FLIP_LOAD                "Zaaduj plik &listy"
  IDS_MI_FLIP_SAVE                "Zapi&sz plik listy"
  IDS_MI_DATASETTE_STOP           "Za&trzymaj"
  IDS_MI_DATASETTE_START          "Odt&warzaj"
  IDS_MI_DATASETTE_FORWARD        "&Przewi do przodu"
  IDS_MI_DATASETTE_REWIND         "P&rzewi do tyu"
  IDS_MI_DATASETTE_RECORD         "Re&jestruj"
  IDS_MI_DATASETTE_RESET          "R&eset"
  IDS_MI_DATASETTE_RESET_COUNTER  "Reset C&ounter"
  IDS_MI_CART_ENABLE_EXPERT       "Wcz"
  IDS_MI_CART_MODE_OFF            "Wycz"
  IDS_MI_CART_MODE_ON             "Wcz"
  IDS_MI_CART_SET_DEFAULT         "Ustaw kartrid jako &domylny"
  IDS_MI_TOGGLE_CART_RESET        "Reset &on cart change"
  IDS_MI_CART_DETACH              "Wjm&ij obraz kartrida"
  IDS_MI_CART_FREEZE              "Cartridge free&ze"
  IDS_MI_MONITOR                  "&Monitor"
#ifdef DEBUG
  IDS_MI_DEBUG_MODE_NORMAL        "&Normal"
  IDS_MI_DEBUG_MODE_SMALL         "&Small"
  IDS_MI_DEBUG_MODE_HISTORY       "&History"
  IDS_MI_DEBUG_MODE_AUTOPLAY      "&History Autoplay"
  IDS_MI_TOGGLE_MAINCPU_TRACE     "&Main CPU Trace"
  IDS_MI_TOGGLE_DRIVE0CPU_TRACE   "Drive&0 CPU Trace"
  IDS_MI_TOGGLE_DRIVE1CPU_TRACE   "Drive&1 CPU Trace"
#endif
  IDS_MI_SNAPSHOT_LOAD            "Zaadu&j zrzut..."
  IDS_MI_SNAPSHOT_SAVE            "Zapisz z&rzut..."
  IDS_MI_LOADQUICK                "Szybkie &zaadowanie zrzutu"
  IDS_MI_SAVEQUICK                "&Szybki zapis zrzutu"
  IDS_MI_EVENT_TOGGLE_RECORD      "Rozpocznij/Zatrzymaj zapisywanie wyda&rzen"
  IDS_MI_EVENT_TOGGLE_PLAYBACK    "Rozpocznij/Zatrzymaj odtwarz&anie wydarzen"
  IDS_MI_EVENT_SETMILESTONE       "Zatrzymaj zapisywanie wydarzen"
  IDS_MI_EVENT_RESETMILESTONE     "Return to Milestone"
  IDS_MI_EVENT_START_MODE_SAVE    "Zapi&sz obraz"
  IDS_MI_EVENT_START_MODE_LOAD    "Zaaduj &zrzut"
  IDS_MI_EVENT_START_MODE_RESET   "Rozpocznij z &restartem"
  IDS_MI_EVENT_START_MODE_PLAYBCK "Overwrite &Playback"
  IDS_MI_EVENT_DIRECTORY          "Katalog systemu plikw"
  IDS_MI_MEDIAFILE                "Save/stop media file..."
  IDS_MI_SOUND_RECORD_START       "Record Sound..."
  IDS_MI_SOUND_RECORD_STOP        "Stop Sound Recording"
  IDS_MI_REFRESH_RATE_AUTO        "&Auto"
  IDS_MI_MAXIMUM_SPEED_NO_LIMIT   "Bez &limitu"
  IDS_MI_MAXIMUM_SPEED_CUSTOM     "&Wasne"
  IDS_MI_TOGGLE_WARP_MODE         "tr&yb przypieszony (Turbo)"
  IDS_MI_TOGGLE_ALWAYSONTOP       "Always on Top"
  IDS_MI_TOGGLE_FASTPAL           "Emulacj PAL"
  IDS_MI_TOGGLE_SCALE2X           "Skala:x2"
  IDS_MI_SWAP_JOYSTICK            "Zamie por&ty (1/2)"
  IDS_MI_SWAP_EXTRA_JOYSTICK      "Swap &Userport joysticks"
  IDS_MI_ALLOW_JOY_OPPOSITE       "Allow opposite joystick directions"
  IDS_MI_JOYKEYS_TOGGLE           "Enable Joy Keys"
  IDS_MI_TOGGLE_VIRTUAL_DEVICES   "&Virtual device traps"
  IDS_MI_TOGGLE_EMUID             "&Idyntifikacja emulatora"
  IDS_MI_MOUSE                    "&Grab mouse events"
  IDS_MI_AUTOSTART_SETTINGS       "&Autostart settings..."
  IDS_MI_VIDEO_SETTINGS           "Ustawienia &video..."
  IDS_MI_DEVICEMANAGER            "Ustawienia &zewntrzne..."
  IDS_MI_JOY_SETTINGS             "Ustawienia &joystcka..."
  IDS_MI_USERPORT_JOY_SETTINGS    "&Userport joystick settings..."
  IDS_MI_SIDCART_JOY_SETTINGS     "&Sidcart joystick settings..."
  IDS_MI_KEYBOARD_SETTINGS        "Ustawienia &klawiatury..."
  IDS_MI_SOUND_SETTINGS           "Usta&wienia dwiku..."
  IDS_MI_ROM_SETTINGS             "Ustawienia &ROM..."
  IDS_MI_RAM_SETTINGS             "Ustawienia RA&M..."
  IDS_MI_DATASETTE_SETTINGS       "Ustawienia d&atasette..."
  IDS_MI_VICII_SETTINGS           "Ustawienia VIC-II..."
  IDS_MI_MOUSE_SETTINGS           "Mo&use settings..."
  IDS_MI_SID_SETTINGS             "Ustawienia ukadu S&ID..."
  IDS_MI_RS232_SETTINGS           "Ustawienia RS&232..."
  IDS_MI_REU_SETTINGS             "Ustawienia &REU..."
  IDS_MI_GEORAM_SETTINGS          "Ustawienia &GEORAM..."
  IDS_MI_RAMCART_SETTINGS         "Ustawienia &RAMCART..."
  IDS_MI_DQBB_SETTINGS            "&Double Quick Brown Box settings..."
  IDS_MI_ISEPIC_SETTINGS          "I&sepic settings..."
  IDS_MI_MMC64_SETTINGS           "&MMC64 settings..."
  IDS_MI_MIDI_SETTINGS            "M&IDI settings..."
  IDS_MI_DIGIMAX_SETTINGS         "&DIGIMAX settings..."
  IDS_MI_LIGHTPEN_SETTINGS        "&Lightpen settings..."
  IDS_MI_IDE64_SETTINGS           "Ustawienia &IDE64..."
#ifdef HAVE_TFE
  IDS_MI_TFE_SETTINGS             "Ustawienia &Ethernet..."
#endif
  IDS_MI_ACIA_SETTINGS            "Ustawienia &ACIA..."
  IDS_MI_RS232USER_SETTINGS       "Ustawienia RS&232 userport..."
  IDS_MI_EASYFLASH_SETTINGS       "EasyFlash settings..."
  IDS_MI_SFX_SE_SETTINGS          "SFX Sound Expander settings..."
  IDS_MI_TOGGLE_SFX_SS            "Enable SFX Sound Sampler"
  IDS_MI_SETTINGS_SAVE_FILE       "Save current settings to specified file"
  IDS_MI_SETTINGS_LOAD_FILE       "Load settings from specified file"
  IDS_MI_SETTINGS_SAVE            "Zapi&sz ustawienia"
  IDS_MI_SETTINGS_LOAD            "Zaad&uj ustawienia"
  IDS_MI_SETTINGS_DEFAULT         "Przywr dom&ylne ustawienia"
  IDS_MI_SAVE_SETTINGS_ON_EXIT    "&Zapisz ustawienia przy wyjciu"
  IDS_MI_CONFIRM_ON_EXIT          "&Confirm on exit"
  IDS_MI_LANG_EN                  "&English"
  IDS_MI_LANG_DA                  "D&anish"
  IDS_MI_LANG_DE                  "&German"
  IDS_MI_LANG_FR                  "&French"
  IDS_MI_LANG_HU                  "&Hungarian"
  IDS_MI_LANG_IT                  "&Italian"
  IDS_MI_LANG_NL                  "&Dutch"
  IDS_MI_LANG_PL                  "&Polish"
  IDS_MI_LANG_SV                  "&Swedish"
  IDS_MI_LANG_TR                  "&Turkish"
  IDS_MI_CMDLINE                  "Command line &options"
  IDS_MI_CONTRIBUTORS             "&Wsppracownicy projektu VICE"
  IDS_MI_LICENSE                  "&Licencja"
  IDS_MI_WARRANTY                 "Bez g&warancji"
  IDS_MI_TOGGLE_FULLSCREEN        "Peny ekran"
  IDS_MI_SIDCART_SETTINGS         "&SID cart settings..."
  IDS_MI_MON_OPEN                 "&Open"
  IDS_MI_MON_SAVE                 "&Zapisz"
  IDS_MI_MON_PRINT                "&Print"
  IDS_MI_MON_EXIT                 "W&yjd z\tAlt+F4"
  IDS_MI_MON_STOP_DEBUG           "&Stop Debug"
  IDS_MI_MON_STOP_EXEC            "Stop E&xecution"
  IDS_MI_MON_STEP_INTO            "Step &into"
  IDS_MI_MON_STEP_OVER            "Step &over"
  IDS_MI_MON_SKIP_RETURN          "Step until &return"
  IDS_MI_MON_GOTO_CURSOR          "Go to &cursor"
  IDS_MI_MON_EVAL                 "&Evaluate"
  IDS_MI_MON_CURRENT              "&Current instruction"
  IDS_MI_MON_WND_EVAL             "Evaluation &window"
  IDS_MI_MON_WND_REG              "&Register window"
  IDS_MI_MON_WND_MEM              "&Memory window"
  IDS_MI_MON_WND_DIS              "&Disassembly window"
  IDS_MI_MON_WND_CONSOLE          "&Console window"
  IDS_MI_MON_COMPUTER             "&Znak"
  IDS_MI_MON_DRIVE8               "Edytor &8"
  IDS_MI_MON_DRIVE9               "Edytor &9"
  IDS_MI_MON_CASCADE              "&Cascade"
  IDS_MI_MON_TILE_VERT            "Tile &vertically"
  IDS_MI_MON_TILE_HORIZ           "Tile &horizontally"
  IDS_MI_MON_ARRANGE_ICONS        "&Arrange icons"
END
#pragma code_page(28591)



STRINGTABLE
LANGUAGE LANG_SWEDISH, SUBLANG_NEUTRAL
BEGIN
  IDS_VICE_ERROR                  "VICE-fel!"
  IDS_VICE_INFORMATION            "VICE-information"
  IDS_VICE_QUESTION               "VICE-frga"
  IDS_FFMPEG_DLL_MISMATCH         "Versionen p din ffmpeg-dll stmmer inte."
  IDS_DIRECTDRAW_ERROR            "DirectDraw-fel: Kod:%8x Fel:%s"
  IDS_CANNOT_SAVE_SETTINGS        "Kan inte spara instllningar."
  IDS_CANNOT_LOAD_SETTINGS        "Kan inte lsa instllningar."
  IDS_DEFAULT_SETTINGS_RESTORED   "Frvalda instllningar terstllda."
  IDS_CANNOT_ATTACH_FILE          "Kan inte ansluta filen"
  IDS_START_MONITOR               "%s\012\012Starta monitor? (Nej kommer att terstlla, avbryt fortstter)"
  IDS_VICE_CPU_JAM                "VICE CPU-blockering"
  IDS_EXTEND_TO_40_TRACKS         "Utka avbildning till 40-sprsformat?"
  IDS_DETACHED_DEVICE_S           "Kopplade frn enhet %s"
  IDS_ATTACHED_S_TO_DEVICE_S      "Anslt %s till enhet %s"
  IDS_DETACHED_TAPE               "Kopplade frn band"
  IDS_HISTORY_RECORDED_UNKNOWN    "Historik inspelad med oknd version"
  IDS_HISTORY_RECORDED_VICE_S     "Historik inspelad med VICE-%s"
  IDS_PAUSED                      "pausad"
  IDS_FRAME_NUMBER                "ram nr"
  IDS_RESUMED                     "terupptagen"
  IDS_REALLY_EXIT                 "Vill du verkligen avsluta?\012\012Alla data i emulerat RAM kommer frloras."
  IDS_CANNOT_AUTOSTART_FILE       "Kan inte autostarta angiven fil."
  IDS_ATTACHED_TAPE_S             "Anslt band %s"
  IDS_SETTINGS_SAVED_SUCCESS      "Instllningarna har sparats."
  IDS_SETTINGS_LOADED_SUCCESS     "Instllningarna har lsts in."
  IDS_ATTACH_DISK_IMAGE           "Anslut diskettavbildningsfil"
  IDS_ATTACH_TAPE_IMAGE           "Anslut bandavbildningsfil"
  IDS_AUTOSTART_IMAGE             "Autostarta disk-/bandavbildningsfil"
  IDS_INVALID_CARTRIDGE           "Ogiltig insticksmodul"
  IDS_BAD_CARTRIDGE_CONFIG        "Felaktiga insticksmodulsinstllningar i UI!"
  IDS_INVALID_CARTRIDGE_IMAGE     "Ogiltig insticksmodulfil"
  IDS_LOG_CONSOLE_OUTPUT_IMAGE    "Logga konsolutdataavbildning"
  IDS_LOG_FILES_TYPE              "VICE konsolloggfiler (*.dbg)"
  IDS_CANNOT_WRITE_LOGFILE_S      "Kan inte skriva loggfil '%s'."
  IDS_LOAD_FLIP_LIST_FILE         "Ls vallistefil"
  IDS_CANNOT_READ_FLIP_LIST       "Kunde inte lsa vallistefil"
  IDS_SAVE_FLIP_LIST_FILE         "Spara vallistefil"
  IDS_CANNOT_WRITE_FLIP_LIST      "Kan inte skriva vallistefil"
  IDS_SELECT_KEYMAP_FILE          "Vlj tangentbordsfil"
  IDS_SAVE_KEYMAP_FILE            "Spara tangentbordsfil"
  IDS_CANNOT_WRITE_KEYMAP_FILE    "Kan inte skriva tangentbordsfil"
  IDS_SAVE_CONFIG_FILE            "Save config file"
  IDS_LOAD_CONFIG_FILE            "Load config file"
  IDS_MAPPING                     "Koppling"
  IDS_KEYBOARD_SETTINGS           "Tangentbordsinstllningar"
  IDS_ATTACH                      "&Anslut"
  IDS_PLEASE_ENTER_A_FILENAME     "Ange filnamn."
  IDS_OVERWRITE_EXISTING_IMAGE    "Skriva ver existerande avbildning?"
  IDS_CANNOT_CREATE_IMAGE         "Kan inte skapa avbildningsfil"
  IDS_COMMAND_LINE_OPTIONS        "Kommandoradsflaggor"
  IDS_COMMAND_OPTIONS_AVAIL       "Vilka kommandoradsflaggor r tillgngliga?"
  IDS_NO_DRIVER_SELECT_SUPPORT    "Drivrutin har inte valts eller vald drivrutin stds inte"
  IDS_CANT_WRITE_SCREENSHOT_S     "Kan inte skriva skrmdumpsfil '%s'."
  IDS_AUTOSTART_DISK_IMAGE        "Autostarta diskettavbildning"
  IDS_SELECT_FS_DIRECTORY         "Ange filsystemskatalog"
  IDS_PRINTER_USERPORT            "Skrivare anvndarport"
  IDS_PRINTER_4                   "Skrivare 4"
  IDS_PRINTER_5                   "Skrivare 5"
  IDS_DRIVE_8                     "Enhet 8"
  IDS_DRIVE_9                     "Enhet 9"
  IDS_DRIVE_10                    "Enhet 10"
  IDS_DRIVE_11                    "Enhet 11"
  IDS_PERIPHERAL_SETTINGS         "Instllningar fr kringutrustning"
  IDS_CANT_WRITE_SNAPSHOT_FILE    "Kan inte skriva gonblicksbildfil."
  IDS_CANNOT_READ_SNAPSHOT_IMG    "Kan inte lsa in gonblicksbildfil"
  IDS_LOAD_S_ROM_IMAGE            "Ls %s-ROM-fil"
  IDS_SELECT_ROMSET_ARCHIVE       "Vlj ROM-uppsttningsarkiv"
  IDS_CANNOT_LOAD_ROMSET_ARCH     "Kunde inte lsa ROM-uppsttningsarkiv!"
  IDS_CANNOT_SAVE_ROMSET_ARCH     "Kan inte spara ROM-uppsttningsarkiv!"
  IDS_CANNOT_LOAD_ROMSET_FILE     "Kan inte lsa in ROM-uppsttningsfil!"
  IDS_CANNOT_SAVE_ROMSET_FILE     "Kunde inte spara ROM-uppsttningsfil!"
  IDS_SELECT_ROMSET_FILE          "Vlj ROM-uppsttningsfil"
  IDS_ROMSET                      "ROM-uppsttning"
  IDS_COMPUTER                    "Dator"
  IDS_DRIVE                       "Enhet"
  IDS_ROM_SETTINGS                "ROM-instllningar"
  IDS_SAVE_SNAPSHOT_IMAGE         "Spara gonblicksbildfil"
  IDS_CANNOT_WRITE_SNAPSHOT_S     "Kan inte skriva gonblicksbildfil '%s'."
  IDS_LOAD_SNAPSHOT_IMAGE         "Lser in gonblicksbild"
  IDS_COULD_NOT_LOAD_PALETTE      "Kunde inte lsa in palettfil."
  IDS_LOAD_VICE_PALETTE_FILE      "Ls in VICE-palettfil"
  IDS_FULLSCREEN                  "Fullskrm/DirectX"
  IDS_COLORS                      "Frger"
  IDS_NEW_PAL                     "Ny PAL-emulering"
  IDS_VIDEO_SETTINGS              "Grafikinstllningar"
  IDS_FILE_SYSTEM                 "Filsystem"
#ifdef HAVE_OPENCBM
  IDS_REAL_IEC_DEVICE             "kta IEC-enhet"
#endif
  IDS_RS232_DEVICE_I              "RS232-enhet %i"
  IDS_ATTACH_CRT_CART_IMAGE       "Anslut CRT-insticksmodulfil"
  IDS_ATTACH_RAW_8KB_CART_IMAGE   "Anslut r 8KB-insticksmodulavbilding"
  IDS_ATTACH_RAW_16KB_CART_IMG    "Anslut r 16KB-insticksmodulavbilding"
  IDS_ATTACH_AR_CART_IMAGE        "Anslut Action Replay-insticksmodulfil"
  IDS_ATTACH_AR3_CART_IMAGE       "Anslut Action Replay III-insticksmodulfil"
  IDS_ATTACH_AR4_CART_IMAGE       "Anslut Action Replay 4-insticksmodulfil"
  IDS_ATTACH_STARDOS_CART_IMAGE   "Anslut StarDOS-insticksmodulfil"
  IDS_ATTACH_ATOMIC_P_CART_IMG    "Anslut Atomic Power-avbildningsfil"
  IDS_ATTACH_EPYX_FL_CART_IMG     "Anslut Epyx fastload-avbildningsfil"
  IDS_ATTACH_IEEE488_CART_IMG     "Anslut IEE-grnssnittsavbildningsfil"
  IDS_ATTACH_RETRO_R_CART_IMG     "Anslut Retro Replay-avbildningsfil"
  IDS_ATTACH_IDE64_CART_IMAGE     "Anslut IDE64-grnssnittsavbildningsfil"
  IDS_ATTACH_SS4_CART_IMAGE       "Anslut Super Snapshot 4-avbildningsfil"
  IDS_ATTACH_SS5_CART_IMAGE       "Anslut Super Snapshot 5-avbildningsfil"
  IDS_ATTACH_STB_CART_IMAGE       "Anslut Structured Basic-avbildningsfil"
  IDS_MODEL                       "Modell"
  IDS_DRIVE_SETTINGS              "Diskettenhetsinstllningar"
  IDS_SELECT_START_SNAP_EVENT     "Vlj startgonblicksmodul fr hndelsehistorik"
  IDS_SELECT_END_SNAP_EVENT       "Vlj slutgonblicksmodul fr hndelsehistorik"
#ifdef UNSTABLE
  IDS_VERSION_S_UNSTABLE          "Version %s *INSTABIL* (%s)"
#else
  IDS_VERSION_S                   "Version %s (%s)"
#endif
  IDS_VICE_CONTRIBUTORS           "Bidragslmnare till VICE"
  IDS_WHO_MADE_WHAT               "Vem gjorde vad?"
  IDS_LICENSE                     "Licens"
  IDS_NO_WARRANTY                 "Ingen garanti!"
  IDS_VICE_WITHOUT_WARRANTY       "VICE distribueras UTAN NGON SOM HELST GARANTI!"
  IDS_PRESS_KEY_NORTHWEST         "Tryck tangent fr nordvst"
  IDS_PRESS_KEY_NORTH             "Tryck tangent fr nord"
  IDS_PRESS_KEY_NORTHEAST         "Tryck tangent fr nordst"
  IDS_PRESS_KEY_EAST              "Tryck tangent fr st"
  IDS_PRESS_KEY_SOUTHEAST         "Tryck tangent fr sydst"
  IDS_PRESS_KEY_SOUTH             "Tryck tangent fr syd"
  IDS_PRESS_KEY_SOUTHWEST         "Tryck tangent fr sydvst"
  IDS_PRESS_KEY_WEST              "Tryck tangent fr vst"
  IDS_PRESS_KEY_FIRE              "Tryck tangent fr avtryckare"
  IDS_NO_USERPORT_ADAPTER         "Ingen anvndarportsspakadapter"
  IDS_CGA_USERPORT_ADAPTER        "CGA-anvndarportsspakadapter"
  IDS_PET_USERPORT_ADAPTER        "PET-anv\xE4ndarportsspakadapter"
  IDS_HUMMER_USERPORT_ADAPTER     "HUMMER-anvndarportsspakadapter"
  IDS_OEM_USERPORT_ADAPTER        "OEM-anvndarportsspakadapter"
  IDS_HIT_USERPORT_ADAPTER        "HIT-anvndarportsspakadapter"
  IDS_NO_SIDCART_JOY              "Inaktivera SIDcart-spak"
  IDS_SIDCART_JOY                 "Aktivera SIDcart-spak"
  IDS_NUMPAD_AND_RCTRL            "Numerisk knappsats + hger Ctrl"
  IDS_KEYSET_A                    "Uppsttning A"
  IDS_KEYSET_B                    "Uppsttning B"
  IDS_ALL_BUTTONS_AS_FIRE         "Alla knappar anvnds som avtryckare"
  IDS_NUMERIC_SEE_ABOVE           "numerisk (se ovan)"
  IDS_NO_BUTTON_NO_AUTOFIRE       "Ingen knapp - Autofire inaktiverad"
  IDS_ALL_FILES_FILTER            "Alla filer (*.*)"
  IDS_PALETTE_FILES_FILTER        "VICE-palettfiler (*.vpl)"
  IDS_SNAPSHOT_FILES_FILTER       "VICE-gonblicksbildfiler (*.vsf)"
  IDS_CBM_IMAGE_FILES_FILTER      "CBM-filer (*.d64;*.d71;*.d80;*.d81;*.d82;*.g64;*.g41;*.x64;*.t64;*.tap;*.prg;*.p00)"
  IDS_DISK_IMAGE_FILES_FILTER     "Diskettavbildningar (*.d64;*.d71;*.d80;*.d81;*.d82;*.g64;*.g41;*.x64)"
  IDS_TAPE_IMAGE_FILES_FILTER     "Bandavbildningar (*.t64;*.tap)"
  IDS_ZIPPED_FILES_FILTER         "Zippade filer (*.zip;*.bz2;*.gz;*.d6z;*.d7z;*.d8z;*.g6z;*.g4z;*.x6z)"
  IDS_CRT_FILES_FILTER            "CRT-insticksmodulfiler (*.crt)"
  IDS_RAW_CART_FILES_FILTER       "Ra insticksmodulfiler (*.bin)"
  IDS_FLIP_LIST_FILES_FILTER      "VICE-vallistefiler (*.vfl)"
  IDS_ROMSET_FILES_FILTER         "VICE-ROM-uppsttningsfiler (*.vrs)"
  IDS_ROMSET_ARCHIVES_FILTER      "VICE-ROM-uppsttningsarkiv (*.vra)"
  IDS_KEYMAP_FILES_FILTER         "VICE-tangentbordsfiler (*.vkm)"
  IDS_PRGP00_FILES_FILTER         "Commodoreemulatorfiler (*.prg;*.p00)"
  IDS_FLEXIBLE                    "Flexibel"
  IDS_ADJUSTING                   "Anpassande"
  IDS_EXACT                       "Exakt"
  IDS_SOUND_DRIVER_DIRECTX        "Ljuddrivrutin: DirectX"
  IDS_SOUND_DRIVER_WMM            "Ljuddrivrutin: WMM"
  IDS_MEDIA_FILES_FILTER          "Mediafiler (*.bmp;*.gif;*.iff;*.jpg;*.pcx;*.png;*.ppm;*.wav;*.mp3;*.avi;*.mpg)"
  IDS_SPACE_KB                    " kB"
  IDS_CONFIGURE_KEYSET_A          "Konfigurera uppsttning A"
  IDS_CONFIGURE_KEYSET_B          "Konfigurera uppsttning B"
  IDS_SAVE_MEDIA_IMAGE            "Spara mediafil"
  IDS_S_AT_D_SPEED                "%s med %d%% hastighet, %d b/s%s"
  IDS_TAPE                        "Band:"
  IDS_JOYSTICK_C                  "Styrspak:"
  IDS_RECORDING                   "Spelar in\n%02d:%02d"
  IDS_PLAYBACK                    "Spelar upp\n%02d:%02d (%02d:%02d)"
  IDS_UNKNOWN                     "Oknd"
  IDS_P_NUMBER                    "<nummer>"
  IDS_SET_INPUT_JOYSTICK_1        "Vlj indataenhet fr spelport 1"
  IDS_SET_INPUT_JOYSTICK_2        "Vlj indataenhet fr spelport 2"
  IDS_SET_INPUT_EXTRA_JOYSTICK_1  "Vlj indataenhet fr extra spelport 1"
  IDS_SET_INPUT_EXTRA_JOYSTICK_2  "Vlj indataenhet fr extra spelport 2"
  IDS_SAVE_SETTINGS_ON_EXIT       "Spara instllningar (resurser) vid avslut"
  IDS_NO_SAVE_SETTINGS_ON_EXIT    "Spara aldrig instllningar (resurser) vid avslut"
  IDS_CONFIRM_QUIT_VICE           "Bekrfta fr att avsluta VICE"
  IDS_NO_CONFIRM_QUIT_VICE        "Bekrfta inte fr att avsluta VICE"
  IDS_USE_ALL_CPU_SMP             "Anvnd Alla CPU:er p SMP-system"
  IDS_USE_FIRST_CPU_SMP           "Anvnd bara frsta CPU:n p SMP-system"
  IDS_START_VICE_FULLSCREEN_MODE  "Starta VICE i fullskrmslge"
  IDS_DISABLE_DX9                 "Inaktivera DirectX9-grafikdrivrutin"
#ifdef SYS_SIGLIST_DECLARED
  IDS_RECEIVED_SIGNAL_D_S         "Ett oknt fel uppstod. Tog emot signal %d (%s)."
#else
  IDS_RECEIVED_SIGNAL_D           "Ett oknt fel uppstod. Tog emot signal %d."
#endif
#ifdef HAVE_NETWORK
  IDS_IDLE                        "Vntar"
  IDS_SERVER_LISTENING            "Servern lyssnar"
  IDS_CONNECTED_SERVER            "Ansluten server"
  IDS_CONNECTED_CLIENT            "Ansluten klient"
  IDS_INVALID_PORT_NUMBER         "Ogiltigt portnummer"
  IDS_ERROR_STARTING_SERVER       "Fel vid anslutning till server."
  IDS_ERROR_CONNECTING_CLIENT     "Fel vid anslutning till klient."
#endif
  IDS_SOUND_RECORDING_STARTED     "Ljudinspelning startad..."
  IDS_SOUND_RECORDING_STOPPED     "Ljudinspelning stoppad..."
  IDS_OK                          "OK"
  IDS_CANCEL                      "Avbryt"
  IDS_NONE                        "Ingen"
  IDS_BROWSE                      "&Blddra..."
  IDS_SPECIFY_MIDI_IN             "Ange enhet fr MIDI-in"
  IDS_SPECIFY_MIDI_OUT            "Ange enhet fr MIDI-ut"
  IDS_ERROR_SAVING_EASYFLASH_CRT  "Fel vid skrivning av EasyFlash-crt-fil."
  IDS_DATASETTE_CAPTION           "Datasetteinstllningar"
  IDS_DATASETTE_RESET_WITH_CPU    "&Nollstll Datasette med CPU"
  IDS_DATASETTE_MOTOR_GROUP       "Motorhastighet vid lsning"
  IDS_DATASETTE_DELAY_TRIGGER     "cykler ytterligare &frdrjning per puls"
  IDS_DATASETTE_DELAY_AT_ZERO     "cykler frdrjning vid &nollvrden"
  IDS_TOGGLE_USEIECDEVICE         "&Anvnd IEC-enhet"
  IDS_SELECTDISK                  "Disk&avbildning"
  IDS_SELECTDIR                   "&Katalog"
#ifdef HAVE_OPENCBM
  IDS_SELECTREAL                  "&kta IEC-enhet"
#endif
  IDS_SELECTNONE                  "&Ingen"
  IDS_AUTOSTART                   "Starta &automatiskt"
  IDS_BROWSEDIR                   "&Blddra..."
  IDS_TOGGLE_ATTACH_READONLY      "Anslut skrivskyddat"
  IDS_TOGGLE_READP00              "&Ls P00-filer"
  IDS_TOGGLE_WRITEP00             "&Skriv P00-filer"
  IDS_TOGGLE_HIDENONP00           "&Gm icke-P00-filer"
  IDS_JOYSTICK_CAPTION            "Instllningar fr styrspak"
  IDS_JOYSTICK_IN_PORT_1          "Styrspak i spelport &1"
  IDS_SELECT_FIRE_BUTTON          "Vlj avtryckarknapp"
  IDS_AUTO_FIRE_BUTTON_SETTINGS   "Instllningar fr autofire"
  IDS_AUTOFIRE_SPEED              "&Hastighet fr autofire (1..32)"
  IDS_JOYSTICK_IN_PORT_2          "Styrspak i spelport &2"
  IDS_JOY_CONFIG_A                "Tangentuppsttning &A"
  IDS_JOY_CONFIG_B                "Tangentuppsttning &B"
  IDS_JOY_CALIBRATE               "&Kalibrera styrspak(ar)"
  IDS_EXTRA_JOYSTICK_CAPTION      "Instllningar fr extra styrspak"
  IDS_JOYSTICK_IN_EXTRA_PORT_1    "Styrspak i extraport &1"
  IDS_JOYSTICK_IN_EXTRA_PORT_2    "Styrspak i extraport &2"
  IDS_KEYSET_SW                   "S&ydvst"
  IDS_KEYSET_S                    "&Syd"
  IDS_KEYSET_SE                   "Sy&dst"
  IDS_KEYSET_W                    "&Vst"
  IDS_KEYSET_E                    "&st"
  IDS_KEYSET_NW                   "No&rdvst"
  IDS_KEYSET_N                    "&Nord"
  IDS_KEYSET_NE                   "N&ordst"
  IDS_KEYSET_FIRE                 "&Avtryckarknapp"
  IDS_SOUND_CAPTION               "Instllningar fr ljudenheter"
  IDS_SOUND_DIRECTX               "DirectX-drivrutiner"
  IDS_SOUND_WMM                   "WMM-drivrutiner"
  IDS_SOUND_SAMPLE_FREQUENCY      "Samplings&frekvens:"
  IDS_SOUND_BUFFER_SIZE           "Ljudbuffert&storlek:"
  IDS_SOUND_FRAGMENT_SIZE_LABEL   "Storlek p ljudfragment:"
  IDS_SOUND_FRAGMENT_SIZE_SMALL   "Liten"
  IDS_SOUND_FRAGMENT_SIZE_MEDIUM  "Medium"
  IDS_SOUND_FRAGMENT_SIZE_LARGE   "Stor"
  IDS_SOUND_SYNCH_METHOD          "Synkroniserings&metod:"
  IDS_TOGGLE_SNAPSHOT_SAVE_DISKS  "Spara anslutna disketter &diskettavbildningar"
  IDS_TOGGLE_SNAPSHOT_SAVE_ROMS   "Spara lsta &ROM-avbildningar"
  IDS_FULLSCREEN_DRIVER           "Drivrutin:"
  IDS_FULLSCREEN_DRVR_BITDEPTH    "Bitdjup:"
  IDS_FULLSCREEN_DRVR_RESOLUTION  "Upplsning:"
  IDS_FULLSCREEN_DRVR_REFRESHRATE "Uppdateringshastighet:"
  IDS_TOGGLE_VIDEO_VBLANK_SYNC    "VBLANK-synkronisering"
  IDS_TOGGLE_VIDEO_DX_PRIMARY     "Rendrera till DXs primra yta"
  IDS_TOGGLE_KEEP_ASPECT_RATIO    "Behll bredd-/hjdfrhllande (0,5..2)"
  IDS_COLORS_SATURATION           "Mttnad (0..2)"
  IDS_COLORS_CONTRAST             "Kontrast (0..2)"
  IDS_COLORS_BRIGHTNESS           "Ljusstyrka (0..2)"
  IDS_NEW_PAL_TINT                "Frgton (0..2)"
  IDS_NEW_PAL_ODD_LINES_PHASE     "Fas fr udda linjer (0..2)"
  IDS_NEW_PAL_ODD_LINES_OFFSET    "Utjmning fr udda linjer (0..2)"
  IDS_VIDEO_GAMMA                 "Gamma (0..2)"
  IDS_VIDEO_PHASE                 "Fas (0..2)"
  IDS_VIDEO_PAL_SHADE             "PAL-skuggning (0..1)"
  IDS_VIDEO_PAL_BLUR              "PAL-suddighet (0..1)"
  IDS_TOGGLE_VIDEO_EXTPALETTE     "Extern palett:"
  IDS_RAM_CAPTION                 "RAM-instllningar"
  IDS_RAM_INIT_AT_POWERUP         "Initiering vid strmpslag"
  IDS_RAM_VALUE_FIRST_BYTE        "Vrde p frsta byte"
  IDS_RAM_LENGTH_CONSTANT_VALUES  "Lngd p konstanta vrden"
  IDS_RAM_LENGTH_CONSTANT_PATTERN "Lngd p konstant mnster"
  IDS_PRINTER_EMULATION           "Skrivaremulering"
  IDS_PRINTER_FORMFEED            "Snd sidmatning"
  IDS_FILESYSTEM_PRINTER          "Filsystemsskrivare"
  IDS_PRINTER_DRVR                "Skrivardrivrutin"
  IDS_OUTPUT                      "Utdata"
  IDS_OUTPUT_TO_FILE              "Utdata till fil"
  IDS_OUTPUT_FILE1_NAME           "Namn p utdatafil 1"
  IDS_OUTPUT_FILE2_NAME           "Namn p utdatafil 2"
  IDS_OUTPUT_FILE3_NAME           "Namn p utdatafil 3"
  IDS_ROMSET_SELECT_ARCHIVE       "ROM-uppsttningsarkiv"
  IDS_ROMSET_ARCHIVE_LOAD         "Ls in arkiv"
  IDS_ROMSET_ARCHIVE_SAVE         "Spara arkiv"
  IDS_ROMSET_CONFIGURATION        "&instllningar"
  IDS_ROMSET_ARCHIVE_APPLY        "Verkstll"
  IDS_ROMSET_ARCHIVE_NEW          "Skapa"
  IDS_ROMSET_ARCHIVE_DELETE       "Ta bort"
  IDS_ROMSET_SELECT_FILE          "ROM-uppsttningsfil"
  IDS_ROMSET_FILE_LOAD            "Ls ROM-uppsttning"
  IDS_ROMSET_FILE_SAVE            "Spara ROM-uppsttning"
  IDS_CUSTOM_SPEED_CAPTION        "Egen hastighet"
  IDS_ENTER_CUSTOM_SPEED          "Ange egen hastighet [%]"
  IDS_NEW_CONFIGURATION           "Nya instllningar"
  IDS_ENTER_CONFIGURATION_NAME    "Ange namn p instllningar"
  IDS_RS232_CAPTION               "RS232-instllningar"
  IDS_RS232_DEV_1                 "RS232-enhet 1"
  IDS_RS232_DEV_2                 "RS232-enhet 2"
  IDS_RS232_DEV_3                 "RS232-enhet 3"
  IDS_RS232_DEV_4                 "RS232-enhet 4"
  IDS_NETWORK_CAPTION             "Instllningar fr ntverksspel"
  IDS_CURRENT_MODE                "Nuvarande lge"
  IDS_SERVER_BIND                 "Serverbindning"
  IDS_TCP_PORT                    "TCP-Port"
  IDS_NETWORK_SERVER              "Starta server"
  IDS_NETWORK_CLIENT              "Anslut till"
  IDS_NETWORK_DISCONNECT          "Koppla frn"
  IDS_CONTROL                     "Styrning"
  IDS_SERVER                      "Server"
  IDS_CLIENT                      "Klient"
  IDS_KEYBOARD                    "Tangentbord"
  IDS_JOYSTICK_1                  "Styrspak 1"
  IDS_JOYSTICK_2                  "Styrspak 2"
  IDS_DEVICES                     "Enheter"
  IDS_SETTINGS                    "Instllningar"
  IDS_TOGGLE_CONSOLE_APPEND       "&Lgg till log i existerande fil"
  IDS_IMAGE_CONTENTS              "Innehll i avbildning"
  IDS_NEW_IMAGE                   "Ny avbildning"
  IDS_NAME                        "Namn"
  IDS_ID                          "ID"
  IDS_TYPE                        "Typ"
  IDS_BLANK_IMAGE                 "Skapa avbildning"
  IDS_NEW_TAP_IMAGE               "Ny TAP-avbildning"
  IDS_SAVE                        "Spara"
  IDS_SELECT_DRIVER               "Vlj drivrutin"
  IDS_FFMPEG_SETTINGS             "FFMPEG-instllningar"
  IDS_FORMAT                      "Format"
  IDS_AUDIO_CODEC                 "Ljudomkodare"
  IDS_BITRATE                     "bithastighet"
  IDS_VIDEO_CODEC                 "Videoomkodare"
  IDS_SOUND_RECORD_CAPTION        "Instllningar fr ljudinspelning"
  IDS_SOUND_RECORD_FORMAT_LABEL   "Format fr ljudinspelning"
  IDS_SOUND_RECORD_FILE_LABEL     "Fil fr ljudinspelning"
  IDS_KERNAL                      "Kernal"
  IDS_BASIC                       "Basic"
  IDS_CHARACTER                   "Teckengenerator"
  IDS_COMPUTER_RESOURCES_CAPTION  "Datorresurser"
  IDS_COMPUTER_RESOURCES          "Datorresurser lagrade i ROM-uppsttning"
  IDS_DRIVE_RESOURCES_CAPTION     "Enhetsresurser"
  IDS_DRIVE_RESOURCES             "Enhetsresurser lagrade i ROM-uppsttning"
  IDS_SYMBOLIC                    "&Symbolisk"
  IDS_POSITIONAL                  "&Positionsriktig"
  IDS_DUMP_KEYSET                 "Spara tangentbord"
  IDS_DUMP_SHORTCUTS              "Spara genvgar"
  IDS_SYMBOLIC_US                 "&Symbolisk US"
  IDS_SYMBOLIC_DE                 "&Symbolisk DE"
  IDS_GR_SYM                      "&Gr Sym."
  IDS_GR_POS                      "G&r Pos."
  IDS_UK_SYM                      "&UK Sym."
  IDS_UK_POS                      "U&K Pos."
  IDS_DE_SYM                      "&DE Sym."
  IDS_DE_POS                      "D&E Pos."
  IDS_A_MEMORY                    "&Minne"
  IDS_DRIVE_TYPE                  "&Enhetstyp"
  IDS_40_TRACK_HANDLING           "Hantering av 40 &spr"
  IDS_SELECT_DRIVE_EXTEND_NEVER   "Utka aldrig"
  IDS_SELECT_DRIVE_EXTEND_ASK     "Frga vid utkning"
  IDS_SELECT_DRIVE_EXTEND_ACCESS  "Utka vid tkomst"
  IDS_IDLE_METHOD                 "Pa&usmetod"
  IDS_SELECT_DRIVE_IDLE_TRAP_IDLE "Fnga inaktiva"
  IDS_SELECT_DRIVE_IDLE_SKIP_CYC  "Hoppa cykler"
  IDS_TOGGLE_DRIVE_PARALLEL_CABLE "&Parallellkabel"
  IDS_DRIVE_EXPANSION             "Enhets&utkning"
  IDS_TOGGLE_DRIVE_EXPANSION_2000 "$2000-$3FFF &RAM"
  IDS_TOGGLE_DRIVE_EXPANSION_4000 "$&4000-$5FFF RAM"
  IDS_TOGGLE_DRIVE_EXPANSION_6000 "$&6000-$7FFF RAM"
  IDS_TOGGLE_DRIVE_EXPANSION_8000 "$8000-$9FFF RA&M"
  IDS_TOGGLE_DRIVE_EXPANSION_A000 "$&A000-$BFFF RAM"
  IDS_PLUS4_VIC20_MEMORY          "&Minne"
  IDS_SID_GENGROUP1               "SID-motor/-modell"
  IDS_SID_FILTERS                 "SID-filter"
  IDS_MP_FILE                     "&Arkiv"
  IDS_MP_ATTACH_DISK_IMAGE        "Anslut &diskettavbildningsfil"
  IDS_MP_DETACH_DISK_IMAGE        "Koppla &frn diskettavbildningsfil"
  IDS_MP_FLIP_LIST                "&Vallista"
  IDS_MP_DATASETTE_CONTROL        "Datasette&styrning"
  IDS_MP_ATTACH_CARTRIDGE_IMAGE   "Anslut &insticksmodulavbild..."
  IDS_MP_EXPERT_CARTRIDGE         "Expert Cartridge"
  IDS_MP_RESET                    "&Nollstll"
  IDS_MP_DEBUG                    "&Felsk"
#ifdef DEBUG
  IDS_MP_MODE                     "&Lge"
#endif
  IDS_MP_EDIT                     "&Redigera"
  IDS_MP_SNAPSHOT                 "&gonblicksbild"
  IDS_MP_RECORDING_START_MODE     "Spelar in startlge"
  IDS_MP_OPTIONS                  "&Alternativ"
  IDS_MP_REFRESH_RATE             "&Uppdateringshastighet"
  IDS_MP_MAXIMUM_SPEED            "&Maximal hastighet"
  IDS_MP_VIDEO_STANDARD           "&TV-standard"
  IDS_MP_DRIVE_SYNC_FACTOR        "S&ynkfaktor fr diskettstation"
  IDS_MP_SETTINGS                 "&Instllningar"
  IDS_MP_CARTRIDGE_IO_SETTINGS    "&Modul/IO-instllningar"
  IDS_MP_LANGUAGE                 "&Sprk"
  IDS_MP_HELP                     "&Hjlp"
  IDS_MP_VIEW                     "&Visa"
  IDS_MP_WINDOW                   "&Fnster"
  IDS_MI_EXIT                     "&Avsluta"
  IDS_MI_ABOUT                    "&Om VICE..."
  IDS_MI_PAUSE                    "&Paus"
  IDS_MI_EDIT_COPY                "&Kopiera"
  IDS_MI_EDIT_PASTE               "K&listra in"
  IDS_MI_AUTOSTART                "&Autostarta disk-/bandavbildningsfil..."
  IDS_MI_RESET_HARD               "&Hrd"
  IDS_MI_RESET_SOFT               "&Mjuk"
  IDS_MI_DRIVE8                   "Enhet &8"
  IDS_MI_DRIVE9                   "Enhet &9"
  IDS_MI_DRIVE10                  "Enhet 1&0"
  IDS_MI_DRIVE11                  "Enhet 1&1"
  IDS_MI_ATTACH_TAPE              "Anslut en &bandavbildningsfil..."
  IDS_MI_DETACH_TAPE              "Koppla f&rn bandavbildningsfil"
  IDS_MI_DETACH_ALL               "&Alla"
  IDS_MI_TOGGLE_SOUND             "Aktivera &ljudtergivning"
  IDS_MI_TOGGLE_DOUBLESIZE        "&Dubbel storlek"
  IDS_MI_TOGGLE_DOUBLESCAN        "Du&bbelskanning"
  IDS_MI_DRIVE_TRUE_EMULATION     "&kta diskettenhetsemulering"
  IDS_MI_AUTOSTART_HANDLE_TDE     "Ha&ntera DE fr autostart"
  IDS_MI_TOGGLE_VIDEOCACHE        "Grafik&cache"
  IDS_MI_DRIVE_SETTINGS           "&Diskettenhetsinstllningar..."
  IDS_MI_CART_ATTACH_CRT          "&CRT-fil..."
  IDS_MI_CART_ATTACH_8KB          "Vanlig &8KB-fil..."
  IDS_MI_CART_ATTACH_16KB         "Vanlig &16KB-fil..."
  IDS_MI_CART_ATTACH_AR           "&Action Replay-fil..."
  IDS_MI_CART_ATTACH_AR3          "&Action Replay 3-fil..."
  IDS_MI_CART_ATTACH_AR4          "&Action Replay 4-fil..."
  IDS_MI_CART_ATTACH_STARDOS      "&StarDOS-fil..."
  IDS_MI_CART_ATTACH_AT           "Atomic &Power-fil..."
  IDS_MI_CART_ATTACH_EPYX         "&Epyx fastload-fil..."
  IDS_MI_CART_ATTACH_IEEE488      "&IEEE488-grnssnittsfil..."
  IDS_MI_CART_ATTACH_RR           "&Retro Replay-fil..."
  IDS_MI_CART_ATTACH_IDE64        "IDE&64-grnssnittsfil..."
  IDS_MI_CART_ATTACH_SS4          "Super Snapshot &4-fil..."
  IDS_MI_CART_ATTACH_SS5          "Super Snapshot &5-fil..."
  IDS_MI_CART_ATTACH_STB          "Anslut &Basicavbildning..."
  IDS_MI_FLIP_ADD                 "&Lgg till aktuell avbildning"
  IDS_MI_FLIP_REMOVE              "&Ta bort aktuell avbildning"
  IDS_MI_FLIP_NEXT                "Anslut &nsta avbildning"
  IDS_MI_FLIP_PREVIOUS            "Anslut &fregende avbildning"
  IDS_MI_FLIP_LOAD                "&Ls in vallistefil"
  IDS_MI_FLIP_SAVE                "&Spara vallistefil"
  IDS_MI_DATASETTE_STOP           "S&toppa"
  IDS_MI_DATASETTE_START          "&Starta"
  IDS_MI_DATASETTE_FORWARD        "Spola &framt"
  IDS_MI_DATASETTE_REWIND         "Spola &bakt"
  IDS_MI_DATASETTE_RECORD         "Spela &in"
  IDS_MI_DATASETTE_RESET          "&Nollstll"
  IDS_MI_DATASETTE_RESET_COUNTER  "Nollstll r&knare"
  IDS_MI_CART_ENABLE_EXPERT       "Aktivera"
  IDS_MI_CART_MODE_OFF            "Av"
  IDS_MI_CART_MODE_ON             "P"
  IDS_MI_CART_SET_DEFAULT         "Vlj insticksmodul som &frval"
  IDS_MI_TOGGLE_CART_RESET        "Nollstll &vid modulbyte"
  IDS_MI_CART_DETACH              "Koppla &frn insticksmodulfil"
  IDS_MI_CART_FREEZE              "Insticksmodulens &frysfunktion"
  IDS_MI_MONITOR                  "&Monitor"
#ifdef DEBUG
  IDS_MI_DEBUG_MODE_NORMAL        "&Normal"
  IDS_MI_DEBUG_MODE_SMALL         "&Liten"
  IDS_MI_DEBUG_MODE_HISTORY       "&Historik"
  IDS_MI_DEBUG_MODE_AUTOPLAY      "&Spela upp historik automatiskt"
  IDS_MI_TOGGLE_MAINCPU_TRACE     "Spra &huvud-CPU"
  IDS_MI_TOGGLE_DRIVE0CPU_TRACE   "Spra CPU fr enhet &0"
  IDS_MI_TOGGLE_DRIVE1CPU_TRACE   "Spra CPU fr enhet &1"
#endif
  IDS_MI_SNAPSHOT_LOAD            "&Ls in gonblicksbild..."
  IDS_MI_SNAPSHOT_SAVE            "Spara &gonblicksbildfil..."
  IDS_MI_LOADQUICK                "Ls in &snabbgonblicksbild"
  IDS_MI_SAVEQUICK                "Spara sna&bbgonblicksbildfil"
  IDS_MI_EVENT_TOGGLE_RECORD      "Brja/sluta spela in &hndelser"
  IDS_MI_EVENT_TOGGLE_PLAYBACK    "Brja/sluta spela &upp hndelser"
  IDS_MI_EVENT_SETMILESTONE       "Ange inspelningsbokmrke"
  IDS_MI_EVENT_RESETMILESTONE     "terg till bokmrke"
  IDS_MI_EVENT_START_MODE_SAVE    "&Spara ny gonblicksbild"
  IDS_MI_EVENT_START_MODE_LOAD    "&Ls in existerande gonblicksbild"
  IDS_MI_EVENT_START_MODE_RESET   "Starta med &nollstllning"
  IDS_MI_EVENT_START_MODE_PLAYBCK "Skriv &ver aktiv uppspelning"
  IDS_MI_EVENT_DIRECTORY          "Vlj historikfiler/-katalog"
  IDS_MI_MEDIAFILE                "Starta/stoppa mediafil..."
  IDS_MI_SOUND_RECORD_START       "Spela in ljud..."
  IDS_MI_SOUND_RECORD_STOP        "Stoppa ljudinspelning"
  IDS_MI_REFRESH_RATE_AUTO        "&Auto"
  IDS_MI_MAXIMUM_SPEED_NO_LIMIT   "Ingen &grns"
  IDS_MI_MAXIMUM_SPEED_CUSTOM     "&Egen"
  IDS_MI_TOGGLE_WARP_MODE         "&Warplge"
  IDS_MI_TOGGLE_ALWAYSONTOP       "Alltid verst"
  IDS_MI_TOGGLE_FASTPAL           "PAL-emulering"
  IDS_MI_TOGGLE_SCALE2X           "Scale2x"
  IDS_MI_ALLOW_JOY_OPPOSITE       "Tillt motsatta riktningar p styrspak"
  IDS_MI_JOYKEYS_TOGGLE           "Aktivera styrspak via tangenter"
  IDS_MI_SWAP_JOYSTICK            "Vxla &spelportarna"
  IDS_MI_SWAP_EXTRA_JOYSTICK      "Vxla &anvndarportstyrspakar"
  IDS_MI_TOGGLE_VIRTUAL_DEVICES   "&Virtuella enhetstrap:ar"
  IDS_MI_TOGGLE_EMUID             "Emulator&identifiering"
  IDS_MI_MOUSE                    "&Fnga mushndelser"
  IDS_MI_AUTOSTART_SETTINGS       "&Autostartinstllningar..."
  IDS_MI_VIDEO_SETTINGS           "&Grafikinstllningar..."
  IDS_MI_DEVICEMANAGER            "Instllningar fr &kringutrustning..."
  IDS_MI_JOY_SETTINGS             "Instllningar fr &styrspak..."
  IDS_MI_USERPORT_JOY_SETTINGS    "Instllningar fr &anvndarportsstyrspak..."
  IDS_MI_SIDCART_JOY_SETTINGS     "Instllningar fr &Sidcart-styrspak..."
  IDS_MI_KEYBOARD_SETTINGS        "&Tangentbordsinstllningar..."
  IDS_MI_SOUND_SETTINGS           "L&judinstllningar..."
  IDS_MI_ROM_SETTINGS             "&ROM-instllningar..."
  IDS_MI_RAM_SETTINGS             "RA&M-instllningar..."
  IDS_MI_DATASETTE_SETTINGS       "D&atasetteinstllningar..."
  IDS_MI_VICII_SETTINGS           "VIC-II-instllningar..."
  IDS_MI_MOUSE_SETTINGS           "M&usinstllningar..."
  IDS_MI_SID_SETTINGS             "S&ID-instllningar..."
  IDS_MI_RS232_SETTINGS           "RS&232-instllningar..."
  IDS_MI_REU_SETTINGS             "&REU-instllningar..."
  IDS_MI_GEORAM_SETTINGS          "&GEORAM-instllningar..."
  IDS_MI_RAMCART_SETTINGS         "&RAMCART-instllningar..."
  IDS_MI_DQBB_SETTINGS            "Instllningar fr &dubbel Quick Brown Box..."
  IDS_MI_ISEPIC_SETTINGS          "I&sepic-instllningar..."
  IDS_MI_MMC64_SETTINGS           "&MMC64-instllningar..."
  IDS_MI_MIDI_SETTINGS            "M&IDI-instllningar..."
  IDS_MI_DIGIMAX_SETTINGS         "&DIGIMAX-instllningar..."
  IDS_MI_LIGHTPEN_SETTINGS        "Instllningar fr &ljuspenna..."
  IDS_MI_IDE64_SETTINGS           "&IDE64-instllningar..."
#ifdef HAVE_TFE
  IDS_MI_TFE_SETTINGS             "&Ethernetinstllningar..."
#endif
  IDS_MI_ACIA_SETTINGS            "&ACIA-instllningar..."
  IDS_MI_RS232USER_SETTINGS       "RS&232-anvndarportinstllningar..."
  IDS_MI_EASYFLASH_SETTINGS       "EasyFlash settings..."
  IDS_MI_SFX_SE_SETTINGS          "Instllningar fr SFX Sound Expander..."
  IDS_MI_TOGGLE_SFX_SS            "Aktivera SFX Sound Sampler"
  IDS_MI_SETTINGS_SAVE_FILE       "Spara nuvarande instllningar till den angivna filen"
  IDS_MI_SETTINGS_LOAD_FILE       "Ls instllningar frn den angivna filen"
  IDS_MI_SETTINGS_SAVE            "&Spara nuvarande instllningar"
  IDS_MI_SETTINGS_LOAD            "&Ls sparade instllningar"
  IDS_MI_SETTINGS_DEFAULT         "&terstll frvalda instllningar"
  IDS_MI_SAVE_SETTINGS_ON_EXIT    "Spara instllningar vid &avslut"
  IDS_MI_CONFIRM_ON_EXIT          "&Bekrfta avslutning"
  IDS_MI_LANG_EN                  "&Engelska"
  IDS_MI_LANG_DA                  "D&anska"
  IDS_MI_LANG_DE                  "&Tyska"
  IDS_MI_LANG_FR                  "&Franska"
  IDS_MI_LANG_HU                  "&Ungerska"
  IDS_MI_LANG_IT                  "&Italienska"
  IDS_MI_LANG_NL                  "&Nederlndska"
  IDS_MI_LANG_PL                  "&Polska"
  IDS_MI_LANG_SV                  "&Svenska"
  IDS_MI_LANG_TR                  "&Turkiska"
  IDS_MI_CMDLINE                  "Kommandorads&flaggor"
  IDS_MI_CONTRIBUTORS             "&Bidragslmnare"
  IDS_MI_LICENSE                  "&Licens"
  IDS_MI_WARRANTY                 "Ingen &garanti"
  IDS_MI_TOGGLE_FULLSCREEN        "Fullskrm"
  IDS_MI_SIDCART_SETTINGS         "&SID-insticksmodulinstllningar..."
  IDS_MI_MON_OPEN                 "&ppna"
  IDS_MI_MON_SAVE                 "&Spara"
  IDS_MI_MON_PRINT                "Skriv &ut"
  IDS_MI_MON_EXIT                 "&Avsluta\tAlt+F4"
  IDS_MI_MON_STOP_DEBUG           "&Avsluta felskning"
  IDS_MI_MON_STOP_EXEC            "Avsluta E&xekvering"
  IDS_MI_MON_STEP_INTO            "Stega &in"
  IDS_MI_MON_STEP_OVER            "Stega &ver"
  IDS_MI_MON_SKIP_RETURN          "Stega till &retur"
  IDS_MI_MON_GOTO_CURSOR          "G till &markr"
  IDS_MI_MON_EVAL                 "&Utvrdera"
  IDS_MI_MON_CURRENT              "&Aktuell instruktion"
  IDS_MI_MON_WND_EVAL             "Utvrderings&fnster"
  IDS_MI_MON_WND_REG              "&Registerfnster"
  IDS_MI_MON_WND_MEM              "&Minnesfnster"
  IDS_MI_MON_WND_DIS              "&Disassembleringsfnster"
  IDS_MI_MON_WND_CONSOLE          "&Konsolfnster"
  IDS_MI_MON_COMPUTER             "&Dator"
  IDS_MI_MON_DRIVE8               "Enhet &8"
  IDS_MI_MON_DRIVE9               "Enhet &9"
  IDS_MI_MON_CASCADE              "&verlappande"
  IDS_MI_MON_TILE_VERT            "&Sida vid sida"
  IDS_MI_MON_TILE_HORIZ           "&ver och under"
  IDS_MI_MON_ARRANGE_ICONS        "&Arrangera ikoner"
END



#pragma code_page(28599)
STRINGTABLE
LANGUAGE LANG_TURKISH, SUBLANG_NEUTRAL
BEGIN
  IDS_VICE_ERROR                  "VICE Hatas!"
  IDS_VICE_INFORMATION            "VICE Bilgisi"
  IDS_VICE_QUESTION               "VICE sorusu"
  IDS_FFMPEG_DLL_MISMATCH         "ffmpeg dll versiyonunuz uyumlu deil."
  IDS_DIRECTDRAW_ERROR            "DirectDraw hatas: Kod:%8x Hata:%s"
  IDS_CANNOT_SAVE_SETTINGS        "Ayarlar kaydedilemedi."
  IDS_CANNOT_LOAD_SETTINGS        "Ayarlar yklenemedi."
  IDS_DEFAULT_SETTINGS_RESTORED   "Varsaylan ayarlara geri dnld."
  IDS_CANNOT_ATTACH_FILE          "Belirtilen dosya yerletirilemedi"
  IDS_START_MONITOR               "%s\012\012Monitr balat? (Hayr reset atacaktr, ptal devam edecektir)"
  IDS_VICE_CPU_JAM                "VICE CPU SIKIMASI"
  IDS_EXTEND_TO_40_TRACKS         "Imaj 40-track biimine geniletilsin mi?"
  IDS_DETACHED_DEVICE_S           "Aygt %s kartld"
  IDS_ATTACHED_S_TO_DEVICE_S      "%s aygt#%s'a yerletirildi"
  IDS_DETACHED_TAPE               "Teyp kartld"
  IDS_HISTORY_RECORDED_UNKNOWN    "Tarihe bilinmeyen yaymlanmayla kaydedildi"
  IDS_HISTORY_RECORDED_VICE_S     "Tarihe VICE-%s ile kaydedildi"
  IDS_PAUSED                      "duraklatld"
  IDS_FRAME_NUMBER                "frame #"
  IDS_RESUMED                     "yeniden balatld"
  IDS_REALLY_EXIT                 "kmak istediinizden emin misiniz?\n\nEmle edilmi RAM'de bulunan mevcut tm veri kaybedilecektir."
  IDS_CANNOT_AUTOSTART_FILE       "Belirtilen dosya otomatik balatlamad."
  IDS_ATTACHED_TAPE_S             "Yerletirilmi teyp %s"
  IDS_SETTINGS_SAVED_SUCCESS      "Ayarlar baaryla kaydedildi."
  IDS_SETTINGS_LOADED_SUCCESS     "Ayarlar baaryla yklendi."
  IDS_ATTACH_DISK_IMAGE           "Disk imajn yerletir"
  IDS_ATTACH_TAPE_IMAGE           "Teyp imajn yerletir"
  IDS_AUTOSTART_IMAGE             "Disk/Teyp imajn otomatik balat"
  IDS_INVALID_CARTRIDGE           "Geersiz kartu"
  IDS_BAD_CARTRIDGE_CONFIG        "UI'de kt kartu konfigrasyonu!"
  IDS_INVALID_CARTRIDGE_IMAGE     "Geersiz kartu imaj"
  IDS_LOG_CONSOLE_OUTPUT_IMAGE    "konsol imaj kts loglanyor"
  IDS_LOG_FILES_TYPE              "VICE konsol log dosyalar (*.dbg)"
  IDS_CANNOT_WRITE_LOGFILE_S      "Log dosyas `%s' yazlamad."
  IDS_LOAD_FLIP_LIST_FILE         "Sralama listesi dosyasn ykle"
  IDS_CANNOT_READ_FLIP_LIST       "Sralama listesi dosyas okunamad."
  IDS_SAVE_FLIP_LIST_FILE         "Sralama listesi dosyasn kaydet"
  IDS_CANNOT_WRITE_FLIP_LIST      "Sralama listesi dosyas yazlamad"
  IDS_SELECT_KEYMAP_FILE          "Tu Haritas dosyas se"
  IDS_SAVE_KEYMAP_FILE            "Tu Haritas dosyasn kaydet"
  IDS_CANNOT_WRITE_KEYMAP_FILE    "Tu Haritas dosyas yazlamad"
  IDS_SAVE_CONFIG_FILE            "Konfigrasyon dosyasn kaydet"
  IDS_LOAD_CONFIG_FILE            "Konfigrasyon dosyasn ykle"
  IDS_MAPPING                     "Haritalama"
  IDS_KEYBOARD_SETTINGS           "Klavye ayarlar"
  IDS_ATTACH                      "&Yerletir"
  IDS_PLEASE_ENTER_A_FILENAME     "Ltfen dosya ismi girin."
  IDS_OVERWRITE_EXISTING_IMAGE    "Varolan imajn zerine yazlsn m?"
  IDS_CANNOT_CREATE_IMAGE         "Imaj yaratlamad"
  IDS_COMMAND_LINE_OPTIONS        "Komut satr seenekleri"
  IDS_COMMAND_OPTIONS_AVAIL       "Hangi komut satr seenekleri mevcut?"
  IDS_NO_DRIVER_SELECT_SUPPORT    "Seilmi src yok ya da desteklenmiyor"
  IDS_CANT_WRITE_SCREENSHOT_S     "Ekran grnts dosyas `%s' yazlamad."
  IDS_AUTOSTART_DISK_IMAGE        "Disk imajn otomatik balat"
  IDS_SELECT_FS_DIRECTORY         "Dosya sistem dizinini se"
  IDS_PRINTER_USERPORT            "Yazc Userport'u"
  IDS_PRINTER_4                   "Yazc 4"
  IDS_PRINTER_5                   "Yazc 5"
  IDS_DRIVE_8                     "Src 8"
  IDS_DRIVE_9                     "Src 9"
  IDS_DRIVE_10                    "Src 10"
  IDS_DRIVE_11                    "Src 11"
  IDS_PERIPHERAL_SETTINGS         "evresel Ayarlar"
  IDS_CANT_WRITE_SNAPSHOT_FILE    "Anlk grnt dosyas yazlamad."
  IDS_CANNOT_READ_SNAPSHOT_IMG    "Anlk grnt dosyas okunamad."
  IDS_LOAD_S_ROM_IMAGE            "%s ROM imajn ykle"
  IDS_SELECT_ROMSET_ARCHIVE       "Romset arivini se"
  IDS_CANNOT_LOAD_ROMSET_ARCH     "Romset arivi yklenemedi!"
  IDS_CANNOT_SAVE_ROMSET_ARCH     "Romset arivi kaydedilemedi!"
  IDS_CANNOT_LOAD_ROMSET_FILE     "Romset dosyas yklenemedi!"
  IDS_CANNOT_SAVE_ROMSET_FILE     "Romset dosyas kaydedilemedi!"
  IDS_SELECT_ROMSET_FILE          "Romset dosyasn se"
  IDS_ROMSET                      "Romset"
  IDS_COMPUTER                    "Bilgisayar"
  IDS_DRIVE                       "Src"
  IDS_ROM_SETTINGS                "ROM ayarlar"
  IDS_SAVE_SNAPSHOT_IMAGE         "Anlk grnt imajn kaydet"
  IDS_CANNOT_WRITE_SNAPSHOT_S     "Anlk grnt dosyas yazlamad `%s'."
  IDS_LOAD_SNAPSHOT_IMAGE         "Anlk grnt imajn ykle"
  IDS_COULD_NOT_LOAD_PALETTE      "Palet dosyas yklenemedi."
  IDS_LOAD_VICE_PALETTE_FILE      "VICE palet dosyas ykle"
  IDS_FULLSCREEN                  "Tam Ekran/DirectX"
  IDS_COLORS                      "Renkler"
  IDS_NEW_PAL                     "Yeni PAL emlasyonu"
  IDS_VIDEO_SETTINGS              "Grnt ayarlar"
  IDS_FILE_SYSTEM                 "Dosya sistemi"
#ifdef HAVE_OPENCBM
  IDS_REAL_IEC_DEVICE             "Gerek IEC aygt"
#endif
  IDS_RS232_DEVICE_I              "RS232 aygt %i"
  IDS_ATTACH_CRT_CART_IMAGE       "CRT kartu imaj yerletir"
  IDS_ATTACH_RAW_8KB_CART_IMAGE   "Dz 8KB kartu imaj yerletir"
  IDS_ATTACH_RAW_16KB_CART_IMG    "Dz 16KB kartu imaj yerletir"
  IDS_ATTACH_AR_CART_IMAGE        "Action Replay kartu imaj yerletir"
  IDS_ATTACH_AR3_CART_IMAGE       "Action Replay III kartu imaj yerletir"
  IDS_ATTACH_AR4_CART_IMAGE       "Action Replay 4 kartu imaj yerletir"
  IDS_ATTACH_STARDOS_CART_IMAGE   "StarDOS kartu imaj yerletir"
  IDS_ATTACH_ATOMIC_P_CART_IMG    "Atomic Power kartu imaj yerletir"
  IDS_ATTACH_EPYX_FL_CART_IMG     "Epyx fastload kartu imaj yerletir"
  IDS_ATTACH_IEEE488_CART_IMG     "IEEE arabirimi kartu imaj yerletir"
  IDS_ATTACH_RETRO_R_CART_IMG     "Retro Replay kartu imaj yerletir"
  IDS_ATTACH_IDE64_CART_IMAGE     "IDE64 arabirimi kartu imaj yerletir"
  IDS_ATTACH_SS4_CART_IMAGE       "Super Snapshot 4 kartu imaj yerletir"
  IDS_ATTACH_SS5_CART_IMAGE       "Super Snapshot 5 kartu imaj yerletir"
  IDS_ATTACH_STB_CART_IMAGE       "Structured Basic kartu imaj yerletir"
  IDS_MODEL                       "Model"
  IDS_DRIVE_SETTINGS              "Src Ayarlar"
  IDS_SELECT_START_SNAP_EVENT     "Olay tarihesi iin balang anlk grntsn se"
  IDS_SELECT_END_SNAP_EVENT       "Olay tarihesi iin biti anlk grntsn se"
#ifdef UNSTABLE
  IDS_VERSION_S_UNSTABLE          "Versiyon %s *STKRARSIZ* (%s)"
#else
  IDS_VERSION_S                   "Versiyon %s (%s)"
#endif
  IDS_VICE_CONTRIBUTORS           "VICE katlmclar"
  IDS_WHO_MADE_WHAT               "Kim ne yapt?"
  IDS_LICENSE                     "Lisans"
  IDS_NO_WARRANTY                 "Garanti verilmez!"
  IDS_VICE_WITHOUT_WARRANTY       "VICE HBR GARANT VERLMEDEN datlmtr!"
  IDS_PRESS_KEY_NORTHWEST         "KuzeyBat iin bir tua basn"
  IDS_PRESS_KEY_NORTH             "Kuzey iin bir tua basn"
  IDS_PRESS_KEY_NORTHEAST         "KuzeyDou iin bir tua basn"
  IDS_PRESS_KEY_EAST              "Dou iin bir tua basn"
  IDS_PRESS_KEY_SOUTHEAST         "GneyDou iin bir tua basn"
  IDS_PRESS_KEY_SOUTH             "Gney iin bir tua basn"
  IDS_PRESS_KEY_SOUTHWEST         "GneyBat iin bir tua basn"
  IDS_PRESS_KEY_WEST              "Bat iin bir tua basn"
  IDS_PRESS_KEY_FIRE              "Ate iin bir tua basn"
  IDS_NO_USERPORT_ADAPTER         "Userport joy dntrc yok"
  IDS_CGA_USERPORT_ADAPTER        "CGA userport joy dntrc"
  IDS_PET_USERPORT_ADAPTER        "PET userport joy dntrc"
  IDS_HUMMER_USERPORT_ADAPTER     "HUMMER userport joy dntrc"
  IDS_OEM_USERPORT_ADAPTER        "OEM userport joy dntrc"
  IDS_HIT_USERPORT_ADAPTER        "HIT userport joy dntrc"
  IDS_NO_SIDCART_JOY              "SID kartuu joy'unu pasifletir"
  IDS_SIDCART_JOY                 "SID kartuu joy'unu aktif et"
  IDS_NUMPAD_AND_RCTRL            "Numpad + Sa Ctrl"
  IDS_KEYSET_A                    "Tu Seti A"
  IDS_KEYSET_B                    "Tu Seti B"
  IDS_ALL_BUTTONS_AS_FIRE         "Tm dmeler ate olarak kullanlr"
  IDS_NUMERIC_SEE_ABOVE           "Nmerik (yukarya bakn)"
  IDS_NO_BUTTON_NO_AUTOFIRE       "Dme yok - Otomatik atei pasifletir"
  IDS_ALL_FILES_FILTER            "Tm dosyalar (*.*)"
  IDS_PALETTE_FILES_FILTER        "VICE palet dosyalar (*.vpl)"
  IDS_SNAPSHOT_FILES_FILTER       "VICE anlk grnt dosyalar (*.vsf)"
  IDS_CBM_IMAGE_FILES_FILTER      "CBM dosyalar (*.d64;*.d71;*.d80;*.d81;*.d82;*.g64;*.g41;*.x64;*.t64;*.tap;*.prg;*.p00)"
  IDS_DISK_IMAGE_FILES_FILTER     "Disk imaj dosyalar (*.d64;*.d71;*.d80;*.d81;*.d82;*.g64;*.g41;*.x64)"
  IDS_TAPE_IMAGE_FILES_FILTER     "Teyp imaj dosyalar (*.t64;*.tap)"
  IDS_ZIPPED_FILES_FILTER         "Ziplenmi dosyalar (*.zip;*.bz2;*.gz;*.d6z;*.d7z;*.d8z;*.g6z;*.g4z;*.x6z)"
  IDS_CRT_FILES_FILTER            "CRT kartu imaj dosyalar (*.crt)"
  IDS_RAW_CART_FILES_FILTER       "Dz kartu imaj dosyalar (*.bin)"
  IDS_FLIP_LIST_FILES_FILTER      "VICE sralama listesi dosyalar (*.vfl)"
  IDS_ROMSET_FILES_FILTER         "VICE romset dosyalar (*.vrs)"
  IDS_ROMSET_ARCHIVES_FILTER      "VICE romset arivleri (*.vra)"
  IDS_KEYMAP_FILES_FILTER         "VICE tu haritas dosyalar (*.vkm)"
  IDS_PRGP00_FILES_FILTER         "Commodore emlatr dosyalar (*.prg;*.p00)"
  IDS_FLEXIBLE                    "Esnek"
  IDS_ADJUSTING                   "Dzeltme"
  IDS_EXACT                       "Aynen"
  IDS_SOUND_DRIVER_DIRECTX        "Ses srcs: DirectX"
  IDS_SOUND_DRIVER_WMM            "Ses srcs: WMM"
  IDS_MEDIA_FILES_FILTER          "Ortam dosyalar (*.bmp;*.gif;*.iff;*.jpg;*.pcx;*.png;*.ppm;*.wav;*.mp3;*.avi;*.mpg)"
  IDS_SPACE_KB                    " kB"
  IDS_CONFIGURE_KEYSET_A          "Tu Seti A'y Konfigre Et"
  IDS_CONFIGURE_KEYSET_B          "Tu Seti B'yi Konfigre Et"
  IDS_SAVE_MEDIA_IMAGE            "Ortam imaj kaydet"
  IDS_S_AT_D_SPEED                "%s %d%% hznda, %d fps%s"
  IDS_TAPE                        "Teyp:"
  IDS_JOYSTICK_C                  "Joystick:"
  IDS_RECORDING                   "Kaydediliyor\n%02d:%02d"
  IDS_PLAYBACK                    "Kayttan yrtlyor\n%02d:%02d (%02d:%02d)"
  IDS_UNKNOWN                     "Bilinmeyen"
  IDS_P_NUMBER                    "<say>"
  IDS_SET_INPUT_JOYSTICK_1        "Joystick #1 iin giri aygt belirle"
  IDS_SET_INPUT_JOYSTICK_2        "Joystick #2 iin giri aygt belirle"
  IDS_SET_INPUT_EXTRA_JOYSTICK_1  "Ekstra joystick #1 iin giri aygt belirle"
  IDS_SET_INPUT_EXTRA_JOYSTICK_2  "Ekstra joystick #2 iin giri aygt belirle"
  IDS_SAVE_SETTINGS_ON_EXIT       "kta ayarlar (kaynaklar) kaydet"
  IDS_NO_SAVE_SETTINGS_ON_EXIT    "kta asla ayarlar (kaynaklar) kaydetme"
  IDS_CONFIRM_QUIT_VICE           "VICE'dan karken teyit et"
  IDS_NO_CONFIRM_QUIT_VICE        "VICE'dan karken asla teyit etme"
  IDS_USE_ALL_CPU_SMP             "SMP sistemlerinde tm CPUlar kullan"
  IDS_USE_FIRST_CPU_SMP           "SMP sistemlerinde yalnzca ilk CPU'yu kullan"
  IDS_START_VICE_FULLSCREEN_MODE  "VICE' tam ekran modunda balat"
  IDS_DISABLE_DX9                 "DirectX9 video srcsn pasifletir"
#ifdef SYS_SIGLIST_DECLARED
  IDS_RECEIVED_SIGNAL_D_S         "Beklenmeyen hata olutu. %d sinyali alnd (%s)."
#else
  IDS_RECEIVED_SIGNAL_D           "Beklenmeyen hata olutu. %d sinyali alnd."
#endif
#ifdef HAVE_NETWORK
  IDS_IDLE                        "Boa vakit geirme"
  IDS_SERVER_LISTENING            "Sunucu dinleniyor"
  IDS_CONNECTED_SERVER            "Sunucu Baland"
  IDS_CONNECTED_CLIENT            "stemci Baland"
  IDS_INVALID_PORT_NUMBER         "Geersiz port numaras"
  IDS_ERROR_STARTING_SERVER       "Sunucu balatlrken bir hata olutu."
  IDS_ERROR_CONNECTING_CLIENT     "stemciye balanrken bir hata olutu."
#endif
  IDS_SOUND_RECORDING_STARTED     "Ses Kayd balad..."
  IDS_SOUND_RECORDING_STOPPED     "Ses Kayd durduruldu"
  IDS_OK                          "Tamam"
  IDS_CANCEL                      "ptal"
  IDS_NONE                        "Yok"
  IDS_BROWSE                      "&Gz at..."
  IDS_SPECIFY_MIDI_IN             "Midi-In aygtn belirleyin"
  IDS_SPECIFY_MIDI_OUT            "Midi-Out aygtn belirleyin"
  IDS_ERROR_SAVING_EASYFLASH_CRT  "EasyFlash crt dosyas kayt hatas"
  IDS_DATASETTE_CAPTION           "Teyp Ayarlar"
  IDS_DATASETTE_RESET_WITH_CPU    "CPU ile birlikte Teyp'i &resetle"
  IDS_DATASETTE_MOTOR_GROUP       "Motorun okurkenki hz"
  IDS_DATASETTE_DELAY_TRIGGER     "cycle(lar) her tetikleme&de eklenen gecikme"
  IDS_DATASETTE_DELAY_AT_ZERO     "cyclelar sfr &gecikme deerinde"
  IDS_TOGGLE_USEIECDEVICE         "IEC Aygt K&ullan"
  IDS_SELECTDISK                  "Disk &imaj"
  IDS_SELECTDIR                   "&Dizin"
#ifdef HAVE_OPENCBM
  IDS_SELECTREAL                  "Ge&rek IEC aygt"
#endif
  IDS_SELECTNONE                  "&Yok"
  IDS_AUTOSTART                   "Otom&atik Balat"
  IDS_BROWSEDIR                   "&Gz at..."
  IDS_TOGGLE_ATTACH_READONLY      "Salt okunur yerletir"
  IDS_TOGGLE_READP00              "P00 dosyala&rn oku"
  IDS_TOGGLE_WRITEP00             "P00 dosyalarn &yaz"
  IDS_TOGGLE_HIDENONP00           "P00 &harici dosyalar gizle"
  IDS_JOYSTICK_CAPTION            "Joystick Ayarlar"
  IDS_JOYSTICK_IN_PORT_1          "Joystick port #&1'de"
  IDS_SELECT_FIRE_BUTTON          "Ate dmesini se"
  IDS_AUTO_FIRE_BUTTON_SETTINGS   "Otomatik ate dmesi ayarlar"
  IDS_AUTOFIRE_SPEED              "Otomatik ate &hz (1..32)"
  IDS_JOYSTICK_IN_PORT_2          "Joystick port #&2'de"
  IDS_JOY_CONFIG_A                "Tu Seti &A'y konfigre et"
  IDS_JOY_CONFIG_B                "Tu Seti &B'y konfigre et"
  IDS_JOY_CALIBRATE               "Joysti&ck(ler)i kalibre et"
  IDS_EXTRA_JOYSTICK_CAPTION      "Ekstra joystick ayarlar"
  IDS_JOYSTICK_IN_EXTRA_PORT_1    "Joystick ekstra port #&1'de"
  IDS_JOYSTICK_IN_EXTRA_PORT_2    "Joystick ekstra port #&2'de"
  IDS_KEYSET_SW                   "G&ney Bat"
  IDS_KEYSET_S                    "Gne&y"
  IDS_KEYSET_SE                   "Gney Do&u"
  IDS_KEYSET_W                    "&Bat"
  IDS_KEYSET_E                    "&Dou"
  IDS_KEYSET_NW                   "Ku&zey Bat"
  IDS_KEYSET_N                    "&Kuzey"
  IDS_KEYSET_NE                   "Kuz&ey Dou"
  IDS_KEYSET_FIRE                 "&Ate dmesi"
  IDS_SOUND_CAPTION               "Ses Aygt Ayarlarn Konfigre Et"
  IDS_SOUND_DIRECTX               "DirectX srcs"
  IDS_SOUND_WMM                   "WMM srcs"
  IDS_SOUND_SAMPLE_FREQUENCY      "rnekleme &Frekans :"
  IDS_SOUND_BUFFER_SIZE           "&Ses Arabellek Boyutu :"
  IDS_SOUND_FRAGMENT_SIZE_LABEL   "Sound Fragment Size :"
  IDS_SOUND_FRAGMENT_SIZE_SMALL   "Small"
  IDS_SOUND_FRAGMENT_SIZE_MEDIUM  "Medium"
  IDS_SOUND_FRAGMENT_SIZE_LARGE   "Large"
  IDS_SOUND_SYNCH_METHOD          "Senkronizasyon &Metodu :"
  IDS_TOGGLE_SNAPSHOT_SAVE_DISKS  "Halihazrda yerletirilmi &disk imajlarn kaydet"
  IDS_TOGGLE_SNAPSHOT_SAVE_ROMS   "Halihazrda yklenmi &ROM imajlarn kaydet"
  IDS_FULLSCREEN_DRIVER           "Src:"
  IDS_FULLSCREEN_DRVR_BITDEPTH    "Bit derinlii:"
  IDS_FULLSCREEN_DRVR_RESOLUTION  "znrlk:"
  IDS_FULLSCREEN_DRVR_REFRESHRATE "Yenileme hz:"
  IDS_TOGGLE_VIDEO_VBLANK_SYNC    "VBLANK senkronizasyonu"
  IDS_TOGGLE_VIDEO_DX_PRIMARY     "DX Birincil yzeyine iz"
  IDS_TOGGLE_KEEP_ASPECT_RATIO    "En boy oran koru (0,5..2)"
  IDS_COLORS_SATURATION           "Doygunluk (0..2)"
  IDS_COLORS_CONTRAST             "Kartlk (0..2)"
  IDS_COLORS_BRIGHTNESS           "Parlaklk (0..2)"
  IDS_NEW_PAL_TINT                "Ton (0..2)"
  IDS_NEW_PAL_ODD_LINES_PHASE     "Tek satrlar faz (0..2)"
  IDS_NEW_PAL_ODD_LINES_OFFSET    "Tek satrlar ofseti (0..2)"
  IDS_VIDEO_GAMMA                 "Gama (0..2)"
  IDS_VIDEO_PHASE                 "Faz (0..2)"
  IDS_VIDEO_PAL_SHADE             "PAL Nans (0..1)"
  IDS_VIDEO_PAL_BLUR              "PAL Bulankl (0..1)"
  IDS_TOGGLE_VIDEO_EXTPALETTE     "Harici Palet:"
  IDS_RAM_CAPTION                 "RAM Ayarlar"
  IDS_RAM_INIT_AT_POWERUP         "G verildiinde balang ayarlarn yap"
  IDS_RAM_VALUE_FIRST_BYTE        "lk byte deeri"
  IDS_RAM_LENGTH_CONSTANT_VALUES  "Sabit deerlerin uzunluu"
  IDS_RAM_LENGTH_CONSTANT_PATTERN "Sabit desenlerin uzunluu"
  IDS_PRINTER_EMULATION           "Yazc emlasyonu"
  IDS_PRINTER_FORMFEED            "Sayfa ilerletme gnder"
  IDS_FILESYSTEM_PRINTER          "Dosya sistemi yazcs"
  IDS_PRINTER_DRVR                "Yazc srcs"
  IDS_OUTPUT                      "kt"
  IDS_OUTPUT_TO_FILE              "kt dosyas #"
  IDS_OUTPUT_FILE1_NAME           "kt dosyas #1 ismi"
  IDS_OUTPUT_FILE2_NAME           "kt dosyas #2 ismi"
  IDS_OUTPUT_FILE3_NAME           "kt dosyas #3 ismi"
  IDS_ROMSET_SELECT_ARCHIVE       "Romset arivi"
  IDS_ROMSET_ARCHIVE_LOAD         "Ariv ykle"
  IDS_ROMSET_ARCHIVE_SAVE         "Ariv kaydet"
  IDS_ROMSET_CONFIGURATION        "&Konfigrasyon"
  IDS_ROMSET_ARCHIVE_APPLY        "Uygula"
  IDS_ROMSET_ARCHIVE_NEW          "Yeni"
  IDS_ROMSET_ARCHIVE_DELETE       "Sil"
  IDS_ROMSET_SELECT_FILE          "Romset dosyas"
  IDS_ROMSET_FILE_LOAD            "Romset ykle"
  IDS_ROMSET_FILE_SAVE            "Romset kaydet"
  IDS_CUSTOM_SPEED_CAPTION        "zel hz"
  IDS_ENTER_CUSTOM_SPEED          "zel hz girin [%]"
  IDS_NEW_CONFIGURATION           "Yeni konfigrasyon"
  IDS_ENTER_CONFIGURATION_NAME    "Konfigrasyon ismi girin"
  IDS_RS232_CAPTION               "RS232 Ayarlar"
  IDS_RS232_DEV_1                 "RS232 aygt 1"
  IDS_RS232_DEV_2                 "RS232 aygt 2"
  IDS_RS232_DEV_3                 "RS232 aygt 3"
  IDS_RS232_DEV_4                 "RS232 aygt 4"
  IDS_NETWORK_CAPTION             "Netplay Ayarlar"
  IDS_CURRENT_MODE                "Geerli mod"
  IDS_SERVER_BIND                 "Sunucu Balants"
  IDS_TCP_PORT                    "TCP-Port"
  IDS_NETWORK_SERVER              "Sunucuyu balat"
  IDS_NETWORK_CLIENT              "Balanlan"
  IDS_NETWORK_DISCONNECT          "Balanty kes"
  IDS_CONTROL                     "Kontrol"
  IDS_SERVER                      "Sunucu"
  IDS_CLIENT                      "stemci"
  IDS_KEYBOARD                    "Klavye"
  IDS_JOYSTICK_1                  "Joystick 1"
  IDS_JOYSTICK_2                  "Joystick 2"
  IDS_DEVICES                     "Aygtlar"
  IDS_SETTINGS                    "Ayarlar"
  IDS_TOGGLE_CONSOLE_APPEND       "V&arolan dosyaya log ekle"
  IDS_IMAGE_CONTENTS              "Imaj erii"
  IDS_NEW_IMAGE                   "Yeni maj"
  IDS_NAME                        "sim"
  IDS_ID                          "ID"
  IDS_TYPE                        "Tip"
  IDS_BLANK_IMAGE                 "Imaj Yarat"
  IDS_NEW_TAP_IMAGE               "Yeni TAP Imaj"
  IDS_SAVE                        "Kaydet"
  IDS_SELECT_DRIVER               "Src Se"
  IDS_FFMPEG_SETTINGS             "FFMPEG ayarlar"
  IDS_FORMAT                      "Biim"
  IDS_AUDIO_CODEC                 "Ses kodei"
  IDS_BITRATE                     "bithz"
  IDS_VIDEO_CODEC                 "Grnt kodei"
  IDS_SOUND_RECORD_CAPTION        "Ses kayt ayarlar"
  IDS_SOUND_RECORD_FORMAT_LABEL   "Ses Kayt Biimi"
  IDS_SOUND_RECORD_FILE_LABEL     "&Ses Kayt Dosyas"
  IDS_KERNAL                      "Kernal"
  IDS_BASIC                       "Basic"
  IDS_CHARACTER                   "Karakter"
  IDS_COMPUTER_RESOURCES_CAPTION  "Bilgisayar kaynaklar"
  IDS_COMPUTER_RESOURCES          "Bilgisayar kaynaklar romsete kaydedildi"
  IDS_DRIVE_RESOURCES_CAPTION     "Src kaynaklar"
  IDS_DRIVE_RESOURCES             "Src kaynaklar romsete kaydedildi"
  IDS_SYMBOLIC                    "&Sembolik"
  IDS_POSITIONAL                  "&Konumsal"
  IDS_DUMP_KEYSET                 "Tu Setini dk"
  IDS_DUMP_SHORTCUTS              "Ksayollar dk"
  IDS_SYMBOLIC_US                 "&Sembolik US"
  IDS_SYMBOLIC_DE                 "&Sembolik DE"
  IDS_GR_SYM                      "&Gr Sem."
  IDS_GR_POS                      "G&r Poz."
  IDS_UK_SYM                      "&UK Sem."
  IDS_UK_POS                      "U&K Poz."
  IDS_DE_SYM                      "&DE Sem."
  IDS_DE_POS                      "D&E Poz."
  IDS_A_MEMORY                    "&Bellek"
  IDS_DRIVE_TYPE                  "&Src tipi"
  IDS_40_TRACK_HANDLING           "40 &track ileme"
  IDS_SELECT_DRIVE_EXTEND_NEVER   "Asla geniletme"
  IDS_SELECT_DRIVE_EXTEND_ASK     "Geniletirken sor"
  IDS_SELECT_DRIVE_EXTEND_ACCESS  "Eriildiinde genilet"
  IDS_IDLE_METHOD                 "&Boa vakit geirme metodu"
  IDS_SELECT_DRIVE_IDLE_TRAP_IDLE "Trap boa vakit geirme"
  IDS_SELECT_DRIVE_IDLE_SKIP_CYC  "Cyclelar atla"
  IDS_TOGGLE_DRIVE_PARALLEL_CABLE "&Paralel kablo"
  IDS_DRIVE_EXPANSION             "Src g&eniletmesi"
  IDS_TOGGLE_DRIVE_EXPANSION_2000 "$2000-$3FFF &RAM"
  IDS_TOGGLE_DRIVE_EXPANSION_4000 "$&4000-$5FFF RAM"
  IDS_TOGGLE_DRIVE_EXPANSION_6000 "$&6000-$7FFF RAM"
  IDS_TOGGLE_DRIVE_EXPANSION_8000 "$8000-$9FFF RA&M"
  IDS_TOGGLE_DRIVE_EXPANSION_A000 "$&A000-$BFFF RAM"
  IDS_PLUS4_VIC20_MEMORY          "&Bellek"
  IDS_SID_GENGROUP1               "SID Motoru/Modeli"
  IDS_SID_FILTERS                 "SID Filtreleri"
  IDS_MP_FILE                     "&Dosya"
  IDS_MP_ATTACH_DISK_IMAGE        "&Disk imaj yerletir"
  IDS_MP_DETACH_DISK_IMAGE        "Disk imaj kar&t"
  IDS_MP_FLIP_LIST                "&Sralama listesi"
  IDS_MP_DATASETTE_CONTROL        "Teyp kontro&l"
  IDS_MP_ATTACH_CARTRIDGE_IMAGE   "&Kartu imaj yerletir..."
  IDS_MP_EXPERT_CARTRIDGE         "Expert Kartuu"
  IDS_MP_RESET                    "&Reset"
  IDS_MP_DEBUG                    "&Hata Aykla"
#ifdef DEBUG
  IDS_MP_MODE                     "M&od"
#endif
  IDS_MP_EDIT                     "Dzenle"
  IDS_MP_SNAPSHOT                 "&Anlk Grnt"
  IDS_MP_RECORDING_START_MODE     "Kayt balang modu"
  IDS_MP_OPTIONS                  "&Seenekler"
  IDS_MP_REFRESH_RATE             "&Yenileme hz"
  IDS_MP_MAXIMUM_SPEED            "&Maksimum Hz"
  IDS_MP_VIDEO_STANDARD           "G&ornt standart"
  IDS_MP_DRIVE_SYNC_FACTOR        "Src s&ync faktr"
  IDS_MP_SETTINGS                 "&Ayarlar"
  IDS_MP_CARTRIDGE_IO_SETTINGS    "&Kartu/G ayarlar"
  IDS_MP_LANGUAGE                 "Di&l"
  IDS_MP_HELP                     "&Yardm"
  IDS_MP_VIEW                     "&Grnm"
  IDS_MP_WINDOW                   "&Pencere"
  IDS_MI_EXIT                     "&k"
  IDS_MI_ABOUT                    "H&akknda..."
  IDS_MI_PAUSE                    "&Duraklat"
  IDS_MI_EDIT_COPY                "&Kopyala"
  IDS_MI_EDIT_PASTE               "Ya&ptr"
  IDS_MI_AUTOSTART                "Disk/Teyp imajlarn otom&atik balat..."
  IDS_MI_RESET_HARD               "&Hard"
  IDS_MI_RESET_SOFT               "&Soft"
  IDS_MI_DRIVE8                   "Src &8"
  IDS_MI_DRIVE9                   "Src &9"
  IDS_MI_DRIVE10                  "Src 1&0"
  IDS_MI_DRIVE11                  "Src 1&1"
  IDS_MI_ATTACH_TAPE              "&Teyp imaj yerletir..."
  IDS_MI_DETACH_TAPE              "Teyp imajn &kart"
  IDS_MI_DETACH_ALL               "&Tm"
  IDS_MI_TOGGLE_SOUND             "&Ses"
  IDS_MI_TOGGLE_DOUBLESIZE        "ift &boyut"
  IDS_MI_TOGGLE_DOUBLESCAN        "ift &tarama"
  IDS_MI_DRIVE_TRUE_EMULATION     "&Gerek src emlasyonu"
  IDS_MI_AUTOSTART_HANDLE_TDE     "TDE iin otomatik balatmay de&netle"
  IDS_MI_TOGGLE_VIDEOCACHE        "Grnt &nbellei"
  IDS_MI_DRIVE_SETTINGS           "&Src ayarlar..."
  IDS_MI_CART_ATTACH_CRT          "&CRT imaj..."
  IDS_MI_CART_ATTACH_8KB          "&8KB jenerik imaj..."
  IDS_MI_CART_ATTACH_16KB         "&16KB jenerik imaj..."
  IDS_MI_CART_ATTACH_AR           "&Action Replay imaj..."
  IDS_MI_CART_ATTACH_AR3          "&Action Replay 3 imaj..."
  IDS_MI_CART_ATTACH_AR4          "&Action Replay 4 imaj..."
  IDS_MI_CART_ATTACH_STARDOS      "&StarDOS imaj..."
  IDS_MI_CART_ATTACH_AT           "Atomic &Power imaj..."
  IDS_MI_CART_ATTACH_EPYX         "&Epyx fastload imaj..."
  IDS_MI_CART_ATTACH_IEEE488      "&IEEE488 arabirimi imaj..."
  IDS_MI_CART_ATTACH_RR           "&Retro Replay imaj..."
  IDS_MI_CART_ATTACH_IDE64        "IDE&64 arabirimi imaj..."
  IDS_MI_CART_ATTACH_SS4          "Super Snapshot &4 imaj..."
  IDS_MI_CART_ATTACH_SS5          "Super Snapshot &5 imaj..."
  IDS_MI_CART_ATTACH_STB          "Structured &Basic imaj..."
  IDS_MI_FLIP_ADD                 "Geerli im&aj ekle"
  IDS_MI_FLIP_REMOVE              "Geerli imaj kald&r"
  IDS_MI_FLIP_NEXT                "So&nraki imaj yerletir"
  IDS_MI_FLIP_PREVIOUS            "nce&ki imaj yerletir"
  IDS_MI_FLIP_LOAD                "Sralama &listesi ykle"
  IDS_MI_FLIP_SAVE                "&Sralama listesi kaydet"
  IDS_MI_DATASETTE_STOP           "&Durdur"
  IDS_MI_DATASETTE_START          "&Balat"
  IDS_MI_DATASETTE_FORWARD        "le&ri"
  IDS_MI_DATASETTE_REWIND         "&Geri"
  IDS_MI_DATASETTE_RECORD         "&Kayt"
  IDS_MI_DATASETTE_RESET          "R&eset"
  IDS_MI_DATASETTE_RESET_COUNTER  "Sayac &Resetle"
  IDS_MI_CART_ENABLE_EXPERT       "Aktif Et"
  IDS_MI_CART_MODE_OFF            "Kapal"
  IDS_MI_CART_MODE_ON             "Ak"
  IDS_MI_CART_SET_DEFAULT         "Kartuu &varsaylan yap"
  IDS_MI_TOGGLE_CART_RESET        "Kartu &deiiminde resetle"
  IDS_MI_CART_DETACH              "Kartu &imajn kart"
  IDS_MI_CART_FREEZE              "&Kartu dondurma"
  IDS_MI_MONITOR                  "&Monitr"
#ifdef DEBUG
  IDS_MI_DEBUG_MODE_NORMAL        "&Normal"
  IDS_MI_DEBUG_MODE_SMALL         "&Kk"
  IDS_MI_DEBUG_MODE_HISTORY       "Tari&he"
  IDS_MI_DEBUG_MODE_AUTOPLAY      "Tari&h Otomatik Yrtme"
  IDS_MI_TOGGLE_MAINCPU_TRACE     "Ana CPU zle&me"
  IDS_MI_TOGGLE_DRIVE0CPU_TRACE   "Src&0 CPU zleme"
  IDS_MI_TOGGLE_DRIVE1CPU_TRACE   "Src&1 CPU zleme"
#endif
  IDS_MI_SNAPSHOT_LOAD            "Anlk grnt imajn ykle..."
  IDS_MI_SNAPSHOT_SAVE            "Anlk grnt imajn &kaydet..."
  IDS_MI_LOADQUICK                "Hzl anlk grnt imaj yk&le"
  IDS_MI_SAVEQUICK                "Hzl anlk grnt imaj ka&ydet"
  IDS_MI_EVENT_TOGGLE_RECORD      "Kayt Tarihesini Balat/Du&rdur"
  IDS_MI_EVENT_TOGGLE_PLAYBACK    "K&ayttan Yrtme Tarihesini Balat/Durdur"
  IDS_MI_EVENT_SETMILESTONE       "Kayt kilometre ta koy"
  IDS_MI_EVENT_RESETMILESTONE     "Kilometre tana geri dn"
  IDS_MI_EVENT_START_MODE_SAVE    "Yeni anlk grnt &kaydet"
  IDS_MI_EVENT_START_MODE_LOAD    "Varolan anlk grnty yk&le"
  IDS_MI_EVENT_START_MODE_RESET   "&Reset ile bala"
  IDS_MI_EVENT_START_MODE_PLAYBCK "Kayttan yrtmenin &zerine yaz"
  IDS_MI_EVENT_DIRECTORY          "Tarihe dosyalar/dizin se"
  IDS_MI_MEDIAFILE                "Ortam dosyas kaydet/durdur..."
  IDS_MI_SOUND_RECORD_START       "Ses Kaydet..."
  IDS_MI_SOUND_RECORD_STOP        "Ses Kaydn Durdur"
  IDS_MI_REFRESH_RATE_AUTO        "Otom&atik"
  IDS_MI_MAXIMUM_SPEED_NO_LIMIT   "&Limitsiz"
  IDS_MI_MAXIMUM_SPEED_CUSTOM     "z&el"
  IDS_MI_TOGGLE_WARP_MODE         "&Warp modu"
  IDS_MI_TOGGLE_ALWAYSONTOP       "Her zaman stte"
  IDS_MI_TOGGLE_FASTPAL           "PAL Emlasyonu"
  IDS_MI_TOGGLE_SCALE2X           "2x Genilet"
  IDS_MI_SWAP_JOYSTICK            "&Joystickleri Yer Deitir"
  IDS_MI_SWAP_EXTRA_JOYSTICK      "&Userport Joysticklerini Yer Deitir"
  IDS_MI_ALLOW_JOY_OPPOSITE       "Allow opposite joystick directions"
  IDS_MI_JOYKEYS_TOGGLE           "Joy Tularn Aktif Et"
  IDS_MI_TOGGLE_VIRTUAL_DEVICES   "Sanal a&ygt trapleri"
  IDS_MI_TOGGLE_EMUID             "Emlatr Tesp&iti"
  IDS_MI_MOUSE                    "Mouse olaylarn &yakala"
  IDS_MI_AUTOSTART_SETTINGS       "Otom&atik balatma ayarlar..."
  IDS_MI_VIDEO_SETTINGS           "&Grnt ayalarlar..."
  IDS_MI_DEVICEMANAGER            "e&vresel ayarlar..."
  IDS_MI_JOY_SETTINGS             "&Joystick ayarlar..."
  IDS_MI_USERPORT_JOY_SETTINGS    "&Userport joystick ayarlar..."
  IDS_MI_SIDCART_JOY_SETTINGS     "&Sid kartuu joystick ayarlar..."
  IDS_MI_KEYBOARD_SETTINGS        "&Klavye ayarlar..."
  IDS_MI_SOUND_SETTINGS           "&Ses ayarlar..."
  IDS_MI_ROM_SETTINGS             "&ROM ayarlar..."
  IDS_MI_RAM_SETTINGS             "RA&M ayarlar..."
  IDS_MI_DATASETTE_SETTINGS       "Teyp &ayarlar..."
  IDS_MI_VICII_SETTINGS           "VIC-II ayarlar..."
  IDS_MI_MOUSE_SETTINGS           "Mo&use ayarlar..."
  IDS_MI_SID_SETTINGS             "S&ID ayarlar..."
  IDS_MI_RS232_SETTINGS           "RS&232 ayarlar"
  IDS_MI_REU_SETTINGS             "&REU ayarlar..."
  IDS_MI_GEORAM_SETTINGS          "&GEORAM ayarlar..."
  IDS_MI_RAMCART_SETTINGS         "&RAMCART ayarlar..."
  IDS_MI_DQBB_SETTINGS            "&Double Quick Brown Box ayarlar..."
  IDS_MI_ISEPIC_SETTINGS          "I&sepic ayarlar..."
  IDS_MI_MMC64_SETTINGS           "&MMC64 ayarlar..."
  IDS_MI_MIDI_SETTINGS            "M&IDI ayarlar..."
  IDS_MI_DIGIMAX_SETTINGS         "&DIGIMAX ayarlar..."
  IDS_MI_LIGHTPEN_SETTINGS        "&Ikl Kalem ayarlar..."
  IDS_MI_IDE64_SETTINGS           "&IDE64 ayarlar..."
#ifdef HAVE_TFE
  IDS_MI_TFE_SETTINGS             "&Ethernet ayarlar..."
#endif
  IDS_MI_ACIA_SETTINGS            "&ACIA ayarlar..."
  IDS_MI_RS232USER_SETTINGS       "RS&232 userport ayarlar..."
  IDS_MI_EASYFLASH_SETTINGS       "EasyFlash ayarlar..."
  IDS_MI_SFX_SE_SETTINGS          "SFX Sound Expander ayarlar..."
  IDS_MI_TOGGLE_SFX_SS            "SFX Sound Sampler' Aktif Et"
  IDS_MI_SETTINGS_SAVE_FILE       "Belirtilen dosyaya geerli ayarlar kaydet"
  IDS_MI_SETTINGS_LOAD_FILE       "Belirtilen dosyadan ayarlar ykle"
  IDS_MI_SETTINGS_SAVE            "Geerli ayarlar &kaydet"
  IDS_MI_SETTINGS_LOAD            "Kaydedilmi ayarlar yk&le"
  IDS_MI_SETTINGS_DEFAULT         "&Varsaylan ayarlar belirle"
  IDS_MI_SAVE_SETTINGS_ON_EXIT    "&kta ayarlar kaydet"
  IDS_MI_CONFIRM_ON_EXIT          "kta &teyit et"
  IDS_MI_LANG_EN                  "ngilizc&e"
  IDS_MI_LANG_DA                  "Da&nimarkaca"
  IDS_MI_LANG_DE                  "&Almanca"
  IDS_MI_LANG_FR                  "&Franszca"
  IDS_MI_LANG_HU                  "&Macarca"
  IDS_MI_LANG_IT                  "&talyanca"
  IDS_MI_LANG_NL                  "Hollan&daca"
  IDS_MI_LANG_PL                  "&Polonyaca"
  IDS_MI_LANG_SV                  "&svee"
  IDS_MI_LANG_TR                  "&Trke"
  IDS_MI_CMDLINE                  "K&omut satr seenekleri"
  IDS_MI_CONTRIBUTORS             "Katlm&clar"
  IDS_MI_LICENSE                  "&Lisans"
  IDS_MI_WARRANTY                 "Garanti &verilmez"
  IDS_MI_TOGGLE_FULLSCREEN        "Tam ekran"
  IDS_MI_SIDCART_SETTINGS         "&SID kartuu ayarlar..."
  IDS_MI_MON_OPEN                 "&A"
  IDS_MI_MON_SAVE                 "&Kaydet"
  IDS_MI_MON_PRINT                "&Yazdr"
  IDS_MI_MON_EXIT                 "&k\tAlt+F4"
  IDS_MI_MON_STOP_DEBUG           "Hata Ayklamay &Durdur"
  IDS_MI_MON_STOP_EXEC            "alt&rmay Durdur"
  IDS_MI_MON_STEP_INTO            "&Admla"
  IDS_MI_MON_STEP_OVER            "zerinden &ge"
  IDS_MI_MON_SKIP_RETURN          "Dnene kada&r admla"
  IDS_MI_MON_GOTO_CURSOR          "mle&ce git"
  IDS_MI_MON_EVAL                 "H&esapla"
  IDS_MI_MON_CURRENT              "&Geerli komut"
  IDS_MI_MON_WND_EVAL             "Hesaplama &penceresi"
  IDS_MI_MON_WND_REG              "Pence&reyi kaydet"
  IDS_MI_MON_WND_MEM              "&Bellek penceresi"
  IDS_MI_MON_WND_DIS              "&Dalm penceresi"
  IDS_MI_MON_WND_CONSOLE          "Konsol pen&ceresi"
  IDS_MI_MON_COMPUTER             "&Bilgisayar"
  IDS_MI_MON_DRIVE8               "Src &8"
  IDS_MI_MON_DRIVE9               "Src &9"
  IDS_MI_MON_CASCADE              "&Basamakla"
  IDS_MI_MON_TILE_VERT            "&Dikey de"
  IDS_MI_MON_TILE_HORIZ           "&Yatay de"
  IDS_MI_MON_ARRANGE_ICONS        "&Simgeleri yerletir"
END
#pragma code_page(28591)
