
#include "debug.h"
#include "config.h"
#include "res.h"
#include "rescommon.h"

#pragma code_page(28591)

#define FILE_DESCRIPTION  "Vice 264 Series Emulator (C16/Plus4)"



IDR_MENUPLUS4 MENU DISCARDABLE
BEGIN
    POPUP N_("&File")
    BEGIN
        MENUITEM "", IDM_AUTOSTART
        MENUITEM SEPARATOR
        POPUP N_("Attach &disk image")
        BEGIN
            MENUITEM "", IDM_ATTACH_8
            MENUITEM "", IDM_ATTACH_9
            MENUITEM "", IDM_ATTACH_10
            MENUITEM "", IDM_ATTACH_11
        END
        POPUP N_("D&etach disk image")
        BEGIN
            MENUITEM "", IDM_DETACH_8
            MENUITEM "", IDM_DETACH_9
            MENUITEM "", IDM_DETACH_10
            MENUITEM "", IDM_DETACH_11
            MENUITEM SEPARATOR
            MENUITEM "", IDM_DETACH_ALL
        END
        POPUP N_("&Flip list")
        BEGIN
            MENUITEM "", IDM_FLIP_ADD
            MENUITEM "", IDM_FLIP_REMOVE
            MENUITEM "", IDM_FLIP_NEXT
            MENUITEM "", IDM_FLIP_PREVIOUS
            MENUITEM SEPARATOR
            MENUITEM "", IDM_FLIP_LOAD
            MENUITEM "", IDM_FLIP_SAVE
        END
        MENUITEM SEPARATOR
        MENUITEM "", IDM_ATTACH_TAPE
        MENUITEM "", IDM_DETACH_TAPE
        POPUP N_("Datassette contro&l")
        BEGIN
            MENUITEM "", IDM_DATASETTE_CONTROL_STOP
            MENUITEM "", IDM_DATASETTE_CONTROL_START
            MENUITEM "", IDM_DATASETTE_CONTROL_FORWARD
            MENUITEM "", IDM_DATASETTE_CONTROL_REWIND
            MENUITEM "", IDM_DATASETTE_CONTROL_RECORD
            MENUITEM "", IDM_DATASETTE_CONTROL_RESET
            MENUITEM "", IDM_DATASETTE_RESET_COUNTER
        END
        MENUITEM SEPARATOR
        POPUP N_("Attach &cartridge image...")
        BEGIN
            MENUITEM "", IDM_CART_ATTACH_C1LO
            MENUITEM "", IDM_CART_ATTACH_C1HI
            MENUITEM "", IDM_CART_ATTACH_C2LO
            MENUITEM "", IDM_CART_ATTACH_C2HI
	    MENUITEM SEPARATOR
            MENUITEM "", IDM_CART_ATTACH_FUNCLO
            MENUITEM "", IDM_CART_ATTACH_FUNCHI
        END
        MENUITEM "", IDM_CART_DETACH
        MENUITEM SEPARATOR
        MENUITEM "", IDM_PAUSE, CHECKED
        MENUITEM "", IDM_MONITOR
        POPUP N_("&Reset")
        BEGIN
            MENUITEM "", IDM_RESET_HARD
            MENUITEM "", IDM_RESET_SOFT
            MENUITEM SEPARATOR
            MENUITEM "", IDM_RESET_DRIVE8
            MENUITEM "", IDM_RESET_DRIVE9
            MENUITEM "", IDM_RESET_DRIVE10
            MENUITEM "", IDM_RESET_DRIVE11
        END
#ifdef DEBUG
		POPUP N_("&Debug")
        BEGIN
            POPUP N_("M&ode")
            BEGIN
                MENUITEM "", IDM_DEBUG_MODE_NORMAL
                MENUITEM "", IDM_DEBUG_MODE_SMALL
                MENUITEM "", IDM_DEBUG_MODE_HISTORY
                MENUITEM "", IDM_DEBUG_MODE_AUTOPLAY
            END
            MENUITEM "", IDM_TOGGLE_MAINCPU_TRACE, CHECKED
            MENUITEM "", IDM_TOGGLE_DRIVE0CPU_TRACE, CHECKED
            MENUITEM "", IDM_TOGGLE_DRIVE1CPU_TRACE, CHECKED
        END
#endif
       MENUITEM SEPARATOR
       MENUITEM "", IDM_EXIT
    END
    POPUP N_("Edit")
    BEGIN
        MENUITEM "", IDM_EDIT_COPY
        MENUITEM "", IDM_EDIT_PASTE
    END
    POPUP N_("Sna&pshot")
    BEGIN
        MENUITEM "", IDM_SNAPSHOT_LOAD
        MENUITEM "", IDM_SNAPSHOT_SAVE
        MENUITEM "", IDM_LOADQUICK
        MENUITEM "", IDM_SAVEQUICK
        MENUITEM SEPARATOR
        MENUITEM "", IDM_EVENT_TOGGLE_RECORD
        MENUITEM "", IDM_EVENT_TOGGLE_PLAYBACK
        MENUITEM "", IDM_EVENT_SETMILESTONE
        MENUITEM "", IDM_EVENT_RESETMILESTONE
        POPUP N_("Recording start mode")
        BEGIN
            MENUITEM "", IDM_EVENT_START_MODE_SAVE
            MENUITEM "", IDM_EVENT_START_MODE_LOAD
            MENUITEM "", IDM_EVENT_START_MODE_RESET
            MENUITEM "", IDM_EVENT_START_MODE_PLAYBACK
        END
        MENUITEM "", IDM_EVENT_DIRECTORY
        MENUITEM SEPARATOR
        MENUITEM "", IDM_MEDIAFILE
        MENUITEM SEPARATOR
        MENUITEM "", IDM_SOUND_RECORD_START
        MENUITEM "", IDM_SOUND_RECORD_STOP
    END
    POPUP N_("&Options")
    BEGIN
        POPUP N_("&Refresh rate")
        BEGIN
            MENUITEM "",      IDM_REFRESH_RATE_AUTO
            MENUITEM N_("1/&1"),  IDM_REFRESH_RATE_1
            MENUITEM N_("1/&2"),  IDM_REFRESH_RATE_2
            MENUITEM N_("1/&3"),  IDM_REFRESH_RATE_3
            MENUITEM N_("1/&4"),  IDM_REFRESH_RATE_4
            MENUITEM N_("1/&5"),  IDM_REFRESH_RATE_5
            MENUITEM N_("1/&6"),  IDM_REFRESH_RATE_6
            MENUITEM N_("1/&7"),  IDM_REFRESH_RATE_7
            MENUITEM N_("1/&8"),  IDM_REFRESH_RATE_8
            MENUITEM N_("1/&9"),  IDM_REFRESH_RATE_9
            MENUITEM N_("1/1&0"), IDM_REFRESH_RATE_10
        END
        POPUP N_("&Maximum Speed")
        BEGIN
            MENUITEM N_("&200%"), IDM_MAXIMUM_SPEED_200
            MENUITEM N_("&100%"), IDM_MAXIMUM_SPEED_100
            MENUITEM N_("&50%"),  IDM_MAXIMUM_SPEED_50
            MENUITEM N_("&20%"),  IDM_MAXIMUM_SPEED_20
            MENUITEM N_("1&0%"),  IDM_MAXIMUM_SPEED_10
            MENUITEM "",      IDM_MAXIMUM_SPEED_NO_LIMIT
            MENUITEM SEPARATOR
            MENUITEM "",      IDM_MAXIMUM_SPEED_CUSTOM
        END
        MENUITEM "", IDM_TOGGLE_WARP_MODE, CHECKED
        MENUITEM SEPARATOR
        MENUITEM "", IDM_TOGGLE_FULLSCREEN
        MENUITEM "", IDM_TOGGLE_ALWAYSONTOP
        MENUITEM SEPARATOR
        MENUITEM "", IDM_TOGGLE_VIDEOCACHE, CHECKED
        MENUITEM "", IDM_TOGGLE_DOUBLESIZE, CHECKED
        MENUITEM "", IDM_TOGGLE_DOUBLESCAN, CHECKED
        MENUITEM "", IDM_TOGGLE_FASTPAL, CHECKED
        MENUITEM "", IDM_TOGGLE_SCALE2X, CHECKED
        MENUITEM SEPARATOR
        MENUITEM "", IDM_SWAP_JOYSTICK
        MENUITEM "", IDM_ALLOW_JOY_OPPOSITE_TOGGLE
        MENUITEM "", IDM_JOYKEYS_TOGGLE
        MENUITEM SEPARATOR
        MENUITEM "", IDM_TOGGLE_SOUND, CHECKED
        MENUITEM SEPARATOR
        MENUITEM "", IDM_TOGGLE_DRIVE_TRUE_EMULATION, CHECKED
        MENUITEM "", IDM_TOGGLE_AUTOSTART_HANDLE_TDE
        MENUITEM "", IDM_TOGGLE_VIRTUAL_DEVICES
        MENUITEM SEPARATOR
        POPUP N_("Vide&o standard")
        BEGIN
            MENUITEM N_("&PAL-G"),  IDM_SYNC_FACTOR_PAL
            MENUITEM N_("&NTSC-M"), IDM_SYNC_FACTOR_NTSC
        END
        MENUITEM SEPARATOR
    END
    POPUP N_("S&ettings")
    BEGIN
        MENUITEM "", IDM_AUTOSTART_SETTINGS
        MENUITEM "", IDM_VIDEO_SETTINGS
        MENUITEM "", IDM_DEVICEMANAGER
        MENUITEM "", IDM_DRIVE_SETTINGS
        MENUITEM "", IDM_DATASETTE_SETTINGS
        MENUITEM "", IDM_PLUS4_SETTINGS
        MENUITEM "", IDM_JOY_SETTINGS
        MENUITEM "", IDM_EXTRA_JOY_SETTINGS
        MENUITEM "", IDM_KEYBOARD_SETTINGS
        MENUITEM "", IDM_SOUND_SETTINGS
        MENUITEM "", IDM_ROM_SETTINGS
        MENUITEM "", IDM_RAM_SETTINGS
        MENUITEM "", IDM_RS232_SETTINGS
        POPUP N_("&Cartridge/IO Settings")
        BEGIN
            MENUITEM "", IDM_ACIA_SETTINGS
            MENUITEM "", IDM_SIDCART_SETTINGS
        END
        MENUITEM SEPARATOR
        MENUITEM "", IDM_SETTINGS_SAVE_FILE
        MENUITEM "", IDM_SETTINGS_LOAD_FILE
        MENUITEM "", IDM_SETTINGS_SAVE
        MENUITEM "", IDM_SETTINGS_LOAD
        MENUITEM "", IDM_SETTINGS_DEFAULT
        MENUITEM SEPARATOR
        MENUITEM "", IDM_TOGGLE_SAVE_SETTINGS_ON_EXIT
        MENUITEM "", IDM_TOGGLE_CONFIRM_ON_EXIT
    END
    POPUP N_("&Language")
    BEGIN
        MENUITEM "", IDM_LANG_EN
        MENUITEM "", IDM_LANG_DA
        MENUITEM "", IDM_LANG_DE
        MENUITEM "", IDM_LANG_FR
        MENUITEM "", IDM_LANG_HU
        MENUITEM "", IDM_LANG_IT
        MENUITEM "", IDM_LANG_NL
        MENUITEM "", IDM_LANG_PL
        MENUITEM "", IDM_LANG_SV
        MENUITEM "", IDM_LANG_TR
    END
    POPUP N_("&Help")
    BEGIN
        MENUITEM "", IDM_HELP
        MENUITEM SEPARATOR
        MENUITEM "", IDM_ABOUT
        MENUITEM SEPARATOR
        MENUITEM "", IDM_CMDLINE
        MENUITEM SEPARATOR
        MENUITEM "", IDM_CONTRIBUTORS
        MENUITEM "", IDM_LICENSE
        MENUITEM "", IDM_WARRANTY
    END
END



IDD_PLUS4ROM_SETTINGS_DIALOG DIALOG DISCARDABLE  0, 0, 240, 90
BEGIN
    LTEXT       "", IDC_KERNAL,
                9, 8, 40, 8
    EDITTEXT    IDC_PLUS4ROM_KERNAL_FILE,
                55, 7, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON  "", IDC_PLUS4ROM_KERNAL_BROWSE,
                185, 7, 50, 14, 0

    LTEXT       "", IDC_BASIC,
                9, 28, 40, 8
    EDITTEXT    IDC_PLUS4ROM_BASIC_FILE,
                55, 27, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON  "", IDC_PLUS4ROM_BASIC_BROWSE,
                185, 27, 50, 14, 0

    LTEXT       "", IDC_3_PLUS_1_LO,
                9, 48, 40, 8
    EDITTEXT    IDC_PLUS4ROM_3P1LO_FILE,
                55, 47, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON  "", IDC_PLUS4ROM_3P1LO_BROWSE,
                185, 47, 50, 14, 0

    LTEXT       "", IDC_3_PLUS_1_HI,
                9, 68, 40, 8
    EDITTEXT    IDC_PLUS4ROM_3P1HI_FILE,
                55, 67, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON  "", IDC_PLUS4ROM_3P1HI_BROWSE,
                185, 67, 50, 14, 0
END



IDD_PLUS4DRIVEROM_SETTINGS_DIALOG DIALOG DISCARDABLE  0, 0, 240, 130
BEGIN
    LTEXT       N_("1541"), IDC_1541,
                9, 8, 40, 8
    EDITTEXT    IDC_DRIVEROM_1541_FILE,
                55, 7, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON  "", IDC_DRIVEROM_1541_BROWSE,
                185, 7, 50, 14, 0

    LTEXT       N_("1541-II"), IDC_1541_II,
                9, 28, 40, 8
    EDITTEXT    IDC_DRIVEROM_1541II_FILE,
                55, 27, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON  "", IDC_DRIVEROM_1541II_BROWSE,
                185, 27, 50, 14, 0

    LTEXT       N_("1551"), IDC_1551,
                9, 48, 40, 8
    EDITTEXT    IDC_DRIVEROM_1551_FILE,
                55, 47, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON  "", IDC_DRIVEROM_1551_BROWSE,
                185, 47, 50, 14, 0

    LTEXT       N_("1570"), IDC_1570,
                9, 68, 40, 8
    EDITTEXT    IDC_DRIVEROM_1570_FILE,
                55, 67, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON  "", IDC_DRIVEROM_1570_BROWSE,
                185, 67, 50, 14, 0

    LTEXT       "", IDC_1571,
                9, 88, 40, 8
    EDITTEXT    IDC_DRIVEROM_1571_FILE,
                55, 87, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON  "", IDC_DRIVEROM_1571_BROWSE,
                185, 87, 50, 14, 0

    LTEXT       N_("1581"), IDC_1581,
                9, 108, 40, 8
    EDITTEXT    IDC_DRIVEROM_1581_FILE,
                55, 107, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON  "", IDC_DRIVEROM_1581_BROWSE,
                185, 107, 50, 14, 0
END



IDD_PLUS4ROM_RESOURCE_DIALOG DIALOG DISCARDABLE  0, 0, 160, 100
BEGIN
    GROUPBOX        "", IDC_COMPUTER_RESOURCES,
                    4, 3, 151, 70
    AUTOCHECKBOX    "", IDC_PLUS4ROM_KERNAL_RESOURCE,
                    11, 13, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX    "", IDC_PLUS4ROM_BASIC_RESOURCE,
                    11, 28, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX    "", IDC_PLUS4ROM_3P1LO_RESOURCE,
                    11, 43, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX    "", IDC_PLUS4ROM_3P1HI_RESOURCE,
                    11, 58, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP

    DEFPUSHBUTTON   "", IDOK,
                    20, 80, 50, 14, WS_TABSTOP
    PUSHBUTTON      "", IDCANCEL,
                    80, 80, 50, 14, WS_TABSTOP
END



IDD_PLUS4ROMDRIVE_RESOURCE_DIALOG DIALOG DISCARDABLE  0, 0, 160, 130
BEGIN
    GROUPBOX        "", IDC_DRIVE_RESOURCES,
                    4, 3, 151, 100
    AUTOCHECKBOX    N_("1541"), IDC_DRIVEROM_1541_RESOURCE,
                    11, 13, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX    N_("1541-II"), IDC_DRIVEROM_1541II_RESOURCE,
                    11, 28, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX    N_("1551"), IDC_DRIVEROM_1551_RESOURCE,
                    11, 43, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX    N_("1570"), IDC_DRIVEROM_1570_RESOURCE,
                    11, 58, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX    N_("1571"), IDC_DRIVEROM_1571_RESOURCE,
                    11, 73, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX    N_("1581"), IDC_DRIVEROM_1581_RESOURCE,
                    11, 88, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP

    DEFPUSHBUTTON   "", IDOK,
                    20, 110, 50, 14, WS_TABSTOP
    PUSHBUTTON      "", IDCANCEL,
                    80, 110, 50, 14, WS_TABSTOP
END



IDD_PLUS4_MEMORY_DIALOG DIALOG DISCARDABLE 0, 0, 130, 175
CAPTION N_("Plus4 settings")
BEGIN
    GROUPBOX        "", IDC_PLUS4_VIC20_MEMORY,
                    5, 15, 100, 135
    AUTORADIOBUTTON "", IDC_SELECT_PLUS4_MEM_16,
                    15, 30, 85, 10, BS_AUTORADIOBUTTON | WS_GROUP | WS_TABSTOP
    AUTORADIOBUTTON "", IDC_SELECT_PLUS4_MEM_32,
                    15, 45, 85, 10, BS_AUTORADIOBUTTON
    AUTORADIOBUTTON "", IDC_SELECT_PLUS4_MEM_64,
                    15, 60, 85, 10, BS_AUTORADIOBUTTON
    AUTORADIOBUTTON "", IDC_SELECT_PLUS4_MEM_256_CSORY,
                    15, 75, 85, 10, BS_AUTORADIOBUTTON
    AUTORADIOBUTTON "", IDC_SELECT_PLUS4_MEM_256_HANNES,
                    15, 90, 85, 10, BS_AUTORADIOBUTTON
    AUTORADIOBUTTON "", IDC_SELECT_PLUS4_MEM_1024_HANNES,
                    15, 105, 85, 10, BS_AUTORADIOBUTTON
    AUTORADIOBUTTON "", IDC_SELECT_PLUS4_MEM_4096_HANNES,
                    15, 120, 85, 10, BS_AUTORADIOBUTTON
    DEFPUSHBUTTON   "", IDOK,
                    5, 154, 50, 14, WS_TABSTOP
    PUSHBUTTON      "", IDCANCEL,
                    75, 154, 50, 14, WS_TABSTOP
END



IDD_PLUS4KBD_MAPPING_SETTINGS_DIALOG DIALOG DISCARDABLE 0, 0, 240, 120
BEGIN
    AUTORADIOBUTTON "", IDC_PLUS4KBD_MAPPING_SELECT_SYM,
                    10, 10, 54, 10, BS_AUTORADIOBUTTON | WS_GROUP | WS_TABSTOP
    AUTORADIOBUTTON "", IDC_PLUS4KBD_MAPPING_SELECT_POS,
                    10, 30, 54, 10, BS_AUTORADIOBUTTON

    EDITTEXT        IDC_PLUS4KBD_MAPPING_SYM,
                    65, 9, 110, 12, WS_TABSTOP
    PUSHBUTTON      "", IDC_PLUS4KBD_MAPPING_SYM_BROWSE,
                    185, 9, 50, 14, 0
    EDITTEXT        IDC_PLUS4KBD_MAPPING_POS,
                    65, 29, 110, 12, WS_TABSTOP
    PUSHBUTTON      "", IDC_PLUS4KBD_MAPPING_POS_BROWSE,
                    185, 29, 50, 14, 0

    PUSHBUTTON      "", IDC_PLUS4KBD_MAPPING_DUMP,
                    10, 54, 60, 14, 0
    PUSHBUTTON      "", IDC_KBD_SHORTCUT_DUMP,
                    80, 54, 60, 14, 0

    DEFPUSHBUTTON   "", IDOK,
                    20, 100, 50, 14, WS_TABSTOP
    PUSHBUTTON      "", IDCANCEL,
                    80, 100, 50, 14, WS_TABSTOP
END



STRINGTABLE
BEGIN
  IDS_ATTACH_FUNCTION_LOW_CART    N_("Attach cartridge image for Function Low")
  IDS_ATTACH_FUNCTION_HIGH_CART   N_("Attach cartridge image for Function High")
  IDS_ATTACH_CART1_LOW            N_("Attach cartridge image for Cartridge1 Low")
  IDS_ATTACH_CART1_HIGH           N_("Attach cartridge image for Cartridge1 High")
  IDS_ATTACH_CART2_LOW            N_("Attach cartridge image for Cartridge2 Low")
  IDS_ATTACH_CART2_HIGH           N_("Attach cartridge image for Cartridge2 High")
  IDS_3_PLUS_1_LO                 N_("3+1 Lo")
  IDS_3_PLUS_1_HI                 N_("3+1 Hi")
  IDS_PLUS4_SETTINGS_CAPTION      N_("Plus4 settings")
  IDS_SELECT_PLUS4_MEM_16         N_("&16 kByte")
  IDS_SELECT_PLUS4_MEM_32         N_("&32 kByte")
  IDS_SELECT_PLUS4_MEM_64         N_("&64 kByte")
  IDS_SELECT_PLUS4_MEM_256_CSORY  N_("2&56 kByte (CSORY)")
  IDS_SELECT_PLUS4_MEM_256_HANNES N_("&256 kByte (HANNES)")
  IDS_SELECT_PLUS4_MEM_1M_HANNES  N_("1&024 kByte (HANNES)")
  IDS_SELECT_PLUS4_MEM_4M_HANNES  N_("&4096 kByte (HANNES)")
  IDS_MI_CART_ATTACH_C1LO         N_("C1 low  image...")
  IDS_MI_CART_ATTACH_C1HI         N_("C1 high image...")
  IDS_MI_CART_ATTACH_C2LO         N_("C2 low  image...")
  IDS_MI_CART_ATTACH_C2HI         N_("C2 high image...")
  IDS_MI_CART_ATTACH_FUNCLO       N_("Function low  image (3plus1)...")
  IDS_MI_CART_ATTACH_FUNCHI       N_("Function high image (3plus1)...")
  IDS_MI_PLUS4_SETTINGS           N_("P&lus4 settings...")
END



STRINGTABLE
LANGUAGE LANG_DANISH, SUBLANG_NEUTRAL
BEGIN
  IDS_ATTACH_FUNCTION_LOW_CART    "Tilslut cartridge for Function Lav"
  IDS_ATTACH_FUNCTION_HIGH_CART   "Tilslut cartridge for Function Hj"
  IDS_ATTACH_CART1_LOW            "Tilslut cartridge image for Cartridge1 Lav"
  IDS_ATTACH_CART1_HIGH           "Tilslut cartridge image for Cartridge1 Hj"
  IDS_ATTACH_CART2_LOW            "Tilslut cartridge image for Cartridge2 Lav"
  IDS_ATTACH_CART2_HIGH           "Tilslut cartridge image for Cartridge2 Hj"
  IDS_3_PLUS_1_LO                 "3+1 Lav"
  IDS_3_PLUS_1_HI                 "3+1 Hj"
  IDS_PLUS4_SETTINGS_CAPTION      "Plus4-indstillinger"
  IDS_SELECT_PLUS4_MEM_16         "&16 kbyte"
  IDS_SELECT_PLUS4_MEM_32         "&32 kbyte"
  IDS_SELECT_PLUS4_MEM_64         "&64 kbyte"
  IDS_SELECT_PLUS4_MEM_256_CSORY  "2&56 kbyte (CSORY)"
  IDS_SELECT_PLUS4_MEM_256_HANNES "&256 kbyte (HANNES)"
  IDS_SELECT_PLUS4_MEM_1M_HANNES  "1&024 kbyte (HANNES)"
  IDS_SELECT_PLUS4_MEM_4M_HANNES  "&4096 kbyte (HANNES)"
  IDS_MI_CART_ATTACH_C1LO         "C1 lav-image..."
  IDS_MI_CART_ATTACH_C1HI         "C1 hj-image..."
  IDS_MI_CART_ATTACH_C2LO         "C2 lav-image..."
  IDS_MI_CART_ATTACH_C2HI         "C2 hj-image..."
  IDS_MI_CART_ATTACH_FUNCLO       "Funktion lav-image (3plus1)..."
  IDS_MI_CART_ATTACH_FUNCHI       "Funktion hj-image (3plus1)..."
  IDS_MI_PLUS4_SETTINGS           "P&lus4-indstillinger..."
END



STRINGTABLE
LANGUAGE LANG_GERMAN, SUBLANG_NEUTRAL
BEGIN
  IDS_ATTACH_FUNCTION_LOW_CART    "Funktions ROM (low) Erweiterungsmodul einlegen"
  IDS_ATTACH_FUNCTION_HIGH_CART   "Funktions ROM (high) Erweiterungsmodul einlegen"
  IDS_ATTACH_CART1_LOW            "Cartridge1 (low) Erweiterungsmodul einlegen"
  IDS_ATTACH_CART1_HIGH           "Cartridge1 (high) Erweiterungsmodul einlegen"
  IDS_ATTACH_CART2_LOW            "Cartridge2 (low) Erweiterungsmodul einlegen"
  IDS_ATTACH_CART2_HIGH           "Cartridge2 (high) Erweiterungsmodul einlegen"
  IDS_3_PLUS_1_LO                 "3+1 Lo"
  IDS_3_PLUS_1_HI                 "3+1 Hi"
  IDS_PLUS4_SETTINGS_CAPTION      "Plus4 einstellungen"
  IDS_SELECT_PLUS4_MEM_16         "&16 kByte"
  IDS_SELECT_PLUS4_MEM_32         "&32 kByte"
  IDS_SELECT_PLUS4_MEM_64         "&64 kByte"
  IDS_SELECT_PLUS4_MEM_256_CSORY  "2&56 kByte (CSORY)"
  IDS_SELECT_PLUS4_MEM_256_HANNES "&256 kByte (HANNES)"
  IDS_SELECT_PLUS4_MEM_1M_HANNES  "1&024 kByte (HANNES)"
  IDS_SELECT_PLUS4_MEM_4M_HANNES  "&4096 kByte (HANNES)"
  IDS_MI_CART_ATTACH_C1LO         "C1 low Image Datei..."
  IDS_MI_CART_ATTACH_C1HI         "C1 high Image Datei..."
  IDS_MI_CART_ATTACH_C2LO         "C2 low Image Datei..."
  IDS_MI_CART_ATTACH_C2HI         "C2 high Image Datei..."
  IDS_MI_CART_ATTACH_FUNCLO       "Funktions ROM Image Datei low (3plus1)..."
  IDS_MI_CART_ATTACH_FUNCHI       "Funktions ROM Image Datei high (3plus1)..."
  IDS_MI_PLUS4_SETTINGS           "P&lus4 Einstellungen..."
END



STRINGTABLE
LANGUAGE LANG_FRENCH, SUBLANG_NEUTRAL
BEGIN
  IDS_ATTACH_FUNCTION_LOW_CART    "Insrer une cartouche Fonction basse"
  IDS_ATTACH_FUNCTION_HIGH_CART   "Insrer une cartouche Fonction haute"
  IDS_ATTACH_CART1_LOW            "Insrer une cartouche pour Cartouche1 basse"
  IDS_ATTACH_CART1_HIGH           "Insrer une cartouche pour Cartouche1 haute"
  IDS_ATTACH_CART2_LOW            "Insrer une cartouche pour Cartouche2 basse"
  IDS_ATTACH_CART2_HIGH           "Insrer une cartouche pour Cartouche2 haute"
  IDS_3_PLUS_1_LO                 "3+1 Lo"
  IDS_3_PLUS_1_HI                 "3+1 Hi"
  IDS_PLUS4_SETTINGS_CAPTION      "Paramtres Plus4"
  IDS_SELECT_PLUS4_MEM_16         "&16 kOctets"
  IDS_SELECT_PLUS4_MEM_32         "&32 kOctets"
  IDS_SELECT_PLUS4_MEM_64         "&64 kOctets"
  IDS_SELECT_PLUS4_MEM_256_CSORY  "2&56 kOctets (CSORY)"
  IDS_SELECT_PLUS4_MEM_256_HANNES "&256 kOctets (HANNES)"
  IDS_SELECT_PLUS4_MEM_1M_HANNES  "1&024 kOctets (HANNES)"
  IDS_SELECT_PLUS4_MEM_4M_HANNES  "&4096 kOctets (HANNES)"
  IDS_MI_CART_ATTACH_C1LO         "Image C1 basse..."
  IDS_MI_CART_ATTACH_C1HI         "Image C1 haute..."
  IDS_MI_CART_ATTACH_C2LO         "Image C2 basse..."
  IDS_MI_CART_ATTACH_C2HI         "Image C2 haute..."
  IDS_MI_CART_ATTACH_FUNCLO       "Image Fonction basse (3+1)..."
  IDS_MI_CART_ATTACH_FUNCHI       "Image Fonction haute (3+1)..."
  IDS_MI_PLUS4_SETTINGS           "Paramtres P&lus4..."
END



#pragma code_page(28592)
STRINGTABLE
LANGUAGE LANG_HUNGARIAN, SUBLANG_NEUTRAL
BEGIN
  IDS_ATTACH_FUNCTION_LOW_CART    "Cartridge kpms csatolsa Function Low-hoz"
  IDS_ATTACH_FUNCTION_HIGH_CART   "Cartridge kpms csatolsa Function High-hez"
  IDS_ATTACH_CART1_LOW            "Cartridge kpms csatolsa als Cartridge1-hez"
  IDS_ATTACH_CART1_HIGH           "Cartridge kpms csatolsa fels Cartridge1-hez"
  IDS_ATTACH_CART2_LOW            "Cartridge kpms csatolsa als Cartridge2-hz"
  IDS_ATTACH_CART2_HIGH           "Cartridge kpms csatolsa fels Cartridge2-hz"
  IDS_3_PLUS_1_LO                 "3+1 Lo"
  IDS_3_PLUS_1_HI                 "3+1 Hi"
  IDS_PLUS4_SETTINGS_CAPTION      "Plus4 belltsai"
  IDS_SELECT_PLUS4_MEM_16         "&16 kBjt"
  IDS_SELECT_PLUS4_MEM_32         "&32 kBjt"
  IDS_SELECT_PLUS4_MEM_64         "&64 kBjt"
  IDS_SELECT_PLUS4_MEM_256_CSORY  "2&56 kBjt (CSORY)"
  IDS_SELECT_PLUS4_MEM_256_HANNES "&256 kBjt (HANNES)"
  IDS_SELECT_PLUS4_MEM_1M_HANNES  "1&024 kBjt (HANNES)"
  IDS_SELECT_PLUS4_MEM_4M_HANNES  "&4096 kBjt (HANNES)"
  IDS_MI_CART_ATTACH_C1LO         "C1 als kpms..."
  IDS_MI_CART_ATTACH_C1HI         "C1 fels kpms..."
  IDS_MI_CART_ATTACH_C2LO         "C2 als kpms..."
  IDS_MI_CART_ATTACH_C2HI         "C2 fels kpms..."
  IDS_MI_CART_ATTACH_FUNCLO       "Function als kpms (3plus1)..."
  IDS_MI_CART_ATTACH_FUNCHI       "Function fels kpms (3plus1)..."
  IDS_MI_PLUS4_SETTINGS           "P&lus4 belltsai..."
END
#pragma code_page(28591)



STRINGTABLE
LANGUAGE LANG_ITALIAN, SUBLANG_NEUTRAL
BEGIN
  IDS_ATTACH_FUNCTION_LOW_CART    "Seleziona l'immagine di una cartuccia per la Function Low"
  IDS_ATTACH_FUNCTION_HIGH_CART   "Seleziona l'immagine di una cartuccia per la Function High"
  IDS_ATTACH_CART1_LOW            "Seleziona l'immagine di una cartuccia per la Cartridge1 Low"
  IDS_ATTACH_CART1_HIGH           "Seleziona l'immagine di una cartuccia per la Cartridge1 High"
  IDS_ATTACH_CART2_LOW            "Seleziona l'immagine di una cartuccia per la Cartridge2 Low"
  IDS_ATTACH_CART2_HIGH           "Seleziona l'immagine di una cartuccia per la Cartridge2 High"
  IDS_3_PLUS_1_LO                 "3+1 Lo"
  IDS_3_PLUS_1_HI                 "3+1 Hi"
  IDS_PLUS4_SETTINGS_CAPTION      "Impostazioni Plus4"
  IDS_SELECT_PLUS4_MEM_16         "&16 kByte"
  IDS_SELECT_PLUS4_MEM_32         "&32 kByte"
  IDS_SELECT_PLUS4_MEM_64         "&64 kByte"
  IDS_SELECT_PLUS4_MEM_256_CSORY  "2&56 kByte (CSORY)"
  IDS_SELECT_PLUS4_MEM_256_HANNES "&256 kByte (HANNES)"
  IDS_SELECT_PLUS4_MEM_1M_HANNES  "1&024 kByte (HANNES)"
  IDS_SELECT_PLUS4_MEM_4M_HANNES  "&4096 kByte (HANNES)"
  IDS_MI_CART_ATTACH_C1LO         "Immagine C1 bassa..."
  IDS_MI_CART_ATTACH_C1HI         "Immagine C1 alta..."
  IDS_MI_CART_ATTACH_C2LO         "Immagine C2 bassa..."
  IDS_MI_CART_ATTACH_C2HI         "Immagine C2 alta..."
  IDS_MI_CART_ATTACH_FUNCLO       "Immagine della Function low (3plus1)..."
  IDS_MI_CART_ATTACH_FUNCHI       "Immagine della Function high (3plus1)..."
  IDS_MI_PLUS4_SETTINGS           "Impostazioni P&lus4..."
END



STRINGTABLE
LANGUAGE LANG_DUTCH, SUBLANG_NEUTRAL
BEGIN
  IDS_ATTACH_FUNCTION_LOW_CART    "Koppel cartridgebestand voor 'Function Low'"
  IDS_ATTACH_FUNCTION_HIGH_CART   "Koppel cartridgebestand voor 'Function High'"
  IDS_ATTACH_CART1_LOW            "Koppel cartridgebestand voor 'Cartridge1 Low'"
  IDS_ATTACH_CART1_HIGH           "Koppel cartridgebestand voor 'Cartridge1 High'"
  IDS_ATTACH_CART2_LOW            "Koppel cartridgebestand voor 'Cartridge2 Low'"
  IDS_ATTACH_CART2_HIGH           "Koppel cartridgebestand voor 'Cartridge2 High'"
  IDS_3_PLUS_1_LO                 "3+1 Lo"
  IDS_3_PLUS_1_HI                 "3+1 Hi"
  IDS_PLUS4_SETTINGS_CAPTION      "Plus4-instellingen"
  IDS_SELECT_PLUS4_MEM_16         "&16 kByte"
  IDS_SELECT_PLUS4_MEM_32         "&32 kByte"
  IDS_SELECT_PLUS4_MEM_64         "&64 kByte"
  IDS_SELECT_PLUS4_MEM_256_CSORY  "2&56 kByte (CSORY)"
  IDS_SELECT_PLUS4_MEM_256_HANNES "&256 kByte (HANNES)"
  IDS_SELECT_PLUS4_MEM_1M_HANNES  "1&024 kByte (HANNES)"
  IDS_SELECT_PLUS4_MEM_4M_HANNES  "&4096 kByte (HANNES)"
  IDS_MI_CART_ATTACH_C1LO         "C1 low-bestand..."
  IDS_MI_CART_ATTACH_C1HI         "C1 high-bestand..."
  IDS_MI_CART_ATTACH_C2LO         "C2 low-bestand..."
  IDS_MI_CART_ATTACH_C2HI         "C2 high-bestand..."
  IDS_MI_CART_ATTACH_FUNCLO       "Function low-bestand (3plus1)..."
  IDS_MI_CART_ATTACH_FUNCHI       "Function high-bestand (3plus1)..."
  IDS_MI_PLUS4_SETTINGS           "P&lus4-instellingen..."
END



#pragma code_page(28592)
STRINGTABLE
LANGUAGE LANG_POLISH, SUBLANG_NEUTRAL
BEGIN
  IDS_ATTACH_FUNCTION_LOW_CART    "Attach cartridge image for Function Low"
  IDS_ATTACH_FUNCTION_HIGH_CART   "Attach cartridge image for Function High"
  IDS_ATTACH_CART1_LOW            "Attach cartridge image for Cartridge1 Low"
  IDS_ATTACH_CART1_HIGH           "Attach cartridge image for Cartridge1 High"
  IDS_ATTACH_CART2_LOW            "Attach cartridge image for Cartridge2 Low"
  IDS_ATTACH_CART2_HIGH           "Attach cartridge image for Cartridge2 High"
  IDS_3_PLUS_1_LO                 "3+1 Lo"
  IDS_3_PLUS_1_HI                 "3+1 Hi"
  IDS_PLUS4_SETTINGS_CAPTION      "Ustawienia Plus4"
  IDS_SELECT_PLUS4_MEM_16         "&16 kByte"
  IDS_SELECT_PLUS4_MEM_32         "&32 kByte"
  IDS_SELECT_PLUS4_MEM_64         "&64 kByte"
  IDS_SELECT_PLUS4_MEM_256_CSORY  "2&56 kByte (CSORY)"
  IDS_SELECT_PLUS4_MEM_256_HANNES "&256 kByte (HANNES)"
  IDS_SELECT_PLUS4_MEM_1M_HANNES  "1&024 kByte (HANNES)"
  IDS_SELECT_PLUS4_MEM_4M_HANNES  "&4096 kByte (HANNES)"
  IDS_MI_CART_ATTACH_C1LO         "C1 low  image..."
  IDS_MI_CART_ATTACH_C1HI         "C1 high image..."
  IDS_MI_CART_ATTACH_C2LO         "C2 low  image..."
  IDS_MI_CART_ATTACH_C2HI         "C2 high image..."
  IDS_MI_CART_ATTACH_FUNCLO       "Function low  image (3plus1)..."
  IDS_MI_CART_ATTACH_FUNCHI       "Function high image (3plus1)..."
  IDS_MI_PLUS4_SETTINGS           "Ustawienia P&lus4..."
END
#pragma code_page(28591)



STRINGTABLE
LANGUAGE LANG_SWEDISH, SUBLANG_NEUTRAL
BEGIN
  IDS_ATTACH_FUNCTION_LOW_CART    "Anslut insticksmodulfil fr funktion lg"
  IDS_ATTACH_FUNCTION_HIGH_CART   "Anslut insticksmodulfil fr funktion hg"
  IDS_ATTACH_CART1_LOW            "Anslut insticksmodulfil fr modul1 lg"
  IDS_ATTACH_CART1_HIGH           "Anslut insticksmodulfil fr modul1 hg"
  IDS_ATTACH_CART2_LOW            "Anslut insticksmodulfil fr modul2 lg"
  IDS_ATTACH_CART2_HIGH           "Anslut insticksmodulfil fr modul2 hg"
  IDS_3_PLUS_1_LO                 "3+1 L"
  IDS_3_PLUS_1_HI                 "3+1 H"
  IDS_PLUS4_SETTINGS_CAPTION      "Plus4-instllningar"
  IDS_SELECT_PLUS4_MEM_16         "&16 kbyte"
  IDS_SELECT_PLUS4_MEM_32         "&32 kbyte"
  IDS_SELECT_PLUS4_MEM_64         "&64 kbyte"
  IDS_SELECT_PLUS4_MEM_256_CSORY  "2&56 kByte (CSORY)"
  IDS_SELECT_PLUS4_MEM_256_HANNES "&256 kByte (HANNES)"
  IDS_SELECT_PLUS4_MEM_1M_HANNES  "1&024 kByte (HANNES)"
  IDS_SELECT_PLUS4_MEM_4M_HANNES  "&4096 kByte (HANNES)"
  IDS_MI_CART_ATTACH_C1LO         "C1 lg-avbildning..."
  IDS_MI_CART_ATTACH_C1HI         "C1 hg-avbildning..."
  IDS_MI_CART_ATTACH_C2LO         "C2 lg-avbildning..."
  IDS_MI_CART_ATTACH_C2HI         "C2 hg-avbildning..."
  IDS_MI_CART_ATTACH_FUNCLO       "Funktion lg-avbildning (3plus1)..."
  IDS_MI_CART_ATTACH_FUNCHI       "Funktion hg-avbildning (3plus1)..."
  IDS_MI_PLUS4_SETTINGS           "P&lus4-instllningar..."
END



#pragma code_page(28599)
STRINGTABLE
LANGUAGE LANG_TURKISH, SUBLANG_NEUTRAL
BEGIN
  IDS_ATTACH_FUNCTION_LOW_CART    "Function Low iin kartu imaj yerletirin"
  IDS_ATTACH_FUNCTION_HIGH_CART   "Function High iin kartu imaj yerletirin"
  IDS_ATTACH_CART1_LOW            "Kartu1 Low iin kartu imaj yerletirin"
  IDS_ATTACH_CART1_HIGH           "Kartu1 High iin kartu imaj yerletirin"
  IDS_ATTACH_CART2_LOW            "Kartu2 Low iin kartu imaj yerletirin"
  IDS_ATTACH_CART2_HIGH           "Kartu2 High iin kartu imaj yerletirin"
  IDS_3_PLUS_1_LO                 "3+1 Lo"
  IDS_3_PLUS_1_HI                 "3+1 Hi"
  IDS_PLUS4_SETTINGS_CAPTION      "Plus4 ayarlar"
  IDS_SELECT_PLUS4_MEM_16         "&16 kByte"
  IDS_SELECT_PLUS4_MEM_32         "&32 kByte"
  IDS_SELECT_PLUS4_MEM_64         "&64 kByte"
  IDS_SELECT_PLUS4_MEM_256_CSORY  "2&56 kByte (CSORY)"
  IDS_SELECT_PLUS4_MEM_256_HANNES "&256 kByte (HANNES)"
  IDS_SELECT_PLUS4_MEM_1M_HANNES  "1&024 kByte (HANNES)"
  IDS_SELECT_PLUS4_MEM_4M_HANNES  "&4096 kByte (HANNES)"
  IDS_MI_CART_ATTACH_C1LO         "C1 low imaj..."
  IDS_MI_CART_ATTACH_C1HI         "C1 high imaj..."
  IDS_MI_CART_ATTACH_C2LO         "C2 low imaj..."
  IDS_MI_CART_ATTACH_C2HI         "C2 high imaj..."
  IDS_MI_CART_ATTACH_FUNCLO       "Function low  imaj (3plus1)..."
  IDS_MI_CART_ATTACH_FUNCHI       "Function high imaj (3plus1)..."
  IDS_MI_PLUS4_SETTINGS           "P&lus4 ayarlar..."
END
#pragma code_page(28591)
