
#include "config.h"
#include "debug.h"
#include "config.h"
#include "res.h"
#include "rescommon.h"

#pragma code_page(28591)


#define FILE_DESCRIPTION  "Vice C128 Emulator"


IDR_MENUC128 MENU DISCARDABLE
BEGIN
    POPUP N_("&File")
    BEGIN
        MENUITEM "", IDM_AUTOSTART
        MENUITEM SEPARATOR
        POPUP N_("Attach &disk image")
        BEGIN
            MENUITEM "", IDM_ATTACH_8
            MENUITEM "", IDM_ATTACH_9
            MENUITEM "", IDM_ATTACH_10
            MENUITEM "", IDM_ATTACH_11
        END
        POPUP N_("D&etach disk image")
        BEGIN
            MENUITEM "", IDM_DETACH_8
            MENUITEM "", IDM_DETACH_9
            MENUITEM "", IDM_DETACH_10
            MENUITEM "", IDM_DETACH_11
            MENUITEM SEPARATOR
            MENUITEM "", IDM_DETACH_ALL
        END
        POPUP N_("&Flip list")
        BEGIN
            MENUITEM "", IDM_FLIP_ADD
            MENUITEM "", IDM_FLIP_REMOVE
            MENUITEM "", IDM_FLIP_NEXT
            MENUITEM "", IDM_FLIP_PREVIOUS
            MENUITEM SEPARATOR
            MENUITEM "", IDM_FLIP_LOAD
            MENUITEM "", IDM_FLIP_SAVE
        END
        MENUITEM SEPARATOR
        MENUITEM "", IDM_ATTACH_TAPE
        MENUITEM "", IDM_DETACH_TAPE
        POPUP N_("Datassette contro&l")
        BEGIN
            MENUITEM "", IDM_DATASETTE_CONTROL_STOP
            MENUITEM "", IDM_DATASETTE_CONTROL_START
            MENUITEM "", IDM_DATASETTE_CONTROL_FORWARD
            MENUITEM "", IDM_DATASETTE_CONTROL_REWIND
            MENUITEM "", IDM_DATASETTE_CONTROL_RECORD
            MENUITEM "", IDM_DATASETTE_CONTROL_RESET
            MENUITEM "", IDM_DATASETTE_RESET_COUNTER
        END
        MENUITEM SEPARATOR
        POPUP N_("Attach &cartridge image...")
        BEGIN
            MENUITEM "", IDM_CART_ATTACH_CRT
            MENUITEM SEPARATOR
            MENUITEM "", IDM_CART_ATTACH_8KB
            MENUITEM "", IDM_CART_ATTACH_16KB
            MENUITEM "", IDM_CART_ATTACH_AR
            MENUITEM "", IDM_CART_ATTACH_AR3
            MENUITEM "", IDM_CART_ATTACH_AR4
            MENUITEM "", IDM_CART_ATTACH_STARDOS
            MENUITEM "", IDM_CART_ATTACH_AT
            MENUITEM "", IDM_CART_ATTACH_EPYX
            MENUITEM "", IDM_CART_ATTACH_IEEE488
            MENUITEM "", IDM_CART_ATTACH_RR
            MENUITEM "", IDM_CART_ATTACH_IDE64
            MENUITEM "", IDM_CART_ATTACH_SS4
            MENUITEM "", IDM_CART_ATTACH_SS5
            MENUITEM "", IDM_CART_ATTACH_STB
            POPUP N_("Expert Cartridge")
            BEGIN
                MENUITEM "", IDM_CART_ENABLE_EXPERT
                MENUITEM SEPARATOR
                MENUITEM "",    IDM_CART_MODE_OFF
                MENUITEM N_("Prg"), IDM_CART_MODE_PRG
                MENUITEM "",    IDM_CART_MODE_ON
            END
            MENUITEM SEPARATOR
            MENUITEM "", IDM_CART_SET_DEFAULT
            MENUITEM "", IDM_TOGGLE_CART_RESET
        END
        MENUITEM "", IDM_CART_DETACH
        MENUITEM "", IDM_CART_FREEZE
        MENUITEM SEPARATOR
        MENUITEM "", IDM_PAUSE, CHECKED
        MENUITEM "", IDM_MONITOR
        POPUP N_("&Reset")
        BEGIN
            MENUITEM "", IDM_RESET_HARD
            MENUITEM "", IDM_RESET_SOFT
            MENUITEM SEPARATOR
            MENUITEM "", IDM_RESET_DRIVE8
            MENUITEM "", IDM_RESET_DRIVE9
            MENUITEM "", IDM_RESET_DRIVE10
            MENUITEM "", IDM_RESET_DRIVE11
        END
#ifdef DEBUG
        POPUP N_("&Debug")
        BEGIN
            POPUP N_("M&ode")
            BEGIN
                MENUITEM "", IDM_DEBUG_MODE_NORMAL
                MENUITEM "", IDM_DEBUG_MODE_SMALL
                MENUITEM "", IDM_DEBUG_MODE_HISTORY
                MENUITEM "", IDM_DEBUG_MODE_AUTOPLAY
            END
            MENUITEM "", IDM_TOGGLE_MAINCPU_TRACE,   CHECKED
            MENUITEM "", IDM_TOGGLE_DRIVE0CPU_TRACE, CHECKED
            MENUITEM "", IDM_TOGGLE_DRIVE1CPU_TRACE, CHECKED
        END
#endif
        MENUITEM SEPARATOR
        MENUITEM "", IDM_EXIT
    END
    POPUP N_("Edit")
    BEGIN
        MENUITEM "", IDM_EDIT_COPY
        MENUITEM "", IDM_EDIT_PASTE
    END
    POPUP N_("Sna&pshot")
    BEGIN
        MENUITEM "", IDM_SNAPSHOT_LOAD
        MENUITEM "", IDM_SNAPSHOT_SAVE
        MENUITEM "", IDM_LOADQUICK
        MENUITEM "", IDM_SAVEQUICK
        MENUITEM SEPARATOR
        MENUITEM "", IDM_EVENT_TOGGLE_RECORD
        MENUITEM "", IDM_EVENT_TOGGLE_PLAYBACK
        MENUITEM "", IDM_EVENT_SETMILESTONE
        MENUITEM "", IDM_EVENT_RESETMILESTONE
        POPUP N_("Recording start mode")
        BEGIN
            MENUITEM "", IDM_EVENT_START_MODE_SAVE
            MENUITEM "", IDM_EVENT_START_MODE_LOAD
            MENUITEM "", IDM_EVENT_START_MODE_RESET
            MENUITEM "", IDM_EVENT_START_MODE_PLAYBACK
        END
        MENUITEM "", IDM_EVENT_DIRECTORY
        MENUITEM SEPARATOR
        MENUITEM "", IDM_MEDIAFILE
        MENUITEM SEPARATOR
        MENUITEM "", IDM_SOUND_RECORD_START
        MENUITEM "", IDM_SOUND_RECORD_STOP
    END
    POPUP N_("&Options")
    BEGIN
        POPUP N_("&Refresh rate")
        BEGIN
            MENUITEM "",      IDM_REFRESH_RATE_AUTO
            MENUITEM N_("1/&1"),  IDM_REFRESH_RATE_1
            MENUITEM N_("1/&2"),  IDM_REFRESH_RATE_2
            MENUITEM N_("1/&3"),  IDM_REFRESH_RATE_3
            MENUITEM N_("1/&4"),  IDM_REFRESH_RATE_4
            MENUITEM N_("1/&5"),  IDM_REFRESH_RATE_5
            MENUITEM N_("1/&6"),  IDM_REFRESH_RATE_6
            MENUITEM N_("1/&7"),  IDM_REFRESH_RATE_7
            MENUITEM N_("1/&8"),  IDM_REFRESH_RATE_8
            MENUITEM N_("1/&9"),  IDM_REFRESH_RATE_9
            MENUITEM N_("1/1&0"), IDM_REFRESH_RATE_10
        END
        POPUP N_("&Maximum Speed")
        BEGIN
            MENUITEM N_("&200%"), IDM_MAXIMUM_SPEED_200
            MENUITEM N_("&100%"), IDM_MAXIMUM_SPEED_100
            MENUITEM N_("&50%"),  IDM_MAXIMUM_SPEED_50
            MENUITEM N_("&20%"),  IDM_MAXIMUM_SPEED_20
            MENUITEM N_("1&0%"),  IDM_MAXIMUM_SPEED_10
            MENUITEM "",      IDM_MAXIMUM_SPEED_NO_LIMIT
            MENUITEM SEPARATOR
            MENUITEM "",      IDM_MAXIMUM_SPEED_CUSTOM
        END
        MENUITEM "", IDM_TOGGLE_WARP_MODE,  CHECKED
        MENUITEM SEPARATOR
        MENUITEM "", IDM_TOGGLE_ALWAYSONTOP
        MENUITEM "", IDM_TOGGLE_VIDEOCACHE, CHECKED
        MENUITEM "", IDM_TOGGLE_DOUBLESIZE, CHECKED
        MENUITEM "", IDM_TOGGLE_DOUBLESCAN, CHECKED
        MENUITEM "", IDM_TOGGLE_FASTPAL,    CHECKED
        MENUITEM "", IDM_TOGGLE_SCALE2X,    CHECKED
        POPUP N_("VDC settin&gs")
        BEGIN
            MENUITEM "", IDM_TOGGLE_VDC_DOUBLESIZE
            MENUITEM "", IDM_TOGGLE_VDC_DOUBLESCAN
            MENUITEM SEPARATOR
            MENUITEM "", IDM_TOGGLE_VDC64KB
            MENUITEM SEPARATOR
            POPUP N_("VDC revision")
            BEGIN
                MENUITEM N_("Rev 0"), IDM_VDC_REV_0
                MENUITEM N_("Rev 1"), IDM_VDC_REV_1
                MENUITEM N_("Rev 2"), IDM_VDC_REV_2
            END
        END
        MENUITEM SEPARATOR
        MENUITEM "", IDM_SWAP_JOYSTICK
        MENUITEM "", IDM_SWAP_EXTRA_JOYSTICK
        MENUITEM "", IDM_ALLOW_JOY_OPPOSITE_TOGGLE
        MENUITEM "", IDM_JOYKEYS_TOGGLE
        MENUITEM SEPARATOR
        MENUITEM "", IDM_TOGGLE_SOUND,                CHECKED
        MENUITEM SEPARATOR
        MENUITEM "", IDM_TOGGLE_DRIVE_TRUE_EMULATION, CHECKED
        MENUITEM "", IDM_TOGGLE_AUTOSTART_HANDLE_TDE
        MENUITEM "", IDM_TOGGLE_VIRTUAL_DEVICES
        MENUITEM SEPARATOR
        POPUP N_("Vide&o standard")
        BEGIN
            MENUITEM N_("&PAL-G"),  IDM_SYNC_FACTOR_PAL
            MENUITEM N_("&NTSC-M"), IDM_SYNC_FACTOR_NTSC
        END
        MENUITEM SEPARATOR
        MENUITEM "", IDM_TOGGLE_EMUID
        MENUITEM "", IDM_IEEE488
        MENUITEM "", IDM_MOUSE
    END
    POPUP N_("S&ettings")
    BEGIN
        MENUITEM "", IDM_AUTOSTART_SETTINGS
        MENUITEM "", IDM_VIDEO_SETTINGS
        MENUITEM "", IDM_DEVICEMANAGER
        MENUITEM "", IDM_DRIVE_SETTINGS
        MENUITEM "", IDM_DATASETTE_SETTINGS
        MENUITEM "", IDM_VICII_SETTINGS
        MENUITEM "", IDM_JOY_SETTINGS
        MENUITEM "", IDM_EXTRA_JOY_SETTINGS
        MENUITEM "", IDM_KEYBOARD_SETTINGS
        MENUITEM "", IDM_MOUSE_SETTINGS
        MENUITEM "", IDM_LIGHTPEN_SETTINGS
        MENUITEM "", IDM_SOUND_SETTINGS
        MENUITEM "", IDM_SID_SETTINGS
        MENUITEM "", IDM_ROM_SETTINGS
        MENUITEM "", IDM_RAM_SETTINGS
        MENUITEM "", IDM_C128_SETTINGS
        MENUITEM "", IDM_RS232_SETTINGS
        POPUP N_("&Cartridge Settings")
        BEGIN
            MENUITEM "", IDM_REU_SETTINGS
            MENUITEM "", IDM_GEORAM_SETTINGS
            MENUITEM "", IDM_RAMCART_SETTINGS
            MENUITEM "", IDM_MIDI_SETTINGS
            MENUITEM "", IDM_MMC64_SETTINGS
            MENUITEM "", IDM_DIGIMAX_SETTINGS
            MENUITEM "", IDM_IDE64_SETTINGS
#ifdef HAVE_TFE
            MENUITEM "", IDM_TFE_SETTINGS
#endif
            MENUITEM "", IDM_ACIA_SETTINGS
            MENUITEM "", IDM_RS232USER_SETTINGS
            MENUITEM "", IDM_EASYFLASH_SETTINGS
            MENUITEM "", IDM_SFX_SE_SETTINGS
            MENUITEM "", IDM_TOGGLE_SFX_SS
        END
        MENUITEM SEPARATOR
        MENUITEM "", IDM_SETTINGS_SAVE_FILE
        MENUITEM "", IDM_SETTINGS_LOAD_FILE
        MENUITEM "", IDM_SETTINGS_SAVE
        MENUITEM "", IDM_SETTINGS_LOAD
        MENUITEM "", IDM_SETTINGS_DEFAULT
        MENUITEM SEPARATOR
        MENUITEM "", IDM_TOGGLE_SAVE_SETTINGS_ON_EXIT
        MENUITEM "", IDM_TOGGLE_CONFIRM_ON_EXIT
    END
    POPUP N_("&Language")
    BEGIN
        MENUITEM "", IDM_LANG_EN
        MENUITEM "", IDM_LANG_DA
        MENUITEM "", IDM_LANG_DE
        MENUITEM "", IDM_LANG_FR
        MENUITEM "", IDM_LANG_HU
        MENUITEM "", IDM_LANG_IT
        MENUITEM "", IDM_LANG_NL
        MENUITEM "", IDM_LANG_PL
        MENUITEM "", IDM_LANG_SV
        MENUITEM "", IDM_LANG_TR
    END
    POPUP N_("&Help")
    BEGIN
        MENUITEM "", IDM_HELP
        MENUITEM SEPARATOR
        MENUITEM "", IDM_ABOUT
        MENUITEM SEPARATOR
        MENUITEM "", IDM_CMDLINE
        MENUITEM SEPARATOR
        MENUITEM "", IDM_CONTRIBUTORS
        MENUITEM "", IDM_LICENSE
        MENUITEM "", IDM_WARRANTY
    END
END



IDD_C128ROM_SETTINGS_DIALOG DIALOG DISCARDABLE 0, 0, 240, 310
BEGIN
    LTEXT      "", IDC_KERNAL_INT,
               9, 8, 40, 8
    EDITTEXT   IDC_C128ROM_KERNALINT_FILE,
               55, 7, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_C128ROM_KERNALINT_BROWSE,
               185, 7, 50, 14, 0

    LTEXT      "", IDC_KERNAL_DE,
               9, 28, 40, 8
    EDITTEXT   IDC_C128ROM_KERNALDE_FILE,
               55, 27, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_C128ROM_KERNALDE_BROWSE,
               185, 27, 50, 14, 0

    LTEXT      "", IDC_KERNAL_FI,
               9, 48, 40, 8
    EDITTEXT   IDC_C128ROM_KERNALFI_FILE,
               55, 47, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_C128ROM_KERNALFI_BROWSE,
               185, 47, 50, 14, 0

    LTEXT      "", IDC_KERNAL_FR,
               9, 68, 40, 8
    EDITTEXT   IDC_C128ROM_KERNALFR_FILE,
               55, 67, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_C128ROM_KERNALFR_BROWSE,
               185, 67, 50, 14, 0

    LTEXT      "", IDC_KERNAL_IT,
               9, 88, 40, 8
    EDITTEXT   IDC_C128ROM_KERNALIT_FILE,
               55, 87, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_C128ROM_KERNALIT_BROWSE,
               185, 87, 50, 14, 0

    LTEXT      "", IDC_KERNAL_NO,
               9, 108, 40, 8
    EDITTEXT   IDC_C128ROM_KERNALNO_FILE,
               55, 107, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_C128ROM_KERNALNO_BROWSE,
               185, 107, 50, 14, 0

    LTEXT      "", IDC_KERNAL_SE,
               9, 128, 40, 8
    EDITTEXT   IDC_C128ROM_KERNALSE_FILE,
               55, 127, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_C128ROM_KERNALSE_BROWSE,
               185, 127, 50, 14, 0

    LTEXT      "", IDC_BASIC_LO,
               9, 148, 40, 8
    EDITTEXT   IDC_C128ROM_BASICLO_FILE,
               55, 147, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_C128ROM_BASICLO_BROWSE,
               185, 147, 50, 14, 0

    LTEXT      "", IDC_BASIC_HI,
               9, 168, 40, 8
    EDITTEXT   IDC_C128ROM_BASICHI_FILE,
               55, 167, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_C128ROM_BASICHI_BROWSE,
               185, 167, 50, 14, 0

    LTEXT      "", IDC_CHAR_INT,
               9, 188, 40, 8
    EDITTEXT   IDC_C128ROM_CHARGENINT_FILE,
               55, 187, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_C128ROM_CHARGENINT_BROWSE,
               185, 187, 50, 14, 0

    LTEXT      "", IDC_CHAR_DE,
               9, 208, 40, 8
    EDITTEXT   IDC_C128ROM_CHARGENDE_FILE,
               55, 207, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_C128ROM_CHARGENDE_BROWSE,
               185, 207, 50, 14, 0

    LTEXT      "", IDC_CHAR_FR,
               9, 228, 40, 8
    EDITTEXT   IDC_C128ROM_CHARGENFR_FILE,
               55, 227, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_C128ROM_CHARGENFR_BROWSE,
               185, 227, 50, 14, 0

    LTEXT      "", IDC_CHAR_SE,
               9, 248, 40, 8
    EDITTEXT   IDC_C128ROM_CHARGENSE_FILE,
               55, 247, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_C128ROM_CHARGENSE_BROWSE,
               185, 247, 50, 14, 0

    LTEXT      "", IDC_KERNAL_C64,
               9, 268, 40, 8
    EDITTEXT   IDC_C128ROM_KERNAL64_FILE,
               55, 267, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_C128ROM_KERNAL64_BROWSE,
               185, 267, 50, 14, 0

    LTEXT      "", IDC_BASIC_C64,
               9, 288, 40, 8
    EDITTEXT   IDC_C128ROM_BASIC64_FILE,
               55, 287, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_C128ROM_BASIC64_BROWSE,
               185, 287, 50, 14, 0
END



IDD_C128DRIVEROM_SETTINGS_DIALOG DIALOG DISCARDABLE 0, 0, 240, 230
BEGIN
    LTEXT      N_("1541"), IDC_1541,
               9, 8, 40, 8
    EDITTEXT   IDC_DRIVEROM_1541_FILE,
               55, 7, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_DRIVEROM_1541_BROWSE,
               185, 7, 50, 14, 0

    LTEXT      N_("1541-II"), IDC_1541_II,
               9, 28, 40, 8
    EDITTEXT   IDC_DRIVEROM_1541II_FILE,
               55, 27, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_DRIVEROM_1541II_BROWSE,
               185, 27, 50, 14, 0

    LTEXT      N_("1570"), IDC_1570,
               9, 48, 40, 8
    EDITTEXT   IDC_DRIVEROM_1570_FILE,
               55, 47, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_DRIVEROM_1570_BROWSE,
               185, 47, 50, 14, 0

    LTEXT      N_("1571"), IDC_1571,
               9, 68, 40, 8
    EDITTEXT   IDC_DRIVEROM_1571_FILE,
               55, 67, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_DRIVEROM_1571_BROWSE,
               185, 67, 50, 14, 0

    LTEXT      N_("1571CR"), IDC_1571CR,
               9, 88, 40, 8
    EDITTEXT   IDC_DRIVEROM_1571CR_FILE,
               55, 87, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_DRIVEROM_1571CR_BROWSE,
               185, 87, 50, 14, 0

    LTEXT      N_("1581"), IDC_1581,
               9, 108, 40, 8
    EDITTEXT   IDC_DRIVEROM_1581_FILE,
               55, 107, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_DRIVEROM_1581_BROWSE,
               185, 107, 50, 14, 0

    LTEXT      N_("2031"), IDC_2031,
               9, 128, 40, 8
    EDITTEXT   IDC_DRIVEROM_2031_FILE,
               55, 127, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_DRIVEROM_2031_BROWSE,
               185, 127, 50, 14, 0

    LTEXT      N_("2040"), IDC_2040,
               9, 148, 40, 8
    EDITTEXT   IDC_DRIVEROM_2040_FILE,
               55, 147, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_DRIVEROM_2040_BROWSE,
               185, 147, 50, 14, 0

    LTEXT      N_("3040"), IDC_3040,
               9, 168, 40, 8
    EDITTEXT   IDC_DRIVEROM_3040_FILE,
               55, 167, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_DRIVEROM_3040_BROWSE,
               185, 167, 50, 14, 0

    LTEXT      N_("4040"), IDC_4040,
               9, 188, 40, 8
    EDITTEXT   IDC_DRIVEROM_4040_FILE,
               55, 187, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_DRIVEROM_4040_BROWSE,
               185, 187, 50, 14, 0

    LTEXT      N_("1001"), IDC_1001,
               9, 208, 40, 8
    EDITTEXT   IDC_DRIVEROM_1001_FILE,
               55, 207, 125, 12, WS_TABSTOP | ES_AUTOHSCROLL
    PUSHBUTTON "", IDC_DRIVEROM_1001_BROWSE,
               185, 207, 50, 14, 0
END



IDD_C128ROM_RESOURCE_DIALOG DIALOG DISCARDABLE 0, 0, 160, 265
BEGIN
    GROUPBOX      "", IDC_COMPUTER_RESOURCES,
                  4, 3, 151, 235
    AUTOCHECKBOX  "", IDC_C128ROM_KERNALINT_RESOURCE,
                  11, 13, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  "", IDC_C128ROM_KERNALDE_RESOURCE,
                  11, 28, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  "", IDC_C128ROM_KERNALFI_RESOURCE,
                  11, 43, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  "", IDC_C128ROM_KERNALFR_RESOURCE,
                  11, 58, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  "", IDC_C128ROM_KERNALIT_RESOURCE,
                  11, 73, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  "", IDC_C128ROM_KERNALNO_RESOURCE,
                  11, 88, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  "", IDC_C128ROM_KERNALSE_RESOURCE,
                  11, 103, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  "", IDC_C128ROM_BASICLO_RESOURCE,
                  11, 118, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  "", IDC_C128ROM_BASICHI_RESOURCE,
                  11, 133, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  "", IDC_C128ROM_CHARGENINT_RESOURCE,
                  11, 148, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  "", IDC_C128ROM_CHARGENDE_RESOURCE,
                  11, 163, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  "", IDC_C128ROM_CHARGENFR_RESOURCE,
                  11, 178, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  "", IDC_C128ROM_CHARGENSE_RESOURCE,
                  11, 193, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  "", IDC_C128ROM_KERNAL64_RESOURCE,
                  11, 208, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  "",IDC_C128ROM_BASIC64_RESOURCE,
                  11, 223, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP

    DEFPUSHBUTTON "", IDOK,
                  20, 245, 50, 14, WS_TABSTOP
    PUSHBUTTON    "", IDCANCEL,
                  80, 245, 50, 14, WS_TABSTOP
END



IDD_C128ROMDRIVE_RESOURCE_DIALOG DIALOG DISCARDABLE 0, 0, 160, 205
BEGIN
    GROUPBOX      "", IDC_DRIVE_RESOURCES,
                  4, 3, 151, 175
    AUTOCHECKBOX  N_("1541"), IDC_DRIVEROM_1541_RESOURCE,
                  11, 13, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  N_("1541-II"), IDC_DRIVEROM_1541II_RESOURCE,
                  11, 28, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  N_("1570"), IDC_DRIVEROM_1570_RESOURCE,
                  11, 43, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  N_("1571"), IDC_DRIVEROM_1571_RESOURCE,
                  11, 58, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  N_("1571CR"), IDC_DRIVEROM_1571CR_RESOURCE,
                  11, 73, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  N_("1581"), IDC_DRIVEROM_1581_RESOURCE,
                  11, 88, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  N_("2031"), IDC_DRIVEROM_2031_RESOURCE,
                  11, 103, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  N_("2040"), IDC_DRIVEROM_2040_RESOURCE,
                  11, 118, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  N_("3040"), IDC_DRIVEROM_3040_RESOURCE,
                  11, 133, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  N_("4040"), IDC_DRIVEROM_4040_RESOURCE,
                  11, 148, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP
    AUTOCHECKBOX  N_("1001"), IDC_DRIVEROM_1001_RESOURCE,
                  11, 163, 95, 10, BS_AUTOCHECKBOX | WS_GROUP | WS_TABSTOP

    DEFPUSHBUTTON "", IDOK,
                  20, 185, 50, 14, WS_TABSTOP
    PUSHBUTTON    "", IDCANCEL,
                  80, 185, 50, 14, WS_TABSTOP
END



IDD_C128_MACHINE_SETTINGS_DIALOG DIALOG DISCARDABLE 0, 0, 220, 110
BEGIN
    LTEXT    "", IDC_MACHINE_TYPE,
             10, 9, 50, 8
    COMBOBOX IDC_C128_MACHINE_TYPE,
             60, 7, 60, 50, CBS_DROPDOWNLIST | WS_VSCROLL | WS_TABSTOP
END



IDD_C128_FUNCTIONROM_SETTINGS_DIALOG DIALOG DISCARDABLE 0, 0, 240, 110
BEGIN
    GROUPBOX     "", IDC_INTERNAL_FUNCTION_ROM,
                 5, 5, 225, 45
    AUTOCHECKBOX "", IDC_C128_FUNCTIONROM_INTERNAL,
                 15, 15, 120, 10, BS_AUTOCHECKBOX | WS_TABSTOP
    LTEXT        "", IDC_FILE_NAME_1,
                 11, 33, 50, 8
    EDITTEXT     IDC_C128_FUNCTIONROM_INTERNAL_NAME,
                 50, 30, 115, 12, WS_TABSTOP
    PUSHBUTTON   "", IDC_C128_FUNCTIONROM_INTERNAL_BROWSE,
                 175, 30, 50, 14, 0
    GROUPBOX     "", IDC_EXTERNAL_FUNCTION_ROM,
                 5, 55, 225, 45
    AUTOCHECKBOX "", IDC_C128_FUNCTIONROM_EXTERNAL,
                 15, 65, 120, 10, BS_AUTOCHECKBOX | WS_TABSTOP
    LTEXT        "", IDC_FILE_NAME_2,
                 11, 83, 50, 8
    EDITTEXT     IDC_C128_FUNCTIONROM_EXTERNAL_NAME,
                 50, 80, 115, 12, WS_TABSTOP
    PUSHBUTTON   "", IDC_C128_FUNCTIONROM_EXTERNAL_BROWSE,
                 175, 80, 50, 14, 0
END



IDD_C128_RAM_BANKS_DIALOG DIALOG DISCARDABLE 0, 0, 240, 110
BEGIN
    AUTOCHECKBOX "", IDC_C128_FULL_BANKS,
                 15, 15, 120, 10, BS_AUTOCHECKBOX | WS_TABSTOP
END



IDD_C128KBD_MAPPING_SETTINGS_DIALOG DIALOG DISCARDABLE 0, 0, 240, 120
BEGIN
    AUTORADIOBUTTON "",IDC_C128KBD_MAPPING_SELECT_SYM,
                    10, 10, 54, 10, BS_AUTORADIOBUTTON | WS_GROUP | WS_TABSTOP
    AUTORADIOBUTTON "", IDC_C128KBD_MAPPING_SELECT_POS,
                    10, 30, 54, 10, BS_AUTORADIOBUTTON

    EDITTEXT        IDC_C128KBD_MAPPING_SYM,
                    65, 9, 110, 12, WS_TABSTOP
    PUSHBUTTON      "", IDC_C128KBD_MAPPING_SYM_BROWSE,
                    185, 9, 50, 14, 0
    EDITTEXT        IDC_C128KBD_MAPPING_POS,
                    65, 29, 110, 12, WS_TABSTOP
    PUSHBUTTON      "", IDC_C128KBD_MAPPING_POS_BROWSE,
                    185, 29, 50, 14, 0

    PUSHBUTTON      "", IDC_C128KBD_MAPPING_DUMP,
                    10, 54, 60, 14, 0
    PUSHBUTTON      "", IDC_KBD_SHORTCUT_DUMP,
                    80, 54, 60, 14, 0

    DEFPUSHBUTTON   "", IDOK,
                    20, 100, 50, 14, WS_TABSTOP
    PUSHBUTTON      "", IDCANCEL,
                    80, 100, 50, 14, WS_TABSTOP
END



STRINGTABLE
BEGIN
  IDS_SELECT_INT_FUNCTION_ROM   N_("Select internal function ROM image")
  IDS_SELECT_EXT_FUNCTION_ROM   N_("Select external function ROM image")
  IDS_MACHINE_TYPE              N_("Machine type")
  IDS_FUNCTION_ROM              N_("Function ROM")
  IDS_RAM_BANKS                 N_("RAM banks")
  IDS_C128_SETTINGS             N_("C128 settings")
  IDS_KERNAL_INT                N_("Kernal Int.")
  IDS_KERNAL_DE                 N_("Kernal DE")
  IDS_KERNAL_FI                 N_("Kernal FI")
  IDS_KERNAL_FR                 N_("Kernal FR")
  IDS_KERNAL_IT                 N_("Kernal IT")
  IDS_KERNAL_NO                 N_("Kernal NO")
  IDS_KERNAL_SE                 N_("Kernal SE")
  IDS_BASIC_LO                  N_("Basic LO")
  IDS_BASIC_HI                  N_("Basic HI")
  IDS_CHAR_INT                  N_("Char. Int.")
  IDS_CHAR_DE                   N_("Char. DE")
  IDS_CHAR_FR                   N_("Char. FR")
  IDS_CHAR_SE                   N_("Char. SE")
  IDS_KERNAL_C64                N_("Kernal C64")
  IDS_BASIC_C64                 N_("Basic C64")
  IDS_INTERNATIONAL_KERNAL      N_("International Kernal")
  IDS_GERMAN_KERNAL             N_("German Kernal")
  IDS_FINNISH_KERNAL            N_("Finnish Kernal")
  IDS_FRENCH_KERNAL             N_("French Kernal")
  IDS_ITALIAN_KERNAL            N_("Italian Kernal")
  IDS_NORWEGIAN_KERNAL          N_("Norwegian Kernal")
  IDS_SWEDISH_KERNAL            N_("Swedish Kernal")
  IDS_INTERNATIONAL_CHARACTER   N_("International Character")
  IDS_GERMAN_CHARACTER          N_("German Character")
  IDS_FRENCH_CHARACTER          N_("French Character")
  IDS_SWEDISH_CHARACTER         N_("Swedish Character")
  IDS_C64_MODE_KERNAL           N_("C64 mode Kernal")
  IDS_C64_MODE_BASIC            N_("C64 mode Basic")
  IDS_INTERNATIONAL             N_("International")
  IDS_FINNISH                   N_("Finnish")
  IDS_FRENCH                    N_("French")
  IDS_GERMAN                    N_("German")
  IDS_ITALIAN                   N_("Italian")
  IDS_NORWEGIAN                 N_("Norwegian")
  IDS_SWEDISH                   N_("Swedish")
  IDS_INT_FUNCTION_ROM          N_("Internal Function ROM")
  IDS_ENABLE_INT_FUNCTION_ROM   N_("Enable internal Function ROM")
  IDS_FILE_NAME                 N_("File name")
  IDS_EXT_FUNCTION_ROM          N_("External Function ROM")
  IDS_ENABLE_EXT_FUNCTION_ROM   N_("Enable external Function ROM")
  IDS_C128_FULL_BANKS           N_("Enable RAM banks 2 and 3")
  IDS_MP_VDC_SETTINGS           N_("VDC settin&gs")
  IDS_MP_VDC_REVISION           N_("VDC revision")
  IDS_MI_TOGGLE_VDC64KB         N_("64KB video &memory")
  IDS_MI_IEEE488                N_("IEEE&488 Interface emulation")
  IDS_MI_C128_SETTINGS          N_("C&128 settings...")
END



STRINGTABLE
LANGUAGE LANG_DANISH, SUBLANG_NEUTRAL
BEGIN
  IDS_SELECT_INT_FUNCTION_ROM   "Vlg image for intern funktions-ROM"
  IDS_SELECT_EXT_FUNCTION_ROM   "Vlg image for extern funktions-ROM"
  IDS_MACHINE_TYPE              "Maskintype"
  IDS_FUNCTION_ROM              "Funktions-ROM"
  IDS_RAM_BANKS                 "RAM banks"
  IDS_C128_SETTINGS             "C128-indstillinger"
  IDS_KERNAL_INT                "Kernal Int."
  IDS_KERNAL_DE                 "Kernal DE"
  IDS_KERNAL_FI                 "Kernal FI"
  IDS_KERNAL_FR                 "Kernal FR"
  IDS_KERNAL_IT                 "Kernal IT"
  IDS_KERNAL_NO                 "Kernal NO"
  IDS_KERNAL_SE                 "Kernal SE"
  IDS_BASIC_LO                  "Basic LAV"
  IDS_BASIC_HI                  "Basic HJ"
  IDS_CHAR_INT                  "Tegn Int."
  IDS_CHAR_DE                   "Tegn DE"
  IDS_CHAR_FR                   "Tegn FR"
  IDS_CHAR_SE                   "Tegn SE"
  IDS_KERNAL_C64                "Kernal C64"
  IDS_BASIC_C64                 "Basic C64"
  IDS_INTERNATIONAL_KERNAL      "International Kernal"
  IDS_GERMAN_KERNAL             "Tysk Kernal"
  IDS_FINNISH_KERNAL            "Finsk Kernal"
  IDS_FRENCH_KERNAL             "Fransk Kernal"
  IDS_ITALIAN_KERNAL            "Italiensk Kernal"
  IDS_NORWEGIAN_KERNAL          "Norsk Kernal"
  IDS_SWEDISH_KERNAL            "Svensk Kernal"
  IDS_INTERNATIONAL_CHARACTER   "International tegngenerator"
  IDS_GERMAN_CHARACTER          "Tysk tegngenerator"
  IDS_FRENCH_CHARACTER          "Fransk tegngenerator"
  IDS_SWEDISH_CHARACTER         "Svensk tegngenerator"
  IDS_C64_MODE_KERNAL           "Kerne for C64-tilstand"
  IDS_C64_MODE_BASIC            "BASIC for C64-tilstand"
  IDS_INTERNATIONAL             "International"
  IDS_FINNISH                   "Finnish"
  IDS_FRENCH                    "French"
  IDS_GERMAN                    "German"
  IDS_ITALIAN                   "Italian"
  IDS_NORWEGIAN                 "Norwegian"
  IDS_SWEDISH                   "Swedish"
  IDS_INT_FUNCTION_ROM          "Intern funktions-ROM"
  IDS_ENABLE_INT_FUNCTION_ROM   "Aktivr intern funktions-ROM"
  IDS_FILE_NAME                 "Filnavn"
  IDS_EXT_FUNCTION_ROM          "Extern funktions-ROM"
  IDS_ENABLE_EXT_FUNCTION_ROM   "Aktivr extern funktions-ROM"
  IDS_C128_FULL_BANKS           "Enable RAM banks 2 and 3"
  IDS_MP_VDC_SETTINGS           "&VDC-indstillinger"
  IDS_MP_VDC_REVISION           "VDC revision"
  IDS_MI_TOGGLE_VDC64KB         "64KB grafikhuko&mmelse"
  IDS_MI_IEEE488                "Emulering af IEEE&488-interface"
  IDS_MI_C128_SETTINGS          "C&128-indstillinger..."
END



STRINGTABLE
LANGUAGE LANG_GERMAN, SUBLANG_NEUTRAL
BEGIN
  IDS_SELECT_INT_FUNCTION_ROM   "Internes Funktions ROM Image Datei auswhlen"
  IDS_SELECT_EXT_FUNCTION_ROM   "Externes Funktions ROM Image Datei auswhlen"
  IDS_MACHINE_TYPE              "Maschinen Typ"
  IDS_FUNCTION_ROM              "Function ROM"
  IDS_RAM_BANKS                 "RAM Bnke"
  IDS_C128_SETTINGS             "C128 Einstellungen"
  IDS_KERNAL_INT                "Kernal Int."
  IDS_KERNAL_DE                 "Kernal DE"
  IDS_KERNAL_FI                 "Kernal FI"
  IDS_KERNAL_FR                 "Kernal FR"
  IDS_KERNAL_IT                 "Kernal IT"
  IDS_KERNAL_NO                 "Kernal NO"
  IDS_KERNAL_SE                 "Kernal SE"
  IDS_BASIC_LO                  "Basic LO"
  IDS_BASIC_HI                  "Basic HI"
  IDS_CHAR_INT                  "Char. Int."
  IDS_CHAR_DE                   "Char. DE"
  IDS_CHAR_FR                   "Char. FR"
  IDS_CHAR_SE                   "Char. SE"
  IDS_KERNAL_C64                "Kernal C64"
  IDS_BASIC_C64                 "Basic C64"
  IDS_INTERNATIONAL_KERNAL      "International Kernal"
  IDS_GERMAN_KERNAL             "Deutscher Kernal"
  IDS_FINNISH_KERNAL            "Finnischer Kernal"
  IDS_FRENCH_KERNAL             "Franzsischer Kernal"
  IDS_ITALIAN_KERNAL            "Italienischer Kernal"
  IDS_NORWEGIAN_KERNAL          "Norwegischer Kernal"
  IDS_SWEDISH_KERNAL            "Schwedischer Kernal"
  IDS_INTERNATIONAL_CHARACTER   "Internationaler Zeichensatz"
  IDS_GERMAN_CHARACTER          "Deutscher Zeichensatz"
  IDS_FRENCH_CHARACTER          "Franzsischer Zeichensatz"
  IDS_SWEDISH_CHARACTER         "Schwedischer Zeichensatz"
  IDS_C64_MODE_KERNAL           "C64 modus Kernal"
  IDS_C64_MODE_BASIC            "C64 modus Basic"
  IDS_INTERNATIONAL             "International"
  IDS_FINNISH                   "Finnish"
  IDS_FRENCH                    "French"
  IDS_GERMAN                    "German"
  IDS_ITALIAN                   "Italian"
  IDS_NORWEGIAN                 "Norwegian"
  IDS_SWEDISH                   "Swedish"
  IDS_INT_FUNCTION_ROM          "Internes Funktions ROM"
  IDS_ENABLE_INT_FUNCTION_ROM   "Internes Funktions ROM aktivieren"
  IDS_FILE_NAME                 "Dateiname"
  IDS_EXT_FUNCTION_ROM          "Externes Funktions ROM"
  IDS_ENABLE_EXT_FUNCTION_ROM   "Externes Funktions ROM aktivieren"
  IDS_C128_FULL_BANKS           "RAM Bnke 2 und 3 aktivieren"
  IDS_MP_VDC_SETTINGS           "VDC Einstellun&gen"
  IDS_MP_VDC_REVISION           "VDC Revision"
  IDS_MI_TOGGLE_VDC64KB         "64KB Bildschirm Speicher"
  IDS_MI_IEEE488                "IEEE&488 Schnittstellen-Emulation"
  IDS_MI_C128_SETTINGS          "C&128 Einstellungen..."
END



STRINGTABLE
LANGUAGE LANG_FRENCH, SUBLANG_NEUTRAL
BEGIN
  IDS_SELECT_INT_FUNCTION_ROM   "Slectionner l'image ROM Fonction interne"
  IDS_SELECT_EXT_FUNCTION_ROM   "Slectionner l'image ROM Fonction externe"
  IDS_MACHINE_TYPE              "Type de machine"
  IDS_FUNCTION_ROM              "ROM Fonction"
  IDS_RAM_BANKS                 "RAM banks"
  IDS_C128_SETTINGS             "Paramtres C128"
  IDS_KERNAL_INT                "Kernal Int."
  IDS_KERNAL_DE                 "Kernal DE"
  IDS_KERNAL_FI                 "Kernal FI"
  IDS_KERNAL_FR                 "Kernal FR"
  IDS_KERNAL_IT                 "Kernal IT"
  IDS_KERNAL_NO                 "Kernal NO"
  IDS_KERNAL_SE                 "Kernal SE"
  IDS_BASIC_LO                  "Basic LO"
  IDS_BASIC_HI                  "Basic HI"
  IDS_CHAR_INT                  "Char. Int."
  IDS_CHAR_DE                   "Char. DE"
  IDS_CHAR_FR                   "Char. FR"
  IDS_CHAR_SE                   "Char. SE"
  IDS_KERNAL_C64                "Kernal C64"
  IDS_BASIC_C64                 "Basic C64"
  IDS_INTERNATIONAL_KERNAL      "Kernal international"
  IDS_GERMAN_KERNAL             "Kernal allemand"
  IDS_FINNISH_KERNAL            "Kernal finlandais"
  IDS_FRENCH_KERNAL             "Kernal franais"
  IDS_ITALIAN_KERNAL            "Kernal italien"
  IDS_NORWEGIAN_KERNAL          "Kernal norvgien"
  IDS_SWEDISH_KERNAL            "Kernal sudois"
  IDS_INTERNATIONAL_CHARACTER   "Jeu de caractres international"
  IDS_GERMAN_CHARACTER          "Jeu de caractres allemand"
  IDS_FRENCH_CHARACTER          "Jeu de caractres franais"
  IDS_SWEDISH_CHARACTER         "Jeu de caractres sudois"
  IDS_C64_MODE_KERNAL           "Kernel mode C64"
  IDS_C64_MODE_BASIC            "Basic mode C64"
  IDS_INTERNATIONAL             "International"
  IDS_FINNISH                   "Finnish"
  IDS_FRENCH                    "French"
  IDS_GERMAN                    "German"
  IDS_ITALIAN                   "Italian"
  IDS_NORWEGIAN                 "Norwegian"
  IDS_SWEDISH                   "Swedish"
  IDS_INT_FUNCTION_ROM          "Image ROM Fonction interne"
  IDS_ENABLE_INT_FUNCTION_ROM   "Activer l'image ROM Fonction interne"
  IDS_FILE_NAME                 "Nom de fichier"
  IDS_EXT_FUNCTION_ROM          "Image ROM Fonction externe"
  IDS_ENABLE_EXT_FUNCTION_ROM   "Activer l'image ROM Fonction externe"
  IDS_C128_FULL_BANKS           "Enable RAM banks 2 and 3"
  IDS_MP_VDC_SETTINGS           "Para&mtres VDC"
  IDS_MP_VDC_REVISION           "VDC revision"
  IDS_MI_TOGGLE_VDC64KB         "Mmoire d'affichage de 64Ko"
  IDS_MI_IEEE488                "Interface d'mulation &IEEE488"
  IDS_MI_C128_SETTINGS          "Paramtres C&128..."
END



#pragma code_page(28592)
STRINGTABLE
LANGUAGE LANG_HUNGARIAN, SUBLANG_NEUTRAL
BEGIN
  IDS_SELECT_INT_FUNCTION_ROM   "Adja meg a bels Function ROM kpms nevt"
  IDS_SELECT_EXT_FUNCTION_ROM   "Adja meg a kls Function ROM kpms nevt"
  IDS_MACHINE_TYPE              "Gp tpus"
  IDS_FUNCTION_ROM              "Function ROM"
  IDS_RAM_BANKS                 "RAM banks"
  IDS_C128_SETTINGS             "C128 belltsai"
  IDS_KERNAL_INT                "Kernal Int."
  IDS_KERNAL_DE                 "Kernal DE"
  IDS_KERNAL_FI                 "Kernal FI"
  IDS_KERNAL_FR                 "Kernal FR"
  IDS_KERNAL_IT                 "Kernal IT"
  IDS_KERNAL_NO                 "Kernal NO"
  IDS_KERNAL_SE                 "Kernal SE"
  IDS_BASIC_LO                  "Basic LO"
  IDS_BASIC_HI                  "Basic HI"
  IDS_CHAR_INT                  "Char. Int."
  IDS_CHAR_DE                   "Char. DE"
  IDS_CHAR_FR                   "Char. FR"
  IDS_CHAR_SE                   "Char. SE"
  IDS_KERNAL_C64                "Kernal C64"
  IDS_BASIC_C64                 "Basic C64"
  IDS_INTERNATIONAL_KERNAL      "Nemzetkzi kernal"
  IDS_GERMAN_KERNAL             "Nmet kernal"
  IDS_FINNISH_KERNAL            "Finn kernal"
  IDS_FRENCH_KERNAL             "Francia kernal"
  IDS_ITALIAN_KERNAL            "Olasz kernal"
  IDS_NORWEGIAN_KERNAL          "Norvg kernal"
  IDS_SWEDISH_KERNAL            "Svd kernal"
  IDS_INTERNATIONAL_CHARACTER   "Nemzetkzi karakterkszlet"
  IDS_GERMAN_CHARACTER          "Nmet karakterkszlet"
  IDS_FRENCH_CHARACTER          "Francia karakterkszlet"
  IDS_SWEDISH_CHARACTER         "Svd karakterkszlet"
  IDS_C64_MODE_KERNAL           "C64 md kernal"
  IDS_C64_MODE_BASIC            "C64 md Basic"
  IDS_INTERNATIONAL             "International"
  IDS_FINNISH                   "Finnish"
  IDS_FRENCH                    "French"
  IDS_GERMAN                    "German"
  IDS_ITALIAN                   "Italian"
  IDS_NORWEGIAN                 "Norwegian"
  IDS_SWEDISH                   "Swedish"
  IDS_INT_FUNCTION_ROM          "Bels Function ROM"
  IDS_ENABLE_INT_FUNCTION_ROM   "Bels Function ROM engedlyezse"
  IDS_FILE_NAME                 "Fjlnv"
  IDS_EXT_FUNCTION_ROM          "Kls Function ROM"
  IDS_ENABLE_EXT_FUNCTION_ROM   "Kls Function ROM engedlyezse"
  IDS_C128_FULL_BANKS           "Enable RAM banks 2 and 3"
  IDS_MP_VDC_SETTINGS           "VDC belltsai"
  IDS_MP_VDC_REVISION           "VDC revision"
  IDS_MI_TOGGLE_VDC64KB         "64KB kperny &memria"
  IDS_MI_IEEE488                "IEEE&488 interfsz emulci"
  IDS_MI_C128_SETTINGS          "C&128 belltsai..."
END
#pragma code_page(28591)



STRINGTABLE
LANGUAGE LANG_ITALIAN, SUBLANG_NEUTRAL
BEGIN
  IDS_SELECT_INT_FUNCTION_ROM   "Seleziona l'immagine della Function ROM interna"
  IDS_SELECT_EXT_FUNCTION_ROM   "Seleziona l'immagine della Function ROM esterna"
  IDS_MACHINE_TYPE              "Tipo di macchina"
  IDS_FUNCTION_ROM              "Function ROM"
  IDS_RAM_BANKS                 "Banchi di Ram"
  IDS_C128_SETTINGS             "Impostazioni C128"
  IDS_KERNAL_INT                "Kernal Int."
  IDS_KERNAL_DE                 "Kernal DE"
  IDS_KERNAL_FI                 "Kernal FI"
  IDS_KERNAL_FR                 "Kernal FR"
  IDS_KERNAL_IT                 "Kernal IT"
  IDS_KERNAL_NO                 "Kernal NO"
  IDS_KERNAL_SE                 "Kernal SE"
  IDS_BASIC_LO                  "Basic LO"
  IDS_BASIC_HI                  "Basic HI"
  IDS_CHAR_INT                  "Char. Int."
  IDS_CHAR_DE                   "Char. DE"
  IDS_CHAR_FR                   "Char. FR"
  IDS_CHAR_SE                   "Char. SE"
  IDS_KERNAL_C64                "Kernal C64"
  IDS_BASIC_C64                 "Basic C64"
  IDS_INTERNATIONAL_KERNAL      "Kernal internazionale"
  IDS_GERMAN_KERNAL             "Kernal tedesco"
  IDS_FINNISH_KERNAL            "Kernal finlandese"
  IDS_FRENCH_KERNAL             "Kernal francese"
  IDS_ITALIAN_KERNAL            "Kernal italiano"
  IDS_NORWEGIAN_KERNAL          "Kernal norvegese"
  IDS_SWEDISH_KERNAL            "Kernal Svedese"
  IDS_INTERNATIONAL_CHARACTER   "Caratteri internazionali"
  IDS_GERMAN_CHARACTER          "Caratteri tedeschi"
  IDS_FRENCH_CHARACTER          "Caratteri francesi"
  IDS_SWEDISH_CHARACTER         "Caratteri svedesi"
  IDS_C64_MODE_KERNAL           "Kernel in modalit C64"
  IDS_C64_MODE_BASIC            "Basic in modalit C64"
  IDS_INTERNATIONAL             "International"
  IDS_FINNISH                   "Finnish"
  IDS_FRENCH                    "French"
  IDS_GERMAN                    "German"
  IDS_ITALIAN                   "Italian"
  IDS_NORWEGIAN                 "Norwegian"
  IDS_SWEDISH                   "Swedish"
  IDS_INT_FUNCTION_ROM          "Function ROM interna"
  IDS_ENABLE_INT_FUNCTION_ROM   "Attiva la Function ROM interna"
  IDS_FILE_NAME                 "Nome del file"
  IDS_EXT_FUNCTION_ROM          "Function ROM esterna"
  IDS_ENABLE_EXT_FUNCTION_ROM   "Attiva la Function ROM esterna"
  IDS_C128_FULL_BANKS           "Attiva i banchi di RAM 2 e 3"
  IDS_MP_VDC_SETTINGS           "Impostazio&ni del VDC"
  IDS_MP_VDC_REVISION           "Revisione VDC"
  IDS_MI_TOGGLE_VDC64KB         "64KB di &memoria video"
  IDS_MI_IEEE488                "Emulazione dell'interfaccia IEEE&488"
  IDS_MI_C128_SETTINGS          "Impostazioni C&128..."
END



STRINGTABLE
LANGUAGE LANG_DUTCH, SUBLANG_NEUTRAL
BEGIN
  IDS_SELECT_INT_FUNCTION_ROM   "Selecteer intern functie-ROM-bestand"
  IDS_SELECT_EXT_FUNCTION_ROM   "Selecteer extern functie-ROM-bestand"
  IDS_MACHINE_TYPE              "Machinesoort"
  IDS_FUNCTION_ROM              "Functie-ROM"
  IDS_RAM_BANKS                 "RAM banken"
  IDS_C128_SETTINGS             "C128-instellingen"
  IDS_KERNAL_INT                "Kernal Int."
  IDS_KERNAL_DE                 "Kernal DE"
  IDS_KERNAL_FI                 "Kernal FI"
  IDS_KERNAL_FR                 "Kernal FR"
  IDS_KERNAL_IT                 "Kernal IT"
  IDS_KERNAL_NO                 "Kernal NO"
  IDS_KERNAL_SE                 "Kernal SE"
  IDS_BASIC_LO                  "Basic LO"
  IDS_BASIC_HI                  "Basic HI"
  IDS_CHAR_INT                  "Char. Int."
  IDS_CHAR_DE                   "Char. DE"
  IDS_CHAR_FR                   "Char. FR"
  IDS_CHAR_SE                   "Char. SE"
  IDS_KERNAL_C64                "Kernal C64"
  IDS_BASIC_C64                 "Basic C64"
  IDS_INTERNATIONAL_KERNAL      "Internationale Kernal"
  IDS_GERMAN_KERNAL             "Duitse Kernal"
  IDS_FINNISH_KERNAL            "Finse Kernal"
  IDS_FRENCH_KERNAL             "Franse Kernal"
  IDS_ITALIAN_KERNAL            "Italiaanse Kernal"
  IDS_NORWEGIAN_KERNAL          "Noorse Kernal"
  IDS_SWEDISH_KERNAL            "Sweedse Kernal"
  IDS_INTERNATIONAL_CHARACTER   "Internationale Karakters"
  IDS_GERMAN_CHARACTER          "Duitse Karakters"
  IDS_FRENCH_CHARACTER          "Franse Karakters"
  IDS_SWEDISH_CHARACTER         "Sweedse Karakters"
  IDS_C64_MODE_KERNAL           "C64-modus kernal"
  IDS_C64_MODE_BASIC            "C64-modus basic"
  IDS_INTERNATIONAL             "Internationaal"
  IDS_FINNISH                   "Fins"
  IDS_FRENCH                    "Frans"
  IDS_GERMAN                    "Duits"
  IDS_ITALIAN                   "Italiaans"
  IDS_NORWEGIAN                 "Noors"
  IDS_SWEDISH                   "Zweeds"
  IDS_INT_FUNCTION_ROM          "Interne functie-ROM"
  IDS_ENABLE_INT_FUNCTION_ROM   "Activeer intern functie-ROM"
  IDS_FILE_NAME                 "Bestandsnaam"
  IDS_EXT_FUNCTION_ROM          "Externe functie-ROM"
  IDS_ENABLE_EXT_FUNCTION_ROM   "Activeer externe functie-ROM"
  IDS_C128_FULL_BANKS           "Aktiveer RAM bank 2 en 3"
  IDS_MP_VDC_SETTINGS           "VDC-instellin&gen"
  IDS_MP_VDC_REVISION           "VDC-revisie"
  IDS_MI_TOGGLE_VDC64KB         "64KB video&geheugen"
  IDS_MI_IEEE488                "IEEE&488 Interface emulatie"
  IDS_MI_C128_SETTINGS          "C&128-instellingen..."
END



#pragma code_page(28592)
STRINGTABLE
LANGUAGE LANG_POLISH, SUBLANG_NEUTRAL
BEGIN
  IDS_SELECT_INT_FUNCTION_ROM   "Select internal function ROM image"
  IDS_SELECT_EXT_FUNCTION_ROM   "Select external function ROM image"
  IDS_MACHINE_TYPE              "Machine type"
  IDS_FUNCTION_ROM              "Function ROM"
  IDS_RAM_BANKS                 "RAM banks"
  IDS_C128_SETTINGS             "C128 settings"
  IDS_KERNAL_INT                "Kernal Int."
  IDS_KERNAL_DE                 "Kernal DE"
  IDS_KERNAL_FI                 "Kernal FI"
  IDS_KERNAL_FR                 "Kernal FR"
  IDS_KERNAL_IT                 "Kernal IT"
  IDS_KERNAL_NO                 "Kernal NO"
  IDS_KERNAL_SE                 "Kernal SE"
  IDS_BASIC_LO                  "Basic LO"
  IDS_BASIC_HI                  "Basic HI"
  IDS_CHAR_INT                  "Char. Int."
  IDS_CHAR_DE                   "Char. DE"
  IDS_CHAR_FR                   "Char. FR"
  IDS_CHAR_SE                   "Char. SE"
  IDS_KERNAL_C64                "Kernal C64"
  IDS_BASIC_C64                 "Basic C64"
  IDS_INTERNATIONAL_KERNAL      "International Kernal"
  IDS_GERMAN_KERNAL             "German Kernal"
  IDS_FINNISH_KERNAL            "Finnish Kernal"
  IDS_FRENCH_KERNAL             "French Kernal"
  IDS_ITALIAN_KERNAL            "Italian Kernal"
  IDS_NORWEGIAN_KERNAL          "Norwegian Kernal"
  IDS_SWEDISH_KERNAL            "Swedish Kernal"
  IDS_INTERNATIONAL_CHARACTER   "International Character"
  IDS_GERMAN_CHARACTER          "German Character"
  IDS_FRENCH_CHARACTER          "French Character"
  IDS_SWEDISH_CHARACTER         "Swedish Character"
  IDS_C64_MODE_KERNAL           "C64 tryb Kernal"
  IDS_C64_MODE_BASIC            "C64 tryb Basic"
  IDS_INTERNATIONAL             "International"
  IDS_FINNISH                   "Finnish"
  IDS_FRENCH                    "French"
  IDS_GERMAN                    "German"
  IDS_ITALIAN                   "Italian"
  IDS_NORWEGIAN                 "Norwegian"
  IDS_SWEDISH                   "Swedish"
  IDS_INT_FUNCTION_ROM          "wewntrzn funkcj ROM"
  IDS_ENABLE_INT_FUNCTION_ROM   "Wcz wewntrzn funkcj ROM"
  IDS_FILE_NAME                 "Nazwa pliku"
  IDS_EXT_FUNCTION_ROM          "zewntrzn funkcj ROM"
  IDS_ENABLE_EXT_FUNCTION_ROM   "Wcz zewntrzn funkcj ROM"
  IDS_C128_FULL_BANKS           "Enable RAM banks 2 and 3"
  IDS_MP_VDC_SETTINGS           "Us&tawienia VDC"
  IDS_MP_VDC_REVISION           "VDC revision"
  IDS_MI_TOGGLE_VDC64KB         "Wywietl pa&mi 64KB"
  IDS_MI_IEEE488                "Emulacja interfejsu IEEE&488"
  IDS_MI_C128_SETTINGS          "Ustawienia C&128..."
END
#pragma code_page(28591)



STRINGTABLE
LANGUAGE LANG_SWEDISH, SUBLANG_NEUTRAL
BEGIN
  IDS_SELECT_INT_FUNCTION_ROM   "Vlj avbildning fr internt funktions-ROM"
  IDS_SELECT_EXT_FUNCTION_ROM   "Vlj avbildning fr externt funktions-ROM"
  IDS_MACHINE_TYPE              "Maskintyp"
  IDS_FUNCTION_ROM              "Funktions-ROM"
  IDS_RAM_BANKS                 "RAM-bankar"
  IDS_C128_SETTINGS             "C128-instllningar"
  IDS_KERNAL_INT                "Kernal Int."
  IDS_KERNAL_DE                 "Kernal DE"
  IDS_KERNAL_FI                 "Kernal FI"
  IDS_KERNAL_FR                 "Kernal FR"
  IDS_KERNAL_IT                 "Kernal IT"
  IDS_KERNAL_NO                 "Kernal NO"
  IDS_KERNAL_SE                 "Kernal SE"
  IDS_BASIC_LO                  "Basic L"
  IDS_BASIC_HI                  "Basic H"
  IDS_CHAR_INT                  "Teck. Int."
  IDS_CHAR_DE                   "Teck. DE"
  IDS_CHAR_FR                   "Teck. FR"
  IDS_CHAR_SE                   "Teck. SE"
  IDS_KERNAL_C64                "Kernal C64"
  IDS_BASIC_C64                 "Basic C64"
  IDS_INTERNATIONAL_KERNAL      "Internationell Kernal"
  IDS_GERMAN_KERNAL             "Tysk Kernal"
  IDS_FINNISH_KERNAL            "Finsk Kernal"
  IDS_FRENCH_KERNAL             "Fransk Kernal"
  IDS_ITALIAN_KERNAL            "Italiensk Kernal"
  IDS_NORWEGIAN_KERNAL          "Norsk Kernal"
  IDS_SWEDISH_KERNAL            "Svensk Kernal"
  IDS_INTERNATIONAL_CHARACTER   "Internationell teckengenerator"
  IDS_GERMAN_CHARACTER          "Tysk teckengenerator"
  IDS_FRENCH_CHARACTER          "Fransk teckengenerator"
  IDS_SWEDISH_CHARACTER         "Svensk teckengenerator"
  IDS_C64_MODE_KERNAL           "Kernal fr C64-lge"
  IDS_C64_MODE_BASIC            "Basic fr C64-lge"
  IDS_INTERNATIONAL             "International"
  IDS_FINNISH                   "Finnish"
  IDS_FRENCH                    "French"
  IDS_GERMAN                    "German"
  IDS_ITALIAN                   "Italian"
  IDS_NORWEGIAN                 "Norwegian"
  IDS_SWEDISH                   "Swedish"
  IDS_INT_FUNCTION_ROM          "Internt funktions-ROM"
  IDS_ENABLE_INT_FUNCTION_ROM   "Aktivera internt funktions-ROM"
  IDS_FILE_NAME                 "Filnamn"
  IDS_EXT_FUNCTION_ROM          "Externt funktions-ROM"
  IDS_ENABLE_EXT_FUNCTION_ROM   "Aktivera externt funktions-ROM"
  IDS_C128_FULL_BANKS           "Aktivera RAM-bank 2 och 3"
  IDS_MP_VDC_SETTINGS           "&VDC-instllningar"
  IDS_MP_VDC_REVISION           "VDC-revision"
  IDS_MI_TOGGLE_VDC64KB         "64KB grafik&minne"
  IDS_MI_IEEE488                "Emulering av IEEE&488-grnssnitt"
  IDS_MI_C128_SETTINGS          "C&128-instllningar..."
END



#pragma code_page(28599)
STRINGTABLE
LANGUAGE LANG_TURKISH, SUBLANG_NEUTRAL
BEGIN
  IDS_SELECT_INT_FUNCTION_ROM   "Dahili function ROM imajn se"
  IDS_SELECT_EXT_FUNCTION_ROM   "Harici function ROM imajn se"
  IDS_MACHINE_TYPE              "Makine tipi"
  IDS_FUNCTION_ROM              "Function ROM"
  IDS_RAM_BANKS                 "RAM banklar"
  IDS_C128_SETTINGS             "C128 ayarlar"
  IDS_KERNAL_INT                "Uluslararas Kernal"
  IDS_KERNAL_DE                 "Kernal DE"
  IDS_KERNAL_FI                 "Kernal FI"
  IDS_KERNAL_FR                 "Kernal FR"
  IDS_KERNAL_IT                 "Kernal IT"
  IDS_KERNAL_NO                 "Kernal NO"
  IDS_KERNAL_SE                 "Kernal SE"
  IDS_BASIC_LO                  "Basic LO"
  IDS_BASIC_HI                  "Basic HI"
  IDS_CHAR_INT                  "Uluslararas Karakter"
  IDS_CHAR_DE                   "Karakter DE"
  IDS_CHAR_FR                   "Karakter FR"
  IDS_CHAR_SE                   "Karakter SE"
  IDS_KERNAL_C64                "Kernal C64"
  IDS_BASIC_C64                 "Basic C64"
  IDS_INTERNATIONAL_KERNAL      "Uluslararas Kernal"
  IDS_GERMAN_KERNAL             "Alman Kernal"
  IDS_FINNISH_KERNAL            "Finlandiya Kernal"
  IDS_FRENCH_KERNAL             "Fransz Kernal"
  IDS_ITALIAN_KERNAL            "talyan Kernal"
  IDS_NORWEGIAN_KERNAL          "Norve Kernal"
  IDS_SWEDISH_KERNAL            "sve Kernal"
  IDS_INTERNATIONAL_CHARACTER   "Uluslararas Karakter"
  IDS_GERMAN_CHARACTER          "Alman Karakter"
  IDS_FRENCH_CHARACTER          "Fransz Karakter"
  IDS_SWEDISH_CHARACTER         "sve Karakter"
  IDS_C64_MODE_KERNAL           "C64 modu Kernal"
  IDS_C64_MODE_BASIC            "C64 modu Basic"
  IDS_INTERNATIONAL             "International"
  IDS_FINNISH                   "Finnish"
  IDS_FRENCH                    "French"
  IDS_GERMAN                    "German"
  IDS_ITALIAN                   "Italian"
  IDS_NORWEGIAN                 "Norwegian"
  IDS_SWEDISH                   "Swedish"
  IDS_INT_FUNCTION_ROM          "Uluslararas Function ROM"
  IDS_ENABLE_INT_FUNCTION_ROM   "Dahili Function ROM'u aktif et"
  IDS_FILE_NAME                 "Dosya ismi"
  IDS_EXT_FUNCTION_ROM          "Harici Function ROM"
  IDS_ENABLE_EXT_FUNCTION_ROM   "Harici Function ROM'u aktif et"
  IDS_C128_FULL_BANKS           "RAM banklar 2 ve 3' aktif et"
  IDS_MP_VDC_SETTINGS           "VDC ayarlar"
  IDS_MP_VDC_REVISION           "VDC revizyonu"
  IDS_MI_TOGGLE_VDC64KB         "64KB grnt &bellei"
  IDS_MI_IEEE488                "IEEE&488 Arabirimi emlasyonu"
  IDS_MI_C128_SETTINGS          "C&128 ayarlar..."
END
#pragma code_page(28591)
