/*
@version: 0.7
@author: Sudheer K. <scifi1947 at gmail.com>
@license: GNU General Public License
*/

#include "telepathyutility.h"
#include "databaseutility.h"
#include "vicarprofiletypes.h"
#include "connectioninterfacerequeststypes.h"
#include "harmattanaccountutility.h"
#include <QDebug>
#include <QCoreApplication>
#include "dbusutility.h"
#include <QDBusMetaType>
#include <QDBusConnection>
#include <QCryptographicHash> //DEBUG


#include <QDBusInterface>
#include <QDBusObjectPath>
#include <QDBusArgument>

#define AM_SERVICE          "org.freedesktop.Telepathy.AccountManager"
#define AM_OBJ_PATH         "/org/freedesktop/Telepathy/AccountManager"
#define AM_INTERFACE        "org.freedesktop.Telepathy.AccountManager"
#define RING_CONN_SERVICE   "org.freedesktop.Telepathy.Connection.ring.tel.ring"
#define RING_CONN_PATH      "/org/freedesktop/Telepathy/Connection/ring/tel/ring"
#define DBUS_SERVICE        "org.freedesktop.DBus.Properties"
#define DBUS_OBJ_PATH       "/org/freedesktop/DBus/Properties"
#define DBUS_PROPS_IFACE     "org.freedesktop.DBus.Properties"

int main(int argc, char *argv[])
{

    QCoreApplication app(argc,argv);

    qDBusRegisterMetaType<org::freedesktop::Telepathy::SimplePresence>();
    //From Connection Interface Requests
    qDBusRegisterMetaType<org::freedesktop::Telepathy::ChannelDetails>();
    qDBusRegisterMetaType<org::freedesktop::Telepathy::ChannelDetailsList>();
    qDBusRegisterMetaType<org::freedesktop::Telepathy::RequestableChannelClass>();
    qDBusRegisterMetaType<org::freedesktop::Telepathy::RequestableChannelClassList>();
    //From Vicar Profile Types
    //qDBusRegisterMetaType<org::maemo::vicar::Profile>();
    //qDBusRegisterMetaType<org::maemo::vicar::ProfileList>();

    TelepathyUtility tpUtility;
    DatabaseUtility databaseUtility;

    if (argc > 1 && argv[1]){
        QString instruction = QString(argv[1]);
        if (instruction == "INSTALL"){
            //Check if Account already exists                                                            
            if (!tpUtility.accountExists()){
                qDebug() << "VICaR account not found. Creating ..";
                bool result = tpUtility.createAccount();
                if (!result) exit(1);
            }
            else{
                qDebug() << "VICaR account found.";
            }
        }
        else if (instruction == "REMOVE"){
            bool result = tpUtility.deleteAccount();
            if (!result) exit(2);
        }
        else if (instruction == "TESTING"){
            tpUtility.callNumberWithRing(argv[2]);
        }
        else if (instruction == "TPACCOUNTSTATUS"){
            QString status = tpUtility.getAccountStatus();
            qDebug() << "Account Status is "<< status;
        }
#if defined(Q_WS_MAEMO_5)
        else if (instruction == "CREATEDB"){
            bool result = databaseUtility.openDatabase();
            if (!result){
                qDebug() <<"Error creating vicar database. "
                        <<databaseUtility.lastError();
                exit(3);
            }

            qDebug() << "VICaR database opened.";
            qDebug() << "Preparing VICaR tables..";
            result = databaseUtility.prepareTables();
            if (!result){
                qDebug() <<"Error creating tables. "
                        <<databaseUtility.lastError();
                exit(4);
            }

            databaseUtility.closeDatabase();
        }
        else if (instruction == "DROPDB"){
            bool result = databaseUtility.deleteDatabase();
            if (!result){
                qDebug() <<"Error deleting vicar database. "
                        <<databaseUtility.lastError();
                exit(5);
            }
            qDebug() << "VICaR database deleted.";
        }    
#elif defined(Q_WS_MAEMO_6)
        else if (instruction == "--create-account"){
            qDebug() << "Creating account";
            HarmattanAccountUtility accountUtility;
            accountUtility.addAccount();
        }
        else if (instruction == "--delete-account"){
            qDebug() << "Deleting account";
            HarmattanAccountUtility accountUtility;
            accountUtility.removeAccount();
        }
#endif
        else {
            qDebug() << "This command is not recognized";
        }
    }
    else{                        

        qDebug() << QCryptographicHash::hash("VICaR",QCryptographicHash::Md5).toHex();

    }
}
