/*
@version: 0.7
@author: Sudheer K. <scifi1947 at gmail.com>
@license: GNU General Public License
*/

#ifndef LOGUTILITY_H
#define LOGUTILITY_H
#include <QDebug>
#include <QFile>
#include <QIODevice>
#include <QDateTime>
#include <QDir>

class LogUtility : public QObject
{
    Q_OBJECT

private:
    QFile * logFile;

public:
    LogUtility(QObject *parent = 0) :
        QObject(parent){
        QString strPath;

#if defined(Q_WS_MAEMO_5) || defined(Q_WS_MAEMO_6)
        //For maemo fremantle or harmattan use a common path                
        QDir logDir = QDir(QDir().homePath() + "/.vicar");
        if (!logDir.exists()){
            if (QDir().mkpath(logDir.absolutePath())){
                qDebug() << "Vicar: Log directory created successfully";
            }
            else{
                qDebug() << "Vicar: Error creating log directory";
            }
        }
        strPath = logDir.absolutePath() + "/vicar.log";
#else
        strPath = "vicar.log";
#endif
        logFile = new QFile(strPath,this);

        if (!logFile->open(QIODevice::WriteOnly | QIODevice::Text | QIODevice::Truncate)) {
            qDebug() << "Vicar: Error opening logfile for writing at path " << strPath;
        }
    }

    ~LogUtility(){
        if (logFile->isOpen())
            logFile->close();
        qDebug() << "Vicar: In LogUtility object destructor..";
    }

public slots:
    void logMessage(QString strMessage) {

        QString strTimeNow = QDateTime::currentDateTime().toString("dd-MMM-yyyy HH:mm:ss");

        if (logFile->isOpen() && logFile->isWritable()) {
            QTextStream logStream(logFile);
            logStream <<  QString("[%1] - %2").arg(strTimeNow,strMessage) << endl;
            qDebug() << QString("Vicar: [%1] - %2").arg(strTimeNow,strMessage);
        }
        else{
            qDebug() <<  "ERROROPENINGLOGFILE" << QString("Vicar: [%1] - %2").arg(strTimeNow,strMessage);
        }
    }
};

#endif // LOGUTILITY_H
