#include "databaseutility.h"
#include <QCryptographicHash>
#include <QSqlDatabase>
#include <QSqlError>
#include <QSqlQuery>
#include <QFile>
#include <QDir>
#include <QVariant>
#include <QDebug>

DatabaseUtility::DatabaseUtility(QObject *parent) :
    QObject(parent)
{
}

DatabaseUtility::~DatabaseUtility(){
}

bool DatabaseUtility::openDatabase(){
    vicarDB = QSqlDatabase::addDatabase("QSQLITE");
#if defined(Q_WS_MAEMO_5)
    QString path("/home/user/vicar.db.sqlite");
#elif defined(Q_WS_MAEMO_6)
    QString path("/home/user/.local/share/data/QML/OfflineStorage/Databases/");
    path.append(QCryptographicHash::hash("VICaR",QCryptographicHash::Md5).toHex()).append(".sqlite");
#endif
    path = QDir::toNativeSeparators(path);
    qDebug()<< "Opening database at "<<path;
    vicarDB.setDatabaseName(path);
    return vicarDB.open();
}

bool DatabaseUtility::deleteDatabase(){
    closeDatabase();
#if defined(Q_WS_MAEMO_5)
    QString path("/home/user/vicar.db.sqlite");
#elif defined(Q_WS_MAEMO_6)
    QString path("/home/user/.local/share/data/QML/OfflineStorage/Databases/");
    path.append(QCryptographicHash::hash("VICaR",QCryptographicHash::Md5).toHex()).append(".sqlite");
#endif
    path = QDir::toNativeSeparators(path);
    return QFile::remove(path);
}

void DatabaseUtility::closeDatabase(){
    if (vicarDB.isOpen()){
        vicarDB.close();
    }
}

bool DatabaseUtility::tableExists(QString tableName){
    bool exists = false;
    if (vicarDB.isOpen()){
        QStringList tablesList = vicarDB.tables();
        exists = tablesList.contains(tableName,Qt::CaseInsensitive);
    }
    return exists;
}

bool DatabaseUtility::prepareTables(){
    bool result = true;
    if (vicarDB.isOpen()){
        QSqlQuery query;
        QString strQuery = "create table if not exists profiles"
                           "(id integer primary key,"
                           "numberpattern varchar(20),"
                           "gatewaynumber varchar(30),"
                           "dtmfformat varchar(100),"
                           "dtmfprefix varchar(20),"
                           "dtmfsuffix varchar(20)"
                           ")";
        if (!query.exec(strQuery)){
            qDebug() << "Error creating profiles table";
            result = false;
        }

        strQuery = "CREATE TABLE IF NOT EXISTS settings(setting TEXT UNIQUE, value TEXT)";
        if (!query.exec(strQuery)){
            qDebug() << "Error creating settings table";
            result = false;
        }
    }
    return result;
}

QString DatabaseUtility::getSetting(QString setting){
    QString value = "Unknown";
    if (vicarDB.isOpen()){
        QString strQuery = QString("'SELECT value FROM settings WHERE setting='%1'").arg(setting);
        qDebug() << "SQL>"<<strQuery;
        QSqlQuery query(strQuery);
        if (query.next()){
            value = query.value(0).toString();
        }
    }
    return value;
}

bool DatabaseUtility::setSetting(QString setting, QString value){
    bool result = false;
    if (vicarDB.isOpen()){
        QSqlQuery query;
        QString strQuery = QString("INSERT OR REPLACE INTO settings VALUES ('%1','%2')")
                           .arg(setting).arg(value);
        qDebug() << "SQL>"<<strQuery;
        result = query.exec(strQuery);
    }
    return result;
}

bool DatabaseUtility::selectProfile(int id,org::maemo::vicar::Profile* profile){
    bool result = false;
    if (vicarDB.isOpen()){
        QString strQuery = QString("select * from profiles where id = %1").arg(id);
        qDebug() << "SQL>"<<strQuery;
        QSqlQuery query(strQuery);
        if (query.next()){
            profile->profileID = query.value(0).toInt();
            profile->phoneNumberPattern = query.value(1).toString();
            profile->gatewayNumber = query.value(2).toString();
            profile->dtmfFormat = query.value(3).toString();
            profile->dtmfPrefix = query.value(4).toString();
            profile->dtmfSuffix = query.value(5).toString();
            result = true;
        }
    }
    return result;
}

bool DatabaseUtility::getAllProfiles(org::maemo::vicar::ProfileList* profileList){
    bool result = false;
    if (vicarDB.isOpen()){
        QString strQuery = QString("select * from profiles order by id");
        qDebug() << "SQL>"<<strQuery;
        QSqlQuery query(strQuery);
        while (query.next()){
            org::maemo::vicar::Profile profile;
            profile.profileID = query.value(0).toInt();
            profile.phoneNumberPattern = query.value(1).toString();
            profile.gatewayNumber = query.value(2).toString();
            profile.dtmfFormat = query.value(3).toString();
            profile.dtmfPrefix = query.value(4).toString();
            profile.dtmfSuffix = query.value(5).toString();
            profileList->append(profile);
        }
        result = true;
    }
    return result;
}

bool DatabaseUtility::findProfileByNumber(QString number,org::maemo::vicar::Profile* profile){
    bool result = false;
    if (vicarDB.isOpen()){
        QString strQuery = QString("select * from profiles where '%1' like numberpattern||'%' order by length(numberpattern) desc")
                           .arg(number);
        qDebug() << "SQL>"<<strQuery;
        QSqlQuery query(strQuery);
        if (query.next()){
            profile->profileID = query.value(0).toInt();
            profile->phoneNumberPattern = query.value(1).toString();
            profile->gatewayNumber = query.value(2).toString();
            profile->dtmfFormat = query.value(3).toString();
            profile->dtmfPrefix = query.value(4).toString();
            profile->dtmfSuffix = query.value(5).toString();
        }
        result = true;
    }
    return result;
}

bool DatabaseUtility::getDefaultProfile(org::maemo::vicar::Profile *profile){
    bool result = false;
    if (vicarDB.isOpen()){
        QString strQuery = QString("select * from profiles where numberpattern = '%' order by id");
        qDebug() << "SQL>"<<strQuery;
        QSqlQuery query(strQuery);
        if (query.next()){
            profile->profileID = query.value(0).toInt();
            profile->phoneNumberPattern = query.value(1).toString();
            profile->gatewayNumber = query.value(2).toString();
            profile->dtmfFormat = query.value(3).toString();
            profile->dtmfPrefix = query.value(4).toString();
            profile->dtmfSuffix = query.value(5).toString();
            result = true;
        }
    }
    return result;
}

int DatabaseUtility::insertProfile(org::maemo::vicar::Profile profile){
    int newId   = -1;
    bool result = false;    
    if (vicarDB.isOpen()){
        bool continueInsert = true;
        if (!this->tableExists("profiles")){
            continueInsert = this->prepareTables();
        }

        if (continueInsert)
        {
            QSqlQuery query;
            QString strQuery = QString("insert into profiles values(NULL,'%1','%2','%3','%4','%5')")
                               .arg(profile.phoneNumberPattern).arg(profile.gatewayNumber)
                               .arg(profile.dtmfFormat).arg(profile.dtmfPrefix).arg(profile.dtmfSuffix);
            qDebug() << "SQL>"<<strQuery;
            result = query.exec(strQuery);
            if (result){
                newId = query.lastInsertId().toInt();
            }
        }
    }
    return newId;
}

bool DatabaseUtility::updateProfile(org::maemo::vicar::Profile profile){
    bool result = false;
    if (vicarDB.isOpen()){
        QSqlQuery query;
        QString strQuery = QString("update profiles set numberpattern = '%1', "
                                   "gatewaynumber = '%2', dtmfformat = '%3', "
                                   "dtmfprefix = '%4', dtmfsuffix = '%5' where id = %6")
                           .arg(profile.phoneNumberPattern).arg(profile.gatewayNumber)
                           .arg(profile.dtmfFormat).arg(profile.dtmfPrefix)
                           .arg(profile.dtmfSuffix).arg(profile.profileID);
        qDebug() << "SQL>"<<strQuery;
        result = query.exec(strQuery);
    }
    return result;
}

bool DatabaseUtility::deleteProfile(int id){
    bool result = false;
    if (vicarDB.isOpen()){
        QSqlQuery query;
        QString strQuery = QString("delete from profiles where id=%1").arg(id);
        qDebug() << "SQL>"<<strQuery;
        result = query.exec(strQuery);
    }
    return result;
}

QSqlError DatabaseUtility::lastError(){
    return vicarDB.lastError();
}
