/*
@version: 0.7
@author: Sudheer K. <scifi1947 at gmail.com>
@license: GNU General Public License
*/


var dynComponent;
var addRuleSheet;
var action;

function loadRules(){
    rulesModel.clear();
    var rulesArray = DBUtility.getAllRules();
    if (rulesArray && rulesArray.length > 0){
        var i;
        for (i = 0; i < rulesArray.length; i++){
            var ruleObj = rulesArray[i];
            rulesModel.append({"id":ruleObj.id,"numberpattern":ruleObj.numberpattern,"gatewaynumber":ruleObj.gatewaynumber,"dtmfformat":ruleObj.dtmfformat,"dtmfprefix":ruleObj.dtmfprefix,"dtmfsuffix":ruleObj.dtmfsuffix});
        }
        uiLoader.sourceComponent = rulesComponent;
    }
    else{
        uiLoader.sourceComponent = blankComponent;
    }
}

function editRule(ruleID){
    action = "EDIT";
    dynComponent = Qt.createComponent("addrulesheet.qml");
    if (dynComponent.status == Component.Error) {
        console.log("Error loading component:", dynComponent.errorString());
    }

    addRuleSheet = dynComponent.createObject(pageStack.currentPage,{"ruleID": ruleID});
    if (addRuleSheet === null){
        console.log("Error creating object");
    }
    else{
        addRuleSheet.statusChanged.connect(onSheetStatusChanged);
        addRuleSheet.open();
    }
}

function addRule(){
    action = "ADD";
    dynComponent = Qt.createComponent("addrulesheet.qml");
    if (dynComponent.status == Component.Error) {
        console.log("Error loading component:", dynComponent.errorString());
    }

    addRuleSheet = dynComponent.createObject(pageStack.currentPage);
    if (addRuleSheet === null){
        console.log("Error creating object");
    }
    else{
        addRuleSheet.statusChanged.connect(onSheetStatusChanged);
        addRuleSheet.open();
    }
}

function onSheetStatusChanged(){
    if (addRuleSheet.status == DialogStatus.Closed){
        if (action == "EDIT")
            loadRules();
        else
            mainPage.reload();
    }
}
