/*
@version: 0.7
@author: Sudheer K. <scifi1947 at gmail.com>
@license: GNU General Public License
*/

#include <QtGui/QApplication>
#include <QDeclarativeEngine>
#include <QDebug>
#include "qmlapplicationviewer.h"
#include <QDir>

Q_DECL_EXPORT int main(int argc, char *argv[])
{
    QScopedPointer<QApplication> app(createApplication(argc, argv));
    QScopedPointer<QmlApplicationViewer> viewer(QmlApplicationViewer::create());    

#if defined(Q_WS_MAEMO_5) || defined(Q_WS_MAEMO_6)
    //For maemo fremantle or harmattan use a common path
    qDebug() << "Maemo";
    QString strPath = QDir().homePath() + "/.vicar/OfflineStorage";
    viewer->engine()->setOfflineStoragePath(strPath);
#else
    qDebug() << "Not Maemo";
#endif

    qDebug() << viewer->engine()->offlineStoragePath();
    viewer->setOrientation(QmlApplicationViewer::ScreenOrientationAuto);
    viewer->setMainQmlFile(QLatin1String("qml/vicarconfigqml/main.qml"));
    viewer->showExpanded();

    return app->exec();
}
