/*
@version: 0.7
@author: Sudheer K. <scifi1947 at gmail.com>
@license: GNU General Public License
*/

import QtQuick 1.1
import com.nokia.meego 1.0
import "Library/js/DBUtility.js" as DBUtility
import "file:///usr/lib/qt4/imports/com/meego/UIConstants.js" as UIConstants
import "file:///usr/lib/qt4/imports/com/nokia/extras/constants.js" as ExtrasConstants

Sheet{
    id: screen
    acceptButtonText: qsTr("Done")
    rejectButtonText: qsTr("Cancel")

    signal sheetDestroyed()

    property int ruleID:0
    property string numberpattern:""
    property string gatewaynumber:""
    property string dtmfformat:""
    property int numberFormatIndex:0
    property string dtmfprefix: ""
    property string dtmfsuffix: ""

    Component.onCompleted: {
        if (ruleID != 0){
            var ruleObj = DBUtility.getRuleByID(ruleID);
            if (ruleObj !== null){
                numberpattern = ruleObj.numberpattern;
                gatewaynumber = ruleObj.gatewaynumber;
                dtmfformat = ruleObj.dtmfformat;
                var i;
                for (i = 0; i < numberFormatModel.count; i++){
                    if (numberFormatModel.get(i).name === dtmfformat) {
                        numberFormatIndex = i;
                        break;
                    }
                }
                dtmfprefix = ruleObj.dtmfprefix;
                dtmfsuffix = ruleObj.dtmfsuffix;
            }
        }
    }

    Component.onDestruction: {
        console.log("OnDestruction");
        sheetDestroyed();
    }

    ListModel {
        id: numberFormatModel
        ListElement { name: "<Country Code><Area Code><Phone Number>" }
        ListElement { name: "+<Country Code><Area Code><Phone Number>" }
        ListElement { name: "00<Country Code><Area Code><Phone Number>" }
        ListElement { name: "011<Country Code><Area Code><Phone Number>" }
    }

    SelectionDialog {
        id: numberFormatDialog
        titleText: "Number Format"
        width: container.width
        selectedIndex: numberFormatIndex
        model: numberFormatModel
    }

    content: Flickable {
        id: container
        anchors.fill: parent
        anchors.leftMargin: UIConstants.DEFAULT_MARGIN
        anchors.rightMargin: UIConstants.DEFAULT_MARGIN
        anchors.topMargin: UIConstants.DEFAULT_MARGIN
        flickableDirection: Flickable.VerticalFlick
        contentHeight: col.height + UIConstants.DEFAULT_MARGIN

        Column {
            id: col
            width: parent.width
            spacing: 10
            Label {
                text: (ruleID != 0)? qsTr("Edit Rule"):qsTr("Add Rule");
                font.family: UIConstants.FONT_FAMILY_LIGHT
                font.pixelSize: UIConstants.FONT_XLARGE
            }
            Label { text: qsTr("For numbers starting with:") }
            TextField {
                id: numberStartingWith
                anchors { left: parent.left; right: parent.right; }
                inputMethodHints: Qt.ImhDialableCharactersOnly | Qt.ImhNoPredictiveText
                text: screen.numberpattern
            }
            Label { text: qsTr("Route call via:") }
            TextField {
                id: gatewayNumber
                anchors { left: parent.left; right: parent.right; }
                inputMethodHints: Qt.ImhDialableCharactersOnly | Qt.ImhNoPredictiveText
                text: screen.gatewaynumber
            }

            Label { text: qsTr("Dial number in this format (tap to change): ") }

            Rectangle {
                width: parent.width
                height: UIConstants.LIST_ITEM_HEIGHT_SMALL
                color: "transparent"

                BorderImage {
                    anchors.fill: parent
                    visible: mouseArea.pressed
                    source: theme.inverted ?
                                'image://theme/meegotouch-list-fullwidth-inverted-background-pressed-vertical-center':
                                'image://theme/meegotouch-list-fullwidth-background-pressed-vertical-center'
                }

                Text {
                    anchors.verticalCenter: parent.verticalCenter
                    verticalAlignment: Text.AlignVCenter
                    text: numberFormatDialog.selectedIndex >= 0 ? numberFormatDialog.model.get(numberFormatDialog.selectedIndex).name : "None"
                    font.family: UIConstants.FONT_FAMILY_LIGHT
                    font.pixelSize: UIConstants.FONT_SMALL
                }

                MouseArea{
                    id: mouseArea
                    anchors.fill: parent
                    onClicked: {
                        numberFormatDialog.open();
                    }
                }
            }

            Label { text: qsTr("Send this tone before dialing:") }
            TextField {
                id: dtmfPrefix
                anchors { left: parent.left; right: parent.right; }
                inputMethodHints: Qt.ImhDialableCharactersOnly | Qt.ImhNoPredictiveText
            }

            Label { text: qsTr("Send this tone after dialing:") }
            TextField {
                id: dtmfSuffix
                anchors { left: parent.left; right: parent.right; }
                inputMethodHints: Qt.ImhDialableCharactersOnly | Qt.ImhNoPredictiveText
            }
        }
    }
    onAccepted: {
        //id, numberpattern, gatewaynumber, dtmfformat, dtmfprefix, dtmfsuffix
        var ruleObj = new Object();
        ruleObj.id = ruleID;
        ruleObj.numberpattern = numberStartingWith.text;
        ruleObj.gatewaynumber = gatewayNumber.text;
        ruleObj.dtmfformat = numberFormatDialog.model.get(numberFormatDialog.selectedIndex).name;
        ruleObj.dtmfprefix = dtmfPrefix.text;
        ruleObj.dtmfsuffix = dtmfSuffix.text;
        if (ruleID != 0)
            DBUtility.updateRule(ruleID,ruleObj);
        else
            DBUtility.addRule(ruleObj);
        destroy();
    }
    onRejected: destroy();
}
