/*
@version: 0.7
@author: Sudheer K. <scifi1947 at gmail.com>
@license: GNU General Public License
*/

function getDatabase() {
     logMessage("Opening VICaR database..");
     return openDatabaseSync("VICaR", "1.0", "StorageDatabase", 100);
}

function logMessage(strMessage){
    if (typeof(logUtility)!== 'undefined'){
        logUtility.logMessage(strMessage);
    }
    else{        
        console.log(strMessage);
    }
}

// Initialize tables
function initialize() {
    var db = getDatabase();
    db.transaction(
        function(tx) {
            // Create the settings table if it doesn't already exist
            // If the table exists, this is skipped
            tx.executeSql('CREATE TABLE IF NOT EXISTS settings(setting TEXT PRIMARY KEY, value TEXT)');
            tx.executeSql('CREATE TABLE IF NOT EXISTS profiles(id INTEGER PRIMARY KEY, numberpattern TEXT, gatewaynumber TEXT, dtmfformat TEXT, dtmfprefix TEXT, dtmfsuffix TEXT)');
          },
        function(error) {
            logMessage("Error ["+error.code +"] - " + error.DOMString+" occurred.");
         });
}

function getSetting(setting) {
    var db = getDatabase();
    var res="";
    db.transaction(
      function(tx) {
          var rs = tx.executeSql('SELECT value FROM settings WHERE setting=?;', [setting]);
          if (rs.rows.length > 0) {
               res = rs.rows.item(0).value;
               logMessage(setting+" is "+res);
          } else {
              res = "Unknown";
          }
      },
      function(error) {
         logMessage("Error ["+error.code +"] - " + error.DOMString+" occurred.");
      }
     );
     return res;
}


function setSetting(setting, value) {
    var db = getDatabase();
    var res = "";
    db.transaction(
        function(tx) {
            var rs = tx.executeSql('INSERT OR REPLACE INTO settings VALUES (?,?);', [setting,value]);
            if (rs.rowsAffected > 0) {
                res = "OK";
                logMessage("Updated "+setting+" to "+value);
            } else {
             res = "Error";
            }
        },
        function(error) {
            logMessage("Error ["+error.code +"] - " + error.DOMString+" occurred.");
        }
    );
   return res;
}

function addRule(ruleObj){
    logMessage('SQL> INSERT INTO profiles(id, numberpattern, gatewaynumber, dtmfformat, dtmfprefix, dtmfsuffix) VALUES (NULL, '+[ruleObj.numberpattern, ruleObj.gatewaynumber, ruleObj.dtmfformat, ruleObj.dtmfprefix, ruleObj.dtmfsuffix]+')');
    var db = getDatabase();
    var res = "";
    logMessage("Opened VICaR database..");

    db.transaction(function(tx) {
               var rs = tx.executeSql('INSERT INTO profiles(id, numberpattern, gatewaynumber, dtmfformat, dtmfprefix, dtmfsuffix) VALUES (NULL, ?, ?, ?, ?, ?);', [ruleObj.numberpattern, ruleObj.gatewaynumber, ruleObj.dtmfformat, ruleObj.dtmfprefix, ruleObj.dtmfsuffix]);
               logMessage("Inserted "+rs.rowsAffected+" rows");
               if (rs.rowsAffected > 0) {
                 res = "OK";
               } else {
                 res = "Error";
               }
         },
         function(error) {
           logMessage("Error ["+error.code +"] - " + error.DOMString+" occurred.");
         }
   );
   return res;
}

function updateRule(id,ruleObj){
    logMessage('SQL> UPDATE profiles set numberpattern = '+[ruleObj.numberpattern]+
               ', gatewaynumber = '+[ruleObj.gatewaynumber]+
               ', dtmfformat = '+[ruleObj.dtmfformat]+
               ', dtmfprefix = '+[ruleObj.dtmfprefix]+
               ', dtmfsuffix = '+[ruleObj.dtmfsuffix]+
               ' WHERE id = ?'+[id]);
    var db = getDatabase();
    var res = "";
    db.transaction(function(tx) {
           var rs = tx.executeSql('UPDATE profiles set numberpattern = ?, gatewaynumber = ?, dtmfformat = ?, dtmfprefix = ?, dtmfsuffix = ? WHERE id = ?;',
                            [ruleObj.numberpattern, ruleObj.gatewaynumber, ruleObj.dtmfformat, ruleObj.dtmfprefix, ruleObj.dtmfsuffix, id]);
           logMessage("Updated "+rs.rowsAffected+" rows");
           if (rs.rowsAffected > 0) {
             res = "OK";
           } else {
             res = "Error";
           }
         },
         function(error) {
            logMessage("Error ["+error.code +"] - " + error.DOMString+" occurred.");
         }
   );
   return res;
}

function removeRule(id){
    logMessage('SQL> DELETE FROM profiles WHERE id = '+[id]);
    var db = getDatabase();
    var res = "";
    db.transaction(function(tx) {
         var rs = tx.executeSql('DELETE FROM profiles WHERE id = ?;', [id]);
               logMessage("Deleted "+rs.rowsAffected+" rows");
               if (rs.rowsAffected > 0) {
                 res = "OK";
               } else {
                 res = "Error";
               }
         },
         function(error) {
            logMessage("Error ["+error.code +"] - " + error.DOMString+" occurred.");
         }
   );
   return res;
}

function getAllRules(){
    var db = getDatabase();
    var rulesArray = new Array();
    var ruleObj;
    db.transaction(function(tx) {
           var rs = tx.executeSql('SELECT * FROM profiles');
           logMessage("Fetched "+rs.rows.length+" rows");
           var i = 0;
           for (i = 0; i < rs.rows.length; i++){
               ruleObj = new Object();
               ruleObj.id = rs.rows.item(i).id;
               ruleObj.numberpattern = rs.rows.item(i).numberpattern;
               ruleObj.gatewaynumber = rs.rows.item(i).gatewaynumber;
               ruleObj.dtmfformat = rs.rows.item(i).dtmfformat;
               ruleObj.dtmfprefix = rs.rows.item(i).dtmfprefix;
               ruleObj.dtmfsuffix = rs.rows.item(i).dtmfsuffix;
               rulesArray[i] = ruleObj;
               logMessage("id = "+ruleObj.id
                          +", numberpattern = "+ruleObj.numberpattern
                          +", gatewaynumber = "+ruleObj.gatewaynumber
                          +", dtmfformat = "+ruleObj.dtmfformat
                          +", dtmfprefix = "+ruleObj.dtmfprefix
                          +", dtmfsuffix = "+ruleObj.dtmfsuffix);
           }
       },
       function(error) {
           logMessage("Error ["+error.code +"] - " + error.DOMString+" occurred.");
       }
   );
   return rulesArray;
}


function getRuleByID(id){
    var db = getDatabase();
    var ruleObj;
    db.transaction(function(tx) {
           logMessage('SQL> SELECT * FROM profiles WHERE id = '+[id]);
           var rs = tx.executeSql('SELECT * FROM profiles WHERE id = '+[id]);
           logMessage("Fetched "+rs.rows.length+" rows");
           if (rs.rows.length > 0){
               ruleObj = new Object();
               ruleObj.id = rs.rows.item(0).id;
               ruleObj.numberpattern = rs.rows.item(0).numberpattern;
               ruleObj.gatewaynumber = rs.rows.item(0).gatewaynumber;
               ruleObj.dtmfformat = rs.rows.item(0).dtmfformat;
               ruleObj.dtmfprefix = rs.rows.item(0).dtmfprefix;
               ruleObj.dtmfsuffix = rs.rows.item(0).dtmfsuffix;
               logMessage("id = "+ruleObj.id
                          +", numberpattern = "+ruleObj.numberpattern
                          +", gatewaynumber = "+ruleObj.gatewaynumber
                          +", dtmfformat = "+ruleObj.dtmfformat
                          +", dtmfprefix = "+ruleObj.dtmfprefix
                          +", dtmfsuffix = "+ruleObj.dtmfsuffix);
           }
       },
       function(error) {
           logMessage("Error ["+error.code +"] - " + error.DOMString+" occurred.");
       }
   );
   return ruleObj;
}
