/*
@version: 0.6
@author: Sudheer K. <scifi1947 at gmail.com>
@license: GNU General Public License
*/

#ifndef DATABASEUTILITY_H
#define DATABASEUTILITY_H

#include <QObject>
#include "vicarprofiletypes.h"
#include <QSqlError>
#include <QSqlDatabase>

class DatabaseUtility : public QObject
{
    Q_OBJECT
public:
    DatabaseUtility(QObject *parent = 0);
    ~DatabaseUtility();
    bool openDatabase();
    bool deleteDatabase();
    void closeDatabase();
    bool tableExists(QString tableName);
    bool createProfilesTable();
    int insertProfile(org::maemo::vicar::Profile profile);
    bool updateProfile(org::maemo::vicar::Profile profile);
    bool selectProfile(int id,org::maemo::vicar::Profile* profile);
    bool getAllProfiles(org::maemo::vicar::ProfileList* profileList);
    bool findProfileByNumber(QString number,org::maemo::vicar::Profile* profile);
    bool getDefaultProfile(org::maemo::vicar::Profile* profile);
    bool deleteProfile(int id);
    QSqlError lastError();

private:
    QSqlDatabase profilesDB;
};

#endif // DATABASEUTILITY_H
