/*
@version: 0.6
@author: Sudheer K. <scifi1947 at gmail.com>
@license: GNU General Public License
*/
#ifndef PROFILESWINDOW_H
#define PROFILESWINDOW_H

#include <QMainWindow>

namespace Ui {
    class ProfilesWindow;
}

class ProfilesWindowPrivate;

class ProfilesWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit ProfilesWindow(QWidget *parent = 0);
    ~ProfilesWindow();
    void loadProfilesList();

private:
    Ui::ProfilesWindow *ui;
    ProfilesWindowPrivate * const d;

private slots:
    void on_addButton_clicked();
    void on_editButton_clicked();
    void on_removeButton_clicked();
    void on_actionRoutingEnabled_triggered(bool checked);
    void on_actionRouteOnDefault_triggered(bool checked);
    void on_actionEditDefaultProfile_triggered();
};

#endif // PROFILESWINDOW_H
