/*
@version: 0.2
@author: Sudheer K. <scifi.guy@hotmail.com>
@license: GNU General Public License
*/

#include "gconfutility.h"
#include <gconf/gconf-client.h>
#include <QDebug>

GConfUtility::GConfUtility(QObject *parent) :
    QObject(parent)
{
    /* Get a GConf client */
    gconfClient = gconf_client_get_default();
    g_assert(GCONF_IS_CLIENT(gconfClient));
}

GConfUtility::~GConfUtility(){
    /* release GConf client */
    g_object_unref(gconfClient);
    gconfClient = 0;
}

QString GConfUtility::getGconfValueString(QString strKey){

    char* strValue = NULL;

    if (!strKey.isEmpty()) {
        strKey.prepend(GCONF_DIR);

        strValue = gconf_client_get_string(gconfClient, strKey.toAscii().constData(), NULL);
        qDebug() << "Gconf: "<<strKey.toAscii().constData()<< " is "<<strValue;
    }

    return QString(strValue);
}

void GConfUtility::setGconfValueString(QString strKey,QString strValue){

    if (!strKey.isEmpty()){

        strKey.prepend(GCONF_DIR);

        if (!strValue.isEmpty()){
                gconf_client_set_string(gconfClient, strKey.toAscii().constData(), strValue.toAscii().constData(),NULL);
                qDebug() << "Assigned "<<strKey.toAscii().constData()<< " to "<<strValue.toAscii().constData();
        }
        else{
                gconf_client_unset(gconfClient, strKey.toAscii().constData(),NULL);
                qDebug() << "Assigned "<<strKey.toAscii().constData()<< " to NULL";
        }

    }
}

bool GConfUtility::getGconfValueBoolean(QString strKey){

    bool boolValue = false;

    if (!strKey.isEmpty()) {
        strKey.prepend(GCONF_DIR);

        boolValue = gconf_client_get_bool(gconfClient, strKey.toAscii().constData(), NULL);
        qDebug() << "Gconf: "<<strKey.toAscii().constData()<< " is "<<boolValue;
    }

    return boolValue;
}

void GConfUtility::setGconfValueBoolean(QString strKey,bool boolValue){

    if (!strKey.isEmpty()){

        strKey.prepend(GCONF_DIR);

        gconf_client_set_bool(gconfClient, strKey.toAscii().constData(),boolValue,NULL);
        qDebug() << "Assigned "<<strKey.toAscii().constData()<< " to "<<boolValue;
    }
}

int GConfUtility::getGconfValueInteger(QString strKey){

    int intValue = 0;

    if (!strKey.isEmpty()) {
        strKey.prepend(GCONF_DIR);

        intValue = gconf_client_get_int(gconfClient, strKey.toAscii().constData(), NULL);
        qDebug() << "Gconf: "<<strKey.toAscii().constData()<< " is "<<intValue;
    }

    return intValue;
}

void GConfUtility::setGconfValueInteger(QString strKey,int intValue){

    if (!strKey.isEmpty()){

        strKey.prepend(GCONF_DIR);

        gconf_client_set_int(gconfClient, strKey.toAscii().constData(),intValue,NULL);
        qDebug() << "Assigned "<<strKey.toAscii().constData()<< " to "<<intValue;
    }
}
