/*
@version: 0.2
@author: Sudheer K. <scifi.guy@hotmail.com>
@license: GNU General Public License
*/

#ifndef CONFIGWINDOW_H
#define CONFIGWINDOW_H

#include <QMainWindow>
#include <QCloseEvent>
#include "gconfutility.h"

#define APPLICATION_DBUS_PATH "/org/maemo/vicar"
#define APPLICATION_DBUS_INTERFACE "org.maemo.vicar"

namespace Ui {
    class ConfigWindow;
}

class ConfigWindow : public QMainWindow {
    Q_OBJECT
public:
    ConfigWindow(QWidget *parent = 0);
    ~ConfigWindow();
    void loadValues();
    bool verifyConfigData();
    void saveConfigData();

protected:
    void changeEvent(QEvent *e);
    void closeEvent(QCloseEvent *e);

private:
    Ui::ConfigWindow *ui;
    GConfUtility *gconfUtility;

private slots:
    void on_actionReset_triggered();
    void on_actionSave_triggered();
};

#endif // CONFIGWINDOW_H
