/*
@version: 0.3
@author: Sudheer K. <scifi1947 at gmail.com>
@license: GNU General Public License
*/

#ifndef CALLROUTER_H
#define CALLROUTER_H

#include <QObject>
#include <QDBusMessage>
#include <gconfutility.h>
#include "vicardbusadaptor.h"

#define APPLICATION_DBUS_PATH "/org/maemo/vicar"
#define APPLICATION_DBUS_INTERFACE "org.maemo.vicar"
#define APPLICATION_DBUS_SERVICE "org.maemo.vicar"
#define APPLICATION_FRIENDLY_NAME "VICaR"

/* CSD CALL plugin D-Bus definitions */
#define CSD_CALL_BUS_NAME	"com.nokia.csd.Call"
#define CSD_CALL_INTERFACE	"com.nokia.csd.Call"
#define CSD_CALL_INSTANCE_INTERFACE	"com.nokia.csd.Call.Instance"
#define CSD_CALL_CONFERENCE	"com.nokia.csd.Call.Conference"
#define CSD_CALL_PATH		"/com/nokia/csd/call"
#define CSD_CALL_INSTANCE_PATH  "/com/nokia/csd/call/1"
#define CSD_CALL_SERVICE	"com.nokia.csd.Call"
#define CSD_SERVICE             "com.nokia.csd"

class CallRouter : public QObject
{
Q_OBJECT
Q_CLASSINFO("D-Bus Interface", "org.maemo.vicar")

public:
    CallRouter(QObject *parent = 0);
    ~CallRouter();
    void registerDBusService();
    void unregisterDBusService();

protected:
    void startCallStatusMonitors();
    QString convertToDTMFCode(QString);
    void connectToDBusSignals();
    void disconnectFromDBusSignals();
    bool isExcludedNumber(QString);
    bool placeCall(QString);

protected slots:
    void processOutgoingCall(const QDBusMessage& dbusMessage);
    QString callViaCallingCard();
    void sendNumberAsDTMFCode(const QDBusMessage& dbusMessage);
    void stopCallStatusMonitors();

    //D-Bus Interface Methods
public slots:
    bool startOutgoingCallMonitor();
    bool stopOutgoingCallMonitor();
    bool isRunning();
    QString callInternationalNumber(const QString& internationalNumber);

private:
    GConfUtility *gconfUtility;
    VicarDbusAdaptor *dbusAdaptor;
};

#endif // CALLROUTER_H
