/*
@version: 0.3
@author: Sudheer K. <scifi1947 at gmail.com>
@license: GNU General Public License
*/

#include "configwindow.h"
#include "ui_configwindow.h"
#include "gconfutility.h"
#include "dbusutility.h"
#include <QDebug>
#include <QMessageBox>

ConfigWindow::ConfigWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::ConfigWindow)
{
    ui->setupUi(this);
    gconfUtility = new GConfUtility();
    loadValues();
}

ConfigWindow::~ConfigWindow()
{
    delete ui;
    delete gconfUtility;
    gconfUtility = 0;
}

void ConfigWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void ConfigWindow::closeEvent(QCloseEvent *e)
{
    if (verifyConfigData()){
        qDebug() << "Verification successful. Saving data to gconf";
        saveConfigData();
        e->accept();
    }
    else{
        e->ignore();
    }
}

void ConfigWindow::on_actionSave_triggered()
{
    if (verifyConfigData()){
        qDebug() << "Verification successful. Saving data to gconf";
        saveConfigData();
    }

}

void ConfigWindow::on_actionReset_triggered()
{
    ui->checkBoxIntlCallRedirEnabled->setChecked(false);
    ui->lineEditCallingCardNumber->clear();
    ui->lineEditCountryCodesToExclude->clear();
    ui->comboBoxDTMFFormat->clear();
    ui->lineEditDTMFPrefix->clear();
    ui->lineEditDTMFSuffix->clear();
    //ui->spinBoxDTMFDelay->setValue(1);
    qDebug() << "Settings reset";
    DbusUtility dbusUtility = DbusUtility();
    dbusUtility.displayNotification("VICaR: Settings reset.");
}

void ConfigWindow::loadValues(){

    bool isRoutingEnabled = gconfUtility->getGconfValueBoolean("routing_enabled");
    QString strCallingCardNumber = gconfUtility->getGconfValueString("calling_card_number");
    QString strNumbersToExclude = gconfUtility->getGconfValueString("numbers_to_exclude");
    QString strDTMFFormat = gconfUtility->getGconfValueString("dtmf_format");
    QString strDTMFPrefix = gconfUtility->getGconfValueString("dtmf_prefix");
    QString strDTMFSuffix = gconfUtility->getGconfValueString("dtmf_suffix");
    //int intDTMFDelay = gconfUtility->getGconfValueInteger("dtmf_delay");

    ui->checkBoxIntlCallRedirEnabled->setChecked(isRoutingEnabled);
    ui->lineEditCallingCardNumber->setText(strCallingCardNumber);
    ui->lineEditCountryCodesToExclude->setText(strNumbersToExclude);
    int intIndex = ui->comboBoxDTMFFormat->findText(strDTMFFormat);
    ui->comboBoxDTMFFormat->setCurrentIndex(intIndex);
    ui->lineEditDTMFPrefix->setText(strDTMFPrefix);    
    ui->lineEditDTMFSuffix->setText(strDTMFSuffix);
    //ui->spinBoxDTMFDelay->setValue(intDTMFDelay);

   //Accept numbers only for Calling Card Number field
    ui->lineEditCallingCardNumber->setValidator(new QRegExpValidator( QRegExp( "^-?\\d\\d*$"), this));    
    ui->lineEditDTMFPrefix->setValidator(new QRegExpValidator( QRegExp( "^[0-9p#\\*]*$"), this));
    ui->lineEditDTMFSuffix->setValidator(new QRegExpValidator( QRegExp( "^[0-9p#\\*]*$"), this));

    qDebug() << "Values loaded from GConf";

}

bool ConfigWindow::verifyConfigData(){
    //Verify whether user-input matches application requirements
    bool isRoutingEnabled = ui->checkBoxIntlCallRedirEnabled->isChecked();
    QString strCallingCardNumber = ui->lineEditCallingCardNumber->text();
    QString strNumbersToExclude = ui->lineEditCountryCodesToExclude->text();


    QString strMessage = QString("");

    if (isRoutingEnabled){
        //Call Routing is checked. Now validate other values
        if (strCallingCardNumber.isEmpty()){
            strMessage.append("Enter a calling card number\n");
            ui->lineEditCallingCardNumber->setFocus();
        }

        if (strCallingCardNumber.startsWith("+")||strCallingCardNumber.startsWith("00")){
            strMessage.append("Calling card number must be a local number. \nPlease remove the international dialing code.\n");
            ui->lineEditCallingCardNumber->setFocus();
        }

    }

    if (!strMessage.isEmpty()){
        QMessageBox::warning(this,"Invalid Data",strMessage);
        return false;
    }
    else{
        return true;
    }
}

void ConfigWindow::saveConfigData(){

        bool isRoutingEnabled = ui->checkBoxIntlCallRedirEnabled->isChecked();
        QString strCallingCardNumber = ui->lineEditCallingCardNumber->text();
        QString strNumbersToExclude = ui->lineEditCountryCodesToExclude->text();

        QString strDTMFFormat = ui->comboBoxDTMFFormat->currentText();
        QString strDTMFPrefix = ui->lineEditDTMFPrefix->text();
        QString strDTMFSuffix = ui->lineEditDTMFSuffix->text();
       // int intDTMFDelay = ui->spinBoxDTMFDelay->value();


        gconfUtility->setGconfValueBoolean("routing_enabled",isRoutingEnabled);

        gconfUtility->setGconfValueString("calling_card_number",strCallingCardNumber);

        if (!strNumbersToExclude.isEmpty()){
            strNumbersToExclude = strNumbersToExclude.remove(" ");
            strNumbersToExclude = strNumbersToExclude.remove("\t");
            strNumbersToExclude = strNumbersToExclude.replace("\n",",");
        }

        gconfUtility->setGconfValueString("numbers_to_exclude",strNumbersToExclude);
        //gconfUtility->setGconfValueInteger("dtmf_delay",intDTMFDelay);
        gconfUtility->setGconfValueString("dtmf_format",strDTMFFormat);
        gconfUtility->setGconfValueString("dtmf_prefix",strDTMFPrefix.trimmed());
        gconfUtility->setGconfValueString("dtmf_suffix",strDTMFSuffix);

        DbusUtility dbusUtility = DbusUtility();

        qDebug() << "Settings updated";
        dbusUtility.displayNotification("VICaR: Settings updated.");

        if (isRoutingEnabled){
            qDebug() << "Enable call routing immediately";
            dbusUtility.sendSignal(APPLICATION_DBUS_PATH,APPLICATION_DBUS_INTERFACE,"startOutgoingCallMonitor");
        }
        else{
            qDebug() << "Disable call routing immediately";
            dbusUtility.sendSignal(APPLICATION_DBUS_PATH,APPLICATION_DBUS_INTERFACE,"stopOutgoingCallMonitor");
        }
}

