/*
@version: 0.1
@author: Sudheer K. <scifi.guy@hotmail.com>
@license: GNU General Public License
*/

#include "gconfutility.h"
#include <gconf/gconf-client.h>
#include <QDebug>

GConfUtility::GConfUtility(QObject *parent) :
    QObject(parent)
{
    /* Get a GConf client */
    gconfClient = gconf_client_get_default();
    g_assert(GCONF_IS_CLIENT(gconfClient));
}

GConfUtility::~GConfUtility(){
    /* release GConf client */
    g_object_unref(gconfClient);
    gconfClient = 0;
}

char* GConfUtility::getGconfValueString(char *strKey){

    char* strValue = NULL;
    QString qstrKey = QString(strKey);

    if (!qstrKey.isEmpty()) {
        qstrKey.prepend(GCONF_DIR);

        strValue = gconf_client_get_string(gconfClient, qstrKey.toAscii().constData(), NULL);
        qDebug() << "Gconf: "<<qstrKey.toAscii().constData()<< " is "<<strValue;
    }

    return strValue;
}

void GConfUtility::setGconfValueString(char *strKey,char *strValue){

    QString qstrKey = QString(strKey);
    QString qstrValue = QString(strValue);

    if (!qstrKey.isEmpty()){

        qstrKey.prepend(GCONF_DIR);

        if (!qstrValue.isEmpty()){
                gconf_client_set_string(gconfClient, qstrKey.toAscii().constData(), qstrValue.toAscii().constData(),NULL);
                qDebug() << "Assigned "<<qstrKey.toAscii().constData()<< " to "<<qstrValue.toAscii().constData();
        }
        else{
                gconf_client_unset(gconfClient, qstrKey.toAscii().constData(),NULL);
                qDebug() << "Assigned "<<qstrKey.toAscii().constData()<< " to NULL";
        }

    }
}

bool GConfUtility::getGconfValueBoolean(char *strKey){

    bool boolValue = false;

    QString qstrKey = QString(strKey);

    if (!qstrKey.isEmpty()) {
        qstrKey.prepend(GCONF_DIR);

        boolValue = gconf_client_get_bool(gconfClient, qstrKey.toAscii().constData(), NULL);
        qDebug() << "Gconf: "<<qstrKey.toAscii().constData()<< " is "<<boolValue;
    }

    return boolValue;
}

void GConfUtility::setGconfValueBoolean(char *strKey,bool boolValue){

    QString qstrKey = QString(strKey);


    if (!qstrKey.isEmpty()){

        qstrKey.prepend(GCONF_DIR);

        gconf_client_set_bool(gconfClient, qstrKey.toAscii().constData(),boolValue,NULL);
        qDebug() << "Assigned "<<qstrKey.toAscii().constData()<< " to "<<boolValue;
    }
}

int GConfUtility::getGconfValueInteger(char *strKey){

    int intValue = 0;

    QString qstrKey = QString(strKey);

    if (!qstrKey.isEmpty()) {
        qstrKey.prepend(GCONF_DIR);

        intValue = gconf_client_get_int(gconfClient, qstrKey.toAscii().constData(), NULL);
        qDebug() << "Gconf: "<<qstrKey.toAscii().constData()<< " is "<<intValue;
    }

    return intValue;
}

void GConfUtility::setGconfValueInteger(char *strKey,int intValue){

    QString qstrKey = QString(strKey);


    if (!qstrKey.isEmpty()){

        qstrKey.prepend(GCONF_DIR);

        gconf_client_set_int(gconfClient, qstrKey.toAscii().constData(),intValue,NULL);
        qDebug() << "Assigned "<<qstrKey.toAscii().constData()<< " to "<<intValue;
    }
}
