/*
@version: 0.1
@author: Sudheer K. <scifi.guy@hotmail.com>
@license: GNU General Public License
*/

#ifndef CONFIGWIDGET_H
#define CONFIGWIDGET_H

#include <QWidget>
#include <QDBusMessage>
#include <QMainWindow>
#include <QCloseEvent>
#include "gconfutility.h"

#define APPLICATION_DBUS_PATH "/org/maemo/vicar"
#define APPLICATION_DBUS_INTERFACE "org.maemo.vicar"

namespace Ui {
    class ConfigWidget;
}

class ConfigWidget : public QWidget {
    Q_OBJECT

public:
    ConfigWidget(QWidget *parent = 0);
    ~ConfigWidget();
    void loadValues();
    bool verifyConfigData();
    void saveConfigData();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::ConfigWidget *ui;
    GConfUtility *gconfUtility;

private slots:
    void on_pushButtonReset_clicked();
    void on_pushButtonSave_clicked();

};

#endif // CONFIGWIDGET_H
