#!/usr/bin/env python
# -*- coding: utf-8 -*-

#vertsms Ossipena/TimoP
#plus others (will add at some stage)

''' 1. Imports '''

# builtin modules
import ctypes, os, sys, time, threading

# maemo-specific modules
import hildon, osso

# third-party modules
import gtk, dbus, pango
from PySide.QtCore import *


# program modules
from vertsms import config, sms, pygobject

class VertSMS():

    osso_ctx = osso.Context("test_abook", "0.one")
    capi = pygobject.PyGObjectCPAI()
    TIMEOUT = 1
    sequential_presses = 0
    last_key_pressed = None
    elapsed_time = 0
    last_update = time.time()
    app = QCoreApplication(sys.argv)

    

    def __init__(self):
        self.window = hildon.Window()
        self.window.set_title("VertSMS")
        self.window.connect("delete_event", gtk.main_quit, None)
        hildon.hildon_gtk_window_set_portrait_flags(self.window,
                                                    hildon.PORTRAIT_MODE_SUPPORT | 
                                                    hildon.PORTRAIT_MODE_REQUEST)

        self.create_widgets()
        self.create_layout()
        self.window.show_all()
        self.program = hildon.Program.get_instance()
        self.program.add_window(self.window)
        

        gtk.main()

    def create_widgets(self):
        self.receiver = hildon.TextView()
        self.receiver.set_placeholder("To")
        self.disable_osk(self.receiver) 

        self.receiver_buffer = self.receiver.get_buffer()

        self.message = hildon.TextView()
        self.message.set_wrap_mode(gtk.WRAP_WORD)
        self.message.set_placeholder("Write your message here")
        self.message.set_cursor_visible(True)
        self.disable_osk(self.message)

        self.message_buffer = self.message.get_buffer()

 
        self.send_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH |
                                         gtk.HILDON_SIZE_THUMB_HEIGHT, 
                                         hildon.BUTTON_ARRANGEMENT_VERTICAL, "Send")
        self.send_button.set_name("hildon-accept-button-thumb")
        self.send_button.connect("clicked", self.send)

        self.back_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH |
                                         gtk.HILDON_SIZE_THUMB_HEIGHT, 
                                         hildon.BUTTON_ARRANGEMENT_VERTICAL)
        self.back_button.set_image(gtk.image_new_from_icon_name("call_dialpad_backspace", 
                                                                gtk.ICON_SIZE_DIALOG))
        self.back_button.tap_and_hold_setup(None, None, 0)
        self.back_button.connect("clicked", self.backspace)
        self.back_button.connect("tap-and-hold", self.backspace_hold)
        self.back_button.connect("released", self.backspace_up)

        self.to_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH |
                                       gtk.HILDON_SIZE_THUMB_HEIGHT, 
                                       hildon.BUTTON_ARRANGEMENT_VERTICAL, "To:")
        self.to_button.connect("clicked", self.addrbook)

        self.one_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH |
                                      gtk.HILDON_SIZE_THUMB_HEIGHT, 
                                      hildon.BUTTON_ARRANGEMENT_VERTICAL, 
                                      "  1", ".,:;!?")
        self.one_button.connect("clicked", self.number_pressed)

        self.two_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH |
                                      gtk.HILDON_SIZE_THUMB_HEIGHT, 
                                      hildon.BUTTON_ARRANGEMENT_VERTICAL, 
                                      " 2", "abc")
        self.two_button.connect("clicked", self.number_pressed)

        self.three_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH |
                                      gtk.HILDON_SIZE_THUMB_HEIGHT, 
                                      hildon.BUTTON_ARRANGEMENT_VERTICAL, 
                                      " 3", "def")
        self.three_button.connect("clicked", self.number_pressed)
        
        self.four_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH |
                                      gtk.HILDON_SIZE_THUMB_HEIGHT, 
                                      hildon.BUTTON_ARRANGEMENT_VERTICAL, 
                                      " 4", "ghi")
        self.four_button.connect("clicked", self.number_pressed)

        self.five_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH |
                                      gtk.HILDON_SIZE_THUMB_HEIGHT, 
                                      hildon.BUTTON_ARRANGEMENT_VERTICAL, 
                                      " 5", "jkl")
        self.five_button.connect("clicked", self.number_pressed)

        self.six_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH |
                                      gtk.HILDON_SIZE_THUMB_HEIGHT, 
                                      hildon.BUTTON_ARRANGEMENT_VERTICAL, 
                                      " 6", "mno")
        self.six_button.connect("clicked", self.number_pressed)

        self.seven_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH |
                                     gtk.HILDON_SIZE_THUMB_HEIGHT, 
                                      hildon.BUTTON_ARRANGEMENT_VERTICAL, 
                                      "  7", "pqrs")
        self.seven_button.connect("clicked", self.number_pressed)

        self.eight_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH |
                                      gtk.HILDON_SIZE_THUMB_HEIGHT, 
                                      hildon.BUTTON_ARRANGEMENT_VERTICAL, 
                                      " 8", "tuv")
        self.eight_button.connect("clicked", self.number_pressed)

        self.nine_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH |
                                      gtk.HILDON_SIZE_THUMB_HEIGHT, 
                                      hildon.BUTTON_ARRANGEMENT_VERTICAL, 
                                      "  9", "wxyz")
        self.nine_button.connect("clicked", self.number_pressed)

        self.zero_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH |
                                      gtk.HILDON_SIZE_THUMB_HEIGHT, 
                                      hildon.BUTTON_ARRANGEMENT_VERTICAL, 
                                      "0", u"_>")
        self.zero_button.connect("clicked", self.number_pressed)

        self.star_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH |
                                         gtk.HILDON_SIZE_THUMB_HEIGHT, 
                                         hildon.BUTTON_ARRANGEMENT_VERTICAL, 
                                         "*\t", "\t+")
        self.star_button.connect("clicked", self.number_pressed)

        self.pound_button = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH |
                                          gtk.HILDON_SIZE_THUMB_HEIGHT, 
                                          hildon.BUTTON_ARRANGEMENT_VERTICAL, 
                                          "#\t")
        self.pound_button.connect("clicked", self.number_pressed)

        # hack to change button font
        for i in ("one", "two", "three", "four", "five", "six", "seven",
                  "eight",  "nine", "zero"):
            for parent in eval("self.%s_button.get_children()" % i):    #We start with the Button itself
                for child in parent.get_children():                #Alignment containing HBox that contains the HBox with HildonButton's Labels
                    for grandchild in child.get_children():           #HBox containg HBox that contains the HBox with HildonButton's Labels...
                        for great_grandchild in grandchild.get_children():        #HBox containing HildonButton's Labels
                            if isinstance(great_grandchild, gtk.Label) and great_grandchild.name == "hildon-button-title":
                                great_grandchild.modify_font(pango.FontDescription("Nokia Sans Bold 35px"))
                            elif isinstance(great_grandchild, gtk.Label) and great_grandchild.name == "hildon-button-value":
                                hildon.hildon_helper_set_logical_font(great_grandchild, "SystemFont")

    def create_layout(self):
        self.table = gtk.Table(8, 3, True)
        self.table.attach(self.to_button, 0, 1, 0, 1)
        self.table.attach(self.receiver, 1, 3, 0, 1)
        self.table.attach(self.message, 0, 3, 1, 3)
        self.table.attach(self.send_button, 0, 2, 3, 4)
        self.table.attach(self.back_button, 2, 3, 3, 4)
        self.table.attach(self.one_button, 0, 1,  4, 5)
        self.table.attach(self.two_button, 1, 2,  4, 5)
        self.table.attach(self.three_button, 2, 3,  4, 5)
        self.table.attach(self.four_button, 0, 1,  5, 6)
        self.table.attach(self.five_button, 1, 2,  5, 6)
        self.table.attach(self.six_button, 2, 3,  5, 6)
        self.table.attach(self.seven_button, 0, 1,  6, 7)
        self.table.attach(self.eight_button, 1, 2,  6, 7)
        self.table.attach(self.nine_button, 2, 3,  6, 7)
        self.table.attach(self.star_button, 0, 1, 7, 8)
        self.table.attach(self.zero_button, 1, 2, 7, 8)
        self.table.attach(self.pound_button, 2, 3, 7, 8)
        self.window.add(self.table)

    def disable_osk(self, widget):
        input_mode = widget.get_property("hildon-input-mode")
        input_mode = input_mode | gtk.HILDON_GTK_INPUT_MODE_NO_SCREEN_PLUGINS
        widget.set_property("hildon-input-mode", input_mode)

    def update_text(self, cursor_correction):
        if self.message.is_focus():
            start, end = self.message_buffer.get_bounds()
        elif self.receiver.is_focus():
            start, end = self.receiver_buffer.get_bounds()

        if cursor_correction == 0:
            if self.message.is_focus():
                updatedtext = self.message_buffer.get_text(start, end)
            elif self.receiver.is_focus():
                updatedtext = self.receiver_buffer.get_text(start, end)
        else:
            if self.message.is_focus():
                new_end = self.message_buffer.get_iter_at_offset(cursor_correction)
                updatedtext = self.message_buffer.get_text(start,new_end)
                updatedtext = updatedtext[:cursor_correction]
                self.message_buffer.set_text(updatedtext)
            elif self.receiver.is_focus():
#                new_end = self.receiver_buffer.get_iter_at_offset(cursor_correction)
                updatedtext = self.receiver_buffer.get_text(start,new_end)
                updatedtext = updatedtext[:cursor_correction]
                self.receiver_buffer.set_text(updatedtext)

        return updatedtext

    def number_pressed(self, button):
        key = button.get_title().strip()

        if self.message.is_focus():
            letters = {}
            letters['1'] = ['', '.', ',', ':', ';', '!', '?', '1']
            letters['2'] = ['', 'a', 'b', 'c', '2']
            letters['3'] = ['', 'd', 'e', 'f', '3']
            letters['4'] = ['', 'g', 'h', 'i', '4']
            letters['5'] = ['', 'j', 'k', 'l', '5']
            letters['6'] = ['', 'm', 'n', 'o', '6']
            letters['7'] = ['', 'p', 'q', 'r', 's', '7']
            letters['8'] = ['', 't', 'u', 'v', '8']
            letters['9'] = ['','w', 'x', 'y', 'z', '9']
            letters['0'] = ['',' ', '0', '\n']
            letters['*'] = ['', '*', '+']
            letters['#'] = ['', '#']

            if self.sequential_presses == len(letters[key]) - 1:
                self.sequential_presses = 0
                
            if key == self.last_key_pressed and not self.timeout():
                self.update_text(-1)
                self.sequential_presses += 1
                
            else:
                self.timeout()
                self.sequential_presses = 1
                self.last_key_pressed = key
                
            output = letters[key][self.sequential_presses]

        elif self.receiver.is_focus():
            letters = {'1': '1',
                       '2': '2',
                       '3': '3',
                       '4': '4',
                       '5': '5',
                       '6': '6',
                       '7': '7',
                       '8': '8',
                       '9': '9',
                       '0': '0',
                       '*': '+',
                       '#': ';'}

            self.update_text(0)
            output = letters[key]

        self.input(output)

    def backspace(self, widget):
    
        if self.message.is_focus():
#            start, end = self.message_buffer.get_bounds()
            offset = self.message_buffer.get_iter_at_mark(self.message_buffer.get_insert())
            self.message_buffer.backspace(offset, True,True)

        elif self.receiver.is_focus():
            offset = self.receiver_buffer.get_iter_at_mark(self.receiver_buffer.get_insert())
            self.receiver_buffer.backspace(offset, True,True)


#            start, end = self.receiver_buffer.get_bounds()

#        start, end = self.message_buffer.get_bounds()
#        offset = gtk_text_iter_get_offset(position)
#k.TextIter.backward_char
#        start = self.message_buffer.get_iter_at_mark(self.message.backward_char())
#        self.update_text(-1)
#        position = self.message_buffer.get_insert()
#        print "position: " + position        
#        offset = self.message_buffer.get_iter_at_mark(self.message_buffer.get_insert())
#        offset = self.message_buffer.get_iter_at_mark(self.message_buffer.get_insert())
#       
#        updatedtext = self.message_buffer.get_text(start,end)
#        updatedtext = updatedtext[:position]+updatedtext[position+1:]
#        self.message_buffer.backspace(self.message_buffer, offset, 0)        
#        self.message_buffer.backspace(offset, True,True)        
#self.message_buffer.backspace(offset)          
#self.message_buffer.set_text(updatedtext)
#        self.message.delete-from-cursor()
        
        self.last_key_pressed = None

    def slow_deletion(self, pressed, unused, unusedtoo):
#        global backspace_pressed
#        backspace_pressed = self.backspace_pressed        
        lock=threading.allocate_lock()
#        i=1        
#        while i < 10:
#          print i
#          i = i+1
#          lock.acquire()
#          print i
#          backspace("nomatterwhathere")
#          time.sleep(1)
#          print "test"
#          lock.release()
#        print self.backspace_pressed
#        print "loop ended"
        while self.backspacepressed:
          lock.acquire()          
          print "jou"
          time.sleep(5)
          lock.release()

    def backspace_hold(self, widget):
        self.backspacepressed = True
#        self.message_buffer.delete(self.message_buffer.get_start_iter(), self.message_buffer.get_end_iter())
#        global self.backspace_pressed
#        global backspace_pressed        
#        self.backspace_pressed = 1
#        print "backspace pressed down"
#        print self.backspace_pressed        
        thread.start_new_thread(self.slow_deletion,(self.lock,"jou", True))      
#        self.slow_deletion("ju", True, "jou")          
        self.backspacepressed = True
        self.slow_deletion("jo", True, "omg")  
    def backspace_up(self, widget):
        self.backspacepressed = False
#        global backspace_pressed
#        self.backspace_pressed = 0
#        print "backspace lifted"          
#        self.slow_deletion("jou", False, "Empty")
        #  this needs to be done better
        #  i=0
        #  while widget.pressed():  
        #    update_text(-1)
        #    time.sleep(1)
        #    i =+1
        #    print "holded " + str(i)


    def send(self, widget):
        start, end = self.message_buffer.get_bounds()
        text = self.message_buffer.get_text(start,end)
        start2, end2 = self.receiver_buffer.get_bounds()
        number = self.receiver_buffer.get_text(start2,end2)
        if number == "":
              note2 = "No receiver number specified!"
              banner = hildon.hildon_banner_show_information(self.window,"" , note2)
              print "error, no number specified!"
        elif text == "":
              note3 = "Message is empty!"
              banner = hildon.hildon_banner_show_information(self.window,"" , note3)
              print "error, message is empty!"
        else:
            confirm = hildon.hildon_note_new_confirmation(self.window, "Send message?")
            response = gtk.Dialog.run(confirm)
            gtk.Dialog.hide(confirm)
            print "response was: " +str(response)

            if response == gtk.RESPONSE_DELETE_EVENT:
                print "sending cancelled"
            elif response == gtk.RESPONSE_OK:
                
                if number.isdigit():                
                    note = "Sending message to: " + number
                    banner = hildon.hildon_banner_show_information(self.window,"" , note)
                    s = sms.SMS(text, number)
                    s.send()
                else:
#                    note = "Sending message to: " + number
#                    banner = hildon.hildon_banner_show_information(self.window,"" , note)
                    numb = number.split(";")
                    i=0
                    while i < len(numb):
                        note = "Sending message to: " + numb[i]
                        banner = hildon.hildon_banner_show_information(self.window,"" , note)
                        s = sms.SMS(text, numb[i])
                        s.send()
#                        print "number " + str(i) + " is: " + numb[i]
                        i = i+1
                        time.sleep(5)


    def timeout(self):
        self.elapsed_time = time.time() - self.last_update
        self.last_update = time.time()

        if self.elapsed_time > self.TIMEOUT:
            return True
        else:
            return False

    def input(self, feed):
        text = self.update_text(0)
        if self.message.is_focus():
#            self.message_buffer.set_text(text + feed)
#            offset = self.message_buffer.get_iter_at_mark(self.message_buffer.get_insert())
            self.message_buffer.insert_at_cursor(feed)
#            insert text to cursor location
        elif self.receiver.is_focus():
#            self.receiver_buffer.set_text(text + feed)
            self.receiver_buffer.insert_at_cursor(feed)
            
    def addrbook(self, widget):
        start, end = self.receiver_buffer.get_bounds()
        oldbuffer = self.receiver_buffer.get_text(start, end)
#        print "oldbuffer: " +oldbuffer        
        osso_abook = ctypes.CDLL('libosso-abook-1.0.so.0')
        argv_type = ctypes.c_char_p * len(sys.argv)
        argv = argv_type(*sys.argv)
        argc = ctypes.c_int(len(sys.argv))
        osso_abook.osso_abook_init(ctypes.byref(argc), ctypes.byref(argv),
                                   hash(self.osso_ctx))
        c_chooser = osso_abook.osso_abook_contact_chooser_new(None, "Choose a contact")
        chooser = self.capi.pygobject_new(c_chooser)
        hildon.hildon_gtk_window_set_portrait_flags(chooser, hildon.PORTRAIT_MODE_SUPPORT)

        

        chooser.run()
        chooser.hide()

        contacts = osso_abook.osso_abook_contact_chooser_get_selection(c_chooser)
        glib = ctypes.CDLL('libglib-2.0.so.0')

        def glist(addr):
            class _GList(ctypes.Structure):
                _fields_ = [('data', ctypes.c_void_p),
                            ('next', ctypes.c_void_p)]
            l = addr
            while l:
                l = _GList.from_address(l)
                yield l.data
                l = l.next

        for i in glist(contacts):
            c_selector = osso_abook.osso_abook_contact_detail_selector_new_for_contact(c_chooser, i, 2) 	

            selector = self.capi.pygobject_new(c_selector)
            hildon.hildon_gtk_window_set_portrait_flags(selector, hildon.PORTRAIT_MODE_SUPPORT)
            selector.run()
            selector.hide()

            c_field = osso_abook.osso_abook_contact_detail_selector_get_selected_field(c_selector)
            get_display_value = osso_abook.osso_abook_contact_field_get_display_value
            get_display_value.restype = ctypes.c_char_p
            finalval = osso_abook.osso_abook_contact_field_get_display_value(c_field)
#            print oldbuffer
            if oldbuffer == "":
                self.receiver_buffer.set_text(finalval)
            else:
                newbuffer = oldbuffer +";" + finalval
                self.receiver_buffer.set_text(newbuffer)

if __name__ == "__main__":
    VertSMS()
