#! /usr/bin/env python
# -*- coding: utf-8 -*-

#
#-------------------------------------------
#VectorMine.pyw - an other vector space shooter
#By Khertan in February, 2010
#-------------------------------------------
#

#import os
import pygame, math, random, os, pickle
from pygame.locals import *
import osso
import sys
VERSION = '1.1.0'

PI = math.pi
PRE_COS_RAD = []
for angle in range(361):
  PRE_COS_RAD.append(math.cos(math.radians(angle)))
PRE_SIN_RAD = []
for angle in range(361):
  PRE_SIN_RAD.append(math.sin(math.radians(angle)))
PRE_RAD = []
for angle in range(361):
  PRE_RAD.append((math.radians(angle)))

def fast_sin(x):
    x = int(x)
    if x < 0:
      return -PRE_SIN_RAD[360+x]
    else:
      return PRE_SIN_RAD[x]

def fast_cos(x):
    x = int(x)
    if x < 0:
      return -PRE_COS_RAD[360+x]
    else:
      return PRE_COS_RAD[x]
MAXX = 800
MAXY = 480

os.environ["SDL_VIDEO_CENTERED"] = "1"
NO_POINTS = []
SHIP_POINTS = [(0, 20), (-20, -20), (0, -10), (20, -20)]
SHOT_POINTS = [(0, 7), (2, -7), (-2, -7)]
BIG_RECT = pygame.Rect((0,0,MAXX,MAXY))
global USE_AA
USE_AA = False

global REGISTERED
REGISTERED = True

name = ""
def NameEdit(screen, font, events):
    global name
    while name.startswith(" "):
        name = name[1:]
    for e in events:
        if e.type == KEYDOWN:
            if e.key == K_BACKSPACE:
                name = name[:-1]
            elif (e.key == K_RETURN) or (e.key==271):
                return name, True
            else:
                name += e.unicode
    ren = font.render("Enter your name:", 1, (255, 255, 255))
    screen.blit(ren, (400-ren.get_width()/2, 280))
    ren = font.render(name + "_", 1, (255, 255, 255))
    screen.blit(ren, (400-ren.get_width()/2, 310))
    while name.startswith(" "):
        name = name[1:]
    return "", False

def GetImei():
    import osso
    ctx = osso.Context('org.example.get_imei', '0.1', False)
    rpc = osso.Rpc(ctx)
    return rpc.rpc_run('com.nokia.phone.SIM', '/com/nokia/phone/SIM/security', 'Phone.Sim.Security', 'get_imei', (), True, True)

serial_code = ""
def LoadSerial():
    global serial_code
    filename = os.path.join("/home/user/", ".vectormine")
    if os.path.exists(filename):
        f = open(filename, "rU")
        serial_code = pickle.load(f)
        f.close()
    else:
        f = open(filename, "wr")
        pickle.dump(serial_code, f)
        f.close()

def SaveSerial():
    global serial_code
    filename = os.path.join("/home/user/", ".vectormine")
    f = open(filename, "wr")
    pickle.dump(serial_code, f)
    f.close()

def SerialCode(screen, font, events):
    global serial_code
    global REGISTERED
    global IMEI
    while serial_code.startswith(" "):
        serial_code = serial_code[1:]
    for e in events:
        if e.type == KEYDOWN:
            if e.key == K_BACKSPACE:
                serial_code = serial_code[:-1]
            elif (e.key == K_RETURN) or (e.key==271):
                code = 0
                for index,num in enumerate(IMEI):
                    code = code + (int(num)+(index*index)) * (index*index)
                if serial_code == hex(code):
                    REGISTERED = True
                    return serial_code, True
                else:
                    ren = font.render("Wrong Code", 1, (255, 255, 255))
                    screen.blit(ren, (400-ren.get_width()/2, 390))
            else:
                serial_code += e.unicode
#    ren = font.render("Precise this number when registering : %s"%(str(GetIMEI)), 1, (255, 255, 255))
#    screen.blit(ren, (240-ren.get_width()/2, 280))
    ren = font.render("Enter your registration code :", 1, (255, 255, 255))
    screen.blit(ren, (400-ren.get_width()/2, 330))
    ren = font.render(serial_code + "_", 1, (255, 255, 255))
    screen.blit(ren, (400-ren.get_width()/2, 360))
#    while serial_code.startswith(" "):
#        serial_code = serial_code[1:]
    return "", False

def __lineCollision(a, b):
    s1 = a[0]
    s2 = b[0]
    e1 = a[1]
    e2 = b[1]
    A = e1[0] - s1[0]
    B = e1[1] - s1[1]
    C = e2[0] - s2[0]
    D = e2[1] - s2[1]
    E = s1[1] - s2[1]
    F = s1[0] - s2[0]

    denom = (D*A)-(C*B)
    if denom == 0:
        return False
    numA = C*E - D*F
    numB = A*E - B*F

    Ta = numA / float(denom)
    Tb = numB / float(denom)

    return (Ta >= -0.5 and Ta <= 1) and (Tb >= -0.5 and Tb <= 1)

def Collision(obj1, obj2):
    l1 = xrange(len(obj1))
    l2 = xrange(len(obj2))
    for a in l1:
        for b in l2:
            if __lineCollision((obj1[a-1], obj1[a]),
                               (obj2[b-1], obj2[b])):
                return True
    return False

class Highscores:
    def __init__(self):

        self.filename = os.path.join("/home/user", ".vectormine_highscores")
        if os.path.exists(self.filename):
            self.file = open(self.filename, "rU")
            self.scores = pickle.load(self.file)
            self.file.close()
        else:
            self.scores = [(15000, "Khertan"),(10000, "Python"), (9000, "Pygame"), (7500, "GTK"), (5000, ""), (2500, ""), (1000, ""), (500, ""), (1, "QT"), (0, "C++")]
            self.file = open(self.filename, "wr")
            pickle.dump(self.scores, self.file)
            self.file.close()
        self.scores.sort(reverse=True)

    def submit_score(self, score, name):
        self.scores.append((score, name))
        self.scores.sort()
        self.scores = self.scores[-10:]
        self.scores.sort(reverse=True)

    def save(self):
        self.file = open(self.filename, "wr")
        pickle.dump(self.scores, self.file)
        self.file.close()

    def draw(self, screen, font):
        y = 170
        x = 140
        for score, name in self.scores:
            ren = font.render("%06d" % score, 1, (255, 255, 255))
            screen.blit(ren, (10 + x, y))
            ren = font.render("%s" % name, 1, (255, 255, 255))
            screen.blit(ren, (110 + x, y))
            y += 25


class Help:

    def __init__(self):

        self.help_txt = """
           VectorMine version %s

Rotate the ship by moving your device.
To move the ship press ctrl key.
To fire press space key.
To teleport press m key.
To pause the game press p key.
To leave a party press q key.
"""%(VERSION)

    def draw(self, screen, font):
        y = 170
        x = 120
        for line in self.help_txt.split('\n'):
            ren = font.render(line, 1, (255, 255, 255))
            screen.blit(ren, (10 + x, y))
            y += 25

class Group(pygame.sprite.Group):
    def draw(self, surface):
        for s in self.sprites():
            s.draw(surface)

class VectorObject(pygame.sprite.DirtySprite):
    def __init__(self, points=NO_POINTS, pos=(0, 0), numpoints=None,level=1):
        pygame.sprite.DirtySprite.__init__(self, self.containers)
        self.points = points
        self.scale = random.choice([0.5, 0.75, 1.0,1.25,1.5])
        self.angle = 0
        self.drawpoints = []
        self.pos = list(pos)
        self.velocity = [0, 0]
        self.color = (255, 255, 255)
        self.numpoints = numpoints
        self.rect = Rect(0, 0, 64, 64)
        self.rect.center = self.pos
#        self.rotate_points()
        self.timer = random.choice([75,100,125,150,200,250,300,350,400,450,500])

    def update(self):
        self.pos[0] -= self.velocity[0]
        self.pos[1] -= self.velocity[1]
        self.rect.center = self.pos
#        if not self.rect.colliderect(BIG_RECT):
#            self.kill()

    def move(self, dx, dy):
      if self.timer == 0:
        self.pos[0] += dx
        self.pos[1] += dy
        self.rect.center = self.pos

    def rotate_points(self):
        self.drawpoints = []
        for p in self.points:
            self.drawpoints.append((p[0]*self.scale+self.pos[0],p[1]*self.scale+self.pos[1]))

    def draw(self, surface):
      if self.timer == 0:
        self.drawpoints = []
        for p in self.points:
            self.drawpoints.append((p[0]*self.scale+self.pos[0],p[1]*self.scale+self.pos[1]))
        pygame.draw.polygon(surface,self.color,self.drawpoints,1)
      else:
        pygame.draw.line(surface,(255,255,255),(self.pos[0],self.pos[1]),(self.pos[0],self.pos[1]))


class Ship(VectorObject):
    def __init__(self):
        VectorObject.__init__(self, points=SHIP_POINTS, pos=(400, 240))
        self.color = (0, 255, 0)
        self.timer = 0
        self.level = 1
        self.score = 0
        self.angle = 180
        self.is_playing_snd = False
        self.dx = 0
        self.dy = 0
        global SOUND_ON
        if SOUND_ON == True:
          self.shoot_sound = pygame.mixer.Sound(os.path.join("/opt/vectormine/data", "fire.wav"))
          self.reactor_sound = pygame.mixer.Sound(os.path.join("/opt/vectormine/data", "reactor.wav"))
          self.reactor_sound.set_volume(0.5)
        else:
          self.shoot_sound = None
          self.reactor_sound = None

    def get_rotation(self):
        f = open("/sys/class/i2c-adapter/i2c-3/3-001d/coord", 'r' )
        coords = int(f.readline().split()[0]) #[int(w) for w in f.readline().split()]
        f.close()
        return coords

    def move(self, dx, dy):
        self.pos[0] += dx
        self.pos[1] += dy
        self.rect.center = self.pos

    def kill_sound(self):
      if self.is_playing_snd == True:
        try:
          self.reactor_sound.stop()
        except:
          pass

    def update(self):
        if self.alive():
            key = pygame.key.get_pressed()
            self.angle = (self.angle - int(self.get_rotation()/20)) % 360
            self.timer += 1
            if self.dx != 0:
                self.dx = self.dx * 0.9
            if self.dy != 0:
                self.dy = self.dy * 0.9

#            if (key[K_LEFT]):
#                self.move(-6, 0)
#            if (key[K_RIGHT]):
#                self.move(6, 0)
            if (key[306]):
                self.dx = self.dx - (fast_sin(self.angle)*2)
                self.dy = self.dy + (fast_cos(self.angle)*2)
                try:
                  if self.is_playing_snd == False:
                    self.reactor_sound.play(-1)
                    self.is_playing_snd = True
                except:
                  pass
            else:
                if self.is_playing_snd == True:
                  try:
                    self.reactor_sound.stop()
                  except:
                    pass
                  self.is_playing_snd = False

#                if self.velocity < 4:
#                    self.velocity = self.velocity + 0.5

            self.move(self.dx,self.dy)

            if self.pos[0] < 0:
                self.pos[0] = 800
            if self.pos[0] > 800:
                self.pos[0] = 0
            if self.pos[1] > 480:
                self.pos[1] = 0
            if self.pos[1] < 0:
                self.pos[1] = 480

            if key[K_m]:
                if self.timer > 5:
                    self.pos[0],self.pos[1] = (random.randint(0,800),random.randint(0,480))
                    ZoomIn(self.pos,self.angle,self.color)
                    self.timer = 0

            if key[K_SPACE]:
                if self.timer > 5:
                    try:
                      self.shoot_sound.play()
                    except:
                      pass
#                    if self.score < 200:
                    Shot(self.pos, self.angle)
#                    elif self.score < 1000:
#                        Shot(self.pos, 8)
#                        Shot(self.pos, -8)
#                    else:
#                        Shot(self.pos, 8,3)
#                        Shot(self.pos, 0)
#                        Shot(self.pos, -8, -3)
                    self.timer = 0

    def draw(self, surface):
        self.drawpoints = []
        for p in self.points:
            newX = int(p[0]*fast_cos(self.angle) - p[1]*fast_sin(self.angle) + self.pos[0])
            newY = int(p[0]*fast_sin(self.angle) + p[1]*fast_cos(self.angle) + self.pos[1])

            self.drawpoints.append((newX,newY))
        pygame.draw.polygon(surface,self.color,self.drawpoints,1)

class Shot(VectorObject):
    def __init__(self, pos, angle=0):
        VectorObject.__init__(self, points=SHOT_POINTS, pos=pos)
#        self.move(offset, 5)
#        self.vx = speedoffset
        self.angle = angle
#        print 'angle',angle
        self.timer = 340

    def move(self, dx, dy):
        self.timer = self.timer - 20
        self.pos[0] += dx
        self.pos[1] += dy
        self.rect.center = self.pos

    def update(self):
        dx = -fast_sin(self.angle)
        dy = fast_cos(self.angle)

        self.move(dx*20,dy*20)

        if self.timer < 0:
            self.kill()
        elif (self.pos[1] <= 0):
          self.pos[1]=480
        elif (self.pos[1] >= 480):
          self.pos[1]=0
        if (self.pos[0] >= 800):
          self.pos[0]=0
        elif (self.pos[0] <= 0):
          self.pos[0]=800

    def draw(self, surface):
        self.drawpoints = []
        for p in self.points:
            newX = int(p[0]*fast_cos(self.angle) - p[1]*fast_sin(self.angle) + self.pos[0])
            newY = int(p[0]*fast_sin(self.angle) + p[1]*fast_cos(self.angle) + self.pos[1])
            self.drawpoints.append((newX,newY))

#            self.drawpoints.append((p[0]+ self.pos[0],p[1]+ self.pos[1]))
        pygame.draw.polygon(surface,self.color,self.drawpoints,1)

class Tri(VectorObject):
    hp = 5
    def __init__(self, pos,level=1):
        VectorObject.__init__(self, points=[(0, 10), (-20, 20), (-10, 0), (-20, -20), (0, -10), (20, -20), (10, 0), (20, 20)], pos=pos)
        self.color = (0, random.randint(150,255), random.randint(150,255))
        self.vx = random.choice([0.25, 0.5, 0.75, 1.0])*2*random.choice([-1, 1])
        self.vy = random.choice([0.25, 0.5, 0.75, 1.0])*3+(level*0.4)
    def update(self):
        self.move(self.vx, self.vy)
        #self.angle += 5*self.vx
        #if self.angle > 360:
        #  self.angle = self.angle - 360
        #elif self.angle < -360:
        #  self.angle = self.angle + 360
        if self.pos[1] > 480:
            self.kill()
    def get_hit(self):
        self.hp -= 1
        if self.hp <= 0:
            self.kill()
            if self.scale >= 1.0:
                for i in range(3):
                    t = Tri(self.pos)
                    t.scale = 0.5
                    t.hp = 2
                    t.color=self.color
#            for i in range(15):
            Particle(self.pos)

class Hex(VectorObject):
    hp = 4
    def __init__(self, pos,level=1):
#        VectorObject.__init__(self, points=[(-20, 0), (0, 20), (20, 0), (0,-20)], pos=pos)
        VectorObject.__init__(self, points=[(-20, 20), (0, 16), (20, 20), (16, 0), (20, -20), (0, -16), (-20,-20), (-16, 0)], pos=pos)
        self.color = (255, 120, 120)
        self.vy = random.choice([0.25, 0.5, 0.75])*5+(level*0.5)
        self.vx = random.choice([-3.0,-2,-1,-0, 1.0,2.0,3.0])
        self.frame = 0

    def update(self):
        self.move(self.vx, self.vy)
        self.angle += int(self.vx)*2
        if self.angle > 360:
          self.angle = self.angle - 360
        if self.angle < -360:
          self.angle = self.angle + 360
        if self.pos[1] > 480:
            self.kill()
        self.pos[0] += fast_sin(PRE_RAD[self.angle])*5

    def get_hit(self):
        self.hp -= 1
        if self.hp <= 0:
            self.kill()
#            for i in range(15):
            Particle(self.pos)

    def draw(self, surface):
        self.drawpoints = []
        for p in self.points:
            newX = int(p[0]*fast_cos(self.angle)*self.scale - p[1]*fast_sin(self.angle)*self.scale + self.pos[0])
            newY = int(p[0]*fast_sin(self.angle)*self.scale + p[1]*fast_cos(self.angle)*self.scale + self.pos[1])
            self.drawpoints.append((newX,newY))
        pygame.draw.polygon(surface,self.color,self.drawpoints,1)

class CircleGrow(VectorObject):
    hp = 4
    def __init__(self, pos,level=1):
#        VectorObject.__init__(self, points=[(-20, 0), (0, 20), (20, 0), (0,-20)], pos=pos)
        VectorObject.__init__(self, points=[(-20, 10), (-10, 20), (10, 20), (20, 10), (20, -10), (10, -20), (-10,-20), (-20, -10)], pos=pos)
        self.color = (255, 180, 50)
        self.vy = random.choice([0.25, 0.5, 0.75,1.0])+(level*0.5)
        self.vx = random.choice([-1.0,-0.5,0.5, 1.0,])*8
        self.scale = random.choice([0.5, 0.75,1.0,1.25,1.5])

    def update(self):
        self.move(self.vx, self.vy)
        self.angle += int(self.vx)
        if self.angle > 359:
          self.angle = self.angle - 360
        if self.angle < -359:
          self.angle = self.angle + 360
        if self.pos[1] > 480:
            self.kill()
        self.pos[0] += self.vx
        if (self.pos[0]>800) or (self.pos[0]<0):
          self.vx = -self.vx

    def get_hit(self):
        self.hp -= 1
        if self.hp <= 0:
            self.kill()
#            for i in range(15):
            Particle(self.pos)
    def draw(self, surface):
        self.drawpoints = []
        for p in self.points:
            newX = int(p[0]*fast_cos(self.angle)*self.scale - p[1]*fast_sin(self.angle)*self.scale + self.pos[0])
            newY = int(p[0]*fast_sin(self.angle)*self.scale + p[1]*fast_cos(self.angle)*self.scale + self.pos[1])
            self.drawpoints.append((newX,newY))
        pygame.draw.polygon(surface,self.color,self.drawpoints,1)

class Square(VectorObject):
    hp = 8
    def __init__(self, pos,level=1):
        VectorObject.__init__(self, points=[(-10, 0), (0, 20), (10, 0), (0, -20)], pos=pos)
        self.color = (255, 255, 0)
        self.vy = random.choice([1.0, 1.5, 2.0,2.5,3.0])+(level*0.5)
        self.vx = random.choice([1.0, 2.0, 3.0,4.0,5.0])
        self.frame = 0
    def update(self):
        #self.angle += self.vx
        #if self.angle > 360:
        #  self.angle = self.angle - 360
        self.vx += random.choice([0.25, 0.5])*random.choice([-1, 1])
        self.vy += random.choice([0.25, 0.5])*random.choice([-1, 1])
        self.angle += self.vx
        if self.angle > 360:
          self.angle = self.angle - 360
        elif self.angle < -360:
          self.angle = self.angle + 360
        self.move(self.vx, self.vy)
        if self.pos[1] > 480:
            self.kill()
        elif self.pos[0] > 800:
            self.kill()
        elif self.pos[0] < 0:
            self.kill()

    def draw(self, surface):
        self.drawpoints = []
        for p in self.points:
            newX = int(p[0]*fast_cos(self.angle)*self.scale - p[1]*fast_sin(self.angle)*self.scale + self.pos[0])
            newY = int(p[0]*fast_sin(self.angle)*self.scale + p[1]*fast_cos(self.angle)*self.scale + self.pos[1])
            self.drawpoints.append((newX,newY))
        pygame.draw.polygon(surface,self.color,self.drawpoints,1)
    def get_hit(self):
        self.hp -= 1
        if self.hp <= 0:
            self.kill()
#            for i in range(15):
            Particle(self.pos)

class Follower(VectorObject):
    hp = 9
    def __init__(self, pos, target,level=1):
        VectorObject.__init__(self, points=[(0, 0), (-8,20), (8,20), (-8,-20), (8,-20), (0,0), (20,8), (20,-8), (-20,8), (-20,-8)], pos=pos)
#        VectorObject.__init__(self, points=[(-20, 20), (0, 35), (20, 20), (35, 0), (20, -20), (0, -35), (-20,-20), (-35, 0)], pos=pos)
        self.color = (255, 0, 0)
        self.scale = random.choice([0.5, 0.75, 1.0, 1.25, 1.5])
        self.vy = random.choice([0.25, 0.5, 0.75])+(level+0.5)
        self.vx = 0
        self.angle = 0
        self.target = target

    def update(self):
        if self.pos[0] < self.target.pos[0] and self.vx < 5:
            self.vx += 0.75
        if self.pos[0] > self.target.pos[0] and self.vx > -5:
            self.vx -= 0.75
        self.move(self.vx, self.vy)
        self.angle += self.vx
        if self.angle > 360:
          self.angle = self.angle - 360
        elif self.angle < -360:
          self.angle = self.angle + 360
        if self.pos[1] > 480:
            self.kill()

    def get_hit(self):
        self.hp -= 1
        if self.hp <= 0:
            self.kill()
            if self.scale >= 1.0:
                for i in range(2):
                    t = Follower(self.pos,self.target)
                    t.scale = 0.5
                    t.hp = 5
#            for i in range(15):
            Particle(self.pos)

    def draw(self, surface):
        self.drawpoints = []
        for p in self.points:
            newX = int(p[0]*fast_cos(self.angle)*self.scale - p[1]*fast_sin(self.angle)*self.scale + self.pos[0])
            newY = int(p[0]*fast_sin(self.angle)*self.scale + p[1]*fast_cos(self.angle)*self.scale + self.pos[1])
            self.drawpoints.append((newX,newY))
        pygame.draw.polygon(surface,self.color,self.drawpoints,1)

class Ennemy1(VectorObject):
    hp = 1
    def __init__(self, pos, target,level=1):
        VectorObject.__init__(self, points=[(5, 5),(0, 25),(-5, 5),(-25, -15),(0, -5),(25, -15) ], pos=pos,level=level)
        self.color = (120, 120, 255)
        self.vy = random.choice([-2,-1,1,2])
        self.vx = random.choice([-2,-1,1,2])
        self.target = target

    def update(self):
        self.move(self.vx, self.vy)
        if self.pos[1] > 480:
            self.pos[1] = 0
        elif self.pos[1] < 0:
            self.pos[1] = 480
        if self.pos[0] > 800:
            self.pos[0] = 0
        elif self.pos[0] < 0:
            self.pos[0] = 800


    def get_hit(self):
      if self.timer == 0:
        self.hp -= 1
        if self.hp <= 0:
            self.kill()
#            for i in range(15):
            Particle(self.pos,self.color)

class Ennemy2(VectorObject):
    hp = 1
    def __init__(self, pos, target,level=1):
        VectorObject.__init__(self, points=[(0, 10), (-20, 20), (-10, 0), (-20, -20), (0, -10), (20, -20), (10, 0), (20, 20)], pos=pos,level=level)
        self.color = (255, 0, 0)
        self.vy = random.choice([-1,1])
        self.vx = random.choice([-1,1])
        self.target = target

    def update(self):
        if self.pos[0] < self.target.pos[0] and self.vx < 2:
            self.vx += 0.5
        if self.pos[0] > self.target.pos[0] and self.vx > -2:
            self.vx -= 0.5
        if self.pos[1] < self.target.pos[1] and self.vy < 2:
            self.vy += 0.5
        if self.pos[1] > self.target.pos[1] and self.vy > -2:
            self.vy -= 0.5
        self.move(self.vx, self.vy)
        if self.pos[1] > 480:
            self.pos[1] = 0
        elif self.pos[1] < 0:
            self.pos[1] = 480
        if self.pos[0] > 800:
            self.pos[0] = 0
        elif self.pos[0] < 0:
            self.pos[0] = 800

    def get_hit(self):
      if self.timer == 0:
        self.hp -= 1
        if self.hp <= 0:
            self.kill()
#            for i in range(15):
            Particle(self.pos,self.color)

class Ennemy3(VectorObject):
    hp = 1
    def __init__(self, pos, level=1):
        VectorObject.__init__(self, points=[(0, 25),(-5, 5),(-25, -15),(0, -5),(25, -15),(5, 5),(0,25),(0,-5) ], pos=pos,level=level)
        self.color = (255, 200, 10)
        self.vy = random.choice([-2,-1,1,2])
        self.vx = random.choice([-2,-1,1,2])
        self.scale = 1

    def update(self):
        self.move(self.vx, self.vy)
        if self.pos[1] > 480:
            self.pos[1] = 0
        elif self.pos[1] < 0:
            self.pos[1] = 480
        if self.pos[0] > 800:
            self.pos[0] = 0
        elif self.pos[0] < 0:
            self.pos[0] = 800

    def get_hit(self):
      if self.timer == 0:
        self.hp -= 1
        if self.hp <= 0:
            if self.scale == 1:
              for i in range(2):
                e = Ennemy3(self.pos)
                e.scale = 0.5
                e.timer = 0
            else:
              Particle(self.pos,self.color)
            self.kill()

class Ennemy4(VectorObject):
    hp = 1
    def __init__(self, pos, target,level=1):
        VectorObject.__init__(self, points=[(0,5),(0,15),(0,5),(5,0),(15,0),(5,0),(0,-5),(0,-15),(0,-5),(-5,0),(-15,0),(-5,0)], pos=pos,level=level)
        self.color = (255, 120, 0)
        self.vy = random.choice([-2,-1,1,2])
        self.vx = random.choice([-2,-1,1,2])
        self.target = target
        self.scale = 1

    def update(self):
        self.move(self.vx, self.vy)
        if self.pos[1] > 480:
          if self.scale == 1:
            self.pos[1] = 0
          else:
            self.kill()
        elif self.pos[1] < 0:
          if self.scale == 1:
            self.pos[1] = 480
          else:
            self.kill()
        if self.pos[0] > 800:
          if self.scale == 1:
            self.pos[0] = 0
          else:
            self.kill()
        elif self.pos[0] < 0:
          if self.scale == 1:
            self.pos[0] = 800
          else:
            self.kill()

    def get_hit(self):
      if self.timer == 0:
        self.hp -= 1
        if self.hp <= 0:
          if self.scale == 0.25:
            self.kill()
            Particle(self.pos,self.color)
          else:
            Particle(self.pos,self.color)
            self.hp=1
            self.scale = 0.25
            self.vx = self.vx * 4
            self.vy = self.vy * 4

class Ennemy5(VectorObject):
    hp = 1
    def __init__(self, pos, target,level=1):
        VectorObject.__init__(self, points=[(0, 10),(0,-10),(0,10),(-20, 20), (-10, 0),(10,0),(-10,0), (-20, -20), (0, -10), (20, -20), (10, 0), (20, 20)], pos=pos,level=level)
        self.color = (255, 50, 0)
        self.vy = random.choice([-1,1])
        self.vx = random.choice([-1,1])
        self.target = target
        self.scale = 1

    def update(self):
        if self.scale == 1:
          if self.pos[0] < self.target.pos[0] and self.vx < 2:
              self.vx += 0.5
          if self.pos[0] > self.target.pos[0] and self.vx > -2:
              self.vx -= 0.5
          if self.pos[1] < self.target.pos[1] and self.vy < 2:
              self.vy += 0.5
          if self.pos[1] > self.target.pos[1] and self.vy > -2:
              self.vy -= 0.5

        self.move(self.vx, self.vy)
        if self.pos[1] > 480:
          if self.scale == 1:
            self.pos[1] = 0
          else:
            self.kill()
        elif self.pos[1] < 0:
          if self.scale == 1:
            self.pos[1] = 480
          else:
            self.kill()
        if self.pos[0] > 800:
          if self.scale == 1:
            self.pos[0] = 0
          else:
            self.kill()
        elif self.pos[0] < 0:
          if self.scale == 1:
            self.pos[0] = 800
          else:
            self.kill()

    def get_hit(self):
      if self.timer == 0:
        self.hp -= 1
        if self.hp <= 0:
          if self.scale == 0.25:
            self.kill()
            Particle(self.pos,self.color)
          else:
            Particle(self.pos,self.color)
            self.hp=1
            self.scale = 0.25
            self.vx = self.vx * 4
            self.vy = self.vy * 4

class Particle(VectorObject):
    def __init__(self, pos,color=(255,255,255)):
        VectorObject.__init__(self, points=[(10, 10), (-10, 10), (-10, -10), (10, -10)], pos=pos)
        self.color = color
        self.pos = pos
        self.points = []
        for i in range(20):
          self.points.append((random.randint(-10,10),random.randint(-10,10)))
#        self.angle = random.randrange(360)
#        self.velocity = random.choice([0.1, 0.2, 0.3, 0.4, 0.5])*10
        self.velocity = 0
        self.vx = 0
        self.vy = 0
#        self.vx = random.randint(-8,8)
#        self.vy = random.randint(-8,8)
#        self.alpha = 255
        self.scale = 1

    def update(self):
#        self.alpha -= 20
#        print 'test'
        self.scale = self.scale + 1
        if self.scale >= 8:
            self.kill()
#        self.move(self.vx,self.vy)
#        self.move(PRE_SIN_RAD[self.angle]*self.velocity, PRE_COS_RAD[self.angle]*self.velocity)
#        self.image.set_alpha(self.alpha)

    def draw(self, surface):
      for p in self.points:
          pygame.draw.line(surface,self.color,(self.pos[0],self.pos[1]),(self.pos[0]+self.scale*(p[0]),self.pos[1]+self.scale*(p[1])))

class ZoomIn(VectorObject):
    def __init__(self, pos,angle,color):
        VectorObject.__init__(self, points=SHIP_POINTS, pos=pos)
        self.color = color
        self.pos = pos
        self.velocity = 0
        self.vx = 0
        self.vy = 0
        self.scale = 8
        self.angle = angle

    def update(self):
        self.scale = self.scale - 1
        if self.scale <= 0:
            self.kill()

    def draw(self, surface):
        self.drawpoints = []
        for p in self.points:
            newX = self.scale*(int(p[0]*fast_cos(self.angle) - p[1]*fast_sin(self.angle))) + self.pos[0]
            newY = self.scale*(int(p[0]*fast_sin(self.angle) + p[1]*fast_cos(self.angle))) + self.pos[1]

            self.drawpoints.append((newX,newY))
        pygame.draw.polygon(surface,self.color,self.drawpoints,1)

class Star(pygame.sprite.DirtySprite):

    def __init__(self):
        pygame.sprite.DirtySprite.__init__(self, self.containers)
        self.size = random.randrange(1, 4)
        self.image = pygame.Surface((self.size, self.size))
        self.pos = [random.randrange(800), random.randrange(480)]
        self.speed = random.choice([0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5])*15
        self.color = (self.speed*32, self.speed*32, self.speed*32)
        self.image.fill(self.color)
    def update(self):
        self.pos[1] += self.speed
        if self.pos[1] >= 480:
            self.pos[1] = 0
    def draw(self, surface):
        surface.blit(self.image, self.pos)

def exit_now():
    pygame.event.clear()
    pygame.mixer.stop()
#    print 'test exit'
    if pygame.mixer.get_busy():
        pygame.mixer.quit()
    pygame.quit()
    sys.exit()
    return

def Menu(screen):
    font = pygame.font.Font(os.path.join("/opt/vectormine/data", "block.ttf"), 30)
    font2 = pygame.font.Font(os.path.join("/opt/vectormine/data", "block.ttf"), 80)
    font3 = pygame.font.Font(os.path.join("/opt/vectormine/data", "block.ttf"), 20)
#    pygame.mixer.music.load(os.path.join("data", "Epic.ogg"))
#    pygame.mixer.music.play()
    stars = Group()
    shapes = Group()
    Star.containers = stars
#    Tri.containers = shapes
#    Hex.containers = shapes
#    Follower.containers = shapes
#    Square.containers = shapes
#    Octo.containers = shapes
#    CircleGrow.containers = shapes
    clock = pygame.time.Clock()
    for i in range(75):
        Star()
    color = 0
    additive = 3
    option = 1
    highscores = Highscores()
    global REGISTERED
    global SOUND_ON

    def update_containers():
        Star.containers = stars
#        Tri.containers = shapes
#        Hex.containers = shapes
#        Follower.containers = shapes
#        Square.containers = shapes
#        Octo.containers = shapes
#        CircleGrow.containers = shapes

    while 1:

        clock.tick(30) #was 60
        stars.update()
#        shapes.update()
        update_containers()

        for e in pygame.event.get():
            if e.type == QUIT:
              exit_now()
              return
            if e.type == MOUSEBUTTONDOWN:
                print e.pos
                if (e.pos[0]>100) and (e.pos[0]<700):
                  if (e.pos[1]>255) and (e.pos[1]<=285): #270
                    option = 1
                  elif (e.pos[1]>285) and (e.pos[1]<=315): #270
                    option = 2
                  elif (e.pos[1]>315) and (e.pos[1]<=345): #270
                    option = 3
                  elif (e.pos[1]>345) and (e.pos[1]<=375): #270
                    option = 4
                  elif (e.pos[1]>375) and (e.pos[1]<=405): #270
                    option = 5
                  elif (e.pos[1]>405) and (e.pos[1]<=435): #270
                    option = 6

            if e.type == KEYDOWN:
                if e.key == K_ESCAPE:
                  exit_now()
                  return
                if (e.key == K_UP) or (e.key == K_RIGHT):
                    option -= 1
                if (e.key == K_DOWN) or (e.key == K_LEFT):
                    option += 1
                if (e.key == K_RETURN) or (e.key==271):
                    if option == 1:
                        Game(screen)
                        HighscoreMenu(screen)
#                        pygame.mixer.music.load(os.path.join("data", "Epic.ogg"))
#                        pygame.mixer.music.play()
                    if option == 2:
                        HighscoreMenu(screen)
                    if option == 4:
                        HelpMenu(screen)
                    if option == 3:
                        SOUND_ON = not SOUND_ON
                    if (option == 5) and not REGISTERED:
                        RegisterMenu(screen)
                    elif ((option == 5) and REGISTERED) or (option == 6):
                        exit_now()
                        return

#        if not random.randrange(25):
#            Tri((random.randrange(800), 0))
#        if not random.randrange(25):
#            Hex((random.randrange(800), 0))
#        if not random.randrange(25):
#            Square((random.randrange(800), 0))

        if option < 1:
            if REGISTERED:
                option = 5
            else:
                option = 6
        if ((option > 5) and REGISTERED) or (option >6):
            option = 1

        color += additive
        if color > 255:
            additive = -additive
            color = 255
        if color < 0:
            additive = -additive
            color = 0

        screen.fill((0, 0, 0))
        stars.draw(screen)
        shapes.draw(screen)

        ren = font2.render("VectorMine", 1, (255, 150, 0))
        screen.blit(ren, (392-ren.get_width()/2, 52))
        ren = font2.render("VectorMine", 1, (color, 0,0))
        screen.blit(ren, (390-ren.get_width()/2, 50))

#        ren = font3.render("Copyright (C) 2010", 1, (150, 75, 0))
#        screen.blit(ren, (391-ren.get_width()/2, 201))
#        ren = font3.render("By Khertan", 1, (150, 75, 0))
#        screen.blit(ren, (391-ren.get_width()/2, 221))
        ren = font3.render("GPLv3 Since 14 Jully 2010", 1, (255, 150, 0))
        screen.blit(ren, (390-ren.get_width()/2, 200))
        ren = font3.render("By Khertan", 1, (255, 150, 0))
        screen.blit(ren, (390-ren.get_width()/2, 220))

        ren = font.render("New Game", 1, (75, 50, 0))
        screen.blit(ren, (391-ren.get_width()/2, 271))
        ren = font.render("High Scores", 1, (75, 50, 0))
        screen.blit(ren, (391-ren.get_width()/2, 301))
        if SOUND_ON == True:
          ren = font.render("Sounds On", 1, (75, 50, 0))
        else:
          ren = font.render("Sounds Off", 1, (75, 50, 0))
        screen.blit(ren, (391-ren.get_width()/2, 331))
        ren = font.render("Help", 1, (75, 50, 0))
        screen.blit(ren, (391-ren.get_width()/2, 361))
        if REGISTERED:
          ren = font.render("Quit Game", 1, (75, 50, 0))
          screen.blit(ren, (391-ren.get_width()/2, 391))
        else:
          ren = font.render("Register", 1, (75, 50, 0))
          screen.blit(ren, (391-ren.get_width()/2, 391))
          ren = font.render("Quit Game", 1, (75, 50, 0))
          screen.blit(ren, (391-ren.get_width()/2, 421))

#        ren = font.render("New Game", 1, (150, 0, 150))
#        screen.blit(ren, (390-ren.get_width()/2, 300))
#        ren = font.render("High Scores", 1, (150, 0, 150))
#        screen.blit(ren, (390-ren.get_width()/2, 330))
#        ren = font.render("Quit Game", 1, (150, 0, 150))
#        screen.blit(ren, (390-ren.get_width()/2, 360))

        if option == 1:
            ren = font.render("> New Game <", 1, (255, 200, 0))
            screen.blit(ren, (390-ren.get_width()/2, 270))
        if option == 2:
            ren = font.render("> High Scores <", 1, (255, 200, 0))
            screen.blit(ren, (390-ren.get_width()/2, 300))
        if option == 3:
            if SOUND_ON == True:
              ren = font.render("> Sounds On <", 1, (255, 200, 0))
            else:
              ren = font.render("> Sounds Off <", 1, (255, 200, 0))
            screen.blit(ren, (390-ren.get_width()/2, 330))
        if option == 4:
            ren = font.render("> Help <", 1, (255, 200, 0))
            screen.blit(ren, (390-ren.get_width()/2, 360))
        if option == 5:
            if REGISTERED:
                ren = font.render("> Quit Game <", 1, (255, 200, 0))
                screen.blit(ren, (390-ren.get_width()/2, 390))
            else:
                ren = font.render("> Register <", 1, (255, 200, 0))
                screen.blit(ren, (390-ren.get_width()/2, 390))
        if option == 6:
            ren = font.render("> Quit Game <", 1, (255, 200, 0))
            screen.blit(ren, (390-ren.get_width()/2, 420))

        pygame.display.flip()

def HighscoreMenu(screen):
    font = pygame.font.Font(os.path.join("/opt/vectormine/data", "block.ttf"), 30)
    font2 = pygame.font.Font(os.path.join("/opt/vectormine/data", "block.ttf"), 80)
    font3 = pygame.font.Font(os.path.join("/opt/vectormine/data", "block.ttf"), 20)
    stars = Group()
    shapes = Group()
    Star.containers = stars
#    Tri.containers = shapes
#    Hex.containers = shapes
#    Square.containers = shapes
#    Octo.containers = shapes
#    CircleGrow.containers = shapes
    clock = pygame.time.Clock()
    for i in range(50):
        Star()
    color = 0
    additive = 3
    highscores = Highscores()

    while 1:

        clock.tick(30)
        stars.update()
#        shapes.update()

        for e in pygame.event.get():
            if (e.type == QUIT):
                pygame.quit()
                return
            if e.type == KEYDOWN:
                if e.key == K_ESCAPE:
                    return
                if (e.key == K_RETURN) or (e.key == 271):
                    return

#        if not random.randrange(25):
#            Tri((random.randrange(800), 0))
#        if not random.randrange(25):
#            Hex((random.randrange(800), 0))
#        if not random.randrange(25):
#            Square((random.randrange(800), 0))

        color += additive
        if color > 255:
            additive = -additive
            color = 255
        if color < 0:
            additive = -additive
            color = 0
        screen.fill((0, 0, 0))
        stars.draw(screen)
        shapes.draw(screen)

        ren = font2.render("Highscores", 1, (255, 150, 0))
        screen.blit(ren, (392-ren.get_width()/2, 52))
        ren = font2.render("Highscores", 1, (color,0, 0))
        screen.blit(ren, (390-ren.get_width()/2, 50))
        ren = font.render("Press Enter to go to menu", 1, (color,color, 0))
        screen.blit(ren, (390-ren.get_width()/2, 430))
        highscores.draw(screen, font3)

        pygame.display.flip()

def HelpMenu(screen):
    font = pygame.font.Font(os.path.join("/opt/vectormine/data", "block.ttf"), 30)
    font2 = pygame.font.Font(os.path.join("/opt/vectormine/data", "block.ttf"), 80)
    font3 = pygame.font.Font(os.path.join("/opt/vectormine/data", "block.ttf"), 20)
    stars = Group()
    shapes = Group()
    Star.containers = stars
#    Tri.containers = shapes
#    Hex.containers = shapes
#    Square.containers = shapes
#    Octo.containers = shapes
#    CircleGrow.containers = shapes
    clock = pygame.time.Clock()
    for i in range(50):
        Star()
    color = 0
    additive = 3
    help = Help()

    while 1:

        clock.tick(30)
        stars.update()
#        shapes.update()

        for e in pygame.event.get():
            if (e.type == QUIT):
                pygame.quit()
                return
            if e.type == KEYDOWN:
                if e.key == K_ESCAPE:
                    return
                if (e.key == K_RETURN) or (e.key == 271):
                    return

        color += additive
        if color > 255:
            additive = -additive
            color = 255
        if color < 0:
            additive = -additive
            color = 0
        screen.fill((0, 0, 0))
        stars.draw(screen)
        shapes.draw(screen)

        ren = font2.render("Help", 1, (255, 150, 0))
        screen.blit(ren, (392-ren.get_width()/2, 52))
        ren = font2.render("Help", 1, (color, 0, 0))
        screen.blit(ren, (390-ren.get_width()/2, 50))
        ren = font.render("Press Enter to go to menu", 1, (color,color, 0))
        screen.blit(ren, (390-ren.get_width()/2, 430))
        help.draw(screen, font)

        pygame.display.flip()

def RegisterMenu(screen):
    font = pygame.font.Font('/usr/lib/python2.5/site-packages/pygame/freesansbold.ttf', 20)
    font2 = pygame.font.Font(os.path.join("/opt/vectormine/data", "block.ttf"), 80)
    font3 = pygame.font.Font(os.path.join("/opt/vectormine/data", "block.ttf"), 20)
    stars = Group()
    shapes = Group()
    Star.containers = stars
    open_browser = "run-standalone.sh /usr/bin/browser --url=http://khertan.net/shop.php"
#    Tri.containers = shapes
#    Hex.containers = shapes
#    Square.containers = shapes
#    Octo.containers = shapes
#    CircleGrow.containers = shapes
    clock = pygame.time.Clock()
    for i in range(50):
        Star()
    color = 0
    additive = 3
#    help = Help()

    global IMEI
    IMEI = str(GetImei())

    while 1:

        clock.tick(30)
        stars.update()
#        shapes.update()

        events = pygame.event.get()
        for e in events:
            if (e.type == QUIT):
                pygame.quit()
                return
            if e.type == KEYDOWN:
                if e.key == K_SPACE:
                    return
            if e.type == MOUSEBUTTONDOWN:
#                import commands
                from subprocess import Popen
#                commands.getoutput(open_browser)
                Popen(open_browser,shell=True,stdout=None)

        color += additive
        if color > 255:
            additive = -additive
            color = 255
        if color < 0:
            additive = -additive
            color = 0
        screen.fill((0, 0, 0))
        stars.draw(screen)
        shapes.draw(screen)

        ren = font2.render("Register", 1, (255, 150, 0))
        screen.blit(ren, (392-ren.get_width()/2, 52))
        ren = font2.render("Register", 1, (color, 0, 0))
        screen.blit(ren, (390-ren.get_width()/2, 50))
        ren = font.render("VectorMine was a 1 Euro Shareware and is now since 14 Jully 2010 a Freeware.", 1, (255,255, 255))
        screen.blit(ren, (390-ren.get_width()/2, 190))
        ren = font.render("Visit http://khertan.net/shop.php to register it", 1, (255,255, 255))
        screen.blit(ren, (390-ren.get_width()/2, 220))
        ren = font3.render("Press space to cancel or touch screen to open web site", 1, (color,color, 0))
        screen.blit(ren, (390-ren.get_width()/2, 430))

        ren = font.render(("Identify number : %s"%(IMEI)), 1, (255,255, 255))
        screen.blit(ren, (390-ren.get_width()/2, 260))

        code, done = SerialCode(screen, font, events)
        if done:
            SaveSerial()
            return

        pygame.display.flip()

def Game(screen):
    all = Group()
    shots = Group()
    enemies = Group()
    particles = Group()
    Ship.containers = all
    Shot.containers = all, shots
#    Tri.containers = all, enemies
#    Hex.containers = all, enemies
#    Square.containers = all, enemies
#    Follower.containers = all, enemies
    Ennemy1.containers = all, enemies
    Ennemy2.containers = all, enemies
    Ennemy3.containers = all, enemies
    Ennemy4.containers = all, enemies
    Ennemy5.containers = all, enemies
#    CircleGrow.containers = all, enemies
#    Star.containers = stars
    Particle.containers = all, particles
    ZoomIn.containers = all, particles
    clock = pygame.time.Clock()
    ship = Ship()
    score = 0
    paused = False
    level = 1
    lives = 5
    font = pygame.font.Font(os.path.join("/opt/vectormine/data", "block.ttf"), 25)
    font2 = pygame.font.Font(os.path.join("/opt/vectormine/data", "block.ttf"), 60)

    global SOUND_ON
    if SOUND_ON == True:
      explode_sound = pygame.mixer.Sound(os.path.join("/opt/vectormine/data", "explode.wav"))
      plop_sound = pygame.mixer.Sound(os.path.join("/opt/vectormine/data", "plop.wav"))
      reactor_sound = pygame.mixer.Sound(os.path.join("/opt/vectormine/data", "reactor.wav"))
      fire_sound = pygame.mixer.Sound(os.path.join("/opt/vectormine/data", "fire.wav"))
    else:
      explode_sound = None
      plop_sound = None
      reactor_sound = None
      fire_sound = None

    timer = 150
    highscores = Highscores()
    saved_score = False

    #set timer to stop sceen blanking
    pygame.time.set_timer(pygame.NUMEVENTS-1, 15000)
    osso_c = osso.Context("net.khertan.vectormine", VERSION, False)
    device = osso.DeviceState(osso_c)

#    global USE_AA
    global REGISTERED

    if not REGISTERED:
        pygame.time.set_timer(pygame.NUMEVENTS-2, 150000)

    for i in range(9+level):
      Ennemy1((random.randrange(800), random.randrange(480)), ship,level)

    while 1:
        clock.tick(30)
        if timer > 0:
            timer -= 1

        events = pygame.event.get()
        for e in events:
            if e.type == pygame.NUMEVENTS-1:
              if not paused:
                device.display_blanking_pause()
            elif e.type == pygame.NUMEVENTS-2:
                RegisterMenu(screen)
                lives = 0
                ship.kill_sound()
                ship.kill()

            if e.type == QUIT:
                pygame.quit()
                return
            if e.type == KEYDOWN:
                if (e.key == K_ESCAPE) or (e.key == K_q):
                    return
                elif (e.key == K_p):
                    paused = not(paused)
                    pygame.display.toggle_fullscreen()

                    if paused:
                        timer = 40

        if len(enemies.sprites())==0:
          level = level + 1
          timer = 150
          for i in range(int(9+level*0.5)):
            if level>4:
              if random.randint(0,level-5)>1:
                Ennemy5((random.randrange(800), random.randrange(480)),ship,level)
            if level>2:
              if random.randint(0,level-3)>1:
                Ennemy4((random.randrange(800), random.randrange(480)),level)
            if level>1:
              if random.randint(0,level-2)>1:
                Ennemy3((random.randrange(800), random.randrange(480)),level)
            if random.randint(0,level-1)>0:
              Ennemy2((random.randrange(800), random.randrange(480)), ship,level)
            else:
              Ennemy1((random.randrange(800), random.randrange(480)), ship,level)


        if not paused:
            for s in enemies.sprites():
                if timer <= 0:
                  if s.timer > 0:
                    s.timer = s.timer - 1
                    if s.timer == 0:
                      try:
                        plop_sound.play()
                      except:
                        pass
                s.update()
                e = s
                for s in shots:
                    if e.rect.colliderect(s.rect):
                        if Collision(e.drawpoints, s.drawpoints):
                            s.kill()
                            e.get_hit()
                            if e.hp <= 0:
                              try:
                                explode_sound.play()
                              except:
                                pass
#                            boom_sound.play()
#                            Particle(s.pos)
                            score += 5*level
                            ship.score += 5

                if e.rect.colliderect(ship.rect):
                    if Collision(e.drawpoints, ship.drawpoints) and ship.alive():
                        ship.kill_sound()
                        ship.kill()
                        lives -= 1
                        try:
                          explode_sound.play()
                        except:
                          pass
#                        for i in xrange(75):
                        Particle(ship.pos,ship.color)

            ship.update()
            for s in shots.sprites():
                s.update()

            particles.update()

            if not ship.alive() and lives > 0 and not particles:
                level = level - 1
                for s in all.sprites():
                    s.kill()
                ship = Ship()

        screen.fill((0, 0, 0))
        if paused:
            ren = font2.render("Paused", 1, (255, 255, 255))
            screen.blit(ren, (390-ren.get_width()/2, 240-ren.get_height()/2))
#        else:
#          stars.draw(screen)
        all.draw(screen)
        ren = font.render("Score: %06d" % score, 1, (255, 200, 0))
        screen.blit(ren, (10, 10))
        ren = font.render("Lives x%d" % lives, 1, (255, 200, 0))
        screen.blit(ren, (10, 35))
        ren = font.render("Mine field: %d" % level, 1, (255, 200, 0))
        screen.blit(ren, (650, 10))
        ren = font.render("FPS: %d" % clock.get_fps(), 1, (255, 200, 0))
        screen.blit(ren, (10, 440))
        if lives <= 0:
            if not saved_score:
                nick, done = NameEdit(screen, font, events)
                if done:
                    highscores.submit_score(score, nick)
                    highscores.save()
                    saved_score = True
                    return
            ren = font2.render("Game Over!", 1, (255, 255, 255))
            screen.blit(ren, (390-ren.get_width()/2, 240-ren.get_height()/2))
        if (timer > 0) and (not paused):
            ren = font2.render("Mine field %s"%(level,), 1, (255, 255, 255))
            screen.blit(ren, (390-ren.get_width()/2, 140-ren.get_height()/2))
#        if timer > 0 and timer <= 75 and (not paused):
#            ren = font2.render("Go!", 1, (255, 255, 255))
#            screen.blit(ren, (390-ren.get_width()/2, 240-ren.get_height()/2))
        pygame.display.flip()
    pygame.time.set_timer(pygame.NUMEVENTS-1, 0)


def main():
#    os.nice(-20)
    pygame.init()
    os.putenv("SDL_VIDEO_X11_WMCLASS", "VectorMine")
    pygame.display.set_caption("VectorMine")
    osso_c = osso.Context("net.khertan.vectormine", VERSION, False)
    screen = pygame.display.set_mode((MAXX, MAXY),FULLSCREEN)
    pygame.mouse.set_visible(0)
    LoadSerial()
    global REGISTERED
    code = 0
    for index,num in enumerate(str(GetImei())):
      code = code + (int(num)+(index*index)) * (index*index)
    LoadSerial()
    if serial_code == hex(code):
      REGISTERED = True
#    pygame.display.toggle_fullscreen()
    try:
      pygame.mixer.init(22050,-8,1,512)
    except:
      pass
    global SOUND_ON
    SOUND_ON = True
    Menu(screen)

if __name__ == "__main__":
    main()
