#ifndef MAINWINDOW_H
#define MAINWINDOW_H

/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

#include <QtGui/QMainWindow>

#include "elv1db.h"

#include <QListWidget>

class QTableWidget;
class QTableWidgetItem;
class QListWidget;

class MainWindow : public QMainWindow
{
    Q_OBJECT
public:
    enum ScreenOrientation {
        ScreenOrientationLockPortrait,
        ScreenOrientationLockLandscape,
        ScreenOrientationAuto
    };

    explicit MainWindow(QWidget *parent = 0);
    virtual ~MainWindow();

    // Note that this will only have an effect on Symbian and Fremantle.
    void setOrientation(ScreenOrientation orientation);

    void showExpanded();

private slots:
    void dlgAbout();
    void clearLog();
    void dlgOptions();
    void elv1db_finised();

    void start_indicator();
    void stop_indicator();

    void elv1db_detail_finised();

    void cellClicked(int, int);

    void detail_start_indicator();

    void select_gsm_calls();
    void select_all_call();

    void select_all_typecall();
    void select_incoming_calls();
    void select_outgoing_calls();
    void select_missed_calls();

    void dlgSearch();
    void noSearch();

private:
    QTableWidget *m_contacts_widget;
    QListWidget *m_contact_detail;

    QMainWindow *dlg_options;

    void setup_menu();
    void setup_menu_detail();

    void doSearch(QString val);

    elv1db *m_elv1db;
    uint m_type_query_temp;
    bool m_in_search;
    QAction *m_no_search;

    QMainWindow *detail_dlg;

    void me_indicator(QMainWindow*, bool);
};

#endif // MAINWINDOW_H
