/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

#ifndef ELV1DB_H
#define ELV1DB_H

#include <QThread>
#include <QtSql/QSqlDatabase>
#include <QIcon>
#include <QDateTime>

#define H_TOTAL_GROUP_BY "select remote_name, count(*) from Events E, Remotes R where R.remote_uid=E.remote_uid and E.local_uid=R.local_uid %1 %2 group by remote_name order by start_time desc"
#define H_TOTAL_GROUP_BY_AND_SEARCH "select remote_name, count(*) from Events E, Remotes R where R.remote_uid=E.remote_uid and E.local_uid=R.local_uid %1 %2 %3 group by remote_name order by start_time desc"
#define H_DEFAULT_SEARCH "select event_type_id, start_time, end_time, is_read, E.local_uid, E.remote_uid, free_text, outgoing, remote_name from Events E, Remotes R where R.remote_uid=E.remote_uid and E.local_uid=R.local_uid %1 order by start_time desc limit %2"

#define P_TYPE_GSM_NETWORK  "ring/tel/ring"
#define P_TYPE_SKYPE        "spirit/skype"
#define P_TYPE_JABBER       "gabble/jabber"

#define ICONS_ROOT_DIR "/usr/share/icons/hicolor/"

#define IMG_AVATAR      ICONS_ROOT_DIR "48x48/hildon/general_default_avatar.png"
#define IMG_OUTGOING    ICONS_ROOT_DIR "48x48/hildon/general_sent.png"
#define IMG_INCOMING    ICONS_ROOT_DIR "48x48/hildon/general_received.png"
#define IMG_MISSED      ICONS_ROOT_DIR "48x48/hildon/general_missed.png"

#define IMG_CELL        ICONS_ROOT_DIR "32x32/hildon/call_status_cellular.png"
#define IMG_SKYPE       ICONS_ROOT_DIR "32x32/hildon/general_skype.png"
#define IMG_GOOGLE      ICONS_ROOT_DIR "32x32/hildon/general_gtalk.png"
#define IMG_SIP         ICONS_ROOT_DIR "32x32/hildon/general_sip.png"
#define IMG_OVI         ICONS_ROOT_DIR "32x32/hildon/general_ovi.png"
#define IMG_JABBER      ICONS_ROOT_DIR "32x32/hildon/general_jabber.png"

/*
  The record class for group by informations first screen
  */
class elv1rec : public QObject
{
    Q_OBJECT
public:

    elv1rec():
        m_avatar(QIcon::fromTheme( "general_default_avatar", QIcon(IMG_AVATAR)))
    {
    }

    QString contact_name() const{
        return m_contact_name;
    }

    QString total_call() const{
        return m_total_call;
    }

    QIcon avatar() const{
        return m_avatar;
    }

    void set_contact_name(QString contact_name){
        m_contact_name = contact_name;
    }

    void set_total_call(QString total_call){
        m_total_call = total_call;
    }

    void set_avatar(QIcon avatar){
        m_avatar = avatar;
    }

private:
    QString m_contact_name;
    QString m_total_call;
    QIcon m_avatar;
};

/*
  The record class for detail informations second screen
  */
enum PhoneType { GSM_NETWORK = 0, SKYPE = 1, JABBER = 2, GOOGLE_TALK = 3, UNKNOW = 4};
enum CallType { OUTGOING = 0, INCOMING = 1, MISSED = 2, ALL_CALL = 3};

class elv1Detailrec : public QObject
{
    Q_OBJECT

public:

    elv1Detailrec()
    {}

    void set_phonenumber(QString phonenumber){ m_phonenumber = phonenumber;}
    void set_starttime(uint starttime){ m_starttime.setTime_t(starttime);}
    void set_endtime(uint endtime){ m_endtime.setTime_t(endtime);}
    void set_calltype(CallType calltype){
        m_calltype = calltype;
        m_icon = QIcon::fromTheme(calltype==OUTGOING?
                                      "general_sent":calltype==INCOMING?
                                          "general_received":"general_missed", QIcon(calltype==OUTGOING?
                                                                                         IMG_OUTGOING:calltype==INCOMING?
                                                                                             IMG_INCOMING:IMG_MISSED));

    }

    void set_phonetype(PhoneType phonetype){
        m_phonetype = phonetype;
        QString _m_icon_meta;
        QString _m_icon_path;
        switch (phonetype){
            case GSM_NETWORK:
                _m_icon_meta = "call_status_cellular";
                _m_icon_path = IMG_CELL;
                break;
            case SKYPE:
                _m_icon_meta = "general_skype";
                _m_icon_path = IMG_SKYPE;
                break;
            case JABBER:
                _m_icon_meta = "general_jabber";
                _m_icon_path = IMG_JABBER;
                break;
            case GOOGLE_TALK:
                _m_icon_meta = "general_gtalk";
                _m_icon_path = IMG_GOOGLE;
                break;
            default:
                _m_icon_meta = "call_status_unknow";
                _m_icon_path = "unknow";
                break;
        }

        m_type_call_icon = QIcon::fromTheme(_m_icon_meta, QIcon(_m_icon_path));
    }

    void set_callduration(uint callduration){ m_callduration = callduration;}

    QString get_phonenumber() const { return m_phonenumber;}
    QIcon get_icon() const { return m_icon;}
    QIcon get_type_call_icon() const { return m_type_call_icon;}
    QTime get_starttime() const { return m_starttime.time();}
    QTime get_endtime() const { return m_endtime.time();}
    QDate get_startdate() const { return m_starttime.date();}
    QDate get_enddate() const { return m_endtime.date();}
    CallType get_calltype() const { return m_calltype;}
    uint get_duration() const { return m_callduration;}

private:
    QIcon m_icon; //incoming/outgoing/missed call icons
    QIcon m_type_call_icon; //cell/skype/sip/jingle/...
    QString m_phonenumber;
    QDateTime m_starttime;
    QDateTime m_endtime;
    CallType m_calltype;
    PhoneType m_phonetype;
    uint m_callduration;
};

/*
  The main db management class
  *MUST* be inherited QThread
  */


class elv1db : public QThread
{
    Q_OBJECT
public:
    explicit elv1db(QObject *parent = 0);
    ~elv1db();

    void run();

    void setQuery(QString o_query) {
        m_query = o_query;
    }

    QString m_contact_name;

    QList<elv1rec*> m_records;
    QList<elv1Detailrec*> m_detail_records;

    uint m_type_query;

    bool m_all_call;
    CallType m_call_type;

    QString *m_search_val;

signals:
    void start_indicator();
    void group_by_finished();
    void detail_finished();
    void detail_start_indicator();

private:
    QSqlDatabase m_db;
    QString m_query;

    PhoneType phonetype(QString metastr);
    QString calltype();
};

#endif // ELV1DB_H
