/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

#include "elv1db.h"

#include <QtSql/QSqlQuery>
#include <QtSql/QSqlRecord>

#include <QString>
#include <QVariant>

#include <QDebug>

elv1db::elv1db(QObject *parent):
    QThread(parent),
    m_type_query(0),
    m_search_val(new QString("")),
    m_db(QSqlDatabase::addDatabase("QSQLITE"))
{
    m_db.setDatabaseName("/home/user/.rtcom-eventlogger/el-v1.db");
    m_db.open();
}

elv1db::~elv1db(){
    if (m_db.isOpen())
        m_db.close();
    delete this->m_search_val;
}

PhoneType elv1db::phonetype(QString metastr){
    if (metastr.contains("ring/tel/ring"))
        return GSM_NETWORK;
    else if (metastr.contains("spirit/skype"))
        return SKYPE;
    else if (metastr.contains("gabble/jabber") && metastr.contains("40gmail_2ecom0"))
        return GOOGLE_TALK;
    else if (metastr.contains("gabble/jabber"))
        return JABBER;
    return UNKNOW;
}

QString elv1db::calltype(){
    return this->m_call_type==ALL_CALL?"and (event_type_id = 1 or event_type_id = 2)":
                                                      this->m_call_type==INCOMING?"and event_type_id = 1  and outgoing = 0":
                                                      this->m_call_type==OUTGOING?"and event_type_id = 1  and outgoing = 1":"and event_type_id = 2";
}

void elv1db::run(){
    if (this->m_type_query == 0 || this->m_type_query == 2)
        emit start_indicator();
    else
        emit detail_start_indicator();

    sleep(1);

    if (this->m_type_query == 0){ //all
        QString m_group_by_call(H_TOTAL_GROUP_BY);
        setQuery(m_group_by_call
                 .arg(this->m_all_call?"":"and E.local_uid='ring/tel/ring'")
                 .arg(calltype()));
    }
    else if (this->m_type_query == 2 ){ //doSearch
        QString m_group_by_and_search_call(H_TOTAL_GROUP_BY_AND_SEARCH);
        QString m_search_val_convert("and remote_name like '%%1%'");
        m_search_val_convert = m_search_val_convert.arg(*this->m_search_val);

        setQuery(m_group_by_and_search_call
                 .arg(this->m_all_call?"":"and E.local_uid='ring/tel/ring'")
                 .arg(calltype())
                 .arg(m_search_val_convert));
    }
    else { // for contact details
        QString m_filter(" and remote_name = '%1' %2 ");
        m_filter = m_filter.arg(m_contact_name).arg(calltype());
        QString m_default_search = QString(H_DEFAULT_SEARCH).arg(m_filter).arg(100);
        setQuery(m_default_search);
    }

    QSqlQuery *query = new QSqlQuery(this->m_query);
    QSqlRecord record = query->record();
    if(record.count() > 0){
        if (this->m_type_query == 0 || this->m_type_query == 2){
            this->m_records.clear();
              while (query->next()) {
                  elv1rec *ef=new elv1rec();
                  ef->set_contact_name(query->value(0).value<QString>());
                  ef->set_total_call(query->value(1).value<QString>());
                  this->m_records << ef;
              }
        }
        else{

            this->m_detail_records.clear();

            while (query->next()) {
                elv1Detailrec *ef=new elv1Detailrec();

                int calltype =  query->value(0).value< int >();

                if (calltype == 1 || calltype == 2){
                    ef->set_phonenumber(query->value(5).value<QString>());
                    ef->set_starttime(query->value(1).value<uint>());
                    ef->set_endtime(query->value(2).value<uint>());
                    if (query->value(2).value<uint>())
                        ef->set_callduration(query->value(2).value<uint>() - query->value(1).value<uint>());
                    else
                        ef->set_callduration(0);
                    if (calltype == 1) //call (outgoing/incoming)
                        ef->set_calltype(query->value(7).value<bool>()?OUTGOING:INCOMING);
                    else // call but missed
                        ef->set_calltype(MISSED);

                    ef->set_phonetype(
                                this->phonetype(query->value(4).value<QString>())
                                );

                    this->m_detail_records << ef;
                }

            }
        }
    }

    delete query;

    if (this->m_type_query == 0 || this->m_type_query == 2)
        emit group_by_finished();
    else
        emit detail_finished();
}
