/*
Copyright (C) 2011  by Cuong Le <metacuong@gmail.com>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

#include "listitemdetaildelegate.h"

listitemdetailDelegate::listitemdetailDelegate(QObject*)
{
}

listitemdetailDelegate::~listitemdetailDelegate(){

}

void listitemdetailDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    QString header = index.data(Qt::DisplayRole).toString();

    QRect r = option.rect;

    if (!header.isNull()){
        r.adjust(0,10,0,-10);
        QLinearGradient gradientSelected(r.left(),r.top(),r.left(),r.height()+r.top());
        gradientSelected.setColorAt(0.0, QColor::fromRgb(119,213,247));
        gradientSelected.setColorAt(0.9, QColor::fromRgb(27,134,183));
        gradientSelected.setColorAt(1.0, QColor::fromRgb(0,120,174));
        painter->setBrush(gradientSelected);
        painter->drawRect(r);

        painter->setPen(Qt::blue);
        painter->setFont(QFont("Nokia Sans", 18, QFont::Normal));
        painter->drawText(r.left(), r.top(), r.width(), r.height(), Qt::AlignCenter, header, &r);
    }else{
        painter->setPen(Qt::white);
        QString phone_number = index.data(Qt::UserRole + 1).toString();
        QString start_end = index.data(Qt::UserRole + 2).toString();
        QIcon icon_type =  QIcon(qvariant_cast<QIcon>(index.data(Qt::UserRole+4)));
        QIcon icon_call_type =  QIcon(qvariant_cast<QIcon>(index.data(Qt::UserRole+5)));

        painter->setFont(QFont("Nokia Sans", 16, QFont::Normal));
        icon_type.paint(painter, r, Qt::AlignVCenter|Qt::AlignLeft);
        icon_call_type.paint(painter, r, Qt::AlignVCenter|Qt::AlignRight);

        r = option.rect.adjusted(55, 0, -10, -30);
        painter->setFont(QFont("Nokia Sans", 18, QFont::Bold));
        painter->drawText(r.left(), r.top(), r.width(), r.height(), Qt::AlignBottom|Qt::AlignLeft, phone_number, &r);

        painter->setFont(QFont("Nokia Sans", 14, QFont::Normal));
        r = option.rect.adjusted(55, 30, -10, -10);
        painter->drawText(r.left(), r.top(), r.width(), r.height(), Qt::AlignBottom|Qt::AlignLeft, start_end, &r);
    }
}

QSize listitemdetailDelegate::sizeHint(const QStyleOptionViewItem&, const QModelIndex&) const {
    return QSize(200, 70);
}
