/* valageniescanner.c generated by valac, the Vala compiler
 * generated from valageniescanner.vala, do not modify */

/* valageniescanner.vala
 *
 * Copyright (C) 2008  Jamie McCracken, Jürg Billeter
 * Based on code by Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jamie McCracken jamiemcc gnome org
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define VALA_GENIE_TYPE_SCANNER (vala_genie_scanner_get_type ())
#define VALA_GENIE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GENIE_TYPE_SCANNER, ValaGenieScanner))
#define VALA_GENIE_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GENIE_TYPE_SCANNER, ValaGenieScannerClass))
#define VALA_GENIE_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GENIE_TYPE_SCANNER))
#define VALA_GENIE_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GENIE_TYPE_SCANNER))
#define VALA_GENIE_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GENIE_TYPE_SCANNER, ValaGenieScannerClass))

typedef struct _ValaGenieScanner ValaGenieScanner;
typedef struct _ValaGenieScannerClass ValaGenieScannerClass;
typedef struct _ValaGenieScannerPrivate ValaGenieScannerPrivate;

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;

#define VALA_GENIE_TYPE_TOKEN_TYPE (vala_genie_token_type_get_type ())

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;

#define VALA_GENIE_SCANNER_TYPE_CONDITIONAL (vala_genie_scanner_conditional_get_type ())
typedef struct _ValaGenieScannerConditional ValaGenieScannerConditional;
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_comment_unref0(var) ((var == NULL) ? NULL : (var = (vala_comment_unref (var), NULL)))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define VALA_TYPE_SOURCE_LOCATION (vala_source_location_get_type ())
typedef struct _ValaSourceLocation ValaSourceLocation;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;
typedef struct _ValaGenieParamSpecScanner ValaGenieParamSpecScanner;

struct _ValaGenieScanner {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaGenieScannerPrivate * priv;
};

struct _ValaGenieScannerClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGenieScanner *self);
};

typedef enum  {
	VALA_GENIE_TOKEN_TYPE_NONE,
	VALA_GENIE_TOKEN_TYPE_ABSTRACT,
	VALA_GENIE_TOKEN_TYPE_ARRAY,
	VALA_GENIE_TOKEN_TYPE_AS,
	VALA_GENIE_TOKEN_TYPE_ASSERT,
	VALA_GENIE_TOKEN_TYPE_ASSIGN,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_ADD,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_AND,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_OR,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_XOR,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_DIV,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_MUL,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_PERCENT,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_SHIFT_LEFT,
	VALA_GENIE_TOKEN_TYPE_ASSIGN_SUB,
	VALA_GENIE_TOKEN_TYPE_ASYNC,
	VALA_GENIE_TOKEN_TYPE_BITWISE_AND,
	VALA_GENIE_TOKEN_TYPE_BITWISE_OR,
	VALA_GENIE_TOKEN_TYPE_BREAK,
	VALA_GENIE_TOKEN_TYPE_CARRET,
	VALA_GENIE_TOKEN_TYPE_CASE,
	VALA_GENIE_TOKEN_TYPE_CHARACTER_LITERAL,
	VALA_GENIE_TOKEN_TYPE_CLASS,
	VALA_GENIE_TOKEN_TYPE_CLOSE_BRACE,
	VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET,
	VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS,
	VALA_GENIE_TOKEN_TYPE_COLON,
	VALA_GENIE_TOKEN_TYPE_COMMA,
	VALA_GENIE_TOKEN_TYPE_CONST,
	VALA_GENIE_TOKEN_TYPE_CONSTRUCT,
	VALA_GENIE_TOKEN_TYPE_CONTINUE,
	VALA_GENIE_TOKEN_TYPE_DEDENT,
	VALA_GENIE_TOKEN_TYPE_DEF,
	VALA_GENIE_TOKEN_TYPE_DEFAULT,
	VALA_GENIE_TOKEN_TYPE_DELEGATE,
	VALA_GENIE_TOKEN_TYPE_DELETE,
	VALA_GENIE_TOKEN_TYPE_DICT,
	VALA_GENIE_TOKEN_TYPE_DIV,
	VALA_GENIE_TOKEN_TYPE_DO,
	VALA_GENIE_TOKEN_TYPE_DOT,
	VALA_GENIE_TOKEN_TYPE_DOWNTO,
	VALA_GENIE_TOKEN_TYPE_DYNAMIC,
	VALA_GENIE_TOKEN_TYPE_ELLIPSIS,
	VALA_GENIE_TOKEN_TYPE_ELSE,
	VALA_GENIE_TOKEN_TYPE_ENUM,
	VALA_GENIE_TOKEN_TYPE_ENSURES,
	VALA_GENIE_TOKEN_TYPE_ERRORDOMAIN,
	VALA_GENIE_TOKEN_TYPE_EOF,
	VALA_GENIE_TOKEN_TYPE_EOL,
	VALA_GENIE_TOKEN_TYPE_EVENT,
	VALA_GENIE_TOKEN_TYPE_EXCEPT,
	VALA_GENIE_TOKEN_TYPE_EXTERN,
	VALA_GENIE_TOKEN_TYPE_FALSE,
	VALA_GENIE_TOKEN_TYPE_FINAL,
	VALA_GENIE_TOKEN_TYPE_FINALLY,
	VALA_GENIE_TOKEN_TYPE_FOR,
	VALA_GENIE_TOKEN_TYPE_GET,
	VALA_GENIE_TOKEN_TYPE_HASH,
	VALA_GENIE_TOKEN_TYPE_IDENTIFIER,
	VALA_GENIE_TOKEN_TYPE_IF,
	VALA_GENIE_TOKEN_TYPE_IMPLEMENTS,
	VALA_GENIE_TOKEN_TYPE_IN,
	VALA_GENIE_TOKEN_TYPE_INDENT,
	VALA_GENIE_TOKEN_TYPE_INIT,
	VALA_GENIE_TOKEN_TYPE_INLINE,
	VALA_GENIE_TOKEN_TYPE_INTEGER_LITERAL,
	VALA_GENIE_TOKEN_TYPE_INTERFACE,
	VALA_GENIE_TOKEN_TYPE_INTERNAL,
	VALA_GENIE_TOKEN_TYPE_INTERR,
	VALA_GENIE_TOKEN_TYPE_IS,
	VALA_GENIE_TOKEN_TYPE_ISA,
	VALA_GENIE_TOKEN_TYPE_LAMBDA,
	VALA_GENIE_TOKEN_TYPE_LIST,
	VALA_GENIE_TOKEN_TYPE_LOCK,
	VALA_GENIE_TOKEN_TYPE_MINUS,
	VALA_GENIE_TOKEN_TYPE_NAMESPACE,
	VALA_GENIE_TOKEN_TYPE_NEW,
	VALA_GENIE_TOKEN_TYPE_NULL,
	VALA_GENIE_TOKEN_TYPE_OF,
	VALA_GENIE_TOKEN_TYPE_OUT,
	VALA_GENIE_TOKEN_TYPE_OP_AND,
	VALA_GENIE_TOKEN_TYPE_OP_DEC,
	VALA_GENIE_TOKEN_TYPE_OP_EQ,
	VALA_GENIE_TOKEN_TYPE_OP_GE,
	VALA_GENIE_TOKEN_TYPE_OP_GT,
	VALA_GENIE_TOKEN_TYPE_OP_INC,
	VALA_GENIE_TOKEN_TYPE_OP_LE,
	VALA_GENIE_TOKEN_TYPE_OP_LT,
	VALA_GENIE_TOKEN_TYPE_OP_NE,
	VALA_GENIE_TOKEN_TYPE_OP_NEG,
	VALA_GENIE_TOKEN_TYPE_OP_OR,
	VALA_GENIE_TOKEN_TYPE_OP_PTR,
	VALA_GENIE_TOKEN_TYPE_OP_SHIFT_LEFT,
	VALA_GENIE_TOKEN_TYPE_OPEN_BRACE,
	VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET,
	VALA_GENIE_TOKEN_TYPE_OPEN_PARENS,
	VALA_GENIE_TOKEN_TYPE_OVERRIDE,
	VALA_GENIE_TOKEN_TYPE_OWNED,
	VALA_GENIE_TOKEN_TYPE_PARAMS,
	VALA_GENIE_TOKEN_TYPE_PASS,
	VALA_GENIE_TOKEN_TYPE_PERCENT,
	VALA_GENIE_TOKEN_TYPE_PLUS,
	VALA_GENIE_TOKEN_TYPE_PRINT,
	VALA_GENIE_TOKEN_TYPE_PRIVATE,
	VALA_GENIE_TOKEN_TYPE_PROP,
	VALA_GENIE_TOKEN_TYPE_PROTECTED,
	VALA_GENIE_TOKEN_TYPE_PUBLIC,
	VALA_GENIE_TOKEN_TYPE_RAISE,
	VALA_GENIE_TOKEN_TYPE_RAISES,
	VALA_GENIE_TOKEN_TYPE_REAL_LITERAL,
	VALA_GENIE_TOKEN_TYPE_READONLY,
	VALA_GENIE_TOKEN_TYPE_REF,
	VALA_GENIE_TOKEN_TYPE_REQUIRES,
	VALA_GENIE_TOKEN_TYPE_RETURN,
	VALA_GENIE_TOKEN_TYPE_SEMICOLON,
	VALA_GENIE_TOKEN_TYPE_SET,
	VALA_GENIE_TOKEN_TYPE_SIZEOF,
	VALA_GENIE_TOKEN_TYPE_STAR,
	VALA_GENIE_TOKEN_TYPE_STATIC,
	VALA_GENIE_TOKEN_TYPE_STRING_LITERAL,
	VALA_GENIE_TOKEN_TYPE_STRUCT,
	VALA_GENIE_TOKEN_TYPE_SUPER,
	VALA_GENIE_TOKEN_TYPE_THIS,
	VALA_GENIE_TOKEN_TYPE_TILDE,
	VALA_GENIE_TOKEN_TYPE_TO,
	VALA_GENIE_TOKEN_TYPE_TRUE,
	VALA_GENIE_TOKEN_TYPE_TRY,
	VALA_GENIE_TOKEN_TYPE_TYPEOF,
	VALA_GENIE_TOKEN_TYPE_UNOWNED,
	VALA_GENIE_TOKEN_TYPE_USES,
	VALA_GENIE_TOKEN_TYPE_VAR,
	VALA_GENIE_TOKEN_TYPE_VERBATIM_STRING_LITERAL,
	VALA_GENIE_TOKEN_TYPE_VIRTUAL,
	VALA_GENIE_TOKEN_TYPE_VOID,
	VALA_GENIE_TOKEN_TYPE_VOLATILE,
	VALA_GENIE_TOKEN_TYPE_WEAK,
	VALA_GENIE_TOKEN_TYPE_WHEN,
	VALA_GENIE_TOKEN_TYPE_WHILE,
	VALA_GENIE_TOKEN_TYPE_WRITEONLY,
	VALA_GENIE_TOKEN_TYPE_YIELD
} ValaGenieTokenType;

struct _ValaGenieScannerConditional {
	gboolean matched;
	gboolean else_found;
	gboolean skip_section;
};

struct _ValaGenieScannerPrivate {
	ValaSourceFile* _source_file;
	gint _indent_spaces;
	gchar* begin;
	gchar* current;
	gchar* end;
	gint line;
	gint column;
	gint current_indent_level;
	gint indent_level;
	gint pending_dedents;
	gint open_parens_count;
	gint open_brace_count;
	ValaGenieTokenType last_token;
	gboolean parse_started;
	ValaComment* _comment;
	ValaGenieScannerConditional* conditional_stack;
	gint conditional_stack_length1;
	gint conditional_stack_size;
};

struct _ValaSourceLocation {
	gchar* pos;
	gint line;
	gint column;
};

struct _ValaGenieParamSpecScanner {
	GParamSpec parent_instance;
};


static gpointer vala_genie_scanner_parent_class = NULL;

gpointer vala_genie_scanner_ref (gpointer instance);
void vala_genie_scanner_unref (gpointer instance);
GParamSpec* vala_genie_param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_genie_value_set_scanner (GValue* value, gpointer v_object);
gpointer vala_genie_value_get_scanner (const GValue* value);
GType vala_genie_scanner_get_type (void);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void);
GType vala_genie_token_type_get_type (void);
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void);
static GType vala_genie_scanner_conditional_get_type (void);
static ValaGenieScannerConditional* vala_genie_scanner_conditional_dup (const ValaGenieScannerConditional* self);
static void vala_genie_scanner_conditional_free (ValaGenieScannerConditional* self);
#define VALA_GENIE_SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_GENIE_TYPE_SCANNER, ValaGenieScannerPrivate))
enum  {
	VALA_GENIE_SCANNER_DUMMY_PROPERTY
};
static void vala_genie_scanner_set_source_file (ValaGenieScanner* self, ValaSourceFile* value);
gchar* vala_source_file_get_mapped_contents (ValaSourceFile* self);
gsize vala_source_file_get_mapped_length (ValaSourceFile* self);
ValaGenieScanner* vala_genie_scanner_new (ValaSourceFile* source_file);
ValaGenieScanner* vala_genie_scanner_construct (GType object_type, ValaSourceFile* source_file);
static gboolean vala_genie_scanner_is_ident_char (ValaGenieScanner* self, gchar c);
static gboolean vala_genie_scanner_matches (ValaGenieScanner* self, gchar* begin, const char* keyword);
static ValaGenieTokenType vala_genie_scanner_get_identifier_or_keyword (ValaGenieScanner* self, gchar* begin, gint len);
static void vala_genie_scanner_space (ValaGenieScanner* self);
static void vala_genie_scanner_skip_space_tabs (ValaGenieScanner* self);
static inline gboolean vala_genie_scanner_newline (ValaGenieScanner* self);
static gboolean vala_genie_scanner_skip_newlines (ValaGenieScanner* self);
static gint vala_genie_scanner_count_tabs (ValaGenieScanner* self);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void);
void vala_report_error (ValaSourceReference* source, const char* message);
ValaSourceFile* vala_genie_scanner_get_source_file (ValaGenieScanner* self);
ValaSourceReference* vala_source_reference_new (ValaSourceFile* _file, gint _first_line, gint _first_column, gint _last_line, gint _last_column);
ValaSourceReference* vala_source_reference_construct (GType object_type, ValaSourceFile* _file, gint _first_line, gint _first_column, gint _last_line, gint _last_column);
GType vala_source_location_get_type (void);
ValaSourceLocation* vala_source_location_dup (const ValaSourceLocation* self);
void vala_source_location_free (ValaSourceLocation* self);
ValaGenieTokenType vala_genie_scanner_read_token (ValaGenieScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end);
static void vala_genie_scanner_pp_directive (ValaGenieScanner* self);
static gboolean vala_genie_scanner_whitespace (ValaGenieScanner* self);
static void vala_genie_scanner_push_comment (ValaGenieScanner* self, const char* comment_item, ValaSourceReference* source_reference, gboolean file_comment);
static gboolean vala_genie_scanner_comment (ValaGenieScanner* self, gboolean file_comment);
static gboolean vala_genie_scanner_skip_tabs (ValaGenieScanner* self);
void vala_genie_scanner_parse_file_comments (ValaGenieScanner* self);
ValaComment* vala_comment_new (const char* comment, ValaSourceReference* _source_reference);
ValaComment* vala_comment_construct (GType object_type, const char* comment, ValaSourceReference* _source_reference);
void vala_source_file_add_comment (ValaSourceFile* self, ValaComment* comment);
ValaComment* vala_genie_scanner_pop_comment (ValaGenieScanner* self);
static gboolean vala_genie_scanner_pp_whitespace (ValaGenieScanner* self);
static void vala_genie_scanner_parse_pp_if (ValaGenieScanner* self);
static void vala_genie_scanner_parse_pp_elif (ValaGenieScanner* self);
static void vala_genie_scanner_parse_pp_else (ValaGenieScanner* self);
static void vala_genie_scanner_parse_pp_endif (ValaGenieScanner* self);
static void vala_genie_scanner_pp_eol (ValaGenieScanner* self);
static gboolean vala_genie_scanner_parse_pp_expression (ValaGenieScanner* self);
static void _vala_array_add3 (ValaGenieScannerConditional** array, int* length, int* size, const ValaGenieScannerConditional* value);
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void);
ValaCodeContext* vala_source_file_get_context (ValaSourceFile* self);
gboolean vala_code_context_is_defined (ValaCodeContext* self, const char* define);
static gboolean vala_genie_scanner_parse_pp_symbol (ValaGenieScanner* self);
static gboolean vala_genie_scanner_parse_pp_primary_expression (ValaGenieScanner* self);
static gboolean vala_genie_scanner_parse_pp_unary_expression (ValaGenieScanner* self);
static gboolean vala_genie_scanner_parse_pp_equality_expression (ValaGenieScanner* self);
static gboolean vala_genie_scanner_parse_pp_and_expression (ValaGenieScanner* self);
static gboolean vala_genie_scanner_parse_pp_or_expression (ValaGenieScanner* self);
gint vala_genie_scanner_get_indent_spaces (ValaGenieScanner* self);
void vala_genie_scanner_set_indent_spaces (ValaGenieScanner* self, gint value);
static void vala_genie_scanner_finalize (ValaGenieScanner* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaGenieScanner* vala_genie_scanner_construct (GType object_type, ValaSourceFile* source_file) {
	ValaGenieScanner* self;
	g_return_val_if_fail (source_file != NULL, NULL);
	self = (ValaGenieScanner*) g_type_create_instance (object_type);
	vala_genie_scanner_set_source_file (self, source_file);
	self->priv->begin = vala_source_file_get_mapped_contents (source_file);
	self->priv->end = self->priv->begin + vala_source_file_get_mapped_length (source_file);
	self->priv->current = self->priv->begin;
	self->priv->_indent_spaces = 0;
	self->priv->line = 1;
	self->priv->column = 1;
	self->priv->current_indent_level = 0;
	self->priv->indent_level = 0;
	self->priv->pending_dedents = 0;
	self->priv->open_parens_count = 0;
	self->priv->open_brace_count = 0;
	self->priv->parse_started = FALSE;
	self->priv->last_token = VALA_GENIE_TOKEN_TYPE_NONE;
	return self;
}


ValaGenieScanner* vala_genie_scanner_new (ValaSourceFile* source_file) {
	return vala_genie_scanner_construct (VALA_GENIE_TYPE_SCANNER, source_file);
}


static gboolean vala_genie_scanner_is_ident_char (ValaGenieScanner* self, gchar c) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (g_ascii_isalnum (c)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = c == '_';
	}
	result = _tmp0_;
	return result;
}


static ValaGenieTokenType vala_genie_scanner_get_identifier_or_keyword (ValaGenieScanner* self, gchar* begin, gint len) {
	ValaGenieTokenType result;
	g_return_val_if_fail (self != NULL, 0);
	switch (len) {
		case 2:
		{
			switch (begin[0]) {
				case 'a':
				{
					if (vala_genie_scanner_matches (self, begin, "as")) {
						result = VALA_GENIE_TOKEN_TYPE_AS;
						return result;
					}
					break;
				}
				case 'd':
				{
					if (vala_genie_scanner_matches (self, begin, "do")) {
						result = VALA_GENIE_TOKEN_TYPE_DO;
						return result;
					}
					break;
				}
				case 'i':
				{
					switch (begin[1]) {
						case 'f':
						{
							result = VALA_GENIE_TOKEN_TYPE_IF;
							return result;
						}
						case 'n':
						{
							result = VALA_GENIE_TOKEN_TYPE_IN;
							return result;
						}
						case 's':
						{
							result = VALA_GENIE_TOKEN_TYPE_IS;
							return result;
						}
					}
					break;
				}
				case 'o':
				{
					if (vala_genie_scanner_matches (self, begin, "of")) {
						result = VALA_GENIE_TOKEN_TYPE_OF;
						return result;
					}
					if (vala_genie_scanner_matches (self, begin, "or")) {
						result = VALA_GENIE_TOKEN_TYPE_OP_OR;
						return result;
					}
					break;
				}
				case 't':
				{
					if (vala_genie_scanner_matches (self, begin, "to")) {
						result = VALA_GENIE_TOKEN_TYPE_TO;
						return result;
					}
					break;
				}
			}
			break;
		}
		case 3:
		{
			switch (begin[0]) {
				case 'a':
				{
					if (vala_genie_scanner_matches (self, begin, "and")) {
						result = VALA_GENIE_TOKEN_TYPE_OP_AND;
						return result;
					}
					break;
				}
				case 'd':
				{
					if (vala_genie_scanner_matches (self, begin, "def")) {
						result = VALA_GENIE_TOKEN_TYPE_DEF;
						return result;
					}
					break;
				}
				case 'f':
				{
					if (vala_genie_scanner_matches (self, begin, "for")) {
						result = VALA_GENIE_TOKEN_TYPE_FOR;
						return result;
					}
					break;
				}
				case 'g':
				{
					if (vala_genie_scanner_matches (self, begin, "get")) {
						result = VALA_GENIE_TOKEN_TYPE_GET;
						return result;
					}
					break;
				}
				case 'i':
				{
					if (vala_genie_scanner_matches (self, begin, "isa")) {
						result = VALA_GENIE_TOKEN_TYPE_ISA;
						return result;
					}
					break;
				}
				case 'n':
				{
					switch (begin[1]) {
						case 'e':
						{
							if (vala_genie_scanner_matches (self, begin, "new")) {
								result = VALA_GENIE_TOKEN_TYPE_NEW;
								return result;
							}
							break;
						}
						case 'o':
						{
							if (vala_genie_scanner_matches (self, begin, "not")) {
								result = VALA_GENIE_TOKEN_TYPE_OP_NEG;
								return result;
							}
							break;
						}
					}
					break;
				}
				case 'o':
				{
					if (vala_genie_scanner_matches (self, begin, "out")) {
						result = VALA_GENIE_TOKEN_TYPE_OUT;
						return result;
					}
					break;
				}
				case 'r':
				{
					if (vala_genie_scanner_matches (self, begin, "ref")) {
						result = VALA_GENIE_TOKEN_TYPE_REF;
						return result;
					}
					break;
				}
				case 's':
				{
					if (vala_genie_scanner_matches (self, begin, "set")) {
						result = VALA_GENIE_TOKEN_TYPE_SET;
						return result;
					}
					break;
				}
				case 't':
				{
					if (vala_genie_scanner_matches (self, begin, "try")) {
						result = VALA_GENIE_TOKEN_TYPE_TRY;
						return result;
					}
					break;
				}
				case 'v':
				{
					if (vala_genie_scanner_matches (self, begin, "var")) {
						result = VALA_GENIE_TOKEN_TYPE_VAR;
						return result;
					}
					break;
				}
			}
			break;
		}
		case 4:
		{
			switch (begin[0]) {
				case 'c':
				{
					if (vala_genie_scanner_matches (self, begin, "case")) {
						result = VALA_GENIE_TOKEN_TYPE_CASE;
						return result;
					}
					break;
				}
				case 'd':
				{
					if (vala_genie_scanner_matches (self, begin, "dict")) {
						result = VALA_GENIE_TOKEN_TYPE_DICT;
						return result;
					}
					break;
				}
				case 'e':
				{
					switch (begin[1]) {
						case 'l':
						{
							if (vala_genie_scanner_matches (self, begin, "else")) {
								result = VALA_GENIE_TOKEN_TYPE_ELSE;
								return result;
							}
							break;
						}
						case 'n':
						{
							if (vala_genie_scanner_matches (self, begin, "enum")) {
								result = VALA_GENIE_TOKEN_TYPE_ENUM;
								return result;
							}
							break;
						}
					}
					break;
				}
				case 'i':
				{
					if (vala_genie_scanner_matches (self, begin, "init")) {
						result = VALA_GENIE_TOKEN_TYPE_INIT;
						return result;
					}
					break;
				}
				case 'l':
				{
					switch (begin[1]) {
						case 'i':
						{
							if (vala_genie_scanner_matches (self, begin, "list")) {
								result = VALA_GENIE_TOKEN_TYPE_LIST;
								return result;
							}
							break;
						}
						case 'o':
						{
							if (vala_genie_scanner_matches (self, begin, "lock")) {
								result = VALA_GENIE_TOKEN_TYPE_LOCK;
								return result;
							}
							break;
						}
					}
					break;
				}
				case 'n':
				{
					if (vala_genie_scanner_matches (self, begin, "null")) {
						result = VALA_GENIE_TOKEN_TYPE_NULL;
						return result;
					}
					break;
				}
				case 'p':
				{
					switch (begin[1]) {
						case 'a':
						{
							if (vala_genie_scanner_matches (self, begin, "pass")) {
								result = VALA_GENIE_TOKEN_TYPE_PASS;
								return result;
							}
							break;
						}
						case 'r':
						{
							if (vala_genie_scanner_matches (self, begin, "prop")) {
								result = VALA_GENIE_TOKEN_TYPE_PROP;
								return result;
							}
							break;
						}
					}
					break;
				}
				case 's':
				{
					if (vala_genie_scanner_matches (self, begin, "self")) {
						result = VALA_GENIE_TOKEN_TYPE_THIS;
						return result;
					}
					break;
				}
				case 't':
				{
					if (vala_genie_scanner_matches (self, begin, "true")) {
						result = VALA_GENIE_TOKEN_TYPE_TRUE;
						return result;
					}
					break;
				}
				case 'u':
				{
					if (vala_genie_scanner_matches (self, begin, "uses")) {
						result = VALA_GENIE_TOKEN_TYPE_USES;
						return result;
					}
					break;
				}
				case 'v':
				{
					if (vala_genie_scanner_matches (self, begin, "void")) {
						result = VALA_GENIE_TOKEN_TYPE_VOID;
						return result;
					}
					break;
				}
				case 'w':
				{
					switch (begin[1]) {
						case 'e':
						{
							if (vala_genie_scanner_matches (self, begin, "weak")) {
								result = VALA_GENIE_TOKEN_TYPE_WEAK;
								return result;
							}
							break;
						}
						case 'h':
						{
							if (vala_genie_scanner_matches (self, begin, "when")) {
								result = VALA_GENIE_TOKEN_TYPE_WHEN;
								return result;
							}
							break;
						}
					}
					break;
				}
			}
			break;
		}
		case 5:
		{
			switch (begin[0]) {
				case 'a':
				{
					switch (begin[1]) {
						case 'r':
						{
							if (vala_genie_scanner_matches (self, begin, "array")) {
								result = VALA_GENIE_TOKEN_TYPE_ARRAY;
								return result;
							}
							break;
						}
						case 's':
						{
							if (vala_genie_scanner_matches (self, begin, "async")) {
								result = VALA_GENIE_TOKEN_TYPE_ASYNC;
								return result;
							}
							break;
						}
					}
					break;
				}
				case 'b':
				{
					if (vala_genie_scanner_matches (self, begin, "break")) {
						result = VALA_GENIE_TOKEN_TYPE_BREAK;
						return result;
					}
					break;
				}
				case 'c':
				{
					switch (begin[1]) {
						case 'l':
						{
							if (vala_genie_scanner_matches (self, begin, "class")) {
								result = VALA_GENIE_TOKEN_TYPE_CLASS;
								return result;
							}
							break;
						}
						case 'o':
						{
							if (vala_genie_scanner_matches (self, begin, "const")) {
								result = VALA_GENIE_TOKEN_TYPE_CONST;
								return result;
							}
							break;
						}
					}
					break;
				}
				case 'e':
				{
					if (vala_genie_scanner_matches (self, begin, "event")) {
						result = VALA_GENIE_TOKEN_TYPE_EVENT;
						return result;
					}
					break;
				}
				case 'f':
				{
					switch (begin[1]) {
						case 'a':
						{
							if (vala_genie_scanner_matches (self, begin, "false")) {
								result = VALA_GENIE_TOKEN_TYPE_FALSE;
								return result;
							}
							break;
						}
						case 'i':
						{
							if (vala_genie_scanner_matches (self, begin, "final")) {
								result = VALA_GENIE_TOKEN_TYPE_FINAL;
								return result;
							}
							break;
						}
					}
					break;
				}
				case 'o':
				{
					if (vala_genie_scanner_matches (self, begin, "owned")) {
						result = VALA_GENIE_TOKEN_TYPE_OWNED;
						return result;
					}
					break;
				}
				case 'p':
				{
					if (vala_genie_scanner_matches (self, begin, "print")) {
						result = VALA_GENIE_TOKEN_TYPE_PRINT;
						return result;
					}
					break;
				}
				case 's':
				{
					if (vala_genie_scanner_matches (self, begin, "super")) {
						result = VALA_GENIE_TOKEN_TYPE_SUPER;
						return result;
					}
					break;
				}
				case 'r':
				{
					if (vala_genie_scanner_matches (self, begin, "raise")) {
						result = VALA_GENIE_TOKEN_TYPE_RAISE;
						return result;
					}
					break;
				}
				case 'w':
				{
					if (vala_genie_scanner_matches (self, begin, "while")) {
						result = VALA_GENIE_TOKEN_TYPE_WHILE;
						return result;
					}
					break;
				}
				case 'y':
				{
					if (vala_genie_scanner_matches (self, begin, "yield")) {
						result = VALA_GENIE_TOKEN_TYPE_YIELD;
						return result;
					}
					break;
				}
			}
			break;
		}
		case 6:
		{
			switch (begin[0]) {
				case 'a':
				{
					if (vala_genie_scanner_matches (self, begin, "assert")) {
						result = VALA_GENIE_TOKEN_TYPE_ASSERT;
						return result;
					}
					break;
				}
				case 'd':
				{
					switch (begin[1]) {
						case 'e':
						{
							if (vala_genie_scanner_matches (self, begin, "delete")) {
								result = VALA_GENIE_TOKEN_TYPE_DELETE;
								return result;
							}
							break;
						}
						case 'o':
						{
							if (vala_genie_scanner_matches (self, begin, "downto")) {
								result = VALA_GENIE_TOKEN_TYPE_DOWNTO;
								return result;
							}
							break;
						}
					}
					break;
				}
				case 'e':
				{
					switch (begin[1]) {
						case 'x':
						{
							switch (begin[2]) {
								case 'c':
								{
									if (vala_genie_scanner_matches (self, begin, "except")) {
										result = VALA_GENIE_TOKEN_TYPE_EXCEPT;
										return result;
									}
									break;
								}
								case 't':
								{
									if (vala_genie_scanner_matches (self, begin, "extern")) {
										result = VALA_GENIE_TOKEN_TYPE_EXTERN;
										return result;
									}
									break;
								}
							}
							break;
						}
					}
					break;
				}
				case 'i':
				{
					if (vala_genie_scanner_matches (self, begin, "inline")) {
						result = VALA_GENIE_TOKEN_TYPE_INLINE;
						return result;
					}
					break;
				}
				case 'p':
				{
					switch (begin[1]) {
						case 'a':
						{
							if (vala_genie_scanner_matches (self, begin, "params")) {
								result = VALA_GENIE_TOKEN_TYPE_PARAMS;
								return result;
							}
							break;
						}
						case 'u':
						{
							if (vala_genie_scanner_matches (self, begin, "public")) {
								result = VALA_GENIE_TOKEN_TYPE_PUBLIC;
								return result;
							}
							break;
						}
					}
					break;
				}
				case 'r':
				{
					switch (begin[1]) {
						case 'a':
						{
							if (vala_genie_scanner_matches (self, begin, "raises")) {
								result = VALA_GENIE_TOKEN_TYPE_RAISES;
								return result;
							}
							break;
						}
						case 'e':
						{
							if (vala_genie_scanner_matches (self, begin, "return")) {
								result = VALA_GENIE_TOKEN_TYPE_RETURN;
								return result;
							}
							break;
						}
					}
					break;
				}
				case 's':
				{
					switch (begin[1]) {
						case 'i':
						{
							if (vala_genie_scanner_matches (self, begin, "sizeof")) {
								result = VALA_GENIE_TOKEN_TYPE_SIZEOF;
								return result;
							}
							break;
						}
						case 't':
						{
							switch (begin[2]) {
								case 'a':
								{
									if (vala_genie_scanner_matches (self, begin, "static")) {
										result = VALA_GENIE_TOKEN_TYPE_STATIC;
										return result;
									}
									break;
								}
								case 'r':
								{
									if (vala_genie_scanner_matches (self, begin, "struct")) {
										result = VALA_GENIE_TOKEN_TYPE_STRUCT;
										return result;
									}
									break;
								}
							}
							break;
						}
					}
					break;
				}
				case 't':
				{
					if (vala_genie_scanner_matches (self, begin, "typeof")) {
						result = VALA_GENIE_TOKEN_TYPE_TYPEOF;
						return result;
					}
					break;
				}
			}
			break;
		}
		case 7:
		{
			switch (begin[0]) {
				case 'd':
				{
					switch (begin[1]) {
						case 'e':
						{
							if (vala_genie_scanner_matches (self, begin, "default")) {
								result = VALA_GENIE_TOKEN_TYPE_DEFAULT;
								return result;
							}
							break;
						}
						case 'y':
						{
							if (vala_genie_scanner_matches (self, begin, "dynamic")) {
								result = VALA_GENIE_TOKEN_TYPE_DYNAMIC;
								return result;
							}
							break;
						}
					}
					break;
				}
				case 'e':
				{
					if (vala_genie_scanner_matches (self, begin, "ensures")) {
						result = VALA_GENIE_TOKEN_TYPE_ENSURES;
						return result;
					}
					break;
				}
				case 'f':
				{
					switch (begin[1]) {
						case 'i':
						{
							if (vala_genie_scanner_matches (self, begin, "finally")) {
								result = VALA_GENIE_TOKEN_TYPE_FINALLY;
								return result;
							}
							break;
						}
					}
					break;
				}
				case 'p':
				{
					if (vala_genie_scanner_matches (self, begin, "private")) {
						result = VALA_GENIE_TOKEN_TYPE_PRIVATE;
						return result;
					}
					break;
				}
				case 'u':
				{
					if (vala_genie_scanner_matches (self, begin, "unowned")) {
						result = VALA_GENIE_TOKEN_TYPE_UNOWNED;
						return result;
					}
					break;
				}
				case 'v':
				{
					if (vala_genie_scanner_matches (self, begin, "virtual")) {
						result = VALA_GENIE_TOKEN_TYPE_VIRTUAL;
						return result;
					}
					break;
				}
			}
			break;
		}
		case 8:
		{
			switch (begin[0]) {
				case 'a':
				{
					if (vala_genie_scanner_matches (self, begin, "abstract")) {
						result = VALA_GENIE_TOKEN_TYPE_ABSTRACT;
						return result;
					}
					break;
				}
				case 'c':
				{
					if (vala_genie_scanner_matches (self, begin, "continue")) {
						result = VALA_GENIE_TOKEN_TYPE_CONTINUE;
						return result;
					}
					break;
				}
				case 'd':
				{
					if (vala_genie_scanner_matches (self, begin, "delegate")) {
						result = VALA_GENIE_TOKEN_TYPE_DELEGATE;
						return result;
					}
					break;
				}
				case 'i':
				{
					if (vala_genie_scanner_matches (self, begin, "internal")) {
						result = VALA_GENIE_TOKEN_TYPE_INTERNAL;
						return result;
					}
					break;
				}
				case 'o':
				{
					if (vala_genie_scanner_matches (self, begin, "override")) {
						result = VALA_GENIE_TOKEN_TYPE_OVERRIDE;
						return result;
					}
					break;
				}
				case 'r':
				{
					switch (begin[2]) {
						case 'a':
						{
							if (vala_genie_scanner_matches (self, begin, "readonly")) {
								result = VALA_GENIE_TOKEN_TYPE_READONLY;
								return result;
							}
							break;
						}
						case 'q':
						{
							if (vala_genie_scanner_matches (self, begin, "requires")) {
								result = VALA_GENIE_TOKEN_TYPE_REQUIRES;
								return result;
							}
							break;
						}
					}
					break;
				}
				case 'v':
				{
					if (vala_genie_scanner_matches (self, begin, "volatile")) {
						result = VALA_GENIE_TOKEN_TYPE_VOLATILE;
						return result;
					}
					break;
				}
			}
			break;
		}
		case 9:
		{
			switch (begin[0]) {
				case 'c':
				{
					if (vala_genie_scanner_matches (self, begin, "construct")) {
						result = VALA_GENIE_TOKEN_TYPE_CONSTRUCT;
						return result;
					}
					break;
				}
				case 'e':
				{
					if (vala_genie_scanner_matches (self, begin, "exception")) {
						result = VALA_GENIE_TOKEN_TYPE_ERRORDOMAIN;
						return result;
					}
					break;
				}
				case 'i':
				{
					if (vala_genie_scanner_matches (self, begin, "interface")) {
						result = VALA_GENIE_TOKEN_TYPE_INTERFACE;
						return result;
					}
					break;
				}
				case 'n':
				{
					if (vala_genie_scanner_matches (self, begin, "namespace")) {
						result = VALA_GENIE_TOKEN_TYPE_NAMESPACE;
						return result;
					}
					break;
				}
				case 'p':
				{
					if (vala_genie_scanner_matches (self, begin, "protected")) {
						result = VALA_GENIE_TOKEN_TYPE_PROTECTED;
						return result;
					}
					break;
				}
				case 'w':
				{
					if (vala_genie_scanner_matches (self, begin, "writeonly")) {
						result = VALA_GENIE_TOKEN_TYPE_WRITEONLY;
						return result;
					}
					break;
				}
			}
			break;
		}
		case 10:
		{
			switch (begin[0]) {
				case 'i':
				{
					if (vala_genie_scanner_matches (self, begin, "implements")) {
						result = VALA_GENIE_TOKEN_TYPE_IMPLEMENTS;
						return result;
					}
					break;
				}
			}
			break;
		}
	}
	result = VALA_GENIE_TOKEN_TYPE_IDENTIFIER;
	return result;
}


ValaGenieTokenType vala_genie_scanner_read_token (ValaGenieScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end) {
	ValaGenieTokenType result;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	ValaGenieTokenType type = 0;
	gchar* begin;
	gint token_length_in_chars;
	g_return_val_if_fail (self != NULL, 0);
	if (self->priv->pending_dedents > 0) {
		self->priv->pending_dedents--;
		self->priv->indent_level--;
		(*token_begin).pos = self->priv->current;
		(*token_begin).line = self->priv->line;
		(*token_begin).column = self->priv->column;
		(*token_end).pos = self->priv->current;
		(*token_end).line = self->priv->line;
		(*token_end).column = self->priv->column;
		self->priv->last_token = VALA_GENIE_TOKEN_TYPE_DEDENT;
		result = VALA_GENIE_TOKEN_TYPE_DEDENT;
		return result;
	}
	if (self->priv->_indent_spaces == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->last_token != VALA_GENIE_TOKEN_TYPE_EOL;
	}
	if (_tmp0_) {
		vala_genie_scanner_space (self);
	}
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		if (self->priv->current < self->priv->end) {
			_tmp2_ = self->priv->current[0] == '\\';
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			_tmp1_ = self->priv->current[1] == '\n';
		} else {
			_tmp1_ = FALSE;
		}
		if (!_tmp1_) {
			break;
		}
		self->priv->current = self->priv->current + 2;
		self->priv->line++;
		vala_genie_scanner_skip_space_tabs (self);
	}
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (self->priv->current < self->priv->end) {
			_tmp4_ = self->priv->current[0] == '\n';
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			gboolean _tmp5_ = FALSE;
			if (self->priv->open_parens_count > 0) {
				_tmp5_ = TRUE;
			} else {
				_tmp5_ = self->priv->open_brace_count > 0;
			}
			_tmp3_ = _tmp5_;
		} else {
			_tmp3_ = FALSE;
		}
		if (!_tmp3_) {
			break;
		}
		self->priv->current++;
		self->priv->line++;
		vala_genie_scanner_skip_space_tabs (self);
	}
	if (vala_genie_scanner_newline (self)) {
		_tmp8_ = self->priv->parse_started;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		_tmp7_ = self->priv->last_token != VALA_GENIE_TOKEN_TYPE_EOL;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		_tmp6_ = self->priv->last_token != VALA_GENIE_TOKEN_TYPE_SEMICOLON;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		(*token_begin).pos = self->priv->current;
		(*token_begin).line = self->priv->line;
		(*token_begin).column = self->priv->column;
		(*token_end).pos = self->priv->current;
		(*token_end).line = self->priv->line;
		(*token_end).column = self->priv->column;
		self->priv->last_token = VALA_GENIE_TOKEN_TYPE_EOL;
		result = VALA_GENIE_TOKEN_TYPE_EOL;
		return result;
	}
	while (TRUE) {
		if (!vala_genie_scanner_skip_newlines (self)) {
			break;
		}
		(*token_begin).pos = self->priv->current;
		(*token_begin).line = self->priv->line;
		(*token_begin).column = self->priv->column;
		self->priv->current_indent_level = vala_genie_scanner_count_tabs (self);
		if (self->priv->current_indent_level == (-1)) {
			continue;
		}
		if (self->priv->current_indent_level > self->priv->indent_level) {
			self->priv->indent_level = self->priv->current_indent_level;
			(*token_end).pos = self->priv->current;
			(*token_end).line = self->priv->line;
			(*token_end).column = self->priv->column;
			self->priv->last_token = VALA_GENIE_TOKEN_TYPE_INDENT;
			result = VALA_GENIE_TOKEN_TYPE_INDENT;
			return result;
		} else {
			if (self->priv->current_indent_level < self->priv->indent_level) {
				self->priv->indent_level--;
				self->priv->pending_dedents = self->priv->indent_level - self->priv->current_indent_level;
				(*token_end).pos = self->priv->current;
				(*token_end).line = self->priv->line;
				(*token_end).column = self->priv->column;
				self->priv->last_token = VALA_GENIE_TOKEN_TYPE_DEDENT;
				result = VALA_GENIE_TOKEN_TYPE_DEDENT;
				return result;
			}
		}
	}
	begin = self->priv->current;
	(*token_begin).pos = begin;
	(*token_begin).line = self->priv->line;
	(*token_begin).column = self->priv->column;
	token_length_in_chars = -1;
	self->priv->parse_started = TRUE;
	if (self->priv->current >= self->priv->end) {
		if (self->priv->indent_level > 0) {
			self->priv->indent_level--;
			self->priv->pending_dedents = self->priv->indent_level;
			type = VALA_GENIE_TOKEN_TYPE_DEDENT;
		} else {
			type = VALA_GENIE_TOKEN_TYPE_EOF;
		}
	} else {
		gboolean _tmp9_ = FALSE;
		if (g_ascii_isalpha (self->priv->current[0])) {
			_tmp9_ = TRUE;
		} else {
			_tmp9_ = self->priv->current[0] == '_';
		}
		if (_tmp9_) {
			gint len;
			len = 0;
			while (TRUE) {
				gboolean _tmp10_ = FALSE;
				if (self->priv->current < self->priv->end) {
					_tmp10_ = vala_genie_scanner_is_ident_char (self, self->priv->current[0]);
				} else {
					_tmp10_ = FALSE;
				}
				if (!_tmp10_) {
					break;
				}
				self->priv->current++;
				len++;
			}
			type = vala_genie_scanner_get_identifier_or_keyword (self, begin, len);
		} else {
			if (self->priv->current[0] == '@') {
				gint len;
				len = 0;
				if (self->priv->current[1] == '@') {
					(*token_begin).pos = (*token_begin).pos + 2;
					self->priv->current = self->priv->current + 2;
				} else {
					self->priv->current++;
					len = 1;
				}
				while (TRUE) {
					gboolean _tmp11_ = FALSE;
					if (self->priv->current < self->priv->end) {
						_tmp11_ = vala_genie_scanner_is_ident_char (self, self->priv->current[0]);
					} else {
						_tmp11_ = FALSE;
					}
					if (!_tmp11_) {
						break;
					}
					self->priv->current++;
					len++;
				}
				type = VALA_GENIE_TOKEN_TYPE_IDENTIFIER;
			} else {
				if (g_ascii_isdigit (self->priv->current[0])) {
					gboolean _tmp13_ = FALSE;
					while (TRUE) {
						gboolean _tmp12_ = FALSE;
						if (self->priv->current < self->priv->end) {
							_tmp12_ = g_ascii_isdigit (self->priv->current[0]);
						} else {
							_tmp12_ = FALSE;
						}
						if (!_tmp12_) {
							break;
						}
						self->priv->current++;
					}
					type = VALA_GENIE_TOKEN_TYPE_INTEGER_LITERAL;
					if (self->priv->current < self->priv->end) {
						_tmp13_ = g_ascii_tolower (self->priv->current[0]) == 'l';
					} else {
						_tmp13_ = FALSE;
					}
					if (_tmp13_) {
						gboolean _tmp14_ = FALSE;
						self->priv->current++;
						if (self->priv->current < self->priv->end) {
							_tmp14_ = g_ascii_tolower (self->priv->current[0]) == 'l';
						} else {
							_tmp14_ = FALSE;
						}
						if (_tmp14_) {
							self->priv->current++;
						}
					} else {
						gboolean _tmp15_ = FALSE;
						if (self->priv->current < self->priv->end) {
							_tmp15_ = g_ascii_tolower (self->priv->current[0]) == 'u';
						} else {
							_tmp15_ = FALSE;
						}
						if (_tmp15_) {
							gboolean _tmp16_ = FALSE;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								_tmp16_ = g_ascii_tolower (self->priv->current[0]) == 'l';
							} else {
								_tmp16_ = FALSE;
							}
							if (_tmp16_) {
								gboolean _tmp17_ = FALSE;
								self->priv->current++;
								if (self->priv->current < self->priv->end) {
									_tmp17_ = g_ascii_tolower (self->priv->current[0]) == 'l';
								} else {
									_tmp17_ = FALSE;
								}
								if (_tmp17_) {
									self->priv->current++;
								}
							}
						} else {
							gboolean _tmp18_ = FALSE;
							gboolean _tmp19_ = FALSE;
							if (self->priv->current < (self->priv->end - 1)) {
								_tmp19_ = self->priv->current[0] == '.';
							} else {
								_tmp19_ = FALSE;
							}
							if (_tmp19_) {
								_tmp18_ = g_ascii_isdigit (self->priv->current[1]);
							} else {
								_tmp18_ = FALSE;
							}
							if (_tmp18_) {
								gboolean _tmp21_ = FALSE;
								gboolean _tmp25_ = FALSE;
								self->priv->current++;
								while (TRUE) {
									gboolean _tmp20_ = FALSE;
									if (self->priv->current < self->priv->end) {
										_tmp20_ = g_ascii_isdigit (self->priv->current[0]);
									} else {
										_tmp20_ = FALSE;
									}
									if (!_tmp20_) {
										break;
									}
									self->priv->current++;
								}
								if (self->priv->current < self->priv->end) {
									_tmp21_ = g_ascii_tolower (self->priv->current[0]) == 'e';
								} else {
									_tmp21_ = FALSE;
								}
								if (_tmp21_) {
									gboolean _tmp22_ = FALSE;
									self->priv->current++;
									if (self->priv->current < self->priv->end) {
										gboolean _tmp23_ = FALSE;
										if (self->priv->current[0] == '+') {
											_tmp23_ = TRUE;
										} else {
											_tmp23_ = self->priv->current[0] == '-';
										}
										_tmp22_ = _tmp23_;
									} else {
										_tmp22_ = FALSE;
									}
									if (_tmp22_) {
										self->priv->current++;
									}
									while (TRUE) {
										gboolean _tmp24_ = FALSE;
										if (self->priv->current < self->priv->end) {
											_tmp24_ = g_ascii_isdigit (self->priv->current[0]);
										} else {
											_tmp24_ = FALSE;
										}
										if (!_tmp24_) {
											break;
										}
										self->priv->current++;
									}
								}
								if (self->priv->current < self->priv->end) {
									_tmp25_ = g_ascii_tolower (self->priv->current[0]) == 'f';
								} else {
									_tmp25_ = FALSE;
								}
								if (_tmp25_) {
									self->priv->current++;
								}
								type = VALA_GENIE_TOKEN_TYPE_REAL_LITERAL;
							} else {
								gboolean _tmp26_ = FALSE;
								gboolean _tmp27_ = FALSE;
								gboolean _tmp28_ = FALSE;
								gboolean _tmp29_ = FALSE;
								if (self->priv->current < self->priv->end) {
									_tmp29_ = self->priv->current == (begin + 1);
								} else {
									_tmp29_ = FALSE;
								}
								if (_tmp29_) {
									_tmp28_ = begin[0] == '0';
								} else {
									_tmp28_ = FALSE;
								}
								if (_tmp28_) {
									_tmp27_ = begin[1] == 'x';
								} else {
									_tmp27_ = FALSE;
								}
								if (_tmp27_) {
									_tmp26_ = g_ascii_isxdigit (begin[2]);
								} else {
									_tmp26_ = FALSE;
								}
								if (_tmp26_) {
									self->priv->current++;
									while (TRUE) {
										gboolean _tmp30_ = FALSE;
										if (self->priv->current < self->priv->end) {
											_tmp30_ = g_ascii_isxdigit (self->priv->current[0]);
										} else {
											_tmp30_ = FALSE;
										}
										if (!_tmp30_) {
											break;
										}
										self->priv->current++;
									}
								} else {
									gboolean _tmp31_ = FALSE;
									if (self->priv->current < self->priv->end) {
										_tmp31_ = vala_genie_scanner_is_ident_char (self, self->priv->current[0]);
									} else {
										_tmp31_ = FALSE;
									}
									if (_tmp31_) {
										while (TRUE) {
											gboolean _tmp32_ = FALSE;
											if (self->priv->current < self->priv->end) {
												_tmp32_ = vala_genie_scanner_is_ident_char (self, self->priv->current[0]);
											} else {
												_tmp32_ = FALSE;
											}
											if (!_tmp32_) {
												break;
											}
											self->priv->current++;
										}
										type = VALA_GENIE_TOKEN_TYPE_IDENTIFIER;
									}
								}
							}
						}
					}
				} else {
					switch (self->priv->current[0]) {
						case '{':
						{
							type = VALA_GENIE_TOKEN_TYPE_OPEN_BRACE;
							self->priv->open_brace_count++;
							self->priv->current++;
							break;
						}
						case '}':
						{
							type = VALA_GENIE_TOKEN_TYPE_CLOSE_BRACE;
							self->priv->open_brace_count--;
							self->priv->current++;
							break;
						}
						case '(':
						{
							type = VALA_GENIE_TOKEN_TYPE_OPEN_PARENS;
							self->priv->open_parens_count++;
							self->priv->current++;
							break;
						}
						case ')':
						{
							type = VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS;
							self->priv->open_parens_count--;
							self->priv->current++;
							break;
						}
						case '[':
						{
							type = VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET;
							self->priv->current++;
							break;
						}
						case ']':
						{
							type = VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET;
							self->priv->current++;
							break;
						}
						case '.':
						{
							type = VALA_GENIE_TOKEN_TYPE_DOT;
							self->priv->current++;
							if (self->priv->current < (self->priv->end - 1)) {
								gboolean _tmp33_ = FALSE;
								if (self->priv->current[0] == '.') {
									_tmp33_ = self->priv->current[1] == '.';
								} else {
									_tmp33_ = FALSE;
								}
								if (_tmp33_) {
									type = VALA_GENIE_TOKEN_TYPE_ELLIPSIS;
									self->priv->current = self->priv->current + 2;
								}
							}
							break;
						}
						case ':':
						{
							type = VALA_GENIE_TOKEN_TYPE_COLON;
							self->priv->current++;
							break;
						}
						case ',':
						{
							type = VALA_GENIE_TOKEN_TYPE_COMMA;
							self->priv->current++;
							break;
						}
						case ';':
						{
							type = VALA_GENIE_TOKEN_TYPE_SEMICOLON;
							self->priv->current++;
							break;
						}
						case '#':
						{
							type = VALA_GENIE_TOKEN_TYPE_HASH;
							self->priv->current++;
							break;
						}
						case '?':
						{
							type = VALA_GENIE_TOKEN_TYPE_INTERR;
							self->priv->current++;
							break;
						}
						case '|':
						{
							type = VALA_GENIE_TOKEN_TYPE_BITWISE_OR;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								switch (self->priv->current[0]) {
									case '=':
									{
										type = VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_OR;
										self->priv->current++;
										break;
									}
									case '|':
									{
										type = VALA_GENIE_TOKEN_TYPE_OP_OR;
										self->priv->current++;
										break;
									}
								}
							}
							break;
						}
						case '&':
						{
							type = VALA_GENIE_TOKEN_TYPE_BITWISE_AND;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								switch (self->priv->current[0]) {
									case '=':
									{
										type = VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_AND;
										self->priv->current++;
										break;
									}
									case '&':
									{
										type = VALA_GENIE_TOKEN_TYPE_OP_AND;
										self->priv->current++;
										break;
									}
								}
							}
							break;
						}
						case '^':
						{
							gboolean _tmp34_ = FALSE;
							type = VALA_GENIE_TOKEN_TYPE_CARRET;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								_tmp34_ = self->priv->current[0] == '=';
							} else {
								_tmp34_ = FALSE;
							}
							if (_tmp34_) {
								type = VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_XOR;
								self->priv->current++;
							}
							break;
						}
						case '~':
						{
							type = VALA_GENIE_TOKEN_TYPE_TILDE;
							self->priv->current++;
							break;
						}
						case '=':
						{
							type = VALA_GENIE_TOKEN_TYPE_ASSIGN;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								switch (self->priv->current[0]) {
									case '=':
									{
										type = VALA_GENIE_TOKEN_TYPE_OP_EQ;
										self->priv->current++;
										break;
									}
									case '>':
									{
										type = VALA_GENIE_TOKEN_TYPE_LAMBDA;
										self->priv->current++;
										break;
									}
								}
							}
							break;
						}
						case '<':
						{
							type = VALA_GENIE_TOKEN_TYPE_OP_LT;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								switch (self->priv->current[0]) {
									case '=':
									{
										type = VALA_GENIE_TOKEN_TYPE_OP_LE;
										self->priv->current++;
										break;
									}
									case '<':
									{
										gboolean _tmp35_ = FALSE;
										type = VALA_GENIE_TOKEN_TYPE_OP_SHIFT_LEFT;
										self->priv->current++;
										if (self->priv->current < self->priv->end) {
											_tmp35_ = self->priv->current[0] == '=';
										} else {
											_tmp35_ = FALSE;
										}
										if (_tmp35_) {
											type = VALA_GENIE_TOKEN_TYPE_ASSIGN_SHIFT_LEFT;
											self->priv->current++;
										}
										break;
									}
								}
							}
							break;
						}
						case '>':
						{
							gboolean _tmp36_ = FALSE;
							type = VALA_GENIE_TOKEN_TYPE_OP_GT;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								_tmp36_ = self->priv->current[0] == '=';
							} else {
								_tmp36_ = FALSE;
							}
							if (_tmp36_) {
								type = VALA_GENIE_TOKEN_TYPE_OP_GE;
								self->priv->current++;
							}
							break;
						}
						case '!':
						{
							gboolean _tmp37_ = FALSE;
							type = VALA_GENIE_TOKEN_TYPE_OP_NEG;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								_tmp37_ = self->priv->current[0] == '=';
							} else {
								_tmp37_ = FALSE;
							}
							if (_tmp37_) {
								type = VALA_GENIE_TOKEN_TYPE_OP_NE;
								self->priv->current++;
							}
							break;
						}
						case '+':
						{
							type = VALA_GENIE_TOKEN_TYPE_PLUS;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								switch (self->priv->current[0]) {
									case '=':
									{
										type = VALA_GENIE_TOKEN_TYPE_ASSIGN_ADD;
										self->priv->current++;
										break;
									}
									case '+':
									{
										type = VALA_GENIE_TOKEN_TYPE_OP_INC;
										self->priv->current++;
										break;
									}
								}
							}
							break;
						}
						case '-':
						{
							type = VALA_GENIE_TOKEN_TYPE_MINUS;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								switch (self->priv->current[0]) {
									case '=':
									{
										type = VALA_GENIE_TOKEN_TYPE_ASSIGN_SUB;
										self->priv->current++;
										break;
									}
									case '-':
									{
										type = VALA_GENIE_TOKEN_TYPE_OP_DEC;
										self->priv->current++;
										break;
									}
									case '>':
									{
										type = VALA_GENIE_TOKEN_TYPE_OP_PTR;
										self->priv->current++;
										break;
									}
								}
							}
							break;
						}
						case '*':
						{
							gboolean _tmp38_ = FALSE;
							type = VALA_GENIE_TOKEN_TYPE_STAR;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								_tmp38_ = self->priv->current[0] == '=';
							} else {
								_tmp38_ = FALSE;
							}
							if (_tmp38_) {
								type = VALA_GENIE_TOKEN_TYPE_ASSIGN_MUL;
								self->priv->current++;
							}
							break;
						}
						case '/':
						{
							gboolean _tmp39_ = FALSE;
							type = VALA_GENIE_TOKEN_TYPE_DIV;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								_tmp39_ = self->priv->current[0] == '=';
							} else {
								_tmp39_ = FALSE;
							}
							if (_tmp39_) {
								type = VALA_GENIE_TOKEN_TYPE_ASSIGN_DIV;
								self->priv->current++;
							}
							break;
						}
						case '%':
						{
							gboolean _tmp40_ = FALSE;
							type = VALA_GENIE_TOKEN_TYPE_PERCENT;
							self->priv->current++;
							if (self->priv->current < self->priv->end) {
								_tmp40_ = self->priv->current[0] == '=';
							} else {
								_tmp40_ = FALSE;
							}
							if (_tmp40_) {
								type = VALA_GENIE_TOKEN_TYPE_ASSIGN_PERCENT;
								self->priv->current++;
							}
							break;
						}
						case '\'':
						case '"':
						{
							gboolean _tmp53_ = FALSE;
							if (begin[0] == '\'') {
								type = VALA_GENIE_TOKEN_TYPE_CHARACTER_LITERAL;
							} else {
								gboolean _tmp41_ = FALSE;
								gboolean _tmp42_ = FALSE;
								if (self->priv->current < (self->priv->end - 6)) {
									_tmp42_ = begin[1] == '"';
								} else {
									_tmp42_ = FALSE;
								}
								if (_tmp42_) {
									_tmp41_ = begin[2] == '"';
								} else {
									_tmp41_ = FALSE;
								}
								if (_tmp41_) {
									gboolean _tmp46_ = FALSE;
									gboolean _tmp47_ = FALSE;
									type = VALA_GENIE_TOKEN_TYPE_VERBATIM_STRING_LITERAL;
									token_length_in_chars = 6;
									self->priv->current = self->priv->current + 3;
									while (TRUE) {
										gboolean _tmp43_ = FALSE;
										gboolean _tmp44_ = FALSE;
										if (!(self->priv->current < (self->priv->end - 4))) {
											break;
										}
										if (self->priv->current[0] == '"') {
											_tmp44_ = self->priv->current[1] == '"';
										} else {
											_tmp44_ = FALSE;
										}
										if (_tmp44_) {
											_tmp43_ = self->priv->current[2] == '"';
										} else {
											_tmp43_ = FALSE;
										}
										if (_tmp43_) {
											break;
										} else {
											if (self->priv->current[0] == '\n') {
												self->priv->current++;
												self->priv->line++;
												self->priv->column = 1;
												token_length_in_chars = 3;
											} else {
												gunichar u;
												u = g_utf8_get_char_validated ((const char*) self->priv->current, (gssize) ((glong) (self->priv->end - self->priv->current)));
												if (u != ((gunichar) (-1))) {
													self->priv->current = self->priv->current + g_unichar_to_utf8 (u, NULL);
													token_length_in_chars++;
												} else {
													ValaSourceReference* _tmp45_;
													vala_report_error (_tmp45_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars), "invalid UTF-8 character");
													_vala_source_reference_unref0 (_tmp45_);
												}
											}
										}
									}
									if (self->priv->current[0] == '"') {
										_tmp47_ = self->priv->current[1] == '"';
									} else {
										_tmp47_ = FALSE;
									}
									if (_tmp47_) {
										_tmp46_ = self->priv->current[2] == '"';
									} else {
										_tmp46_ = FALSE;
									}
									if (_tmp46_) {
										self->priv->current = self->priv->current + 3;
									} else {
										ValaSourceReference* _tmp48_;
										vala_report_error (_tmp48_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars), "syntax error, expected \"\"\"");
										_vala_source_reference_unref0 (_tmp48_);
									}
									break;
								} else {
									type = VALA_GENIE_TOKEN_TYPE_STRING_LITERAL;
								}
							}
							token_length_in_chars = 2;
							self->priv->current++;
							while (TRUE) {
								gboolean _tmp49_ = FALSE;
								if (self->priv->current < self->priv->end) {
									_tmp49_ = self->priv->current[0] != begin[0];
								} else {
									_tmp49_ = FALSE;
								}
								if (!_tmp49_) {
									break;
								}
								if (self->priv->current[0] == '\\') {
									self->priv->current++;
									token_length_in_chars++;
									if (self->priv->current >= self->priv->end) {
										break;
									}
									switch (self->priv->current[0]) {
										case '\'':
										case '"':
										case '\\':
										case '0':
										case 'b':
										case 'f':
										case 'n':
										case 'r':
										case 't':
										{
											self->priv->current++;
											token_length_in_chars++;
											break;
										}
										case 'x':
										{
											self->priv->current++;
											token_length_in_chars++;
											while (TRUE) {
												gboolean _tmp50_ = FALSE;
												if (self->priv->current < self->priv->end) {
													_tmp50_ = g_ascii_isxdigit (self->priv->current[0]);
												} else {
													_tmp50_ = FALSE;
												}
												if (!_tmp50_) {
													break;
												}
												self->priv->current++;
												token_length_in_chars++;
											}
											break;
										}
										default:
										{
											ValaSourceReference* _tmp51_;
											vala_report_error (_tmp51_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars), "invalid escape sequence");
											_vala_source_reference_unref0 (_tmp51_);
											break;
										}
									}
								} else {
									if (self->priv->current[0] == '\n') {
										break;
									} else {
										gunichar u;
										u = g_utf8_get_char_validated ((const char*) self->priv->current, (gssize) ((glong) (self->priv->end - self->priv->current)));
										if (u != ((gunichar) (-1))) {
											self->priv->current = self->priv->current + g_unichar_to_utf8 (u, NULL);
											token_length_in_chars++;
										} else {
											ValaSourceReference* _tmp52_;
											self->priv->current++;
											vala_report_error (_tmp52_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars), "invalid UTF-8 character");
											_vala_source_reference_unref0 (_tmp52_);
										}
									}
								}
							}
							if (self->priv->current < self->priv->end) {
								_tmp53_ = self->priv->current[0] != '\n';
							} else {
								_tmp53_ = FALSE;
							}
							if (_tmp53_) {
								self->priv->current++;
							} else {
								char* _tmp55_;
								ValaSourceReference* _tmp54_;
								vala_report_error (_tmp54_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column + token_length_in_chars, self->priv->line, self->priv->column + token_length_in_chars), _tmp55_ = g_strdup_printf ("syntax error, expected %c", (gint) begin[0]));
								_g_free0 (_tmp55_);
								_vala_source_reference_unref0 (_tmp54_);
							}
							break;
						}
						default:
						{
							gunichar u;
							u = g_utf8_get_char_validated ((const char*) self->priv->current, (gssize) ((glong) (self->priv->end - self->priv->current)));
							if (u != ((gunichar) (-1))) {
								ValaSourceReference* _tmp56_;
								self->priv->current = self->priv->current + g_unichar_to_utf8 (u, NULL);
								vala_report_error (_tmp56_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column), "syntax error, unexpected character");
								_vala_source_reference_unref0 (_tmp56_);
							} else {
								ValaSourceReference* _tmp57_;
								self->priv->current++;
								vala_report_error (_tmp57_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column), "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp57_);
							}
							self->priv->column++;
							self->priv->last_token = VALA_GENIE_TOKEN_TYPE_STRING_LITERAL;
							result = vala_genie_scanner_read_token (self, token_begin, token_end);
							return result;
						}
					}
				}
			}
		}
	}
	if (token_length_in_chars < 0) {
		self->priv->column = self->priv->column + ((gint) (self->priv->current - begin));
	} else {
		self->priv->column = self->priv->column + token_length_in_chars;
	}
	(*token_end).pos = self->priv->current;
	(*token_end).line = self->priv->line;
	(*token_end).column = self->priv->column - 1;
	self->priv->last_token = type;
	result = type;
	return result;
}


static gint vala_genie_scanner_count_tabs (ValaGenieScanner* self) {
	gint result;
	gint tab_count;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	tab_count = 0;
	if (self->priv->_indent_spaces == 0) {
		while (TRUE) {
			gboolean _tmp0_ = FALSE;
			if (self->priv->current < self->priv->end) {
				_tmp0_ = self->priv->current[0] == '\t';
			} else {
				_tmp0_ = FALSE;
			}
			if (!_tmp0_) {
				break;
			}
			self->priv->current++;
			self->priv->column++;
			tab_count++;
		}
	} else {
		gint space_count;
		space_count = 0;
		while (TRUE) {
			gboolean _tmp1_ = FALSE;
			if (self->priv->current < self->priv->end) {
				_tmp1_ = self->priv->current[0] == ' ';
			} else {
				_tmp1_ = FALSE;
			}
			if (!_tmp1_) {
				break;
			}
			self->priv->current++;
			self->priv->column++;
			space_count++;
		}
		tab_count = space_count / self->priv->_indent_spaces;
	}
	vala_genie_scanner_space (self);
	if (self->priv->current < self->priv->end) {
		_tmp2_ = self->priv->current[0] == '\n';
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = -1;
		return result;
	}
	result = tab_count;
	return result;
}


static gboolean vala_genie_scanner_matches (ValaGenieScanner* self, gchar* begin, const char* keyword) {
	gboolean result;
	gchar* keyword_array;
	glong len;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (keyword != NULL, FALSE);
	keyword_array = (gchar*) keyword;
	len = g_utf8_strlen (keyword, -1);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < len)) {
					break;
				}
				if (begin[i] != keyword_array[i]) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static gboolean vala_genie_scanner_whitespace (ValaGenieScanner* self) {
	gboolean result;
	gboolean found;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		if (self->priv->current < self->priv->end) {
			_tmp1_ = g_ascii_isspace (self->priv->current[0]);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			_tmp0_ = self->priv->current[0] != '\n';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		found = TRUE;
		self->priv->current++;
		self->priv->column++;
	}
	if (self->priv->column == 1) {
		_tmp3_ = self->priv->current < self->priv->end;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = self->priv->current[0] == '#';
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		vala_genie_scanner_pp_directive (self);
		result = TRUE;
		return result;
	}
	result = found;
	return result;
}


static inline gboolean vala_genie_scanner_newline (ValaGenieScanner* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->current[0] == '\n') {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean vala_genie_scanner_skip_newlines (ValaGenieScanner* self) {
	gboolean result;
	gboolean new_lines;
	g_return_val_if_fail (self != NULL, FALSE);
	new_lines = FALSE;
	while (TRUE) {
		if (!vala_genie_scanner_newline (self)) {
			break;
		}
		self->priv->current++;
		self->priv->line++;
		self->priv->column = 1;
		self->priv->current_indent_level = 0;
		new_lines = TRUE;
	}
	result = new_lines;
	return result;
}


static gboolean vala_genie_scanner_comment (ValaGenieScanner* self, gboolean file_comment) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->current > (self->priv->end - 2)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->current[0] != '/';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (self->priv->current[1] != '/') {
			_tmp2_ = self->priv->current[1] != '*';
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	if (self->priv->current[1] == '/') {
		ValaSourceReference* source_reference;
		gboolean _tmp5_ = FALSE;
		source_reference = NULL;
		if (file_comment) {
			ValaSourceReference* _tmp3_;
			source_reference = (_tmp3_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column), _vala_source_reference_unref0 (source_reference), _tmp3_);
		}
		self->priv->current = self->priv->current + 2;
		while (TRUE) {
			gboolean _tmp4_ = FALSE;
			if (self->priv->current < self->priv->end) {
				_tmp4_ = self->priv->current[0] != '\n';
			} else {
				_tmp4_ = FALSE;
			}
			if (!_tmp4_) {
				break;
			}
			self->priv->current++;
		}
		if (self->priv->current[0] == '\n') {
			_tmp5_ = self->priv->last_token == VALA_GENIE_TOKEN_TYPE_EOL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			self->priv->current++;
			self->priv->line++;
			self->priv->column = 1;
			self->priv->current_indent_level = 0;
		}
		if (source_reference != NULL) {
			char* _tmp6_;
			vala_genie_scanner_push_comment (self, _tmp6_ = g_strndup ((const char*) self->priv->begin, (gsize) ((glong) (self->priv->current - self->priv->begin))), source_reference, file_comment);
			_g_free0 (_tmp6_);
		}
		_vala_source_reference_unref0 (source_reference);
	} else {
		ValaSourceReference* source_reference;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		gchar* begin;
		source_reference = NULL;
		if (file_comment) {
			_tmp7_ = self->priv->current[2] == '*';
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			result = FALSE;
			_vala_source_reference_unref0 (source_reference);
			return result;
		}
		if (self->priv->current[2] == '*') {
			_tmp8_ = TRUE;
		} else {
			_tmp8_ = file_comment;
		}
		if (_tmp8_) {
			ValaSourceReference* _tmp9_;
			source_reference = (_tmp9_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column), _vala_source_reference_unref0 (source_reference), _tmp9_);
		}
		self->priv->current = self->priv->current + 2;
		begin = self->priv->current;
		while (TRUE) {
			gboolean _tmp10_ = FALSE;
			if (self->priv->current < (self->priv->end - 1)) {
				gboolean _tmp11_ = FALSE;
				if (self->priv->current[0] != '*') {
					_tmp11_ = TRUE;
				} else {
					_tmp11_ = self->priv->current[1] != '/';
				}
				_tmp10_ = _tmp11_;
			} else {
				_tmp10_ = FALSE;
			}
			if (!_tmp10_) {
				break;
			}
			if (self->priv->current[0] == '\n') {
				self->priv->line++;
				self->priv->column = 0;
			}
			self->priv->current++;
			self->priv->column++;
		}
		if (self->priv->current == (self->priv->end - 1)) {
			ValaSourceReference* _tmp12_;
			vala_report_error (_tmp12_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column), "syntax error, expected */");
			_vala_source_reference_unref0 (_tmp12_);
			result = TRUE;
			_vala_source_reference_unref0 (source_reference);
			return result;
		}
		if (source_reference != NULL) {
			char* comment;
			comment = g_strndup ((const char*) begin, (gsize) ((glong) (self->priv->current - begin)));
			vala_genie_scanner_push_comment (self, comment, source_reference, file_comment);
			_g_free0 (comment);
		}
		self->priv->current = self->priv->current + 2;
		self->priv->column = self->priv->column + 2;
		_vala_source_reference_unref0 (source_reference);
	}
	result = TRUE;
	return result;
}


static gboolean vala_genie_scanner_skip_tabs (ValaGenieScanner* self) {
	gboolean result;
	gboolean found;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (self->priv->current < self->priv->end) {
			_tmp0_ = self->priv->current[0] == '\t';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		self->priv->current++;
		self->priv->column++;
		found = TRUE;
	}
	result = found;
	return result;
}


static void vala_genie_scanner_skip_space_tabs (ValaGenieScanner* self) {
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		if (vala_genie_scanner_whitespace (self)) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = vala_genie_scanner_skip_tabs (self);
		}
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = vala_genie_scanner_comment (self, FALSE);
		}
		if (!_tmp0_) {
			break;
		}
	}
}


static void vala_genie_scanner_space (ValaGenieScanner* self) {
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (vala_genie_scanner_whitespace (self)) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = vala_genie_scanner_comment (self, FALSE);
		}
		if (!_tmp0_) {
			break;
		}
	}
}


void vala_genie_scanner_parse_file_comments (ValaGenieScanner* self) {
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (vala_genie_scanner_whitespace (self)) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = vala_genie_scanner_comment (self, TRUE);
		}
		if (!_tmp0_) {
			break;
		}
	}
}


static void vala_genie_scanner_push_comment (ValaGenieScanner* self, const char* comment_item, ValaSourceReference* source_reference, gboolean file_comment) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (comment_item != NULL);
	g_return_if_fail (source_reference != NULL);
	if (g_utf8_get_char (g_utf8_offset_to_pointer (comment_item, 0)) == '*') {
		ValaComment* _tmp0_;
		self->priv->_comment = (_tmp0_ = vala_comment_new (comment_item, source_reference), _vala_comment_unref0 (self->priv->_comment), _tmp0_);
	}
	if (file_comment) {
		ValaComment* _tmp1_;
		ValaComment* _tmp2_;
		vala_source_file_add_comment (self->priv->_source_file, _tmp1_ = vala_comment_new (comment_item, source_reference));
		_vala_comment_unref0 (_tmp1_);
		self->priv->_comment = (_tmp2_ = NULL, _vala_comment_unref0 (self->priv->_comment), _tmp2_);
	}
}


static gpointer _vala_comment_ref0 (gpointer self) {
	return self ? vala_comment_ref (self) : NULL;
}


ValaComment* vala_genie_scanner_pop_comment (ValaGenieScanner* self) {
	ValaComment* result;
	ValaComment* comment;
	ValaComment* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_comment == NULL) {
		result = NULL;
		return result;
	}
	comment = _vala_comment_ref0 (self->priv->_comment);
	self->priv->_comment = (_tmp0_ = NULL, _vala_comment_unref0 (self->priv->_comment), _tmp0_);
	result = comment;
	return result;
}


static gboolean vala_genie_scanner_pp_whitespace (ValaGenieScanner* self) {
	gboolean result;
	gboolean found;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		if (self->priv->current < self->priv->end) {
			_tmp1_ = g_ascii_isspace (self->priv->current[0]);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			_tmp0_ = self->priv->current[0] != '\n';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		found = TRUE;
		self->priv->current++;
		self->priv->column++;
	}
	result = found;
	return result;
}


static void vala_genie_scanner_pp_directive (ValaGenieScanner* self) {
	gchar* begin;
	gint len;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	self->priv->current++;
	self->priv->column++;
	vala_genie_scanner_pp_whitespace (self);
	begin = self->priv->current;
	len = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (self->priv->current < self->priv->end) {
			_tmp0_ = g_ascii_isalnum (self->priv->current[0]);
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		self->priv->current++;
		self->priv->column++;
		len++;
	}
	if (len == 2) {
		_tmp1_ = vala_genie_scanner_matches (self, begin, "if");
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		vala_genie_scanner_parse_pp_if (self);
	} else {
		gboolean _tmp2_ = FALSE;
		if (len == 4) {
			_tmp2_ = vala_genie_scanner_matches (self, begin, "elif");
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			vala_genie_scanner_parse_pp_elif (self);
		} else {
			gboolean _tmp3_ = FALSE;
			if (len == 4) {
				_tmp3_ = vala_genie_scanner_matches (self, begin, "else");
			} else {
				_tmp3_ = FALSE;
			}
			if (_tmp3_) {
				vala_genie_scanner_parse_pp_else (self);
			} else {
				gboolean _tmp4_ = FALSE;
				if (len == 5) {
					_tmp4_ = vala_genie_scanner_matches (self, begin, "endif");
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					vala_genie_scanner_parse_pp_endif (self);
				} else {
					ValaSourceReference* _tmp5_;
					vala_report_error (_tmp5_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column - len, self->priv->line, self->priv->column), "syntax error, invalid preprocessing directive");
					_vala_source_reference_unref0 (_tmp5_);
				}
			}
		}
	}
	if (self->priv->conditional_stack_length1 > 0) {
		_tmp6_ = self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].skip_section;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		gboolean bol;
		bol = FALSE;
		while (TRUE) {
			gboolean _tmp7_ = FALSE;
			if (!(self->priv->current < self->priv->end)) {
				break;
			}
			if (bol) {
				_tmp7_ = self->priv->current[0] == '#';
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				self->priv->current = self->priv->current - (self->priv->column - 1);
				self->priv->column = 1;
				return;
			}
			if (self->priv->current[0] == '\n') {
				self->priv->line++;
				self->priv->column = 0;
				bol = TRUE;
			} else {
				if (!g_ascii_isspace (self->priv->current[0])) {
					bol = FALSE;
				}
			}
			self->priv->current++;
			self->priv->column++;
		}
	}
}


static void vala_genie_scanner_pp_eol (ValaGenieScanner* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	vala_genie_scanner_pp_whitespace (self);
	if (self->priv->current >= self->priv->end) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->current[0] != '\n';
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp1_;
		vala_report_error (_tmp1_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column), "syntax error, expected newline");
		_vala_source_reference_unref0 (_tmp1_);
	}
}


static void _vala_array_add3 (ValaGenieScannerConditional** array, int* length, int* size, const ValaGenieScannerConditional* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerConditional, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void vala_genie_scanner_parse_pp_if (ValaGenieScanner* self) {
	gboolean condition;
	ValaGenieScannerConditional _tmp1_;
	ValaGenieScannerConditional _tmp0_ = {0};
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	vala_genie_scanner_pp_whitespace (self);
	condition = vala_genie_scanner_parse_pp_expression (self);
	vala_genie_scanner_pp_eol (self);
	_vala_array_add3 (&self->priv->conditional_stack, &self->priv->conditional_stack_length1, &self->priv->conditional_stack_size, (_tmp1_ = (memset (&_tmp0_, 0, sizeof (ValaGenieScannerConditional)), _tmp0_), &_tmp1_));
	if (condition) {
		gboolean _tmp3_ = FALSE;
		if (self->priv->conditional_stack_length1 == 1) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = !self->priv->conditional_stack[self->priv->conditional_stack_length1 - 2].skip_section;
		}
		_tmp2_ = _tmp3_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].matched = TRUE;
	} else {
		self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].skip_section = TRUE;
	}
}


static void vala_genie_scanner_parse_pp_elif (ValaGenieScanner* self) {
	gboolean condition;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	vala_genie_scanner_pp_whitespace (self);
	condition = vala_genie_scanner_parse_pp_expression (self);
	vala_genie_scanner_pp_eol (self);
	if (self->priv->conditional_stack_length1 == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].else_found;
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp1_;
		vala_report_error (_tmp1_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column), "syntax error, unexpected #elif");
		_vala_source_reference_unref0 (_tmp1_);
		return;
	}
	if (condition) {
		_tmp3_ = !self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].matched;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gboolean _tmp4_ = FALSE;
		if (self->priv->conditional_stack_length1 == 1) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = !self->priv->conditional_stack[self->priv->conditional_stack_length1 - 2].skip_section;
		}
		_tmp2_ = _tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].matched = TRUE;
		self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].skip_section = FALSE;
	} else {
		self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].skip_section = TRUE;
	}
}


static void vala_genie_scanner_parse_pp_else (ValaGenieScanner* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	vala_genie_scanner_pp_eol (self);
	if (self->priv->conditional_stack_length1 == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].else_found;
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp1_;
		vala_report_error (_tmp1_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column), "syntax error, unexpected #else");
		_vala_source_reference_unref0 (_tmp1_);
		return;
	}
	if (!self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].matched) {
		gboolean _tmp3_ = FALSE;
		if (self->priv->conditional_stack_length1 == 1) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = !self->priv->conditional_stack[self->priv->conditional_stack_length1 - 2].skip_section;
		}
		_tmp2_ = _tmp3_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].matched = TRUE;
		self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].skip_section = FALSE;
	} else {
		self->priv->conditional_stack[self->priv->conditional_stack_length1 - 1].skip_section = TRUE;
	}
}


static void vala_genie_scanner_parse_pp_endif (ValaGenieScanner* self) {
	g_return_if_fail (self != NULL);
	vala_genie_scanner_pp_eol (self);
	if (self->priv->conditional_stack_length1 == 0) {
		ValaSourceReference* _tmp0_;
		vala_report_error (_tmp0_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column), "syntax error, unexpected #endif");
		_vala_source_reference_unref0 (_tmp0_);
		return;
	}
	self->priv->conditional_stack_length1--;
}


static gboolean vala_genie_scanner_parse_pp_symbol (ValaGenieScanner* self) {
	gboolean result;
	gint len;
	char* identifier;
	gboolean defined = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	len = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (self->priv->current < self->priv->end) {
			_tmp0_ = vala_genie_scanner_is_ident_char (self, self->priv->current[0]);
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		self->priv->current++;
		self->priv->column++;
		len++;
	}
	if (len == 0) {
		ValaSourceReference* _tmp1_;
		vala_report_error (_tmp1_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column), "syntax error, expected identifier");
		_vala_source_reference_unref0 (_tmp1_);
		result = FALSE;
		return result;
	}
	identifier = g_strndup ((const char*) (self->priv->current - len), (gsize) len);
	if (_vala_strcmp0 (identifier, "true") == 0) {
		defined = TRUE;
	} else {
		if (_vala_strcmp0 (identifier, "false") == 0) {
			defined = FALSE;
		} else {
			defined = vala_code_context_is_defined (vala_source_file_get_context (self->priv->_source_file), identifier);
		}
	}
	result = defined;
	_g_free0 (identifier);
	return result;
}


static gboolean vala_genie_scanner_parse_pp_primary_expression (ValaGenieScanner* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->current >= self->priv->end) {
		ValaSourceReference* _tmp0_;
		vala_report_error (_tmp0_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column), "syntax error, expected identifier");
		_vala_source_reference_unref0 (_tmp0_);
	} else {
		if (vala_genie_scanner_is_ident_char (self, self->priv->current[0])) {
			result = vala_genie_scanner_parse_pp_symbol (self);
			return result;
		} else {
			if (self->priv->current[0] == '(') {
				gboolean _result_;
				gboolean _tmp1_ = FALSE;
				self->priv->current++;
				self->priv->column++;
				vala_genie_scanner_pp_whitespace (self);
				_result_ = vala_genie_scanner_parse_pp_expression (self);
				vala_genie_scanner_pp_whitespace (self);
				if (self->priv->current < self->priv->end) {
					_tmp1_ = self->priv->current[0] == ')';
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					self->priv->current++;
					self->priv->column++;
				} else {
					ValaSourceReference* _tmp2_;
					vala_report_error (_tmp2_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column), "syntax error, expected `)'");
					_vala_source_reference_unref0 (_tmp2_);
				}
				result = _result_;
				return result;
			} else {
				ValaSourceReference* _tmp3_;
				vala_report_error (_tmp3_ = vala_source_reference_new (self->priv->_source_file, self->priv->line, self->priv->column, self->priv->line, self->priv->column), "syntax error, expected identifier");
				_vala_source_reference_unref0 (_tmp3_);
			}
		}
	}
	result = FALSE;
	return result;
}


static gboolean vala_genie_scanner_parse_pp_unary_expression (ValaGenieScanner* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->current < self->priv->end) {
		_tmp0_ = self->priv->current[0] == '!';
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		self->priv->current++;
		self->priv->column++;
		vala_genie_scanner_pp_whitespace (self);
		result = !vala_genie_scanner_parse_pp_unary_expression (self);
		return result;
	}
	result = vala_genie_scanner_parse_pp_primary_expression (self);
	return result;
}


static gboolean vala_genie_scanner_parse_pp_equality_expression (ValaGenieScanner* self) {
	gboolean result;
	gboolean left;
	g_return_val_if_fail (self != NULL, FALSE);
	left = vala_genie_scanner_parse_pp_unary_expression (self);
	vala_genie_scanner_pp_whitespace (self);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		if (self->priv->current < (self->priv->end - 1)) {
			_tmp1_ = self->priv->current[0] == '=';
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			_tmp0_ = self->priv->current[1] == '=';
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			gboolean right;
			self->priv->current = self->priv->current + 2;
			self->priv->column = self->priv->column + 2;
			vala_genie_scanner_pp_whitespace (self);
			right = vala_genie_scanner_parse_pp_unary_expression (self);
			left = left == right;
		} else {
			gboolean _tmp2_ = FALSE;
			gboolean _tmp3_ = FALSE;
			if (self->priv->current < (self->priv->end - 1)) {
				_tmp3_ = self->priv->current[0] == '!';
			} else {
				_tmp3_ = FALSE;
			}
			if (_tmp3_) {
				_tmp2_ = self->priv->current[1] == '=';
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				gboolean right;
				self->priv->current = self->priv->current + 2;
				self->priv->column = self->priv->column + 2;
				vala_genie_scanner_pp_whitespace (self);
				right = vala_genie_scanner_parse_pp_unary_expression (self);
				left = left != right;
			} else {
				break;
			}
		}
	}
	result = left;
	return result;
}


static gboolean vala_genie_scanner_parse_pp_and_expression (ValaGenieScanner* self) {
	gboolean result;
	gboolean left;
	g_return_val_if_fail (self != NULL, FALSE);
	left = vala_genie_scanner_parse_pp_equality_expression (self);
	vala_genie_scanner_pp_whitespace (self);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gboolean right;
		gboolean _tmp2_ = FALSE;
		if (self->priv->current < (self->priv->end - 1)) {
			_tmp1_ = self->priv->current[0] == '&';
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			_tmp0_ = self->priv->current[1] == '&';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		self->priv->current = self->priv->current + 2;
		self->priv->column = self->priv->column + 2;
		vala_genie_scanner_pp_whitespace (self);
		right = vala_genie_scanner_parse_pp_equality_expression (self);
		if (left) {
			_tmp2_ = right;
		} else {
			_tmp2_ = FALSE;
		}
		left = _tmp2_;
	}
	result = left;
	return result;
}


static gboolean vala_genie_scanner_parse_pp_or_expression (ValaGenieScanner* self) {
	gboolean result;
	gboolean left;
	g_return_val_if_fail (self != NULL, FALSE);
	left = vala_genie_scanner_parse_pp_and_expression (self);
	vala_genie_scanner_pp_whitespace (self);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gboolean right;
		gboolean _tmp2_ = FALSE;
		if (self->priv->current < (self->priv->end - 1)) {
			_tmp1_ = self->priv->current[0] == '|';
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			_tmp0_ = self->priv->current[1] == '|';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		self->priv->current = self->priv->current + 2;
		self->priv->column = self->priv->column + 2;
		vala_genie_scanner_pp_whitespace (self);
		right = vala_genie_scanner_parse_pp_and_expression (self);
		if (left) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = right;
		}
		left = _tmp2_;
	}
	result = left;
	return result;
}


static gboolean vala_genie_scanner_parse_pp_expression (ValaGenieScanner* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_genie_scanner_parse_pp_or_expression (self);
	return result;
}


ValaSourceFile* vala_genie_scanner_get_source_file (ValaGenieScanner* self) {
	ValaSourceFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_source_file;
	return result;
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static void vala_genie_scanner_set_source_file (ValaGenieScanner* self, ValaSourceFile* value) {
	ValaSourceFile* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_source_file = (_tmp0_ = _vala_source_file_ref0 (value), _vala_source_file_unref0 (self->priv->_source_file), _tmp0_);
}


gint vala_genie_scanner_get_indent_spaces (ValaGenieScanner* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_indent_spaces;
	return result;
}


void vala_genie_scanner_set_indent_spaces (ValaGenieScanner* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_indent_spaces = value;
}


static ValaGenieScannerConditional* vala_genie_scanner_conditional_dup (const ValaGenieScannerConditional* self) {
	ValaGenieScannerConditional* dup;
	dup = g_new0 (ValaGenieScannerConditional, 1);
	memcpy (dup, self, sizeof (ValaGenieScannerConditional));
	return dup;
}


static void vala_genie_scanner_conditional_free (ValaGenieScannerConditional* self) {
	g_free (self);
}


static GType vala_genie_scanner_conditional_get_type (void) {
	static GType vala_genie_scanner_conditional_type_id = 0;
	if (vala_genie_scanner_conditional_type_id == 0) {
		vala_genie_scanner_conditional_type_id = g_boxed_type_register_static ("ValaGenieScannerConditional", (GBoxedCopyFunc) vala_genie_scanner_conditional_dup, (GBoxedFreeFunc) vala_genie_scanner_conditional_free);
	}
	return vala_genie_scanner_conditional_type_id;
}


static void vala_genie_value_scanner_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_genie_value_scanner_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_genie_scanner_unref (value->data[0].v_pointer);
	}
}


static void vala_genie_value_scanner_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_genie_scanner_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_genie_value_scanner_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_genie_value_scanner_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaGenieScanner* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_genie_scanner_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_genie_value_scanner_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaGenieScanner** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_genie_scanner_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_genie_param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaGenieParamSpecScanner* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GENIE_TYPE_SCANNER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_genie_value_get_scanner (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GENIE_TYPE_SCANNER), NULL);
	return value->data[0].v_pointer;
}


void vala_genie_value_set_scanner (GValue* value, gpointer v_object) {
	ValaGenieScanner* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GENIE_TYPE_SCANNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GENIE_TYPE_SCANNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_genie_scanner_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_genie_scanner_unref (old);
	}
}


static void vala_genie_scanner_class_init (ValaGenieScannerClass * klass) {
	vala_genie_scanner_parent_class = g_type_class_peek_parent (klass);
	VALA_GENIE_SCANNER_CLASS (klass)->finalize = vala_genie_scanner_finalize;
	g_type_class_add_private (klass, sizeof (ValaGenieScannerPrivate));
}


static void vala_genie_scanner_instance_init (ValaGenieScanner * self) {
	self->priv = VALA_GENIE_SCANNER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void vala_genie_scanner_finalize (ValaGenieScanner* obj) {
	ValaGenieScanner * self;
	self = VALA_GENIE_SCANNER (obj);
	_vala_source_file_unref0 (self->priv->_source_file);
	_vala_comment_unref0 (self->priv->_comment);
	self->priv->conditional_stack = (g_free (self->priv->conditional_stack), NULL);
}


GType vala_genie_scanner_get_type (void) {
	static GType vala_genie_scanner_type_id = 0;
	if (vala_genie_scanner_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { vala_genie_value_scanner_init, vala_genie_value_scanner_free_value, vala_genie_value_scanner_copy_value, vala_genie_value_scanner_peek_pointer, "p", vala_genie_value_scanner_collect_value, "p", vala_genie_value_scanner_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaGenieScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_genie_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGenieScanner), 0, (GInstanceInitFunc) vala_genie_scanner_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		vala_genie_scanner_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGenieScanner", &g_define_type_info, &g_define_type_fundamental_info, 0);
	}
	return vala_genie_scanner_type_id;
}


gpointer vala_genie_scanner_ref (gpointer instance) {
	ValaGenieScanner* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_genie_scanner_unref (gpointer instance) {
	ValaGenieScanner* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GENIE_SCANNER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




