#!/usr/bin/python
# -*- coding: utf-8 -*-
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published
## by the Free Software Foundation; version 2 and higer.
##
## Guseynov Alexey (kibergus bark-bark gmail.com) 2010

import pexpect
import time
from subprocess import *
import sys
import gsmdecode
import re
import fcntl
import os
import stat
import dbus
import gobject

# Needed for correct output of utf-8 symbols.
sys.stdout=file("/dev/stdout", "wb")

def check_number(number):
	if number == "":
		return False
	for s in number :
		if not (s in ["1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "+", "*", "#"]) :
			return False
	return True

if len(sys.argv) == 1:
    print "Usage:\nussdquery.py <ussd number> [options]\nussdquery.py interactive [options]\n"+\
"Options:\n-l language. Allowed languages: German, English, Italian, French, Spanish, Dutch, Swedish, Danish, Portuguese, Finnish, Norwegian, Greek, Turkish, Reserved1, Reserved2, Unspecified\n"+\
"-r retry count. 0 default. Use -1 for infinite.\n-f If specified, errors, which occur on last query are threated as fatal\n"+\
"-t timeout in seconds. Default 30. Timeout is considered to be critical error because you can't be sure answer for what request was returned.\n"+\
"-d delimeter. Default is '\\n> \n'"+\
"-m gain modem lock imidiately '"+\
"-s show GUI message box on last reply"+\
"For USSD menu navigation divide USSD number via spacebars for every next menu selection. Type exit in interactive mode to exit."
    sys.exit()

lockf = None

def gain_lock ():
	global lockf
	lockf = open("/tmp/ussdquery.lock", 'a')
	fcntl.flock(lockf,fcntl.LOCK_EX)
	try:
		os.chmod("/tmp/ussdquery.lock", stat.S_IRUSR | stat.S_IWUSR | stat.S_IRGRP | stat.S_IWGRP | stat.S_IROTH | stat.S_IWOTH)
	except:
		None

def release_lock ():
	global lockf
	fcntl.flock(lockf,fcntl.LOCK_UN)
	lockf.close()

def init_modem(modem):
	# We have only one modem, simultaneous acces wouldn't bring anything good
	gain_lock()
	response = ""
	init_retry = 5
	while response != "OK" and init_retry > 0 :
		if modem == None :
			# OK response should be recieved shortly
			modem = pexpect.spawn('pnatd', [], 2)
		try :
			modem.send('at\r');
			# Read our "at" command
			modem.readline();
			# Read OK response
			response = modem.readline().strip()
		except pexpect.TIMEOUT:
			modem.kill(9)
			modem = None
			response = ""
		if response != "OK" :
			time.sleep(0.5)
			init_retry -= 1
		else:
			try:
				# Switch output encoding to GSM default encoding
				modem.send('at+cscs="GSM"\r');
				# Read our command
				modem.readline();
				# Read OK response
				response = modem.readline().strip()
			except pexpect.TIMEOUT:
				modem.kill(9)
				modem = None
				response = ""
			
		if response != "OK" :
			time.sleep(0.5)
			init_retry -= 1

	if response != "OK" :
		print >> sys.stderr, "Couldn't init modem."
		if modem != None:
			modem.kill(9)
		release_lock()
		sys.exit (-1)

	modem.timeout = timeout
	return modem

def close_modem (modem):
	modem.sendeof()
	modem.kill(9)
	release_lock()

retry = 0
allow_last_error = True
delimiter = "\n> "
language = 15
timeout = 30
show_qussd = False

if sys.argv[1] == "interactive":
	number = "interactive"
else:
	number = sys.argv[1].split(" ")
	for n in number: 
		if not check_number(n):
			print >> sys.stderr, "Syntax error in USSD number."
			sys.exit(-7)

modem = None

# Parsing command line options
arg = 1
state = "arg"
while arg < len(sys.argv)-1:
	arg += 1
	if state == "arg":
		if sys.argv[arg] == "-l":
			state = "lang"
			continue
		if sys.argv[arg] == "-r":
			state = "retry"
			continue
		if sys.argv[arg] == "-t":
			state = "timeout"
			continue
		if sys.argv[arg] == "-d":
			state = "delim"
			continue
		if sys.argv[arg] == "-f":
			allow_last_error = False
			continue
		if sys.argv[arg] == "-s":
			show_qussd = True
			continue
		if sys.argv[arg] == "-m":
			modem = init_modem(modem)
			continue

	if state == "lang":
		if sys.argv[arg] == "German":
			language = 0
		elif sys.argv[arg] == "English":
			language = 1
		elif sys.argv[arg] == "Italian":
			language = 2
		elif sys.argv[arg] == "French":
			language = 3
		elif sys.argv[arg] == "Spanish":
			language = 4
		elif sys.argv[arg] == "Dutch":
			language = 5
		elif sys.argv[arg] == "Swedish":
			language = 6
		elif sys.argv[arg] == "Danish":
			language = 7
		elif sys.argv[arg] == "Portuguese":
			language = 8
		elif sys.argv[arg] == "Finnish":
			language = 9
		elif sys.argv[arg] == "Norwegian":
			language = 10
		elif sys.argv[arg] == "Greek":
			language = 11
		elif sys.argv[arg] == "Turkish":
			language = 12
		elif sys.argv[arg] == "Reserved1":
			language = 13
		elif sys.argv[arg] == "Reserved2":
			language = 14
		elif sys.argv[arg] == "Unspecified":
			language = 15
		else:
			print >> sys.stderr, "Language unknown, falling back to unspecified."
		state = "arg"
		continue

	if state == "delim":
		if number == "interactive":
			delimiter = sys.argv[arg]
		else:
			print >> sys.stderr, "Delimiter is only supported in interactive mode."
		state = "arg"
		continue

	if state == "retry":
		if number == "interactive":
			print >> sys.stderr, "Retry is only supported in normal mode."
		else:
			try:
				retry = int(sys.argv[arg])
				if retry < -1:
					print >> sys.stderr, "Number of allowed errors must be >= -1. -1 assumed."
				retry = -1
			except:
				print >> sys.stderr, "Retry must be an integer."
				sys.exit(-5)
		state = "arg"
		continue
	if state == "timeout":
		try:
			timeout = int(sys.argv[arg])
		except:
			print >> sys.stderr, "Timeout must be an integer."
			sys.exit(-5)
		state = "arg"
		continue

	print >> sys.stderr, "Unrecogmized argument: "+sys.argv[arg]
	
if retry == -1:
	retry_forever = True
else:
	retry_forever = False

bus = dbus.SystemBus()
ussdd = bus.get_object("su.kibergus.ussdd", "/su/kibergus/ussdd")
ussdd_int = dbus.Interface(ussdd, "su.kibergus.ussdd")

# Now we are ready to send commands

stage = 0
if number == "interactive":
	sys.stdout.write(delimiter)
	sys.stdout.flush()
while number == "interactive" or stage < len(number):
	if number == "interactive":
		cnumber = sys.stdin.readline().strip()
		if cnumber == "exit":
			if modem != None:
				close_modem (modem)
			sys.exit (0)
		if not check_number (cnumber):
			sys.stdout.write ("Syntax error in USSD number"+delimiter)
			sys.stdout.flush()
			continue
	else:
		cnumber = number[stage]

	if modem == None:
		modem = init_modem(modem)

	if retry == -1 and not retry_forever:
		print >> sys.stderr, "Retry limit is over. Giving up."
		break

	try :
		if number != "interactive" and not show_qussd or stage != len(number)-1:
			ussdd_int.skip_next()

		modem.send('at+cusd=1,"'+cnumber+'",'+str(language)+'\r')
		# Read our query echoed back
		modem.readline()

		#Read and parse reply
		replystring = modem.readline().decode('string_escape')
		# This will read out unneeded info from modem
		modem.readline()
		modem.readline()
	except pexpect.TIMEOUT:
		print >> sys.stderr, "Timeout. Modem didn't reply."
		close_modem (modem)
		ussdd_int.show_next()
		sys.exit (-2)

	if replystring.strip() == "ERROR" :
		retry -= 1
		print >> sys.stderr, "Modem returned ERROR. Query not executed."
		ussdd_int.show_next()
		continue

	try:
		reresult = re.match("(?s)^\\+CUSD: (\\d+),\"(.*)\",(\\d+)$", replystring.strip())

		# 0 no further user action required (network initiated USSD-Notify, or no further information needed after mobile initiated operation)
		# 1 further user action required (network initiated USSD-Request, or further information needed after mobile initiated operation)
		# 2 USSD terminated by network
		# 3 other local client has responded
		# 4 operation not supported
		# 5 network time out
		reply_status=reresult.group(1)
		reply = reresult.group(2)
		# See GSM 07.07 and GSM 03.38
		encoding = reresult.group(3)
	except:
		retry -= 1
		print >> sys.stderr, "Couldn't parse modem answer: "+replystring
		continue

	if reply_status == 0:
		# May be somebody else needs it
		close_modem(modem)
		modem = None
	elif reply_status == 2:
		print >> sys.stderr, "USSD terminated by network."
        elif reply_status == 3:
                print >> sys.stderr, "Error: other local client has responded."
        elif reply_status == 4:
                print >> sys.stderr, "Operation not supported."
        elif reply_status == 5:
                print >> sys.stderr, "Network time out."

	# Decoding ansver
	reply = gsmdecode.decode(reply, int(encoding))

	if number == "interactive":
		# prints line feed
		sys.stdout.write(reply+delimiter)
		sys.stdout.flush()
	else:
		if stage == len(number)-1:
			print reply
	stage += 1
	if not allow_last_error and namber != "interactive" and stage == len(number) - 1:
		retry = 0

if modem != None:
	close_modem (modem)
