#!/usr/bin/python
# -*- coding: utf-8 -*-
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published
## by the Free Software Foundation; version 2 and higer.
##
## Guseynov Alexey (kibergus bark-bark gmail.com) 2010

import pexpect
import time
from subprocess import *
import sys
import gsmdecode
import re
import fcntl

if len(sys.argv) != 2 and len(sys.argv) != 3:
    print "Usage: ussdquery.py <ussd number> [<language>]\nAllowed languages: German, English, Italian, French, Spanish, Dutch, Swedish, Danish, Portuguese, Finnish, Norwegian, Greek, Turkish, Reserved1, Reserved2, Unspecified"
    sys.exit()

language = 15
if len(sys.argv) == 3:
	if sys.argv[2] == "German":
		language = 0
	elif sys.argv[2] == "English":
		language = 1
	elif sys.argv[2] == "Italian":
		language = 2
	elif sys.argv[2] == "French":
		language = 3
	elif sys.argv[2] == "Spanish":
		language = 4
	elif sys.argv[2] == "Dutch":
		language = 5
	elif sys.argv[2] == "Swedish":
		language = 6
	elif sys.argv[2] == "Danish":
		language = 7
	elif sys.argv[2] == "Portuguese":
		language = 8
	elif sys.argv[2] == "Finnish":
		language = 9
	elif sys.argv[2] == "Norwegian":
		language = 10
	elif sys.argv[2] == "Greek":
		language = 11
	elif sys.argv[2] == "Turkish":
		language = 12
	elif sys.argv[2] == "Reserved1":
		language = 13
	elif sys.argv[2] == "Reserved2":
		language = 14
	elif sys.argv[2] == "Unspecified":
		language = 15
	else:
		print >> sys.stderr, "Language unknown, falling back to unspecified."

# We have only one modem, simultaneous acces wouldn't bring anything good
lockf = open("/tmp/ussdquery.lock", 'a')
fcntl.flock(lockf,fcntl.LOCK_EX)

# Operations should timeout in 30 seconds.
# I'm not shure, that readline uses timeouts
child = None
response = ""
retry = 5
while response != "OK" and retry > 0 :
	if child == None :
		# OK response should be recieved shortly
		child = pexpect.spawn('pnatd', [], 2)
	try :
		child.send('at\r');
		# Read our "at" command
		child.readline();
		# Read OK response
		response = child.readline().strip()
	except pexpect.TIMEOUT:
		child.kill(9)
		child = None
		response = ""
	if response != "OK" :
		time.sleep(0.5)
		retry -= 1

if response != "OK" :
	print >> sys.stderr, "Couldn't init modem."
	if child != None:
		child.kill(9)
        fcntl.flock(lockf,fcntl.LOCK_UN)
        lockf.close()
	sys.exit (-1)

child.timeout = 30

try :
	child.send('at+cusd=1,"'+(sys.argv[1])+'",'+str(language)+'\r')
	# Read our query echoed back
	child.readline()

	#Read and parse reply
	replystring = child.readline().decode('string_escape')
except pexpect.TIMEOUT:
	print >> sys.stderr, "Timeout. Modem didn't reply."
	child.kill(9)
        fcntl.flock(lockf,fcntl.LOCK_UN)
        lockf.close()
	sys.exit (-2)

child.sendeof()
fcntl.flock(lockf,fcntl.LOCK_UN)
lockf.close()

#replystring = "+CUSD: 0,\"OCTATOK 165.65 p.\n 3BOHu 333! HOBbIu PA3DEL: ХuT-nAPAD MY3bIKu (3p. MuHYTA)\",1"

if replystring.strip() == "ERROR" :
	print >> sys.stderr, "Modem returned ERROR. Query not executed."
	sys.exit (-3)

try:
	reresult = re.match("(?s)^\\+CUSD: \\d+,\"(.*)\",(\\d+)$", replystring.strip())
	reply = reresult.group(1)
	encoding = reresult.group(2)
except:
	print >> sys.stderr, "Couldn't parse modem answer."
	sys.exit (-4)

# Decoding ansver
reply = gsmdecode.decode(reply, int(encoding))

print reply

