import QtQuick 1.1
import org.maemo.fremantle 1.0


Sheet
{
    id: manuallyDetailsSheet

    function reset()
    {
        userAgentField.text = ""
    }

    rejectButtonText: "Cancel"
    acceptButtonText: "OK"
    onAccepted:
    {
        uachanger.agent = userAgentField.text
        uachanger.currentAgent = userAgentField.text
        uachanger.restartBrowserUI()
        uachanger.currentAgentChanged(userAgentField.text)
        reset()
    }
    onRejected: reset()

    content: Rectangle
    {
        anchors.fill: parent
        width: parent.width
        height: parent.height
        color: "#E0E1E2"
        TextField
        {
            id: userAgentField
            placeholderText: "User agent"
            width: parent.width
        }
    }
}
