import gtk
import os,dbus
import hildondesktop
import cairo
import gobject
import pango
import commands
import traceback
import time
supports_alpha = False

#f = open("/home/user/MyDocs/.documents/tracker-applet-log.txt", 'w' )
#f.write("Log started:"+str(time.time())+"\n")
#f.close()

#max_hits=10
#offset=0
#text="jpg"
#service="Images"

#bus = dbus.SessionBus()
#obj = bus.get_object('org.freedesktop.Tracker','/org/freedesktop/Tracker/Search')		
#search_iface = dbus.Interface(obj, 'org.freedesktop.Tracker.Search')
#returnedfiles = search_iface.Text(1,service,text,offset,max_hits)
#if len(returnedfiles) > 0:
#	for returnitem in returnedfiles:
#		print returnitem
		


class IPPlugin(hildondesktop.HomeItem):
	def videoClicked(self, widget, data=None):
		self.removeResults()
		
	def removeResults(self):
		if self.resutsShown:
			self.vbox.remove(self.resultbox)
			self.resutsShown=False
		self.set_size_request(340, 140)
		
	def clicked(self, widget, data=None):
		self.label2.set_text("clicked")
		self.removeResults()
		self.createResults()		
		self.set_size_request(340, 240)
		self.big=True
		
	def fileClicked(self, widget, data=None):
		self.label2.set_text("clicked")
		

	def createResults(self):
		
		eventbox = gtk.EventBox()
		#eventbox.set_events(gtk.gdk.BUTTON_PRESS_MASK)
		eventbox.connect("clicked", self.fileClicked, None)
				
		self.resultbox = gtk.VBox(False, 0)		
		self.result1 = gtk.Label("ok")
		self.result2 = gtk.Label(self.get_ip())
		self.resultbox.pack_start(self.result1)
		
		
		eventbox.add(self.result2)
		self.resultbox.pack_start(eventbox)
		
		#self.result2.connect("clicked", self.fileClicked, None)
		max_hits=5
		offset=0
		text="jpg"
		service="Images"
		bus = dbus.SessionBus()
		obj = bus.get_object('org.freedesktop.Tracker','/org/freedesktop/Tracker/Search')		
		search_iface = dbus.Interface(obj, 'org.freedesktop.Tracker.Search')
		returnedfiles = search_iface.Text(1,service,text,offset,max_hits)
		if len(returnedfiles) > 0:
			for returnitem in returnedfiles:
				self.result2.set_text(str(returnitem))
				
		self.resultbox.show()
		self.vbox.pack_start(self.resultbox)
		self.resutsShown=True
		self.show_all()

		
	def __init__(self):		
		hildondesktop.HomeItem.__init__(self)
		
 		#self.window.connect('key_press_event', self.on_key_press)
		#self.connect('key_press_event', self.on_key_press_event)
		#self.connect("expose-event", self.expose)
		#self.connect("screen-changed", self.screen_changed)

		self.set_resize_type(hildondesktop.HOME_ITEM_RESIZE_BOTH)
		self.set_size_request(340, 140)
		self.resutsShown=False
		self.searchText=" No TEXT"
		
		self.label = gtk.Label()
		self.label.set_use_markup(True)
		self.label.modify_font(pango.FontDescription ("Sans 12"))
		self.label.set_text(self.searchText)
		self.label.set_padding(15, 10)
		audioImage = gtk.Image()
		videoImage = gtk.Image()
		docImage = gtk.Image()
		imageImage = gtk.Image()
		mailImage = gtk.Image()
		
		#image.set_from_stock(gtk.STOCK_CDROM, gtk.ICON_SIZE_LARGE_TOOLBAR)
		audioImage.set_from_file("/usr/share/icons/hicolor/scalable/hildon/qgn_list_filesys_audio_fldr.png")
		videoImage.set_from_file("/usr/share/icons/hicolor/scalable/hildon/qgn_list_filesys_video_fldr.png")
		docImage.set_from_file("/usr/share/icons/hicolor/scalable/hildon/qgn_list_filesys_doc_fldr.png")
		imageImage.set_from_file("/usr/share/icons/hicolor/scalable/hildon/qgn_list_filesys_image_fldr.png")
		mailImage.set_from_file("/usr/share/icons/hicolor/scalable/hildon/qgn_list_gene_mail.png")
		
		
		
		self.audiobutton = gtk.Button()
		self.audiobutton.connect("clicked", self.clicked, None)
		self.audiobutton.set_image(audioImage)
		self.audiobutton.set_size_request(55, 25);

		self.videobutton = gtk.Button()
		self.videobutton.connect("clicked", self.videoClicked, None)
		self.videobutton.set_image(videoImage)
		self.videobutton.set_size_request(55, 25);
		
		self.documentbutton = gtk.Button()
		self.documentbutton.connect("clicked", self.clicked, None)
		self.documentbutton.set_image(docImage)
		self.documentbutton.set_size_request(55, 25);
		
		self.imagebutton = gtk.Button()
		self.imagebutton.connect("clicked", self.clicked, None)
		self.imagebutton.set_image(imageImage)
		self.imagebutton.set_size_request(55, 25);
		
		self.mailbutton = gtk.Button()
		self.mailbutton.connect("clicked", self.clicked, None)
		self.mailbutton.set_image(mailImage)
		self.mailbutton.set_size_request(55, 25);

		self.label2 = gtk.Label("Testing...")
		
		self.audioLabel = gtk.Label("12")
		self.videoLabel = gtk.Label("1")
		self.documentLabel = gtk.Label("1")
		self.imageLabel = gtk.Label("17")
		self.mailLabel = gtk.Label("129")
		
		self.audioLabel.modify_font(pango.FontDescription ("Sans 10"))
		self.videoLabel.modify_font(pango.FontDescription ("Sans 10"))
		self.documentLabel.modify_font(pango.FontDescription ("Sans 10"))
		self.imageLabel.modify_font(pango.FontDescription ("Sans 10"))
		self.mailLabel.modify_font(pango.FontDescription ("Sans 10"))
		
		
		self.vbox = gtk.VBox(False, 0)
		hbox = gtk.HBox(False, 0)
		hbox2 = gtk.HBox(False, 0)
		hbox.pack_start(self.audiobutton, True, True, 0)
		hbox.pack_start(self.videobutton, True, True, 0)
		hbox.pack_start(self.documentbutton, True, True, 0)
		hbox.pack_start(self.imagebutton, True, True, 0)
		#hbox.pack_start(self.mailbutton, True, True, 0)
		
		hbox2.pack_start(self.audioLabel, True, True, 0)
		hbox2.pack_start(self.videoLabel, True, True, 0)
		hbox2.pack_start(self.documentLabel, True, True, 0)
		hbox2.pack_start(self.imageLabel, True, True, 0)
		#hbox2.pack_start(self.mailLabel, True, True, 0)
		
		hbox.show()

		self.add(self.vbox)
		self.vbox.pack_start(hbox)		
		self.vbox.pack_start(hbox2)		
		self.vbox.show()		
		self.show_all()		
		self.get_categories()
		
		# set a timeout to change the images
		#self.timer = gobject.timeout_add(2000, self.update)
		#print "foreground timer", self.timer
		#Timers for until dbus signals have been set
		#self.connect ("background", self.background)
		#self.connect ("foreground", self.foreground)
		
		
	def background(self, widget, data=None):
		#Avoid refresh when applet is in background
		self.label.set_text("refreshing")
		if self.timer != None:
			gobject.source_remove(self.timer)
			self.timer = None

	def foreground(self, widget, data=None):
		self.label.set_text(self.get_ip())
		self.timer = gobject.timeout_add(2000, self.update)
		print "foreground timer", self.timer

	def unrealize(self, widget, date=None):
		# cancel timeout
		v = gobject.source_remove(self.timer)
		print "canceled homeip timeout:", v

	def update(self):
		self.label.set_text(self.get_ip())
	
	def get_categories(self):		
		devs = commands.getoutput("/usr/bin/tracker-stats")
		sdevs = devs.rsplit('\n')
		for stdev in sdevs:
			
			if 'Documents = ' in stdev:
				sdev = stdev.rsplit('=')
				self.documentLabel.set_text(sdev[1])
			
			elif 'Images = ' in stdev:
				sdev = stdev.rsplit('=')
				self.imageLabel.set_text(sdev[1])
			elif 'Videos = ' in stdev:
				sdev = stdev.rsplit('=')
				self.videoLabel.set_text(sdev[1])
			elif 'Music = ' in stdev:
				sdev = stdev.rsplit('=')
				self.audioLabel.set_text(sdev[1])
			
	def get_ip(self):
		#CPU Speed
		text = "No IP"
		devs = commands.getoutput("/sbin/ifconfig wlan0")
		sdevs = devs.rsplit('\n')
		for stdev in sdevs:
			#sdev = re.findall("(\S*)\s*", stdev)
			if 'inet addr:' in stdev:
				sdev = stdev.rsplit(':')
				sdev2 = sdev[1].rsplit(' ')
				text= "IP: " + sdev2[0]
		return text



					
def hd_plugin_get_objects():
	plugin = IPPlugin()
	return [plugin]