/**************************************************************************

    URPO

    Unix Remote Printing Operation
    Copyright (c) Arto Hyvättinen 2010

    This file is part of URPO.

    URPO is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    URPO is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.


**************************************************************************/

#ifndef URPOCONNECTIONSETTINGS_H
#define URPOCONNECTIONSETTINGS_H

#include "urpoconnection.h"

/*!  Connection information, support storing settings

  Setting are stored/loaded using QSettings

    @author Arto Hyvättinen
    @date 2010-06-11
    @version 1
  */
class UrpoConnectionSettings : public UrpoConnection
{
public:
    /*!
      @param organization Organization key for storing settings
      @param application Application key for storing settings
      */
    UrpoConnectionSettings(const QString organization = QString(), const QString application=QString());


    QString getHost() const;
    QString getIdentity() const;
    QString getUserid() const;

    void setHost(const QString &host);
    void setIdentity(const QString &password);
    void setUserid(const QString &userid);

    /*! Store settings via QSettings */
    void store() const;
    /*! Load settings via QSettings */
    void load();

private:
    QString host_;  /*! Host name or ip address */
    QString identity_;  /*! Identity (private key) file path */
    QString userid_; /*! Userid in remote host */

    bool storePassword_; /*! Allow to store password */

    QString organization_;  /*! Organization key storing settings */
    QString application_; /*! Application key storing settings */


};

#endif // URPOCONNECTIONSETTINGS_H
