/**************************************************************************

    URPO

    Unix Remote Printing Operation
    Copyright (c) Arto Hyvättinen 2010

    This file is part of URPO.

    URPO is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    URPO is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.


**************************************************************************/

#include "urpoconnectionsettings.h"
#include <QSettings>


UrpoConnectionSettings::UrpoConnectionSettings(const QString organization, const QString application)
{
    storePassword_ = false;
    organization_ = organization;
    application_ = application;
}

QString UrpoConnectionSettings::getHost() const
{
    return host_;
}

QString UrpoConnectionSettings::getIdentity() const
{
    return identity_;
}

QString UrpoConnectionSettings::getUserid() const
{
    return userid_;
}

void UrpoConnectionSettings::setHost(const QString &host)
{
    host_ = host;
}

void UrpoConnectionSettings::setIdentity(const QString &identity)
{
    identity_ = identity;
}

void UrpoConnectionSettings::setUserid(const QString &userid)
{
    userid_ = userid;
}

void UrpoConnectionSettings::store() const
{
    // Store settings using QSettings
    QSettings settings(organization_, application_);
    settings.setValue("host",host_);
    settings.setValue("userid",userid_);
    settings.setValue("identity",identity_);

}

void UrpoConnectionSettings::load()
{
    // Load settings using QSettings
    QSettings settings(organization_,application_);

    host_ = settings.value("host").toString();
    userid_ = settings.value("userid").toString();
    identity_ = settings.value("identity").toString();


}
